#!/bin/bash

CERT_PATH="/data/certs/mosquitto_user"
SITE="Kolin"
CN="127.0.0.1"

#mosquito

SUBJECT_CA="/C=SE/ST=Prague/L=Prague/O=mySCADA/OU=CA/CN="$CN
SUBJECT_SERVER="/C=SE/ST=Prague/L=Prague/O=mySCADA/OU=Server/CN="$CN
SUBJECT_CLIENT="/C=SE/ST=Prague/L=Prague/O=mySCADA/OU=Client"

mkdir -p $CERT_PATH
mkdir -p $CERT_PATH/ca
mkdir -p $CERT_PATH/broker
mkdir -p $CERT_PATH/client

echo $SUBJECT_CA
openssl req -x509 -nodes -sha256 -newkey rsa:2048 -subj $SUBJECT_CA -days 358000 -keyout $CERT_PATH/ca/ca.key -out $CERT_PATH/ca/ca.crt

echo $SUBJECT_SERVER
openssl req -nodes -sha256 -new -subj $SUBJECT_SERVER -keyout $CERT_PATH/broker/broker.key -out $CERT_PATH/broker/broker.csr
openssl x509 -req -sha256 -in $CERT_PATH/broker/broker.csr -CA $CERT_PATH/ca/ca.crt -CAkey $CERT_PATH/ca/ca.key -CAcreateserial -out $CERT_PATH/broker/broker.crt -days 358000


echo $SUBJECT_CLIENT
openssl req -new -nodes -sha256 -subj $SUBJECT_CLIENT -out $CERT_PATH/client/client.csr -keyout $CERT_PATH/client/client.key 
openssl x509 -req -sha256 -in $CERT_PATH/client/client.csr -CA $CERT_PATH/ca/ca.crt -CAkey $CERT_PATH/ca/ca.key -CAcreateserial -out $CERT_PATH/client/client.crt -days 358000

cp /etc/config_default/mosquitto2_cert.conf.template /data/conf/mosquitto2.conf

pm2 restart mosquitto2