#!/bin/bash

export HOME=/root
export NVM_DIR="$HOME/.nvm"
export DEBIAN_FRONTEND=noninteractive
export TERM=xterm
source "$NVM_DIR/nvm.sh"

#setting /etc/localtime 
TZNAME=$(cat /etc/timezone)
ZONEINFO="/usr/share/zoneinfo/$TZNAME"
if [ -f "$ZONEINFO" ]; then
  ln -sf "$ZONEINFO" /etc/localtime
fi

microsoft_azure="no"

if [[ $microsoft_azure == "yes" ]]; then
    mkdir /mnt/resource/blobfusetmp -p
    chown root:root /mnt/resource/blobfusetmp
    blobfuse /data --tmp-path=/mnt/resource/blobfusetmp  --config-file=/etc/fuse_connection.cfg -o attr_timeout=240 -o entry_timeout=240 -o negative_timeout=120
fi

#running on WSL
if grep -q WSL /proc/version; then
    #echo `hostname -I | cut -d ' ' -f1 `" host.docker.internal" >> /etc/hosts
    echo `route -n | awk '/^0.0.0.0/ {print $2}'`" host.docker.internal" >> /etc/hosts
fi
#nastavit cestu z lokalniho disku
#na linux hostu mount -m ==mkdir pouze vytvori adresar    
    sudo mount -m -t drvfs c:/ProgramData/DataTalk/conf /data/conf
    sudo mount -m -t drvfs c:/ProgramData/DataTalk/certs /data/certs
    sudo mount -m -t drvfs c:/ProgramData/DataTalk/lic /data/lic
    sudo mount -m -t drvfs c:/ProgramData/DataTalk/Backup /data/Backup
    sudo mount -m -t drvfs c:/ProgramData/DataTalk/dump /data/dump
    if [ -e "/data/conf/settings.json" ]; then
       install_path=`cat /data/conf/settings.json | jq -r '.install_path'`
       project_path=`cat /data/conf/settings.json | jq -r '.project_path'`
    else
       install_path="/opt/DataTalk/"
       project_path="/opt/DataTalk/"
    fi
    echo $install_path
    echo $project_path
    sudo mount -m -t drvfs $project_path/db /data/db
    sudo mount -m -t drvfs $project_path/userData /data/userData
    sudo mount -m -t drvfs $project_path/retentionData /data/retentionData
    sudo mount -m -t drvfs $project_path/projectData /data/projectData
    sudo mount -m -t drvfs $project_path/svgs /data/svgs


#sudo mkdir -p /data/conf
#sudo mkdir -p /data/db
#sudo mkdir -p /data/pictures
#sudo mkdir -p /data/certs
#sudo mkdir -p /data/svgs
#sudo mkdir -p /data/projectData
#sudo mkdir -p /data/userData
#sudo mkdir -p /data/lic

HOST_IP=`netstat -rn |grep -e '^0\.0\.0\.0' | awk '{print $2}'`
echo $HOST_IP > /var/run/host_ip
export HOST_IP=$HOST_IP

sudo mkdir -p /run/mosquitto
sudo mkdir /var/lib/nginx
sudo mkdir /var/log/nginx
sudo chown mosquitto:mosquitto /run/mosquitto

if [[ ! -f "/data/conf/nginx_port_http.conf" ]]
then
    echo "listen	80;" > /data/conf/nginx_port_http.conf
fi

if [[ ! -f "/data/conf/nginx_port_https.conf" ]]
then
    echo "listen	443 ssl http2;" > /data/conf/nginx_port_https.conf
fi

if [[ ! -f "/data/conf/mosquitto2.conf" ]]
then
    mv /etc/config_default/mosquitto2.conf.template /data/conf/mosquitto2.conf
fi

if [[ ! -f "/data/conf/nginx_ssl.conf" ]]
then
    mv /etc/config_default/nginx_ssl.conf.template /data/conf/nginx_ssl.conf
fi

#if [[ ! -f "/data/lic/*.lic" ]]
#then
    
#    cp /etc/config_default/*.lic /data/lic/
#fi


/usr/share/easy-rsa/generate.sh

/etc/init.d/ssh start

pm2 start /root/.pm2/ecosystem.config.js --output /dev/null --error /dev/null

if [[ -f "/opt/first_boot" ]]
then
    pm2 stop all
    pm2 start mongodb
    # restore Anume
    #mongorestore --host 127.0.0.1 --drop --tlsInsecure --port 27017 --ssl -sslCAFile /data/certs/mongod/ca/ca.crt --sslPEMKeyFile /data/certs/mongod/client/client.pem --nsInclude=1_project.project dump_file
    #
    /usr/local/bin/mongodb.init > /var/log/mongodb_init.log 2>&1
    rm /opt/first_boot
    pm2 restart all
fi

#sleep 3
#sudo pm2 restart ajaxHandler liveDBtoMQTT interfaceModule authModule aggregate

#/etc/init.d/nginx start
#/bin/mongod -f /etc/mongod.conf> /var/log/mongod &
#/sbin/mosquitto -c /etc/mosquitto/mosquitto.conf> /var/log/mosquitto/mosquitto &
#cd /opt/myscada/backend/ajaxHandler && bytenode ./main.jsc &

#RES=`pm2 jlist`
#if [[ $RES == "[]" ]]; then
#    pm2 restart /root/.pm2/ecosystem.config.js
#fi

while true
do
    if grep -q WSL /proc/version; then
	hwclock -s
    fi
    #sudo pm2 jlist > /data/pm2.temp && mv /data/pm2.temp /data/pm2.json
    sleep 5
done
