## Coverage
Apprise has been mentioned in:
- [Interviewed by Sai from Console](https://console.substack.com/p/console-139) (an Open Source Newsletter) - Jan 7th, 2023
- [VirtualizationHowto / Brandon Lee - Best Notification System for Home Servers with Apprise Push Alerts](https://www.youtube.com/watch?v=Cj7A46NuACA) (YouTube Video)- Jan 3rd, 2023
- [Self Hosted Podcast 86](https://selfhosted.show/86) - Dec 16, 2022
- [Self Hosted Podcast 48](https://selfhosted.show/48) - Jul 2nd, 2021
- [Self Hosted Podcast 27](https://selfhosted.show/27) - Sep 11, 2020
- [Home Assistant Podcast 58](https://hasspodcast.io/ha058/) - Oct 31, 2019
- [Python Bytes Podcast Episode 138](https://pythonbytes.fm/episodes/show/138/will-pyoxidizer-weld-shut-one-of-python-s-major-gaps) - Jul 4, 2019

## Integrations
- [Apache Airflow](https://airflow.apache.org/): Airflow is a platform created by the community to programmatically author, schedule and monitor workflows.
- [Home Assistant](https://www.home-assistant.io/): Open source home automation that puts local control and privacy first.
- [Fail2Ban](https://www.fail2ban.org/): scans log files and bans IPs that show the malicious signs -- too many password failures, seeking for exploits, etc. Generally Fail2Ban is then used to update firewall rules to reject the IP addresses for a specified amount of time, although any arbitrary other action (e.g. sending a notification via Apprise) could also be configured.
- [Uptime Kuma](https://github.com/louislam/uptime-kuma): A popular self-hosted monitoring tool like _[Uptime Robot](https://uptimerobot.com/)_.
- [SABnzbd](https://sabnzbd.org/): Free and easy binary newsreader.
- [Apprise-GA](https://github.com/cstuder/apprise-ga): Apprise [GitHub Action](https://github.com/features/actions) integration.  Also available in the [GitHub Marketplace](https://github.com/marketplace/actions/apprise-notification).
- [Bazarr](https://www.bazarr.media/): A companion application to [Sonarr](https://sonarr.tv) and [Radarr](https://radarr.video). It manages and downloads subtitles based on your requirements. You define your preferences by TV show or movie and Bazarr takes care of everything for you.
- [Mealie](https://github.com/hay-kot/mealie): Mealie is a self hosted recipe manager and meal planner.
- [Ouroboros](https://github.com/pyouroboros/ouroboros): Automatically update running docker containers with newest available image.
- [Mailrise](https://github.com/YoRyan/mailrise): Listens for emails and relays them through Apprise.
- [Apprise-Skill](https://github.com/domcross/apprise-skill): A component of [Mycroft](https://mycroft.ai/) voice assistant platform allowing it to work with the Apprise library.
- [Traktarr](https://github.com/l3uddz/traktarr): Script to add new series & movies to [Sonarr](https://sonarr.tv)/[Radarr](https://radarr.video) based on [Trakt](https://trakt.tv) lists.
- [Healthchecks](https://healthchecks.io): A Cron Monitoring Tool written in Python & Django.
- [ChangeDetection](https://github.com/dgtlmoon/changedetection.io): A tool that monitors websites you provide it so that it can alert you when the page changes (and/or is updated).
- [binance-trade-bot](https://github.com/edeng23/binance-trade-bot): A platform that monitors bitcoin currency value and can automatically move your coins around (while notifying you when this is done) to maximize your profit.
- [BirdNET-Pi](https://github.com/mcguirepr89/BirdNET-Pi): Allows your sytem to recognize bird sounds from a USB microphone or sound card in realtime and share its data with the rest of the world.
- [Prefect 2](https://github.com/PrefectHQ/prefect): The easiest way to coordinate your dataflow! It is a second-generation dataflow coordination and orchestration platform from [Prefect](https://www.prefect.io/).
- [BorgWarehouse](https://borgwarehouse.com/): A fast and modern WebUI for a [BorgBackup](https://www.borgbackup.org/) central repository server.
- [Robusta](https://home.robusta.dev/): Keep your Kubernetes microservices up and running. Robusta is both an automations engine for Kubernetes, and a [multi-cluster observability platform](https://home.robusta.dev/).
- [Borgmatic](https://torsion.org/borgmatic/): A is simple, configuration-driven backup software for servers and workstations. Protect your files with client-side encryption. Backup your databases too. Monitor it all with integrated third-party services.
- [Superagent](https://github.com/homanp/superagent): An open-source agent framework that enables any developer to integrate production-ready AI Assistants into any application in a matter of minutes.
- [Tube Archivist](https://tubearchivist.com/): A self hosted YouTube media server
- [Robusta](https://github.com/robusta-dev/robusta): Keep your Kubernetes microservices up and running

## Public Acknowledgements

- [BorgWarehouse Developer (Raven) Blog](https://r4ven.fr/en/blog/apprise-opensource-notification-library/) - Mar 15, 2023
- [Bertelsmann's Developer Blog](https://developers.bertelsmann.com/en/blog/articles/apprise-your-push-messaging-musketeer-one-for-all-messenger-services) - Jan 28, 2022
- [syslog-ng Blog](https://www.syslog-ng.com/community/b/blog/posts/first-steps-of-sending-alerts-to-discord-and-others-from-syslog-ng-http-and-apprise) - Apr 20, 2021 
- [Kumulos Newsletter](https://www.kumulos.com/2019/11/26/kumulos-features-update-fall-19/) - Nov 26, 2019
- [Python Weekly - Issue 382](https://newsletry.com/Home/Python%20Weekly/b6a9876d-7f17-40f1-c7e5-08d686ed8528) - Jan 24, 2019  