## Twitter Notifications
* **Source**: https://twitter.com/
* **Attachment Support**: Yes
* **Icon Support**: No
* **Message Format**: Text
* **Message Limit**: 10000 Characters per message if a private DM otherwise public tweets are limited to 280 character.

### Account Setup
Twitter Direct Messages  are slightly more complicated then some of the other notification services, so here is quick breakdown of what you need to know and do in order to send Notifications through it using this tool:

1. First off, you need to generate a Twitter App from [developer.twitter.com](https://developer.twitter.com/en/apps). It's through a Twitter App we will be able to send our DMs.
2. Once you create the app, you'll need to **generate the Access Tokens**. This Is done from the "*Keys and Access Tokens*" Tab.<br/>![Immagine 2022-05-29 215909](https://user-images.githubusercontent.com/55278049/170889227-a593c2e4-901c-42b1-801f-2a8e6f6eee28.png)
3. If you need to post automatic tweets, send private messages you need to request high access on your application you can do it by accessing the **Elevated** section under the **Twitter API v2** section (on left menu). Twitter asks you to justify why you need it as long as you specify the purpose of your app in detail<br/>![Immagine 2022-05-29 221019](https://user-images.githubusercontent.com/55278049/170889548-ef64e746-9159-45ec-a763-74199e864964.png)<br/>For more information, please refer [here](https://developer.twitter.com/en/support/twitter-api/v2#:~:text=Can%20all%20Twitter%20API%20v2,not%20available%20at%20this%20time.).

You should now have 4 Tokens to work with at this point on this same page.
* A Consumer Key
* A Consumer Secret
* An Access Token
* An Access Token Secret

![image](https://user-images.githubusercontent.com/850374/159798092-33126194-eefb-4bca-80d0-7020f25cfe22.png)
From here you're ready to go. You can post public tweets or simply create DMs through the use of the mode= variable.  By default Direct Messaging (DM) is used.


### Syntax
Valid syntax is as follows:
- `twitter://{ConsumerKey}/{ConsumerSecret}/{AccessToken}/{AccessSecret}`
- `twitter://{ScreenName}@{ConsumerKey}/{ConsumerSecret}/{AccessToken}/{AccessSecret}`

If you know the targets you wish to identify; they can be targeted by their Twitter Screen Name:
- `twitter://{ConsumerKey}/{ConsumerSecret}/{AccessToken}/{AccessSecret}/{ScreenName}`
- `twitter://{ConsumerKey}/{ConsumerSecret}/{AccessToken}/{AccessSecret}/{ScreenName1}/{ScreenName2}/{ScreenNameN}`

**Note** If no ScreenName is specified, then by default the Direct Message is sent to your own account.

A Public tweet can be referenced like so:
* `twitter://{ConsumerKey}/{ConsumerSecret}/{AccessToken}/{AccessSecret}?mode=tweet`

### Parameter Breakdown
| Variable    | Required | Description
| ----------- | -------- | -----------
| ScreenName      | Yes      | The UserID of your account such as *l2gnux* (if your id is @l2gnux). You must specify a {userid} *or* an {ownerid}.
| ConsumerKey      | Yes      | The Consumer Key
| ConsumerSecret     | Yes      | The Consumer Secret Key
| AccessToken     | Yes      | The Access Token; you would have had to generate this one from your Twitter App Configuration.
| AccessSecret     | Yes      | The Access Secret; you would have had to generate this one from your Twitter App Configuration.
| Mode             | No       | The Twitter mode you want to operate in.  Possible values are **dm** (for Private Direct Messages) and **tweet** to make a public post.  By default this is set to **dm**
| batch            | No       | By default images are batched together.  However if you want your attachments to be posted 1 tweet per attachment, set this to False.

#### Example
Send a Twitter DM to @testaccount:
```bash
# Assuming our {ConsumerKey} is T1JJ3T3L2
# Assuming our {ConsumerSecret} is A1BRTD4JD
# Assuming our {AccessToken} is TIiajkdnlazkcOXrIdevi7F
# Assuming our {AccessSecret} is FDVJaj4jcl8chG3
# our user is @testaccount
apprise -vv -t "Test Message Title" -b "Test Message Body" \
   twitter://testaccount@T1JJ3T3L2/A1BRTD4JD/TIiajkdnlazkcOXrIdevi7F/FDVJaj4jcl8chG3

```

Send a public Tweet:
```bash
# Assuming our {ConsumerKey} is T1JJ3T3L2
# Assuming our {ConsumerSecret} is A1BRTD4JD
# Assuming our {AccessToken} is TIiajkdnlazkcOXrIdevi7F
# Assuming our {AccessSecret} is FDVJaj4jcl8chG3
apprise -vv -t "Test Message Title" -b "Test Message Body" \
   twitter://testaccount@T1JJ3T3L2/A1BRTD4JD/TIiajkdnlazkcOXrIdevi7F/FDVJaj4jcl8chG3?mode=tweet

```