## Misskey Notifications
* **Source**: https://misskey-hub.net/
* **Attachment Support**: No
* **Icon Support**: No
* **Message Format**: Text
* **Message Limit**: 500

### Account Setup
Sign up for any Misskey based service. [Here are a few you can choose from today](https://misskey-hub.net/en/instances.html).

In the **Settings** of your account, you can access the **API** tab and create the  **Generate access token**. This is what Apprise will use to send your notifications.
![image](https://user-images.githubusercontent.com/850374/219906358-2e3028c8-05c1-4cba-a71c-f6e2d121029c.png)

While generating the token:
  - Call it whatever you want
  -  At the bare minimum you need to grant the: **Compose or delete notes**<br/>
![image](https://user-images.githubusercontent.com/850374/219906545-1a7865a6-7e59-4fc4-a2e5-f49627e72f4e.png)

After you save your changes, you will be provided with the **Access Token** needed to work with Apprise.
 
### Syntax
Valid syntax is as follows:
* `misskey://{token}@{host}`
* `misskeys://{token}@{host}`

Simply use `misskey://` if accessing an insecure server and `misskeys://` if accessing a secure one (https). In most cases, you'll likely always be using `misskeys://`

### Parameter Breakdown
| Variable        | Required | Description
| --------------- | -------- | -----------
| token     | Yes      | The Access Token associated with the Application you created (in Misskey's Account Settings).  Your token MUST have at the bare minimum `write:statuses` access.  Additionally provide `write:media` if you intend to provide attachments.
| visibility     | No      | The Misskey visibility you want to operate in. Possible values are:<br/>:red_circle: `public`: your note will be visible to all users and will show up on all timelines (home, local, social, global).<br/>Note: If your account is _silenced_, you cannot set your note visibility to public.<br/>:red_circle: `home`: Your note will be visible to all users, but will not show up on the local, social or global timeline for non-followers.<br/>:red_circle: `followers`: Your note will only be visible to those that are following you. The note will show up on all timelines of your followers.<br/>:red_circle: `specified`:  Your note will only be visible to individually specified users. The note will show up on all timelines of the specified users. If you enable this option, your note won't be federated to remote instances.

#### Example
Create a Misskey note on the `misskey.sda1.net` server :
```bash
# Assuming our {hostname} is misskey.sda1.net
# Assuming our {token} is abcdefghijklmn
apprise -vv -t "Test Message Title" -b "Test Message Body" \
   "misskeys://misskey.sda1.net/abcdefghijklmn"
```

This example builds on the last but leverages the `visibility` option::
```bash
# Assuming our {hostname} is misskey.sda1.net
# Assuming our {token} is abcdefghijklmn
# Assuming a {visibility} of home
apprise -vv -t "Test Message Title" -b "Test Message Body" \
   "misskeys://misskey.sda1.net/abcdefghijklmn?visibility=home"
```
