"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
module.exports = function (reportingService) {
    let operations = {
        GET,
    };
    function GET(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            let prefix = req.prefix.replace("_", "");
            let result = yield reportingService.getReportItems(prefix, req.query);
            res.status(200).json(result);
        });
    }
    GET.apiDoc = {
        tags: ["Reporting tools"],
        summary: "Return report items to fill in.",
        operationId: "getReportItems",
        parameters: [
            {
                name: "name",
                in: "query",
                description: "Report name",
                required: true,
                schema: {
                    type: "string",
                },
            },
            {
                name: "type",
                in: "query",
                description: "Report type (docx, xlsx)",
                required: true,
                schema: {
                    type: "string",
                },
            },
        ],
        responses: {
            200: {
                description: "Array of historical data.",
                content: {
                    "*/*": {
                        schema: {
                            type: "object",
                            items: {
                                $ref: "#/components/schemas/ReportingResult",
                            },
                        },
                    },
                },
            },
            default: {
                description: "An error occurred",
                content: {
                    "text/html": {
                        schema: {
                            additionalProperties: true,
                        },
                    },
                },
            },
        },
    };
    return operations;
};
