"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
module.exports = function (reportingService) {
    let operations = {
        GET,
    };
    function GET(req, res, next) {
        return __awaiter(this, void 0, void 0, function* () {
            var _a, _b;
            const prefix = req.prefix.replace("_", "");
            if ((_a = req.query) === null || _a === void 0 ? void 0 : _a.options) {
                try {
                    req.query.options = JSON.parse(req.query.options);
                }
                catch (e) {
                    // invalid JSON in options
                }
            }
            // Set up chunked response to keep connection alive
            res.setHeader("Content-Type", "application/json");
            res.setHeader("Transfer-Encoding", "chunked");
            res.setHeader("Cache-Control", "no-cache");
            try {
                (_b = res.flushHeaders) === null || _b === void 0 ? void 0 : _b.call(res); // if you're using Express
            }
            catch (e) { }
            // Send keep-alive whitespace every 10 seconds
            const keepAliveTimer = setInterval(() => {
                try {
                    res.write(" \n"); // write a space to keep the connection alive
                }
                catch (err) {
                    clearInterval(keepAliveTimer);
                }
            }, 10000); // 10 seconds
            try {
                const result = yield reportingService.generateReport(prefix, req.query);
                clearInterval(keepAliveTimer);
                // Final JSON result
                res.end(JSON.stringify(result));
            }
            catch (err) {
                clearInterval(keepAliveTimer);
                res.statusCode = 500;
                res.end(JSON.stringify({ err: true, message: "Report generation failed." }));
            }
        });
    }
    GET.apiDoc = {
        tags: ["Reporting"],
        summary: "Generate Report.",
        operationId: "generateReport",
        parameters: [
            {
                name: "name",
                in: "query",
                description: "Report name",
                required: true,
                schema: {
                    type: "string",
                },
            },
            {
                name: "from",
                in: "query",
                description: "Start datetime value in format RFC 3339, section 5.6 (example: 2017-07-21T17:32:28Z)",
                required: false,
                schema: {
                    type: "string",
                    format: "date-time", //2017-07-21T17:32:28Z
                },
            },
            {
                name: "to",
                in: "query",
                description: "End datetime value in format RFC 3339, section 5.6 (example: 2017-07-21T17:32:28Z)",
                required: false,
                schema: {
                    type: "string",
                    format: "date-time",
                },
            },
            {
                name: "limit",
                in: "query",
                description: "Limit number of records",
                required: false,
                schema: {
                    type: "integer",
                    minimum: 1,
                },
            },
            {
                name: "filename",
                in: "query",
                description: "Output file name",
                required: false,
                schema: {
                    type: "string",
                },
            },
            {
                name: "options",
                in: "query",
                description: "Pass data for script.",
                required: false,
                schema: {},
            },
        ],
        responses: {
            200: {
                description: "Array of historical data.",
                content: {
                    "*/*": {
                        schema: {
                            type: "object",
                            items: {
                                $ref: "#/components/schemas/ReportingResult",
                            },
                        },
                    },
                },
            },
            default: {
                description: "An error occurred",
                content: {
                    "text/html": {
                        schema: {
                            additionalProperties: true,
                        },
                    },
                },
            },
        },
    };
    return operations;
};
