"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const apiDoc = {
    openapi: "3.0.3",
    // swagger: "3.0",
    //basePath: "/",
    info: {
        title: "mySCADA API",
        version: "1.0.0",
    },
    servers: [{ url: "/apiv1" }],
    components: {
        securitySchemes: {
            /*basicAuth: {
              type: "http",
              scheme: "basic",
            },*/
            bearerAuth: {
                type: "http",
                scheme: "bearer",
            } /*
            apiKeyAuth: {
              type: "apiKey",
              in: "header",
              name: "X-API-Key",
            },*/,
            oAuth2: {
                type: "oauth2",
                flows: {
                    authorizationCode: {
                        authorizationUrl: "/auth",
                        tokenUrl: "/token",
                        scopes: {
                            openid: "default OpenID",
                            myscada: "mySCADA",
                        },
                    },
                },
            },
        },
        schemas: {
            ReportingResult: {
                type: "object",
            },
        },
    },
    paths: {},
    security: [
        {
            bearerAuth: [],
        },
        { oAuth2: ["openID", "myscada"] },
    ],
};
module.exports = apiDoc;
