interface ICreateWrapperOptions {
    withCallback?: boolean;
    multiArgs?: boolean | string[];
}
/**
 * Turn async functions into promises
 *
 * @param {Function} fn
 * @return {Function}
 * @api public
 */
declare function thenify(fn: Function, options: ICreateWrapperOptions): Function;
/**
 * Turn async functions into promises and backward compatible with callback
 */
declare function withCallback<T extends Function>(fn: Function, options?: ICreateWrapperOptions): T;

export { type ICreateWrapperOptions, thenify, withCallback };
