"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _events = require("events");
var util = _interopRequireWildcard(require("util"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class Debug extends _events.EventEmitter {
  /*
    @options    Which debug details should be sent.
                data    - dump of packet data
                payload - details of decoded payload
  */
  constructor({
    data = false,
    payload = false,
    packet = false,
    token = false
  } = {}) {
    super();
    this.options = {
      data,
      payload,
      packet,
      token
    };
    this.indent = '  ';
  }
  packet(direction, packet) {
    if (this.haveListeners() && this.options.packet) {
      this.log('');
      this.log(direction);
      this.log(packet.headerToString(this.indent));
    }
  }
  data(packet) {
    if (this.haveListeners() && this.options.data) {
      this.log(packet.dataToString(this.indent));
    }
  }
  payload(generatePayloadText) {
    if (this.haveListeners() && this.options.payload) {
      this.log(generatePayloadText());
    }
  }
  token(token) {
    if (this.haveListeners() && this.options.token) {
      this.log(util.inspect(token, {
        showHidden: false,
        depth: 5,
        colors: true
      }));
    }
  }
  haveListeners() {
    return this.listeners('debug').length > 0;
  }
  log(text) {
    this.emit('debug', text);
  }
}
var _default = exports.default = Debug;
module.exports = Debug;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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