/**
 * Bonjour Service - Service Definition
 */
/// <reference types="node" />
import { EventEmitter } from 'events';
import * as mDNS from 'multicast-dns';
export interface ServiceConfig extends Omit<mDNS.Options, "type"> {
    name: string;
    type?: string;
    port: number;
    protocol?: 'tcp' | 'udp';
    host?: string;
    fqdn?: string;
    subtypes?: Array<string>;
    txt?: Record<string, string>;
    probe?: boolean;
}
export interface ServiceRecord {
    name: string;
    type: 'PTR' | 'SRV' | 'TXT' | 'A' | 'AAAA';
    ttl: number;
    data: {
        [key: string]: any;
    } | string | any;
}
export interface ServiceReferer {
    address: string;
    family: 'IPv4' | 'IPv6';
    port: number;
    size: number;
}
export declare class Service extends EventEmitter {
    name: string;
    type: string;
    protocol: 'tcp' | 'udp';
    port: number;
    host: string;
    fqdn: string;
    txt?: Record<string, string>;
    subtypes?: Array<string>;
    addresses?: Array<string>;
    referer?: ServiceReferer;
    probe: boolean;
    published: boolean;
    activated: boolean;
    destroyed: boolean;
    _broadCastTimeout: NodeJS.Timer | undefined;
    start?: any;
    stop?: any;
    constructor(config: ServiceConfig);
    records(): ServiceRecord[];
}
export default Service;
