"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toType = exports.toString = void 0;
/**
 * Provides underscore prefix to name
 * @param name
 * @returns
 */
const Prefix = (name) => {
    return '_' + name;
};
/**
 * Check if key is allowed
 * @param key
 * @returns
 */
const AllowedProp = (key) => {
    let keys = ['name', 'protocol', 'subtypes'];
    return keys.includes(key);
};
/**
 * Format input ServiceType to string
 * @param data
 * @returns
 */
const toString = (data) => {
    // Format to correct order
    let formatted = {
        name: data.name,
        protocol: data.protocol,
        subtypes: data.subtypes
    };
    // Output as entries array
    let entries = Object.entries(formatted);
    return entries
        .filter(([key, val]) => AllowedProp(key) && val !== undefined)
        .reduce((prev, [key, val]) => {
        switch (typeof val) {
            case 'object':
                val.map((i) => prev.push(Prefix(i)));
                break;
            default:
                prev.push(Prefix(val));
                break;
        }
        return prev;
    }, [])
        .join('.');
};
exports.toString = toString;
/**
 * Format input string to ServiceType
 * @param string
 * @returns
 */
const toType = (string) => {
    // Split string into parts by dot
    const parts = string.split('.');
    // Remove the prefix
    for (let i in parts) {
        if (parts[i][0] !== '_')
            continue;
        parts[i] = parts[i].slice(1);
    }
    // Format the output
    return {
        name: parts.shift(),
        protocol: parts.shift() || null,
        subtypes: parts
    };
};
exports.toType = toType;
//# sourceMappingURL=service-types.js.map