import Server from './mdns-server';
import Service, { ServiceConfig } from './service';
export declare class Registry {
    private server;
    private services;
    constructor(server: Server);
    publish(config: ServiceConfig): Service;
    unpublishAll(callback: CallableFunction | undefined): void;
    destroy(): void;
    /**
     * Check if a service name is already in use on the network.
     *
     * Used before announcing the new service.
     *
     * To guard against race conditions where multiple services are started
     * simultaneously on the network, wait a random amount of time (between
     * 0 and 250 ms) before probing.
     *
     */
    private probe;
    /**
     * Initial service announcement
     *
     * Used to announce new services when they are first registered.
     *
     * Broadcasts right away, then after 3 seconds, 9 seconds, 27 seconds,
     * and so on, up to a maximum interval of one hour.
     */
    private announce;
    /**
     * Stop the given services
     *
     * Besides removing a service from the mDNS registry, a "goodbye"
     * message is sent for each service to let the network know about the
     * shutdown.
     */
    private teardown;
}
export default Registry;
