"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Browser = exports.Service = exports.Bonjour = void 0;
const registry_1 = __importDefault(require("./lib/registry"));
const mdns_server_1 = __importDefault(require("./lib/mdns-server"));
const browser_1 = __importDefault(require("./lib/browser"));
exports.Browser = browser_1.default;
const service_1 = __importDefault(require("./lib/service"));
exports.Service = service_1.default;
class Bonjour {
    /**
     * Setup bonjour service with optional config
     * @param opts ServiceConfig | undefined
     * @param errorCallback Function | undefined
     */
    constructor(opts, errorCallback) {
        this.server = new mdns_server_1.default(opts, errorCallback);
        this.registry = new registry_1.default(this.server);
    }
    /**
     * Publish a service for the device with options
     * @param opts
     * @returns
     */
    publish(opts) {
        return this.registry.publish(opts);
    }
    /**
     * Unpublish all services for the device
     * @param callback
     * @returns
     */
    unpublishAll(callback) {
        return this.registry.unpublishAll(callback);
    }
    /**
     * Find services on the network with options
     * @param opts BrowserConfig
     * @param onup Callback when up event received
     * @returns
     */
    find(opts = undefined, onup) {
        return new browser_1.default(this.server.mdns, opts, onup);
    }
    /**
     * Find a single device and close browser
     * @param opts BrowserConfig
     * @param timeout Timeout (ms) if not device is found, default 10s
     * @param callback Callback when device found
     * @returns
     */
    findOne(opts = undefined, timeout = 10000, callback) {
        if (this.timerId) {
            clearTimeout(this.timerId);
            this.timerId = undefined;
        }
        const browser = new browser_1.default(this.server.mdns, opts);
        browser.once('up', (service) => {
            if (this.timerId !== undefined) {
                clearTimeout(this.timerId);
                this.timerId = undefined;
            }
            browser.stop();
            if (callback)
                callback(service);
        });
        this.timerId = setTimeout(() => {
            browser.stop();
            if (callback)
                callback(null);
        }, timeout);
        return browser;
    }
    /**
     * Destroy the class
     */
    destroy(callback) {
        if (this.timerId) {
            clearTimeout(this.timerId);
            this.timerId = undefined;
        }
        this.registry.destroy();
        this.server.mdns.destroy(callback);
    }
}
exports.Bonjour = Bonjour;
exports.default = Bonjour;
//# sourceMappingURL=index.js.map