"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
exports.__esModule = true;
var OpenAPISecurityHandler = /** @class */ (function () {
    function OpenAPISecurityHandler(args) {
        var loggingKey = args && args.loggingKey ? args.loggingKey + ': ' : '';
        if (!args) {
            throw new Error(loggingKey + 'missing args argument');
        }
        var securityDefinitions = args.securityDefinitions;
        var securityHandlers = args.securityHandlers;
        var operationSecurity = args.operationSecurity;
        if (!securityDefinitions || typeof securityDefinitions !== 'object') {
            throw new Error(loggingKey + 'securityDefinitions must be an object');
        }
        if (!securityHandlers || typeof securityHandlers !== 'object') {
            throw new Error(loggingKey + 'securityHandlers must be an object');
        }
        if (!operationSecurity || !Array.isArray(operationSecurity)) {
            throw new Error(loggingKey + 'operationSecurity must be an Array');
        }
        this.operationSecurity = operationSecurity;
        this.securitySets = operationSecurity
            .map(function (security) {
            return Object.keys(security)
                .map(function (scheme) {
                if (!securityDefinitions[scheme]) {
                    throw new Error(loggingKey +
                        'Unknown security scheme "' +
                        scheme +
                        '" used in operation.');
                }
                if (!securityHandlers[scheme]) {
                    console.warn(loggingKey +
                        'No handler defined for security scheme "' +
                        scheme +
                        '"');
                    return null;
                }
                if (typeof securityHandlers[scheme] !== 'function') {
                    throw new Error(loggingKey +
                        'Security handlers must be functions.  Non function ' +
                        'given for scheme "' +
                        scheme +
                        '"');
                }
                return {
                    definition: securityDefinitions[scheme],
                    handler: securityHandlers[scheme],
                    scopes: security[scheme]
                };
            })
                .filter(
            /* tslint:disable-next-line:no-shadowed-variable */
            function (security) {
                return !!security;
            });
        })
            .filter(function (set) {
            return set.length > 0;
        });
        if (!this.securitySets.length) {
            this.handle = function () { return Promise.resolve(); };
        }
    }
    OpenAPISecurityHandler.prototype.handle = function (request) {
        return __awaiter(this, void 0, void 0, function () {
            var operationSecurity;
            return __generator(this, function (_a) {
                operationSecurity = this.operationSecurity;
                return [2 /*return*/, this.securitySets
                        .reduce(function (promiseChain, currentTask) {
                        return promiseChain.then(function (result) {
                            if (!result) {
                                var resultPromises = currentTask.map(function (securitySet) {
                                    return securitySet.handler(request, securitySet.scopes, securitySet.definition);
                                });
                                return Promise.all(resultPromises).then(function (results) {
                                    /* tslint:disable-next-line:no-shadowed-variable */
                                    return results.filter(function (result) { return !result; }).length === 0;
                                });
                            }
                            return Promise.resolve(result);
                        });
                    }, Promise.resolve(false))
                        .then(function (result) {
                        if (!result) {
                            return Promise.reject({
                                status: 401,
                                message: 'No security handlers returned an acceptable response: ' +
                                    operationSecurity.map(toAuthenticationScheme).join(' OR '),
                                errorCode: 'authentication.openapi.security'
                            });
                        }
                    })];
            });
        });
    };
    return OpenAPISecurityHandler;
}());
exports["default"] = OpenAPISecurityHandler;
function toAuthenticationScheme(security) {
    return Object.keys(security).join(' AND ');
}
//# sourceMappingURL=index.js.map