import { FormatDefinition, Format, ErrorObject } from 'ajv';
import { IJsonSchema, OpenAPIV2, OpenAPIV3 } from 'openapi-types';
export interface IOpenAPIResponseValidator {
    validateResponse(statusCode: string, response: any): void | OpenAPIResponseValidatorValidationError;
}
export interface OpenAPIResponseValidatorArgs {
    customFormats?: {
        [formatName: string]: Format | FormatDefinition<string | number>;
    };
    definitions?: {
        [definitionName: string]: IJsonSchema;
    };
    components?: OpenAPIV3.ComponentsObject;
    externalSchemas?: {
        [index: string]: IJsonSchema;
    };
    loggingKey?: string;
    responses: {
        [responseCode: string]: {
            schema: OpenAPIV2.Schema | OpenAPIV3.SchemaObject;
        };
    };
    errorTransformer?(openAPIResponseValidatorValidationError: OpenAPIResponseValidatorError, ajvError: ErrorObject): any;
}
export interface OpenAPIResponseValidatorError {
    path?: string;
    errorCode: string;
    message: string;
}
export interface OpenAPIResponseValidatorValidationError {
    message: string;
    errors?: any[];
}
export default class OpenAPIResponseValidator implements IOpenAPIResponseValidator {
    private errorMapper;
    private validators;
    constructor(args: OpenAPIResponseValidatorArgs);
    validateResponse(statusCode: any, response: any): {
        message: string;
        errors: any;
    };
}
