import { OpenAPI, OpenAPIV3 } from 'openapi-types';
import { Logger } from 'ts-log';
export interface IOpenAPIRequestCoercer {
    coerce(request: OpenAPI.Request): void;
}
export interface CoercionStrategy {
    boolean?: (input: any) => any;
    number?: (input: any) => any;
    integer?: (input: any) => any;
}
export interface OpenAPIRequestCoercerArgs {
    loggingKey?: string;
    logger?: Logger;
    enableObjectCoercion?: boolean;
    extensionBase?: string;
    coercionStrategy?: CoercionStrategy;
    parameters: OpenAPI.Parameters;
    requestBody?: OpenAPIV3.RequestBodyObject;
}
export default class OpenAPIRequestCoercer implements IOpenAPIRequestCoercer {
    private coerceHeaders;
    private coerceParams;
    private coerceQuery;
    private coerceFormData;
    constructor(args: OpenAPIRequestCoercerArgs);
    coerce(request: any): void;
}
