"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
exports.__esModule = true;
exports.convertParametersToJSONSchema = void 0;
function convertParametersToJSONSchema(parameters) {
    var parametersSchema = {};
    var bodySchema = getBodySchema(parameters);
    var formDataSchema = getSchema(parameters, 'formData');
    var headerSchema = getSchema(parameters, 'header');
    var pathSchema = getSchema(parameters, 'path');
    var querySchema = getSchema(parameters, 'query');
    var cookieSchema = getSchema(parameters, 'cookie');
    if (bodySchema) {
        parametersSchema.body = bodySchema;
    }
    if (formDataSchema) {
        parametersSchema.formData = formDataSchema;
    }
    if (headerSchema) {
        parametersSchema.headers = headerSchema;
    }
    if (pathSchema) {
        parametersSchema.path = pathSchema;
    }
    if (querySchema) {
        parametersSchema.query = querySchema;
    }
    if (cookieSchema) {
        parametersSchema.cookie = cookieSchema;
    }
    return parametersSchema;
}
exports.convertParametersToJSONSchema = convertParametersToJSONSchema;
var VALIDATION_KEYWORDS = [
    'additionalItems',
    'default',
    'example',
    'description',
    'enum',
    'examples',
    'exclusiveMaximum',
    'exclusiveMinimum',
    'format',
    'items',
    'maxItems',
    'maxLength',
    'maximum',
    'minItems',
    'minLength',
    'minimum',
    'multipleOf',
    'pattern',
    'title',
    'type',
    'uniqueItems',
];
function copyValidationKeywords(src) {
    var dst = {};
    for (var i = 0, keys = Object.keys(src), len = keys.length; i < len; i++) {
        var keyword = keys[i];
        if (VALIDATION_KEYWORDS.indexOf(keyword) > -1 ||
            keyword.slice(0, 2) === 'x-') {
            dst[keyword] = src[keyword];
        }
    }
    return dst;
}
function handleNullable(schema) {
    return { anyOf: [schema, { type: 'null' }] };
}
var SUBSCHEMA_KEYWORDS = [
    'additionalItems',
    'items',
    'contains',
    'additionalProperties',
    'propertyNames',
    'not',
];
var SUBSCHEMA_ARRAY_KEYWORDS = ['items', 'allOf', 'anyOf', 'oneOf'];
var SUBSCHEMA_OBJECT_KEYWORDS = [
    'definitions',
    'properties',
    'patternProperties',
    'dependencies',
];
function handleNullableSchema(schema) {
    if (typeof schema !== 'object' || schema === null) {
        return schema;
    }
    var newSchema = __assign({}, schema);
    SUBSCHEMA_KEYWORDS.forEach(function (keyword) {
        if (typeof schema[keyword] === 'object' &&
            schema[keyword] !== null &&
            !Array.isArray(schema[keyword])) {
            newSchema[keyword] = handleNullableSchema(schema[keyword]);
        }
    });
    SUBSCHEMA_ARRAY_KEYWORDS.forEach(function (keyword) {
        if (Array.isArray(schema[keyword])) {
            newSchema[keyword] = schema[keyword].map(handleNullableSchema);
        }
    });
    SUBSCHEMA_OBJECT_KEYWORDS.forEach(function (keyword) {
        if (typeof schema[keyword] === 'object' && schema[keyword] !== null) {
            newSchema[keyword] = __assign({}, schema[keyword]);
            Object.keys(schema[keyword]).forEach(function (prop) {
                newSchema[keyword][prop] = handleNullableSchema(schema[keyword][prop]);
            });
        }
    });
    delete newSchema.$ref;
    if (schema.nullable) {
        delete newSchema.nullable;
        return handleNullable(newSchema);
    }
    return newSchema;
}
function getBodySchema(parameters) {
    var bodySchema = parameters.filter(function (param) {
        return param["in"] === 'body' && param.schema;
    })[0];
    if (bodySchema) {
        bodySchema = bodySchema.schema;
    }
    return bodySchema;
}
function getSchema(parameters, type) {
    var params = parameters.filter(byIn(type));
    var schema;
    if (params.length) {
        schema = { properties: {} };
        params.forEach(function (param) {
            var paramSchema;
            if ('schema' in param) {
                paramSchema = handleNullableSchema(param.schema);
                if ('examples' in param) {
                    paramSchema.examples = getExamples(param.examples);
                }
                schema.properties[param.name] = paramSchema;
            }
            else {
                paramSchema = copyValidationKeywords(param);
                if ('examples' in paramSchema) {
                    paramSchema.examples = getExamples(paramSchema.examples);
                }
                schema.properties[param.name] = param.nullable
                    ? handleNullable(paramSchema)
                    : paramSchema;
            }
        });
        schema.required = getRequiredParams(params);
    }
    return schema;
}
function getRequiredParams(parameters) {
    return parameters.filter(byRequired).map(toName);
}
function getExamples(exampleSchema) {
    return Object.keys(exampleSchema).map(function (k) { return exampleSchema[k].value; });
}
function byIn(str) {
    return function (param) { return param["in"] === str && param.type !== 'file'; };
}
function byRequired(param) {
    return !!param.required;
}
function toName(param) {
    return param.name;
}
//# sourceMappingURL=index.js.map