import { OpenAPIV3 } from 'openapi-types';
import { Logger } from 'ts-log';
import BasePath from './BasePath';
import { IOpenAPIFramework } from './types';
export declare const METHOD_ALIASES: {
    DELETE: string;
    GET: string;
    HEAD: string;
    OPTIONS: string;
    PATCH: string;
    POST: string;
    PUT: string;
    del: string;
    delete: string;
    get: string;
    head: string;
    options: string;
    patch: string;
    post: string;
    put: string;
};
export declare function addOperationTagToApiDoc(apiDoc: any, tag: any): void;
export declare function allowsCoercionFeature(framework: IOpenAPIFramework, ...docs: any[]): boolean;
export declare function allowsDefaultsFeature(framework: IOpenAPIFramework, ...docs: any[]): boolean;
export declare function allowsFeatures(framework: IOpenAPIFramework, ...docs: any[]): boolean;
export declare function allowsResponseValidationFeature(framework: IOpenAPIFramework, ...docs: any[]): boolean;
export declare function allowsValidationFeature(framework: IOpenAPIFramework, ...docs: any[]): boolean;
export declare function assertRegExpAndSecurity(framework: any, tuple: any): void;
export declare function byDefault(param: any): boolean;
export declare function byDirectory(el: any): any;
export declare function byMethods(name: any): boolean;
export declare function byRoute(a: any, b: any): number;
export declare function byString(el: any): boolean;
export declare function byTag(a: any, b: any): 1 | -1 | 0;
export declare function copy(obj: any): any;
export declare function getAdditionalFeatures(framework: IOpenAPIFramework, logger: Logger, ...docs: any[]): any[];
export declare function getSecurityDefinitionByPath(openapiPath: any, pathSecurity: any): any;
export declare function getMethodDoc(operationHandler: any): any;
export declare function handleFilePath(filePath: any): any;
export declare function handleYaml(apiDoc: any): any;
export declare function injectDependencies(handlers: any, dependencies: any): any;
export declare function isDynamicRoute(route: any): boolean;
export declare function resolveParameterRefs(framework: IOpenAPIFramework, parameters: any, apiDoc: any): any;
export declare function resolveResponseRefs(framework: IOpenAPIFramework, responses: any, apiDoc: any, route: any): {};
export declare function resolveRequestBodyRefs(framework: IOpenAPIFramework, requestBody: any, apiDoc: any): any;
export declare function sortApiDocTags(apiDoc: any): void;
export declare function sortOperationDocTags(operationDoc: any): void;
export declare function toAbsolutePath(part: any): any;
export declare function withNoDuplicates(arr: any): any[];
export declare function getBasePathsFromServers(servers: OpenAPIV3.ServerObject[]): BasePath[];
