"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const url_1 = require("url");
class BasePath {
    constructor(server) {
        this.variables = {};
        this.path = '';
        // break the url into parts
        // baseUrl param added to make the parsing of relative paths go well
        const serverUrl = new url_1.URL(server.url, 'http://localhost');
        let urlPath = decodeURI(serverUrl.pathname).replace(/\/$/, '');
        if (/{\w+}/.test(urlPath)) {
            // has variable that we need to check out
            urlPath = urlPath.replace(/{(\w+)}/g, (substring, p1) => `:${p1}`);
        }
        this.path = urlPath;
        for (const variable in server.variables) {
            if (server.variables.hasOwnProperty(variable)) {
                this.variables[variable] = { enum: server.variables[variable].enum };
            }
        }
    }
    hasVariables() {
        return Object.keys(this.variables).length > 0;
    }
}
exports.default = BasePath;
//# sourceMappingURL=BasePath.js.map