"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Xml2JsonPojo = exports.json_parser = void 0;
exports.startPojo = startPojo;
const xml2json_1 = require("./xml2json");
const xml2Json_pojo_tools_1 = require("./xml2Json_pojo_tools");
const json_extractor = new xml2Json_pojo_tools_1.ReaderState2();
exports.json_parser = {
    init(elementName, attrs, parent, engine) {
        json_extractor._on_init(elementName, attrs, parent, 0, engine);
    },
    finish() {
        this.parent._pojo = json_extractor._pojo;
    }
};
function startPojo(pThis, elementName, attrs, withPojo) {
    pThis.engine._promote(json_extractor, pThis.engine.currentLevel, elementName, attrs);
    json_extractor._withPojo = (name, pojo) => {
        withPojo(name, pojo);
        pThis.engine._demote(json_extractor, pThis.engine.currentLevel, elementName);
    };
}
class Xml2JsonPojo extends xml2json_1.Xml2Json {
    constructor() {
        super(json_extractor);
    }
}
exports.Xml2JsonPojo = Xml2JsonPojo;
//# sourceMappingURL=xml2json_pojo.js.map