/**
 * @module node-opcua-xml2json
 * node -> see if https://github.com/isaacs/sax-js could be used instead
 */
export type SimpleCallback = (err?: Error) => void;
export type Callback<T> = (err?: Error | null, result?: T) => void;
export interface Parser {
    [key: string]: ReaderState;
}
export interface XmlAttributes {
    [key: string]: string;
}
export interface ReaderStateParser {
    parser?: ParserLike;
    init?: (this: IReaderState, name: string, attrs: XmlAttributes, parent: IReaderState, engine: Xml2Json) => void;
    finish?: (this: IReaderState) => void;
    startElement?: (this: IReaderState, name: string, attrs: XmlAttributes) => void;
    endElement?: (this: IReaderState, name: string) => void;
}
export interface ParserLike {
    [key: string]: ReaderStateParserLike;
}
export interface ReaderStateParserLike {
    parser?: ParserLike;
    init?: (this: any, name: string, attrs: XmlAttributes, parent: IReaderState, engine: Xml2Json) => void;
    finish?: (this: any) => void;
    startElement?: (this: any, name: string, attrs: XmlAttributes) => void;
    endElement?: (this: any, name: string) => void;
}
export interface IReaderState {
    _on_init(elementName: string, attrs: XmlAttributes, parent: IReaderState, level: number, engine: Xml2Json): void;
    _on_finish(): void;
    _on_startElement(level: number, elementName: string, attrs: XmlAttributes): void;
    _on_endElement(level: number, elementName: string): void;
    _on_endElement2(level: number, elementName: string): void;
    _on_text(text: string): void;
}
export declare class ReaderStateBase {
}
export interface ReaderStateBase extends IReaderState {
}
/**
 * @private
 */
export declare class ReaderState extends ReaderStateBase {
    _init?: (name: string, attrs: XmlAttributes, parent: IReaderState, engine: Xml2Json) => void;
    _finish?: () => void;
    _startElement?: (name: string, attrs: XmlAttributes) => void;
    _endElement?: (name: string) => void;
    parser: any;
    attrs?: XmlAttributes;
    chunks: any[];
    text: string;
    name?: string | undefined;
    level: number;
    currentLevel: number;
    engine?: Xml2Json;
    parent?: IReaderState;
    root?: Xml2Json;
    data?: any;
    constructor(options: ReaderStateParser | ReaderState);
    /**
     * @protected
     */
    _on_init(elementName: string, attrs: XmlAttributes, parent: IReaderState, level: number, engine: Xml2Json): void;
    /**
     * @protected
     */
    _on_finish(): void;
    /**
     * @protected
     */
    _on_startElement(level: number, elementName: string, attrs: XmlAttributes): void;
    /**
     * @protected
     */
    _on_endElement2(level: number, elementName: string): void;
    /**

     * @protected
     */
    _on_endElement(level: number, elementName: string): void;
    /**
     * @param text {String} the text found inside the element
     * @protected
     */
    _on_text(text: string): void;
}
/**
 *
 * @example
 *  var parser = new Xml2Json({
 *       parser: {
 *           'person': {
 *               init: function(name,attrs) {
 *                   this.parent.root.obj = {};
 *                   this.obj =  this.parent.root.obj;
 *                   this.obj['name'] = attrs['name'];
 *               },
 *               parser: {
 *                   'address': {
 *                       finish: function(){
 *                           this.parent.obj['address'] = this.text;
 *                       }
 *                   }
 *               }
 *           }
 *       }
 *   });
 *
 * var xml_string =  "<employees>" +
 * "  <person name='John'>" +
 * "     <address>Paris</address>" +
 * "   </person>" +
 * "</employees>";
 *
 * parser.parseString(xml_string, function() {
 *       parser.obj.should.eql({name: 'John',address: 'Paris'});
 *       done();
 *   });
 */
export declare class Xml2Json {
    currentLevel: number;
    private state_stack;
    private current_state;
    constructor(options: ReaderStateParser);
    parseString(xml_text: string): Record<string, unknown>;
    /**
     * @private
     * @internal
     */
    _promote(new_state: IReaderState, level: number, name?: string, attr?: XmlAttributes): void;
    /**
     * @private
     * @internal
     */
    _demote(cur_state: IReaderState, level: number, elementName: string): void;
    /**
     * @private
     * @internal
     */
    protected __parseInternal(data: string): Record<string, unknown>;
}
