"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.definitionReaderStateParser = exports._definitionParser = void 0;
//<Definition Name="SomeName">
//    <Field Name="Running" Value="0" dataType: [ValueRank="1"]>
//      [<Description>text</Description>]
//   <Field>
// </Definition>
const node_opcua_assert_1 = __importDefault(require("node-opcua-assert"));
exports._definitionParser = {
    init(name, attrs, parent, engine) {
        (0, node_opcua_assert_1.default)(!this.parent.nFields || this.parent.definitionFields.length === 0);
        this.parent.definitionFields = [];
        this.parent.definitionName = attrs.SymbolicName || attrs.Name;
        this.array = this.parent.definitionFields;
        this.isUnion = attrs.IsUnion === "true" ? true : false;
    },
    parser: {
        Field: {
            init() {
                this.description = undefined;
            },
            parser: {
                Description: {
                    finish() {
                        this.parent.description = this.text;
                    }
                }
            },
            finish() {
                const obj = {
                    name: this.attrs.Name
                };
                if (this.attrs.AllowSubtype !== undefined) {
                    obj.allowSubtype = this.attrs.AllowSubtype === "true";
                }
                else {
                    obj.allowSubtype = false;
                }
                if (this.attrs.DataType !== undefined) {
                    obj.dataType = this.attrs.DataType;
                }
                if (this.description) {
                    obj.description = this.description;
                }
                if (this.attrs.Value !== undefined) {
                    obj.value = parseInt(this.attrs.Value, 10);
                }
                if (this.attrs.ValueRank !== undefined) {
                    obj.valueRank = parseInt(this.attrs.ValueRank, 10);
                }
                else {
                    // when not specified valueRank means Scalar and Scalar is -1
                    obj.valueRank = -1;
                }
                if (this.attrs.ArrayDimensions !== undefined) {
                    obj.arrayDimensions = this.attrs.ArrayDimensions.split(",").map((e) => parseInt(e, 10));
                }
                if (this.attrs.IsOptional !== undefined) {
                    obj.isOptional = this.attrs.IsOptional === "true" ? true : false;
                }
                if (this.attrs.SymbolicName !== undefined) {
                    obj.symbolicName = this.attrs.SymbolicName;
                }
                this.parent.array.push(obj);
            }
        }
    }
};
exports.definitionReaderStateParser = {
    parser: {
        Definition: exports._definitionParser
    },
    endElement() {
        this._pojo = {
            name: this.definitionName,
            fields: this.definitionFields
        };
    }
};
//# sourceMappingURL=definition_parser.js.map