// --------- This code has been automatically generated !!! 2025-09-24T21:15:01.295Z
/**
 * @module node-opcua-types
 */
// tslint:disable:no-this-assignment
// tslint:disable:max-classes-per-file
// tslint:disable:no-empty-interface
// tslint:disable:no-trailing-whitespace
// tslint:disable:array-type
// tslint:disable:object-literal-sort-keys
// tslint:disable:max-line-length

import { assert } from "node-opcua-assert";
import {
    Byte, ByteString, CharArray, DateTime,
    decodeArray, decodeBoolean, decodeByte, decodeByteString,
    decodeDateTime, decodeDouble, decodeExpandedNodeId, decodeFloat,
    decodeGuid, decodeInt16,
    decodeInt32, decodeInt64,
    decodeInt8, decodeNodeId,
    decodeString, decodeUABoolean,
    decodeUAString, decodeUInt16,
    decodeUInt32, decodeUInt64,
    decodeUInt8,
    decodeSByte,
    Double,
    encodeArray, encodeBoolean,
    encodeSByte, encodeByte, encodeByteString,
    encodeDateTime, encodeDouble,
    encodeExpandedNodeId, encodeFloat,
    encodeGuid, encodeInt16,
    encodeInt32, encodeInt64,
    encodeInt8, encodeNodeId,
    encodeString, encodeUABoolean,
    encodeUAString, encodeUInt16,
    encodeUInt32, encodeUInt64, encodeUInt8,
    Float, Guid,
    Int16, Int32,
    Int64,
    Int8,
    SByte,
    UABoolean,
    UAString, UInt16, UInt32,
    UInt64, UInt8,
} from "node-opcua-basic-types";

import { Enum, EnumItem } from "node-opcua-enum";

import { BinaryStream , OutputBinaryStream} from "node-opcua-binary-stream";
import {
    _enumerationBrowseDirection, BrowseDirection, decodeBrowseDirection, decodeDiagnosticInfo,
    decodeLocalizedText, decodeQualifiedName,
    DiagnosticInfo, DiagnosticInfoOptions,
    encodeBrowseDirection,
    encodeDiagnosticInfo, encodeLocalizedText, encodeQualifiedName,
    LocalizedText, LocalizedTextLike, QualifiedName, QualifiedNameLike,
    LocalizedTextOptions,    QualifiedNameOptions,
} from "node-opcua-data-model";
import {
    _enumerationTimestampsToReturn, DataValue, DataValueLike, DataValueOptions, decodeDataValue,
    decodeTimestampsToReturn, encodeDataValue, encodeTimestampsToReturn, TimestampsToReturn
} from "node-opcua-data-value";
import {
    decodeExtensionObject, encodeExtensionObject, ExtensionObject
} from "node-opcua-extension-object";
import {
    BaseUAObject, buildStructuredType, check_options_correctness_against_schema,
    initialize_field, initialize_field_array, parameters,
    registerClassDefinition,
    registerEnumeration, IStructuredTypeSchema
} from "node-opcua-factory";
import {
    ExpandedNodeId, makeExpandedNodeId, NodeId, NodeIdLike
} from "node-opcua-nodeid";
import {
    decodeNumericRange, encodeNumericRange, NumericRange
} from "node-opcua-numeric-range";
import {
    decodeStatusCode, encodeStatusCode, StatusCode, StatusCodes
} from "node-opcua-status-code";
import {
    decodeVariant, encodeVariant, Variant, VariantLike,
    VariantOptions
} from "node-opcua-variant";

// --------------------------------------------------------------------------------------------
const schemaEUInformation = buildStructuredType({
    name: "EUInformation",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "NamespaceUri",

            fieldType: "String",
        },
        {
            name: "UnitId",

            fieldType: "Int32",
        },
        {
            name: "DisplayName",

            fieldType: "LocalizedText",
        },
        {
            name: "Description",

            fieldType: "LocalizedText",
        },
    ]
});
export interface EUInformationOptions {
    namespaceUri?: UAString ;
    unitId?: Int32 ;
    displayName?: (LocalizedTextLike | null);
    description?: (LocalizedTextLike | null);
}
export class EUInformation extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaEUInformation; }
    public static possibleFields: string[] = [
          "namespaceUri",
           "unitId",
           "displayName",
           "description"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(887, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(889, 0);
    public static encodingDefaultXml = makeExpandedNodeId(888, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15376, 0);
    public namespaceUri: UAString;
    public unitId: Int32;
    public displayName: LocalizedText;
    public description: LocalizedText;

    constructor(options?: EUInformationOptions | null) {

        super(options);

        if (options === null) {
            this.namespaceUri = null;
            this.unitId = 0;
            this.displayName = new LocalizedText(null);
            this.description = new LocalizedText(null);
              return;
        }
        const schema = EUInformation.schema;
        options = (schema.constructHook ? schema.constructHook(options) as EUInformationOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.namespaceUri = initialize_field(schema.fields[0], options?.namespaceUri);
        this.unitId = initialize_field(schema.fields[1], options?.unitId);
        this.displayName = initialize_field(schema.fields[2], options?.displayName);
        this.description = initialize_field(schema.fields[3], options?.description);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.namespaceUri, stream);
        encodeInt32(this.unitId, stream);
        encodeLocalizedText(this.displayName, stream);
        encodeLocalizedText(this.description, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.namespaceUri = decodeString(stream, this.namespaceUri);
        this.unitId = decodeInt32(stream, this.unitId);
        this.displayName = decodeLocalizedText(stream, this.displayName);
        this.description = decodeLocalizedText(stream, this.description);
    }
    public get schema(): IStructuredTypeSchema { return schemaEUInformation; }
}
EUInformation.schema.dataTypeNodeId = EUInformation.dataTypeNodeId;
EUInformation.schema.encodingDefaultBinary = EUInformation.encodingDefaultBinary;
EUInformation.schema.encodingDefaultXml = EUInformation.encodingDefaultXml;
EUInformation.schema.encodingDefaultJson = EUInformation.encodingDefaultJson;
registerClassDefinition( EUInformation.dataTypeNodeId, "EUInformation", EUInformation);
// --------------------------------------------------------------------------------------------
const schemaRange = buildStructuredType({
    name: "Range",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Low",

            fieldType: "Double",
        },
        {
            name: "High",

            fieldType: "Double",
        },
    ]
});
export interface RangeOptions {
    low?: Double ;
    high?: Double ;
}
export class Range extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaRange; }
    public static possibleFields: string[] = [
          "low",
           "high"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(884, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(886, 0);
    public static encodingDefaultXml = makeExpandedNodeId(885, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15375, 0);
    public low: Double;
    public high: Double;

    constructor(options?: RangeOptions | null) {

        super(options);

        if (options === null) {
            this.low = 0;
            this.high = 0;
              return;
        }
        const schema = Range.schema;
        options = (schema.constructHook ? schema.constructHook(options) as RangeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.low = initialize_field(schema.fields[0], options?.low);
        this.high = initialize_field(schema.fields[1], options?.high);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeDouble(this.low, stream);
        encodeDouble(this.high, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.low = decodeDouble(stream, this.low);
        this.high = decodeDouble(stream, this.high);
    }
    public get schema(): IStructuredTypeSchema { return schemaRange; }
}
Range.schema.dataTypeNodeId = Range.dataTypeNodeId;
Range.schema.encodingDefaultBinary = Range.encodingDefaultBinary;
Range.schema.encodingDefaultXml = Range.encodingDefaultXml;
Range.schema.encodingDefaultJson = Range.encodingDefaultJson;
registerClassDefinition( Range.dataTypeNodeId, "Range", Range);

// --------------------------------------------------------------------------------------------
export enum AxisScaleEnumeration {
    Linear = 0,
    Log = 1,
    Ln = 2,
    Invalid = 4294967295
}
const schemaAxisScaleEnumeration = {
    enumValues: AxisScaleEnumeration,
    flaggable: false,
    minValue: 0,
    maxValue: 2,
    name: "AxisScaleEnumeration"
};
function decodeAxisScaleEnumeration(stream: BinaryStream, _value?: AxisScaleEnumeration): AxisScaleEnumeration {
    let value =  stream.readUInt32() as AxisScaleEnumeration;
    value = (value < schemaAxisScaleEnumeration.minValue || value > schemaAxisScaleEnumeration.maxValue) ? AxisScaleEnumeration.Invalid : value; 
    return value;
}
function encodeAxisScaleEnumeration(value: AxisScaleEnumeration, stream: OutputBinaryStream): void {
    stream.writeUInt32(value);
}
export const _enumerationAxisScaleEnumeration = registerEnumeration(schemaAxisScaleEnumeration);
assert(_enumerationAxisScaleEnumeration.isFlaggable ===  false);
// --------------------------------------------------------------------------------------------
const schemaAxisInformation = buildStructuredType({
    name: "AxisInformation",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "EngineeringUnits",

            fieldType: "EUInformation",
        },
        {
            name: "EURange",

            fieldType: "Range",
        },
        {
            name: "Title",

            fieldType: "LocalizedText",
        },
        {
            name: "AxisScaleType",

            fieldType: "AxisScaleEnumeration",
        },
        {
            name: "AxisSteps",

            fieldType: "Double",
            isArray: true
        },
    ]
});
export interface AxisInformationOptions {
    engineeringUnits?: EUInformationOptions ;
    euRange?: RangeOptions ;
    title?: (LocalizedTextLike | null);
    axisScaleType?: AxisScaleEnumeration;
    axisSteps?: Double [] | null;
}
export class AxisInformation extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaAxisInformation; }
    public static possibleFields: string[] = [
          "engineeringUnits",
           "euRange",
           "title",
           "axisScaleType",
           "axisSteps"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(12079, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(12089, 0);
    public static encodingDefaultXml = makeExpandedNodeId(12081, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15379, 0);
    public engineeringUnits: EUInformation;
    public euRange: Range;
    public title: LocalizedText;
    public axisScaleType: AxisScaleEnumeration;
    public axisSteps: Double[] | null;

    constructor(options?: AxisInformationOptions | null) {

        super(options);

        if (options === null) {
         this.engineeringUnits =  new EUInformation(null);
         this.euRange =  new Range(null);
            this.title = new LocalizedText(null);
             this.axisScaleType =  0 as  AxisScaleEnumeration;
            this.axisSteps = []
              return;
        }
        const schema = AxisInformation.schema;
        options = (schema.constructHook ? schema.constructHook(options) as AxisInformationOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.engineeringUnits  =  new EUInformation(options.engineeringUnits);
        this.euRange  =  new Range(options.euRange);
        this.title = initialize_field(schema.fields[2], options?.title);
        this.axisScaleType = this.setAxisScaleType(initialize_field(schema.fields[3], options?.axisScaleType));
        this.axisSteps = initialize_field_array(schema.fields[4], options?.axisSteps);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.engineeringUnits.encode(stream);
        this.euRange.encode(stream);
        encodeLocalizedText(this.title, stream);
        encodeAxisScaleEnumeration(this.axisScaleType, stream);
        encodeArray(this.axisSteps, stream, encodeDouble);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.engineeringUnits.decode(stream);
        this.euRange.decode(stream);
        this.title = decodeLocalizedText(stream, this.title);
        this.axisScaleType = decodeAxisScaleEnumeration(stream, this.axisScaleType);
        this.axisSteps = decodeArray(stream, decodeDouble);
    }

    // Define Enumeration setters
    public setAxisScaleType(value: any): AxisScaleEnumeration {
        const coercedValue = _enumerationAxisScaleEnumeration.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to AxisScaleEnumeration :" + value);
        }
        this.axisScaleType = coercedValue.value as AxisScaleEnumeration;
        return this.axisScaleType;
    }
    public get schema(): IStructuredTypeSchema { return schemaAxisInformation; }
}
AxisInformation.schema.dataTypeNodeId = AxisInformation.dataTypeNodeId;
AxisInformation.schema.encodingDefaultBinary = AxisInformation.encodingDefaultBinary;
AxisInformation.schema.encodingDefaultXml = AxisInformation.encodingDefaultXml;
AxisInformation.schema.encodingDefaultJson = AxisInformation.encodingDefaultJson;
registerClassDefinition( AxisInformation.dataTypeNodeId, "AxisInformation", AxisInformation);
// --------------------------------------------------------------------------------------------
const schemaFilterOperand = buildStructuredType({
    name: "FilterOperand",

    baseType: "ExtensionObject",
    fields: [
    ]
});
export interface FilterOperandOptions {
}
export class FilterOperand extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaFilterOperand; }
    public static possibleFields: string[] = [
          
    ];
    public static dataTypeNodeId = makeExpandedNodeId(589, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(591, 0);
    public static encodingDefaultXml = makeExpandedNodeId(590, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15206, 0);

    constructor(options?: FilterOperandOptions | null) {

        super(options);

        if (options === null) {
              return;
        }
        const schema = FilterOperand.schema;
        options = (schema.constructHook ? schema.constructHook(options) as FilterOperandOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaFilterOperand; }
}
FilterOperand.schema.dataTypeNodeId = FilterOperand.dataTypeNodeId;
FilterOperand.schema.encodingDefaultBinary = FilterOperand.encodingDefaultBinary;
FilterOperand.schema.encodingDefaultXml = FilterOperand.encodingDefaultXml;
FilterOperand.schema.encodingDefaultJson = FilterOperand.encodingDefaultJson;
registerClassDefinition( FilterOperand.dataTypeNodeId, "FilterOperand", FilterOperand);
// --------------------------------------------------------------------------------------------
const schemaSimpleAttributeOperand = buildStructuredType({
    name: "SimpleAttributeOperand",

    baseType: "FilterOperand",
    fields: [
        {
            name: "TypeDefinitionId",

            fieldType: "NodeId",
        },
        {
            name: "BrowsePath",

            fieldType: "QualifiedName",
            isArray: true
        },
        {
            name: "AttributeId",

            fieldType: "UInt32",
        },
        {
            name: "IndexRange",

            fieldType: "NumericRange",
        },
    ]
});
export interface SimpleAttributeOperandOptions extends FilterOperandOptions {
    typeDefinitionId?: (NodeIdLike | null);
    browsePath?: (QualifiedNameLike | null)[] | null;
    attributeId?: UInt32 ;
    indexRange?: NumericRange ;
}
export class SimpleAttributeOperand extends FilterOperand {
    public static get schema(): IStructuredTypeSchema { return schemaSimpleAttributeOperand; }
    public static possibleFields: string[] = [
          "typeDefinitionId",
           "browsePath",
           "attributeId",
           "indexRange"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(601, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(603, 0);
    public static encodingDefaultXml = makeExpandedNodeId(602, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15210, 0);
    public typeDefinitionId: NodeId;
    public browsePath: QualifiedName[] | null;
    public attributeId: UInt32;
    public indexRange: NumericRange;

    constructor(options?: SimpleAttributeOperandOptions | null) {

        super(options);

        if (options === null) {
            this.typeDefinitionId = new NodeId(null);
            this.browsePath = []
            this.attributeId = 0;
            this.indexRange = new NumericRange(null);
              return;
        }
        const schema = SimpleAttributeOperand.schema;
        options = (schema.constructHook ? schema.constructHook(options) as SimpleAttributeOperandOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.typeDefinitionId = initialize_field(schema.fields[0], options?.typeDefinitionId);
        this.browsePath = initialize_field_array(schema.fields[1], options?.browsePath);
        this.attributeId = initialize_field(schema.fields[2], options?.attributeId);
        this.indexRange = initialize_field(schema.fields[3], options?.indexRange);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.typeDefinitionId, stream);
        encodeArray(this.browsePath, stream, encodeQualifiedName);
        encodeUInt32(this.attributeId, stream);
        encodeNumericRange(this.indexRange, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.typeDefinitionId = decodeNodeId(stream, this.typeDefinitionId);
        this.browsePath = decodeArray(stream, decodeQualifiedName);
        this.attributeId = decodeUInt32(stream, this.attributeId);
        this.indexRange = decodeNumericRange(stream, this.indexRange);
    }
    public get schema(): IStructuredTypeSchema { return schemaSimpleAttributeOperand; }
}
SimpleAttributeOperand.schema.dataTypeNodeId = SimpleAttributeOperand.dataTypeNodeId;
SimpleAttributeOperand.schema.encodingDefaultBinary = SimpleAttributeOperand.encodingDefaultBinary;
SimpleAttributeOperand.schema.encodingDefaultXml = SimpleAttributeOperand.encodingDefaultXml;
SimpleAttributeOperand.schema.encodingDefaultJson = SimpleAttributeOperand.encodingDefaultJson;
registerClassDefinition( SimpleAttributeOperand.dataTypeNodeId, "SimpleAttributeOperand", SimpleAttributeOperand);
// --------------------------------------------------------------------------------------------
const schemaActionMethodDataType = buildStructuredType({
    name: "ActionMethodDataType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ObjectId",

            fieldType: "NodeId",
        },
        {
            name: "MethodId",

            fieldType: "NodeId",
        },
    ]
});
export interface ActionMethodDataTypeOptions {
    objectId?: (NodeIdLike | null);
    methodId?: (NodeIdLike | null);
}
export class ActionMethodDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaActionMethodDataType; }
    public static possibleFields: string[] = [
          "objectId",
           "methodId"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(0, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(0, 0);
    public static encodingDefaultXml = makeExpandedNodeId(0, 0);
    public static encodingDefaultJson = makeExpandedNodeId(0, 0);
    public objectId: NodeId;
    public methodId: NodeId;

    constructor(options?: ActionMethodDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.objectId = new NodeId(null);
            this.methodId = new NodeId(null);
              return;
        }
        const schema = ActionMethodDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ActionMethodDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.objectId = initialize_field(schema.fields[0], options?.objectId);
        this.methodId = initialize_field(schema.fields[1], options?.methodId);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.objectId, stream);
        encodeNodeId(this.methodId, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.objectId = decodeNodeId(stream, this.objectId);
        this.methodId = decodeNodeId(stream, this.methodId);
    }
    public get schema(): IStructuredTypeSchema { return schemaActionMethodDataType; }
}
ActionMethodDataType.schema.dataTypeNodeId = ActionMethodDataType.dataTypeNodeId;
ActionMethodDataType.schema.encodingDefaultBinary = ActionMethodDataType.encodingDefaultBinary;
ActionMethodDataType.schema.encodingDefaultXml = ActionMethodDataType.encodingDefaultXml;
ActionMethodDataType.schema.encodingDefaultJson = ActionMethodDataType.encodingDefaultJson;
registerClassDefinition( ActionMethodDataType.dataTypeNodeId, "ActionMethodDataType", ActionMethodDataType);
// --------------------------------------------------------------------------------------------
const schemaActionTargetDataType = buildStructuredType({
    name: "ActionTargetDataType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ActionTargetId",

            fieldType: "UInt16",
        },
        {
            name: "Name",

            fieldType: "String",
        },
        {
            name: "Description",

            fieldType: "LocalizedText",
        },
    ]
});
export interface ActionTargetDataTypeOptions {
    actionTargetId?: UInt16 ;
    name?: UAString ;
    description?: (LocalizedTextLike | null);
}
export class ActionTargetDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaActionTargetDataType; }
    public static possibleFields: string[] = [
          "actionTargetId",
           "name",
           "description"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(0, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(0, 0);
    public static encodingDefaultXml = makeExpandedNodeId(0, 0);
    public static encodingDefaultJson = makeExpandedNodeId(0, 0);
    public actionTargetId: UInt16;
    public name: UAString;
    public description: LocalizedText;

    constructor(options?: ActionTargetDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.actionTargetId = 0;
            this.name = null;
            this.description = new LocalizedText(null);
              return;
        }
        const schema = ActionTargetDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ActionTargetDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.actionTargetId = initialize_field(schema.fields[0], options?.actionTargetId);
        this.name = initialize_field(schema.fields[1], options?.name);
        this.description = initialize_field(schema.fields[2], options?.description);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeUInt16(this.actionTargetId, stream);
        encodeString(this.name, stream);
        encodeLocalizedText(this.description, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.actionTargetId = decodeUInt16(stream, this.actionTargetId);
        this.name = decodeString(stream, this.name);
        this.description = decodeLocalizedText(stream, this.description);
    }
    public get schema(): IStructuredTypeSchema { return schemaActionTargetDataType; }
}
ActionTargetDataType.schema.dataTypeNodeId = ActionTargetDataType.dataTypeNodeId;
ActionTargetDataType.schema.encodingDefaultBinary = ActionTargetDataType.encodingDefaultBinary;
ActionTargetDataType.schema.encodingDefaultXml = ActionTargetDataType.encodingDefaultXml;
ActionTargetDataType.schema.encodingDefaultJson = ActionTargetDataType.encodingDefaultJson;
registerClassDefinition( ActionTargetDataType.dataTypeNodeId, "ActionTargetDataType", ActionTargetDataType);
// --------------------------------------------------------------------------------------------
const schemaRequestHeader = buildStructuredType({
    name: "RequestHeader",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "AuthenticationToken",

            fieldType: "NodeId",
        },
        {
            name: "Timestamp",

            fieldType: "DateTime",
        },
        {
            name: "RequestHandle",

            fieldType: "UInt32",
        },
        {
            name: "ReturnDiagnostics",

            fieldType: "UInt32",
        },
        {
            name: "AuditEntryId",

            fieldType: "String",
        },
        {
            name: "TimeoutHint",

            fieldType: "UInt32",
        },
        {
            name: "AdditionalHeader",

            fieldType: "ExtensionObject",
        },
    ]
});
export interface RequestHeaderOptions {
    authenticationToken?: (NodeIdLike | null);
    timestamp?: DateTime ;
    requestHandle?: UInt32 ;
    returnDiagnostics?: UInt32 ;
    auditEntryId?: UAString ;
    timeoutHint?: UInt32 ;
    additionalHeader?: (ExtensionObject | null);
}
export class RequestHeader extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaRequestHeader; }
    public static possibleFields: string[] = [
          "authenticationToken",
           "timestamp",
           "requestHandle",
           "returnDiagnostics",
           "auditEntryId",
           "timeoutHint",
           "additionalHeader"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(389, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(391, 0);
    public static encodingDefaultXml = makeExpandedNodeId(390, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15088, 0);
    public authenticationToken: NodeId;
    public timestamp: DateTime;
    public requestHandle: UInt32;
    public returnDiagnostics: UInt32;
    public auditEntryId: UAString;
    public timeoutHint: UInt32;
    public additionalHeader: (ExtensionObject | null);

    constructor(options?: RequestHeaderOptions | null) {

        super(options);

        if (options === null) {
            this.authenticationToken = new NodeId(null);
            this.timestamp = new Date();
            this.requestHandle = 0;
            this.returnDiagnostics = 0;
            this.auditEntryId = null;
            this.timeoutHint = 0;
            this.additionalHeader = null;
              return;
        }
        const schema = RequestHeader.schema;
        options = (schema.constructHook ? schema.constructHook(options) as RequestHeaderOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.authenticationToken = initialize_field(schema.fields[0], options?.authenticationToken);
        this.timestamp = initialize_field(schema.fields[1], options?.timestamp);
        this.requestHandle = initialize_field(schema.fields[2], options?.requestHandle);
        this.returnDiagnostics = initialize_field(schema.fields[3], options?.returnDiagnostics);
        this.auditEntryId = initialize_field(schema.fields[4], options?.auditEntryId);
        this.timeoutHint = initialize_field(schema.fields[5], options?.timeoutHint);
        this.additionalHeader = initialize_field(schema.fields[6], options?.additionalHeader);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.authenticationToken, stream);
        encodeDateTime(this.timestamp, stream);
        encodeUInt32(this.requestHandle, stream);
        encodeUInt32(this.returnDiagnostics, stream);
        encodeString(this.auditEntryId, stream);
        encodeUInt32(this.timeoutHint, stream);
        encodeExtensionObject(this.additionalHeader, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.authenticationToken = decodeNodeId(stream, this.authenticationToken);
        this.timestamp = decodeDateTime(stream, this.timestamp);
        this.requestHandle = decodeUInt32(stream, this.requestHandle);
        this.returnDiagnostics = decodeUInt32(stream, this.returnDiagnostics);
        this.auditEntryId = decodeString(stream, this.auditEntryId);
        this.timeoutHint = decodeUInt32(stream, this.timeoutHint);
        this.additionalHeader = decodeExtensionObject(stream, this.additionalHeader);
    }
    public get schema(): IStructuredTypeSchema { return schemaRequestHeader; }
}
RequestHeader.schema.dataTypeNodeId = RequestHeader.dataTypeNodeId;
RequestHeader.schema.encodingDefaultBinary = RequestHeader.encodingDefaultBinary;
RequestHeader.schema.encodingDefaultXml = RequestHeader.encodingDefaultXml;
RequestHeader.schema.encodingDefaultJson = RequestHeader.encodingDefaultJson;
registerClassDefinition( RequestHeader.dataTypeNodeId, "RequestHeader", RequestHeader);
// --------------------------------------------------------------------------------------------
const schemaSignatureData = buildStructuredType({
    name: "SignatureData",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Algorithm",

            fieldType: "String",
        },
        {
            name: "Signature",

            fieldType: "ByteString",
        },
    ]
});
export interface SignatureDataOptions {
    algorithm?: UAString ;
    signature?: ByteString ;
}
export class SignatureData extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaSignatureData; }
    public static possibleFields: string[] = [
          "algorithm",
           "signature"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(456, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(458, 0);
    public static encodingDefaultXml = makeExpandedNodeId(457, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15137, 0);
    public algorithm: UAString;
    public signature: ByteString;

    constructor(options?: SignatureDataOptions | null) {

        super(options);

        if (options === null) {
            this.algorithm = null;
            this.signature = Buffer.alloc(0);
              return;
        }
        const schema = SignatureData.schema;
        options = (schema.constructHook ? schema.constructHook(options) as SignatureDataOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.algorithm = initialize_field(schema.fields[0], options?.algorithm);
        this.signature = initialize_field(schema.fields[1], options?.signature);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.algorithm, stream);
        encodeByteString(this.signature, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.algorithm = decodeString(stream, this.algorithm);
        this.signature = decodeByteString(stream, this.signature);
    }
    public get schema(): IStructuredTypeSchema { return schemaSignatureData; }
}
SignatureData.schema.dataTypeNodeId = SignatureData.dataTypeNodeId;
SignatureData.schema.encodingDefaultBinary = SignatureData.encodingDefaultBinary;
SignatureData.schema.encodingDefaultXml = SignatureData.encodingDefaultXml;
SignatureData.schema.encodingDefaultJson = SignatureData.encodingDefaultJson;
registerClassDefinition( SignatureData.dataTypeNodeId, "SignatureData", SignatureData);
// --------------------------------------------------------------------------------------------
const schemaSignedSoftwareCertificate = buildStructuredType({
    name: "SignedSoftwareCertificate",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "CertificateData",

            fieldType: "ByteString",
        },
        {
            name: "Signature",

            fieldType: "ByteString",
        },
    ]
});
export interface SignedSoftwareCertificateOptions {
    certificateData?: ByteString ;
    signature?: ByteString ;
}
export class SignedSoftwareCertificate extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaSignedSoftwareCertificate; }
    public static possibleFields: string[] = [
          "certificateData",
           "signature"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(344, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(346, 0);
    public static encodingDefaultXml = makeExpandedNodeId(345, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15136, 0);
    public certificateData: ByteString;
    public signature: ByteString;

    constructor(options?: SignedSoftwareCertificateOptions | null) {

        super(options);

        if (options === null) {
            this.certificateData = Buffer.alloc(0);
            this.signature = Buffer.alloc(0);
              return;
        }
        const schema = SignedSoftwareCertificate.schema;
        options = (schema.constructHook ? schema.constructHook(options) as SignedSoftwareCertificateOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.certificateData = initialize_field(schema.fields[0], options?.certificateData);
        this.signature = initialize_field(schema.fields[1], options?.signature);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeByteString(this.certificateData, stream);
        encodeByteString(this.signature, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.certificateData = decodeByteString(stream, this.certificateData);
        this.signature = decodeByteString(stream, this.signature);
    }
    public get schema(): IStructuredTypeSchema { return schemaSignedSoftwareCertificate; }
}
SignedSoftwareCertificate.schema.dataTypeNodeId = SignedSoftwareCertificate.dataTypeNodeId;
SignedSoftwareCertificate.schema.encodingDefaultBinary = SignedSoftwareCertificate.encodingDefaultBinary;
SignedSoftwareCertificate.schema.encodingDefaultXml = SignedSoftwareCertificate.encodingDefaultXml;
SignedSoftwareCertificate.schema.encodingDefaultJson = SignedSoftwareCertificate.encodingDefaultJson;
registerClassDefinition( SignedSoftwareCertificate.dataTypeNodeId, "SignedSoftwareCertificate", SignedSoftwareCertificate);
// --------------------------------------------------------------------------------------------
const schemaActivateSessionRequest = buildStructuredType({
    name: "ActivateSessionRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
        {
            name: "ClientSignature",

            fieldType: "SignatureData",
        },
        {
            name: "ClientSoftwareCertificates",

            fieldType: "SignedSoftwareCertificate",
            isArray: true
        },
        {
            name: "LocaleIds",

            fieldType: "String",
            isArray: true
        },
        {
            name: "UserIdentityToken",

            fieldType: "ExtensionObject",
        },
        {
            name: "UserTokenSignature",

            fieldType: "SignatureData",
        },
    ]
});
export interface ActivateSessionRequestOptions {
    requestHeader?: RequestHeaderOptions ;
    clientSignature?: SignatureDataOptions ;
    clientSoftwareCertificates?: SignedSoftwareCertificateOptions [] | null;
    localeIds?: UAString [] | null;
    userIdentityToken?: (ExtensionObject | null);
    userTokenSignature?: SignatureDataOptions ;
}
export class ActivateSessionRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaActivateSessionRequest; }
    public static possibleFields: string[] = [
          "requestHeader",
           "clientSignature",
           "clientSoftwareCertificates",
           "localeIds",
           "userIdentityToken",
           "userTokenSignature"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(465, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(467, 0);
    public static encodingDefaultXml = makeExpandedNodeId(466, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15145, 0);
    public requestHeader: RequestHeader;
    public clientSignature: SignatureData;
    public clientSoftwareCertificates: SignedSoftwareCertificate[] | null;
    public localeIds: UAString[] | null;
    public userIdentityToken: (ExtensionObject | null);
    public userTokenSignature: SignatureData;

    constructor(options?: ActivateSessionRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
         this.clientSignature =  new SignatureData(null);
         this.clientSoftwareCertificates =  null; /* null array */
            this.localeIds = []
            this.userIdentityToken = null;
         this.userTokenSignature =  new SignatureData(null);
              return;
        }
        const schema = ActivateSessionRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ActivateSessionRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
        this.clientSignature  =  new SignatureData(options.clientSignature);
        this.clientSoftwareCertificates = []; // should default
        if (options.clientSoftwareCertificates) {
            assert(Array.isArray(options.clientSoftwareCertificates));
            this.clientSoftwareCertificates = options.clientSoftwareCertificates.map((e: any) => new SignedSoftwareCertificate(e));
        }
        this.localeIds = initialize_field_array(schema.fields[3], options?.localeIds);
        this.userIdentityToken = initialize_field(schema.fields[4], options?.userIdentityToken);
        this.userTokenSignature  =  new SignatureData(options.userTokenSignature);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        this.clientSignature.encode(stream);
        encodeArray(this.clientSoftwareCertificates, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.localeIds, stream, encodeString);
        encodeExtensionObject(this.userIdentityToken, stream);
        this.userTokenSignature.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.clientSignature.decode(stream);
        this.clientSoftwareCertificates = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new SignedSoftwareCertificate(null);
            obj.decode(stream1);
            return obj;
        });
        this.localeIds = decodeArray(stream, decodeString);
        this.userIdentityToken = decodeExtensionObject(stream, this.userIdentityToken);
        this.userTokenSignature.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaActivateSessionRequest; }
}
ActivateSessionRequest.schema.dataTypeNodeId = ActivateSessionRequest.dataTypeNodeId;
ActivateSessionRequest.schema.encodingDefaultBinary = ActivateSessionRequest.encodingDefaultBinary;
ActivateSessionRequest.schema.encodingDefaultXml = ActivateSessionRequest.encodingDefaultXml;
ActivateSessionRequest.schema.encodingDefaultJson = ActivateSessionRequest.encodingDefaultJson;
registerClassDefinition( ActivateSessionRequest.dataTypeNodeId, "ActivateSessionRequest", ActivateSessionRequest);
// --------------------------------------------------------------------------------------------
const schemaResponseHeader = buildStructuredType({
    name: "ResponseHeader",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Timestamp",

            fieldType: "DateTime",
        },
        {
            name: "RequestHandle",

            fieldType: "UInt32",
        },
        {
            name: "ServiceResult",

            fieldType: "StatusCode",
        },
        {
            name: "ServiceDiagnostics",

            fieldType: "DiagnosticInfo",
        },
        {
            name: "StringTable",

            fieldType: "String",
            isArray: true
        },
        {
            name: "AdditionalHeader",

            fieldType: "ExtensionObject",
        },
    ]
});
export interface ResponseHeaderOptions {
    timestamp?: DateTime ;
    requestHandle?: UInt32 ;
    serviceResult?: StatusCode ;
    serviceDiagnostics?: (DiagnosticInfo | null);
    stringTable?: UAString [] | null;
    additionalHeader?: (ExtensionObject | null);
}
export class ResponseHeader extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaResponseHeader; }
    public static possibleFields: string[] = [
          "timestamp",
           "requestHandle",
           "serviceResult",
           "serviceDiagnostics",
           "stringTable",
           "additionalHeader"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(392, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(394, 0);
    public static encodingDefaultXml = makeExpandedNodeId(393, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15089, 0);
    public timestamp: DateTime;
    public requestHandle: UInt32;
    public serviceResult: StatusCode;
    public serviceDiagnostics: (DiagnosticInfo | null);
    public stringTable: UAString[] | null;
    public additionalHeader: (ExtensionObject | null);

    constructor(options?: ResponseHeaderOptions | null) {

        super(options);

        if (options === null) {
            this.timestamp = new Date();
            this.requestHandle = 0;
            this.serviceResult = StatusCodes.Good;
            this.serviceDiagnostics = null;
            this.stringTable = []
            this.additionalHeader = null;
              return;
        }
        const schema = ResponseHeader.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ResponseHeaderOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.timestamp = initialize_field(schema.fields[0], options?.timestamp);
        this.requestHandle = initialize_field(schema.fields[1], options?.requestHandle);
        this.serviceResult = initialize_field(schema.fields[2], options?.serviceResult);
        this.serviceDiagnostics = initialize_field(schema.fields[3], options?.serviceDiagnostics);
        this.stringTable = initialize_field_array(schema.fields[4], options?.stringTable);
        this.additionalHeader = initialize_field(schema.fields[5], options?.additionalHeader);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeDateTime(this.timestamp, stream);
        encodeUInt32(this.requestHandle, stream);
        encodeStatusCode(this.serviceResult, stream);
        encodeDiagnosticInfo(this.serviceDiagnostics, stream);
        encodeArray(this.stringTable, stream, encodeString);
        encodeExtensionObject(this.additionalHeader, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.timestamp = decodeDateTime(stream, this.timestamp);
        this.requestHandle = decodeUInt32(stream, this.requestHandle);
        this.serviceResult = decodeStatusCode(stream, this.serviceResult);
        this.serviceDiagnostics = decodeDiagnosticInfo(stream, this.serviceDiagnostics);
        this.stringTable = decodeArray(stream, decodeString);
        this.additionalHeader = decodeExtensionObject(stream, this.additionalHeader);
    }
    public get schema(): IStructuredTypeSchema { return schemaResponseHeader; }
}
ResponseHeader.schema.dataTypeNodeId = ResponseHeader.dataTypeNodeId;
ResponseHeader.schema.encodingDefaultBinary = ResponseHeader.encodingDefaultBinary;
ResponseHeader.schema.encodingDefaultXml = ResponseHeader.encodingDefaultXml;
ResponseHeader.schema.encodingDefaultJson = ResponseHeader.encodingDefaultJson;
registerClassDefinition( ResponseHeader.dataTypeNodeId, "ResponseHeader", ResponseHeader);
// --------------------------------------------------------------------------------------------
const schemaActivateSessionResponse = buildStructuredType({
    name: "ActivateSessionResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
        {
            name: "ServerNonce",

            fieldType: "ByteString",
        },
        {
            name: "Results",

            fieldType: "StatusCode",
            isArray: true
        },
        {
            name: "DiagnosticInfos",

            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
export interface ActivateSessionResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
    serverNonce?: ByteString ;
    results?: StatusCode [] | null;
    diagnosticInfos?: (DiagnosticInfo | null)[] | null;
}
export class ActivateSessionResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaActivateSessionResponse; }
    public static possibleFields: string[] = [
          "responseHeader",
           "serverNonce",
           "results",
           "diagnosticInfos"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(468, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(470, 0);
    public static encodingDefaultXml = makeExpandedNodeId(469, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15146, 0);
    public responseHeader: ResponseHeader;
    public serverNonce: ByteString;
    public results: StatusCode[] | null;
    public diagnosticInfos: (DiagnosticInfo | null)[] | null;

    constructor(options?: ActivateSessionResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
            this.serverNonce = Buffer.alloc(0);
            this.results = []
            this.diagnosticInfos = []
              return;
        }
        const schema = ActivateSessionResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ActivateSessionResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
        this.serverNonce = initialize_field(schema.fields[1], options?.serverNonce);
        this.results = initialize_field_array(schema.fields[2], options?.results);
        this.diagnosticInfos = initialize_field_array(schema.fields[3], options?.diagnosticInfos);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        encodeByteString(this.serverNonce, stream);
        encodeArray(this.results, stream, encodeStatusCode);
        encodeArray(this.diagnosticInfos, stream, encodeDiagnosticInfo);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.serverNonce = decodeByteString(stream, this.serverNonce);
        this.results = decodeArray(stream, decodeStatusCode);
        this.diagnosticInfos = decodeArray(stream, decodeDiagnosticInfo);
    }
    public get schema(): IStructuredTypeSchema { return schemaActivateSessionResponse; }
}
ActivateSessionResponse.schema.dataTypeNodeId = ActivateSessionResponse.dataTypeNodeId;
ActivateSessionResponse.schema.encodingDefaultBinary = ActivateSessionResponse.encodingDefaultBinary;
ActivateSessionResponse.schema.encodingDefaultXml = ActivateSessionResponse.encodingDefaultXml;
ActivateSessionResponse.schema.encodingDefaultJson = ActivateSessionResponse.encodingDefaultJson;
registerClassDefinition( ActivateSessionResponse.dataTypeNodeId, "ActivateSessionResponse", ActivateSessionResponse);

// --------------------------------------------------------------------------------------------
export enum NodeClass {
    Unspecified = 0,
    Object = 1,
    Variable = 2,
    Method = 4,
    ObjectType = 8,
    VariableType = 16,
    ReferenceType = 32,
    DataType = 64,
    View = 128
}
const schemaNodeClass = {
    enumValues: NodeClass,
    flaggable: true,
    name: "NodeClass"
};
function decodeNodeClass(stream: BinaryStream, _value?: NodeClass): NodeClass {
    return  stream.readUInt32() as NodeClass;
}
function encodeNodeClass(value: NodeClass, stream: OutputBinaryStream): void {
    stream.writeUInt32(value);
}
export const _enumerationNodeClass = registerEnumeration(schemaNodeClass);
assert(_enumerationNodeClass.isFlaggable ===  true);
// --------------------------------------------------------------------------------------------
const schemaAddNodesItem = buildStructuredType({
    name: "AddNodesItem",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ParentNodeId",

            fieldType: "ExpandedNodeId",
        },
        {
            name: "ReferenceTypeId",

            fieldType: "NodeId",
        },
        {
            name: "RequestedNewNodeId",

            fieldType: "ExpandedNodeId",
        },
        {
            name: "BrowseName",

            fieldType: "QualifiedName",
        },
        {
            name: "NodeClass",

            fieldType: "NodeClass",
        },
        {
            name: "NodeAttributes",

            fieldType: "ExtensionObject",
        },
        {
            name: "TypeDefinition",

            fieldType: "ExpandedNodeId",
        },
    ]
});
export interface AddNodesItemOptions {
    parentNodeId?: ExpandedNodeId ;
    referenceTypeId?: (NodeIdLike | null);
    requestedNewNodeId?: ExpandedNodeId ;
    browseName?: (QualifiedNameLike | null);
    nodeClass?: NodeClass;
    nodeAttributes?: (ExtensionObject | null);
    typeDefinition?: ExpandedNodeId ;
}
export class AddNodesItem extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaAddNodesItem; }
    public static possibleFields: string[] = [
          "parentNodeId",
           "referenceTypeId",
           "requestedNewNodeId",
           "browseName",
           "nodeClass",
           "nodeAttributes",
           "typeDefinition"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(376, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(378, 0);
    public static encodingDefaultXml = makeExpandedNodeId(377, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15165, 0);
    public parentNodeId: ExpandedNodeId;
    public referenceTypeId: NodeId;
    public requestedNewNodeId: ExpandedNodeId;
    public browseName: QualifiedName;
    public nodeClass: NodeClass;
    public nodeAttributes: (ExtensionObject | null);
    public typeDefinition: ExpandedNodeId;

    constructor(options?: AddNodesItemOptions | null) {

        super(options);

        if (options === null) {
            this.parentNodeId = new ExpandedNodeId(null);
            this.referenceTypeId = new NodeId(null);
            this.requestedNewNodeId = new ExpandedNodeId(null);
            this.browseName = new QualifiedName(null);
             this.nodeClass =  0 as  NodeClass;
            this.nodeAttributes = null;
            this.typeDefinition = new ExpandedNodeId(null);
              return;
        }
        const schema = AddNodesItem.schema;
        options = (schema.constructHook ? schema.constructHook(options) as AddNodesItemOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.parentNodeId = initialize_field(schema.fields[0], options?.parentNodeId);
        this.referenceTypeId = initialize_field(schema.fields[1], options?.referenceTypeId);
        this.requestedNewNodeId = initialize_field(schema.fields[2], options?.requestedNewNodeId);
        this.browseName = initialize_field(schema.fields[3], options?.browseName);
        this.nodeClass = this.setNodeClass(initialize_field(schema.fields[4], options?.nodeClass));
        this.nodeAttributes = initialize_field(schema.fields[5], options?.nodeAttributes);
        this.typeDefinition = initialize_field(schema.fields[6], options?.typeDefinition);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeExpandedNodeId(this.parentNodeId, stream);
        encodeNodeId(this.referenceTypeId, stream);
        encodeExpandedNodeId(this.requestedNewNodeId, stream);
        encodeQualifiedName(this.browseName, stream);
        encodeNodeClass(this.nodeClass, stream);
        encodeExtensionObject(this.nodeAttributes, stream);
        encodeExpandedNodeId(this.typeDefinition, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.parentNodeId = decodeExpandedNodeId(stream, this.parentNodeId);
        this.referenceTypeId = decodeNodeId(stream, this.referenceTypeId);
        this.requestedNewNodeId = decodeExpandedNodeId(stream, this.requestedNewNodeId);
        this.browseName = decodeQualifiedName(stream, this.browseName);
        this.nodeClass = decodeNodeClass(stream, this.nodeClass);
        this.nodeAttributes = decodeExtensionObject(stream, this.nodeAttributes);
        this.typeDefinition = decodeExpandedNodeId(stream, this.typeDefinition);
    }

    // Define Enumeration setters
    public setNodeClass(value: any): NodeClass {
        const coercedValue = _enumerationNodeClass.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to NodeClass :" + value);
        }
        this.nodeClass = coercedValue.value as NodeClass;
        return this.nodeClass;
    }
    public get schema(): IStructuredTypeSchema { return schemaAddNodesItem; }
}
AddNodesItem.schema.dataTypeNodeId = AddNodesItem.dataTypeNodeId;
AddNodesItem.schema.encodingDefaultBinary = AddNodesItem.encodingDefaultBinary;
AddNodesItem.schema.encodingDefaultXml = AddNodesItem.encodingDefaultXml;
AddNodesItem.schema.encodingDefaultJson = AddNodesItem.encodingDefaultJson;
registerClassDefinition( AddNodesItem.dataTypeNodeId, "AddNodesItem", AddNodesItem);
// --------------------------------------------------------------------------------------------
const schemaAddNodesRequest = buildStructuredType({
    name: "AddNodesRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
        {
            name: "NodesToAdd",

            fieldType: "AddNodesItem",
            isArray: true
        },
    ]
});
export interface AddNodesRequestOptions {
    requestHeader?: RequestHeaderOptions ;
    nodesToAdd?: AddNodesItemOptions [] | null;
}
export class AddNodesRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaAddNodesRequest; }
    public static possibleFields: string[] = [
          "requestHeader",
           "nodesToAdd"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(486, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(488, 0);
    public static encodingDefaultXml = makeExpandedNodeId(487, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15167, 0);
    public requestHeader: RequestHeader;
    public nodesToAdd: AddNodesItem[] | null;

    constructor(options?: AddNodesRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
         this.nodesToAdd =  null; /* null array */
              return;
        }
        const schema = AddNodesRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as AddNodesRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
        this.nodesToAdd = []; // should default
        if (options.nodesToAdd) {
            assert(Array.isArray(options.nodesToAdd));
            this.nodesToAdd = options.nodesToAdd.map((e: any) => new AddNodesItem(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        encodeArray(this.nodesToAdd, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.nodesToAdd = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new AddNodesItem(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaAddNodesRequest; }
}
AddNodesRequest.schema.dataTypeNodeId = AddNodesRequest.dataTypeNodeId;
AddNodesRequest.schema.encodingDefaultBinary = AddNodesRequest.encodingDefaultBinary;
AddNodesRequest.schema.encodingDefaultXml = AddNodesRequest.encodingDefaultXml;
AddNodesRequest.schema.encodingDefaultJson = AddNodesRequest.encodingDefaultJson;
registerClassDefinition( AddNodesRequest.dataTypeNodeId, "AddNodesRequest", AddNodesRequest);
// --------------------------------------------------------------------------------------------
const schemaAddNodesResult = buildStructuredType({
    name: "AddNodesResult",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "StatusCode",

            fieldType: "StatusCode",
        },
        {
            name: "AddedNodeId",

            fieldType: "NodeId",
        },
    ]
});
export interface AddNodesResultOptions {
    statusCode?: StatusCode ;
    addedNodeId?: (NodeIdLike | null);
}
export class AddNodesResult extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaAddNodesResult; }
    public static possibleFields: string[] = [
          "statusCode",
           "addedNodeId"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(483, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(485, 0);
    public static encodingDefaultXml = makeExpandedNodeId(484, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15166, 0);
    public statusCode: StatusCode;
    public addedNodeId: NodeId;

    constructor(options?: AddNodesResultOptions | null) {

        super(options);

        if (options === null) {
            this.statusCode = StatusCodes.Good;
            this.addedNodeId = new NodeId(null);
              return;
        }
        const schema = AddNodesResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) as AddNodesResultOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.statusCode = initialize_field(schema.fields[0], options?.statusCode);
        this.addedNodeId = initialize_field(schema.fields[1], options?.addedNodeId);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeStatusCode(this.statusCode, stream);
        encodeNodeId(this.addedNodeId, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.statusCode = decodeStatusCode(stream, this.statusCode);
        this.addedNodeId = decodeNodeId(stream, this.addedNodeId);
    }
    public get schema(): IStructuredTypeSchema { return schemaAddNodesResult; }
}
AddNodesResult.schema.dataTypeNodeId = AddNodesResult.dataTypeNodeId;
AddNodesResult.schema.encodingDefaultBinary = AddNodesResult.encodingDefaultBinary;
AddNodesResult.schema.encodingDefaultXml = AddNodesResult.encodingDefaultXml;
AddNodesResult.schema.encodingDefaultJson = AddNodesResult.encodingDefaultJson;
registerClassDefinition( AddNodesResult.dataTypeNodeId, "AddNodesResult", AddNodesResult);
// --------------------------------------------------------------------------------------------
const schemaAddNodesResponse = buildStructuredType({
    name: "AddNodesResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
        {
            name: "Results",

            fieldType: "AddNodesResult",
            isArray: true
        },
        {
            name: "DiagnosticInfos",

            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
export interface AddNodesResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
    results?: AddNodesResultOptions [] | null;
    diagnosticInfos?: (DiagnosticInfo | null)[] | null;
}
export class AddNodesResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaAddNodesResponse; }
    public static possibleFields: string[] = [
          "responseHeader",
           "results",
           "diagnosticInfos"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(489, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(491, 0);
    public static encodingDefaultXml = makeExpandedNodeId(490, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15168, 0);
    public responseHeader: ResponseHeader;
    public results: AddNodesResult[] | null;
    public diagnosticInfos: (DiagnosticInfo | null)[] | null;

    constructor(options?: AddNodesResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
         this.results =  null; /* null array */
            this.diagnosticInfos = []
              return;
        }
        const schema = AddNodesResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as AddNodesResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
        this.results = []; // should default
        if (options.results) {
            assert(Array.isArray(options.results));
            this.results = options.results.map((e: any) => new AddNodesResult(e));
        }
        this.diagnosticInfos = initialize_field_array(schema.fields[2], options?.diagnosticInfos);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        encodeArray(this.results, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.diagnosticInfos, stream, encodeDiagnosticInfo);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new AddNodesResult(null);
            obj.decode(stream1);
            return obj;
        });
        this.diagnosticInfos = decodeArray(stream, decodeDiagnosticInfo);
    }
    public get schema(): IStructuredTypeSchema { return schemaAddNodesResponse; }
}
AddNodesResponse.schema.dataTypeNodeId = AddNodesResponse.dataTypeNodeId;
AddNodesResponse.schema.encodingDefaultBinary = AddNodesResponse.encodingDefaultBinary;
AddNodesResponse.schema.encodingDefaultXml = AddNodesResponse.encodingDefaultXml;
AddNodesResponse.schema.encodingDefaultJson = AddNodesResponse.encodingDefaultJson;
registerClassDefinition( AddNodesResponse.dataTypeNodeId, "AddNodesResponse", AddNodesResponse);
// --------------------------------------------------------------------------------------------
const schemaAddReferencesItem = buildStructuredType({
    name: "AddReferencesItem",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "SourceNodeId",

            fieldType: "NodeId",
        },
        {
            name: "ReferenceTypeId",

            fieldType: "NodeId",
        },
        {
            name: "IsForward",

            fieldType: "Boolean",
        },
        {
            name: "TargetServerUri",

            fieldType: "String",
        },
        {
            name: "TargetNodeId",

            fieldType: "ExpandedNodeId",
        },
        {
            name: "TargetNodeClass",

            fieldType: "NodeClass",
        },
    ]
});
export interface AddReferencesItemOptions {
    sourceNodeId?: (NodeIdLike | null);
    referenceTypeId?: (NodeIdLike | null);
    isForward?: UABoolean ;
    targetServerUri?: UAString ;
    targetNodeId?: ExpandedNodeId ;
    targetNodeClass?: NodeClass;
}
export class AddReferencesItem extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaAddReferencesItem; }
    public static possibleFields: string[] = [
          "sourceNodeId",
           "referenceTypeId",
           "isForward",
           "targetServerUri",
           "targetNodeId",
           "targetNodeClass"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(379, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(381, 0);
    public static encodingDefaultXml = makeExpandedNodeId(380, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15169, 0);
    public sourceNodeId: NodeId;
    public referenceTypeId: NodeId;
    public isForward: UABoolean;
    public targetServerUri: UAString;
    public targetNodeId: ExpandedNodeId;
    public targetNodeClass: NodeClass;

    constructor(options?: AddReferencesItemOptions | null) {

        super(options);

        if (options === null) {
            this.sourceNodeId = new NodeId(null);
            this.referenceTypeId = new NodeId(null);
            this.isForward = false;
            this.targetServerUri = null;
            this.targetNodeId = new ExpandedNodeId(null);
             this.targetNodeClass =  0 as  NodeClass;
              return;
        }
        const schema = AddReferencesItem.schema;
        options = (schema.constructHook ? schema.constructHook(options) as AddReferencesItemOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.sourceNodeId = initialize_field(schema.fields[0], options?.sourceNodeId);
        this.referenceTypeId = initialize_field(schema.fields[1], options?.referenceTypeId);
        this.isForward = initialize_field(schema.fields[2], options?.isForward);
        this.targetServerUri = initialize_field(schema.fields[3], options?.targetServerUri);
        this.targetNodeId = initialize_field(schema.fields[4], options?.targetNodeId);
        this.targetNodeClass = this.setTargetNodeClass(initialize_field(schema.fields[5], options?.targetNodeClass));
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.sourceNodeId, stream);
        encodeNodeId(this.referenceTypeId, stream);
        encodeBoolean(this.isForward, stream);
        encodeString(this.targetServerUri, stream);
        encodeExpandedNodeId(this.targetNodeId, stream);
        encodeNodeClass(this.targetNodeClass, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.sourceNodeId = decodeNodeId(stream, this.sourceNodeId);
        this.referenceTypeId = decodeNodeId(stream, this.referenceTypeId);
        this.isForward = decodeBoolean(stream, this.isForward);
        this.targetServerUri = decodeString(stream, this.targetServerUri);
        this.targetNodeId = decodeExpandedNodeId(stream, this.targetNodeId);
        this.targetNodeClass = decodeNodeClass(stream, this.targetNodeClass);
    }

    // Define Enumeration setters
    public setTargetNodeClass(value: any): NodeClass {
        const coercedValue = _enumerationNodeClass.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to NodeClass :" + value);
        }
        this.targetNodeClass = coercedValue.value as NodeClass;
        return this.targetNodeClass;
    }
    public get schema(): IStructuredTypeSchema { return schemaAddReferencesItem; }
}
AddReferencesItem.schema.dataTypeNodeId = AddReferencesItem.dataTypeNodeId;
AddReferencesItem.schema.encodingDefaultBinary = AddReferencesItem.encodingDefaultBinary;
AddReferencesItem.schema.encodingDefaultXml = AddReferencesItem.encodingDefaultXml;
AddReferencesItem.schema.encodingDefaultJson = AddReferencesItem.encodingDefaultJson;
registerClassDefinition( AddReferencesItem.dataTypeNodeId, "AddReferencesItem", AddReferencesItem);
// --------------------------------------------------------------------------------------------
const schemaAddReferencesRequest = buildStructuredType({
    name: "AddReferencesRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
        {
            name: "ReferencesToAdd",

            fieldType: "AddReferencesItem",
            isArray: true
        },
    ]
});
export interface AddReferencesRequestOptions {
    requestHeader?: RequestHeaderOptions ;
    referencesToAdd?: AddReferencesItemOptions [] | null;
}
export class AddReferencesRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaAddReferencesRequest; }
    public static possibleFields: string[] = [
          "requestHeader",
           "referencesToAdd"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(492, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(494, 0);
    public static encodingDefaultXml = makeExpandedNodeId(493, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15170, 0);
    public requestHeader: RequestHeader;
    public referencesToAdd: AddReferencesItem[] | null;

    constructor(options?: AddReferencesRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
         this.referencesToAdd =  null; /* null array */
              return;
        }
        const schema = AddReferencesRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as AddReferencesRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
        this.referencesToAdd = []; // should default
        if (options.referencesToAdd) {
            assert(Array.isArray(options.referencesToAdd));
            this.referencesToAdd = options.referencesToAdd.map((e: any) => new AddReferencesItem(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        encodeArray(this.referencesToAdd, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.referencesToAdd = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new AddReferencesItem(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaAddReferencesRequest; }
}
AddReferencesRequest.schema.dataTypeNodeId = AddReferencesRequest.dataTypeNodeId;
AddReferencesRequest.schema.encodingDefaultBinary = AddReferencesRequest.encodingDefaultBinary;
AddReferencesRequest.schema.encodingDefaultXml = AddReferencesRequest.encodingDefaultXml;
AddReferencesRequest.schema.encodingDefaultJson = AddReferencesRequest.encodingDefaultJson;
registerClassDefinition( AddReferencesRequest.dataTypeNodeId, "AddReferencesRequest", AddReferencesRequest);
// --------------------------------------------------------------------------------------------
const schemaAddReferencesResponse = buildStructuredType({
    name: "AddReferencesResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
        {
            name: "Results",

            fieldType: "StatusCode",
            isArray: true
        },
        {
            name: "DiagnosticInfos",

            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
export interface AddReferencesResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
    results?: StatusCode [] | null;
    diagnosticInfos?: (DiagnosticInfo | null)[] | null;
}
export class AddReferencesResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaAddReferencesResponse; }
    public static possibleFields: string[] = [
          "responseHeader",
           "results",
           "diagnosticInfos"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(495, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(497, 0);
    public static encodingDefaultXml = makeExpandedNodeId(496, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15171, 0);
    public responseHeader: ResponseHeader;
    public results: StatusCode[] | null;
    public diagnosticInfos: (DiagnosticInfo | null)[] | null;

    constructor(options?: AddReferencesResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
            this.results = []
            this.diagnosticInfos = []
              return;
        }
        const schema = AddReferencesResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as AddReferencesResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
        this.results = initialize_field_array(schema.fields[1], options?.results);
        this.diagnosticInfos = initialize_field_array(schema.fields[2], options?.diagnosticInfos);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        encodeArray(this.results, stream, encodeStatusCode);
        encodeArray(this.diagnosticInfos, stream, encodeDiagnosticInfo);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = decodeArray(stream, decodeStatusCode);
        this.diagnosticInfos = decodeArray(stream, decodeDiagnosticInfo);
    }
    public get schema(): IStructuredTypeSchema { return schemaAddReferencesResponse; }
}
AddReferencesResponse.schema.dataTypeNodeId = AddReferencesResponse.dataTypeNodeId;
AddReferencesResponse.schema.encodingDefaultBinary = AddReferencesResponse.encodingDefaultBinary;
AddReferencesResponse.schema.encodingDefaultXml = AddReferencesResponse.encodingDefaultXml;
AddReferencesResponse.schema.encodingDefaultJson = AddReferencesResponse.encodingDefaultJson;
registerClassDefinition( AddReferencesResponse.dataTypeNodeId, "AddReferencesResponse", AddReferencesResponse);
// --------------------------------------------------------------------------------------------
const schemaKeyValuePair = buildStructuredType({
    name: "KeyValuePair",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Key",

            fieldType: "QualifiedName",
        },
        {
            name: "Value",

            fieldType: "Variant",
        },
    ]
});
export interface KeyValuePairOptions {
    key?: (QualifiedNameLike | null);
    value?: (VariantLike | null);
}
export class KeyValuePair extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaKeyValuePair; }
    public static possibleFields: string[] = [
          "key",
           "value"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(14533, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(14846, 0);
    public static encodingDefaultXml = makeExpandedNodeId(14802, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15041, 0);
    public key: QualifiedName;
    public value: Variant;

    constructor(options?: KeyValuePairOptions | null) {

        super(options);

        if (options === null) {
            this.key = new QualifiedName(null);
            this.value = new Variant(null);
              return;
        }
        const schema = KeyValuePair.schema;
        options = (schema.constructHook ? schema.constructHook(options) as KeyValuePairOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.key = initialize_field(schema.fields[0], options?.key);
        this.value = initialize_field(schema.fields[1], options?.value);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeQualifiedName(this.key, stream);
        encodeVariant(this.value, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.key = decodeQualifiedName(stream, this.key);
        this.value = decodeVariant(stream, this.value);
    }
    public get schema(): IStructuredTypeSchema { return schemaKeyValuePair; }
}
KeyValuePair.schema.dataTypeNodeId = KeyValuePair.dataTypeNodeId;
KeyValuePair.schema.encodingDefaultBinary = KeyValuePair.encodingDefaultBinary;
KeyValuePair.schema.encodingDefaultXml = KeyValuePair.encodingDefaultXml;
KeyValuePair.schema.encodingDefaultJson = KeyValuePair.encodingDefaultJson;
registerClassDefinition( KeyValuePair.dataTypeNodeId, "KeyValuePair", KeyValuePair);
// --------------------------------------------------------------------------------------------
const schemaAdditionalParametersType = buildStructuredType({
    name: "AdditionalParametersType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Parameters",

            fieldType: "KeyValuePair",
            isArray: true
        },
    ]
});
export interface AdditionalParametersTypeOptions {
    parameters?: KeyValuePairOptions [] | null;
}
export class AdditionalParametersType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaAdditionalParametersType; }
    public static possibleFields: string[] = [
          "parameters"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(16313, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(17537, 0);
    public static encodingDefaultXml = makeExpandedNodeId(17541, 0);
    public static encodingDefaultJson = makeExpandedNodeId(17547, 0);
    public parameters: KeyValuePair[] | null;

    constructor(options?: AdditionalParametersTypeOptions | null) {

        super(options);

        if (options === null) {
         this.parameters =  null; /* null array */
              return;
        }
        const schema = AdditionalParametersType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as AdditionalParametersTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.parameters = []; // should default
        if (options.parameters) {
            assert(Array.isArray(options.parameters));
            this.parameters = options.parameters.map((e: any) => new KeyValuePair(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeArray(this.parameters, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.parameters = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new KeyValuePair(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaAdditionalParametersType; }
}
AdditionalParametersType.schema.dataTypeNodeId = AdditionalParametersType.dataTypeNodeId;
AdditionalParametersType.schema.encodingDefaultBinary = AdditionalParametersType.encodingDefaultBinary;
AdditionalParametersType.schema.encodingDefaultXml = AdditionalParametersType.encodingDefaultXml;
AdditionalParametersType.schema.encodingDefaultJson = AdditionalParametersType.encodingDefaultJson;
registerClassDefinition( AdditionalParametersType.dataTypeNodeId, "AdditionalParametersType", AdditionalParametersType);
// --------------------------------------------------------------------------------------------
const schemaAggregateConfiguration = buildStructuredType({
    name: "AggregateConfiguration",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "UseServerCapabilitiesDefaults",

            fieldType: "Boolean",
        },
        {
            name: "TreatUncertainAsBad",

            fieldType: "Boolean",
        },
        {
            name: "PercentDataBad",

            fieldType: "Byte",
        },
        {
            name: "PercentDataGood",

            fieldType: "Byte",
        },
        {
            name: "UseSlopedExtrapolation",

            fieldType: "Boolean",
        },
    ]
});
export interface AggregateConfigurationOptions {
    useServerCapabilitiesDefaults?: UABoolean ;
    treatUncertainAsBad?: UABoolean ;
    percentDataBad?: Byte ;
    percentDataGood?: Byte ;
    useSlopedExtrapolation?: UABoolean ;
}
export class AggregateConfiguration extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaAggregateConfiguration; }
    public static possibleFields: string[] = [
          "useServerCapabilitiesDefaults",
           "treatUncertainAsBad",
           "percentDataBad",
           "percentDataGood",
           "useSlopedExtrapolation"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(948, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(950, 0);
    public static encodingDefaultXml = makeExpandedNodeId(949, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15304, 0);
    public useServerCapabilitiesDefaults: UABoolean;
    public treatUncertainAsBad: UABoolean;
    public percentDataBad: Byte;
    public percentDataGood: Byte;
    public useSlopedExtrapolation: UABoolean;

    constructor(options?: AggregateConfigurationOptions | null) {

        super(options);

        if (options === null) {
            this.useServerCapabilitiesDefaults = false;
            this.treatUncertainAsBad = false;
            this.percentDataBad = 0;
            this.percentDataGood = 0;
            this.useSlopedExtrapolation = false;
              return;
        }
        const schema = AggregateConfiguration.schema;
        options = (schema.constructHook ? schema.constructHook(options) as AggregateConfigurationOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.useServerCapabilitiesDefaults = initialize_field(schema.fields[0], options?.useServerCapabilitiesDefaults);
        this.treatUncertainAsBad = initialize_field(schema.fields[1], options?.treatUncertainAsBad);
        this.percentDataBad = initialize_field(schema.fields[2], options?.percentDataBad);
        this.percentDataGood = initialize_field(schema.fields[3], options?.percentDataGood);
        this.useSlopedExtrapolation = initialize_field(schema.fields[4], options?.useSlopedExtrapolation);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeBoolean(this.useServerCapabilitiesDefaults, stream);
        encodeBoolean(this.treatUncertainAsBad, stream);
        encodeByte(this.percentDataBad, stream);
        encodeByte(this.percentDataGood, stream);
        encodeBoolean(this.useSlopedExtrapolation, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.useServerCapabilitiesDefaults = decodeBoolean(stream, this.useServerCapabilitiesDefaults);
        this.treatUncertainAsBad = decodeBoolean(stream, this.treatUncertainAsBad);
        this.percentDataBad = decodeByte(stream, this.percentDataBad);
        this.percentDataGood = decodeByte(stream, this.percentDataGood);
        this.useSlopedExtrapolation = decodeBoolean(stream, this.useSlopedExtrapolation);
    }
    public get schema(): IStructuredTypeSchema { return schemaAggregateConfiguration; }
}
AggregateConfiguration.schema.dataTypeNodeId = AggregateConfiguration.dataTypeNodeId;
AggregateConfiguration.schema.encodingDefaultBinary = AggregateConfiguration.encodingDefaultBinary;
AggregateConfiguration.schema.encodingDefaultXml = AggregateConfiguration.encodingDefaultXml;
AggregateConfiguration.schema.encodingDefaultJson = AggregateConfiguration.encodingDefaultJson;
registerClassDefinition( AggregateConfiguration.dataTypeNodeId, "AggregateConfiguration", AggregateConfiguration);
// --------------------------------------------------------------------------------------------
const schemaMonitoringFilter = buildStructuredType({
    name: "MonitoringFilter",

    baseType: "ExtensionObject",
    fields: [
    ]
});
export interface MonitoringFilterOptions {
}
export class MonitoringFilter extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaMonitoringFilter; }
    public static possibleFields: string[] = [
          
    ];
    public static dataTypeNodeId = makeExpandedNodeId(719, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(721, 0);
    public static encodingDefaultXml = makeExpandedNodeId(720, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15293, 0);

    constructor(options?: MonitoringFilterOptions | null) {

        super(options);

        if (options === null) {
              return;
        }
        const schema = MonitoringFilter.schema;
        options = (schema.constructHook ? schema.constructHook(options) as MonitoringFilterOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaMonitoringFilter; }
}
MonitoringFilter.schema.dataTypeNodeId = MonitoringFilter.dataTypeNodeId;
MonitoringFilter.schema.encodingDefaultBinary = MonitoringFilter.encodingDefaultBinary;
MonitoringFilter.schema.encodingDefaultXml = MonitoringFilter.encodingDefaultXml;
MonitoringFilter.schema.encodingDefaultJson = MonitoringFilter.encodingDefaultJson;
registerClassDefinition( MonitoringFilter.dataTypeNodeId, "MonitoringFilter", MonitoringFilter);
// --------------------------------------------------------------------------------------------
const schemaAggregateFilter = buildStructuredType({
    name: "AggregateFilter",

    baseType: "MonitoringFilter",
    fields: [
        {
            name: "StartTime",

            fieldType: "DateTime",
        },
        {
            name: "AggregateType",

            fieldType: "NodeId",
        },
        {
            name: "ProcessingInterval",

            fieldType: "Double",
        },
        {
            name: "AggregateConfiguration",

            fieldType: "AggregateConfiguration",
        },
    ]
});
export interface AggregateFilterOptions extends MonitoringFilterOptions {
    startTime?: DateTime ;
    aggregateType?: (NodeIdLike | null);
    processingInterval?: Double ;
    aggregateConfiguration?: AggregateConfigurationOptions ;
}
export class AggregateFilter extends MonitoringFilter {
    public static get schema(): IStructuredTypeSchema { return schemaAggregateFilter; }
    public static possibleFields: string[] = [
          "startTime",
           "aggregateType",
           "processingInterval",
           "aggregateConfiguration"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(728, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(730, 0);
    public static encodingDefaultXml = makeExpandedNodeId(729, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15312, 0);
    public startTime: DateTime;
    public aggregateType: NodeId;
    public processingInterval: Double;
    public aggregateConfiguration: AggregateConfiguration;

    constructor(options?: AggregateFilterOptions | null) {

        super(options);

        if (options === null) {
            this.startTime = new Date();
            this.aggregateType = new NodeId(null);
            this.processingInterval = 0;
         this.aggregateConfiguration =  new AggregateConfiguration(null);
              return;
        }
        const schema = AggregateFilter.schema;
        options = (schema.constructHook ? schema.constructHook(options) as AggregateFilterOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.startTime = initialize_field(schema.fields[0], options?.startTime);
        this.aggregateType = initialize_field(schema.fields[1], options?.aggregateType);
        this.processingInterval = initialize_field(schema.fields[2], options?.processingInterval);
        this.aggregateConfiguration  =  new AggregateConfiguration(options.aggregateConfiguration);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeDateTime(this.startTime, stream);
        encodeNodeId(this.aggregateType, stream);
        encodeDouble(this.processingInterval, stream);
        this.aggregateConfiguration.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.startTime = decodeDateTime(stream, this.startTime);
        this.aggregateType = decodeNodeId(stream, this.aggregateType);
        this.processingInterval = decodeDouble(stream, this.processingInterval);
        this.aggregateConfiguration.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaAggregateFilter; }
}
AggregateFilter.schema.dataTypeNodeId = AggregateFilter.dataTypeNodeId;
AggregateFilter.schema.encodingDefaultBinary = AggregateFilter.encodingDefaultBinary;
AggregateFilter.schema.encodingDefaultXml = AggregateFilter.encodingDefaultXml;
AggregateFilter.schema.encodingDefaultJson = AggregateFilter.encodingDefaultJson;
registerClassDefinition( AggregateFilter.dataTypeNodeId, "AggregateFilter", AggregateFilter);
// --------------------------------------------------------------------------------------------
const schemaMonitoringFilterResult = buildStructuredType({
    name: "MonitoringFilterResult",

    baseType: "ExtensionObject",
    fields: [
    ]
});
export interface MonitoringFilterResultOptions {
}
export class MonitoringFilterResult extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaMonitoringFilterResult; }
    public static possibleFields: string[] = [
          
    ];
    public static dataTypeNodeId = makeExpandedNodeId(731, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(733, 0);
    public static encodingDefaultXml = makeExpandedNodeId(732, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15313, 0);

    constructor(options?: MonitoringFilterResultOptions | null) {

        super(options);

        if (options === null) {
              return;
        }
        const schema = MonitoringFilterResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) as MonitoringFilterResultOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaMonitoringFilterResult; }
}
MonitoringFilterResult.schema.dataTypeNodeId = MonitoringFilterResult.dataTypeNodeId;
MonitoringFilterResult.schema.encodingDefaultBinary = MonitoringFilterResult.encodingDefaultBinary;
MonitoringFilterResult.schema.encodingDefaultXml = MonitoringFilterResult.encodingDefaultXml;
MonitoringFilterResult.schema.encodingDefaultJson = MonitoringFilterResult.encodingDefaultJson;
registerClassDefinition( MonitoringFilterResult.dataTypeNodeId, "MonitoringFilterResult", MonitoringFilterResult);
// --------------------------------------------------------------------------------------------
const schemaAggregateFilterResult = buildStructuredType({
    name: "AggregateFilterResult",

    baseType: "MonitoringFilterResult",
    fields: [
        {
            name: "RevisedStartTime",

            fieldType: "DateTime",
        },
        {
            name: "RevisedProcessingInterval",

            fieldType: "Double",
        },
        {
            name: "RevisedAggregateConfiguration",

            fieldType: "AggregateConfiguration",
        },
    ]
});
export interface AggregateFilterResultOptions extends MonitoringFilterResultOptions {
    revisedStartTime?: DateTime ;
    revisedProcessingInterval?: Double ;
    revisedAggregateConfiguration?: AggregateConfigurationOptions ;
}
export class AggregateFilterResult extends MonitoringFilterResult {
    public static get schema(): IStructuredTypeSchema { return schemaAggregateFilterResult; }
    public static possibleFields: string[] = [
          "revisedStartTime",
           "revisedProcessingInterval",
           "revisedAggregateConfiguration"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(737, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(739, 0);
    public static encodingDefaultXml = makeExpandedNodeId(738, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15315, 0);
    public revisedStartTime: DateTime;
    public revisedProcessingInterval: Double;
    public revisedAggregateConfiguration: AggregateConfiguration;

    constructor(options?: AggregateFilterResultOptions | null) {

        super(options);

        if (options === null) {
            this.revisedStartTime = new Date();
            this.revisedProcessingInterval = 0;
         this.revisedAggregateConfiguration =  new AggregateConfiguration(null);
              return;
        }
        const schema = AggregateFilterResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) as AggregateFilterResultOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.revisedStartTime = initialize_field(schema.fields[0], options?.revisedStartTime);
        this.revisedProcessingInterval = initialize_field(schema.fields[1], options?.revisedProcessingInterval);
        this.revisedAggregateConfiguration  =  new AggregateConfiguration(options.revisedAggregateConfiguration);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeDateTime(this.revisedStartTime, stream);
        encodeDouble(this.revisedProcessingInterval, stream);
        this.revisedAggregateConfiguration.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.revisedStartTime = decodeDateTime(stream, this.revisedStartTime);
        this.revisedProcessingInterval = decodeDouble(stream, this.revisedProcessingInterval);
        this.revisedAggregateConfiguration.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaAggregateFilterResult; }
}
AggregateFilterResult.schema.dataTypeNodeId = AggregateFilterResult.dataTypeNodeId;
AggregateFilterResult.schema.encodingDefaultBinary = AggregateFilterResult.encodingDefaultBinary;
AggregateFilterResult.schema.encodingDefaultXml = AggregateFilterResult.encodingDefaultXml;
AggregateFilterResult.schema.encodingDefaultJson = AggregateFilterResult.encodingDefaultJson;
registerClassDefinition( AggregateFilterResult.dataTypeNodeId, "AggregateFilterResult", AggregateFilterResult);
// --------------------------------------------------------------------------------------------
const schemaAliasNameDataType = buildStructuredType({
    name: "AliasNameDataType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "AliasName",

            fieldType: "QualifiedName",
        },
        {
            name: "ReferencedNodes",

            fieldType: "ExpandedNodeId",
            isArray: true
        },
    ]
});
export interface AliasNameDataTypeOptions {
    aliasName?: (QualifiedNameLike | null);
    referencedNodes?: ExpandedNodeId [] | null;
}
export class AliasNameDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaAliasNameDataType; }
    public static possibleFields: string[] = [
          "aliasName",
           "referencedNodes"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(23468, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(23499, 0);
    public static encodingDefaultXml = makeExpandedNodeId(23505, 0);
    public static encodingDefaultJson = makeExpandedNodeId(23511, 0);
    public aliasName: QualifiedName;
    public referencedNodes: ExpandedNodeId[] | null;

    constructor(options?: AliasNameDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.aliasName = new QualifiedName(null);
            this.referencedNodes = []
              return;
        }
        const schema = AliasNameDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as AliasNameDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.aliasName = initialize_field(schema.fields[0], options?.aliasName);
        this.referencedNodes = initialize_field_array(schema.fields[1], options?.referencedNodes);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeQualifiedName(this.aliasName, stream);
        encodeArray(this.referencedNodes, stream, encodeExpandedNodeId);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.aliasName = decodeQualifiedName(stream, this.aliasName);
        this.referencedNodes = decodeArray(stream, decodeExpandedNodeId);
    }
    public get schema(): IStructuredTypeSchema { return schemaAliasNameDataType; }
}
AliasNameDataType.schema.dataTypeNodeId = AliasNameDataType.dataTypeNodeId;
AliasNameDataType.schema.encodingDefaultBinary = AliasNameDataType.encodingDefaultBinary;
AliasNameDataType.schema.encodingDefaultXml = AliasNameDataType.encodingDefaultXml;
AliasNameDataType.schema.encodingDefaultJson = AliasNameDataType.encodingDefaultJson;
registerClassDefinition( AliasNameDataType.dataTypeNodeId, "AliasNameDataType", AliasNameDataType);
// --------------------------------------------------------------------------------------------
const schemaAnnotation = buildStructuredType({
    name: "Annotation",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Message",

            fieldType: "String",
        },
        {
            name: "UserName",

            fieldType: "String",
        },
        {
            name: "AnnotationTime",

            fieldType: "DateTime",
        },
    ]
});
export interface AnnotationOptions {
    message?: UAString ;
    userName?: UAString ;
    annotationTime?: DateTime ;
}
export class Annotation extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaAnnotation; }
    public static possibleFields: string[] = [
          "message",
           "userName",
           "annotationTime"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(891, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(893, 0);
    public static encodingDefaultXml = makeExpandedNodeId(892, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15382, 0);
    public message: UAString;
    public userName: UAString;
    public annotationTime: DateTime;

    constructor(options?: AnnotationOptions | null) {

        super(options);

        if (options === null) {
            this.message = null;
            this.userName = null;
            this.annotationTime = new Date();
              return;
        }
        const schema = Annotation.schema;
        options = (schema.constructHook ? schema.constructHook(options) as AnnotationOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.message = initialize_field(schema.fields[0], options?.message);
        this.userName = initialize_field(schema.fields[1], options?.userName);
        this.annotationTime = initialize_field(schema.fields[2], options?.annotationTime);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.message, stream);
        encodeString(this.userName, stream);
        encodeDateTime(this.annotationTime, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.message = decodeString(stream, this.message);
        this.userName = decodeString(stream, this.userName);
        this.annotationTime = decodeDateTime(stream, this.annotationTime);
    }
    public get schema(): IStructuredTypeSchema { return schemaAnnotation; }
}
Annotation.schema.dataTypeNodeId = Annotation.dataTypeNodeId;
Annotation.schema.encodingDefaultBinary = Annotation.encodingDefaultBinary;
Annotation.schema.encodingDefaultXml = Annotation.encodingDefaultXml;
Annotation.schema.encodingDefaultJson = Annotation.encodingDefaultJson;
registerClassDefinition( Annotation.dataTypeNodeId, "Annotation", Annotation);
// --------------------------------------------------------------------------------------------
const schemaAnnotationDataType = buildStructuredType({
    name: "AnnotationDataType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Annotation",

            fieldType: "String",
        },
        {
            name: "Discipline",

            fieldType: "String",
        },
        {
            name: "Uri",

            fieldType: "String",
        },
    ]
});
export interface AnnotationDataTypeOptions {
    annotation?: UAString ;
    discipline?: UAString ;
    uri?: UAString ;
}
export class AnnotationDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaAnnotationDataType; }
    public static possibleFields: string[] = [
          "annotation",
           "discipline",
           "uri"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(32434, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(32560, 0);
    public static encodingDefaultXml = makeExpandedNodeId(32572, 0);
    public static encodingDefaultJson = makeExpandedNodeId(32584, 0);
    public annotation: UAString;
    public discipline: UAString;
    public uri: UAString;

    constructor(options?: AnnotationDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.annotation = null;
            this.discipline = null;
            this.uri = null;
              return;
        }
        const schema = AnnotationDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as AnnotationDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.annotation = initialize_field(schema.fields[0], options?.annotation);
        this.discipline = initialize_field(schema.fields[1], options?.discipline);
        this.uri = initialize_field(schema.fields[2], options?.uri);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.annotation, stream);
        encodeString(this.discipline, stream);
        encodeString(this.uri, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.annotation = decodeString(stream, this.annotation);
        this.discipline = decodeString(stream, this.discipline);
        this.uri = decodeString(stream, this.uri);
    }
    public get schema(): IStructuredTypeSchema { return schemaAnnotationDataType; }
}
AnnotationDataType.schema.dataTypeNodeId = AnnotationDataType.dataTypeNodeId;
AnnotationDataType.schema.encodingDefaultBinary = AnnotationDataType.encodingDefaultBinary;
AnnotationDataType.schema.encodingDefaultXml = AnnotationDataType.encodingDefaultXml;
AnnotationDataType.schema.encodingDefaultJson = AnnotationDataType.encodingDefaultJson;
registerClassDefinition( AnnotationDataType.dataTypeNodeId, "AnnotationDataType", AnnotationDataType);
// --------------------------------------------------------------------------------------------
const schemaUserIdentityToken = buildStructuredType({
    name: "UserIdentityToken",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "PolicyId",

            fieldType: "String",
        },
    ]
});
export interface UserIdentityTokenOptions {
    policyId?: UAString ;
}
export class UserIdentityToken extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaUserIdentityToken; }
    public static possibleFields: string[] = [
          "policyId"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(316, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(318, 0);
    public static encodingDefaultXml = makeExpandedNodeId(317, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15140, 0);
    public policyId: UAString;

    constructor(options?: UserIdentityTokenOptions | null) {

        super(options);

        if (options === null) {
            this.policyId = null;
              return;
        }
        const schema = UserIdentityToken.schema;
        options = (schema.constructHook ? schema.constructHook(options) as UserIdentityTokenOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.policyId = initialize_field(schema.fields[0], options?.policyId);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.policyId, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.policyId = decodeString(stream, this.policyId);
    }
    public get schema(): IStructuredTypeSchema { return schemaUserIdentityToken; }
}
UserIdentityToken.schema.dataTypeNodeId = UserIdentityToken.dataTypeNodeId;
UserIdentityToken.schema.encodingDefaultBinary = UserIdentityToken.encodingDefaultBinary;
UserIdentityToken.schema.encodingDefaultXml = UserIdentityToken.encodingDefaultXml;
UserIdentityToken.schema.encodingDefaultJson = UserIdentityToken.encodingDefaultJson;
registerClassDefinition( UserIdentityToken.dataTypeNodeId, "UserIdentityToken", UserIdentityToken);
// --------------------------------------------------------------------------------------------
const schemaAnonymousIdentityToken = buildStructuredType({
    name: "AnonymousIdentityToken",

    baseType: "UserIdentityToken",
    fields: [
    ]
});
export interface AnonymousIdentityTokenOptions extends UserIdentityTokenOptions {
}
export class AnonymousIdentityToken extends UserIdentityToken {
    public static get schema(): IStructuredTypeSchema { return schemaAnonymousIdentityToken; }
    public static possibleFields: string[] = [
          "policyId"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(319, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(321, 0);
    public static encodingDefaultXml = makeExpandedNodeId(320, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15141, 0);

    constructor(options?: AnonymousIdentityTokenOptions | null) {

        super(options);

        if (options === null) {
              return;
        }
        const schema = AnonymousIdentityToken.schema;
        options = (schema.constructHook ? schema.constructHook(options) as AnonymousIdentityTokenOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaAnonymousIdentityToken; }
}
AnonymousIdentityToken.schema.dataTypeNodeId = AnonymousIdentityToken.dataTypeNodeId;
AnonymousIdentityToken.schema.encodingDefaultBinary = AnonymousIdentityToken.encodingDefaultBinary;
AnonymousIdentityToken.schema.encodingDefaultXml = AnonymousIdentityToken.encodingDefaultXml;
AnonymousIdentityToken.schema.encodingDefaultJson = AnonymousIdentityToken.encodingDefaultJson;
registerClassDefinition( AnonymousIdentityToken.dataTypeNodeId, "AnonymousIdentityToken", AnonymousIdentityToken);

// --------------------------------------------------------------------------------------------
export enum ApplicationType {
    Server = 0,
    Client = 1,
    ClientAndServer = 2,
    DiscoveryServer = 3,
    Invalid = 4294967295
}
const schemaApplicationType = {
    enumValues: ApplicationType,
    flaggable: false,
    minValue: 0,
    maxValue: 3,
    name: "ApplicationType"
};
function decodeApplicationType(stream: BinaryStream, _value?: ApplicationType): ApplicationType {
    let value =  stream.readUInt32() as ApplicationType;
    value = (value < schemaApplicationType.minValue || value > schemaApplicationType.maxValue) ? ApplicationType.Invalid : value; 
    return value;
}
function encodeApplicationType(value: ApplicationType, stream: OutputBinaryStream): void {
    stream.writeUInt32(value);
}
export const _enumerationApplicationType = registerEnumeration(schemaApplicationType);
assert(_enumerationApplicationType.isFlaggable ===  false);
// --------------------------------------------------------------------------------------------
const schemaApplicationDescription = buildStructuredType({
    name: "ApplicationDescription",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ApplicationUri",

            fieldType: "String",
        },
        {
            name: "ProductUri",

            fieldType: "String",
        },
        {
            name: "ApplicationName",

            fieldType: "LocalizedText",
        },
        {
            name: "ApplicationType",

            fieldType: "ApplicationType",
        },
        {
            name: "GatewayServerUri",

            fieldType: "String",
        },
        {
            name: "DiscoveryProfileUri",

            fieldType: "String",
        },
        {
            name: "DiscoveryUrls",

            fieldType: "String",
            isArray: true
        },
    ]
});
export interface ApplicationDescriptionOptions {
    applicationUri?: UAString ;
    productUri?: UAString ;
    applicationName?: (LocalizedTextLike | null);
    applicationType?: ApplicationType;
    gatewayServerUri?: UAString ;
    discoveryProfileUri?: UAString ;
    discoveryUrls?: UAString [] | null;
}
export class ApplicationDescription extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaApplicationDescription; }
    public static possibleFields: string[] = [
          "applicationUri",
           "productUri",
           "applicationName",
           "applicationType",
           "gatewayServerUri",
           "discoveryProfileUri",
           "discoveryUrls"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(308, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(310, 0);
    public static encodingDefaultXml = makeExpandedNodeId(309, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15087, 0);
    public applicationUri: UAString;
    public productUri: UAString;
    public applicationName: LocalizedText;
    public applicationType: ApplicationType;
    public gatewayServerUri: UAString;
    public discoveryProfileUri: UAString;
    public discoveryUrls: UAString[] | null;

    constructor(options?: ApplicationDescriptionOptions | null) {

        super(options);

        if (options === null) {
            this.applicationUri = null;
            this.productUri = null;
            this.applicationName = new LocalizedText(null);
             this.applicationType =  0 as  ApplicationType;
            this.gatewayServerUri = null;
            this.discoveryProfileUri = null;
            this.discoveryUrls = []
              return;
        }
        const schema = ApplicationDescription.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ApplicationDescriptionOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.applicationUri = initialize_field(schema.fields[0], options?.applicationUri);
        this.productUri = initialize_field(schema.fields[1], options?.productUri);
        this.applicationName = initialize_field(schema.fields[2], options?.applicationName);
        this.applicationType = this.setApplicationType(initialize_field(schema.fields[3], options?.applicationType));
        this.gatewayServerUri = initialize_field(schema.fields[4], options?.gatewayServerUri);
        this.discoveryProfileUri = initialize_field(schema.fields[5], options?.discoveryProfileUri);
        this.discoveryUrls = initialize_field_array(schema.fields[6], options?.discoveryUrls);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.applicationUri, stream);
        encodeString(this.productUri, stream);
        encodeLocalizedText(this.applicationName, stream);
        encodeApplicationType(this.applicationType, stream);
        encodeString(this.gatewayServerUri, stream);
        encodeString(this.discoveryProfileUri, stream);
        encodeArray(this.discoveryUrls, stream, encodeString);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.applicationUri = decodeString(stream, this.applicationUri);
        this.productUri = decodeString(stream, this.productUri);
        this.applicationName = decodeLocalizedText(stream, this.applicationName);
        this.applicationType = decodeApplicationType(stream, this.applicationType);
        this.gatewayServerUri = decodeString(stream, this.gatewayServerUri);
        this.discoveryProfileUri = decodeString(stream, this.discoveryProfileUri);
        this.discoveryUrls = decodeArray(stream, decodeString);
    }

    // Define Enumeration setters
    public setApplicationType(value: any): ApplicationType {
        const coercedValue = _enumerationApplicationType.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to ApplicationType :" + value);
        }
        this.applicationType = coercedValue.value as ApplicationType;
        return this.applicationType;
    }
    public get schema(): IStructuredTypeSchema { return schemaApplicationDescription; }
}
ApplicationDescription.schema.dataTypeNodeId = ApplicationDescription.dataTypeNodeId;
ApplicationDescription.schema.encodingDefaultBinary = ApplicationDescription.encodingDefaultBinary;
ApplicationDescription.schema.encodingDefaultXml = ApplicationDescription.encodingDefaultXml;
ApplicationDescription.schema.encodingDefaultJson = ApplicationDescription.encodingDefaultJson;
registerClassDefinition( ApplicationDescription.dataTypeNodeId, "ApplicationDescription", ApplicationDescription);
// --------------------------------------------------------------------------------------------
const schemaArgument = buildStructuredType({
    name: "Argument",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Name",

            fieldType: "String",
        },
        {
            name: "DataType",

            fieldType: "NodeId",
        },
        {
            name: "ValueRank",

            fieldType: "Int32",
        },
        {
            name: "ArrayDimensions",

            fieldType: "UInt32",
            isArray: true
        },
        {
            name: "Description",

            fieldType: "LocalizedText",
        },
    ]
});
export interface ArgumentOptions {
    name?: UAString ;
    dataType?: (NodeIdLike | null);
    valueRank?: Int32 ;
    arrayDimensions?: UInt32 [] | null;
    description?: (LocalizedTextLike | null);
}
export class Argument extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaArgument; }
    public static possibleFields: string[] = [
          "name",
           "dataType",
           "valueRank",
           "arrayDimensions",
           "description"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(296, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(298, 0);
    public static encodingDefaultXml = makeExpandedNodeId(297, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15081, 0);
    public name: UAString;
    public dataType: NodeId;
    public valueRank: Int32;
    public arrayDimensions: UInt32[] | null;
    public description: LocalizedText;

    constructor(options?: ArgumentOptions | null) {

        super(options);

        if (options === null) {
            this.name = null;
            this.dataType = new NodeId(null);
            this.valueRank = 0;
            this.arrayDimensions = []
            this.description = new LocalizedText(null);
              return;
        }
        const schema = Argument.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ArgumentOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.name = initialize_field(schema.fields[0], options?.name);
        this.dataType = initialize_field(schema.fields[1], options?.dataType);
        this.valueRank = initialize_field(schema.fields[2], options?.valueRank);
        this.arrayDimensions = initialize_field_array(schema.fields[3], options?.arrayDimensions);
        this.description = initialize_field(schema.fields[4], options?.description);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.name, stream);
        encodeNodeId(this.dataType, stream);
        encodeInt32(this.valueRank, stream);
        encodeArray(this.arrayDimensions, stream, encodeUInt32);
        encodeLocalizedText(this.description, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = decodeString(stream, this.name);
        this.dataType = decodeNodeId(stream, this.dataType);
        this.valueRank = decodeInt32(stream, this.valueRank);
        this.arrayDimensions = decodeArray(stream, decodeUInt32);
        this.description = decodeLocalizedText(stream, this.description);
    }
    public get schema(): IStructuredTypeSchema { return schemaArgument; }
}
Argument.schema.dataTypeNodeId = Argument.dataTypeNodeId;
Argument.schema.encodingDefaultBinary = Argument.encodingDefaultBinary;
Argument.schema.encodingDefaultXml = Argument.encodingDefaultXml;
Argument.schema.encodingDefaultJson = Argument.encodingDefaultJson;
registerClassDefinition( Argument.dataTypeNodeId, "Argument", Argument);
// --------------------------------------------------------------------------------------------
const schemaRelativePathElement = buildStructuredType({
    name: "RelativePathElement",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ReferenceTypeId",

            fieldType: "NodeId",
        },
        {
            name: "IsInverse",

            fieldType: "Boolean",
        },
        {
            name: "IncludeSubtypes",

            fieldType: "Boolean",
        },
        {
            name: "TargetName",

            fieldType: "QualifiedName",
        },
    ]
});
export interface RelativePathElementOptions {
    referenceTypeId?: (NodeIdLike | null);
    isInverse?: UABoolean ;
    includeSubtypes?: UABoolean ;
    targetName?: (QualifiedNameLike | null);
}
export class RelativePathElement extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaRelativePathElement; }
    public static possibleFields: string[] = [
          "referenceTypeId",
           "isInverse",
           "includeSubtypes",
           "targetName"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(537, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(539, 0);
    public static encodingDefaultXml = makeExpandedNodeId(538, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15188, 0);
    public referenceTypeId: NodeId;
    public isInverse: UABoolean;
    public includeSubtypes: UABoolean;
    public targetName: QualifiedName;

    constructor(options?: RelativePathElementOptions | null) {

        super(options);

        if (options === null) {
            this.referenceTypeId = new NodeId(null);
            this.isInverse = false;
            this.includeSubtypes = false;
            this.targetName = new QualifiedName(null);
              return;
        }
        const schema = RelativePathElement.schema;
        options = (schema.constructHook ? schema.constructHook(options) as RelativePathElementOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.referenceTypeId = initialize_field(schema.fields[0], options?.referenceTypeId);
        this.isInverse = initialize_field(schema.fields[1], options?.isInverse);
        this.includeSubtypes = initialize_field(schema.fields[2], options?.includeSubtypes);
        this.targetName = initialize_field(schema.fields[3], options?.targetName);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.referenceTypeId, stream);
        encodeBoolean(this.isInverse, stream);
        encodeBoolean(this.includeSubtypes, stream);
        encodeQualifiedName(this.targetName, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.referenceTypeId = decodeNodeId(stream, this.referenceTypeId);
        this.isInverse = decodeBoolean(stream, this.isInverse);
        this.includeSubtypes = decodeBoolean(stream, this.includeSubtypes);
        this.targetName = decodeQualifiedName(stream, this.targetName);
    }
    public get schema(): IStructuredTypeSchema { return schemaRelativePathElement; }
}
RelativePathElement.schema.dataTypeNodeId = RelativePathElement.dataTypeNodeId;
RelativePathElement.schema.encodingDefaultBinary = RelativePathElement.encodingDefaultBinary;
RelativePathElement.schema.encodingDefaultXml = RelativePathElement.encodingDefaultXml;
RelativePathElement.schema.encodingDefaultJson = RelativePathElement.encodingDefaultJson;
registerClassDefinition( RelativePathElement.dataTypeNodeId, "RelativePathElement", RelativePathElement);
// --------------------------------------------------------------------------------------------
const schemaRelativePath = buildStructuredType({
    name: "RelativePath",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Elements",

            fieldType: "RelativePathElement",
            isArray: true
        },
    ]
});
export interface RelativePathOptions {
    elements?: RelativePathElementOptions [] | null;
}
export class RelativePath extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaRelativePath; }
    public static possibleFields: string[] = [
          "elements"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(540, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(542, 0);
    public static encodingDefaultXml = makeExpandedNodeId(541, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15189, 0);
    public elements: RelativePathElement[] | null;

    constructor(options?: RelativePathOptions | null) {

        super(options);

        if (options === null) {
         this.elements =  null; /* null array */
              return;
        }
        const schema = RelativePath.schema;
        options = (schema.constructHook ? schema.constructHook(options) as RelativePathOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.elements = []; // should default
        if (options.elements) {
            assert(Array.isArray(options.elements));
            this.elements = options.elements.map((e: any) => new RelativePathElement(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeArray(this.elements, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.elements = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new RelativePathElement(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaRelativePath; }
}
RelativePath.schema.dataTypeNodeId = RelativePath.dataTypeNodeId;
RelativePath.schema.encodingDefaultBinary = RelativePath.encodingDefaultBinary;
RelativePath.schema.encodingDefaultXml = RelativePath.encodingDefaultXml;
RelativePath.schema.encodingDefaultJson = RelativePath.encodingDefaultJson;
registerClassDefinition( RelativePath.dataTypeNodeId, "RelativePath", RelativePath);
// --------------------------------------------------------------------------------------------
const schemaAttributeOperand = buildStructuredType({
    name: "AttributeOperand",

    baseType: "FilterOperand",
    fields: [
        {
            name: "NodeId",

            fieldType: "NodeId",
        },
        {
            name: "Alias",

            fieldType: "String",
        },
        {
            name: "BrowsePath",

            fieldType: "RelativePath",
        },
        {
            name: "AttributeId",

            fieldType: "UInt32",
        },
        {
            name: "IndexRange",

            fieldType: "NumericRange",
        },
    ]
});
export interface AttributeOperandOptions extends FilterOperandOptions {
    nodeId?: (NodeIdLike | null);
    alias?: UAString ;
    browsePath?: RelativePathOptions ;
    attributeId?: UInt32 ;
    indexRange?: NumericRange ;
}
export class AttributeOperand extends FilterOperand {
    public static get schema(): IStructuredTypeSchema { return schemaAttributeOperand; }
    public static possibleFields: string[] = [
          "nodeId",
           "alias",
           "browsePath",
           "attributeId",
           "indexRange"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(598, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(600, 0);
    public static encodingDefaultXml = makeExpandedNodeId(599, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15209, 0);
    public nodeId: NodeId;
    public alias: UAString;
    public browsePath: RelativePath;
    public attributeId: UInt32;
    public indexRange: NumericRange;

    constructor(options?: AttributeOperandOptions | null) {

        super(options);

        if (options === null) {
            this.nodeId = new NodeId(null);
            this.alias = null;
         this.browsePath =  new RelativePath(null);
            this.attributeId = 0;
            this.indexRange = new NumericRange(null);
              return;
        }
        const schema = AttributeOperand.schema;
        options = (schema.constructHook ? schema.constructHook(options) as AttributeOperandOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.nodeId = initialize_field(schema.fields[0], options?.nodeId);
        this.alias = initialize_field(schema.fields[1], options?.alias);
        this.browsePath  =  new RelativePath(options.browsePath);
        this.attributeId = initialize_field(schema.fields[3], options?.attributeId);
        this.indexRange = initialize_field(schema.fields[4], options?.indexRange);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.nodeId, stream);
        encodeString(this.alias, stream);
        this.browsePath.encode(stream);
        encodeUInt32(this.attributeId, stream);
        encodeNumericRange(this.indexRange, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.nodeId = decodeNodeId(stream, this.nodeId);
        this.alias = decodeString(stream, this.alias);
        this.browsePath.decode(stream);
        this.attributeId = decodeUInt32(stream, this.attributeId);
        this.indexRange = decodeNumericRange(stream, this.indexRange);
    }
    public get schema(): IStructuredTypeSchema { return schemaAttributeOperand; }
}
AttributeOperand.schema.dataTypeNodeId = AttributeOperand.dataTypeNodeId;
AttributeOperand.schema.encodingDefaultBinary = AttributeOperand.encodingDefaultBinary;
AttributeOperand.schema.encodingDefaultXml = AttributeOperand.encodingDefaultXml;
AttributeOperand.schema.encodingDefaultJson = AttributeOperand.encodingDefaultJson;
registerClassDefinition( AttributeOperand.dataTypeNodeId, "AttributeOperand", AttributeOperand);
// --------------------------------------------------------------------------------------------
const schemaBitFieldDefinition = buildStructuredType({
    name: "BitFieldDefinition",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Name",

            fieldType: "String",
        },
        {
            name: "Description",

            fieldType: "LocalizedText",
        },
        {
            name: "Reserved",

            fieldType: "Boolean",
        },
        {
            name: "StartingBitPosition",

            fieldType: "UInt32",
        },
        {
            name: "EndingBitPosition",

            fieldType: "UInt32",
        },
    ]
});
export interface BitFieldDefinitionOptions {
    name?: UAString ;
    description?: (LocalizedTextLike | null);
    reserved?: UABoolean ;
    startingBitPosition?: UInt32 ;
    endingBitPosition?: UInt32 ;
}
export class BitFieldDefinition extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaBitFieldDefinition; }
    public static possibleFields: string[] = [
          "name",
           "description",
           "reserved",
           "startingBitPosition",
           "endingBitPosition"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(32421, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(32422, 0);
    public static encodingDefaultXml = makeExpandedNodeId(32426, 0);
    public static encodingDefaultJson = makeExpandedNodeId(32430, 0);
    public name: UAString;
    public description: LocalizedText;
    public reserved: UABoolean;
    public startingBitPosition: UInt32;
    public endingBitPosition: UInt32;

    constructor(options?: BitFieldDefinitionOptions | null) {

        super(options);

        if (options === null) {
            this.name = null;
            this.description = new LocalizedText(null);
            this.reserved = false;
            this.startingBitPosition = 0;
            this.endingBitPosition = 0;
              return;
        }
        const schema = BitFieldDefinition.schema;
        options = (schema.constructHook ? schema.constructHook(options) as BitFieldDefinitionOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.name = initialize_field(schema.fields[0], options?.name);
        this.description = initialize_field(schema.fields[1], options?.description);
        this.reserved = initialize_field(schema.fields[2], options?.reserved);
        this.startingBitPosition = initialize_field(schema.fields[3], options?.startingBitPosition);
        this.endingBitPosition = initialize_field(schema.fields[4], options?.endingBitPosition);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.name, stream);
        encodeLocalizedText(this.description, stream);
        encodeBoolean(this.reserved, stream);
        encodeUInt32(this.startingBitPosition, stream);
        encodeUInt32(this.endingBitPosition, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = decodeString(stream, this.name);
        this.description = decodeLocalizedText(stream, this.description);
        this.reserved = decodeBoolean(stream, this.reserved);
        this.startingBitPosition = decodeUInt32(stream, this.startingBitPosition);
        this.endingBitPosition = decodeUInt32(stream, this.endingBitPosition);
    }
    public get schema(): IStructuredTypeSchema { return schemaBitFieldDefinition; }
}
BitFieldDefinition.schema.dataTypeNodeId = BitFieldDefinition.dataTypeNodeId;
BitFieldDefinition.schema.encodingDefaultBinary = BitFieldDefinition.encodingDefaultBinary;
BitFieldDefinition.schema.encodingDefaultXml = BitFieldDefinition.encodingDefaultXml;
BitFieldDefinition.schema.encodingDefaultJson = BitFieldDefinition.encodingDefaultJson;
registerClassDefinition( BitFieldDefinition.dataTypeNodeId, "BitFieldDefinition", BitFieldDefinition);
// --------------------------------------------------------------------------------------------
const schemaConnectionTransportDataType = buildStructuredType({
    name: "ConnectionTransportDataType",

    baseType: "ExtensionObject",
    fields: [
    ]
});
export interface ConnectionTransportDataTypeOptions {
}
export class ConnectionTransportDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaConnectionTransportDataType; }
    public static possibleFields: string[] = [
          
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15618, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15695, 0);
    public static encodingDefaultXml = makeExpandedNodeId(15993, 0);
    public static encodingDefaultJson = makeExpandedNodeId(16282, 0);

    constructor(options?: ConnectionTransportDataTypeOptions | null) {

        super(options);

        if (options === null) {
              return;
        }
        const schema = ConnectionTransportDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ConnectionTransportDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaConnectionTransportDataType; }
}
ConnectionTransportDataType.schema.dataTypeNodeId = ConnectionTransportDataType.dataTypeNodeId;
ConnectionTransportDataType.schema.encodingDefaultBinary = ConnectionTransportDataType.encodingDefaultBinary;
ConnectionTransportDataType.schema.encodingDefaultXml = ConnectionTransportDataType.encodingDefaultXml;
ConnectionTransportDataType.schema.encodingDefaultJson = ConnectionTransportDataType.encodingDefaultJson;
registerClassDefinition( ConnectionTransportDataType.dataTypeNodeId, "ConnectionTransportDataType", ConnectionTransportDataType);
// --------------------------------------------------------------------------------------------
const schemaBrokerConnectionTransportDataType = buildStructuredType({
    name: "BrokerConnectionTransportDataType",

    baseType: "ConnectionTransportDataType",
    fields: [
        {
            name: "ResourceUri",

            fieldType: "String",
        },
        {
            name: "AuthenticationProfileUri",

            fieldType: "String",
        },
    ]
});
export interface BrokerConnectionTransportDataTypeOptions extends ConnectionTransportDataTypeOptions {
    resourceUri?: UAString ;
    authenticationProfileUri?: UAString ;
}
export class BrokerConnectionTransportDataType extends ConnectionTransportDataType {
    public static get schema(): IStructuredTypeSchema { return schemaBrokerConnectionTransportDataType; }
    public static possibleFields: string[] = [
          "resourceUri",
           "authenticationProfileUri"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15007, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15479, 0);
    public static encodingDefaultXml = makeExpandedNodeId(15579, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15726, 0);
    public resourceUri: UAString;
    public authenticationProfileUri: UAString;

    constructor(options?: BrokerConnectionTransportDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.resourceUri = null;
            this.authenticationProfileUri = null;
              return;
        }
        const schema = BrokerConnectionTransportDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as BrokerConnectionTransportDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.resourceUri = initialize_field(schema.fields[0], options?.resourceUri);
        this.authenticationProfileUri = initialize_field(schema.fields[1], options?.authenticationProfileUri);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.resourceUri, stream);
        encodeString(this.authenticationProfileUri, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.resourceUri = decodeString(stream, this.resourceUri);
        this.authenticationProfileUri = decodeString(stream, this.authenticationProfileUri);
    }
    public get schema(): IStructuredTypeSchema { return schemaBrokerConnectionTransportDataType; }
}
BrokerConnectionTransportDataType.schema.dataTypeNodeId = BrokerConnectionTransportDataType.dataTypeNodeId;
BrokerConnectionTransportDataType.schema.encodingDefaultBinary = BrokerConnectionTransportDataType.encodingDefaultBinary;
BrokerConnectionTransportDataType.schema.encodingDefaultXml = BrokerConnectionTransportDataType.encodingDefaultXml;
BrokerConnectionTransportDataType.schema.encodingDefaultJson = BrokerConnectionTransportDataType.encodingDefaultJson;
registerClassDefinition( BrokerConnectionTransportDataType.dataTypeNodeId, "BrokerConnectionTransportDataType", BrokerConnectionTransportDataType);
// --------------------------------------------------------------------------------------------
const schemaDataSetReaderTransportDataType = buildStructuredType({
    name: "DataSetReaderTransportDataType",

    baseType: "ExtensionObject",
    fields: [
    ]
});
export interface DataSetReaderTransportDataTypeOptions {
}
export class DataSetReaderTransportDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaDataSetReaderTransportDataType; }
    public static possibleFields: string[] = [
          
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15628, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15705, 0);
    public static encodingDefaultXml = makeExpandedNodeId(16008, 0);
    public static encodingDefaultJson = makeExpandedNodeId(16287, 0);

    constructor(options?: DataSetReaderTransportDataTypeOptions | null) {

        super(options);

        if (options === null) {
              return;
        }
        const schema = DataSetReaderTransportDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DataSetReaderTransportDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaDataSetReaderTransportDataType; }
}
DataSetReaderTransportDataType.schema.dataTypeNodeId = DataSetReaderTransportDataType.dataTypeNodeId;
DataSetReaderTransportDataType.schema.encodingDefaultBinary = DataSetReaderTransportDataType.encodingDefaultBinary;
DataSetReaderTransportDataType.schema.encodingDefaultXml = DataSetReaderTransportDataType.encodingDefaultXml;
DataSetReaderTransportDataType.schema.encodingDefaultJson = DataSetReaderTransportDataType.encodingDefaultJson;
registerClassDefinition( DataSetReaderTransportDataType.dataTypeNodeId, "DataSetReaderTransportDataType", DataSetReaderTransportDataType);

// --------------------------------------------------------------------------------------------
export enum BrokerTransportQualityOfService {
    NotSpecified = 0,
    BestEffort = 1,
    AtLeastOnce = 2,
    AtMostOnce = 3,
    ExactlyOnce = 4,
    Invalid = 4294967295
}
const schemaBrokerTransportQualityOfService = {
    enumValues: BrokerTransportQualityOfService,
    flaggable: false,
    minValue: 0,
    maxValue: 4,
    name: "BrokerTransportQualityOfService"
};
function decodeBrokerTransportQualityOfService(stream: BinaryStream, _value?: BrokerTransportQualityOfService): BrokerTransportQualityOfService {
    let value =  stream.readUInt32() as BrokerTransportQualityOfService;
    value = (value < schemaBrokerTransportQualityOfService.minValue || value > schemaBrokerTransportQualityOfService.maxValue) ? BrokerTransportQualityOfService.Invalid : value; 
    return value;
}
function encodeBrokerTransportQualityOfService(value: BrokerTransportQualityOfService, stream: OutputBinaryStream): void {
    stream.writeUInt32(value);
}
export const _enumerationBrokerTransportQualityOfService = registerEnumeration(schemaBrokerTransportQualityOfService);
assert(_enumerationBrokerTransportQualityOfService.isFlaggable ===  false);
// --------------------------------------------------------------------------------------------
const schemaBrokerDataSetReaderTransportDataType = buildStructuredType({
    name: "BrokerDataSetReaderTransportDataType",

    baseType: "DataSetReaderTransportDataType",
    fields: [
        {
            name: "QueueName",

            fieldType: "String",
        },
        {
            name: "ResourceUri",

            fieldType: "String",
        },
        {
            name: "AuthenticationProfileUri",

            fieldType: "String",
        },
        {
            name: "RequestedDeliveryGuarantee",

            fieldType: "BrokerTransportQualityOfService",
        },
        {
            name: "MetaDataQueueName",

            fieldType: "String",
        },
    ]
});
export interface BrokerDataSetReaderTransportDataTypeOptions extends DataSetReaderTransportDataTypeOptions {
    queueName?: UAString ;
    resourceUri?: UAString ;
    authenticationProfileUri?: UAString ;
    requestedDeliveryGuarantee?: BrokerTransportQualityOfService;
    metaDataQueueName?: UAString ;
}
export class BrokerDataSetReaderTransportDataType extends DataSetReaderTransportDataType {
    public static get schema(): IStructuredTypeSchema { return schemaBrokerDataSetReaderTransportDataType; }
    public static possibleFields: string[] = [
          "queueName",
           "resourceUri",
           "authenticationProfileUri",
           "requestedDeliveryGuarantee",
           "metaDataQueueName"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15670, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15733, 0);
    public static encodingDefaultXml = makeExpandedNodeId(16023, 0);
    public static encodingDefaultJson = makeExpandedNodeId(16526, 0);
    public queueName: UAString;
    public resourceUri: UAString;
    public authenticationProfileUri: UAString;
    public requestedDeliveryGuarantee: BrokerTransportQualityOfService;
    public metaDataQueueName: UAString;

    constructor(options?: BrokerDataSetReaderTransportDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.queueName = null;
            this.resourceUri = null;
            this.authenticationProfileUri = null;
             this.requestedDeliveryGuarantee =  0 as  BrokerTransportQualityOfService;
            this.metaDataQueueName = null;
              return;
        }
        const schema = BrokerDataSetReaderTransportDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as BrokerDataSetReaderTransportDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.queueName = initialize_field(schema.fields[0], options?.queueName);
        this.resourceUri = initialize_field(schema.fields[1], options?.resourceUri);
        this.authenticationProfileUri = initialize_field(schema.fields[2], options?.authenticationProfileUri);
        this.requestedDeliveryGuarantee = this.setRequestedDeliveryGuarantee(initialize_field(schema.fields[3], options?.requestedDeliveryGuarantee));
        this.metaDataQueueName = initialize_field(schema.fields[4], options?.metaDataQueueName);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.queueName, stream);
        encodeString(this.resourceUri, stream);
        encodeString(this.authenticationProfileUri, stream);
        encodeBrokerTransportQualityOfService(this.requestedDeliveryGuarantee, stream);
        encodeString(this.metaDataQueueName, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.queueName = decodeString(stream, this.queueName);
        this.resourceUri = decodeString(stream, this.resourceUri);
        this.authenticationProfileUri = decodeString(stream, this.authenticationProfileUri);
        this.requestedDeliveryGuarantee = decodeBrokerTransportQualityOfService(stream, this.requestedDeliveryGuarantee);
        this.metaDataQueueName = decodeString(stream, this.metaDataQueueName);
    }

    // Define Enumeration setters
    public setRequestedDeliveryGuarantee(value: any): BrokerTransportQualityOfService {
        const coercedValue = _enumerationBrokerTransportQualityOfService.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to BrokerTransportQualityOfService :" + value);
        }
        this.requestedDeliveryGuarantee = coercedValue.value as BrokerTransportQualityOfService;
        return this.requestedDeliveryGuarantee;
    }
    public get schema(): IStructuredTypeSchema { return schemaBrokerDataSetReaderTransportDataType; }
}
BrokerDataSetReaderTransportDataType.schema.dataTypeNodeId = BrokerDataSetReaderTransportDataType.dataTypeNodeId;
BrokerDataSetReaderTransportDataType.schema.encodingDefaultBinary = BrokerDataSetReaderTransportDataType.encodingDefaultBinary;
BrokerDataSetReaderTransportDataType.schema.encodingDefaultXml = BrokerDataSetReaderTransportDataType.encodingDefaultXml;
BrokerDataSetReaderTransportDataType.schema.encodingDefaultJson = BrokerDataSetReaderTransportDataType.encodingDefaultJson;
registerClassDefinition( BrokerDataSetReaderTransportDataType.dataTypeNodeId, "BrokerDataSetReaderTransportDataType", BrokerDataSetReaderTransportDataType);
// --------------------------------------------------------------------------------------------
const schemaDataSetWriterTransportDataType = buildStructuredType({
    name: "DataSetWriterTransportDataType",

    baseType: "ExtensionObject",
    fields: [
    ]
});
export interface DataSetWriterTransportDataTypeOptions {
}
export class DataSetWriterTransportDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaDataSetWriterTransportDataType; }
    public static possibleFields: string[] = [
          
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15598, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15683, 0);
    public static encodingDefaultXml = makeExpandedNodeId(15956, 0);
    public static encodingDefaultJson = makeExpandedNodeId(16157, 0);

    constructor(options?: DataSetWriterTransportDataTypeOptions | null) {

        super(options);

        if (options === null) {
              return;
        }
        const schema = DataSetWriterTransportDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DataSetWriterTransportDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaDataSetWriterTransportDataType; }
}
DataSetWriterTransportDataType.schema.dataTypeNodeId = DataSetWriterTransportDataType.dataTypeNodeId;
DataSetWriterTransportDataType.schema.encodingDefaultBinary = DataSetWriterTransportDataType.encodingDefaultBinary;
DataSetWriterTransportDataType.schema.encodingDefaultXml = DataSetWriterTransportDataType.encodingDefaultXml;
DataSetWriterTransportDataType.schema.encodingDefaultJson = DataSetWriterTransportDataType.encodingDefaultJson;
registerClassDefinition( DataSetWriterTransportDataType.dataTypeNodeId, "DataSetWriterTransportDataType", DataSetWriterTransportDataType);
// --------------------------------------------------------------------------------------------
const schemaBrokerDataSetWriterTransportDataType = buildStructuredType({
    name: "BrokerDataSetWriterTransportDataType",

    baseType: "DataSetWriterTransportDataType",
    fields: [
        {
            name: "QueueName",

            fieldType: "String",
        },
        {
            name: "ResourceUri",

            fieldType: "String",
        },
        {
            name: "AuthenticationProfileUri",

            fieldType: "String",
        },
        {
            name: "RequestedDeliveryGuarantee",

            fieldType: "BrokerTransportQualityOfService",
        },
        {
            name: "MetaDataQueueName",

            fieldType: "String",
        },
        {
            name: "MetaDataUpdateTime",

            fieldType: "Double",
        },
    ]
});
export interface BrokerDataSetWriterTransportDataTypeOptions extends DataSetWriterTransportDataTypeOptions {
    queueName?: UAString ;
    resourceUri?: UAString ;
    authenticationProfileUri?: UAString ;
    requestedDeliveryGuarantee?: BrokerTransportQualityOfService;
    metaDataQueueName?: UAString ;
    metaDataUpdateTime?: Double ;
}
export class BrokerDataSetWriterTransportDataType extends DataSetWriterTransportDataType {
    public static get schema(): IStructuredTypeSchema { return schemaBrokerDataSetWriterTransportDataType; }
    public static possibleFields: string[] = [
          "queueName",
           "resourceUri",
           "authenticationProfileUri",
           "requestedDeliveryGuarantee",
           "metaDataQueueName",
           "metaDataUpdateTime"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15669, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15729, 0);
    public static encodingDefaultXml = makeExpandedNodeId(16022, 0);
    public static encodingDefaultJson = makeExpandedNodeId(16525, 0);
    public queueName: UAString;
    public resourceUri: UAString;
    public authenticationProfileUri: UAString;
    public requestedDeliveryGuarantee: BrokerTransportQualityOfService;
    public metaDataQueueName: UAString;
    public metaDataUpdateTime: Double;

    constructor(options?: BrokerDataSetWriterTransportDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.queueName = null;
            this.resourceUri = null;
            this.authenticationProfileUri = null;
             this.requestedDeliveryGuarantee =  0 as  BrokerTransportQualityOfService;
            this.metaDataQueueName = null;
            this.metaDataUpdateTime = 0;
              return;
        }
        const schema = BrokerDataSetWriterTransportDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as BrokerDataSetWriterTransportDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.queueName = initialize_field(schema.fields[0], options?.queueName);
        this.resourceUri = initialize_field(schema.fields[1], options?.resourceUri);
        this.authenticationProfileUri = initialize_field(schema.fields[2], options?.authenticationProfileUri);
        this.requestedDeliveryGuarantee = this.setRequestedDeliveryGuarantee(initialize_field(schema.fields[3], options?.requestedDeliveryGuarantee));
        this.metaDataQueueName = initialize_field(schema.fields[4], options?.metaDataQueueName);
        this.metaDataUpdateTime = initialize_field(schema.fields[5], options?.metaDataUpdateTime);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.queueName, stream);
        encodeString(this.resourceUri, stream);
        encodeString(this.authenticationProfileUri, stream);
        encodeBrokerTransportQualityOfService(this.requestedDeliveryGuarantee, stream);
        encodeString(this.metaDataQueueName, stream);
        encodeDouble(this.metaDataUpdateTime, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.queueName = decodeString(stream, this.queueName);
        this.resourceUri = decodeString(stream, this.resourceUri);
        this.authenticationProfileUri = decodeString(stream, this.authenticationProfileUri);
        this.requestedDeliveryGuarantee = decodeBrokerTransportQualityOfService(stream, this.requestedDeliveryGuarantee);
        this.metaDataQueueName = decodeString(stream, this.metaDataQueueName);
        this.metaDataUpdateTime = decodeDouble(stream, this.metaDataUpdateTime);
    }

    // Define Enumeration setters
    public setRequestedDeliveryGuarantee(value: any): BrokerTransportQualityOfService {
        const coercedValue = _enumerationBrokerTransportQualityOfService.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to BrokerTransportQualityOfService :" + value);
        }
        this.requestedDeliveryGuarantee = coercedValue.value as BrokerTransportQualityOfService;
        return this.requestedDeliveryGuarantee;
    }
    public get schema(): IStructuredTypeSchema { return schemaBrokerDataSetWriterTransportDataType; }
}
BrokerDataSetWriterTransportDataType.schema.dataTypeNodeId = BrokerDataSetWriterTransportDataType.dataTypeNodeId;
BrokerDataSetWriterTransportDataType.schema.encodingDefaultBinary = BrokerDataSetWriterTransportDataType.encodingDefaultBinary;
BrokerDataSetWriterTransportDataType.schema.encodingDefaultXml = BrokerDataSetWriterTransportDataType.encodingDefaultXml;
BrokerDataSetWriterTransportDataType.schema.encodingDefaultJson = BrokerDataSetWriterTransportDataType.encodingDefaultJson;
registerClassDefinition( BrokerDataSetWriterTransportDataType.dataTypeNodeId, "BrokerDataSetWriterTransportDataType", BrokerDataSetWriterTransportDataType);
// --------------------------------------------------------------------------------------------
const schemaWriterGroupTransportDataType = buildStructuredType({
    name: "WriterGroupTransportDataType",

    baseType: "ExtensionObject",
    fields: [
    ]
});
export interface WriterGroupTransportDataTypeOptions {
}
export class WriterGroupTransportDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaWriterGroupTransportDataType; }
    public static possibleFields: string[] = [
          
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15611, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15691, 0);
    public static encodingDefaultXml = makeExpandedNodeId(15990, 0);
    public static encodingDefaultJson = makeExpandedNodeId(16161, 0);

    constructor(options?: WriterGroupTransportDataTypeOptions | null) {

        super(options);

        if (options === null) {
              return;
        }
        const schema = WriterGroupTransportDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as WriterGroupTransportDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaWriterGroupTransportDataType; }
}
WriterGroupTransportDataType.schema.dataTypeNodeId = WriterGroupTransportDataType.dataTypeNodeId;
WriterGroupTransportDataType.schema.encodingDefaultBinary = WriterGroupTransportDataType.encodingDefaultBinary;
WriterGroupTransportDataType.schema.encodingDefaultXml = WriterGroupTransportDataType.encodingDefaultXml;
WriterGroupTransportDataType.schema.encodingDefaultJson = WriterGroupTransportDataType.encodingDefaultJson;
registerClassDefinition( WriterGroupTransportDataType.dataTypeNodeId, "WriterGroupTransportDataType", WriterGroupTransportDataType);
// --------------------------------------------------------------------------------------------
const schemaBrokerWriterGroupTransportDataType = buildStructuredType({
    name: "BrokerWriterGroupTransportDataType",

    baseType: "WriterGroupTransportDataType",
    fields: [
        {
            name: "QueueName",

            fieldType: "String",
        },
        {
            name: "ResourceUri",

            fieldType: "String",
        },
        {
            name: "AuthenticationProfileUri",

            fieldType: "String",
        },
        {
            name: "RequestedDeliveryGuarantee",

            fieldType: "BrokerTransportQualityOfService",
        },
    ]
});
export interface BrokerWriterGroupTransportDataTypeOptions extends WriterGroupTransportDataTypeOptions {
    queueName?: UAString ;
    resourceUri?: UAString ;
    authenticationProfileUri?: UAString ;
    requestedDeliveryGuarantee?: BrokerTransportQualityOfService;
}
export class BrokerWriterGroupTransportDataType extends WriterGroupTransportDataType {
    public static get schema(): IStructuredTypeSchema { return schemaBrokerWriterGroupTransportDataType; }
    public static possibleFields: string[] = [
          "queueName",
           "resourceUri",
           "authenticationProfileUri",
           "requestedDeliveryGuarantee"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15667, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15727, 0);
    public static encodingDefaultXml = makeExpandedNodeId(16021, 0);
    public static encodingDefaultJson = makeExpandedNodeId(16524, 0);
    public queueName: UAString;
    public resourceUri: UAString;
    public authenticationProfileUri: UAString;
    public requestedDeliveryGuarantee: BrokerTransportQualityOfService;

    constructor(options?: BrokerWriterGroupTransportDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.queueName = null;
            this.resourceUri = null;
            this.authenticationProfileUri = null;
             this.requestedDeliveryGuarantee =  0 as  BrokerTransportQualityOfService;
              return;
        }
        const schema = BrokerWriterGroupTransportDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as BrokerWriterGroupTransportDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.queueName = initialize_field(schema.fields[0], options?.queueName);
        this.resourceUri = initialize_field(schema.fields[1], options?.resourceUri);
        this.authenticationProfileUri = initialize_field(schema.fields[2], options?.authenticationProfileUri);
        this.requestedDeliveryGuarantee = this.setRequestedDeliveryGuarantee(initialize_field(schema.fields[3], options?.requestedDeliveryGuarantee));
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.queueName, stream);
        encodeString(this.resourceUri, stream);
        encodeString(this.authenticationProfileUri, stream);
        encodeBrokerTransportQualityOfService(this.requestedDeliveryGuarantee, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.queueName = decodeString(stream, this.queueName);
        this.resourceUri = decodeString(stream, this.resourceUri);
        this.authenticationProfileUri = decodeString(stream, this.authenticationProfileUri);
        this.requestedDeliveryGuarantee = decodeBrokerTransportQualityOfService(stream, this.requestedDeliveryGuarantee);
    }

    // Define Enumeration setters
    public setRequestedDeliveryGuarantee(value: any): BrokerTransportQualityOfService {
        const coercedValue = _enumerationBrokerTransportQualityOfService.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to BrokerTransportQualityOfService :" + value);
        }
        this.requestedDeliveryGuarantee = coercedValue.value as BrokerTransportQualityOfService;
        return this.requestedDeliveryGuarantee;
    }
    public get schema(): IStructuredTypeSchema { return schemaBrokerWriterGroupTransportDataType; }
}
BrokerWriterGroupTransportDataType.schema.dataTypeNodeId = BrokerWriterGroupTransportDataType.dataTypeNodeId;
BrokerWriterGroupTransportDataType.schema.encodingDefaultBinary = BrokerWriterGroupTransportDataType.encodingDefaultBinary;
BrokerWriterGroupTransportDataType.schema.encodingDefaultXml = BrokerWriterGroupTransportDataType.encodingDefaultXml;
BrokerWriterGroupTransportDataType.schema.encodingDefaultJson = BrokerWriterGroupTransportDataType.encodingDefaultJson;
registerClassDefinition( BrokerWriterGroupTransportDataType.dataTypeNodeId, "BrokerWriterGroupTransportDataType", BrokerWriterGroupTransportDataType);
// --------------------------------------------------------------------------------------------
const schemaBrowseDescription = buildStructuredType({
    name: "BrowseDescription",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "NodeId",

            fieldType: "NodeId",
        },
        {
            name: "BrowseDirection",

            fieldType: "BrowseDirection",
        },
        {
            name: "ReferenceTypeId",

            fieldType: "NodeId",
        },
        {
            name: "IncludeSubtypes",

            fieldType: "Boolean",
        },
        {
            name: "NodeClassMask",

            fieldType: "UInt32",
        },
        {
            name: "ResultMask",

            fieldType: "UInt32",
        },
    ]
});
export interface BrowseDescriptionOptions {
    nodeId?: (NodeIdLike | null);
    browseDirection?: BrowseDirection;
    referenceTypeId?: (NodeIdLike | null);
    includeSubtypes?: UABoolean ;
    nodeClassMask?: UInt32 ;
    resultMask?: UInt32 ;
}
export class BrowseDescription extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaBrowseDescription; }
    public static possibleFields: string[] = [
          "nodeId",
           "browseDirection",
           "referenceTypeId",
           "includeSubtypes",
           "nodeClassMask",
           "resultMask"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(514, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(516, 0);
    public static encodingDefaultXml = makeExpandedNodeId(515, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15180, 0);
    public nodeId: NodeId;
    public browseDirection: BrowseDirection;
    public referenceTypeId: NodeId;
    public includeSubtypes: UABoolean;
    public nodeClassMask: UInt32;
    public resultMask: UInt32;

    constructor(options?: BrowseDescriptionOptions | null) {

        super(options);

        if (options === null) {
            this.nodeId = new NodeId(null);
             this.browseDirection =  0 as  BrowseDirection;
            this.referenceTypeId = new NodeId(null);
            this.includeSubtypes = false;
            this.nodeClassMask = 0;
            this.resultMask = 0;
              return;
        }
        const schema = BrowseDescription.schema;
        options = (schema.constructHook ? schema.constructHook(options) as BrowseDescriptionOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.nodeId = initialize_field(schema.fields[0], options?.nodeId);
        this.browseDirection = this.setBrowseDirection(initialize_field(schema.fields[1], options?.browseDirection));
        this.referenceTypeId = initialize_field(schema.fields[2], options?.referenceTypeId);
        this.includeSubtypes = initialize_field(schema.fields[3], options?.includeSubtypes);
        this.nodeClassMask = initialize_field(schema.fields[4], options?.nodeClassMask);
        this.resultMask = initialize_field(schema.fields[5], options?.resultMask);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.nodeId, stream);
        encodeBrowseDirection(this.browseDirection, stream);
        encodeNodeId(this.referenceTypeId, stream);
        encodeBoolean(this.includeSubtypes, stream);
        encodeUInt32(this.nodeClassMask, stream);
        encodeUInt32(this.resultMask, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.nodeId = decodeNodeId(stream, this.nodeId);
        this.browseDirection = decodeBrowseDirection(stream, this.browseDirection);
        this.referenceTypeId = decodeNodeId(stream, this.referenceTypeId);
        this.includeSubtypes = decodeBoolean(stream, this.includeSubtypes);
        this.nodeClassMask = decodeUInt32(stream, this.nodeClassMask);
        this.resultMask = decodeUInt32(stream, this.resultMask);
    }

    // Define Enumeration setters
    public setBrowseDirection(value: any): BrowseDirection {
        const coercedValue = _enumerationBrowseDirection.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to BrowseDirection :" + value);
        }
        this.browseDirection = coercedValue.value as BrowseDirection;
        return this.browseDirection;
    }
    public get schema(): IStructuredTypeSchema { return schemaBrowseDescription; }
}
BrowseDescription.schema.dataTypeNodeId = BrowseDescription.dataTypeNodeId;
BrowseDescription.schema.encodingDefaultBinary = BrowseDescription.encodingDefaultBinary;
BrowseDescription.schema.encodingDefaultXml = BrowseDescription.encodingDefaultXml;
BrowseDescription.schema.encodingDefaultJson = BrowseDescription.encodingDefaultJson;
registerClassDefinition( BrowseDescription.dataTypeNodeId, "BrowseDescription", BrowseDescription);
// --------------------------------------------------------------------------------------------
const schemaBrowseNextRequest = buildStructuredType({
    name: "BrowseNextRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
        {
            name: "ReleaseContinuationPoints",

            fieldType: "Boolean",
        },
        {
            name: "ContinuationPoints",

            fieldType: "ByteString",
            isArray: true
        },
    ]
});
export interface BrowseNextRequestOptions {
    requestHeader?: RequestHeaderOptions ;
    releaseContinuationPoints?: UABoolean ;
    continuationPoints?: ByteString [] | null;
}
export class BrowseNextRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaBrowseNextRequest; }
    public static possibleFields: string[] = [
          "requestHeader",
           "releaseContinuationPoints",
           "continuationPoints"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(531, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(533, 0);
    public static encodingDefaultXml = makeExpandedNodeId(532, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15186, 0);
    public requestHeader: RequestHeader;
    public releaseContinuationPoints: UABoolean;
    public continuationPoints: ByteString[] | null;

    constructor(options?: BrowseNextRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
            this.releaseContinuationPoints = false;
            this.continuationPoints = []
              return;
        }
        const schema = BrowseNextRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as BrowseNextRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
        this.releaseContinuationPoints = initialize_field(schema.fields[1], options?.releaseContinuationPoints);
        this.continuationPoints = initialize_field_array(schema.fields[2], options?.continuationPoints);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        encodeBoolean(this.releaseContinuationPoints, stream);
        encodeArray(this.continuationPoints, stream, encodeByteString);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.releaseContinuationPoints = decodeBoolean(stream, this.releaseContinuationPoints);
        this.continuationPoints = decodeArray(stream, decodeByteString);
    }
    public get schema(): IStructuredTypeSchema { return schemaBrowseNextRequest; }
}
BrowseNextRequest.schema.dataTypeNodeId = BrowseNextRequest.dataTypeNodeId;
BrowseNextRequest.schema.encodingDefaultBinary = BrowseNextRequest.encodingDefaultBinary;
BrowseNextRequest.schema.encodingDefaultXml = BrowseNextRequest.encodingDefaultXml;
BrowseNextRequest.schema.encodingDefaultJson = BrowseNextRequest.encodingDefaultJson;
registerClassDefinition( BrowseNextRequest.dataTypeNodeId, "BrowseNextRequest", BrowseNextRequest);
// --------------------------------------------------------------------------------------------
const schemaReferenceDescription = buildStructuredType({
    name: "ReferenceDescription",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ReferenceTypeId",

            fieldType: "NodeId",
        },
        {
            name: "IsForward",

            fieldType: "Boolean",
        },
        {
            name: "NodeId",

            fieldType: "ExpandedNodeId",
        },
        {
            name: "BrowseName",

            fieldType: "QualifiedName",
        },
        {
            name: "DisplayName",

            fieldType: "LocalizedText",
        },
        {
            name: "NodeClass",

            fieldType: "NodeClass",
        },
        {
            name: "TypeDefinition",

            fieldType: "ExpandedNodeId",
        },
    ]
});
export interface ReferenceDescriptionOptions {
    referenceTypeId?: (NodeIdLike | null);
    isForward?: UABoolean ;
    nodeId?: ExpandedNodeId ;
    browseName?: (QualifiedNameLike | null);
    displayName?: (LocalizedTextLike | null);
    nodeClass?: NodeClass;
    typeDefinition?: ExpandedNodeId ;
}
export class ReferenceDescription extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaReferenceDescription; }
    public static possibleFields: string[] = [
          "referenceTypeId",
           "isForward",
           "nodeId",
           "browseName",
           "displayName",
           "nodeClass",
           "typeDefinition"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(518, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(520, 0);
    public static encodingDefaultXml = makeExpandedNodeId(519, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15182, 0);
    public referenceTypeId: NodeId;
    public isForward: UABoolean;
    public nodeId: ExpandedNodeId;
    public browseName: QualifiedName;
    public displayName: LocalizedText;
    public nodeClass: NodeClass;
    public typeDefinition: ExpandedNodeId;

    constructor(options?: ReferenceDescriptionOptions | null) {

        super(options);

        if (options === null) {
            this.referenceTypeId = new NodeId(null);
            this.isForward = false;
            this.nodeId = new ExpandedNodeId(null);
            this.browseName = new QualifiedName(null);
            this.displayName = new LocalizedText(null);
             this.nodeClass =  0 as  NodeClass;
            this.typeDefinition = new ExpandedNodeId(null);
              return;
        }
        const schema = ReferenceDescription.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ReferenceDescriptionOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.referenceTypeId = initialize_field(schema.fields[0], options?.referenceTypeId);
        this.isForward = initialize_field(schema.fields[1], options?.isForward);
        this.nodeId = initialize_field(schema.fields[2], options?.nodeId);
        this.browseName = initialize_field(schema.fields[3], options?.browseName);
        this.displayName = initialize_field(schema.fields[4], options?.displayName);
        this.nodeClass = this.setNodeClass(initialize_field(schema.fields[5], options?.nodeClass));
        this.typeDefinition = initialize_field(schema.fields[6], options?.typeDefinition);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.referenceTypeId, stream);
        encodeBoolean(this.isForward, stream);
        encodeExpandedNodeId(this.nodeId, stream);
        encodeQualifiedName(this.browseName, stream);
        encodeLocalizedText(this.displayName, stream);
        encodeNodeClass(this.nodeClass, stream);
        encodeExpandedNodeId(this.typeDefinition, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.referenceTypeId = decodeNodeId(stream, this.referenceTypeId);
        this.isForward = decodeBoolean(stream, this.isForward);
        this.nodeId = decodeExpandedNodeId(stream, this.nodeId);
        this.browseName = decodeQualifiedName(stream, this.browseName);
        this.displayName = decodeLocalizedText(stream, this.displayName);
        this.nodeClass = decodeNodeClass(stream, this.nodeClass);
        this.typeDefinition = decodeExpandedNodeId(stream, this.typeDefinition);
    }

    // Define Enumeration setters
    public setNodeClass(value: any): NodeClass {
        const coercedValue = _enumerationNodeClass.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to NodeClass :" + value);
        }
        this.nodeClass = coercedValue.value as NodeClass;
        return this.nodeClass;
    }
    public get schema(): IStructuredTypeSchema { return schemaReferenceDescription; }
}
ReferenceDescription.schema.dataTypeNodeId = ReferenceDescription.dataTypeNodeId;
ReferenceDescription.schema.encodingDefaultBinary = ReferenceDescription.encodingDefaultBinary;
ReferenceDescription.schema.encodingDefaultXml = ReferenceDescription.encodingDefaultXml;
ReferenceDescription.schema.encodingDefaultJson = ReferenceDescription.encodingDefaultJson;
registerClassDefinition( ReferenceDescription.dataTypeNodeId, "ReferenceDescription", ReferenceDescription);
// --------------------------------------------------------------------------------------------
const schemaBrowseResult = buildStructuredType({
    name: "BrowseResult",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "StatusCode",

            fieldType: "StatusCode",
        },
        {
            name: "ContinuationPoint",

            fieldType: "ByteString",
        },
        {
            name: "References",

            fieldType: "ReferenceDescription",
            isArray: true
        },
    ]
});
export interface BrowseResultOptions {
    statusCode?: StatusCode ;
    continuationPoint?: ByteString ;
    references?: ReferenceDescriptionOptions [] | null;
}
export class BrowseResult extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaBrowseResult; }
    public static possibleFields: string[] = [
          "statusCode",
           "continuationPoint",
           "references"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(522, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(524, 0);
    public static encodingDefaultXml = makeExpandedNodeId(523, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15183, 0);
    public statusCode: StatusCode;
    public continuationPoint: ByteString;
    public references: ReferenceDescription[] | null;

    constructor(options?: BrowseResultOptions | null) {

        super(options);

        if (options === null) {
            this.statusCode = StatusCodes.Good;
            this.continuationPoint = Buffer.alloc(0);
         this.references =  null; /* null array */
              return;
        }
        const schema = BrowseResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) as BrowseResultOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.statusCode = initialize_field(schema.fields[0], options?.statusCode);
        this.continuationPoint = initialize_field(schema.fields[1], options?.continuationPoint);
        this.references = []; // should default
        if (options.references) {
            assert(Array.isArray(options.references));
            this.references = options.references.map((e: any) => new ReferenceDescription(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeStatusCode(this.statusCode, stream);
        encodeByteString(this.continuationPoint, stream);
        encodeArray(this.references, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.statusCode = decodeStatusCode(stream, this.statusCode);
        this.continuationPoint = decodeByteString(stream, this.continuationPoint);
        this.references = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new ReferenceDescription(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaBrowseResult; }
}
BrowseResult.schema.dataTypeNodeId = BrowseResult.dataTypeNodeId;
BrowseResult.schema.encodingDefaultBinary = BrowseResult.encodingDefaultBinary;
BrowseResult.schema.encodingDefaultXml = BrowseResult.encodingDefaultXml;
BrowseResult.schema.encodingDefaultJson = BrowseResult.encodingDefaultJson;
registerClassDefinition( BrowseResult.dataTypeNodeId, "BrowseResult", BrowseResult);
// --------------------------------------------------------------------------------------------
const schemaBrowseNextResponse = buildStructuredType({
    name: "BrowseNextResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
        {
            name: "Results",

            fieldType: "BrowseResult",
            isArray: true
        },
        {
            name: "DiagnosticInfos",

            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
export interface BrowseNextResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
    results?: BrowseResultOptions [] | null;
    diagnosticInfos?: (DiagnosticInfo | null)[] | null;
}
export class BrowseNextResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaBrowseNextResponse; }
    public static possibleFields: string[] = [
          "responseHeader",
           "results",
           "diagnosticInfos"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(534, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(536, 0);
    public static encodingDefaultXml = makeExpandedNodeId(535, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15187, 0);
    public responseHeader: ResponseHeader;
    public results: BrowseResult[] | null;
    public diagnosticInfos: (DiagnosticInfo | null)[] | null;

    constructor(options?: BrowseNextResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
         this.results =  null; /* null array */
            this.diagnosticInfos = []
              return;
        }
        const schema = BrowseNextResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as BrowseNextResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
        this.results = []; // should default
        if (options.results) {
            assert(Array.isArray(options.results));
            this.results = options.results.map((e: any) => new BrowseResult(e));
        }
        this.diagnosticInfos = initialize_field_array(schema.fields[2], options?.diagnosticInfos);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        encodeArray(this.results, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.diagnosticInfos, stream, encodeDiagnosticInfo);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new BrowseResult(null);
            obj.decode(stream1);
            return obj;
        });
        this.diagnosticInfos = decodeArray(stream, decodeDiagnosticInfo);
    }
    public get schema(): IStructuredTypeSchema { return schemaBrowseNextResponse; }
}
BrowseNextResponse.schema.dataTypeNodeId = BrowseNextResponse.dataTypeNodeId;
BrowseNextResponse.schema.encodingDefaultBinary = BrowseNextResponse.encodingDefaultBinary;
BrowseNextResponse.schema.encodingDefaultXml = BrowseNextResponse.encodingDefaultXml;
BrowseNextResponse.schema.encodingDefaultJson = BrowseNextResponse.encodingDefaultJson;
registerClassDefinition( BrowseNextResponse.dataTypeNodeId, "BrowseNextResponse", BrowseNextResponse);
// --------------------------------------------------------------------------------------------
const schemaBrowsePath = buildStructuredType({
    name: "BrowsePath",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "StartingNode",

            fieldType: "NodeId",
        },
        {
            name: "RelativePath",

            fieldType: "RelativePath",
        },
    ]
});
export interface BrowsePathOptions {
    startingNode?: (NodeIdLike | null);
    relativePath?: RelativePathOptions ;
}
export class BrowsePath extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaBrowsePath; }
    public static possibleFields: string[] = [
          "startingNode",
           "relativePath"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(543, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(545, 0);
    public static encodingDefaultXml = makeExpandedNodeId(544, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15190, 0);
    public startingNode: NodeId;
    public relativePath: RelativePath;

    constructor(options?: BrowsePathOptions | null) {

        super(options);

        if (options === null) {
            this.startingNode = new NodeId(null);
         this.relativePath =  new RelativePath(null);
              return;
        }
        const schema = BrowsePath.schema;
        options = (schema.constructHook ? schema.constructHook(options) as BrowsePathOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.startingNode = initialize_field(schema.fields[0], options?.startingNode);
        this.relativePath  =  new RelativePath(options.relativePath);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.startingNode, stream);
        this.relativePath.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.startingNode = decodeNodeId(stream, this.startingNode);
        this.relativePath.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaBrowsePath; }
}
BrowsePath.schema.dataTypeNodeId = BrowsePath.dataTypeNodeId;
BrowsePath.schema.encodingDefaultBinary = BrowsePath.encodingDefaultBinary;
BrowsePath.schema.encodingDefaultXml = BrowsePath.encodingDefaultXml;
BrowsePath.schema.encodingDefaultJson = BrowsePath.encodingDefaultJson;
registerClassDefinition( BrowsePath.dataTypeNodeId, "BrowsePath", BrowsePath);
// --------------------------------------------------------------------------------------------
const schemaBrowsePathTarget = buildStructuredType({
    name: "BrowsePathTarget",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "TargetId",

            fieldType: "ExpandedNodeId",
        },
        {
            name: "RemainingPathIndex",

            fieldType: "UInt32",
        },
    ]
});
export interface BrowsePathTargetOptions {
    targetId?: ExpandedNodeId ;
    remainingPathIndex?: UInt32 ;
}
export class BrowsePathTarget extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaBrowsePathTarget; }
    public static possibleFields: string[] = [
          "targetId",
           "remainingPathIndex"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(546, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(548, 0);
    public static encodingDefaultXml = makeExpandedNodeId(547, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15191, 0);
    public targetId: ExpandedNodeId;
    public remainingPathIndex: UInt32;

    constructor(options?: BrowsePathTargetOptions | null) {

        super(options);

        if (options === null) {
            this.targetId = new ExpandedNodeId(null);
            this.remainingPathIndex = 0;
              return;
        }
        const schema = BrowsePathTarget.schema;
        options = (schema.constructHook ? schema.constructHook(options) as BrowsePathTargetOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.targetId = initialize_field(schema.fields[0], options?.targetId);
        this.remainingPathIndex = initialize_field(schema.fields[1], options?.remainingPathIndex);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeExpandedNodeId(this.targetId, stream);
        encodeUInt32(this.remainingPathIndex, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.targetId = decodeExpandedNodeId(stream, this.targetId);
        this.remainingPathIndex = decodeUInt32(stream, this.remainingPathIndex);
    }
    public get schema(): IStructuredTypeSchema { return schemaBrowsePathTarget; }
}
BrowsePathTarget.schema.dataTypeNodeId = BrowsePathTarget.dataTypeNodeId;
BrowsePathTarget.schema.encodingDefaultBinary = BrowsePathTarget.encodingDefaultBinary;
BrowsePathTarget.schema.encodingDefaultXml = BrowsePathTarget.encodingDefaultXml;
BrowsePathTarget.schema.encodingDefaultJson = BrowsePathTarget.encodingDefaultJson;
registerClassDefinition( BrowsePathTarget.dataTypeNodeId, "BrowsePathTarget", BrowsePathTarget);
// --------------------------------------------------------------------------------------------
const schemaBrowsePathResult = buildStructuredType({
    name: "BrowsePathResult",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "StatusCode",

            fieldType: "StatusCode",
        },
        {
            name: "Targets",

            fieldType: "BrowsePathTarget",
            isArray: true
        },
    ]
});
export interface BrowsePathResultOptions {
    statusCode?: StatusCode ;
    targets?: BrowsePathTargetOptions [] | null;
}
export class BrowsePathResult extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaBrowsePathResult; }
    public static possibleFields: string[] = [
          "statusCode",
           "targets"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(549, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(551, 0);
    public static encodingDefaultXml = makeExpandedNodeId(550, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15192, 0);
    public statusCode: StatusCode;
    public targets: BrowsePathTarget[] | null;

    constructor(options?: BrowsePathResultOptions | null) {

        super(options);

        if (options === null) {
            this.statusCode = StatusCodes.Good;
         this.targets =  null; /* null array */
              return;
        }
        const schema = BrowsePathResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) as BrowsePathResultOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.statusCode = initialize_field(schema.fields[0], options?.statusCode);
        this.targets = []; // should default
        if (options.targets) {
            assert(Array.isArray(options.targets));
            this.targets = options.targets.map((e: any) => new BrowsePathTarget(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeStatusCode(this.statusCode, stream);
        encodeArray(this.targets, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.statusCode = decodeStatusCode(stream, this.statusCode);
        this.targets = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new BrowsePathTarget(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaBrowsePathResult; }
}
BrowsePathResult.schema.dataTypeNodeId = BrowsePathResult.dataTypeNodeId;
BrowsePathResult.schema.encodingDefaultBinary = BrowsePathResult.encodingDefaultBinary;
BrowsePathResult.schema.encodingDefaultXml = BrowsePathResult.encodingDefaultXml;
BrowsePathResult.schema.encodingDefaultJson = BrowsePathResult.encodingDefaultJson;
registerClassDefinition( BrowsePathResult.dataTypeNodeId, "BrowsePathResult", BrowsePathResult);
// --------------------------------------------------------------------------------------------
const schemaViewDescription = buildStructuredType({
    name: "ViewDescription",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ViewId",

            fieldType: "NodeId",
        },
        {
            name: "Timestamp",

            fieldType: "DateTime",
        },
        {
            name: "ViewVersion",

            fieldType: "UInt32",
        },
    ]
});
export interface ViewDescriptionOptions {
    viewId?: (NodeIdLike | null);
    timestamp?: DateTime ;
    viewVersion?: UInt32 ;
}
export class ViewDescription extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaViewDescription; }
    public static possibleFields: string[] = [
          "viewId",
           "timestamp",
           "viewVersion"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(511, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(513, 0);
    public static encodingDefaultXml = makeExpandedNodeId(512, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15179, 0);
    public viewId: NodeId;
    public timestamp: DateTime;
    public viewVersion: UInt32;

    constructor(options?: ViewDescriptionOptions | null) {

        super(options);

        if (options === null) {
            this.viewId = new NodeId(null);
            this.timestamp = new Date();
            this.viewVersion = 0;
              return;
        }
        const schema = ViewDescription.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ViewDescriptionOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.viewId = initialize_field(schema.fields[0], options?.viewId);
        this.timestamp = initialize_field(schema.fields[1], options?.timestamp);
        this.viewVersion = initialize_field(schema.fields[2], options?.viewVersion);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.viewId, stream);
        encodeDateTime(this.timestamp, stream);
        encodeUInt32(this.viewVersion, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.viewId = decodeNodeId(stream, this.viewId);
        this.timestamp = decodeDateTime(stream, this.timestamp);
        this.viewVersion = decodeUInt32(stream, this.viewVersion);
    }
    public get schema(): IStructuredTypeSchema { return schemaViewDescription; }
}
ViewDescription.schema.dataTypeNodeId = ViewDescription.dataTypeNodeId;
ViewDescription.schema.encodingDefaultBinary = ViewDescription.encodingDefaultBinary;
ViewDescription.schema.encodingDefaultXml = ViewDescription.encodingDefaultXml;
ViewDescription.schema.encodingDefaultJson = ViewDescription.encodingDefaultJson;
registerClassDefinition( ViewDescription.dataTypeNodeId, "ViewDescription", ViewDescription);
// --------------------------------------------------------------------------------------------
const schemaBrowseRequest = buildStructuredType({
    name: "BrowseRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
        {
            name: "View",

            fieldType: "ViewDescription",
        },
        {
            name: "RequestedMaxReferencesPerNode",

            fieldType: "UInt32",
        },
        {
            name: "NodesToBrowse",

            fieldType: "BrowseDescription",
            isArray: true
        },
    ]
});
export interface BrowseRequestOptions {
    requestHeader?: RequestHeaderOptions ;
    view?: ViewDescriptionOptions ;
    requestedMaxReferencesPerNode?: UInt32 ;
    nodesToBrowse?: BrowseDescriptionOptions [] | null;
}
export class BrowseRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaBrowseRequest; }
    public static possibleFields: string[] = [
          "requestHeader",
           "view",
           "requestedMaxReferencesPerNode",
           "nodesToBrowse"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(525, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(527, 0);
    public static encodingDefaultXml = makeExpandedNodeId(526, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15184, 0);
    public requestHeader: RequestHeader;
    public view: ViewDescription;
    public requestedMaxReferencesPerNode: UInt32;
    public nodesToBrowse: BrowseDescription[] | null;

    constructor(options?: BrowseRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
         this.view =  new ViewDescription(null);
            this.requestedMaxReferencesPerNode = 0;
         this.nodesToBrowse =  null; /* null array */
              return;
        }
        const schema = BrowseRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as BrowseRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
        this.view  =  new ViewDescription(options.view);
        this.requestedMaxReferencesPerNode = initialize_field(schema.fields[2], options?.requestedMaxReferencesPerNode);
        this.nodesToBrowse = []; // should default
        if (options.nodesToBrowse) {
            assert(Array.isArray(options.nodesToBrowse));
            this.nodesToBrowse = options.nodesToBrowse.map((e: any) => new BrowseDescription(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        this.view.encode(stream);
        encodeUInt32(this.requestedMaxReferencesPerNode, stream);
        encodeArray(this.nodesToBrowse, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.view.decode(stream);
        this.requestedMaxReferencesPerNode = decodeUInt32(stream, this.requestedMaxReferencesPerNode);
        this.nodesToBrowse = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new BrowseDescription(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaBrowseRequest; }
}
BrowseRequest.schema.dataTypeNodeId = BrowseRequest.dataTypeNodeId;
BrowseRequest.schema.encodingDefaultBinary = BrowseRequest.encodingDefaultBinary;
BrowseRequest.schema.encodingDefaultXml = BrowseRequest.encodingDefaultXml;
BrowseRequest.schema.encodingDefaultJson = BrowseRequest.encodingDefaultJson;
registerClassDefinition( BrowseRequest.dataTypeNodeId, "BrowseRequest", BrowseRequest);
// --------------------------------------------------------------------------------------------
const schemaBrowseResponse = buildStructuredType({
    name: "BrowseResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
        {
            name: "Results",

            fieldType: "BrowseResult",
            isArray: true
        },
        {
            name: "DiagnosticInfos",

            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
export interface BrowseResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
    results?: BrowseResultOptions [] | null;
    diagnosticInfos?: (DiagnosticInfo | null)[] | null;
}
export class BrowseResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaBrowseResponse; }
    public static possibleFields: string[] = [
          "responseHeader",
           "results",
           "diagnosticInfos"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(528, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(530, 0);
    public static encodingDefaultXml = makeExpandedNodeId(529, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15185, 0);
    public responseHeader: ResponseHeader;
    public results: BrowseResult[] | null;
    public diagnosticInfos: (DiagnosticInfo | null)[] | null;

    constructor(options?: BrowseResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
         this.results =  null; /* null array */
            this.diagnosticInfos = []
              return;
        }
        const schema = BrowseResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as BrowseResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
        this.results = []; // should default
        if (options.results) {
            assert(Array.isArray(options.results));
            this.results = options.results.map((e: any) => new BrowseResult(e));
        }
        this.diagnosticInfos = initialize_field_array(schema.fields[2], options?.diagnosticInfos);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        encodeArray(this.results, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.diagnosticInfos, stream, encodeDiagnosticInfo);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new BrowseResult(null);
            obj.decode(stream1);
            return obj;
        });
        this.diagnosticInfos = decodeArray(stream, decodeDiagnosticInfo);
    }
    public get schema(): IStructuredTypeSchema { return schemaBrowseResponse; }
}
BrowseResponse.schema.dataTypeNodeId = BrowseResponse.dataTypeNodeId;
BrowseResponse.schema.encodingDefaultBinary = BrowseResponse.encodingDefaultBinary;
BrowseResponse.schema.encodingDefaultXml = BrowseResponse.encodingDefaultXml;
BrowseResponse.schema.encodingDefaultJson = BrowseResponse.encodingDefaultJson;
registerClassDefinition( BrowseResponse.dataTypeNodeId, "BrowseResponse", BrowseResponse);
// --------------------------------------------------------------------------------------------
const schemaBuildInfo = buildStructuredType({
    name: "BuildInfo",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ProductUri",

            fieldType: "String",
        },
        {
            name: "ManufacturerName",

            fieldType: "String",
        },
        {
            name: "ProductName",

            fieldType: "String",
        },
        {
            name: "SoftwareVersion",

            fieldType: "String",
        },
        {
            name: "BuildNumber",

            fieldType: "String",
        },
        {
            name: "BuildDate",

            fieldType: "DateTime",
        },
    ]
});
export interface BuildInfoOptions {
    productUri?: UAString ;
    manufacturerName?: UAString ;
    productName?: UAString ;
    softwareVersion?: UAString ;
    buildNumber?: UAString ;
    buildDate?: DateTime ;
}
export class BuildInfo extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaBuildInfo; }
    public static possibleFields: string[] = [
          "productUri",
           "manufacturerName",
           "productName",
           "softwareVersion",
           "buildNumber",
           "buildDate"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(338, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(340, 0);
    public static encodingDefaultXml = makeExpandedNodeId(339, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15361, 0);
    public productUri: UAString;
    public manufacturerName: UAString;
    public productName: UAString;
    public softwareVersion: UAString;
    public buildNumber: UAString;
    public buildDate: DateTime;

    constructor(options?: BuildInfoOptions | null) {

        super(options);

        if (options === null) {
            this.productUri = null;
            this.manufacturerName = null;
            this.productName = null;
            this.softwareVersion = null;
            this.buildNumber = null;
            this.buildDate = new Date();
              return;
        }
        const schema = BuildInfo.schema;
        options = (schema.constructHook ? schema.constructHook(options) as BuildInfoOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.productUri = initialize_field(schema.fields[0], options?.productUri);
        this.manufacturerName = initialize_field(schema.fields[1], options?.manufacturerName);
        this.productName = initialize_field(schema.fields[2], options?.productName);
        this.softwareVersion = initialize_field(schema.fields[3], options?.softwareVersion);
        this.buildNumber = initialize_field(schema.fields[4], options?.buildNumber);
        this.buildDate = initialize_field(schema.fields[5], options?.buildDate);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.productUri, stream);
        encodeString(this.manufacturerName, stream);
        encodeString(this.productName, stream);
        encodeString(this.softwareVersion, stream);
        encodeString(this.buildNumber, stream);
        encodeDateTime(this.buildDate, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.productUri = decodeString(stream, this.productUri);
        this.manufacturerName = decodeString(stream, this.manufacturerName);
        this.productName = decodeString(stream, this.productName);
        this.softwareVersion = decodeString(stream, this.softwareVersion);
        this.buildNumber = decodeString(stream, this.buildNumber);
        this.buildDate = decodeDateTime(stream, this.buildDate);
    }
    public get schema(): IStructuredTypeSchema { return schemaBuildInfo; }
}
BuildInfo.schema.dataTypeNodeId = BuildInfo.dataTypeNodeId;
BuildInfo.schema.encodingDefaultBinary = BuildInfo.encodingDefaultBinary;
BuildInfo.schema.encodingDefaultXml = BuildInfo.encodingDefaultXml;
BuildInfo.schema.encodingDefaultJson = BuildInfo.encodingDefaultJson;
registerClassDefinition( BuildInfo.dataTypeNodeId, "BuildInfo", BuildInfo);
// --------------------------------------------------------------------------------------------
const schemaCallMethodRequest = buildStructuredType({
    name: "CallMethodRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ObjectId",

            fieldType: "NodeId",
        },
        {
            name: "MethodId",

            fieldType: "NodeId",
        },
        {
            name: "InputArguments",

            fieldType: "Variant",
            isArray: true
        },
    ]
});
export interface CallMethodRequestOptions {
    objectId?: (NodeIdLike | null);
    methodId?: (NodeIdLike | null);
    inputArguments?: (VariantLike | null)[] | null;
}
export class CallMethodRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaCallMethodRequest; }
    public static possibleFields: string[] = [
          "objectId",
           "methodId",
           "inputArguments"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(704, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(706, 0);
    public static encodingDefaultXml = makeExpandedNodeId(705, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15289, 0);
    public objectId: NodeId;
    public methodId: NodeId;
    public inputArguments: Variant[] | null;

    constructor(options?: CallMethodRequestOptions | null) {

        super(options);

        if (options === null) {
            this.objectId = new NodeId(null);
            this.methodId = new NodeId(null);
            this.inputArguments = []
              return;
        }
        const schema = CallMethodRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as CallMethodRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.objectId = initialize_field(schema.fields[0], options?.objectId);
        this.methodId = initialize_field(schema.fields[1], options?.methodId);
        this.inputArguments = initialize_field_array(schema.fields[2], options?.inputArguments);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.objectId, stream);
        encodeNodeId(this.methodId, stream);
        encodeArray(this.inputArguments, stream, encodeVariant);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.objectId = decodeNodeId(stream, this.objectId);
        this.methodId = decodeNodeId(stream, this.methodId);
        this.inputArguments = decodeArray(stream, decodeVariant);
    }
    public get schema(): IStructuredTypeSchema { return schemaCallMethodRequest; }
}
CallMethodRequest.schema.dataTypeNodeId = CallMethodRequest.dataTypeNodeId;
CallMethodRequest.schema.encodingDefaultBinary = CallMethodRequest.encodingDefaultBinary;
CallMethodRequest.schema.encodingDefaultXml = CallMethodRequest.encodingDefaultXml;
CallMethodRequest.schema.encodingDefaultJson = CallMethodRequest.encodingDefaultJson;
registerClassDefinition( CallMethodRequest.dataTypeNodeId, "CallMethodRequest", CallMethodRequest);
// --------------------------------------------------------------------------------------------
const schemaCallMethodResult = buildStructuredType({
    name: "CallMethodResult",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "StatusCode",

            fieldType: "StatusCode",
        },
        {
            name: "InputArgumentResults",

            fieldType: "StatusCode",
            isArray: true
        },
        {
            name: "InputArgumentDiagnosticInfos",

            fieldType: "DiagnosticInfo",
            isArray: true
        },
        {
            name: "OutputArguments",

            fieldType: "Variant",
            isArray: true
        },
    ]
});
export interface CallMethodResultOptions {
    statusCode?: StatusCode ;
    inputArgumentResults?: StatusCode [] | null;
    inputArgumentDiagnosticInfos?: (DiagnosticInfo | null)[] | null;
    outputArguments?: (VariantLike | null)[] | null;
}
export class CallMethodResult extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaCallMethodResult; }
    public static possibleFields: string[] = [
          "statusCode",
           "inputArgumentResults",
           "inputArgumentDiagnosticInfos",
           "outputArguments"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(707, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(709, 0);
    public static encodingDefaultXml = makeExpandedNodeId(708, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15290, 0);
    public statusCode: StatusCode;
    public inputArgumentResults: StatusCode[] | null;
    public inputArgumentDiagnosticInfos: (DiagnosticInfo | null)[] | null;
    public outputArguments: Variant[] | null;

    constructor(options?: CallMethodResultOptions | null) {

        super(options);

        if (options === null) {
            this.statusCode = StatusCodes.Good;
            this.inputArgumentResults = []
            this.inputArgumentDiagnosticInfos = []
            this.outputArguments = []
              return;
        }
        const schema = CallMethodResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) as CallMethodResultOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.statusCode = initialize_field(schema.fields[0], options?.statusCode);
        this.inputArgumentResults = initialize_field_array(schema.fields[1], options?.inputArgumentResults);
        this.inputArgumentDiagnosticInfos = initialize_field_array(schema.fields[2], options?.inputArgumentDiagnosticInfos);
        this.outputArguments = initialize_field_array(schema.fields[3], options?.outputArguments);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeStatusCode(this.statusCode, stream);
        encodeArray(this.inputArgumentResults, stream, encodeStatusCode);
        encodeArray(this.inputArgumentDiagnosticInfos, stream, encodeDiagnosticInfo);
        encodeArray(this.outputArguments, stream, encodeVariant);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.statusCode = decodeStatusCode(stream, this.statusCode);
        this.inputArgumentResults = decodeArray(stream, decodeStatusCode);
        this.inputArgumentDiagnosticInfos = decodeArray(stream, decodeDiagnosticInfo);
        this.outputArguments = decodeArray(stream, decodeVariant);
    }
    public get schema(): IStructuredTypeSchema { return schemaCallMethodResult; }
}
CallMethodResult.schema.dataTypeNodeId = CallMethodResult.dataTypeNodeId;
CallMethodResult.schema.encodingDefaultBinary = CallMethodResult.encodingDefaultBinary;
CallMethodResult.schema.encodingDefaultXml = CallMethodResult.encodingDefaultXml;
CallMethodResult.schema.encodingDefaultJson = CallMethodResult.encodingDefaultJson;
registerClassDefinition( CallMethodResult.dataTypeNodeId, "CallMethodResult", CallMethodResult);
// --------------------------------------------------------------------------------------------
const schemaCallRequest = buildStructuredType({
    name: "CallRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
        {
            name: "MethodsToCall",

            fieldType: "CallMethodRequest",
            isArray: true
        },
    ]
});
export interface CallRequestOptions {
    requestHeader?: RequestHeaderOptions ;
    methodsToCall?: CallMethodRequestOptions [] | null;
}
export class CallRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaCallRequest; }
    public static possibleFields: string[] = [
          "requestHeader",
           "methodsToCall"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(710, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(712, 0);
    public static encodingDefaultXml = makeExpandedNodeId(711, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15291, 0);
    public requestHeader: RequestHeader;
    public methodsToCall: CallMethodRequest[] | null;

    constructor(options?: CallRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
         this.methodsToCall =  null; /* null array */
              return;
        }
        const schema = CallRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as CallRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
        this.methodsToCall = []; // should default
        if (options.methodsToCall) {
            assert(Array.isArray(options.methodsToCall));
            this.methodsToCall = options.methodsToCall.map((e: any) => new CallMethodRequest(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        encodeArray(this.methodsToCall, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.methodsToCall = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new CallMethodRequest(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaCallRequest; }
}
CallRequest.schema.dataTypeNodeId = CallRequest.dataTypeNodeId;
CallRequest.schema.encodingDefaultBinary = CallRequest.encodingDefaultBinary;
CallRequest.schema.encodingDefaultXml = CallRequest.encodingDefaultXml;
CallRequest.schema.encodingDefaultJson = CallRequest.encodingDefaultJson;
registerClassDefinition( CallRequest.dataTypeNodeId, "CallRequest", CallRequest);
// --------------------------------------------------------------------------------------------
const schemaCallResponse = buildStructuredType({
    name: "CallResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
        {
            name: "Results",

            fieldType: "CallMethodResult",
            isArray: true
        },
        {
            name: "DiagnosticInfos",

            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
export interface CallResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
    results?: CallMethodResultOptions [] | null;
    diagnosticInfos?: (DiagnosticInfo | null)[] | null;
}
export class CallResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaCallResponse; }
    public static possibleFields: string[] = [
          "responseHeader",
           "results",
           "diagnosticInfos"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(713, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(715, 0);
    public static encodingDefaultXml = makeExpandedNodeId(714, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15292, 0);
    public responseHeader: ResponseHeader;
    public results: CallMethodResult[] | null;
    public diagnosticInfos: (DiagnosticInfo | null)[] | null;

    constructor(options?: CallResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
         this.results =  null; /* null array */
            this.diagnosticInfos = []
              return;
        }
        const schema = CallResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as CallResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
        this.results = []; // should default
        if (options.results) {
            assert(Array.isArray(options.results));
            this.results = options.results.map((e: any) => new CallMethodResult(e));
        }
        this.diagnosticInfos = initialize_field_array(schema.fields[2], options?.diagnosticInfos);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        encodeArray(this.results, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.diagnosticInfos, stream, encodeDiagnosticInfo);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new CallMethodResult(null);
            obj.decode(stream1);
            return obj;
        });
        this.diagnosticInfos = decodeArray(stream, decodeDiagnosticInfo);
    }
    public get schema(): IStructuredTypeSchema { return schemaCallResponse; }
}
CallResponse.schema.dataTypeNodeId = CallResponse.dataTypeNodeId;
CallResponse.schema.encodingDefaultBinary = CallResponse.encodingDefaultBinary;
CallResponse.schema.encodingDefaultXml = CallResponse.encodingDefaultXml;
CallResponse.schema.encodingDefaultJson = CallResponse.encodingDefaultJson;
registerClassDefinition( CallResponse.dataTypeNodeId, "CallResponse", CallResponse);
// --------------------------------------------------------------------------------------------
const schemaCancelRequest = buildStructuredType({
    name: "CancelRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
        {
            name: "RequestHandle",

            fieldType: "UInt32",
        },
    ]
});
export interface CancelRequestOptions {
    requestHeader?: RequestHeaderOptions ;
    requestHandle?: UInt32 ;
}
export class CancelRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaCancelRequest; }
    public static possibleFields: string[] = [
          "requestHeader",
           "requestHandle"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(477, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(479, 0);
    public static encodingDefaultXml = makeExpandedNodeId(478, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15149, 0);
    public requestHeader: RequestHeader;
    public requestHandle: UInt32;

    constructor(options?: CancelRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
            this.requestHandle = 0;
              return;
        }
        const schema = CancelRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as CancelRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
        this.requestHandle = initialize_field(schema.fields[1], options?.requestHandle);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        encodeUInt32(this.requestHandle, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.requestHandle = decodeUInt32(stream, this.requestHandle);
    }
    public get schema(): IStructuredTypeSchema { return schemaCancelRequest; }
}
CancelRequest.schema.dataTypeNodeId = CancelRequest.dataTypeNodeId;
CancelRequest.schema.encodingDefaultBinary = CancelRequest.encodingDefaultBinary;
CancelRequest.schema.encodingDefaultXml = CancelRequest.encodingDefaultXml;
CancelRequest.schema.encodingDefaultJson = CancelRequest.encodingDefaultJson;
registerClassDefinition( CancelRequest.dataTypeNodeId, "CancelRequest", CancelRequest);
// --------------------------------------------------------------------------------------------
const schemaCancelResponse = buildStructuredType({
    name: "CancelResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
        {
            name: "CancelCount",

            fieldType: "UInt32",
        },
    ]
});
export interface CancelResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
    cancelCount?: UInt32 ;
}
export class CancelResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaCancelResponse; }
    public static possibleFields: string[] = [
          "responseHeader",
           "cancelCount"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(480, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(482, 0);
    public static encodingDefaultXml = makeExpandedNodeId(481, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15150, 0);
    public responseHeader: ResponseHeader;
    public cancelCount: UInt32;

    constructor(options?: CancelResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
            this.cancelCount = 0;
              return;
        }
        const schema = CancelResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as CancelResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
        this.cancelCount = initialize_field(schema.fields[1], options?.cancelCount);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        encodeUInt32(this.cancelCount, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.cancelCount = decodeUInt32(stream, this.cancelCount);
    }
    public get schema(): IStructuredTypeSchema { return schemaCancelResponse; }
}
CancelResponse.schema.dataTypeNodeId = CancelResponse.dataTypeNodeId;
CancelResponse.schema.encodingDefaultBinary = CancelResponse.encodingDefaultBinary;
CancelResponse.schema.encodingDefaultXml = CancelResponse.encodingDefaultXml;
CancelResponse.schema.encodingDefaultJson = CancelResponse.encodingDefaultJson;
registerClassDefinition( CancelResponse.dataTypeNodeId, "CancelResponse", CancelResponse);
// --------------------------------------------------------------------------------------------
const schemaCartesianCoordinates = buildStructuredType({
    name: "CartesianCoordinates",

    baseType: "ExtensionObject",
    fields: [
    ]
});
export interface CartesianCoordinatesOptions {
}
export class CartesianCoordinates extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaCartesianCoordinates; }
    public static possibleFields: string[] = [
          
    ];
    public static dataTypeNodeId = makeExpandedNodeId(18809, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(18818, 0);
    public static encodingDefaultXml = makeExpandedNodeId(18854, 0);
    public static encodingDefaultJson = makeExpandedNodeId(19067, 0);

    constructor(options?: CartesianCoordinatesOptions | null) {

        super(options);

        if (options === null) {
              return;
        }
        const schema = CartesianCoordinates.schema;
        options = (schema.constructHook ? schema.constructHook(options) as CartesianCoordinatesOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaCartesianCoordinates; }
}
CartesianCoordinates.schema.dataTypeNodeId = CartesianCoordinates.dataTypeNodeId;
CartesianCoordinates.schema.encodingDefaultBinary = CartesianCoordinates.encodingDefaultBinary;
CartesianCoordinates.schema.encodingDefaultXml = CartesianCoordinates.encodingDefaultXml;
CartesianCoordinates.schema.encodingDefaultJson = CartesianCoordinates.encodingDefaultJson;
registerClassDefinition( CartesianCoordinates.dataTypeNodeId, "CartesianCoordinates", CartesianCoordinates);
// --------------------------------------------------------------------------------------------
const schemaChannelSecurityToken = buildStructuredType({
    name: "ChannelSecurityToken",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ChannelId",

            fieldType: "UInt32",
        },
        {
            name: "TokenId",

            fieldType: "UInt32",
        },
        {
            name: "CreatedAt",

            fieldType: "DateTime",
        },
        {
            name: "RevisedLifetime",

            fieldType: "UInt32",
        },
    ]
});
export interface ChannelSecurityTokenOptions {
    channelId?: UInt32 ;
    tokenId?: UInt32 ;
    createdAt?: DateTime ;
    revisedLifetime?: UInt32 ;
}
export class ChannelSecurityToken extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaChannelSecurityToken; }
    public static possibleFields: string[] = [
          "channelId",
           "tokenId",
           "createdAt",
           "revisedLifetime"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(441, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(443, 0);
    public static encodingDefaultXml = makeExpandedNodeId(442, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15131, 0);
    public channelId: UInt32;
    public tokenId: UInt32;
    public createdAt: DateTime;
    public revisedLifetime: UInt32;

    constructor(options?: ChannelSecurityTokenOptions | null) {

        super(options);

        if (options === null) {
            this.channelId = 0;
            this.tokenId = 0;
            this.createdAt = new Date();
            this.revisedLifetime = 0;
              return;
        }
        const schema = ChannelSecurityToken.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ChannelSecurityTokenOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.channelId = initialize_field(schema.fields[0], options?.channelId);
        this.tokenId = initialize_field(schema.fields[1], options?.tokenId);
        this.createdAt = initialize_field(schema.fields[2], options?.createdAt);
        this.revisedLifetime = initialize_field(schema.fields[3], options?.revisedLifetime);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeUInt32(this.channelId, stream);
        encodeUInt32(this.tokenId, stream);
        encodeDateTime(this.createdAt, stream);
        encodeUInt32(this.revisedLifetime, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.channelId = decodeUInt32(stream, this.channelId);
        this.tokenId = decodeUInt32(stream, this.tokenId);
        this.createdAt = decodeDateTime(stream, this.createdAt);
        this.revisedLifetime = decodeUInt32(stream, this.revisedLifetime);
    }
    public get schema(): IStructuredTypeSchema { return schemaChannelSecurityToken; }
}
ChannelSecurityToken.schema.dataTypeNodeId = ChannelSecurityToken.dataTypeNodeId;
ChannelSecurityToken.schema.encodingDefaultBinary = ChannelSecurityToken.encodingDefaultBinary;
ChannelSecurityToken.schema.encodingDefaultXml = ChannelSecurityToken.encodingDefaultXml;
ChannelSecurityToken.schema.encodingDefaultJson = ChannelSecurityToken.encodingDefaultJson;
registerClassDefinition( ChannelSecurityToken.dataTypeNodeId, "ChannelSecurityToken", ChannelSecurityToken);
// --------------------------------------------------------------------------------------------
const schemaCloseSecureChannelRequest = buildStructuredType({
    name: "CloseSecureChannelRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
    ]
});
export interface CloseSecureChannelRequestOptions {
    requestHeader?: RequestHeaderOptions ;
}
export class CloseSecureChannelRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaCloseSecureChannelRequest; }
    public static possibleFields: string[] = [
          "requestHeader"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(450, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(452, 0);
    public static encodingDefaultXml = makeExpandedNodeId(451, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15134, 0);
    public requestHeader: RequestHeader;

    constructor(options?: CloseSecureChannelRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
              return;
        }
        const schema = CloseSecureChannelRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as CloseSecureChannelRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaCloseSecureChannelRequest; }
}
CloseSecureChannelRequest.schema.dataTypeNodeId = CloseSecureChannelRequest.dataTypeNodeId;
CloseSecureChannelRequest.schema.encodingDefaultBinary = CloseSecureChannelRequest.encodingDefaultBinary;
CloseSecureChannelRequest.schema.encodingDefaultXml = CloseSecureChannelRequest.encodingDefaultXml;
CloseSecureChannelRequest.schema.encodingDefaultJson = CloseSecureChannelRequest.encodingDefaultJson;
registerClassDefinition( CloseSecureChannelRequest.dataTypeNodeId, "CloseSecureChannelRequest", CloseSecureChannelRequest);
// --------------------------------------------------------------------------------------------
const schemaCloseSecureChannelResponse = buildStructuredType({
    name: "CloseSecureChannelResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
    ]
});
export interface CloseSecureChannelResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
}
export class CloseSecureChannelResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaCloseSecureChannelResponse; }
    public static possibleFields: string[] = [
          "responseHeader"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(453, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(455, 0);
    public static encodingDefaultXml = makeExpandedNodeId(454, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15135, 0);
    public responseHeader: ResponseHeader;

    constructor(options?: CloseSecureChannelResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
              return;
        }
        const schema = CloseSecureChannelResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as CloseSecureChannelResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaCloseSecureChannelResponse; }
}
CloseSecureChannelResponse.schema.dataTypeNodeId = CloseSecureChannelResponse.dataTypeNodeId;
CloseSecureChannelResponse.schema.encodingDefaultBinary = CloseSecureChannelResponse.encodingDefaultBinary;
CloseSecureChannelResponse.schema.encodingDefaultXml = CloseSecureChannelResponse.encodingDefaultXml;
CloseSecureChannelResponse.schema.encodingDefaultJson = CloseSecureChannelResponse.encodingDefaultJson;
registerClassDefinition( CloseSecureChannelResponse.dataTypeNodeId, "CloseSecureChannelResponse", CloseSecureChannelResponse);
// --------------------------------------------------------------------------------------------
const schemaCloseSessionRequest = buildStructuredType({
    name: "CloseSessionRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
        {
            name: "DeleteSubscriptions",

            fieldType: "Boolean",
        },
    ]
});
export interface CloseSessionRequestOptions {
    requestHeader?: RequestHeaderOptions ;
    deleteSubscriptions?: UABoolean ;
}
export class CloseSessionRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaCloseSessionRequest; }
    public static possibleFields: string[] = [
          "requestHeader",
           "deleteSubscriptions"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(471, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(473, 0);
    public static encodingDefaultXml = makeExpandedNodeId(472, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15147, 0);
    public requestHeader: RequestHeader;
    public deleteSubscriptions: UABoolean;

    constructor(options?: CloseSessionRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
            this.deleteSubscriptions = false;
              return;
        }
        const schema = CloseSessionRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as CloseSessionRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
        this.deleteSubscriptions = initialize_field(schema.fields[1], options?.deleteSubscriptions);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        encodeBoolean(this.deleteSubscriptions, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.deleteSubscriptions = decodeBoolean(stream, this.deleteSubscriptions);
    }
    public get schema(): IStructuredTypeSchema { return schemaCloseSessionRequest; }
}
CloseSessionRequest.schema.dataTypeNodeId = CloseSessionRequest.dataTypeNodeId;
CloseSessionRequest.schema.encodingDefaultBinary = CloseSessionRequest.encodingDefaultBinary;
CloseSessionRequest.schema.encodingDefaultXml = CloseSessionRequest.encodingDefaultXml;
CloseSessionRequest.schema.encodingDefaultJson = CloseSessionRequest.encodingDefaultJson;
registerClassDefinition( CloseSessionRequest.dataTypeNodeId, "CloseSessionRequest", CloseSessionRequest);
// --------------------------------------------------------------------------------------------
const schemaCloseSessionResponse = buildStructuredType({
    name: "CloseSessionResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
    ]
});
export interface CloseSessionResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
}
export class CloseSessionResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaCloseSessionResponse; }
    public static possibleFields: string[] = [
          "responseHeader"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(474, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(476, 0);
    public static encodingDefaultXml = makeExpandedNodeId(475, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15148, 0);
    public responseHeader: ResponseHeader;

    constructor(options?: CloseSessionResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
              return;
        }
        const schema = CloseSessionResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as CloseSessionResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaCloseSessionResponse; }
}
CloseSessionResponse.schema.dataTypeNodeId = CloseSessionResponse.dataTypeNodeId;
CloseSessionResponse.schema.encodingDefaultBinary = CloseSessionResponse.encodingDefaultBinary;
CloseSessionResponse.schema.encodingDefaultXml = CloseSessionResponse.encodingDefaultXml;
CloseSessionResponse.schema.encodingDefaultJson = CloseSessionResponse.encodingDefaultJson;
registerClassDefinition( CloseSessionResponse.dataTypeNodeId, "CloseSessionResponse", CloseSessionResponse);
// --------------------------------------------------------------------------------------------
const schemaComplexNumberType = buildStructuredType({
    name: "ComplexNumberType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Real",

            fieldType: "Float",
        },
        {
            name: "Imaginary",

            fieldType: "Float",
        },
    ]
});
export interface ComplexNumberTypeOptions {
    real?: Float ;
    imaginary?: Float ;
}
export class ComplexNumberType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaComplexNumberType; }
    public static possibleFields: string[] = [
          "real",
           "imaginary"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(12171, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(12181, 0);
    public static encodingDefaultXml = makeExpandedNodeId(12173, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15377, 0);
    public real: Float;
    public imaginary: Float;

    constructor(options?: ComplexNumberTypeOptions | null) {

        super(options);

        if (options === null) {
            this.real = 0;
            this.imaginary = 0;
              return;
        }
        const schema = ComplexNumberType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ComplexNumberTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.real = initialize_field(schema.fields[0], options?.real);
        this.imaginary = initialize_field(schema.fields[1], options?.imaginary);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeFloat(this.real, stream);
        encodeFloat(this.imaginary, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.real = decodeFloat(stream, this.real);
        this.imaginary = decodeFloat(stream, this.imaginary);
    }
    public get schema(): IStructuredTypeSchema { return schemaComplexNumberType; }
}
ComplexNumberType.schema.dataTypeNodeId = ComplexNumberType.dataTypeNodeId;
ComplexNumberType.schema.encodingDefaultBinary = ComplexNumberType.encodingDefaultBinary;
ComplexNumberType.schema.encodingDefaultXml = ComplexNumberType.encodingDefaultXml;
ComplexNumberType.schema.encodingDefaultJson = ComplexNumberType.encodingDefaultJson;
registerClassDefinition( ComplexNumberType.dataTypeNodeId, "ComplexNumberType", ComplexNumberType);
// --------------------------------------------------------------------------------------------
const schemaConfigurationVersionDataType = buildStructuredType({
    name: "ConfigurationVersionDataType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "MajorVersion",

            fieldType: "UInt32",
        },
        {
            name: "MinorVersion",

            fieldType: "UInt32",
        },
    ]
});
export interface ConfigurationVersionDataTypeOptions {
    majorVersion?: UInt32 ;
    minorVersion?: UInt32 ;
}
export class ConfigurationVersionDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaConfigurationVersionDataType; }
    public static possibleFields: string[] = [
          "majorVersion",
           "minorVersion"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(14593, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(14847, 0);
    public static encodingDefaultXml = makeExpandedNodeId(14803, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15049, 0);
    public majorVersion: UInt32;
    public minorVersion: UInt32;

    constructor(options?: ConfigurationVersionDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.majorVersion = 0;
            this.minorVersion = 0;
              return;
        }
        const schema = ConfigurationVersionDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ConfigurationVersionDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.majorVersion = initialize_field(schema.fields[0], options?.majorVersion);
        this.minorVersion = initialize_field(schema.fields[1], options?.minorVersion);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeUInt32(this.majorVersion, stream);
        encodeUInt32(this.minorVersion, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.majorVersion = decodeUInt32(stream, this.majorVersion);
        this.minorVersion = decodeUInt32(stream, this.minorVersion);
    }
    public get schema(): IStructuredTypeSchema { return schemaConfigurationVersionDataType; }
}
ConfigurationVersionDataType.schema.dataTypeNodeId = ConfigurationVersionDataType.dataTypeNodeId;
ConfigurationVersionDataType.schema.encodingDefaultBinary = ConfigurationVersionDataType.encodingDefaultBinary;
ConfigurationVersionDataType.schema.encodingDefaultXml = ConfigurationVersionDataType.encodingDefaultXml;
ConfigurationVersionDataType.schema.encodingDefaultJson = ConfigurationVersionDataType.encodingDefaultJson;
registerClassDefinition( ConfigurationVersionDataType.dataTypeNodeId, "ConfigurationVersionDataType", ConfigurationVersionDataType);

// --------------------------------------------------------------------------------------------
export enum FilterOperator {
    Equals = 0,
    IsNull = 1,
    GreaterThan = 2,
    LessThan = 3,
    GreaterThanOrEqual = 4,
    LessThanOrEqual = 5,
    Like = 6,
    Not = 7,
    Between = 8,
    InList = 9,
    And = 10,
    Or = 11,
    Cast = 12,
    InView = 13,
    OfType = 14,
    RelatedTo = 15,
    BitwiseAnd = 16,
    BitwiseOr = 17,
    Invalid = 4294967295
}
const schemaFilterOperator = {
    enumValues: FilterOperator,
    flaggable: false,
    minValue: 0,
    maxValue: 17,
    name: "FilterOperator"
};
function decodeFilterOperator(stream: BinaryStream, _value?: FilterOperator): FilterOperator {
    let value =  stream.readUInt32() as FilterOperator;
    value = (value < schemaFilterOperator.minValue || value > schemaFilterOperator.maxValue) ? FilterOperator.Invalid : value; 
    return value;
}
function encodeFilterOperator(value: FilterOperator, stream: OutputBinaryStream): void {
    stream.writeUInt32(value);
}
export const _enumerationFilterOperator = registerEnumeration(schemaFilterOperator);
assert(_enumerationFilterOperator.isFlaggable ===  false);
// --------------------------------------------------------------------------------------------
const schemaContentFilterElement = buildStructuredType({
    name: "ContentFilterElement",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "FilterOperator",

            fieldType: "FilterOperator",
        },
        {
            name: "FilterOperands",

            fieldType: "ExtensionObject",
            isArray: true
        },
    ]
});
export interface ContentFilterElementOptions {
    filterOperator?: FilterOperator;
    filterOperands?: (ExtensionObject | null)[] | null;
}
export class ContentFilterElement extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaContentFilterElement; }
    public static possibleFields: string[] = [
          "filterOperator",
           "filterOperands"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(583, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(585, 0);
    public static encodingDefaultXml = makeExpandedNodeId(584, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15204, 0);
    public filterOperator: FilterOperator;
    public filterOperands: (ExtensionObject | null)[] | null;

    constructor(options?: ContentFilterElementOptions | null) {

        super(options);

        if (options === null) {
             this.filterOperator =  0 as  FilterOperator;
            this.filterOperands = []
              return;
        }
        const schema = ContentFilterElement.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ContentFilterElementOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.filterOperator = this.setFilterOperator(initialize_field(schema.fields[0], options?.filterOperator));
        this.filterOperands = initialize_field_array(schema.fields[1], options?.filterOperands);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeFilterOperator(this.filterOperator, stream);
        encodeArray(this.filterOperands, stream, encodeExtensionObject);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.filterOperator = decodeFilterOperator(stream, this.filterOperator);
        this.filterOperands = decodeArray(stream, decodeExtensionObject);
    }

    // Define Enumeration setters
    public setFilterOperator(value: any): FilterOperator {
        const coercedValue = _enumerationFilterOperator.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to FilterOperator :" + value);
        }
        this.filterOperator = coercedValue.value as FilterOperator;
        return this.filterOperator;
    }
    public get schema(): IStructuredTypeSchema { return schemaContentFilterElement; }
}
ContentFilterElement.schema.dataTypeNodeId = ContentFilterElement.dataTypeNodeId;
ContentFilterElement.schema.encodingDefaultBinary = ContentFilterElement.encodingDefaultBinary;
ContentFilterElement.schema.encodingDefaultXml = ContentFilterElement.encodingDefaultXml;
ContentFilterElement.schema.encodingDefaultJson = ContentFilterElement.encodingDefaultJson;
registerClassDefinition( ContentFilterElement.dataTypeNodeId, "ContentFilterElement", ContentFilterElement);
// --------------------------------------------------------------------------------------------
const schemaContentFilter = buildStructuredType({
    name: "ContentFilter",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Elements",

            fieldType: "ContentFilterElement",
            isArray: true
        },
    ]
});
export interface ContentFilterOptions {
    elements?: ContentFilterElementOptions [] | null;
}
export class ContentFilter extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaContentFilter; }
    public static possibleFields: string[] = [
          "elements"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(586, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(588, 0);
    public static encodingDefaultXml = makeExpandedNodeId(587, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15205, 0);
    public elements: ContentFilterElement[] | null;

    constructor(options?: ContentFilterOptions | null) {

        super(options);

        if (options === null) {
         this.elements =  null; /* null array */
              return;
        }
        const schema = ContentFilter.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ContentFilterOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.elements = []; // should default
        if (options.elements) {
            assert(Array.isArray(options.elements));
            this.elements = options.elements.map((e: any) => new ContentFilterElement(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeArray(this.elements, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.elements = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new ContentFilterElement(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaContentFilter; }
}
ContentFilter.schema.dataTypeNodeId = ContentFilter.dataTypeNodeId;
ContentFilter.schema.encodingDefaultBinary = ContentFilter.encodingDefaultBinary;
ContentFilter.schema.encodingDefaultXml = ContentFilter.encodingDefaultXml;
ContentFilter.schema.encodingDefaultJson = ContentFilter.encodingDefaultJson;
registerClassDefinition( ContentFilter.dataTypeNodeId, "ContentFilter", ContentFilter);
// --------------------------------------------------------------------------------------------
const schemaContentFilterElementResult = buildStructuredType({
    name: "ContentFilterElementResult",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "StatusCode",

            fieldType: "StatusCode",
        },
        {
            name: "OperandStatusCodes",

            fieldType: "StatusCode",
            isArray: true
        },
        {
            name: "OperandDiagnosticInfos",

            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
export interface ContentFilterElementResultOptions {
    statusCode?: StatusCode ;
    operandStatusCodes?: StatusCode [] | null;
    operandDiagnosticInfos?: (DiagnosticInfo | null)[] | null;
}
export class ContentFilterElementResult extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaContentFilterElementResult; }
    public static possibleFields: string[] = [
          "statusCode",
           "operandStatusCodes",
           "operandDiagnosticInfos"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(604, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(606, 0);
    public static encodingDefaultXml = makeExpandedNodeId(605, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15211, 0);
    public statusCode: StatusCode;
    public operandStatusCodes: StatusCode[] | null;
    public operandDiagnosticInfos: (DiagnosticInfo | null)[] | null;

    constructor(options?: ContentFilterElementResultOptions | null) {

        super(options);

        if (options === null) {
            this.statusCode = StatusCodes.Good;
            this.operandStatusCodes = []
            this.operandDiagnosticInfos = []
              return;
        }
        const schema = ContentFilterElementResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ContentFilterElementResultOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.statusCode = initialize_field(schema.fields[0], options?.statusCode);
        this.operandStatusCodes = initialize_field_array(schema.fields[1], options?.operandStatusCodes);
        this.operandDiagnosticInfos = initialize_field_array(schema.fields[2], options?.operandDiagnosticInfos);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeStatusCode(this.statusCode, stream);
        encodeArray(this.operandStatusCodes, stream, encodeStatusCode);
        encodeArray(this.operandDiagnosticInfos, stream, encodeDiagnosticInfo);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.statusCode = decodeStatusCode(stream, this.statusCode);
        this.operandStatusCodes = decodeArray(stream, decodeStatusCode);
        this.operandDiagnosticInfos = decodeArray(stream, decodeDiagnosticInfo);
    }
    public get schema(): IStructuredTypeSchema { return schemaContentFilterElementResult; }
}
ContentFilterElementResult.schema.dataTypeNodeId = ContentFilterElementResult.dataTypeNodeId;
ContentFilterElementResult.schema.encodingDefaultBinary = ContentFilterElementResult.encodingDefaultBinary;
ContentFilterElementResult.schema.encodingDefaultXml = ContentFilterElementResult.encodingDefaultXml;
ContentFilterElementResult.schema.encodingDefaultJson = ContentFilterElementResult.encodingDefaultJson;
registerClassDefinition( ContentFilterElementResult.dataTypeNodeId, "ContentFilterElementResult", ContentFilterElementResult);
// --------------------------------------------------------------------------------------------
const schemaContentFilterResult = buildStructuredType({
    name: "ContentFilterResult",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ElementResults",

            fieldType: "ContentFilterElementResult",
            isArray: true
        },
        {
            name: "ElementDiagnosticInfos",

            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
export interface ContentFilterResultOptions {
    elementResults?: ContentFilterElementResultOptions [] | null;
    elementDiagnosticInfos?: (DiagnosticInfo | null)[] | null;
}
export class ContentFilterResult extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaContentFilterResult; }
    public static possibleFields: string[] = [
          "elementResults",
           "elementDiagnosticInfos"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(607, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(609, 0);
    public static encodingDefaultXml = makeExpandedNodeId(608, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15228, 0);
    public elementResults: ContentFilterElementResult[] | null;
    public elementDiagnosticInfos: (DiagnosticInfo | null)[] | null;

    constructor(options?: ContentFilterResultOptions | null) {

        super(options);

        if (options === null) {
         this.elementResults =  null; /* null array */
            this.elementDiagnosticInfos = []
              return;
        }
        const schema = ContentFilterResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ContentFilterResultOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.elementResults = []; // should default
        if (options.elementResults) {
            assert(Array.isArray(options.elementResults));
            this.elementResults = options.elementResults.map((e: any) => new ContentFilterElementResult(e));
        }
        this.elementDiagnosticInfos = initialize_field_array(schema.fields[1], options?.elementDiagnosticInfos);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeArray(this.elementResults, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.elementDiagnosticInfos, stream, encodeDiagnosticInfo);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.elementResults = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new ContentFilterElementResult(null);
            obj.decode(stream1);
            return obj;
        });
        this.elementDiagnosticInfos = decodeArray(stream, decodeDiagnosticInfo);
    }
    public get schema(): IStructuredTypeSchema { return schemaContentFilterResult; }
}
ContentFilterResult.schema.dataTypeNodeId = ContentFilterResult.dataTypeNodeId;
ContentFilterResult.schema.encodingDefaultBinary = ContentFilterResult.encodingDefaultBinary;
ContentFilterResult.schema.encodingDefaultXml = ContentFilterResult.encodingDefaultXml;
ContentFilterResult.schema.encodingDefaultJson = ContentFilterResult.encodingDefaultJson;
registerClassDefinition( ContentFilterResult.dataTypeNodeId, "ContentFilterResult", ContentFilterResult);
// --------------------------------------------------------------------------------------------
const schemaReadValueId = buildStructuredType({
    name: "ReadValueId",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "NodeId",

            fieldType: "NodeId",
        },
        {
            name: "AttributeId",

            fieldType: "UInt32",
        },
        {
            name: "IndexRange",

            fieldType: "NumericRange",
        },
        {
            name: "DataEncoding",

            fieldType: "QualifiedName",
        },
    ]
});
export interface ReadValueIdOptions {
    nodeId?: (NodeIdLike | null);
    attributeId?: UInt32 ;
    indexRange?: NumericRange ;
    dataEncoding?: (QualifiedNameLike | null);
}
export class ReadValueId extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaReadValueId; }
    public static possibleFields: string[] = [
          "nodeId",
           "attributeId",
           "indexRange",
           "dataEncoding"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(626, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(628, 0);
    public static encodingDefaultXml = makeExpandedNodeId(627, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15256, 0);
    public nodeId: NodeId;
    public attributeId: UInt32;
    public indexRange: NumericRange;
    public dataEncoding: QualifiedName;

    constructor(options?: ReadValueIdOptions | null) {

        super(options);

        if (options === null) {
            this.nodeId = new NodeId(null);
            this.attributeId = 0;
            this.indexRange = new NumericRange(null);
            this.dataEncoding = new QualifiedName(null);
              return;
        }
        const schema = ReadValueId.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ReadValueIdOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.nodeId = initialize_field(schema.fields[0], options?.nodeId);
        this.attributeId = initialize_field(schema.fields[1], options?.attributeId);
        this.indexRange = initialize_field(schema.fields[2], options?.indexRange);
        this.dataEncoding = initialize_field(schema.fields[3], options?.dataEncoding);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.nodeId, stream);
        encodeUInt32(this.attributeId, stream);
        encodeNumericRange(this.indexRange, stream);
        encodeQualifiedName(this.dataEncoding, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.nodeId = decodeNodeId(stream, this.nodeId);
        this.attributeId = decodeUInt32(stream, this.attributeId);
        this.indexRange = decodeNumericRange(stream, this.indexRange);
        this.dataEncoding = decodeQualifiedName(stream, this.dataEncoding);
    }
    public get schema(): IStructuredTypeSchema { return schemaReadValueId; }
}
ReadValueId.schema.dataTypeNodeId = ReadValueId.dataTypeNodeId;
ReadValueId.schema.encodingDefaultBinary = ReadValueId.encodingDefaultBinary;
ReadValueId.schema.encodingDefaultXml = ReadValueId.encodingDefaultXml;
ReadValueId.schema.encodingDefaultJson = ReadValueId.encodingDefaultJson;
registerClassDefinition( ReadValueId.dataTypeNodeId, "ReadValueId", ReadValueId);

// --------------------------------------------------------------------------------------------
export enum MonitoringMode {
    Disabled = 0,
    Sampling = 1,
    Reporting = 2,
    Invalid = 4294967295
}
const schemaMonitoringMode = {
    enumValues: MonitoringMode,
    flaggable: false,
    minValue: 0,
    maxValue: 2,
    name: "MonitoringMode"
};
function decodeMonitoringMode(stream: BinaryStream, _value?: MonitoringMode): MonitoringMode {
    let value =  stream.readUInt32() as MonitoringMode;
    value = (value < schemaMonitoringMode.minValue || value > schemaMonitoringMode.maxValue) ? MonitoringMode.Invalid : value; 
    return value;
}
function encodeMonitoringMode(value: MonitoringMode, stream: OutputBinaryStream): void {
    stream.writeUInt32(value);
}
export const _enumerationMonitoringMode = registerEnumeration(schemaMonitoringMode);
assert(_enumerationMonitoringMode.isFlaggable ===  false);
// --------------------------------------------------------------------------------------------
const schemaMonitoringParameters = buildStructuredType({
    name: "MonitoringParameters",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ClientHandle",

            fieldType: "UInt32",
        },
        {
            name: "SamplingInterval",

            fieldType: "Double",
        },
        {
            name: "Filter",

            fieldType: "ExtensionObject",
        },
        {
            name: "QueueSize",

            fieldType: "UInt32",
        },
        {
            name: "DiscardOldest",

            fieldType: "Boolean",
        },
    ]
});
export interface MonitoringParametersOptions {
    clientHandle?: UInt32 ;
    samplingInterval?: Double ;
    filter?: (ExtensionObject | null);
    queueSize?: UInt32 ;
    discardOldest?: UABoolean ;
}
export class MonitoringParameters extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaMonitoringParameters; }
    public static possibleFields: string[] = [
          "clientHandle",
           "samplingInterval",
           "filter",
           "queueSize",
           "discardOldest"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(740, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(742, 0);
    public static encodingDefaultXml = makeExpandedNodeId(741, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15320, 0);
    public clientHandle: UInt32;
    public samplingInterval: Double;
    public filter: (ExtensionObject | null);
    public queueSize: UInt32;
    public discardOldest: UABoolean;

    constructor(options?: MonitoringParametersOptions | null) {

        super(options);

        if (options === null) {
            this.clientHandle = 0;
            this.samplingInterval = 0;
            this.filter = null;
            this.queueSize = 0;
            this.discardOldest = false;
              return;
        }
        const schema = MonitoringParameters.schema;
        options = (schema.constructHook ? schema.constructHook(options) as MonitoringParametersOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.clientHandle = initialize_field(schema.fields[0], options?.clientHandle);
        this.samplingInterval = initialize_field(schema.fields[1], options?.samplingInterval);
        this.filter = initialize_field(schema.fields[2], options?.filter);
        this.queueSize = initialize_field(schema.fields[3], options?.queueSize);
        this.discardOldest = initialize_field(schema.fields[4], options?.discardOldest);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeUInt32(this.clientHandle, stream);
        encodeDouble(this.samplingInterval, stream);
        encodeExtensionObject(this.filter, stream);
        encodeUInt32(this.queueSize, stream);
        encodeBoolean(this.discardOldest, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.clientHandle = decodeUInt32(stream, this.clientHandle);
        this.samplingInterval = decodeDouble(stream, this.samplingInterval);
        this.filter = decodeExtensionObject(stream, this.filter);
        this.queueSize = decodeUInt32(stream, this.queueSize);
        this.discardOldest = decodeBoolean(stream, this.discardOldest);
    }
    public get schema(): IStructuredTypeSchema { return schemaMonitoringParameters; }
}
MonitoringParameters.schema.dataTypeNodeId = MonitoringParameters.dataTypeNodeId;
MonitoringParameters.schema.encodingDefaultBinary = MonitoringParameters.encodingDefaultBinary;
MonitoringParameters.schema.encodingDefaultXml = MonitoringParameters.encodingDefaultXml;
MonitoringParameters.schema.encodingDefaultJson = MonitoringParameters.encodingDefaultJson;
registerClassDefinition( MonitoringParameters.dataTypeNodeId, "MonitoringParameters", MonitoringParameters);
// --------------------------------------------------------------------------------------------
const schemaMonitoredItemCreateRequest = buildStructuredType({
    name: "MonitoredItemCreateRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ItemToMonitor",

            fieldType: "ReadValueId",
        },
        {
            name: "MonitoringMode",

            fieldType: "MonitoringMode",
        },
        {
            name: "RequestedParameters",

            fieldType: "MonitoringParameters",
        },
    ]
});
export interface MonitoredItemCreateRequestOptions {
    itemToMonitor?: ReadValueIdOptions ;
    monitoringMode?: MonitoringMode;
    requestedParameters?: MonitoringParametersOptions ;
}
export class MonitoredItemCreateRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaMonitoredItemCreateRequest; }
    public static possibleFields: string[] = [
          "itemToMonitor",
           "monitoringMode",
           "requestedParameters"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(743, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(745, 0);
    public static encodingDefaultXml = makeExpandedNodeId(744, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15321, 0);
    public itemToMonitor: ReadValueId;
    public monitoringMode: MonitoringMode;
    public requestedParameters: MonitoringParameters;

    constructor(options?: MonitoredItemCreateRequestOptions | null) {

        super(options);

        if (options === null) {
         this.itemToMonitor =  new ReadValueId(null);
             this.monitoringMode =  0 as  MonitoringMode;
         this.requestedParameters =  new MonitoringParameters(null);
              return;
        }
        const schema = MonitoredItemCreateRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as MonitoredItemCreateRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.itemToMonitor  =  new ReadValueId(options.itemToMonitor);
        this.monitoringMode = this.setMonitoringMode(initialize_field(schema.fields[1], options?.monitoringMode));
        this.requestedParameters  =  new MonitoringParameters(options.requestedParameters);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.itemToMonitor.encode(stream);
        encodeMonitoringMode(this.monitoringMode, stream);
        this.requestedParameters.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.itemToMonitor.decode(stream);
        this.monitoringMode = decodeMonitoringMode(stream, this.monitoringMode);
        this.requestedParameters.decode(stream);
    }

    // Define Enumeration setters
    public setMonitoringMode(value: any): MonitoringMode {
        const coercedValue = _enumerationMonitoringMode.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to MonitoringMode :" + value);
        }
        this.monitoringMode = coercedValue.value as MonitoringMode;
        return this.monitoringMode;
    }
    public get schema(): IStructuredTypeSchema { return schemaMonitoredItemCreateRequest; }
}
MonitoredItemCreateRequest.schema.dataTypeNodeId = MonitoredItemCreateRequest.dataTypeNodeId;
MonitoredItemCreateRequest.schema.encodingDefaultBinary = MonitoredItemCreateRequest.encodingDefaultBinary;
MonitoredItemCreateRequest.schema.encodingDefaultXml = MonitoredItemCreateRequest.encodingDefaultXml;
MonitoredItemCreateRequest.schema.encodingDefaultJson = MonitoredItemCreateRequest.encodingDefaultJson;
registerClassDefinition( MonitoredItemCreateRequest.dataTypeNodeId, "MonitoredItemCreateRequest", MonitoredItemCreateRequest);
// --------------------------------------------------------------------------------------------
const schemaCreateMonitoredItemsRequest = buildStructuredType({
    name: "CreateMonitoredItemsRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
        {
            name: "SubscriptionId",

            fieldType: "UInt32",
        },
        {
            name: "TimestampsToReturn",

            fieldType: "TimestampsToReturn",
        },
        {
            name: "ItemsToCreate",

            fieldType: "MonitoredItemCreateRequest",
            isArray: true
        },
    ]
});
export interface CreateMonitoredItemsRequestOptions {
    requestHeader?: RequestHeaderOptions ;
    subscriptionId?: UInt32 ;
    timestampsToReturn?: TimestampsToReturn;
    itemsToCreate?: MonitoredItemCreateRequestOptions [] | null;
}
export class CreateMonitoredItemsRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaCreateMonitoredItemsRequest; }
    public static possibleFields: string[] = [
          "requestHeader",
           "subscriptionId",
           "timestampsToReturn",
           "itemsToCreate"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(749, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(751, 0);
    public static encodingDefaultXml = makeExpandedNodeId(750, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15323, 0);
    public requestHeader: RequestHeader;
    public subscriptionId: UInt32;
    public timestampsToReturn: TimestampsToReturn;
    public itemsToCreate: MonitoredItemCreateRequest[] | null;

    constructor(options?: CreateMonitoredItemsRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
            this.subscriptionId = 0;
             this.timestampsToReturn =  0 as  TimestampsToReturn;
         this.itemsToCreate =  null; /* null array */
              return;
        }
        const schema = CreateMonitoredItemsRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as CreateMonitoredItemsRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
        this.subscriptionId = initialize_field(schema.fields[1], options?.subscriptionId);
        this.timestampsToReturn = this.setTimestampsToReturn(initialize_field(schema.fields[2], options?.timestampsToReturn));
        this.itemsToCreate = []; // should default
        if (options.itemsToCreate) {
            assert(Array.isArray(options.itemsToCreate));
            this.itemsToCreate = options.itemsToCreate.map((e: any) => new MonitoredItemCreateRequest(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        encodeUInt32(this.subscriptionId, stream);
        encodeTimestampsToReturn(this.timestampsToReturn, stream);
        encodeArray(this.itemsToCreate, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.subscriptionId = decodeUInt32(stream, this.subscriptionId);
        this.timestampsToReturn = decodeTimestampsToReturn(stream, this.timestampsToReturn);
        this.itemsToCreate = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new MonitoredItemCreateRequest(null);
            obj.decode(stream1);
            return obj;
        });
    }

    // Define Enumeration setters
    public setTimestampsToReturn(value: any): TimestampsToReturn {
        const coercedValue = _enumerationTimestampsToReturn.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to TimestampsToReturn :" + value);
        }
        this.timestampsToReturn = coercedValue.value as TimestampsToReturn;
        return this.timestampsToReturn;
    }
    public get schema(): IStructuredTypeSchema { return schemaCreateMonitoredItemsRequest; }
}
CreateMonitoredItemsRequest.schema.dataTypeNodeId = CreateMonitoredItemsRequest.dataTypeNodeId;
CreateMonitoredItemsRequest.schema.encodingDefaultBinary = CreateMonitoredItemsRequest.encodingDefaultBinary;
CreateMonitoredItemsRequest.schema.encodingDefaultXml = CreateMonitoredItemsRequest.encodingDefaultXml;
CreateMonitoredItemsRequest.schema.encodingDefaultJson = CreateMonitoredItemsRequest.encodingDefaultJson;
registerClassDefinition( CreateMonitoredItemsRequest.dataTypeNodeId, "CreateMonitoredItemsRequest", CreateMonitoredItemsRequest);
// --------------------------------------------------------------------------------------------
const schemaMonitoredItemCreateResult = buildStructuredType({
    name: "MonitoredItemCreateResult",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "StatusCode",

            fieldType: "StatusCode",
        },
        {
            name: "MonitoredItemId",

            fieldType: "UInt32",
        },
        {
            name: "RevisedSamplingInterval",

            fieldType: "Double",
        },
        {
            name: "RevisedQueueSize",

            fieldType: "UInt32",
        },
        {
            name: "FilterResult",

            fieldType: "ExtensionObject",
        },
    ]
});
export interface MonitoredItemCreateResultOptions {
    statusCode?: StatusCode ;
    monitoredItemId?: UInt32 ;
    revisedSamplingInterval?: Double ;
    revisedQueueSize?: UInt32 ;
    filterResult?: (ExtensionObject | null);
}
export class MonitoredItemCreateResult extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaMonitoredItemCreateResult; }
    public static possibleFields: string[] = [
          "statusCode",
           "monitoredItemId",
           "revisedSamplingInterval",
           "revisedQueueSize",
           "filterResult"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(746, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(748, 0);
    public static encodingDefaultXml = makeExpandedNodeId(747, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15322, 0);
    public statusCode: StatusCode;
    public monitoredItemId: UInt32;
    public revisedSamplingInterval: Double;
    public revisedQueueSize: UInt32;
    public filterResult: (ExtensionObject | null);

    constructor(options?: MonitoredItemCreateResultOptions | null) {

        super(options);

        if (options === null) {
            this.statusCode = StatusCodes.Good;
            this.monitoredItemId = 0;
            this.revisedSamplingInterval = 0;
            this.revisedQueueSize = 0;
            this.filterResult = null;
              return;
        }
        const schema = MonitoredItemCreateResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) as MonitoredItemCreateResultOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.statusCode = initialize_field(schema.fields[0], options?.statusCode);
        this.monitoredItemId = initialize_field(schema.fields[1], options?.monitoredItemId);
        this.revisedSamplingInterval = initialize_field(schema.fields[2], options?.revisedSamplingInterval);
        this.revisedQueueSize = initialize_field(schema.fields[3], options?.revisedQueueSize);
        this.filterResult = initialize_field(schema.fields[4], options?.filterResult);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeStatusCode(this.statusCode, stream);
        encodeUInt32(this.monitoredItemId, stream);
        encodeDouble(this.revisedSamplingInterval, stream);
        encodeUInt32(this.revisedQueueSize, stream);
        encodeExtensionObject(this.filterResult, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.statusCode = decodeStatusCode(stream, this.statusCode);
        this.monitoredItemId = decodeUInt32(stream, this.monitoredItemId);
        this.revisedSamplingInterval = decodeDouble(stream, this.revisedSamplingInterval);
        this.revisedQueueSize = decodeUInt32(stream, this.revisedQueueSize);
        this.filterResult = decodeExtensionObject(stream, this.filterResult);
    }
    public get schema(): IStructuredTypeSchema { return schemaMonitoredItemCreateResult; }
}
MonitoredItemCreateResult.schema.dataTypeNodeId = MonitoredItemCreateResult.dataTypeNodeId;
MonitoredItemCreateResult.schema.encodingDefaultBinary = MonitoredItemCreateResult.encodingDefaultBinary;
MonitoredItemCreateResult.schema.encodingDefaultXml = MonitoredItemCreateResult.encodingDefaultXml;
MonitoredItemCreateResult.schema.encodingDefaultJson = MonitoredItemCreateResult.encodingDefaultJson;
registerClassDefinition( MonitoredItemCreateResult.dataTypeNodeId, "MonitoredItemCreateResult", MonitoredItemCreateResult);
// --------------------------------------------------------------------------------------------
const schemaCreateMonitoredItemsResponse = buildStructuredType({
    name: "CreateMonitoredItemsResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
        {
            name: "Results",

            fieldType: "MonitoredItemCreateResult",
            isArray: true
        },
        {
            name: "DiagnosticInfos",

            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
export interface CreateMonitoredItemsResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
    results?: MonitoredItemCreateResultOptions [] | null;
    diagnosticInfos?: (DiagnosticInfo | null)[] | null;
}
export class CreateMonitoredItemsResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaCreateMonitoredItemsResponse; }
    public static possibleFields: string[] = [
          "responseHeader",
           "results",
           "diagnosticInfos"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(752, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(754, 0);
    public static encodingDefaultXml = makeExpandedNodeId(753, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15324, 0);
    public responseHeader: ResponseHeader;
    public results: MonitoredItemCreateResult[] | null;
    public diagnosticInfos: (DiagnosticInfo | null)[] | null;

    constructor(options?: CreateMonitoredItemsResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
         this.results =  null; /* null array */
            this.diagnosticInfos = []
              return;
        }
        const schema = CreateMonitoredItemsResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as CreateMonitoredItemsResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
        this.results = []; // should default
        if (options.results) {
            assert(Array.isArray(options.results));
            this.results = options.results.map((e: any) => new MonitoredItemCreateResult(e));
        }
        this.diagnosticInfos = initialize_field_array(schema.fields[2], options?.diagnosticInfos);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        encodeArray(this.results, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.diagnosticInfos, stream, encodeDiagnosticInfo);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new MonitoredItemCreateResult(null);
            obj.decode(stream1);
            return obj;
        });
        this.diagnosticInfos = decodeArray(stream, decodeDiagnosticInfo);
    }
    public get schema(): IStructuredTypeSchema { return schemaCreateMonitoredItemsResponse; }
}
CreateMonitoredItemsResponse.schema.dataTypeNodeId = CreateMonitoredItemsResponse.dataTypeNodeId;
CreateMonitoredItemsResponse.schema.encodingDefaultBinary = CreateMonitoredItemsResponse.encodingDefaultBinary;
CreateMonitoredItemsResponse.schema.encodingDefaultXml = CreateMonitoredItemsResponse.encodingDefaultXml;
CreateMonitoredItemsResponse.schema.encodingDefaultJson = CreateMonitoredItemsResponse.encodingDefaultJson;
registerClassDefinition( CreateMonitoredItemsResponse.dataTypeNodeId, "CreateMonitoredItemsResponse", CreateMonitoredItemsResponse);
// --------------------------------------------------------------------------------------------
const schemaCreateSessionRequest = buildStructuredType({
    name: "CreateSessionRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
        {
            name: "ClientDescription",

            fieldType: "ApplicationDescription",
        },
        {
            name: "ServerUri",

            fieldType: "String",
        },
        {
            name: "EndpointUrl",

            fieldType: "String",
        },
        {
            name: "SessionName",

            fieldType: "String",
        },
        {
            name: "ClientNonce",

            fieldType: "ByteString",
        },
        {
            name: "ClientCertificate",

            fieldType: "ByteString",
        },
        {
            name: "RequestedSessionTimeout",

            fieldType: "Double",
        },
        {
            name: "MaxResponseMessageSize",

            fieldType: "UInt32",
        },
    ]
});
export interface CreateSessionRequestOptions {
    requestHeader?: RequestHeaderOptions ;
    clientDescription?: ApplicationDescriptionOptions ;
    serverUri?: UAString ;
    endpointUrl?: UAString ;
    sessionName?: UAString ;
    clientNonce?: ByteString ;
    clientCertificate?: ByteString ;
    requestedSessionTimeout?: Double ;
    maxResponseMessageSize?: UInt32 ;
}
export class CreateSessionRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaCreateSessionRequest; }
    public static possibleFields: string[] = [
          "requestHeader",
           "clientDescription",
           "serverUri",
           "endpointUrl",
           "sessionName",
           "clientNonce",
           "clientCertificate",
           "requestedSessionTimeout",
           "maxResponseMessageSize"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(459, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(461, 0);
    public static encodingDefaultXml = makeExpandedNodeId(460, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15138, 0);
    public requestHeader: RequestHeader;
    public clientDescription: ApplicationDescription;
    public serverUri: UAString;
    public endpointUrl: UAString;
    public sessionName: UAString;
    public clientNonce: ByteString;
    public clientCertificate: ByteString;
    public requestedSessionTimeout: Double;
    public maxResponseMessageSize: UInt32;

    constructor(options?: CreateSessionRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
         this.clientDescription =  new ApplicationDescription(null);
            this.serverUri = null;
            this.endpointUrl = null;
            this.sessionName = null;
            this.clientNonce = Buffer.alloc(0);
            this.clientCertificate = Buffer.alloc(0);
            this.requestedSessionTimeout = 0;
            this.maxResponseMessageSize = 0;
              return;
        }
        const schema = CreateSessionRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as CreateSessionRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
        this.clientDescription  =  new ApplicationDescription(options.clientDescription);
        this.serverUri = initialize_field(schema.fields[2], options?.serverUri);
        this.endpointUrl = initialize_field(schema.fields[3], options?.endpointUrl);
        this.sessionName = initialize_field(schema.fields[4], options?.sessionName);
        this.clientNonce = initialize_field(schema.fields[5], options?.clientNonce);
        this.clientCertificate = initialize_field(schema.fields[6], options?.clientCertificate);
        this.requestedSessionTimeout = initialize_field(schema.fields[7], options?.requestedSessionTimeout);
        this.maxResponseMessageSize = initialize_field(schema.fields[8], options?.maxResponseMessageSize);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        this.clientDescription.encode(stream);
        encodeString(this.serverUri, stream);
        encodeString(this.endpointUrl, stream);
        encodeString(this.sessionName, stream);
        encodeByteString(this.clientNonce, stream);
        encodeByteString(this.clientCertificate, stream);
        encodeDouble(this.requestedSessionTimeout, stream);
        encodeUInt32(this.maxResponseMessageSize, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.clientDescription.decode(stream);
        this.serverUri = decodeString(stream, this.serverUri);
        this.endpointUrl = decodeString(stream, this.endpointUrl);
        this.sessionName = decodeString(stream, this.sessionName);
        this.clientNonce = decodeByteString(stream, this.clientNonce);
        this.clientCertificate = decodeByteString(stream, this.clientCertificate);
        this.requestedSessionTimeout = decodeDouble(stream, this.requestedSessionTimeout);
        this.maxResponseMessageSize = decodeUInt32(stream, this.maxResponseMessageSize);
    }
    public get schema(): IStructuredTypeSchema { return schemaCreateSessionRequest; }
}
CreateSessionRequest.schema.dataTypeNodeId = CreateSessionRequest.dataTypeNodeId;
CreateSessionRequest.schema.encodingDefaultBinary = CreateSessionRequest.encodingDefaultBinary;
CreateSessionRequest.schema.encodingDefaultXml = CreateSessionRequest.encodingDefaultXml;
CreateSessionRequest.schema.encodingDefaultJson = CreateSessionRequest.encodingDefaultJson;
registerClassDefinition( CreateSessionRequest.dataTypeNodeId, "CreateSessionRequest", CreateSessionRequest);

// --------------------------------------------------------------------------------------------
export enum MessageSecurityMode {
    Invalid = 0,
    None = 1,
    Sign = 2,
    SignAndEncrypt = 3
}
const schemaMessageSecurityMode = {
    enumValues: MessageSecurityMode,
    flaggable: false,
    minValue: 0,
    maxValue: 3,
    name: "MessageSecurityMode"
};
function decodeMessageSecurityMode(stream: BinaryStream, _value?: MessageSecurityMode): MessageSecurityMode {
    let value =  stream.readUInt32() as MessageSecurityMode;
    value = (value < schemaMessageSecurityMode.minValue || value > schemaMessageSecurityMode.maxValue) ? MessageSecurityMode.Invalid : value; 
    return value;
}
function encodeMessageSecurityMode(value: MessageSecurityMode, stream: OutputBinaryStream): void {
    stream.writeUInt32(value);
}
export const _enumerationMessageSecurityMode = registerEnumeration(schemaMessageSecurityMode);
assert(_enumerationMessageSecurityMode.isFlaggable ===  false);

// --------------------------------------------------------------------------------------------
export enum UserTokenType {
    Anonymous = 0,
    UserName = 1,
    Certificate = 2,
    IssuedToken = 3,
    Invalid = 4294967295
}
const schemaUserTokenType = {
    enumValues: UserTokenType,
    flaggable: false,
    minValue: 0,
    maxValue: 3,
    name: "UserTokenType"
};
function decodeUserTokenType(stream: BinaryStream, _value?: UserTokenType): UserTokenType {
    let value =  stream.readUInt32() as UserTokenType;
    value = (value < schemaUserTokenType.minValue || value > schemaUserTokenType.maxValue) ? UserTokenType.Invalid : value; 
    return value;
}
function encodeUserTokenType(value: UserTokenType, stream: OutputBinaryStream): void {
    stream.writeUInt32(value);
}
export const _enumerationUserTokenType = registerEnumeration(schemaUserTokenType);
assert(_enumerationUserTokenType.isFlaggable ===  false);
// --------------------------------------------------------------------------------------------
const schemaUserTokenPolicy = buildStructuredType({
    name: "UserTokenPolicy",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "PolicyId",

            fieldType: "String",
        },
        {
            name: "TokenType",

            fieldType: "UserTokenType",
        },
        {
            name: "IssuedTokenType",

            fieldType: "String",
        },
        {
            name: "IssuerEndpointUrl",

            fieldType: "String",
        },
        {
            name: "SecurityPolicyUri",

            fieldType: "String",
        },
    ]
});
export interface UserTokenPolicyOptions {
    policyId?: UAString ;
    tokenType?: UserTokenType;
    issuedTokenType?: UAString ;
    issuerEndpointUrl?: UAString ;
    securityPolicyUri?: UAString ;
}
export class UserTokenPolicy extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaUserTokenPolicy; }
    public static possibleFields: string[] = [
          "policyId",
           "tokenType",
           "issuedTokenType",
           "issuerEndpointUrl",
           "securityPolicyUri"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(304, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(306, 0);
    public static encodingDefaultXml = makeExpandedNodeId(305, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15098, 0);
    public policyId: UAString;
    public tokenType: UserTokenType;
    public issuedTokenType: UAString;
    public issuerEndpointUrl: UAString;
    public securityPolicyUri: UAString;

    constructor(options?: UserTokenPolicyOptions | null) {

        super(options);

        if (options === null) {
            this.policyId = null;
             this.tokenType =  0 as  UserTokenType;
            this.issuedTokenType = null;
            this.issuerEndpointUrl = null;
            this.securityPolicyUri = null;
              return;
        }
        const schema = UserTokenPolicy.schema;
        options = (schema.constructHook ? schema.constructHook(options) as UserTokenPolicyOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.policyId = initialize_field(schema.fields[0], options?.policyId);
        this.tokenType = this.setTokenType(initialize_field(schema.fields[1], options?.tokenType));
        this.issuedTokenType = initialize_field(schema.fields[2], options?.issuedTokenType);
        this.issuerEndpointUrl = initialize_field(schema.fields[3], options?.issuerEndpointUrl);
        this.securityPolicyUri = initialize_field(schema.fields[4], options?.securityPolicyUri);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.policyId, stream);
        encodeUserTokenType(this.tokenType, stream);
        encodeString(this.issuedTokenType, stream);
        encodeString(this.issuerEndpointUrl, stream);
        encodeString(this.securityPolicyUri, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.policyId = decodeString(stream, this.policyId);
        this.tokenType = decodeUserTokenType(stream, this.tokenType);
        this.issuedTokenType = decodeString(stream, this.issuedTokenType);
        this.issuerEndpointUrl = decodeString(stream, this.issuerEndpointUrl);
        this.securityPolicyUri = decodeString(stream, this.securityPolicyUri);
    }

    // Define Enumeration setters
    public setTokenType(value: any): UserTokenType {
        const coercedValue = _enumerationUserTokenType.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to UserTokenType :" + value);
        }
        this.tokenType = coercedValue.value as UserTokenType;
        return this.tokenType;
    }
    public get schema(): IStructuredTypeSchema { return schemaUserTokenPolicy; }
}
UserTokenPolicy.schema.dataTypeNodeId = UserTokenPolicy.dataTypeNodeId;
UserTokenPolicy.schema.encodingDefaultBinary = UserTokenPolicy.encodingDefaultBinary;
UserTokenPolicy.schema.encodingDefaultXml = UserTokenPolicy.encodingDefaultXml;
UserTokenPolicy.schema.encodingDefaultJson = UserTokenPolicy.encodingDefaultJson;
registerClassDefinition( UserTokenPolicy.dataTypeNodeId, "UserTokenPolicy", UserTokenPolicy);
// --------------------------------------------------------------------------------------------
const schemaEndpointDescription = buildStructuredType({
    name: "EndpointDescription",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "EndpointUrl",

            fieldType: "String",
        },
        {
            name: "Server",

            fieldType: "ApplicationDescription",
        },
        {
            name: "ServerCertificate",

            fieldType: "ByteString",
        },
        {
            name: "SecurityMode",

            fieldType: "MessageSecurityMode",
        },
        {
            name: "SecurityPolicyUri",

            fieldType: "String",
        },
        {
            name: "UserIdentityTokens",

            fieldType: "UserTokenPolicy",
            isArray: true
        },
        {
            name: "TransportProfileUri",

            fieldType: "String",
        },
        {
            name: "SecurityLevel",

            fieldType: "Byte",
        },
    ]
});
export interface EndpointDescriptionOptions {
    endpointUrl?: UAString ;
    server?: ApplicationDescriptionOptions ;
    serverCertificate?: ByteString ;
    securityMode?: MessageSecurityMode;
    securityPolicyUri?: UAString ;
    userIdentityTokens?: UserTokenPolicyOptions [] | null;
    transportProfileUri?: UAString ;
    securityLevel?: Byte ;
}
export class EndpointDescription extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaEndpointDescription; }
    public static possibleFields: string[] = [
          "endpointUrl",
           "server",
           "serverCertificate",
           "securityMode",
           "securityPolicyUri",
           "userIdentityTokens",
           "transportProfileUri",
           "securityLevel"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(312, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(314, 0);
    public static encodingDefaultXml = makeExpandedNodeId(313, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15099, 0);
    public endpointUrl: UAString;
    public server: ApplicationDescription;
    public serverCertificate: ByteString;
    public securityMode: MessageSecurityMode;
    public securityPolicyUri: UAString;
    public userIdentityTokens: UserTokenPolicy[] | null;
    public transportProfileUri: UAString;
    public securityLevel: Byte;

    constructor(options?: EndpointDescriptionOptions | null) {

        super(options);

        if (options === null) {
            this.endpointUrl = null;
         this.server =  new ApplicationDescription(null);
            this.serverCertificate = Buffer.alloc(0);
             this.securityMode =  0 as  MessageSecurityMode;
            this.securityPolicyUri = null;
         this.userIdentityTokens =  null; /* null array */
            this.transportProfileUri = null;
            this.securityLevel = 0;
              return;
        }
        const schema = EndpointDescription.schema;
        options = (schema.constructHook ? schema.constructHook(options) as EndpointDescriptionOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.endpointUrl = initialize_field(schema.fields[0], options?.endpointUrl);
        this.server  =  new ApplicationDescription(options.server);
        this.serverCertificate = initialize_field(schema.fields[2], options?.serverCertificate);
        this.securityMode = this.setSecurityMode(initialize_field(schema.fields[3], options?.securityMode));
        this.securityPolicyUri = initialize_field(schema.fields[4], options?.securityPolicyUri);
        this.userIdentityTokens = []; // should default
        if (options.userIdentityTokens) {
            assert(Array.isArray(options.userIdentityTokens));
            this.userIdentityTokens = options.userIdentityTokens.map((e: any) => new UserTokenPolicy(e));
        }
        this.transportProfileUri = initialize_field(schema.fields[6], options?.transportProfileUri);
        this.securityLevel = initialize_field(schema.fields[7], options?.securityLevel);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.endpointUrl, stream);
        this.server.encode(stream);
        encodeByteString(this.serverCertificate, stream);
        encodeMessageSecurityMode(this.securityMode, stream);
        encodeString(this.securityPolicyUri, stream);
        encodeArray(this.userIdentityTokens, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeString(this.transportProfileUri, stream);
        encodeByte(this.securityLevel, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.endpointUrl = decodeString(stream, this.endpointUrl);
        this.server.decode(stream);
        this.serverCertificate = decodeByteString(stream, this.serverCertificate);
        this.securityMode = decodeMessageSecurityMode(stream, this.securityMode);
        this.securityPolicyUri = decodeString(stream, this.securityPolicyUri);
        this.userIdentityTokens = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new UserTokenPolicy(null);
            obj.decode(stream1);
            return obj;
        });
        this.transportProfileUri = decodeString(stream, this.transportProfileUri);
        this.securityLevel = decodeByte(stream, this.securityLevel);
    }

    // Define Enumeration setters
    public setSecurityMode(value: any): MessageSecurityMode {
        const coercedValue = _enumerationMessageSecurityMode.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to MessageSecurityMode :" + value);
        }
        this.securityMode = coercedValue.value as MessageSecurityMode;
        return this.securityMode;
    }
    public get schema(): IStructuredTypeSchema { return schemaEndpointDescription; }
}
EndpointDescription.schema.dataTypeNodeId = EndpointDescription.dataTypeNodeId;
EndpointDescription.schema.encodingDefaultBinary = EndpointDescription.encodingDefaultBinary;
EndpointDescription.schema.encodingDefaultXml = EndpointDescription.encodingDefaultXml;
EndpointDescription.schema.encodingDefaultJson = EndpointDescription.encodingDefaultJson;
registerClassDefinition( EndpointDescription.dataTypeNodeId, "EndpointDescription", EndpointDescription);
// --------------------------------------------------------------------------------------------
const schemaCreateSessionResponse = buildStructuredType({
    name: "CreateSessionResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
        {
            name: "SessionId",

            fieldType: "NodeId",
        },
        {
            name: "AuthenticationToken",

            fieldType: "NodeId",
        },
        {
            name: "RevisedSessionTimeout",

            fieldType: "Double",
        },
        {
            name: "ServerNonce",

            fieldType: "ByteString",
        },
        {
            name: "ServerCertificate",

            fieldType: "ByteString",
        },
        {
            name: "ServerEndpoints",

            fieldType: "EndpointDescription",
            isArray: true
        },
        {
            name: "ServerSoftwareCertificates",

            fieldType: "SignedSoftwareCertificate",
            isArray: true
        },
        {
            name: "ServerSignature",

            fieldType: "SignatureData",
        },
        {
            name: "MaxRequestMessageSize",

            fieldType: "UInt32",
        },
    ]
});
export interface CreateSessionResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
    sessionId?: (NodeIdLike | null);
    authenticationToken?: (NodeIdLike | null);
    revisedSessionTimeout?: Double ;
    serverNonce?: ByteString ;
    serverCertificate?: ByteString ;
    serverEndpoints?: EndpointDescriptionOptions [] | null;
    serverSoftwareCertificates?: SignedSoftwareCertificateOptions [] | null;
    serverSignature?: SignatureDataOptions ;
    maxRequestMessageSize?: UInt32 ;
}
export class CreateSessionResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaCreateSessionResponse; }
    public static possibleFields: string[] = [
          "responseHeader",
           "sessionId",
           "authenticationToken",
           "revisedSessionTimeout",
           "serverNonce",
           "serverCertificate",
           "serverEndpoints",
           "serverSoftwareCertificates",
           "serverSignature",
           "maxRequestMessageSize"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(462, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(464, 0);
    public static encodingDefaultXml = makeExpandedNodeId(463, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15139, 0);
    public responseHeader: ResponseHeader;
    public sessionId: NodeId;
    public authenticationToken: NodeId;
    public revisedSessionTimeout: Double;
    public serverNonce: ByteString;
    public serverCertificate: ByteString;
    public serverEndpoints: EndpointDescription[] | null;
    public serverSoftwareCertificates: SignedSoftwareCertificate[] | null;
    public serverSignature: SignatureData;
    public maxRequestMessageSize: UInt32;

    constructor(options?: CreateSessionResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
            this.sessionId = new NodeId(null);
            this.authenticationToken = new NodeId(null);
            this.revisedSessionTimeout = 0;
            this.serverNonce = Buffer.alloc(0);
            this.serverCertificate = Buffer.alloc(0);
         this.serverEndpoints =  null; /* null array */
         this.serverSoftwareCertificates =  null; /* null array */
         this.serverSignature =  new SignatureData(null);
            this.maxRequestMessageSize = 0;
              return;
        }
        const schema = CreateSessionResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as CreateSessionResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
        this.sessionId = initialize_field(schema.fields[1], options?.sessionId);
        this.authenticationToken = initialize_field(schema.fields[2], options?.authenticationToken);
        this.revisedSessionTimeout = initialize_field(schema.fields[3], options?.revisedSessionTimeout);
        this.serverNonce = initialize_field(schema.fields[4], options?.serverNonce);
        this.serverCertificate = initialize_field(schema.fields[5], options?.serverCertificate);
        this.serverEndpoints = []; // should default
        if (options.serverEndpoints) {
            assert(Array.isArray(options.serverEndpoints));
            this.serverEndpoints = options.serverEndpoints.map((e: any) => new EndpointDescription(e));
        }
        this.serverSoftwareCertificates = []; // should default
        if (options.serverSoftwareCertificates) {
            assert(Array.isArray(options.serverSoftwareCertificates));
            this.serverSoftwareCertificates = options.serverSoftwareCertificates.map((e: any) => new SignedSoftwareCertificate(e));
        }
        this.serverSignature  =  new SignatureData(options.serverSignature);
        this.maxRequestMessageSize = initialize_field(schema.fields[9], options?.maxRequestMessageSize);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        encodeNodeId(this.sessionId, stream);
        encodeNodeId(this.authenticationToken, stream);
        encodeDouble(this.revisedSessionTimeout, stream);
        encodeByteString(this.serverNonce, stream);
        encodeByteString(this.serverCertificate, stream);
        encodeArray(this.serverEndpoints, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.serverSoftwareCertificates, stream, (obj, stream1) => { obj.encode(stream1); });
        this.serverSignature.encode(stream);
        encodeUInt32(this.maxRequestMessageSize, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.sessionId = decodeNodeId(stream, this.sessionId);
        this.authenticationToken = decodeNodeId(stream, this.authenticationToken);
        this.revisedSessionTimeout = decodeDouble(stream, this.revisedSessionTimeout);
        this.serverNonce = decodeByteString(stream, this.serverNonce);
        this.serverCertificate = decodeByteString(stream, this.serverCertificate);
        this.serverEndpoints = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new EndpointDescription(null);
            obj.decode(stream1);
            return obj;
        });
        this.serverSoftwareCertificates = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new SignedSoftwareCertificate(null);
            obj.decode(stream1);
            return obj;
        });
        this.serverSignature.decode(stream);
        this.maxRequestMessageSize = decodeUInt32(stream, this.maxRequestMessageSize);
    }
    public get schema(): IStructuredTypeSchema { return schemaCreateSessionResponse; }
}
CreateSessionResponse.schema.dataTypeNodeId = CreateSessionResponse.dataTypeNodeId;
CreateSessionResponse.schema.encodingDefaultBinary = CreateSessionResponse.encodingDefaultBinary;
CreateSessionResponse.schema.encodingDefaultXml = CreateSessionResponse.encodingDefaultXml;
CreateSessionResponse.schema.encodingDefaultJson = CreateSessionResponse.encodingDefaultJson;
registerClassDefinition( CreateSessionResponse.dataTypeNodeId, "CreateSessionResponse", CreateSessionResponse);
// --------------------------------------------------------------------------------------------
const schemaCreateSubscriptionRequest = buildStructuredType({
    name: "CreateSubscriptionRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
        {
            name: "RequestedPublishingInterval",

            fieldType: "Double",
        },
        {
            name: "RequestedLifetimeCount",

            fieldType: "UInt32",
        },
        {
            name: "RequestedMaxKeepAliveCount",

            fieldType: "UInt32",
        },
        {
            name: "MaxNotificationsPerPublish",

            fieldType: "UInt32",
        },
        {
            name: "PublishingEnabled",

            fieldType: "Boolean",
        },
        {
            name: "Priority",

            fieldType: "Byte",
        },
    ]
});
export interface CreateSubscriptionRequestOptions {
    requestHeader?: RequestHeaderOptions ;
    requestedPublishingInterval?: Double ;
    requestedLifetimeCount?: UInt32 ;
    requestedMaxKeepAliveCount?: UInt32 ;
    maxNotificationsPerPublish?: UInt32 ;
    publishingEnabled?: UABoolean ;
    priority?: Byte ;
}
export class CreateSubscriptionRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaCreateSubscriptionRequest; }
    public static possibleFields: string[] = [
          "requestHeader",
           "requestedPublishingInterval",
           "requestedLifetimeCount",
           "requestedMaxKeepAliveCount",
           "maxNotificationsPerPublish",
           "publishingEnabled",
           "priority"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(785, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(787, 0);
    public static encodingDefaultXml = makeExpandedNodeId(786, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15337, 0);
    public requestHeader: RequestHeader;
    public requestedPublishingInterval: Double;
    public requestedLifetimeCount: UInt32;
    public requestedMaxKeepAliveCount: UInt32;
    public maxNotificationsPerPublish: UInt32;
    public publishingEnabled: UABoolean;
    public priority: Byte;

    constructor(options?: CreateSubscriptionRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
            this.requestedPublishingInterval = 0;
            this.requestedLifetimeCount = 0;
            this.requestedMaxKeepAliveCount = 0;
            this.maxNotificationsPerPublish = 0;
            this.publishingEnabled = false;
            this.priority = 0;
              return;
        }
        const schema = CreateSubscriptionRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as CreateSubscriptionRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
        this.requestedPublishingInterval = initialize_field(schema.fields[1], options?.requestedPublishingInterval);
        this.requestedLifetimeCount = initialize_field(schema.fields[2], options?.requestedLifetimeCount);
        this.requestedMaxKeepAliveCount = initialize_field(schema.fields[3], options?.requestedMaxKeepAliveCount);
        this.maxNotificationsPerPublish = initialize_field(schema.fields[4], options?.maxNotificationsPerPublish);
        this.publishingEnabled = initialize_field(schema.fields[5], options?.publishingEnabled);
        this.priority = initialize_field(schema.fields[6], options?.priority);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        encodeDouble(this.requestedPublishingInterval, stream);
        encodeUInt32(this.requestedLifetimeCount, stream);
        encodeUInt32(this.requestedMaxKeepAliveCount, stream);
        encodeUInt32(this.maxNotificationsPerPublish, stream);
        encodeBoolean(this.publishingEnabled, stream);
        encodeByte(this.priority, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.requestedPublishingInterval = decodeDouble(stream, this.requestedPublishingInterval);
        this.requestedLifetimeCount = decodeUInt32(stream, this.requestedLifetimeCount);
        this.requestedMaxKeepAliveCount = decodeUInt32(stream, this.requestedMaxKeepAliveCount);
        this.maxNotificationsPerPublish = decodeUInt32(stream, this.maxNotificationsPerPublish);
        this.publishingEnabled = decodeBoolean(stream, this.publishingEnabled);
        this.priority = decodeByte(stream, this.priority);
    }
    public get schema(): IStructuredTypeSchema { return schemaCreateSubscriptionRequest; }
}
CreateSubscriptionRequest.schema.dataTypeNodeId = CreateSubscriptionRequest.dataTypeNodeId;
CreateSubscriptionRequest.schema.encodingDefaultBinary = CreateSubscriptionRequest.encodingDefaultBinary;
CreateSubscriptionRequest.schema.encodingDefaultXml = CreateSubscriptionRequest.encodingDefaultXml;
CreateSubscriptionRequest.schema.encodingDefaultJson = CreateSubscriptionRequest.encodingDefaultJson;
registerClassDefinition( CreateSubscriptionRequest.dataTypeNodeId, "CreateSubscriptionRequest", CreateSubscriptionRequest);
// --------------------------------------------------------------------------------------------
const schemaCreateSubscriptionResponse = buildStructuredType({
    name: "CreateSubscriptionResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
        {
            name: "SubscriptionId",

            fieldType: "UInt32",
        },
        {
            name: "RevisedPublishingInterval",

            fieldType: "Double",
        },
        {
            name: "RevisedLifetimeCount",

            fieldType: "UInt32",
        },
        {
            name: "RevisedMaxKeepAliveCount",

            fieldType: "UInt32",
        },
    ]
});
export interface CreateSubscriptionResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
    subscriptionId?: UInt32 ;
    revisedPublishingInterval?: Double ;
    revisedLifetimeCount?: UInt32 ;
    revisedMaxKeepAliveCount?: UInt32 ;
}
export class CreateSubscriptionResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaCreateSubscriptionResponse; }
    public static possibleFields: string[] = [
          "responseHeader",
           "subscriptionId",
           "revisedPublishingInterval",
           "revisedLifetimeCount",
           "revisedMaxKeepAliveCount"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(788, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(790, 0);
    public static encodingDefaultXml = makeExpandedNodeId(789, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15338, 0);
    public responseHeader: ResponseHeader;
    public subscriptionId: UInt32;
    public revisedPublishingInterval: Double;
    public revisedLifetimeCount: UInt32;
    public revisedMaxKeepAliveCount: UInt32;

    constructor(options?: CreateSubscriptionResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
            this.subscriptionId = 0;
            this.revisedPublishingInterval = 0;
            this.revisedLifetimeCount = 0;
            this.revisedMaxKeepAliveCount = 0;
              return;
        }
        const schema = CreateSubscriptionResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as CreateSubscriptionResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
        this.subscriptionId = initialize_field(schema.fields[1], options?.subscriptionId);
        this.revisedPublishingInterval = initialize_field(schema.fields[2], options?.revisedPublishingInterval);
        this.revisedLifetimeCount = initialize_field(schema.fields[3], options?.revisedLifetimeCount);
        this.revisedMaxKeepAliveCount = initialize_field(schema.fields[4], options?.revisedMaxKeepAliveCount);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        encodeUInt32(this.subscriptionId, stream);
        encodeDouble(this.revisedPublishingInterval, stream);
        encodeUInt32(this.revisedLifetimeCount, stream);
        encodeUInt32(this.revisedMaxKeepAliveCount, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.subscriptionId = decodeUInt32(stream, this.subscriptionId);
        this.revisedPublishingInterval = decodeDouble(stream, this.revisedPublishingInterval);
        this.revisedLifetimeCount = decodeUInt32(stream, this.revisedLifetimeCount);
        this.revisedMaxKeepAliveCount = decodeUInt32(stream, this.revisedMaxKeepAliveCount);
    }
    public get schema(): IStructuredTypeSchema { return schemaCreateSubscriptionResponse; }
}
CreateSubscriptionResponse.schema.dataTypeNodeId = CreateSubscriptionResponse.dataTypeNodeId;
CreateSubscriptionResponse.schema.encodingDefaultBinary = CreateSubscriptionResponse.encodingDefaultBinary;
CreateSubscriptionResponse.schema.encodingDefaultXml = CreateSubscriptionResponse.encodingDefaultXml;
CreateSubscriptionResponse.schema.encodingDefaultJson = CreateSubscriptionResponse.encodingDefaultJson;
registerClassDefinition( CreateSubscriptionResponse.dataTypeNodeId, "CreateSubscriptionResponse", CreateSubscriptionResponse);
// --------------------------------------------------------------------------------------------
const schemaCurrencyUnitType = buildStructuredType({
    name: "CurrencyUnitType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "NumericCode",

            fieldType: "Int16",
        },
        {
            name: "Exponent",

            fieldType: "SByte",
        },
        {
            name: "AlphabeticCode",

            fieldType: "String",
        },
        {
            name: "Currency",

            fieldType: "LocalizedText",
        },
    ]
});
export interface CurrencyUnitTypeOptions {
    numericCode?: Int16 ;
    exponent?: SByte ;
    alphabeticCode?: UAString ;
    currency?: (LocalizedTextLike | null);
}
export class CurrencyUnitType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaCurrencyUnitType; }
    public static possibleFields: string[] = [
          "numericCode",
           "exponent",
           "alphabeticCode",
           "currency"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(23498, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(23507, 0);
    public static encodingDefaultXml = makeExpandedNodeId(23520, 0);
    public static encodingDefaultJson = makeExpandedNodeId(23528, 0);
    public numericCode: Int16;
    public exponent: SByte;
    public alphabeticCode: UAString;
    public currency: LocalizedText;

    constructor(options?: CurrencyUnitTypeOptions | null) {

        super(options);

        if (options === null) {
            this.numericCode = 0;
            this.exponent = 0;
            this.alphabeticCode = null;
            this.currency = new LocalizedText(null);
              return;
        }
        const schema = CurrencyUnitType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as CurrencyUnitTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.numericCode = initialize_field(schema.fields[0], options?.numericCode);
        this.exponent = initialize_field(schema.fields[1], options?.exponent);
        this.alphabeticCode = initialize_field(schema.fields[2], options?.alphabeticCode);
        this.currency = initialize_field(schema.fields[3], options?.currency);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeInt16(this.numericCode, stream);
        encodeSByte(this.exponent, stream);
        encodeString(this.alphabeticCode, stream);
        encodeLocalizedText(this.currency, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.numericCode = decodeInt16(stream, this.numericCode);
        this.exponent = decodeSByte(stream, this.exponent);
        this.alphabeticCode = decodeString(stream, this.alphabeticCode);
        this.currency = decodeLocalizedText(stream, this.currency);
    }
    public get schema(): IStructuredTypeSchema { return schemaCurrencyUnitType; }
}
CurrencyUnitType.schema.dataTypeNodeId = CurrencyUnitType.dataTypeNodeId;
CurrencyUnitType.schema.encodingDefaultBinary = CurrencyUnitType.encodingDefaultBinary;
CurrencyUnitType.schema.encodingDefaultXml = CurrencyUnitType.encodingDefaultXml;
CurrencyUnitType.schema.encodingDefaultJson = CurrencyUnitType.encodingDefaultJson;
registerClassDefinition( CurrencyUnitType.dataTypeNodeId, "CurrencyUnitType", CurrencyUnitType);

// --------------------------------------------------------------------------------------------
export enum DataChangeTrigger {
    Status = 0,
    StatusValue = 1,
    StatusValueTimestamp = 2,
    Invalid = 4294967295
}
const schemaDataChangeTrigger = {
    enumValues: DataChangeTrigger,
    flaggable: false,
    minValue: 0,
    maxValue: 2,
    name: "DataChangeTrigger"
};
function decodeDataChangeTrigger(stream: BinaryStream, _value?: DataChangeTrigger): DataChangeTrigger {
    let value =  stream.readUInt32() as DataChangeTrigger;
    value = (value < schemaDataChangeTrigger.minValue || value > schemaDataChangeTrigger.maxValue) ? DataChangeTrigger.Invalid : value; 
    return value;
}
function encodeDataChangeTrigger(value: DataChangeTrigger, stream: OutputBinaryStream): void {
    stream.writeUInt32(value);
}
export const _enumerationDataChangeTrigger = registerEnumeration(schemaDataChangeTrigger);
assert(_enumerationDataChangeTrigger.isFlaggable ===  false);
// --------------------------------------------------------------------------------------------
const schemaDataChangeFilter = buildStructuredType({
    name: "DataChangeFilter",

    baseType: "MonitoringFilter",
    fields: [
        {
            name: "Trigger",

            fieldType: "DataChangeTrigger",
        },
        {
            name: "DeadbandType",

            fieldType: "UInt32",
        },
        {
            name: "DeadbandValue",

            fieldType: "Double",
        },
    ]
});
export interface DataChangeFilterOptions extends MonitoringFilterOptions {
    trigger?: DataChangeTrigger;
    deadbandType?: UInt32 ;
    deadbandValue?: Double ;
}
export class DataChangeFilter extends MonitoringFilter {
    public static get schema(): IStructuredTypeSchema { return schemaDataChangeFilter; }
    public static possibleFields: string[] = [
          "trigger",
           "deadbandType",
           "deadbandValue"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(722, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(724, 0);
    public static encodingDefaultXml = makeExpandedNodeId(723, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15294, 0);
    public trigger: DataChangeTrigger;
    public deadbandType: UInt32;
    public deadbandValue: Double;

    constructor(options?: DataChangeFilterOptions | null) {

        super(options);

        if (options === null) {
             this.trigger =  0 as  DataChangeTrigger;
            this.deadbandType = 0;
            this.deadbandValue = 0;
              return;
        }
        const schema = DataChangeFilter.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DataChangeFilterOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.trigger = this.setTrigger(initialize_field(schema.fields[0], options?.trigger));
        this.deadbandType = initialize_field(schema.fields[1], options?.deadbandType);
        this.deadbandValue = initialize_field(schema.fields[2], options?.deadbandValue);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeDataChangeTrigger(this.trigger, stream);
        encodeUInt32(this.deadbandType, stream);
        encodeDouble(this.deadbandValue, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.trigger = decodeDataChangeTrigger(stream, this.trigger);
        this.deadbandType = decodeUInt32(stream, this.deadbandType);
        this.deadbandValue = decodeDouble(stream, this.deadbandValue);
    }

    // Define Enumeration setters
    public setTrigger(value: any): DataChangeTrigger {
        const coercedValue = _enumerationDataChangeTrigger.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to DataChangeTrigger :" + value);
        }
        this.trigger = coercedValue.value as DataChangeTrigger;
        return this.trigger;
    }
    public get schema(): IStructuredTypeSchema { return schemaDataChangeFilter; }
}
DataChangeFilter.schema.dataTypeNodeId = DataChangeFilter.dataTypeNodeId;
DataChangeFilter.schema.encodingDefaultBinary = DataChangeFilter.encodingDefaultBinary;
DataChangeFilter.schema.encodingDefaultXml = DataChangeFilter.encodingDefaultXml;
DataChangeFilter.schema.encodingDefaultJson = DataChangeFilter.encodingDefaultJson;
registerClassDefinition( DataChangeFilter.dataTypeNodeId, "DataChangeFilter", DataChangeFilter);
// --------------------------------------------------------------------------------------------
const schemaNotificationData = buildStructuredType({
    name: "NotificationData",

    baseType: "ExtensionObject",
    fields: [
    ]
});
export interface NotificationDataOptions {
}
export class NotificationData extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaNotificationData; }
    public static possibleFields: string[] = [
          
    ];
    public static dataTypeNodeId = makeExpandedNodeId(945, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(947, 0);
    public static encodingDefaultXml = makeExpandedNodeId(946, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15344, 0);

    constructor(options?: NotificationDataOptions | null) {

        super(options);

        if (options === null) {
              return;
        }
        const schema = NotificationData.schema;
        options = (schema.constructHook ? schema.constructHook(options) as NotificationDataOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaNotificationData; }
}
NotificationData.schema.dataTypeNodeId = NotificationData.dataTypeNodeId;
NotificationData.schema.encodingDefaultBinary = NotificationData.encodingDefaultBinary;
NotificationData.schema.encodingDefaultXml = NotificationData.encodingDefaultXml;
NotificationData.schema.encodingDefaultJson = NotificationData.encodingDefaultJson;
registerClassDefinition( NotificationData.dataTypeNodeId, "NotificationData", NotificationData);
// --------------------------------------------------------------------------------------------
const schemaMonitoredItemNotification = buildStructuredType({
    name: "MonitoredItemNotification",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ClientHandle",

            fieldType: "UInt32",
        },
        {
            name: "Value",

            fieldType: "DataValue",
        },
    ]
});
export interface MonitoredItemNotificationOptions {
    clientHandle?: UInt32 ;
    value?: (DataValueLike | null);
}
export class MonitoredItemNotification extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaMonitoredItemNotification; }
    public static possibleFields: string[] = [
          "clientHandle",
           "value"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(806, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(808, 0);
    public static encodingDefaultXml = makeExpandedNodeId(807, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15346, 0);
    public clientHandle: UInt32;
    public value: DataValue;

    constructor(options?: MonitoredItemNotificationOptions | null) {

        super(options);

        if (options === null) {
            this.clientHandle = 0;
            this.value = new DataValue(null);
              return;
        }
        const schema = MonitoredItemNotification.schema;
        options = (schema.constructHook ? schema.constructHook(options) as MonitoredItemNotificationOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.clientHandle = initialize_field(schema.fields[0], options?.clientHandle);
        this.value = initialize_field(schema.fields[1], options?.value);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeUInt32(this.clientHandle, stream);
        encodeDataValue(this.value, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.clientHandle = decodeUInt32(stream, this.clientHandle);
        this.value = decodeDataValue(stream, this.value);
    }
    public get schema(): IStructuredTypeSchema { return schemaMonitoredItemNotification; }
}
MonitoredItemNotification.schema.dataTypeNodeId = MonitoredItemNotification.dataTypeNodeId;
MonitoredItemNotification.schema.encodingDefaultBinary = MonitoredItemNotification.encodingDefaultBinary;
MonitoredItemNotification.schema.encodingDefaultXml = MonitoredItemNotification.encodingDefaultXml;
MonitoredItemNotification.schema.encodingDefaultJson = MonitoredItemNotification.encodingDefaultJson;
registerClassDefinition( MonitoredItemNotification.dataTypeNodeId, "MonitoredItemNotification", MonitoredItemNotification);
// --------------------------------------------------------------------------------------------
const schemaDataChangeNotification = buildStructuredType({
    name: "DataChangeNotification",

    baseType: "NotificationData",
    fields: [
        {
            name: "MonitoredItems",

            fieldType: "MonitoredItemNotification",
            isArray: true
        },
        {
            name: "DiagnosticInfos",

            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
export interface DataChangeNotificationOptions extends NotificationDataOptions {
    monitoredItems?: MonitoredItemNotificationOptions [] | null;
    diagnosticInfos?: (DiagnosticInfo | null)[] | null;
}
export class DataChangeNotification extends NotificationData {
    public static get schema(): IStructuredTypeSchema { return schemaDataChangeNotification; }
    public static possibleFields: string[] = [
          "monitoredItems",
           "diagnosticInfos"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(809, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(811, 0);
    public static encodingDefaultXml = makeExpandedNodeId(810, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15345, 0);
    public monitoredItems: MonitoredItemNotification[] | null;
    public diagnosticInfos: (DiagnosticInfo | null)[] | null;

    constructor(options?: DataChangeNotificationOptions | null) {

        super(options);

        if (options === null) {
         this.monitoredItems =  null; /* null array */
            this.diagnosticInfos = []
              return;
        }
        const schema = DataChangeNotification.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DataChangeNotificationOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.monitoredItems = []; // should default
        if (options.monitoredItems) {
            assert(Array.isArray(options.monitoredItems));
            this.monitoredItems = options.monitoredItems.map((e: any) => new MonitoredItemNotification(e));
        }
        this.diagnosticInfos = initialize_field_array(schema.fields[1], options?.diagnosticInfos);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeArray(this.monitoredItems, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.diagnosticInfos, stream, encodeDiagnosticInfo);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.monitoredItems = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new MonitoredItemNotification(null);
            obj.decode(stream1);
            return obj;
        });
        this.diagnosticInfos = decodeArray(stream, decodeDiagnosticInfo);
    }
    public get schema(): IStructuredTypeSchema { return schemaDataChangeNotification; }
}
DataChangeNotification.schema.dataTypeNodeId = DataChangeNotification.dataTypeNodeId;
DataChangeNotification.schema.encodingDefaultBinary = DataChangeNotification.encodingDefaultBinary;
DataChangeNotification.schema.encodingDefaultXml = DataChangeNotification.encodingDefaultXml;
DataChangeNotification.schema.encodingDefaultJson = DataChangeNotification.encodingDefaultJson;
registerClassDefinition( DataChangeNotification.dataTypeNodeId, "DataChangeNotification", DataChangeNotification);
// --------------------------------------------------------------------------------------------
const schemaDataTypeDescription = buildStructuredType({
    name: "DataTypeDescription",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "DataTypeId",

            fieldType: "NodeId",
        },
        {
            name: "Name",

            fieldType: "QualifiedName",
        },
    ]
});
export interface DataTypeDescriptionOptions {
    dataTypeId?: (NodeIdLike | null);
    name?: (QualifiedNameLike | null);
}
export class DataTypeDescription extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaDataTypeDescription; }
    public static possibleFields: string[] = [
          "dataTypeId",
           "name"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(14525, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(125, 0);
    public static encodingDefaultXml = makeExpandedNodeId(14796, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15057, 0);
    public dataTypeId: NodeId;
    public name: QualifiedName;

    constructor(options?: DataTypeDescriptionOptions | null) {

        super(options);

        if (options === null) {
            this.dataTypeId = new NodeId(null);
            this.name = new QualifiedName(null);
              return;
        }
        const schema = DataTypeDescription.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DataTypeDescriptionOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.dataTypeId = initialize_field(schema.fields[0], options?.dataTypeId);
        this.name = initialize_field(schema.fields[1], options?.name);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.dataTypeId, stream);
        encodeQualifiedName(this.name, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.dataTypeId = decodeNodeId(stream, this.dataTypeId);
        this.name = decodeQualifiedName(stream, this.name);
    }
    public get schema(): IStructuredTypeSchema { return schemaDataTypeDescription; }
}
DataTypeDescription.schema.dataTypeNodeId = DataTypeDescription.dataTypeNodeId;
DataTypeDescription.schema.encodingDefaultBinary = DataTypeDescription.encodingDefaultBinary;
DataTypeDescription.schema.encodingDefaultXml = DataTypeDescription.encodingDefaultXml;
DataTypeDescription.schema.encodingDefaultJson = DataTypeDescription.encodingDefaultJson;
registerClassDefinition( DataTypeDescription.dataTypeNodeId, "DataTypeDescription", DataTypeDescription);
// --------------------------------------------------------------------------------------------
const schemaDataTypeDefinition = buildStructuredType({
    name: "DataTypeDefinition",

    baseType: "ExtensionObject",
    fields: [
    ]
});
export interface DataTypeDefinitionOptions {
}
export class DataTypeDefinition extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaDataTypeDefinition; }
    public static possibleFields: string[] = [
          
    ];
    public static dataTypeNodeId = makeExpandedNodeId(97, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(121, 0);
    public static encodingDefaultXml = makeExpandedNodeId(14797, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15063, 0);

    constructor(options?: DataTypeDefinitionOptions | null) {

        super(options);

        if (options === null) {
              return;
        }
        const schema = DataTypeDefinition.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DataTypeDefinitionOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaDataTypeDefinition; }
}
DataTypeDefinition.schema.dataTypeNodeId = DataTypeDefinition.dataTypeNodeId;
DataTypeDefinition.schema.encodingDefaultBinary = DataTypeDefinition.encodingDefaultBinary;
DataTypeDefinition.schema.encodingDefaultXml = DataTypeDefinition.encodingDefaultXml;
DataTypeDefinition.schema.encodingDefaultJson = DataTypeDefinition.encodingDefaultJson;
registerClassDefinition( DataTypeDefinition.dataTypeNodeId, "DataTypeDefinition", DataTypeDefinition);

// --------------------------------------------------------------------------------------------
export enum StructureType {
    Structure = 0,
    StructureWithOptionalFields = 1,
    Union = 2,
    StructureWithSubtypedValues = 3,
    UnionWithSubtypedValues = 4,
    Invalid = 4294967295
}
const schemaStructureType = {
    enumValues: StructureType,
    flaggable: false,
    minValue: 0,
    maxValue: 4,
    name: "StructureType"
};
function decodeStructureType(stream: BinaryStream, _value?: StructureType): StructureType {
    let value =  stream.readUInt32() as StructureType;
    value = (value < schemaStructureType.minValue || value > schemaStructureType.maxValue) ? StructureType.Invalid : value; 
    return value;
}
function encodeStructureType(value: StructureType, stream: OutputBinaryStream): void {
    stream.writeUInt32(value);
}
export const _enumerationStructureType = registerEnumeration(schemaStructureType);
assert(_enumerationStructureType.isFlaggable ===  false);
// --------------------------------------------------------------------------------------------
const schemaStructureField = buildStructuredType({
    name: "StructureField",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Name",

            fieldType: "String",
        },
        {
            name: "Description",

            fieldType: "LocalizedText",
        },
        {
            name: "DataType",

            fieldType: "NodeId",
        },
        {
            name: "ValueRank",

            fieldType: "Int32",
        },
        {
            name: "ArrayDimensions",

            fieldType: "UInt32",
            isArray: true
        },
        {
            name: "MaxStringLength",

            fieldType: "UInt32",
        },
        {
            name: "IsOptional",

            fieldType: "Boolean",
        },
    ]
});
export interface StructureFieldOptions {
    name?: UAString ;
    description?: (LocalizedTextLike | null);
    dataType?: (NodeIdLike | null);
    valueRank?: Int32 ;
    arrayDimensions?: UInt32 [] | null;
    maxStringLength?: UInt32 ;
    isOptional?: UABoolean ;
}
export class StructureField extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaStructureField; }
    public static possibleFields: string[] = [
          "name",
           "description",
           "dataType",
           "valueRank",
           "arrayDimensions",
           "maxStringLength",
           "isOptional"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(101, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(14844, 0);
    public static encodingDefaultXml = makeExpandedNodeId(14800, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15065, 0);
    public name: UAString;
    public description: LocalizedText;
    public dataType: NodeId;
    public valueRank: Int32;
    public arrayDimensions: UInt32[] | null;
    public maxStringLength: UInt32;
    public isOptional: UABoolean;

    constructor(options?: StructureFieldOptions | null) {

        super(options);

        if (options === null) {
            this.name = null;
            this.description = new LocalizedText(null);
            this.dataType = new NodeId(null);
            this.valueRank = 0;
            this.arrayDimensions = []
            this.maxStringLength = 0;
            this.isOptional = false;
              return;
        }
        const schema = StructureField.schema;
        options = (schema.constructHook ? schema.constructHook(options) as StructureFieldOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.name = initialize_field(schema.fields[0], options?.name);
        this.description = initialize_field(schema.fields[1], options?.description);
        this.dataType = initialize_field(schema.fields[2], options?.dataType);
        this.valueRank = initialize_field(schema.fields[3], options?.valueRank);
        this.arrayDimensions = initialize_field_array(schema.fields[4], options?.arrayDimensions);
        this.maxStringLength = initialize_field(schema.fields[5], options?.maxStringLength);
        this.isOptional = initialize_field(schema.fields[6], options?.isOptional);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.name, stream);
        encodeLocalizedText(this.description, stream);
        encodeNodeId(this.dataType, stream);
        encodeInt32(this.valueRank, stream);
        encodeArray(this.arrayDimensions, stream, encodeUInt32);
        encodeUInt32(this.maxStringLength, stream);
        encodeBoolean(this.isOptional, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = decodeString(stream, this.name);
        this.description = decodeLocalizedText(stream, this.description);
        this.dataType = decodeNodeId(stream, this.dataType);
        this.valueRank = decodeInt32(stream, this.valueRank);
        this.arrayDimensions = decodeArray(stream, decodeUInt32);
        this.maxStringLength = decodeUInt32(stream, this.maxStringLength);
        this.isOptional = decodeBoolean(stream, this.isOptional);
    }
    public get schema(): IStructuredTypeSchema { return schemaStructureField; }
}
StructureField.schema.dataTypeNodeId = StructureField.dataTypeNodeId;
StructureField.schema.encodingDefaultBinary = StructureField.encodingDefaultBinary;
StructureField.schema.encodingDefaultXml = StructureField.encodingDefaultXml;
StructureField.schema.encodingDefaultJson = StructureField.encodingDefaultJson;
registerClassDefinition( StructureField.dataTypeNodeId, "StructureField", StructureField);
// --------------------------------------------------------------------------------------------
const schemaStructureDefinition = buildStructuredType({
    name: "StructureDefinition",

    baseType: "DataTypeDefinition",
    fields: [
        {
            name: "DefaultEncodingId",

            fieldType: "NodeId",
        },
        {
            name: "BaseDataType",

            fieldType: "NodeId",
        },
        {
            name: "StructureType",

            fieldType: "StructureType",
        },
        {
            name: "Fields",

            fieldType: "StructureField",
            isArray: true
        },
    ]
});
export interface StructureDefinitionOptions {
    defaultEncodingId?: (NodeIdLike | null);
    baseDataType?: (NodeIdLike | null);
    structureType?: StructureType;
    fields?: StructureFieldOptions [] | null;
}
export class StructureDefinition extends DataTypeDefinition {
    public static get schema(): IStructuredTypeSchema { return schemaStructureDefinition; }
    public static possibleFields: string[] = [
          "defaultEncodingId",
           "baseDataType",
           "structureType",
           "fields"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(99, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(122, 0);
    public static encodingDefaultXml = makeExpandedNodeId(14798, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15066, 0);
    public defaultEncodingId: NodeId;
    public baseDataType: NodeId;
    public structureType: StructureType;
    public fields: StructureField[] | null;

    constructor(options?: StructureDefinitionOptions | null) {

        super(options);

        if (options === null) {
            this.defaultEncodingId = new NodeId(null);
            this.baseDataType = new NodeId(null);
             this.structureType =  0 as  StructureType;
         this.fields =  null; /* null array */
              return;
        }
        const schema = StructureDefinition.schema;
        options = (schema.constructHook ? schema.constructHook(options) as StructureDefinitionOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.defaultEncodingId = initialize_field(schema.fields[0], options?.defaultEncodingId);
        this.baseDataType = initialize_field(schema.fields[1], options?.baseDataType);
        this.structureType = this.setStructureType(initialize_field(schema.fields[2], options?.structureType));
        this.fields = []; // should default
        if (options.fields) {
            assert(Array.isArray(options.fields));
            this.fields = options.fields.map((e: any) => new StructureField(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.defaultEncodingId, stream);
        encodeNodeId(this.baseDataType, stream);
        encodeStructureType(this.structureType, stream);
        encodeArray(this.fields, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.defaultEncodingId = decodeNodeId(stream, this.defaultEncodingId);
        this.baseDataType = decodeNodeId(stream, this.baseDataType);
        this.structureType = decodeStructureType(stream, this.structureType);
        this.fields = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new StructureField(null);
            obj.decode(stream1);
            return obj;
        });
    }

    // Define Enumeration setters
    public setStructureType(value: any): StructureType {
        const coercedValue = _enumerationStructureType.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to StructureType :" + value);
        }
        this.structureType = coercedValue.value as StructureType;
        return this.structureType;
    }
    public get schema(): IStructuredTypeSchema { return schemaStructureDefinition; }
}
StructureDefinition.schema.dataTypeNodeId = StructureDefinition.dataTypeNodeId;
StructureDefinition.schema.encodingDefaultBinary = StructureDefinition.encodingDefaultBinary;
StructureDefinition.schema.encodingDefaultXml = StructureDefinition.encodingDefaultXml;
StructureDefinition.schema.encodingDefaultJson = StructureDefinition.encodingDefaultJson;
registerClassDefinition( StructureDefinition.dataTypeNodeId, "StructureDefinition", StructureDefinition);
// --------------------------------------------------------------------------------------------
const schemaStructureDescription = buildStructuredType({
    name: "StructureDescription",

    baseType: "DataTypeDescription",
    fields: [
        {
            name: "StructureDefinition",

            fieldType: "StructureDefinition",
        },
    ]
});
export interface StructureDescriptionOptions extends DataTypeDescriptionOptions {
    structureDefinition?: StructureDefinitionOptions ;
}
export class StructureDescription extends DataTypeDescription {
    public static get schema(): IStructuredTypeSchema { return schemaStructureDescription; }
    public static possibleFields: string[] = [
          "dataTypeId",
           "name",
           "structureDefinition"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15487, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(126, 0);
    public static encodingDefaultXml = makeExpandedNodeId(15589, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15058, 0);
    public structureDefinition: StructureDefinition;

    constructor(options?: StructureDescriptionOptions | null) {

        super(options);

        if (options === null) {
         this.structureDefinition =  new StructureDefinition(null);
              return;
        }
        const schema = StructureDescription.schema;
        options = (schema.constructHook ? schema.constructHook(options) as StructureDescriptionOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.structureDefinition  =  new StructureDefinition(options.structureDefinition);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.structureDefinition.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.structureDefinition.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaStructureDescription; }
}
StructureDescription.schema.dataTypeNodeId = StructureDescription.dataTypeNodeId;
StructureDescription.schema.encodingDefaultBinary = StructureDescription.encodingDefaultBinary;
StructureDescription.schema.encodingDefaultXml = StructureDescription.encodingDefaultXml;
StructureDescription.schema.encodingDefaultJson = StructureDescription.encodingDefaultJson;
registerClassDefinition( StructureDescription.dataTypeNodeId, "StructureDescription", StructureDescription);
// --------------------------------------------------------------------------------------------
const schemaEnumValueType = buildStructuredType({
    name: "EnumValueType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Value",

            fieldType: "Int64",
        },
        {
            name: "DisplayName",

            fieldType: "LocalizedText",
        },
        {
            name: "Description",

            fieldType: "LocalizedText",
        },
    ]
});
export interface EnumValueTypeOptions {
    value?: Int64 ;
    displayName?: (LocalizedTextLike | null);
    description?: (LocalizedTextLike | null);
}
export class EnumValueType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaEnumValueType; }
    public static possibleFields: string[] = [
          "value",
           "displayName",
           "description"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(7594, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(8251, 0);
    public static encodingDefaultXml = makeExpandedNodeId(7616, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15082, 0);
    public value: Int64;
    public displayName: LocalizedText;
    public description: LocalizedText;

    constructor(options?: EnumValueTypeOptions | null) {

        super(options);

        if (options === null) {
            this.value = [];
            this.displayName = new LocalizedText(null);
            this.description = new LocalizedText(null);
              return;
        }
        const schema = EnumValueType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as EnumValueTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.value = initialize_field(schema.fields[0], options?.value);
        this.displayName = initialize_field(schema.fields[1], options?.displayName);
        this.description = initialize_field(schema.fields[2], options?.description);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeInt64(this.value, stream);
        encodeLocalizedText(this.displayName, stream);
        encodeLocalizedText(this.description, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.value = decodeInt64(stream, this.value);
        this.displayName = decodeLocalizedText(stream, this.displayName);
        this.description = decodeLocalizedText(stream, this.description);
    }
    public get schema(): IStructuredTypeSchema { return schemaEnumValueType; }
}
EnumValueType.schema.dataTypeNodeId = EnumValueType.dataTypeNodeId;
EnumValueType.schema.encodingDefaultBinary = EnumValueType.encodingDefaultBinary;
EnumValueType.schema.encodingDefaultXml = EnumValueType.encodingDefaultXml;
EnumValueType.schema.encodingDefaultJson = EnumValueType.encodingDefaultJson;
registerClassDefinition( EnumValueType.dataTypeNodeId, "EnumValueType", EnumValueType);
// --------------------------------------------------------------------------------------------
const schemaEnumField = buildStructuredType({
    name: "EnumField",

    baseType: "EnumValueType",
    fields: [
        {
            name: "Name",

            fieldType: "String",
        },
    ]
});
export interface EnumFieldOptions extends EnumValueTypeOptions {
    name?: UAString ;
}
export class EnumField extends EnumValueType {
    public static get schema(): IStructuredTypeSchema { return schemaEnumField; }
    public static possibleFields: string[] = [
          "value",
           "displayName",
           "description",
           "name"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(102, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(14845, 0);
    public static encodingDefaultXml = makeExpandedNodeId(14801, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15083, 0);
    public name: UAString;

    constructor(options?: EnumFieldOptions | null) {

        super(options);

        if (options === null) {
            this.name = null;
              return;
        }
        const schema = EnumField.schema;
        options = (schema.constructHook ? schema.constructHook(options) as EnumFieldOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.name = initialize_field(schema.fields[0], options?.name);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.name, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = decodeString(stream, this.name);
    }
    public get schema(): IStructuredTypeSchema { return schemaEnumField; }
}
EnumField.schema.dataTypeNodeId = EnumField.dataTypeNodeId;
EnumField.schema.encodingDefaultBinary = EnumField.encodingDefaultBinary;
EnumField.schema.encodingDefaultXml = EnumField.encodingDefaultXml;
EnumField.schema.encodingDefaultJson = EnumField.encodingDefaultJson;
registerClassDefinition( EnumField.dataTypeNodeId, "EnumField", EnumField);
// --------------------------------------------------------------------------------------------
const schemaEnumDefinition = buildStructuredType({
    name: "EnumDefinition",

    baseType: "DataTypeDefinition",
    fields: [
        {
            name: "Fields",

            fieldType: "EnumField",
            isArray: true
        },
    ]
});
export interface EnumDefinitionOptions {
    fields?: EnumFieldOptions [] | null;
}
export class EnumDefinition extends DataTypeDefinition {
    public static get schema(): IStructuredTypeSchema { return schemaEnumDefinition; }
    public static possibleFields: string[] = [
          "fields"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(100, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(123, 0);
    public static encodingDefaultXml = makeExpandedNodeId(14799, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15067, 0);
    public fields: EnumField[] | null;

    constructor(options?: EnumDefinitionOptions | null) {

        super(options);

        if (options === null) {
         this.fields =  null; /* null array */
              return;
        }
        const schema = EnumDefinition.schema;
        options = (schema.constructHook ? schema.constructHook(options) as EnumDefinitionOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.fields = []; // should default
        if (options.fields) {
            assert(Array.isArray(options.fields));
            this.fields = options.fields.map((e: any) => new EnumField(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeArray(this.fields, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.fields = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new EnumField(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaEnumDefinition; }
}
EnumDefinition.schema.dataTypeNodeId = EnumDefinition.dataTypeNodeId;
EnumDefinition.schema.encodingDefaultBinary = EnumDefinition.encodingDefaultBinary;
EnumDefinition.schema.encodingDefaultXml = EnumDefinition.encodingDefaultXml;
EnumDefinition.schema.encodingDefaultJson = EnumDefinition.encodingDefaultJson;
registerClassDefinition( EnumDefinition.dataTypeNodeId, "EnumDefinition", EnumDefinition);
// --------------------------------------------------------------------------------------------
const schemaEnumDescription = buildStructuredType({
    name: "EnumDescription",

    baseType: "DataTypeDescription",
    fields: [
        {
            name: "EnumDefinition",

            fieldType: "EnumDefinition",
        },
        {
            name: "BuiltInType",

            fieldType: "Byte",
        },
    ]
});
export interface EnumDescriptionOptions extends DataTypeDescriptionOptions {
    enumDefinition?: EnumDefinitionOptions ;
    builtInType?: Byte ;
}
export class EnumDescription extends DataTypeDescription {
    public static get schema(): IStructuredTypeSchema { return schemaEnumDescription; }
    public static possibleFields: string[] = [
          "dataTypeId",
           "name",
           "enumDefinition",
           "builtInType"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15488, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(127, 0);
    public static encodingDefaultXml = makeExpandedNodeId(15590, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15059, 0);
    public enumDefinition: EnumDefinition;
    public builtInType: Byte;

    constructor(options?: EnumDescriptionOptions | null) {

        super(options);

        if (options === null) {
         this.enumDefinition =  new EnumDefinition(null);
            this.builtInType = 0;
              return;
        }
        const schema = EnumDescription.schema;
        options = (schema.constructHook ? schema.constructHook(options) as EnumDescriptionOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.enumDefinition  =  new EnumDefinition(options.enumDefinition);
        this.builtInType = initialize_field(schema.fields[1], options?.builtInType);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.enumDefinition.encode(stream);
        encodeByte(this.builtInType, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.enumDefinition.decode(stream);
        this.builtInType = decodeByte(stream, this.builtInType);
    }
    public get schema(): IStructuredTypeSchema { return schemaEnumDescription; }
}
EnumDescription.schema.dataTypeNodeId = EnumDescription.dataTypeNodeId;
EnumDescription.schema.encodingDefaultBinary = EnumDescription.encodingDefaultBinary;
EnumDescription.schema.encodingDefaultXml = EnumDescription.encodingDefaultXml;
EnumDescription.schema.encodingDefaultJson = EnumDescription.encodingDefaultJson;
registerClassDefinition( EnumDescription.dataTypeNodeId, "EnumDescription", EnumDescription);
// --------------------------------------------------------------------------------------------
const schemaSimpleTypeDescription = buildStructuredType({
    name: "SimpleTypeDescription",

    baseType: "DataTypeDescription",
    fields: [
        {
            name: "BaseDataType",

            fieldType: "NodeId",
        },
        {
            name: "BuiltInType",

            fieldType: "Byte",
        },
    ]
});
export interface SimpleTypeDescriptionOptions extends DataTypeDescriptionOptions {
    baseDataType?: (NodeIdLike | null);
    builtInType?: Byte ;
}
export class SimpleTypeDescription extends DataTypeDescription {
    public static get schema(): IStructuredTypeSchema { return schemaSimpleTypeDescription; }
    public static possibleFields: string[] = [
          "dataTypeId",
           "name",
           "baseDataType",
           "builtInType"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15005, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15421, 0);
    public static encodingDefaultXml = makeExpandedNodeId(15529, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15700, 0);
    public baseDataType: NodeId;
    public builtInType: Byte;

    constructor(options?: SimpleTypeDescriptionOptions | null) {

        super(options);

        if (options === null) {
            this.baseDataType = new NodeId(null);
            this.builtInType = 0;
              return;
        }
        const schema = SimpleTypeDescription.schema;
        options = (schema.constructHook ? schema.constructHook(options) as SimpleTypeDescriptionOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.baseDataType = initialize_field(schema.fields[0], options?.baseDataType);
        this.builtInType = initialize_field(schema.fields[1], options?.builtInType);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.baseDataType, stream);
        encodeByte(this.builtInType, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.baseDataType = decodeNodeId(stream, this.baseDataType);
        this.builtInType = decodeByte(stream, this.builtInType);
    }
    public get schema(): IStructuredTypeSchema { return schemaSimpleTypeDescription; }
}
SimpleTypeDescription.schema.dataTypeNodeId = SimpleTypeDescription.dataTypeNodeId;
SimpleTypeDescription.schema.encodingDefaultBinary = SimpleTypeDescription.encodingDefaultBinary;
SimpleTypeDescription.schema.encodingDefaultXml = SimpleTypeDescription.encodingDefaultXml;
SimpleTypeDescription.schema.encodingDefaultJson = SimpleTypeDescription.encodingDefaultJson;
registerClassDefinition( SimpleTypeDescription.dataTypeNodeId, "SimpleTypeDescription", SimpleTypeDescription);
// --------------------------------------------------------------------------------------------
const schemaDataTypeSchemaHeader = buildStructuredType({
    name: "DataTypeSchemaHeader",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Namespaces",

            fieldType: "String",
            isArray: true
        },
        {
            name: "StructureDataTypes",

            fieldType: "StructureDescription",
            isArray: true
        },
        {
            name: "EnumDataTypes",

            fieldType: "EnumDescription",
            isArray: true
        },
        {
            name: "SimpleDataTypes",

            fieldType: "SimpleTypeDescription",
            isArray: true
        },
    ]
});
export interface DataTypeSchemaHeaderOptions {
    namespaces?: UAString [] | null;
    structureDataTypes?: StructureDescriptionOptions [] | null;
    enumDataTypes?: EnumDescriptionOptions [] | null;
    simpleDataTypes?: SimpleTypeDescriptionOptions [] | null;
}
export class DataTypeSchemaHeader extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaDataTypeSchemaHeader; }
    public static possibleFields: string[] = [
          "namespaces",
           "structureDataTypes",
           "enumDataTypes",
           "simpleDataTypes"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15534, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15676, 0);
    public static encodingDefaultXml = makeExpandedNodeId(15950, 0);
    public static encodingDefaultJson = makeExpandedNodeId(16151, 0);
    public namespaces: UAString[] | null;
    public structureDataTypes: StructureDescription[] | null;
    public enumDataTypes: EnumDescription[] | null;
    public simpleDataTypes: SimpleTypeDescription[] | null;

    constructor(options?: DataTypeSchemaHeaderOptions | null) {

        super(options);

        if (options === null) {
            this.namespaces = []
         this.structureDataTypes =  null; /* null array */
         this.enumDataTypes =  null; /* null array */
         this.simpleDataTypes =  null; /* null array */
              return;
        }
        const schema = DataTypeSchemaHeader.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DataTypeSchemaHeaderOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.namespaces = initialize_field_array(schema.fields[0], options?.namespaces);
        this.structureDataTypes = []; // should default
        if (options.structureDataTypes) {
            assert(Array.isArray(options.structureDataTypes));
            this.structureDataTypes = options.structureDataTypes.map((e: any) => new StructureDescription(e));
        }
        this.enumDataTypes = []; // should default
        if (options.enumDataTypes) {
            assert(Array.isArray(options.enumDataTypes));
            this.enumDataTypes = options.enumDataTypes.map((e: any) => new EnumDescription(e));
        }
        this.simpleDataTypes = []; // should default
        if (options.simpleDataTypes) {
            assert(Array.isArray(options.simpleDataTypes));
            this.simpleDataTypes = options.simpleDataTypes.map((e: any) => new SimpleTypeDescription(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeArray(this.namespaces, stream, encodeString);
        encodeArray(this.structureDataTypes, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.enumDataTypes, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.simpleDataTypes, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.namespaces = decodeArray(stream, decodeString);
        this.structureDataTypes = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new StructureDescription(null);
            obj.decode(stream1);
            return obj;
        });
        this.enumDataTypes = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new EnumDescription(null);
            obj.decode(stream1);
            return obj;
        });
        this.simpleDataTypes = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new SimpleTypeDescription(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaDataTypeSchemaHeader; }
}
DataTypeSchemaHeader.schema.dataTypeNodeId = DataTypeSchemaHeader.dataTypeNodeId;
DataTypeSchemaHeader.schema.encodingDefaultBinary = DataTypeSchemaHeader.encodingDefaultBinary;
DataTypeSchemaHeader.schema.encodingDefaultXml = DataTypeSchemaHeader.encodingDefaultXml;
DataTypeSchemaHeader.schema.encodingDefaultJson = DataTypeSchemaHeader.encodingDefaultJson;
registerClassDefinition( DataTypeSchemaHeader.dataTypeNodeId, "DataTypeSchemaHeader", DataTypeSchemaHeader);

// --------------------------------------------------------------------------------------------
export enum DataSetFieldFlags {
    None = 0,
    PromotedField = 1,
    Invalid = 4294967295
}
const schemaDataSetFieldFlags = {
    enumValues: DataSetFieldFlags,
    flaggable: false,
    minValue: 0,
    maxValue: 1,
    name: "DataSetFieldFlags"
};
function decodeDataSetFieldFlags(stream: BinaryStream, _value?: DataSetFieldFlags): DataSetFieldFlags {
    let value =  stream.readUInt16() as DataSetFieldFlags;
    value = (value < schemaDataSetFieldFlags.minValue || value > schemaDataSetFieldFlags.maxValue) ? DataSetFieldFlags.Invalid : value; 
    return value;
}
function encodeDataSetFieldFlags(value: DataSetFieldFlags, stream: OutputBinaryStream): void {
    stream.writeUInt16(value);
}
export const _enumerationDataSetFieldFlags = registerEnumeration(schemaDataSetFieldFlags);
assert(_enumerationDataSetFieldFlags.isFlaggable ===  false);
// --------------------------------------------------------------------------------------------
const schemaFieldMetaData = buildStructuredType({
    name: "FieldMetaData",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Name",

            fieldType: "String",
        },
        {
            name: "Description",

            fieldType: "LocalizedText",
        },
        {
            name: "FieldFlags",

            fieldType: "DataSetFieldFlags",
        },
        {
            name: "BuiltInType",

            fieldType: "Byte",
        },
        {
            name: "DataType",

            fieldType: "NodeId",
        },
        {
            name: "ValueRank",

            fieldType: "Int32",
        },
        {
            name: "ArrayDimensions",

            fieldType: "UInt32",
            isArray: true
        },
        {
            name: "MaxStringLength",

            fieldType: "UInt32",
        },
        {
            name: "DataSetFieldId",

            fieldType: "Guid",
        },
        {
            name: "Properties",

            fieldType: "KeyValuePair",
            isArray: true
        },
    ]
});
export interface FieldMetaDataOptions {
    name?: UAString ;
    description?: (LocalizedTextLike | null);
    fieldFlags?: DataSetFieldFlags;
    builtInType?: Byte ;
    dataType?: (NodeIdLike | null);
    valueRank?: Int32 ;
    arrayDimensions?: UInt32 [] | null;
    maxStringLength?: UInt32 ;
    dataSetFieldId?: Guid ;
    properties?: KeyValuePairOptions [] | null;
}
export class FieldMetaData extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaFieldMetaData; }
    public static possibleFields: string[] = [
          "name",
           "description",
           "fieldFlags",
           "builtInType",
           "dataType",
           "valueRank",
           "arrayDimensions",
           "maxStringLength",
           "dataSetFieldId",
           "properties"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(14524, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(14839, 0);
    public static encodingDefaultXml = makeExpandedNodeId(14795, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15051, 0);
    public name: UAString;
    public description: LocalizedText;
    public fieldFlags: DataSetFieldFlags;
    public builtInType: Byte;
    public dataType: NodeId;
    public valueRank: Int32;
    public arrayDimensions: UInt32[] | null;
    public maxStringLength: UInt32;
    public dataSetFieldId: Guid;
    public properties: KeyValuePair[] | null;

    constructor(options?: FieldMetaDataOptions | null) {

        super(options);

        if (options === null) {
            this.name = null;
            this.description = new LocalizedText(null);
             this.fieldFlags =  0 as  DataSetFieldFlags;
            this.builtInType = 0;
            this.dataType = new NodeId(null);
            this.valueRank = 0;
            this.arrayDimensions = []
            this.maxStringLength = 0;
            this.dataSetFieldId = "";
         this.properties =  null; /* null array */
              return;
        }
        const schema = FieldMetaData.schema;
        options = (schema.constructHook ? schema.constructHook(options) as FieldMetaDataOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.name = initialize_field(schema.fields[0], options?.name);
        this.description = initialize_field(schema.fields[1], options?.description);
        this.fieldFlags = this.setFieldFlags(initialize_field(schema.fields[2], options?.fieldFlags));
        this.builtInType = initialize_field(schema.fields[3], options?.builtInType);
        this.dataType = initialize_field(schema.fields[4], options?.dataType);
        this.valueRank = initialize_field(schema.fields[5], options?.valueRank);
        this.arrayDimensions = initialize_field_array(schema.fields[6], options?.arrayDimensions);
        this.maxStringLength = initialize_field(schema.fields[7], options?.maxStringLength);
        this.dataSetFieldId = initialize_field(schema.fields[8], options?.dataSetFieldId);
        this.properties = []; // should default
        if (options.properties) {
            assert(Array.isArray(options.properties));
            this.properties = options.properties.map((e: any) => new KeyValuePair(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.name, stream);
        encodeLocalizedText(this.description, stream);
        encodeDataSetFieldFlags(this.fieldFlags, stream);
        encodeByte(this.builtInType, stream);
        encodeNodeId(this.dataType, stream);
        encodeInt32(this.valueRank, stream);
        encodeArray(this.arrayDimensions, stream, encodeUInt32);
        encodeUInt32(this.maxStringLength, stream);
        encodeGuid(this.dataSetFieldId, stream);
        encodeArray(this.properties, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = decodeString(stream, this.name);
        this.description = decodeLocalizedText(stream, this.description);
        this.fieldFlags = decodeDataSetFieldFlags(stream, this.fieldFlags);
        this.builtInType = decodeByte(stream, this.builtInType);
        this.dataType = decodeNodeId(stream, this.dataType);
        this.valueRank = decodeInt32(stream, this.valueRank);
        this.arrayDimensions = decodeArray(stream, decodeUInt32);
        this.maxStringLength = decodeUInt32(stream, this.maxStringLength);
        this.dataSetFieldId = decodeGuid(stream, this.dataSetFieldId);
        this.properties = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new KeyValuePair(null);
            obj.decode(stream1);
            return obj;
        });
    }

    // Define Enumeration setters
    public setFieldFlags(value: any): DataSetFieldFlags {
        const coercedValue = _enumerationDataSetFieldFlags.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to DataSetFieldFlags :" + value);
        }
        this.fieldFlags = coercedValue.value as DataSetFieldFlags;
        return this.fieldFlags;
    }
    public get schema(): IStructuredTypeSchema { return schemaFieldMetaData; }
}
FieldMetaData.schema.dataTypeNodeId = FieldMetaData.dataTypeNodeId;
FieldMetaData.schema.encodingDefaultBinary = FieldMetaData.encodingDefaultBinary;
FieldMetaData.schema.encodingDefaultXml = FieldMetaData.encodingDefaultXml;
FieldMetaData.schema.encodingDefaultJson = FieldMetaData.encodingDefaultJson;
registerClassDefinition( FieldMetaData.dataTypeNodeId, "FieldMetaData", FieldMetaData);
// --------------------------------------------------------------------------------------------
const schemaDataSetMetaDataType = buildStructuredType({
    name: "DataSetMetaDataType",

    baseType: "DataTypeSchemaHeader",
    fields: [
        {
            name: "Name",

            fieldType: "String",
        },
        {
            name: "Description",

            fieldType: "LocalizedText",
        },
        {
            name: "Fields",

            fieldType: "FieldMetaData",
            isArray: true
        },
        {
            name: "DataSetClassId",

            fieldType: "Guid",
        },
        {
            name: "ConfigurationVersion",

            fieldType: "ConfigurationVersionDataType",
        },
    ]
});
export interface DataSetMetaDataTypeOptions extends DataTypeSchemaHeaderOptions {
    name?: UAString ;
    description?: (LocalizedTextLike | null);
    fields?: FieldMetaDataOptions [] | null;
    dataSetClassId?: Guid ;
    configurationVersion?: ConfigurationVersionDataTypeOptions ;
}
export class DataSetMetaDataType extends DataTypeSchemaHeader {
    public static get schema(): IStructuredTypeSchema { return schemaDataSetMetaDataType; }
    public static possibleFields: string[] = [
          "namespaces",
           "structureDataTypes",
           "enumDataTypes",
           "simpleDataTypes",
           "name",
           "description",
           "fields",
           "dataSetClassId",
           "configurationVersion"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(14523, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(124, 0);
    public static encodingDefaultXml = makeExpandedNodeId(14794, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15050, 0);
    public name: UAString;
    public description: LocalizedText;
    public fields: FieldMetaData[] | null;
    public dataSetClassId: Guid;
    public configurationVersion: ConfigurationVersionDataType;

    constructor(options?: DataSetMetaDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.name = null;
            this.description = new LocalizedText(null);
         this.fields =  null; /* null array */
            this.dataSetClassId = "";
         this.configurationVersion =  new ConfigurationVersionDataType(null);
              return;
        }
        const schema = DataSetMetaDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DataSetMetaDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.name = initialize_field(schema.fields[0], options?.name);
        this.description = initialize_field(schema.fields[1], options?.description);
        this.fields = []; // should default
        if (options.fields) {
            assert(Array.isArray(options.fields));
            this.fields = options.fields.map((e: any) => new FieldMetaData(e));
        }
        this.dataSetClassId = initialize_field(schema.fields[3], options?.dataSetClassId);
        this.configurationVersion  =  new ConfigurationVersionDataType(options.configurationVersion);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.name, stream);
        encodeLocalizedText(this.description, stream);
        encodeArray(this.fields, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeGuid(this.dataSetClassId, stream);
        this.configurationVersion.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = decodeString(stream, this.name);
        this.description = decodeLocalizedText(stream, this.description);
        this.fields = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new FieldMetaData(null);
            obj.decode(stream1);
            return obj;
        });
        this.dataSetClassId = decodeGuid(stream, this.dataSetClassId);
        this.configurationVersion.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaDataSetMetaDataType; }
}
DataSetMetaDataType.schema.dataTypeNodeId = DataSetMetaDataType.dataTypeNodeId;
DataSetMetaDataType.schema.encodingDefaultBinary = DataSetMetaDataType.encodingDefaultBinary;
DataSetMetaDataType.schema.encodingDefaultXml = DataSetMetaDataType.encodingDefaultXml;
DataSetMetaDataType.schema.encodingDefaultJson = DataSetMetaDataType.encodingDefaultJson;
registerClassDefinition( DataSetMetaDataType.dataTypeNodeId, "DataSetMetaDataType", DataSetMetaDataType);

// --------------------------------------------------------------------------------------------
export enum DataSetFieldContentMask {
    None = 0,
    StatusCode = 1,
    SourceTimestamp = 2,
    ServerTimestamp = 4,
    SourcePicoSeconds = 8,
    ServerPicoSeconds = 16,
    RawData = 32
}
const schemaDataSetFieldContentMask = {
    enumValues: DataSetFieldContentMask,
    flaggable: true,
    name: "DataSetFieldContentMask"
};
function decodeDataSetFieldContentMask(stream: BinaryStream, _value?: DataSetFieldContentMask): DataSetFieldContentMask {
    return  stream.readUInt32() as DataSetFieldContentMask;
}
function encodeDataSetFieldContentMask(value: DataSetFieldContentMask, stream: OutputBinaryStream): void {
    stream.writeUInt32(value);
}
export const _enumerationDataSetFieldContentMask = registerEnumeration(schemaDataSetFieldContentMask);
assert(_enumerationDataSetFieldContentMask.isFlaggable ===  true);
// --------------------------------------------------------------------------------------------
const schemaDataSetReaderDataType = buildStructuredType({
    name: "DataSetReaderDataType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Name",

            fieldType: "String",
        },
        {
            name: "Enabled",

            fieldType: "Boolean",
        },
        {
            name: "PublisherId",

            fieldType: "Variant",
        },
        {
            name: "WriterGroupId",

            fieldType: "UInt16",
        },
        {
            name: "DataSetWriterId",

            fieldType: "UInt16",
        },
        {
            name: "DataSetMetaData",

            fieldType: "DataSetMetaDataType",
        },
        {
            name: "DataSetFieldContentMask",

            fieldType: "DataSetFieldContentMask",
        },
        {
            name: "MessageReceiveTimeout",

            fieldType: "Double",
        },
        {
            name: "KeyFrameCount",

            fieldType: "UInt32",
        },
        {
            name: "HeaderLayoutUri",

            fieldType: "String",
        },
        {
            name: "SecurityMode",

            fieldType: "MessageSecurityMode",
        },
        {
            name: "SecurityGroupId",

            fieldType: "String",
        },
        {
            name: "SecurityKeyServices",

            fieldType: "EndpointDescription",
            isArray: true
        },
        {
            name: "DataSetReaderProperties",

            fieldType: "KeyValuePair",
            isArray: true
        },
        {
            name: "TransportSettings",

            fieldType: "ExtensionObject",
        },
        {
            name: "MessageSettings",

            fieldType: "ExtensionObject",
        },
        {
            name: "SubscribedDataSet",

            fieldType: "ExtensionObject",
        },
    ]
});
export interface DataSetReaderDataTypeOptions {
    name?: UAString ;
    enabled?: UABoolean ;
    publisherId?: (VariantLike | null);
    writerGroupId?: UInt16 ;
    dataSetWriterId?: UInt16 ;
    dataSetMetaData?: DataSetMetaDataTypeOptions ;
    dataSetFieldContentMask?: DataSetFieldContentMask;
    messageReceiveTimeout?: Double ;
    keyFrameCount?: UInt32 ;
    headerLayoutUri?: UAString ;
    securityMode?: MessageSecurityMode;
    securityGroupId?: UAString ;
    securityKeyServices?: EndpointDescriptionOptions [] | null;
    dataSetReaderProperties?: KeyValuePairOptions [] | null;
    transportSettings?: (ExtensionObject | null);
    messageSettings?: (ExtensionObject | null);
    subscribedDataSet?: (ExtensionObject | null);
}
export class DataSetReaderDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaDataSetReaderDataType; }
    public static possibleFields: string[] = [
          "name",
           "enabled",
           "publisherId",
           "writerGroupId",
           "dataSetWriterId",
           "dataSetMetaData",
           "dataSetFieldContentMask",
           "messageReceiveTimeout",
           "keyFrameCount",
           "headerLayoutUri",
           "securityMode",
           "securityGroupId",
           "securityKeyServices",
           "dataSetReaderProperties",
           "transportSettings",
           "messageSettings",
           "subscribedDataSet"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15623, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15703, 0);
    public static encodingDefaultXml = makeExpandedNodeId(16007, 0);
    public static encodingDefaultJson = makeExpandedNodeId(16286, 0);
    public name: UAString;
    public enabled: UABoolean;
    public publisherId: Variant;
    public writerGroupId: UInt16;
    public dataSetWriterId: UInt16;
    public dataSetMetaData: DataSetMetaDataType;
    public dataSetFieldContentMask: DataSetFieldContentMask;
    public messageReceiveTimeout: Double;
    public keyFrameCount: UInt32;
    public headerLayoutUri: UAString;
    public securityMode: MessageSecurityMode;
    public securityGroupId: UAString;
    public securityKeyServices: EndpointDescription[] | null;
    public dataSetReaderProperties: KeyValuePair[] | null;
    public transportSettings: (ExtensionObject | null);
    public messageSettings: (ExtensionObject | null);
    public subscribedDataSet: (ExtensionObject | null);

    constructor(options?: DataSetReaderDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.name = null;
            this.enabled = false;
            this.publisherId = new Variant(null);
            this.writerGroupId = 0;
            this.dataSetWriterId = 0;
         this.dataSetMetaData =  new DataSetMetaDataType(null);
             this.dataSetFieldContentMask =  0 as  DataSetFieldContentMask;
            this.messageReceiveTimeout = 0;
            this.keyFrameCount = 0;
            this.headerLayoutUri = null;
             this.securityMode =  0 as  MessageSecurityMode;
            this.securityGroupId = null;
         this.securityKeyServices =  null; /* null array */
         this.dataSetReaderProperties =  null; /* null array */
            this.transportSettings = null;
            this.messageSettings = null;
            this.subscribedDataSet = null;
              return;
        }
        const schema = DataSetReaderDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DataSetReaderDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.name = initialize_field(schema.fields[0], options?.name);
        this.enabled = initialize_field(schema.fields[1], options?.enabled);
        this.publisherId = initialize_field(schema.fields[2], options?.publisherId);
        this.writerGroupId = initialize_field(schema.fields[3], options?.writerGroupId);
        this.dataSetWriterId = initialize_field(schema.fields[4], options?.dataSetWriterId);
        this.dataSetMetaData  =  new DataSetMetaDataType(options.dataSetMetaData);
        this.dataSetFieldContentMask = this.setDataSetFieldContentMask(initialize_field(schema.fields[6], options?.dataSetFieldContentMask));
        this.messageReceiveTimeout = initialize_field(schema.fields[7], options?.messageReceiveTimeout);
        this.keyFrameCount = initialize_field(schema.fields[8], options?.keyFrameCount);
        this.headerLayoutUri = initialize_field(schema.fields[9], options?.headerLayoutUri);
        this.securityMode = this.setSecurityMode(initialize_field(schema.fields[10], options?.securityMode));
        this.securityGroupId = initialize_field(schema.fields[11], options?.securityGroupId);
        this.securityKeyServices = []; // should default
        if (options.securityKeyServices) {
            assert(Array.isArray(options.securityKeyServices));
            this.securityKeyServices = options.securityKeyServices.map((e: any) => new EndpointDescription(e));
        }
        this.dataSetReaderProperties = []; // should default
        if (options.dataSetReaderProperties) {
            assert(Array.isArray(options.dataSetReaderProperties));
            this.dataSetReaderProperties = options.dataSetReaderProperties.map((e: any) => new KeyValuePair(e));
        }
        this.transportSettings = initialize_field(schema.fields[14], options?.transportSettings);
        this.messageSettings = initialize_field(schema.fields[15], options?.messageSettings);
        this.subscribedDataSet = initialize_field(schema.fields[16], options?.subscribedDataSet);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.name, stream);
        encodeBoolean(this.enabled, stream);
        encodeVariant(this.publisherId, stream);
        encodeUInt16(this.writerGroupId, stream);
        encodeUInt16(this.dataSetWriterId, stream);
        this.dataSetMetaData.encode(stream);
        encodeDataSetFieldContentMask(this.dataSetFieldContentMask, stream);
        encodeDouble(this.messageReceiveTimeout, stream);
        encodeUInt32(this.keyFrameCount, stream);
        encodeString(this.headerLayoutUri, stream);
        encodeMessageSecurityMode(this.securityMode, stream);
        encodeString(this.securityGroupId, stream);
        encodeArray(this.securityKeyServices, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.dataSetReaderProperties, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeExtensionObject(this.transportSettings, stream);
        encodeExtensionObject(this.messageSettings, stream);
        encodeExtensionObject(this.subscribedDataSet, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = decodeString(stream, this.name);
        this.enabled = decodeBoolean(stream, this.enabled);
        this.publisherId = decodeVariant(stream, this.publisherId);
        this.writerGroupId = decodeUInt16(stream, this.writerGroupId);
        this.dataSetWriterId = decodeUInt16(stream, this.dataSetWriterId);
        this.dataSetMetaData.decode(stream);
        this.dataSetFieldContentMask = decodeDataSetFieldContentMask(stream, this.dataSetFieldContentMask);
        this.messageReceiveTimeout = decodeDouble(stream, this.messageReceiveTimeout);
        this.keyFrameCount = decodeUInt32(stream, this.keyFrameCount);
        this.headerLayoutUri = decodeString(stream, this.headerLayoutUri);
        this.securityMode = decodeMessageSecurityMode(stream, this.securityMode);
        this.securityGroupId = decodeString(stream, this.securityGroupId);
        this.securityKeyServices = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new EndpointDescription(null);
            obj.decode(stream1);
            return obj;
        });
        this.dataSetReaderProperties = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new KeyValuePair(null);
            obj.decode(stream1);
            return obj;
        });
        this.transportSettings = decodeExtensionObject(stream, this.transportSettings);
        this.messageSettings = decodeExtensionObject(stream, this.messageSettings);
        this.subscribedDataSet = decodeExtensionObject(stream, this.subscribedDataSet);
    }

    // Define Enumeration setters
    public setDataSetFieldContentMask(value: any): DataSetFieldContentMask {
        const coercedValue = _enumerationDataSetFieldContentMask.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to DataSetFieldContentMask :" + value);
        }
        this.dataSetFieldContentMask = coercedValue.value as DataSetFieldContentMask;
        return this.dataSetFieldContentMask;
    }
    public setSecurityMode(value: any): MessageSecurityMode {
        const coercedValue = _enumerationMessageSecurityMode.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to MessageSecurityMode :" + value);
        }
        this.securityMode = coercedValue.value as MessageSecurityMode;
        return this.securityMode;
    }
    public get schema(): IStructuredTypeSchema { return schemaDataSetReaderDataType; }
}
DataSetReaderDataType.schema.dataTypeNodeId = DataSetReaderDataType.dataTypeNodeId;
DataSetReaderDataType.schema.encodingDefaultBinary = DataSetReaderDataType.encodingDefaultBinary;
DataSetReaderDataType.schema.encodingDefaultXml = DataSetReaderDataType.encodingDefaultXml;
DataSetReaderDataType.schema.encodingDefaultJson = DataSetReaderDataType.encodingDefaultJson;
registerClassDefinition( DataSetReaderDataType.dataTypeNodeId, "DataSetReaderDataType", DataSetReaderDataType);
// --------------------------------------------------------------------------------------------
const schemaDataSetReaderMessageDataType = buildStructuredType({
    name: "DataSetReaderMessageDataType",

    baseType: "ExtensionObject",
    fields: [
    ]
});
export interface DataSetReaderMessageDataTypeOptions {
}
export class DataSetReaderMessageDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaDataSetReaderMessageDataType; }
    public static possibleFields: string[] = [
          
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15629, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15706, 0);
    public static encodingDefaultXml = makeExpandedNodeId(16009, 0);
    public static encodingDefaultJson = makeExpandedNodeId(16288, 0);

    constructor(options?: DataSetReaderMessageDataTypeOptions | null) {

        super(options);

        if (options === null) {
              return;
        }
        const schema = DataSetReaderMessageDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DataSetReaderMessageDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaDataSetReaderMessageDataType; }
}
DataSetReaderMessageDataType.schema.dataTypeNodeId = DataSetReaderMessageDataType.dataTypeNodeId;
DataSetReaderMessageDataType.schema.encodingDefaultBinary = DataSetReaderMessageDataType.encodingDefaultBinary;
DataSetReaderMessageDataType.schema.encodingDefaultXml = DataSetReaderMessageDataType.encodingDefaultXml;
DataSetReaderMessageDataType.schema.encodingDefaultJson = DataSetReaderMessageDataType.encodingDefaultJson;
registerClassDefinition( DataSetReaderMessageDataType.dataTypeNodeId, "DataSetReaderMessageDataType", DataSetReaderMessageDataType);
// --------------------------------------------------------------------------------------------
const schemaDataSetWriterDataType = buildStructuredType({
    name: "DataSetWriterDataType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Name",

            fieldType: "String",
        },
        {
            name: "Enabled",

            fieldType: "Boolean",
        },
        {
            name: "DataSetWriterId",

            fieldType: "UInt16",
        },
        {
            name: "DataSetFieldContentMask",

            fieldType: "DataSetFieldContentMask",
        },
        {
            name: "KeyFrameCount",

            fieldType: "UInt32",
        },
        {
            name: "DataSetName",

            fieldType: "String",
        },
        {
            name: "DataSetWriterProperties",

            fieldType: "KeyValuePair",
            isArray: true
        },
        {
            name: "TransportSettings",

            fieldType: "ExtensionObject",
        },
        {
            name: "MessageSettings",

            fieldType: "ExtensionObject",
        },
    ]
});
export interface DataSetWriterDataTypeOptions {
    name?: UAString ;
    enabled?: UABoolean ;
    dataSetWriterId?: UInt16 ;
    dataSetFieldContentMask?: DataSetFieldContentMask;
    keyFrameCount?: UInt32 ;
    dataSetName?: UAString ;
    dataSetWriterProperties?: KeyValuePairOptions [] | null;
    transportSettings?: (ExtensionObject | null);
    messageSettings?: (ExtensionObject | null);
}
export class DataSetWriterDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaDataSetWriterDataType; }
    public static possibleFields: string[] = [
          "name",
           "enabled",
           "dataSetWriterId",
           "dataSetFieldContentMask",
           "keyFrameCount",
           "dataSetName",
           "dataSetWriterProperties",
           "transportSettings",
           "messageSettings"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15597, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15682, 0);
    public static encodingDefaultXml = makeExpandedNodeId(15955, 0);
    public static encodingDefaultJson = makeExpandedNodeId(16156, 0);
    public name: UAString;
    public enabled: UABoolean;
    public dataSetWriterId: UInt16;
    public dataSetFieldContentMask: DataSetFieldContentMask;
    public keyFrameCount: UInt32;
    public dataSetName: UAString;
    public dataSetWriterProperties: KeyValuePair[] | null;
    public transportSettings: (ExtensionObject | null);
    public messageSettings: (ExtensionObject | null);

    constructor(options?: DataSetWriterDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.name = null;
            this.enabled = false;
            this.dataSetWriterId = 0;
             this.dataSetFieldContentMask =  0 as  DataSetFieldContentMask;
            this.keyFrameCount = 0;
            this.dataSetName = null;
         this.dataSetWriterProperties =  null; /* null array */
            this.transportSettings = null;
            this.messageSettings = null;
              return;
        }
        const schema = DataSetWriterDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DataSetWriterDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.name = initialize_field(schema.fields[0], options?.name);
        this.enabled = initialize_field(schema.fields[1], options?.enabled);
        this.dataSetWriterId = initialize_field(schema.fields[2], options?.dataSetWriterId);
        this.dataSetFieldContentMask = this.setDataSetFieldContentMask(initialize_field(schema.fields[3], options?.dataSetFieldContentMask));
        this.keyFrameCount = initialize_field(schema.fields[4], options?.keyFrameCount);
        this.dataSetName = initialize_field(schema.fields[5], options?.dataSetName);
        this.dataSetWriterProperties = []; // should default
        if (options.dataSetWriterProperties) {
            assert(Array.isArray(options.dataSetWriterProperties));
            this.dataSetWriterProperties = options.dataSetWriterProperties.map((e: any) => new KeyValuePair(e));
        }
        this.transportSettings = initialize_field(schema.fields[7], options?.transportSettings);
        this.messageSettings = initialize_field(schema.fields[8], options?.messageSettings);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.name, stream);
        encodeBoolean(this.enabled, stream);
        encodeUInt16(this.dataSetWriterId, stream);
        encodeDataSetFieldContentMask(this.dataSetFieldContentMask, stream);
        encodeUInt32(this.keyFrameCount, stream);
        encodeString(this.dataSetName, stream);
        encodeArray(this.dataSetWriterProperties, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeExtensionObject(this.transportSettings, stream);
        encodeExtensionObject(this.messageSettings, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = decodeString(stream, this.name);
        this.enabled = decodeBoolean(stream, this.enabled);
        this.dataSetWriterId = decodeUInt16(stream, this.dataSetWriterId);
        this.dataSetFieldContentMask = decodeDataSetFieldContentMask(stream, this.dataSetFieldContentMask);
        this.keyFrameCount = decodeUInt32(stream, this.keyFrameCount);
        this.dataSetName = decodeString(stream, this.dataSetName);
        this.dataSetWriterProperties = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new KeyValuePair(null);
            obj.decode(stream1);
            return obj;
        });
        this.transportSettings = decodeExtensionObject(stream, this.transportSettings);
        this.messageSettings = decodeExtensionObject(stream, this.messageSettings);
    }

    // Define Enumeration setters
    public setDataSetFieldContentMask(value: any): DataSetFieldContentMask {
        const coercedValue = _enumerationDataSetFieldContentMask.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to DataSetFieldContentMask :" + value);
        }
        this.dataSetFieldContentMask = coercedValue.value as DataSetFieldContentMask;
        return this.dataSetFieldContentMask;
    }
    public get schema(): IStructuredTypeSchema { return schemaDataSetWriterDataType; }
}
DataSetWriterDataType.schema.dataTypeNodeId = DataSetWriterDataType.dataTypeNodeId;
DataSetWriterDataType.schema.encodingDefaultBinary = DataSetWriterDataType.encodingDefaultBinary;
DataSetWriterDataType.schema.encodingDefaultXml = DataSetWriterDataType.encodingDefaultXml;
DataSetWriterDataType.schema.encodingDefaultJson = DataSetWriterDataType.encodingDefaultJson;
registerClassDefinition( DataSetWriterDataType.dataTypeNodeId, "DataSetWriterDataType", DataSetWriterDataType);
// --------------------------------------------------------------------------------------------
const schemaDataSetWriterMessageDataType = buildStructuredType({
    name: "DataSetWriterMessageDataType",

    baseType: "ExtensionObject",
    fields: [
    ]
});
export interface DataSetWriterMessageDataTypeOptions {
}
export class DataSetWriterMessageDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaDataSetWriterMessageDataType; }
    public static possibleFields: string[] = [
          
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15605, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15688, 0);
    public static encodingDefaultXml = makeExpandedNodeId(15987, 0);
    public static encodingDefaultJson = makeExpandedNodeId(16158, 0);

    constructor(options?: DataSetWriterMessageDataTypeOptions | null) {

        super(options);

        if (options === null) {
              return;
        }
        const schema = DataSetWriterMessageDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DataSetWriterMessageDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaDataSetWriterMessageDataType; }
}
DataSetWriterMessageDataType.schema.dataTypeNodeId = DataSetWriterMessageDataType.dataTypeNodeId;
DataSetWriterMessageDataType.schema.encodingDefaultBinary = DataSetWriterMessageDataType.encodingDefaultBinary;
DataSetWriterMessageDataType.schema.encodingDefaultXml = DataSetWriterMessageDataType.encodingDefaultXml;
DataSetWriterMessageDataType.schema.encodingDefaultJson = DataSetWriterMessageDataType.encodingDefaultJson;
registerClassDefinition( DataSetWriterMessageDataType.dataTypeNodeId, "DataSetWriterMessageDataType", DataSetWriterMessageDataType);
// --------------------------------------------------------------------------------------------
const schemaNodeAttributes = buildStructuredType({
    name: "NodeAttributes",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "SpecifiedAttributes",

            fieldType: "UInt32",
        },
        {
            name: "DisplayName",

            fieldType: "LocalizedText",
        },
        {
            name: "Description",

            fieldType: "LocalizedText",
        },
        {
            name: "WriteMask",

            fieldType: "UInt32",
        },
        {
            name: "UserWriteMask",

            fieldType: "UInt32",
        },
    ]
});
export interface NodeAttributesOptions {
    specifiedAttributes?: UInt32 ;
    displayName?: (LocalizedTextLike | null);
    description?: (LocalizedTextLike | null);
    writeMask?: UInt32 ;
    userWriteMask?: UInt32 ;
}
export class NodeAttributes extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaNodeAttributes; }
    public static possibleFields: string[] = [
          "specifiedAttributes",
           "displayName",
           "description",
           "writeMask",
           "userWriteMask"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(349, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(351, 0);
    public static encodingDefaultXml = makeExpandedNodeId(350, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15151, 0);
    public specifiedAttributes: UInt32;
    public displayName: LocalizedText;
    public description: LocalizedText;
    public writeMask: UInt32;
    public userWriteMask: UInt32;

    constructor(options?: NodeAttributesOptions | null) {

        super(options);

        if (options === null) {
            this.specifiedAttributes = 0;
            this.displayName = new LocalizedText(null);
            this.description = new LocalizedText(null);
            this.writeMask = 0;
            this.userWriteMask = 0;
              return;
        }
        const schema = NodeAttributes.schema;
        options = (schema.constructHook ? schema.constructHook(options) as NodeAttributesOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.specifiedAttributes = initialize_field(schema.fields[0], options?.specifiedAttributes);
        this.displayName = initialize_field(schema.fields[1], options?.displayName);
        this.description = initialize_field(schema.fields[2], options?.description);
        this.writeMask = initialize_field(schema.fields[3], options?.writeMask);
        this.userWriteMask = initialize_field(schema.fields[4], options?.userWriteMask);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeUInt32(this.specifiedAttributes, stream);
        encodeLocalizedText(this.displayName, stream);
        encodeLocalizedText(this.description, stream);
        encodeUInt32(this.writeMask, stream);
        encodeUInt32(this.userWriteMask, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.specifiedAttributes = decodeUInt32(stream, this.specifiedAttributes);
        this.displayName = decodeLocalizedText(stream, this.displayName);
        this.description = decodeLocalizedText(stream, this.description);
        this.writeMask = decodeUInt32(stream, this.writeMask);
        this.userWriteMask = decodeUInt32(stream, this.userWriteMask);
    }
    public get schema(): IStructuredTypeSchema { return schemaNodeAttributes; }
}
NodeAttributes.schema.dataTypeNodeId = NodeAttributes.dataTypeNodeId;
NodeAttributes.schema.encodingDefaultBinary = NodeAttributes.encodingDefaultBinary;
NodeAttributes.schema.encodingDefaultXml = NodeAttributes.encodingDefaultXml;
NodeAttributes.schema.encodingDefaultJson = NodeAttributes.encodingDefaultJson;
registerClassDefinition( NodeAttributes.dataTypeNodeId, "NodeAttributes", NodeAttributes);
// --------------------------------------------------------------------------------------------
const schemaDataTypeAttributes = buildStructuredType({
    name: "DataTypeAttributes",

    baseType: "NodeAttributes",
    fields: [
        {
            name: "IsAbstract",

            fieldType: "Boolean",
        },
    ]
});
export interface DataTypeAttributesOptions extends NodeAttributesOptions {
    isAbstract?: UABoolean ;
}
export class DataTypeAttributes extends NodeAttributes {
    public static get schema(): IStructuredTypeSchema { return schemaDataTypeAttributes; }
    public static possibleFields: string[] = [
          "specifiedAttributes",
           "displayName",
           "description",
           "writeMask",
           "userWriteMask",
           "isAbstract"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(370, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(372, 0);
    public static encodingDefaultXml = makeExpandedNodeId(371, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15161, 0);
    public isAbstract: UABoolean;

    constructor(options?: DataTypeAttributesOptions | null) {

        super(options);

        if (options === null) {
            this.isAbstract = false;
              return;
        }
        const schema = DataTypeAttributes.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DataTypeAttributesOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.isAbstract = initialize_field(schema.fields[0], options?.isAbstract);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeBoolean(this.isAbstract, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.isAbstract = decodeBoolean(stream, this.isAbstract);
    }
    public get schema(): IStructuredTypeSchema { return schemaDataTypeAttributes; }
}
DataTypeAttributes.schema.dataTypeNodeId = DataTypeAttributes.dataTypeNodeId;
DataTypeAttributes.schema.encodingDefaultBinary = DataTypeAttributes.encodingDefaultBinary;
DataTypeAttributes.schema.encodingDefaultXml = DataTypeAttributes.encodingDefaultXml;
DataTypeAttributes.schema.encodingDefaultJson = DataTypeAttributes.encodingDefaultJson;
registerClassDefinition( DataTypeAttributes.dataTypeNodeId, "DataTypeAttributes", DataTypeAttributes);
// --------------------------------------------------------------------------------------------
const schemaDatagramConnectionTransportDataType = buildStructuredType({
    name: "DatagramConnectionTransportDataType",

    baseType: "ConnectionTransportDataType",
    fields: [
        {
            name: "DiscoveryAddress",

            fieldType: "ExtensionObject",
        },
    ]
});
export interface DatagramConnectionTransportDataTypeOptions extends ConnectionTransportDataTypeOptions {
    discoveryAddress?: (ExtensionObject | null);
}
export class DatagramConnectionTransportDataType extends ConnectionTransportDataType {
    public static get schema(): IStructuredTypeSchema { return schemaDatagramConnectionTransportDataType; }
    public static possibleFields: string[] = [
          "discoveryAddress"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(17467, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(17468, 0);
    public static encodingDefaultXml = makeExpandedNodeId(17472, 0);
    public static encodingDefaultJson = makeExpandedNodeId(17476, 0);
    public discoveryAddress: (ExtensionObject | null);

    constructor(options?: DatagramConnectionTransportDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.discoveryAddress = null;
              return;
        }
        const schema = DatagramConnectionTransportDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DatagramConnectionTransportDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.discoveryAddress = initialize_field(schema.fields[0], options?.discoveryAddress);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeExtensionObject(this.discoveryAddress, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.discoveryAddress = decodeExtensionObject(stream, this.discoveryAddress);
    }
    public get schema(): IStructuredTypeSchema { return schemaDatagramConnectionTransportDataType; }
}
DatagramConnectionTransportDataType.schema.dataTypeNodeId = DatagramConnectionTransportDataType.dataTypeNodeId;
DatagramConnectionTransportDataType.schema.encodingDefaultBinary = DatagramConnectionTransportDataType.encodingDefaultBinary;
DatagramConnectionTransportDataType.schema.encodingDefaultXml = DatagramConnectionTransportDataType.encodingDefaultXml;
DatagramConnectionTransportDataType.schema.encodingDefaultJson = DatagramConnectionTransportDataType.encodingDefaultJson;
registerClassDefinition( DatagramConnectionTransportDataType.dataTypeNodeId, "DatagramConnectionTransportDataType", DatagramConnectionTransportDataType);
// --------------------------------------------------------------------------------------------
const schemaDatagramConnectionTransport2DataType = buildStructuredType({
    name: "DatagramConnectionTransport2DataType",

    baseType: "DatagramConnectionTransportDataType",
    fields: [
        {
            name: "DiscoveryAnnounceRate",

            fieldType: "UInt32",
        },
        {
            name: "DiscoveryMaxMessageSize",

            fieldType: "UInt32",
        },
        {
            name: "QosCategory",

            fieldType: "String",
        },
        {
            name: "DatagramQos",

            fieldType: "ExtensionObject",
            isArray: true
        },
    ]
});
export interface DatagramConnectionTransport2DataTypeOptions extends DatagramConnectionTransportDataTypeOptions {
    discoveryAnnounceRate?: UInt32 ;
    discoveryMaxMessageSize?: UInt32 ;
    qosCategory?: UAString ;
    datagramQos?: (ExtensionObject | null)[] | null;
}
export class DatagramConnectionTransport2DataType extends DatagramConnectionTransportDataType {
    public static get schema(): IStructuredTypeSchema { return schemaDatagramConnectionTransport2DataType; }
    public static possibleFields: string[] = [
          "discoveryAddress",
           "discoveryAnnounceRate",
           "discoveryMaxMessageSize",
           "qosCategory",
           "datagramQos"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(23612, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(23864, 0);
    public static encodingDefaultXml = makeExpandedNodeId(23932, 0);
    public static encodingDefaultJson = makeExpandedNodeId(24000, 0);
    public discoveryAnnounceRate: UInt32;
    public discoveryMaxMessageSize: UInt32;
    public qosCategory: UAString;
    public datagramQos: (ExtensionObject | null)[] | null;

    constructor(options?: DatagramConnectionTransport2DataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.discoveryAnnounceRate = 0;
            this.discoveryMaxMessageSize = 0;
            this.qosCategory = null;
            this.datagramQos = []
              return;
        }
        const schema = DatagramConnectionTransport2DataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DatagramConnectionTransport2DataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.discoveryAnnounceRate = initialize_field(schema.fields[0], options?.discoveryAnnounceRate);
        this.discoveryMaxMessageSize = initialize_field(schema.fields[1], options?.discoveryMaxMessageSize);
        this.qosCategory = initialize_field(schema.fields[2], options?.qosCategory);
        this.datagramQos = initialize_field_array(schema.fields[3], options?.datagramQos);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeUInt32(this.discoveryAnnounceRate, stream);
        encodeUInt32(this.discoveryMaxMessageSize, stream);
        encodeString(this.qosCategory, stream);
        encodeArray(this.datagramQos, stream, encodeExtensionObject);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.discoveryAnnounceRate = decodeUInt32(stream, this.discoveryAnnounceRate);
        this.discoveryMaxMessageSize = decodeUInt32(stream, this.discoveryMaxMessageSize);
        this.qosCategory = decodeString(stream, this.qosCategory);
        this.datagramQos = decodeArray(stream, decodeExtensionObject);
    }
    public get schema(): IStructuredTypeSchema { return schemaDatagramConnectionTransport2DataType; }
}
DatagramConnectionTransport2DataType.schema.dataTypeNodeId = DatagramConnectionTransport2DataType.dataTypeNodeId;
DatagramConnectionTransport2DataType.schema.encodingDefaultBinary = DatagramConnectionTransport2DataType.encodingDefaultBinary;
DatagramConnectionTransport2DataType.schema.encodingDefaultXml = DatagramConnectionTransport2DataType.encodingDefaultXml;
DatagramConnectionTransport2DataType.schema.encodingDefaultJson = DatagramConnectionTransport2DataType.encodingDefaultJson;
registerClassDefinition( DatagramConnectionTransport2DataType.dataTypeNodeId, "DatagramConnectionTransport2DataType", DatagramConnectionTransport2DataType);
// --------------------------------------------------------------------------------------------
const schemaDatagramDataSetReaderTransportDataType = buildStructuredType({
    name: "DatagramDataSetReaderTransportDataType",

    baseType: "DataSetReaderTransportDataType",
    fields: [
        {
            name: "Address",

            fieldType: "ExtensionObject",
        },
        {
            name: "QosCategory",

            fieldType: "String",
        },
        {
            name: "DatagramQos",

            fieldType: "ExtensionObject",
            isArray: true
        },
        {
            name: "Topic",

            fieldType: "String",
        },
    ]
});
export interface DatagramDataSetReaderTransportDataTypeOptions extends DataSetReaderTransportDataTypeOptions {
    address?: (ExtensionObject | null);
    qosCategory?: UAString ;
    datagramQos?: (ExtensionObject | null)[] | null;
    topic?: UAString ;
}
export class DatagramDataSetReaderTransportDataType extends DataSetReaderTransportDataType {
    public static get schema(): IStructuredTypeSchema { return schemaDatagramDataSetReaderTransportDataType; }
    public static possibleFields: string[] = [
          "address",
           "qosCategory",
           "datagramQos",
           "topic"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(23614, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(23866, 0);
    public static encodingDefaultXml = makeExpandedNodeId(23934, 0);
    public static encodingDefaultJson = makeExpandedNodeId(24002, 0);
    public address: (ExtensionObject | null);
    public qosCategory: UAString;
    public datagramQos: (ExtensionObject | null)[] | null;
    public topic: UAString;

    constructor(options?: DatagramDataSetReaderTransportDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.address = null;
            this.qosCategory = null;
            this.datagramQos = []
            this.topic = null;
              return;
        }
        const schema = DatagramDataSetReaderTransportDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DatagramDataSetReaderTransportDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.address = initialize_field(schema.fields[0], options?.address);
        this.qosCategory = initialize_field(schema.fields[1], options?.qosCategory);
        this.datagramQos = initialize_field_array(schema.fields[2], options?.datagramQos);
        this.topic = initialize_field(schema.fields[3], options?.topic);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeExtensionObject(this.address, stream);
        encodeString(this.qosCategory, stream);
        encodeArray(this.datagramQos, stream, encodeExtensionObject);
        encodeString(this.topic, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.address = decodeExtensionObject(stream, this.address);
        this.qosCategory = decodeString(stream, this.qosCategory);
        this.datagramQos = decodeArray(stream, decodeExtensionObject);
        this.topic = decodeString(stream, this.topic);
    }
    public get schema(): IStructuredTypeSchema { return schemaDatagramDataSetReaderTransportDataType; }
}
DatagramDataSetReaderTransportDataType.schema.dataTypeNodeId = DatagramDataSetReaderTransportDataType.dataTypeNodeId;
DatagramDataSetReaderTransportDataType.schema.encodingDefaultBinary = DatagramDataSetReaderTransportDataType.encodingDefaultBinary;
DatagramDataSetReaderTransportDataType.schema.encodingDefaultXml = DatagramDataSetReaderTransportDataType.encodingDefaultXml;
DatagramDataSetReaderTransportDataType.schema.encodingDefaultJson = DatagramDataSetReaderTransportDataType.encodingDefaultJson;
registerClassDefinition( DatagramDataSetReaderTransportDataType.dataTypeNodeId, "DatagramDataSetReaderTransportDataType", DatagramDataSetReaderTransportDataType);
// --------------------------------------------------------------------------------------------
const schemaDatagramWriterGroupTransportDataType = buildStructuredType({
    name: "DatagramWriterGroupTransportDataType",

    baseType: "WriterGroupTransportDataType",
    fields: [
        {
            name: "MessageRepeatCount",

            fieldType: "Byte",
        },
        {
            name: "MessageRepeatDelay",

            fieldType: "Double",
        },
    ]
});
export interface DatagramWriterGroupTransportDataTypeOptions extends WriterGroupTransportDataTypeOptions {
    messageRepeatCount?: Byte ;
    messageRepeatDelay?: Double ;
}
export class DatagramWriterGroupTransportDataType extends WriterGroupTransportDataType {
    public static get schema(): IStructuredTypeSchema { return schemaDatagramWriterGroupTransportDataType; }
    public static possibleFields: string[] = [
          "messageRepeatCount",
           "messageRepeatDelay"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15532, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(21155, 0);
    public static encodingDefaultXml = makeExpandedNodeId(21179, 0);
    public static encodingDefaultJson = makeExpandedNodeId(21203, 0);
    public messageRepeatCount: Byte;
    public messageRepeatDelay: Double;

    constructor(options?: DatagramWriterGroupTransportDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.messageRepeatCount = 0;
            this.messageRepeatDelay = 0;
              return;
        }
        const schema = DatagramWriterGroupTransportDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DatagramWriterGroupTransportDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.messageRepeatCount = initialize_field(schema.fields[0], options?.messageRepeatCount);
        this.messageRepeatDelay = initialize_field(schema.fields[1], options?.messageRepeatDelay);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeByte(this.messageRepeatCount, stream);
        encodeDouble(this.messageRepeatDelay, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.messageRepeatCount = decodeByte(stream, this.messageRepeatCount);
        this.messageRepeatDelay = decodeDouble(stream, this.messageRepeatDelay);
    }
    public get schema(): IStructuredTypeSchema { return schemaDatagramWriterGroupTransportDataType; }
}
DatagramWriterGroupTransportDataType.schema.dataTypeNodeId = DatagramWriterGroupTransportDataType.dataTypeNodeId;
DatagramWriterGroupTransportDataType.schema.encodingDefaultBinary = DatagramWriterGroupTransportDataType.encodingDefaultBinary;
DatagramWriterGroupTransportDataType.schema.encodingDefaultXml = DatagramWriterGroupTransportDataType.encodingDefaultXml;
DatagramWriterGroupTransportDataType.schema.encodingDefaultJson = DatagramWriterGroupTransportDataType.encodingDefaultJson;
registerClassDefinition( DatagramWriterGroupTransportDataType.dataTypeNodeId, "DatagramWriterGroupTransportDataType", DatagramWriterGroupTransportDataType);
// --------------------------------------------------------------------------------------------
const schemaDatagramWriterGroupTransport2DataType = buildStructuredType({
    name: "DatagramWriterGroupTransport2DataType",

    baseType: "DatagramWriterGroupTransportDataType",
    fields: [
        {
            name: "Address",

            fieldType: "ExtensionObject",
        },
        {
            name: "QosCategory",

            fieldType: "String",
        },
        {
            name: "DatagramQos",

            fieldType: "ExtensionObject",
            isArray: true
        },
        {
            name: "DiscoveryAnnounceRate",

            fieldType: "UInt32",
        },
        {
            name: "Topic",

            fieldType: "String",
        },
    ]
});
export interface DatagramWriterGroupTransport2DataTypeOptions extends DatagramWriterGroupTransportDataTypeOptions {
    address?: (ExtensionObject | null);
    qosCategory?: UAString ;
    datagramQos?: (ExtensionObject | null)[] | null;
    discoveryAnnounceRate?: UInt32 ;
    topic?: UAString ;
}
export class DatagramWriterGroupTransport2DataType extends DatagramWriterGroupTransportDataType {
    public static get schema(): IStructuredTypeSchema { return schemaDatagramWriterGroupTransport2DataType; }
    public static possibleFields: string[] = [
          "messageRepeatCount",
           "messageRepeatDelay",
           "address",
           "qosCategory",
           "datagramQos",
           "discoveryAnnounceRate",
           "topic"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(23613, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(23865, 0);
    public static encodingDefaultXml = makeExpandedNodeId(23933, 0);
    public static encodingDefaultJson = makeExpandedNodeId(24001, 0);
    public address: (ExtensionObject | null);
    public qosCategory: UAString;
    public datagramQos: (ExtensionObject | null)[] | null;
    public discoveryAnnounceRate: UInt32;
    public topic: UAString;

    constructor(options?: DatagramWriterGroupTransport2DataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.address = null;
            this.qosCategory = null;
            this.datagramQos = []
            this.discoveryAnnounceRate = 0;
            this.topic = null;
              return;
        }
        const schema = DatagramWriterGroupTransport2DataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DatagramWriterGroupTransport2DataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.address = initialize_field(schema.fields[0], options?.address);
        this.qosCategory = initialize_field(schema.fields[1], options?.qosCategory);
        this.datagramQos = initialize_field_array(schema.fields[2], options?.datagramQos);
        this.discoveryAnnounceRate = initialize_field(schema.fields[3], options?.discoveryAnnounceRate);
        this.topic = initialize_field(schema.fields[4], options?.topic);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeExtensionObject(this.address, stream);
        encodeString(this.qosCategory, stream);
        encodeArray(this.datagramQos, stream, encodeExtensionObject);
        encodeUInt32(this.discoveryAnnounceRate, stream);
        encodeString(this.topic, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.address = decodeExtensionObject(stream, this.address);
        this.qosCategory = decodeString(stream, this.qosCategory);
        this.datagramQos = decodeArray(stream, decodeExtensionObject);
        this.discoveryAnnounceRate = decodeUInt32(stream, this.discoveryAnnounceRate);
        this.topic = decodeString(stream, this.topic);
    }
    public get schema(): IStructuredTypeSchema { return schemaDatagramWriterGroupTransport2DataType; }
}
DatagramWriterGroupTransport2DataType.schema.dataTypeNodeId = DatagramWriterGroupTransport2DataType.dataTypeNodeId;
DatagramWriterGroupTransport2DataType.schema.encodingDefaultBinary = DatagramWriterGroupTransport2DataType.encodingDefaultBinary;
DatagramWriterGroupTransport2DataType.schema.encodingDefaultXml = DatagramWriterGroupTransport2DataType.encodingDefaultXml;
DatagramWriterGroupTransport2DataType.schema.encodingDefaultJson = DatagramWriterGroupTransport2DataType.encodingDefaultJson;
registerClassDefinition( DatagramWriterGroupTransport2DataType.dataTypeNodeId, "DatagramWriterGroupTransport2DataType", DatagramWriterGroupTransport2DataType);
// --------------------------------------------------------------------------------------------
const schemaHistoryUpdateDetails = buildStructuredType({
    name: "HistoryUpdateDetails",

    baseType: "ExtensionObject",
    fields: [
    ]
});
export interface HistoryUpdateDetailsOptions {
}
export class HistoryUpdateDetails extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaHistoryUpdateDetails; }
    public static possibleFields: string[] = [
          
    ];
    public static dataTypeNodeId = makeExpandedNodeId(677, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(679, 0);
    public static encodingDefaultXml = makeExpandedNodeId(678, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15279, 0);

    constructor(options?: HistoryUpdateDetailsOptions | null) {

        super(options);

        if (options === null) {
              return;
        }
        const schema = HistoryUpdateDetails.schema;
        options = (schema.constructHook ? schema.constructHook(options) as HistoryUpdateDetailsOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaHistoryUpdateDetails; }
}
HistoryUpdateDetails.schema.dataTypeNodeId = HistoryUpdateDetails.dataTypeNodeId;
HistoryUpdateDetails.schema.encodingDefaultBinary = HistoryUpdateDetails.encodingDefaultBinary;
HistoryUpdateDetails.schema.encodingDefaultXml = HistoryUpdateDetails.encodingDefaultXml;
HistoryUpdateDetails.schema.encodingDefaultJson = HistoryUpdateDetails.encodingDefaultJson;
registerClassDefinition( HistoryUpdateDetails.dataTypeNodeId, "HistoryUpdateDetails", HistoryUpdateDetails);
// --------------------------------------------------------------------------------------------
const schemaDeleteAtTimeDetails = buildStructuredType({
    name: "DeleteAtTimeDetails",

    baseType: "HistoryUpdateDetails",
    fields: [
        {
            name: "NodeId",

            fieldType: "NodeId",
        },
        {
            name: "ReqTimes",

            fieldType: "DateTime",
            isArray: true
        },
    ]
});
export interface DeleteAtTimeDetailsOptions extends HistoryUpdateDetailsOptions {
    nodeId?: (NodeIdLike | null);
    reqTimes?: DateTime [] | null;
}
export class DeleteAtTimeDetails extends HistoryUpdateDetails {
    public static get schema(): IStructuredTypeSchema { return schemaDeleteAtTimeDetails; }
    public static possibleFields: string[] = [
          "nodeId",
           "reqTimes"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(689, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(691, 0);
    public static encodingDefaultXml = makeExpandedNodeId(690, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15284, 0);
    public nodeId: NodeId;
    public reqTimes: DateTime[] | null;

    constructor(options?: DeleteAtTimeDetailsOptions | null) {

        super(options);

        if (options === null) {
            this.nodeId = new NodeId(null);
            this.reqTimes = []
              return;
        }
        const schema = DeleteAtTimeDetails.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DeleteAtTimeDetailsOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.nodeId = initialize_field(schema.fields[0], options?.nodeId);
        this.reqTimes = initialize_field_array(schema.fields[1], options?.reqTimes);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.nodeId, stream);
        encodeArray(this.reqTimes, stream, encodeDateTime);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.nodeId = decodeNodeId(stream, this.nodeId);
        this.reqTimes = decodeArray(stream, decodeDateTime);
    }
    public get schema(): IStructuredTypeSchema { return schemaDeleteAtTimeDetails; }
}
DeleteAtTimeDetails.schema.dataTypeNodeId = DeleteAtTimeDetails.dataTypeNodeId;
DeleteAtTimeDetails.schema.encodingDefaultBinary = DeleteAtTimeDetails.encodingDefaultBinary;
DeleteAtTimeDetails.schema.encodingDefaultXml = DeleteAtTimeDetails.encodingDefaultXml;
DeleteAtTimeDetails.schema.encodingDefaultJson = DeleteAtTimeDetails.encodingDefaultJson;
registerClassDefinition( DeleteAtTimeDetails.dataTypeNodeId, "DeleteAtTimeDetails", DeleteAtTimeDetails);
// --------------------------------------------------------------------------------------------
const schemaDeleteEventDetails = buildStructuredType({
    name: "DeleteEventDetails",

    baseType: "HistoryUpdateDetails",
    fields: [
        {
            name: "NodeId",

            fieldType: "NodeId",
        },
        {
            name: "EventIds",

            fieldType: "ByteString",
            isArray: true
        },
    ]
});
export interface DeleteEventDetailsOptions extends HistoryUpdateDetailsOptions {
    nodeId?: (NodeIdLike | null);
    eventIds?: ByteString [] | null;
}
export class DeleteEventDetails extends HistoryUpdateDetails {
    public static get schema(): IStructuredTypeSchema { return schemaDeleteEventDetails; }
    public static possibleFields: string[] = [
          "nodeId",
           "eventIds"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(692, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(694, 0);
    public static encodingDefaultXml = makeExpandedNodeId(693, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15285, 0);
    public nodeId: NodeId;
    public eventIds: ByteString[] | null;

    constructor(options?: DeleteEventDetailsOptions | null) {

        super(options);

        if (options === null) {
            this.nodeId = new NodeId(null);
            this.eventIds = []
              return;
        }
        const schema = DeleteEventDetails.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DeleteEventDetailsOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.nodeId = initialize_field(schema.fields[0], options?.nodeId);
        this.eventIds = initialize_field_array(schema.fields[1], options?.eventIds);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.nodeId, stream);
        encodeArray(this.eventIds, stream, encodeByteString);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.nodeId = decodeNodeId(stream, this.nodeId);
        this.eventIds = decodeArray(stream, decodeByteString);
    }
    public get schema(): IStructuredTypeSchema { return schemaDeleteEventDetails; }
}
DeleteEventDetails.schema.dataTypeNodeId = DeleteEventDetails.dataTypeNodeId;
DeleteEventDetails.schema.encodingDefaultBinary = DeleteEventDetails.encodingDefaultBinary;
DeleteEventDetails.schema.encodingDefaultXml = DeleteEventDetails.encodingDefaultXml;
DeleteEventDetails.schema.encodingDefaultJson = DeleteEventDetails.encodingDefaultJson;
registerClassDefinition( DeleteEventDetails.dataTypeNodeId, "DeleteEventDetails", DeleteEventDetails);
// --------------------------------------------------------------------------------------------
const schemaDeleteMonitoredItemsRequest = buildStructuredType({
    name: "DeleteMonitoredItemsRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
        {
            name: "SubscriptionId",

            fieldType: "UInt32",
        },
        {
            name: "MonitoredItemIds",

            fieldType: "UInt32",
            isArray: true
        },
    ]
});
export interface DeleteMonitoredItemsRequestOptions {
    requestHeader?: RequestHeaderOptions ;
    subscriptionId?: UInt32 ;
    monitoredItemIds?: UInt32 [] | null;
}
export class DeleteMonitoredItemsRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaDeleteMonitoredItemsRequest; }
    public static possibleFields: string[] = [
          "requestHeader",
           "subscriptionId",
           "monitoredItemIds"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(779, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(781, 0);
    public static encodingDefaultXml = makeExpandedNodeId(780, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15335, 0);
    public requestHeader: RequestHeader;
    public subscriptionId: UInt32;
    public monitoredItemIds: UInt32[] | null;

    constructor(options?: DeleteMonitoredItemsRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
            this.subscriptionId = 0;
            this.monitoredItemIds = []
              return;
        }
        const schema = DeleteMonitoredItemsRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DeleteMonitoredItemsRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
        this.subscriptionId = initialize_field(schema.fields[1], options?.subscriptionId);
        this.monitoredItemIds = initialize_field_array(schema.fields[2], options?.monitoredItemIds);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        encodeUInt32(this.subscriptionId, stream);
        encodeArray(this.monitoredItemIds, stream, encodeUInt32);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.subscriptionId = decodeUInt32(stream, this.subscriptionId);
        this.monitoredItemIds = decodeArray(stream, decodeUInt32);
    }
    public get schema(): IStructuredTypeSchema { return schemaDeleteMonitoredItemsRequest; }
}
DeleteMonitoredItemsRequest.schema.dataTypeNodeId = DeleteMonitoredItemsRequest.dataTypeNodeId;
DeleteMonitoredItemsRequest.schema.encodingDefaultBinary = DeleteMonitoredItemsRequest.encodingDefaultBinary;
DeleteMonitoredItemsRequest.schema.encodingDefaultXml = DeleteMonitoredItemsRequest.encodingDefaultXml;
DeleteMonitoredItemsRequest.schema.encodingDefaultJson = DeleteMonitoredItemsRequest.encodingDefaultJson;
registerClassDefinition( DeleteMonitoredItemsRequest.dataTypeNodeId, "DeleteMonitoredItemsRequest", DeleteMonitoredItemsRequest);
// --------------------------------------------------------------------------------------------
const schemaDeleteMonitoredItemsResponse = buildStructuredType({
    name: "DeleteMonitoredItemsResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
        {
            name: "Results",

            fieldType: "StatusCode",
            isArray: true
        },
        {
            name: "DiagnosticInfos",

            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
export interface DeleteMonitoredItemsResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
    results?: StatusCode [] | null;
    diagnosticInfos?: (DiagnosticInfo | null)[] | null;
}
export class DeleteMonitoredItemsResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaDeleteMonitoredItemsResponse; }
    public static possibleFields: string[] = [
          "responseHeader",
           "results",
           "diagnosticInfos"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(782, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(784, 0);
    public static encodingDefaultXml = makeExpandedNodeId(783, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15336, 0);
    public responseHeader: ResponseHeader;
    public results: StatusCode[] | null;
    public diagnosticInfos: (DiagnosticInfo | null)[] | null;

    constructor(options?: DeleteMonitoredItemsResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
            this.results = []
            this.diagnosticInfos = []
              return;
        }
        const schema = DeleteMonitoredItemsResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DeleteMonitoredItemsResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
        this.results = initialize_field_array(schema.fields[1], options?.results);
        this.diagnosticInfos = initialize_field_array(schema.fields[2], options?.diagnosticInfos);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        encodeArray(this.results, stream, encodeStatusCode);
        encodeArray(this.diagnosticInfos, stream, encodeDiagnosticInfo);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = decodeArray(stream, decodeStatusCode);
        this.diagnosticInfos = decodeArray(stream, decodeDiagnosticInfo);
    }
    public get schema(): IStructuredTypeSchema { return schemaDeleteMonitoredItemsResponse; }
}
DeleteMonitoredItemsResponse.schema.dataTypeNodeId = DeleteMonitoredItemsResponse.dataTypeNodeId;
DeleteMonitoredItemsResponse.schema.encodingDefaultBinary = DeleteMonitoredItemsResponse.encodingDefaultBinary;
DeleteMonitoredItemsResponse.schema.encodingDefaultXml = DeleteMonitoredItemsResponse.encodingDefaultXml;
DeleteMonitoredItemsResponse.schema.encodingDefaultJson = DeleteMonitoredItemsResponse.encodingDefaultJson;
registerClassDefinition( DeleteMonitoredItemsResponse.dataTypeNodeId, "DeleteMonitoredItemsResponse", DeleteMonitoredItemsResponse);
// --------------------------------------------------------------------------------------------
const schemaDeleteNodesItem = buildStructuredType({
    name: "DeleteNodesItem",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "NodeId",

            fieldType: "NodeId",
        },
        {
            name: "DeleteTargetReferences",

            fieldType: "Boolean",
        },
    ]
});
export interface DeleteNodesItemOptions {
    nodeId?: (NodeIdLike | null);
    deleteTargetReferences?: UABoolean ;
}
export class DeleteNodesItem extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaDeleteNodesItem; }
    public static possibleFields: string[] = [
          "nodeId",
           "deleteTargetReferences"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(382, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(384, 0);
    public static encodingDefaultXml = makeExpandedNodeId(383, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15172, 0);
    public nodeId: NodeId;
    public deleteTargetReferences: UABoolean;

    constructor(options?: DeleteNodesItemOptions | null) {

        super(options);

        if (options === null) {
            this.nodeId = new NodeId(null);
            this.deleteTargetReferences = false;
              return;
        }
        const schema = DeleteNodesItem.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DeleteNodesItemOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.nodeId = initialize_field(schema.fields[0], options?.nodeId);
        this.deleteTargetReferences = initialize_field(schema.fields[1], options?.deleteTargetReferences);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.nodeId, stream);
        encodeBoolean(this.deleteTargetReferences, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.nodeId = decodeNodeId(stream, this.nodeId);
        this.deleteTargetReferences = decodeBoolean(stream, this.deleteTargetReferences);
    }
    public get schema(): IStructuredTypeSchema { return schemaDeleteNodesItem; }
}
DeleteNodesItem.schema.dataTypeNodeId = DeleteNodesItem.dataTypeNodeId;
DeleteNodesItem.schema.encodingDefaultBinary = DeleteNodesItem.encodingDefaultBinary;
DeleteNodesItem.schema.encodingDefaultXml = DeleteNodesItem.encodingDefaultXml;
DeleteNodesItem.schema.encodingDefaultJson = DeleteNodesItem.encodingDefaultJson;
registerClassDefinition( DeleteNodesItem.dataTypeNodeId, "DeleteNodesItem", DeleteNodesItem);
// --------------------------------------------------------------------------------------------
const schemaDeleteNodesRequest = buildStructuredType({
    name: "DeleteNodesRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
        {
            name: "NodesToDelete",

            fieldType: "DeleteNodesItem",
            isArray: true
        },
    ]
});
export interface DeleteNodesRequestOptions {
    requestHeader?: RequestHeaderOptions ;
    nodesToDelete?: DeleteNodesItemOptions [] | null;
}
export class DeleteNodesRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaDeleteNodesRequest; }
    public static possibleFields: string[] = [
          "requestHeader",
           "nodesToDelete"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(498, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(500, 0);
    public static encodingDefaultXml = makeExpandedNodeId(499, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15173, 0);
    public requestHeader: RequestHeader;
    public nodesToDelete: DeleteNodesItem[] | null;

    constructor(options?: DeleteNodesRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
         this.nodesToDelete =  null; /* null array */
              return;
        }
        const schema = DeleteNodesRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DeleteNodesRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
        this.nodesToDelete = []; // should default
        if (options.nodesToDelete) {
            assert(Array.isArray(options.nodesToDelete));
            this.nodesToDelete = options.nodesToDelete.map((e: any) => new DeleteNodesItem(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        encodeArray(this.nodesToDelete, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.nodesToDelete = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new DeleteNodesItem(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaDeleteNodesRequest; }
}
DeleteNodesRequest.schema.dataTypeNodeId = DeleteNodesRequest.dataTypeNodeId;
DeleteNodesRequest.schema.encodingDefaultBinary = DeleteNodesRequest.encodingDefaultBinary;
DeleteNodesRequest.schema.encodingDefaultXml = DeleteNodesRequest.encodingDefaultXml;
DeleteNodesRequest.schema.encodingDefaultJson = DeleteNodesRequest.encodingDefaultJson;
registerClassDefinition( DeleteNodesRequest.dataTypeNodeId, "DeleteNodesRequest", DeleteNodesRequest);
// --------------------------------------------------------------------------------------------
const schemaDeleteNodesResponse = buildStructuredType({
    name: "DeleteNodesResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
        {
            name: "Results",

            fieldType: "StatusCode",
            isArray: true
        },
        {
            name: "DiagnosticInfos",

            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
export interface DeleteNodesResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
    results?: StatusCode [] | null;
    diagnosticInfos?: (DiagnosticInfo | null)[] | null;
}
export class DeleteNodesResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaDeleteNodesResponse; }
    public static possibleFields: string[] = [
          "responseHeader",
           "results",
           "diagnosticInfos"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(501, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(503, 0);
    public static encodingDefaultXml = makeExpandedNodeId(502, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15174, 0);
    public responseHeader: ResponseHeader;
    public results: StatusCode[] | null;
    public diagnosticInfos: (DiagnosticInfo | null)[] | null;

    constructor(options?: DeleteNodesResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
            this.results = []
            this.diagnosticInfos = []
              return;
        }
        const schema = DeleteNodesResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DeleteNodesResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
        this.results = initialize_field_array(schema.fields[1], options?.results);
        this.diagnosticInfos = initialize_field_array(schema.fields[2], options?.diagnosticInfos);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        encodeArray(this.results, stream, encodeStatusCode);
        encodeArray(this.diagnosticInfos, stream, encodeDiagnosticInfo);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = decodeArray(stream, decodeStatusCode);
        this.diagnosticInfos = decodeArray(stream, decodeDiagnosticInfo);
    }
    public get schema(): IStructuredTypeSchema { return schemaDeleteNodesResponse; }
}
DeleteNodesResponse.schema.dataTypeNodeId = DeleteNodesResponse.dataTypeNodeId;
DeleteNodesResponse.schema.encodingDefaultBinary = DeleteNodesResponse.encodingDefaultBinary;
DeleteNodesResponse.schema.encodingDefaultXml = DeleteNodesResponse.encodingDefaultXml;
DeleteNodesResponse.schema.encodingDefaultJson = DeleteNodesResponse.encodingDefaultJson;
registerClassDefinition( DeleteNodesResponse.dataTypeNodeId, "DeleteNodesResponse", DeleteNodesResponse);
// --------------------------------------------------------------------------------------------
const schemaDeleteRawModifiedDetails = buildStructuredType({
    name: "DeleteRawModifiedDetails",

    baseType: "HistoryUpdateDetails",
    fields: [
        {
            name: "NodeId",

            fieldType: "NodeId",
        },
        {
            name: "IsDeleteModified",

            fieldType: "Boolean",
        },
        {
            name: "StartTime",

            fieldType: "DateTime",
        },
        {
            name: "EndTime",

            fieldType: "DateTime",
        },
    ]
});
export interface DeleteRawModifiedDetailsOptions extends HistoryUpdateDetailsOptions {
    nodeId?: (NodeIdLike | null);
    isDeleteModified?: UABoolean ;
    startTime?: DateTime ;
    endTime?: DateTime ;
}
export class DeleteRawModifiedDetails extends HistoryUpdateDetails {
    public static get schema(): IStructuredTypeSchema { return schemaDeleteRawModifiedDetails; }
    public static possibleFields: string[] = [
          "nodeId",
           "isDeleteModified",
           "startTime",
           "endTime"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(686, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(688, 0);
    public static encodingDefaultXml = makeExpandedNodeId(687, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15283, 0);
    public nodeId: NodeId;
    public isDeleteModified: UABoolean;
    public startTime: DateTime;
    public endTime: DateTime;

    constructor(options?: DeleteRawModifiedDetailsOptions | null) {

        super(options);

        if (options === null) {
            this.nodeId = new NodeId(null);
            this.isDeleteModified = false;
            this.startTime = new Date();
            this.endTime = new Date();
              return;
        }
        const schema = DeleteRawModifiedDetails.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DeleteRawModifiedDetailsOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.nodeId = initialize_field(schema.fields[0], options?.nodeId);
        this.isDeleteModified = initialize_field(schema.fields[1], options?.isDeleteModified);
        this.startTime = initialize_field(schema.fields[2], options?.startTime);
        this.endTime = initialize_field(schema.fields[3], options?.endTime);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.nodeId, stream);
        encodeBoolean(this.isDeleteModified, stream);
        encodeDateTime(this.startTime, stream);
        encodeDateTime(this.endTime, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.nodeId = decodeNodeId(stream, this.nodeId);
        this.isDeleteModified = decodeBoolean(stream, this.isDeleteModified);
        this.startTime = decodeDateTime(stream, this.startTime);
        this.endTime = decodeDateTime(stream, this.endTime);
    }
    public get schema(): IStructuredTypeSchema { return schemaDeleteRawModifiedDetails; }
}
DeleteRawModifiedDetails.schema.dataTypeNodeId = DeleteRawModifiedDetails.dataTypeNodeId;
DeleteRawModifiedDetails.schema.encodingDefaultBinary = DeleteRawModifiedDetails.encodingDefaultBinary;
DeleteRawModifiedDetails.schema.encodingDefaultXml = DeleteRawModifiedDetails.encodingDefaultXml;
DeleteRawModifiedDetails.schema.encodingDefaultJson = DeleteRawModifiedDetails.encodingDefaultJson;
registerClassDefinition( DeleteRawModifiedDetails.dataTypeNodeId, "DeleteRawModifiedDetails", DeleteRawModifiedDetails);
// --------------------------------------------------------------------------------------------
const schemaDeleteReferencesItem = buildStructuredType({
    name: "DeleteReferencesItem",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "SourceNodeId",

            fieldType: "NodeId",
        },
        {
            name: "ReferenceTypeId",

            fieldType: "NodeId",
        },
        {
            name: "IsForward",

            fieldType: "Boolean",
        },
        {
            name: "TargetNodeId",

            fieldType: "ExpandedNodeId",
        },
        {
            name: "DeleteBidirectional",

            fieldType: "Boolean",
        },
    ]
});
export interface DeleteReferencesItemOptions {
    sourceNodeId?: (NodeIdLike | null);
    referenceTypeId?: (NodeIdLike | null);
    isForward?: UABoolean ;
    targetNodeId?: ExpandedNodeId ;
    deleteBidirectional?: UABoolean ;
}
export class DeleteReferencesItem extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaDeleteReferencesItem; }
    public static possibleFields: string[] = [
          "sourceNodeId",
           "referenceTypeId",
           "isForward",
           "targetNodeId",
           "deleteBidirectional"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(385, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(387, 0);
    public static encodingDefaultXml = makeExpandedNodeId(386, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15175, 0);
    public sourceNodeId: NodeId;
    public referenceTypeId: NodeId;
    public isForward: UABoolean;
    public targetNodeId: ExpandedNodeId;
    public deleteBidirectional: UABoolean;

    constructor(options?: DeleteReferencesItemOptions | null) {

        super(options);

        if (options === null) {
            this.sourceNodeId = new NodeId(null);
            this.referenceTypeId = new NodeId(null);
            this.isForward = false;
            this.targetNodeId = new ExpandedNodeId(null);
            this.deleteBidirectional = false;
              return;
        }
        const schema = DeleteReferencesItem.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DeleteReferencesItemOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.sourceNodeId = initialize_field(schema.fields[0], options?.sourceNodeId);
        this.referenceTypeId = initialize_field(schema.fields[1], options?.referenceTypeId);
        this.isForward = initialize_field(schema.fields[2], options?.isForward);
        this.targetNodeId = initialize_field(schema.fields[3], options?.targetNodeId);
        this.deleteBidirectional = initialize_field(schema.fields[4], options?.deleteBidirectional);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.sourceNodeId, stream);
        encodeNodeId(this.referenceTypeId, stream);
        encodeBoolean(this.isForward, stream);
        encodeExpandedNodeId(this.targetNodeId, stream);
        encodeBoolean(this.deleteBidirectional, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.sourceNodeId = decodeNodeId(stream, this.sourceNodeId);
        this.referenceTypeId = decodeNodeId(stream, this.referenceTypeId);
        this.isForward = decodeBoolean(stream, this.isForward);
        this.targetNodeId = decodeExpandedNodeId(stream, this.targetNodeId);
        this.deleteBidirectional = decodeBoolean(stream, this.deleteBidirectional);
    }
    public get schema(): IStructuredTypeSchema { return schemaDeleteReferencesItem; }
}
DeleteReferencesItem.schema.dataTypeNodeId = DeleteReferencesItem.dataTypeNodeId;
DeleteReferencesItem.schema.encodingDefaultBinary = DeleteReferencesItem.encodingDefaultBinary;
DeleteReferencesItem.schema.encodingDefaultXml = DeleteReferencesItem.encodingDefaultXml;
DeleteReferencesItem.schema.encodingDefaultJson = DeleteReferencesItem.encodingDefaultJson;
registerClassDefinition( DeleteReferencesItem.dataTypeNodeId, "DeleteReferencesItem", DeleteReferencesItem);
// --------------------------------------------------------------------------------------------
const schemaDeleteReferencesRequest = buildStructuredType({
    name: "DeleteReferencesRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
        {
            name: "ReferencesToDelete",

            fieldType: "DeleteReferencesItem",
            isArray: true
        },
    ]
});
export interface DeleteReferencesRequestOptions {
    requestHeader?: RequestHeaderOptions ;
    referencesToDelete?: DeleteReferencesItemOptions [] | null;
}
export class DeleteReferencesRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaDeleteReferencesRequest; }
    public static possibleFields: string[] = [
          "requestHeader",
           "referencesToDelete"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(504, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(506, 0);
    public static encodingDefaultXml = makeExpandedNodeId(505, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15176, 0);
    public requestHeader: RequestHeader;
    public referencesToDelete: DeleteReferencesItem[] | null;

    constructor(options?: DeleteReferencesRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
         this.referencesToDelete =  null; /* null array */
              return;
        }
        const schema = DeleteReferencesRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DeleteReferencesRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
        this.referencesToDelete = []; // should default
        if (options.referencesToDelete) {
            assert(Array.isArray(options.referencesToDelete));
            this.referencesToDelete = options.referencesToDelete.map((e: any) => new DeleteReferencesItem(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        encodeArray(this.referencesToDelete, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.referencesToDelete = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new DeleteReferencesItem(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaDeleteReferencesRequest; }
}
DeleteReferencesRequest.schema.dataTypeNodeId = DeleteReferencesRequest.dataTypeNodeId;
DeleteReferencesRequest.schema.encodingDefaultBinary = DeleteReferencesRequest.encodingDefaultBinary;
DeleteReferencesRequest.schema.encodingDefaultXml = DeleteReferencesRequest.encodingDefaultXml;
DeleteReferencesRequest.schema.encodingDefaultJson = DeleteReferencesRequest.encodingDefaultJson;
registerClassDefinition( DeleteReferencesRequest.dataTypeNodeId, "DeleteReferencesRequest", DeleteReferencesRequest);
// --------------------------------------------------------------------------------------------
const schemaDeleteReferencesResponse = buildStructuredType({
    name: "DeleteReferencesResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
        {
            name: "Results",

            fieldType: "StatusCode",
            isArray: true
        },
        {
            name: "DiagnosticInfos",

            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
export interface DeleteReferencesResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
    results?: StatusCode [] | null;
    diagnosticInfos?: (DiagnosticInfo | null)[] | null;
}
export class DeleteReferencesResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaDeleteReferencesResponse; }
    public static possibleFields: string[] = [
          "responseHeader",
           "results",
           "diagnosticInfos"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(507, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(509, 0);
    public static encodingDefaultXml = makeExpandedNodeId(508, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15177, 0);
    public responseHeader: ResponseHeader;
    public results: StatusCode[] | null;
    public diagnosticInfos: (DiagnosticInfo | null)[] | null;

    constructor(options?: DeleteReferencesResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
            this.results = []
            this.diagnosticInfos = []
              return;
        }
        const schema = DeleteReferencesResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DeleteReferencesResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
        this.results = initialize_field_array(schema.fields[1], options?.results);
        this.diagnosticInfos = initialize_field_array(schema.fields[2], options?.diagnosticInfos);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        encodeArray(this.results, stream, encodeStatusCode);
        encodeArray(this.diagnosticInfos, stream, encodeDiagnosticInfo);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = decodeArray(stream, decodeStatusCode);
        this.diagnosticInfos = decodeArray(stream, decodeDiagnosticInfo);
    }
    public get schema(): IStructuredTypeSchema { return schemaDeleteReferencesResponse; }
}
DeleteReferencesResponse.schema.dataTypeNodeId = DeleteReferencesResponse.dataTypeNodeId;
DeleteReferencesResponse.schema.encodingDefaultBinary = DeleteReferencesResponse.encodingDefaultBinary;
DeleteReferencesResponse.schema.encodingDefaultXml = DeleteReferencesResponse.encodingDefaultXml;
DeleteReferencesResponse.schema.encodingDefaultJson = DeleteReferencesResponse.encodingDefaultJson;
registerClassDefinition( DeleteReferencesResponse.dataTypeNodeId, "DeleteReferencesResponse", DeleteReferencesResponse);
// --------------------------------------------------------------------------------------------
const schemaDeleteSubscriptionsRequest = buildStructuredType({
    name: "DeleteSubscriptionsRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
        {
            name: "SubscriptionIds",

            fieldType: "UInt32",
            isArray: true
        },
    ]
});
export interface DeleteSubscriptionsRequestOptions {
    requestHeader?: RequestHeaderOptions ;
    subscriptionIds?: UInt32 [] | null;
}
export class DeleteSubscriptionsRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaDeleteSubscriptionsRequest; }
    public static possibleFields: string[] = [
          "requestHeader",
           "subscriptionIds"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(845, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(847, 0);
    public static encodingDefaultXml = makeExpandedNodeId(846, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15359, 0);
    public requestHeader: RequestHeader;
    public subscriptionIds: UInt32[] | null;

    constructor(options?: DeleteSubscriptionsRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
            this.subscriptionIds = []
              return;
        }
        const schema = DeleteSubscriptionsRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DeleteSubscriptionsRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
        this.subscriptionIds = initialize_field_array(schema.fields[1], options?.subscriptionIds);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        encodeArray(this.subscriptionIds, stream, encodeUInt32);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.subscriptionIds = decodeArray(stream, decodeUInt32);
    }
    public get schema(): IStructuredTypeSchema { return schemaDeleteSubscriptionsRequest; }
}
DeleteSubscriptionsRequest.schema.dataTypeNodeId = DeleteSubscriptionsRequest.dataTypeNodeId;
DeleteSubscriptionsRequest.schema.encodingDefaultBinary = DeleteSubscriptionsRequest.encodingDefaultBinary;
DeleteSubscriptionsRequest.schema.encodingDefaultXml = DeleteSubscriptionsRequest.encodingDefaultXml;
DeleteSubscriptionsRequest.schema.encodingDefaultJson = DeleteSubscriptionsRequest.encodingDefaultJson;
registerClassDefinition( DeleteSubscriptionsRequest.dataTypeNodeId, "DeleteSubscriptionsRequest", DeleteSubscriptionsRequest);
// --------------------------------------------------------------------------------------------
const schemaDeleteSubscriptionsResponse = buildStructuredType({
    name: "DeleteSubscriptionsResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
        {
            name: "Results",

            fieldType: "StatusCode",
            isArray: true
        },
        {
            name: "DiagnosticInfos",

            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
export interface DeleteSubscriptionsResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
    results?: StatusCode [] | null;
    diagnosticInfos?: (DiagnosticInfo | null)[] | null;
}
export class DeleteSubscriptionsResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaDeleteSubscriptionsResponse; }
    public static possibleFields: string[] = [
          "responseHeader",
           "results",
           "diagnosticInfos"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(848, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(850, 0);
    public static encodingDefaultXml = makeExpandedNodeId(849, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15360, 0);
    public responseHeader: ResponseHeader;
    public results: StatusCode[] | null;
    public diagnosticInfos: (DiagnosticInfo | null)[] | null;

    constructor(options?: DeleteSubscriptionsResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
            this.results = []
            this.diagnosticInfos = []
              return;
        }
        const schema = DeleteSubscriptionsResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DeleteSubscriptionsResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
        this.results = initialize_field_array(schema.fields[1], options?.results);
        this.diagnosticInfos = initialize_field_array(schema.fields[2], options?.diagnosticInfos);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        encodeArray(this.results, stream, encodeStatusCode);
        encodeArray(this.diagnosticInfos, stream, encodeDiagnosticInfo);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = decodeArray(stream, decodeStatusCode);
        this.diagnosticInfos = decodeArray(stream, decodeDiagnosticInfo);
    }
    public get schema(): IStructuredTypeSchema { return schemaDeleteSubscriptionsResponse; }
}
DeleteSubscriptionsResponse.schema.dataTypeNodeId = DeleteSubscriptionsResponse.dataTypeNodeId;
DeleteSubscriptionsResponse.schema.encodingDefaultBinary = DeleteSubscriptionsResponse.encodingDefaultBinary;
DeleteSubscriptionsResponse.schema.encodingDefaultXml = DeleteSubscriptionsResponse.encodingDefaultXml;
DeleteSubscriptionsResponse.schema.encodingDefaultJson = DeleteSubscriptionsResponse.encodingDefaultJson;
registerClassDefinition( DeleteSubscriptionsResponse.dataTypeNodeId, "DeleteSubscriptionsResponse", DeleteSubscriptionsResponse);
// --------------------------------------------------------------------------------------------
const schemaDiscoveryConfiguration = buildStructuredType({
    name: "DiscoveryConfiguration",

    baseType: "ExtensionObject",
    fields: [
    ]
});
export interface DiscoveryConfigurationOptions {
}
export class DiscoveryConfiguration extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaDiscoveryConfiguration; }
    public static possibleFields: string[] = [
          
    ];
    public static dataTypeNodeId = makeExpandedNodeId(12890, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(12900, 0);
    public static encodingDefaultXml = makeExpandedNodeId(12892, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15105, 0);

    constructor(options?: DiscoveryConfigurationOptions | null) {

        super(options);

        if (options === null) {
              return;
        }
        const schema = DiscoveryConfiguration.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DiscoveryConfigurationOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaDiscoveryConfiguration; }
}
DiscoveryConfiguration.schema.dataTypeNodeId = DiscoveryConfiguration.dataTypeNodeId;
DiscoveryConfiguration.schema.encodingDefaultBinary = DiscoveryConfiguration.encodingDefaultBinary;
DiscoveryConfiguration.schema.encodingDefaultXml = DiscoveryConfiguration.encodingDefaultXml;
DiscoveryConfiguration.schema.encodingDefaultJson = DiscoveryConfiguration.encodingDefaultJson;
registerClassDefinition( DiscoveryConfiguration.dataTypeNodeId, "DiscoveryConfiguration", DiscoveryConfiguration);
// --------------------------------------------------------------------------------------------
const schemaDoubleComplexNumberType = buildStructuredType({
    name: "DoubleComplexNumberType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Real",

            fieldType: "Double",
        },
        {
            name: "Imaginary",

            fieldType: "Double",
        },
    ]
});
export interface DoubleComplexNumberTypeOptions {
    real?: Double ;
    imaginary?: Double ;
}
export class DoubleComplexNumberType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaDoubleComplexNumberType; }
    public static possibleFields: string[] = [
          "real",
           "imaginary"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(12172, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(12182, 0);
    public static encodingDefaultXml = makeExpandedNodeId(12174, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15378, 0);
    public real: Double;
    public imaginary: Double;

    constructor(options?: DoubleComplexNumberTypeOptions | null) {

        super(options);

        if (options === null) {
            this.real = 0;
            this.imaginary = 0;
              return;
        }
        const schema = DoubleComplexNumberType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DoubleComplexNumberTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.real = initialize_field(schema.fields[0], options?.real);
        this.imaginary = initialize_field(schema.fields[1], options?.imaginary);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeDouble(this.real, stream);
        encodeDouble(this.imaginary, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.real = decodeDouble(stream, this.real);
        this.imaginary = decodeDouble(stream, this.imaginary);
    }
    public get schema(): IStructuredTypeSchema { return schemaDoubleComplexNumberType; }
}
DoubleComplexNumberType.schema.dataTypeNodeId = DoubleComplexNumberType.dataTypeNodeId;
DoubleComplexNumberType.schema.encodingDefaultBinary = DoubleComplexNumberType.encodingDefaultBinary;
DoubleComplexNumberType.schema.encodingDefaultXml = DoubleComplexNumberType.encodingDefaultXml;
DoubleComplexNumberType.schema.encodingDefaultJson = DoubleComplexNumberType.encodingDefaultJson;
registerClassDefinition( DoubleComplexNumberType.dataTypeNodeId, "DoubleComplexNumberType", DoubleComplexNumberType);
// --------------------------------------------------------------------------------------------
const schemaDtlsPubSubConnectionDataType = buildStructuredType({
    name: "DtlsPubSubConnectionDataType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ClientCipherSuite",

            fieldType: "String",
        },
        {
            name: "ServerCipherSuites",

            fieldType: "String",
            isArray: true
        },
        {
            name: "ZeroRTT",

            fieldType: "Boolean",
        },
        {
            name: "CertificateGroupId",

            fieldType: "NodeId",
        },
        {
            name: "VerifyClientCertificate",

            fieldType: "Boolean",
        },
    ]
});
export interface DtlsPubSubConnectionDataTypeOptions {
    clientCipherSuite?: UAString ;
    serverCipherSuites?: UAString [] | null;
    zeroRTT?: UABoolean ;
    certificateGroupId?: (NodeIdLike | null);
    verifyClientCertificate?: UABoolean ;
}
export class DtlsPubSubConnectionDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaDtlsPubSubConnectionDataType; }
    public static possibleFields: string[] = [
          "clientCipherSuite",
           "serverCipherSuites",
           "zeroRTT",
           "certificateGroupId",
           "verifyClientCertificate"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(0, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(0, 0);
    public static encodingDefaultXml = makeExpandedNodeId(0, 0);
    public static encodingDefaultJson = makeExpandedNodeId(0, 0);
    public clientCipherSuite: UAString;
    public serverCipherSuites: UAString[] | null;
    public zeroRTT: UABoolean;
    public certificateGroupId: NodeId;
    public verifyClientCertificate: UABoolean;

    constructor(options?: DtlsPubSubConnectionDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.clientCipherSuite = null;
            this.serverCipherSuites = []
            this.zeroRTT = false;
            this.certificateGroupId = new NodeId(null);
            this.verifyClientCertificate = false;
              return;
        }
        const schema = DtlsPubSubConnectionDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as DtlsPubSubConnectionDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.clientCipherSuite = initialize_field(schema.fields[0], options?.clientCipherSuite);
        this.serverCipherSuites = initialize_field_array(schema.fields[1], options?.serverCipherSuites);
        this.zeroRTT = initialize_field(schema.fields[2], options?.zeroRTT);
        this.certificateGroupId = initialize_field(schema.fields[3], options?.certificateGroupId);
        this.verifyClientCertificate = initialize_field(schema.fields[4], options?.verifyClientCertificate);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.clientCipherSuite, stream);
        encodeArray(this.serverCipherSuites, stream, encodeString);
        encodeBoolean(this.zeroRTT, stream);
        encodeNodeId(this.certificateGroupId, stream);
        encodeBoolean(this.verifyClientCertificate, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.clientCipherSuite = decodeString(stream, this.clientCipherSuite);
        this.serverCipherSuites = decodeArray(stream, decodeString);
        this.zeroRTT = decodeBoolean(stream, this.zeroRTT);
        this.certificateGroupId = decodeNodeId(stream, this.certificateGroupId);
        this.verifyClientCertificate = decodeBoolean(stream, this.verifyClientCertificate);
    }
    public get schema(): IStructuredTypeSchema { return schemaDtlsPubSubConnectionDataType; }
}
DtlsPubSubConnectionDataType.schema.dataTypeNodeId = DtlsPubSubConnectionDataType.dataTypeNodeId;
DtlsPubSubConnectionDataType.schema.encodingDefaultBinary = DtlsPubSubConnectionDataType.encodingDefaultBinary;
DtlsPubSubConnectionDataType.schema.encodingDefaultXml = DtlsPubSubConnectionDataType.encodingDefaultXml;
DtlsPubSubConnectionDataType.schema.encodingDefaultJson = DtlsPubSubConnectionDataType.encodingDefaultJson;
registerClassDefinition( DtlsPubSubConnectionDataType.dataTypeNodeId, "DtlsPubSubConnectionDataType", DtlsPubSubConnectionDataType);
// --------------------------------------------------------------------------------------------
const schemaElementOperand = buildStructuredType({
    name: "ElementOperand",

    baseType: "FilterOperand",
    fields: [
        {
            name: "Index",

            fieldType: "UInt32",
        },
    ]
});
export interface ElementOperandOptions extends FilterOperandOptions {
    index?: UInt32 ;
}
export class ElementOperand extends FilterOperand {
    public static get schema(): IStructuredTypeSchema { return schemaElementOperand; }
    public static possibleFields: string[] = [
          "index"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(592, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(594, 0);
    public static encodingDefaultXml = makeExpandedNodeId(593, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15207, 0);
    public index: UInt32;

    constructor(options?: ElementOperandOptions | null) {

        super(options);

        if (options === null) {
            this.index = 0;
              return;
        }
        const schema = ElementOperand.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ElementOperandOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.index = initialize_field(schema.fields[0], options?.index);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeUInt32(this.index, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.index = decodeUInt32(stream, this.index);
    }
    public get schema(): IStructuredTypeSchema { return schemaElementOperand; }
}
ElementOperand.schema.dataTypeNodeId = ElementOperand.dataTypeNodeId;
ElementOperand.schema.encodingDefaultBinary = ElementOperand.encodingDefaultBinary;
ElementOperand.schema.encodingDefaultXml = ElementOperand.encodingDefaultXml;
ElementOperand.schema.encodingDefaultJson = ElementOperand.encodingDefaultJson;
registerClassDefinition( ElementOperand.dataTypeNodeId, "ElementOperand", ElementOperand);
// --------------------------------------------------------------------------------------------
const schemaEndpointConfiguration = buildStructuredType({
    name: "EndpointConfiguration",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "OperationTimeout",

            fieldType: "Int32",
        },
        {
            name: "UseBinaryEncoding",

            fieldType: "Boolean",
        },
        {
            name: "MaxStringLength",

            fieldType: "Int32",
        },
        {
            name: "MaxByteStringLength",

            fieldType: "Int32",
        },
        {
            name: "MaxArrayLength",

            fieldType: "Int32",
        },
        {
            name: "MaxMessageSize",

            fieldType: "Int32",
        },
        {
            name: "MaxBufferSize",

            fieldType: "Int32",
        },
        {
            name: "ChannelLifetime",

            fieldType: "Int32",
        },
        {
            name: "SecurityTokenLifetime",

            fieldType: "Int32",
        },
    ]
});
export interface EndpointConfigurationOptions {
    operationTimeout?: Int32 ;
    useBinaryEncoding?: UABoolean ;
    maxStringLength?: Int32 ;
    maxByteStringLength?: Int32 ;
    maxArrayLength?: Int32 ;
    maxMessageSize?: Int32 ;
    maxBufferSize?: Int32 ;
    channelLifetime?: Int32 ;
    securityTokenLifetime?: Int32 ;
}
export class EndpointConfiguration extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaEndpointConfiguration; }
    public static possibleFields: string[] = [
          "operationTimeout",
           "useBinaryEncoding",
           "maxStringLength",
           "maxByteStringLength",
           "maxArrayLength",
           "maxMessageSize",
           "maxBufferSize",
           "channelLifetime",
           "securityTokenLifetime"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(331, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(333, 0);
    public static encodingDefaultXml = makeExpandedNodeId(332, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15199, 0);
    public operationTimeout: Int32;
    public useBinaryEncoding: UABoolean;
    public maxStringLength: Int32;
    public maxByteStringLength: Int32;
    public maxArrayLength: Int32;
    public maxMessageSize: Int32;
    public maxBufferSize: Int32;
    public channelLifetime: Int32;
    public securityTokenLifetime: Int32;

    constructor(options?: EndpointConfigurationOptions | null) {

        super(options);

        if (options === null) {
            this.operationTimeout = 0;
            this.useBinaryEncoding = false;
            this.maxStringLength = 0;
            this.maxByteStringLength = 0;
            this.maxArrayLength = 0;
            this.maxMessageSize = 0;
            this.maxBufferSize = 0;
            this.channelLifetime = 0;
            this.securityTokenLifetime = 0;
              return;
        }
        const schema = EndpointConfiguration.schema;
        options = (schema.constructHook ? schema.constructHook(options) as EndpointConfigurationOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.operationTimeout = initialize_field(schema.fields[0], options?.operationTimeout);
        this.useBinaryEncoding = initialize_field(schema.fields[1], options?.useBinaryEncoding);
        this.maxStringLength = initialize_field(schema.fields[2], options?.maxStringLength);
        this.maxByteStringLength = initialize_field(schema.fields[3], options?.maxByteStringLength);
        this.maxArrayLength = initialize_field(schema.fields[4], options?.maxArrayLength);
        this.maxMessageSize = initialize_field(schema.fields[5], options?.maxMessageSize);
        this.maxBufferSize = initialize_field(schema.fields[6], options?.maxBufferSize);
        this.channelLifetime = initialize_field(schema.fields[7], options?.channelLifetime);
        this.securityTokenLifetime = initialize_field(schema.fields[8], options?.securityTokenLifetime);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeInt32(this.operationTimeout, stream);
        encodeBoolean(this.useBinaryEncoding, stream);
        encodeInt32(this.maxStringLength, stream);
        encodeInt32(this.maxByteStringLength, stream);
        encodeInt32(this.maxArrayLength, stream);
        encodeInt32(this.maxMessageSize, stream);
        encodeInt32(this.maxBufferSize, stream);
        encodeInt32(this.channelLifetime, stream);
        encodeInt32(this.securityTokenLifetime, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.operationTimeout = decodeInt32(stream, this.operationTimeout);
        this.useBinaryEncoding = decodeBoolean(stream, this.useBinaryEncoding);
        this.maxStringLength = decodeInt32(stream, this.maxStringLength);
        this.maxByteStringLength = decodeInt32(stream, this.maxByteStringLength);
        this.maxArrayLength = decodeInt32(stream, this.maxArrayLength);
        this.maxMessageSize = decodeInt32(stream, this.maxMessageSize);
        this.maxBufferSize = decodeInt32(stream, this.maxBufferSize);
        this.channelLifetime = decodeInt32(stream, this.channelLifetime);
        this.securityTokenLifetime = decodeInt32(stream, this.securityTokenLifetime);
    }
    public get schema(): IStructuredTypeSchema { return schemaEndpointConfiguration; }
}
EndpointConfiguration.schema.dataTypeNodeId = EndpointConfiguration.dataTypeNodeId;
EndpointConfiguration.schema.encodingDefaultBinary = EndpointConfiguration.encodingDefaultBinary;
EndpointConfiguration.schema.encodingDefaultXml = EndpointConfiguration.encodingDefaultXml;
EndpointConfiguration.schema.encodingDefaultJson = EndpointConfiguration.encodingDefaultJson;
registerClassDefinition( EndpointConfiguration.dataTypeNodeId, "EndpointConfiguration", EndpointConfiguration);
// --------------------------------------------------------------------------------------------
const schemaEndpointType = buildStructuredType({
    name: "EndpointType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "EndpointUrl",

            fieldType: "String",
        },
        {
            name: "SecurityMode",

            fieldType: "MessageSecurityMode",
        },
        {
            name: "SecurityPolicyUri",

            fieldType: "String",
        },
        {
            name: "TransportProfileUri",

            fieldType: "String",
        },
    ]
});
export interface EndpointTypeOptions {
    endpointUrl?: UAString ;
    securityMode?: MessageSecurityMode;
    securityPolicyUri?: UAString ;
    transportProfileUri?: UAString ;
}
export class EndpointType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaEndpointType; }
    public static possibleFields: string[] = [
          "endpointUrl",
           "securityMode",
           "securityPolicyUri",
           "transportProfileUri"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15528, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15671, 0);
    public static encodingDefaultXml = makeExpandedNodeId(15949, 0);
    public static encodingDefaultJson = makeExpandedNodeId(16150, 0);
    public endpointUrl: UAString;
    public securityMode: MessageSecurityMode;
    public securityPolicyUri: UAString;
    public transportProfileUri: UAString;

    constructor(options?: EndpointTypeOptions | null) {

        super(options);

        if (options === null) {
            this.endpointUrl = null;
             this.securityMode =  0 as  MessageSecurityMode;
            this.securityPolicyUri = null;
            this.transportProfileUri = null;
              return;
        }
        const schema = EndpointType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as EndpointTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.endpointUrl = initialize_field(schema.fields[0], options?.endpointUrl);
        this.securityMode = this.setSecurityMode(initialize_field(schema.fields[1], options?.securityMode));
        this.securityPolicyUri = initialize_field(schema.fields[2], options?.securityPolicyUri);
        this.transportProfileUri = initialize_field(schema.fields[3], options?.transportProfileUri);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.endpointUrl, stream);
        encodeMessageSecurityMode(this.securityMode, stream);
        encodeString(this.securityPolicyUri, stream);
        encodeString(this.transportProfileUri, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.endpointUrl = decodeString(stream, this.endpointUrl);
        this.securityMode = decodeMessageSecurityMode(stream, this.securityMode);
        this.securityPolicyUri = decodeString(stream, this.securityPolicyUri);
        this.transportProfileUri = decodeString(stream, this.transportProfileUri);
    }

    // Define Enumeration setters
    public setSecurityMode(value: any): MessageSecurityMode {
        const coercedValue = _enumerationMessageSecurityMode.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to MessageSecurityMode :" + value);
        }
        this.securityMode = coercedValue.value as MessageSecurityMode;
        return this.securityMode;
    }
    public get schema(): IStructuredTypeSchema { return schemaEndpointType; }
}
EndpointType.schema.dataTypeNodeId = EndpointType.dataTypeNodeId;
EndpointType.schema.encodingDefaultBinary = EndpointType.encodingDefaultBinary;
EndpointType.schema.encodingDefaultXml = EndpointType.encodingDefaultXml;
EndpointType.schema.encodingDefaultJson = EndpointType.encodingDefaultJson;
registerClassDefinition( EndpointType.dataTypeNodeId, "EndpointType", EndpointType);
// --------------------------------------------------------------------------------------------
const schemaEndpointUrlListDataType = buildStructuredType({
    name: "EndpointUrlListDataType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "EndpointUrlList",

            fieldType: "String",
            isArray: true
        },
    ]
});
export interface EndpointUrlListDataTypeOptions {
    endpointUrlList?: UAString [] | null;
}
export class EndpointUrlListDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaEndpointUrlListDataType; }
    public static possibleFields: string[] = [
          "endpointUrlList"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(11943, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(11957, 0);
    public static encodingDefaultXml = makeExpandedNodeId(11949, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15363, 0);
    public endpointUrlList: UAString[] | null;

    constructor(options?: EndpointUrlListDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.endpointUrlList = []
              return;
        }
        const schema = EndpointUrlListDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as EndpointUrlListDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.endpointUrlList = initialize_field_array(schema.fields[0], options?.endpointUrlList);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeArray(this.endpointUrlList, stream, encodeString);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.endpointUrlList = decodeArray(stream, decodeString);
    }
    public get schema(): IStructuredTypeSchema { return schemaEndpointUrlListDataType; }
}
EndpointUrlListDataType.schema.dataTypeNodeId = EndpointUrlListDataType.dataTypeNodeId;
EndpointUrlListDataType.schema.encodingDefaultBinary = EndpointUrlListDataType.encodingDefaultBinary;
EndpointUrlListDataType.schema.encodingDefaultXml = EndpointUrlListDataType.encodingDefaultXml;
EndpointUrlListDataType.schema.encodingDefaultJson = EndpointUrlListDataType.encodingDefaultJson;
registerClassDefinition( EndpointUrlListDataType.dataTypeNodeId, "EndpointUrlListDataType", EndpointUrlListDataType);
// --------------------------------------------------------------------------------------------
const schemaEphemeralKeyType = buildStructuredType({
    name: "EphemeralKeyType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "PublicKey",

            fieldType: "ByteString",
        },
        {
            name: "Signature",

            fieldType: "ByteString",
        },
    ]
});
export interface EphemeralKeyTypeOptions {
    publicKey?: ByteString ;
    signature?: ByteString ;
}
export class EphemeralKeyType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaEphemeralKeyType; }
    public static possibleFields: string[] = [
          "publicKey",
           "signature"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(17548, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(17549, 0);
    public static encodingDefaultXml = makeExpandedNodeId(17553, 0);
    public static encodingDefaultJson = makeExpandedNodeId(17557, 0);
    public publicKey: ByteString;
    public signature: ByteString;

    constructor(options?: EphemeralKeyTypeOptions | null) {

        super(options);

        if (options === null) {
            this.publicKey = Buffer.alloc(0);
            this.signature = Buffer.alloc(0);
              return;
        }
        const schema = EphemeralKeyType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as EphemeralKeyTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.publicKey = initialize_field(schema.fields[0], options?.publicKey);
        this.signature = initialize_field(schema.fields[1], options?.signature);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeByteString(this.publicKey, stream);
        encodeByteString(this.signature, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.publicKey = decodeByteString(stream, this.publicKey);
        this.signature = decodeByteString(stream, this.signature);
    }
    public get schema(): IStructuredTypeSchema { return schemaEphemeralKeyType; }
}
EphemeralKeyType.schema.dataTypeNodeId = EphemeralKeyType.dataTypeNodeId;
EphemeralKeyType.schema.encodingDefaultBinary = EphemeralKeyType.encodingDefaultBinary;
EphemeralKeyType.schema.encodingDefaultXml = EphemeralKeyType.encodingDefaultXml;
EphemeralKeyType.schema.encodingDefaultJson = EphemeralKeyType.encodingDefaultJson;
registerClassDefinition( EphemeralKeyType.dataTypeNodeId, "EphemeralKeyType", EphemeralKeyType);
// --------------------------------------------------------------------------------------------
const schemaEventFieldList = buildStructuredType({
    name: "EventFieldList",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ClientHandle",

            fieldType: "UInt32",
        },
        {
            name: "EventFields",

            fieldType: "Variant",
            isArray: true
        },
    ]
});
export interface EventFieldListOptions {
    clientHandle?: UInt32 ;
    eventFields?: (VariantLike | null)[] | null;
}
export class EventFieldList extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaEventFieldList; }
    public static possibleFields: string[] = [
          "clientHandle",
           "eventFields"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(917, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(919, 0);
    public static encodingDefaultXml = makeExpandedNodeId(918, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15348, 0);
    public clientHandle: UInt32;
    public eventFields: Variant[] | null;

    constructor(options?: EventFieldListOptions | null) {

        super(options);

        if (options === null) {
            this.clientHandle = 0;
            this.eventFields = []
              return;
        }
        const schema = EventFieldList.schema;
        options = (schema.constructHook ? schema.constructHook(options) as EventFieldListOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.clientHandle = initialize_field(schema.fields[0], options?.clientHandle);
        this.eventFields = initialize_field_array(schema.fields[1], options?.eventFields);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeUInt32(this.clientHandle, stream);
        encodeArray(this.eventFields, stream, encodeVariant);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.clientHandle = decodeUInt32(stream, this.clientHandle);
        this.eventFields = decodeArray(stream, decodeVariant);
    }
    public get schema(): IStructuredTypeSchema { return schemaEventFieldList; }
}
EventFieldList.schema.dataTypeNodeId = EventFieldList.dataTypeNodeId;
EventFieldList.schema.encodingDefaultBinary = EventFieldList.encodingDefaultBinary;
EventFieldList.schema.encodingDefaultXml = EventFieldList.encodingDefaultXml;
EventFieldList.schema.encodingDefaultJson = EventFieldList.encodingDefaultJson;
registerClassDefinition( EventFieldList.dataTypeNodeId, "EventFieldList", EventFieldList);
// --------------------------------------------------------------------------------------------
const schemaEventFilter = buildStructuredType({
    name: "EventFilter",

    baseType: "MonitoringFilter",
    fields: [
        {
            name: "SelectClauses",

            fieldType: "SimpleAttributeOperand",
            isArray: true
        },
        {
            name: "WhereClause",

            fieldType: "ContentFilter",
        },
    ]
});
export interface EventFilterOptions extends MonitoringFilterOptions {
    selectClauses?: SimpleAttributeOperandOptions [] | null;
    whereClause?: ContentFilterOptions ;
}
export class EventFilter extends MonitoringFilter {
    public static get schema(): IStructuredTypeSchema { return schemaEventFilter; }
    public static possibleFields: string[] = [
          "selectClauses",
           "whereClause"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(725, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(727, 0);
    public static encodingDefaultXml = makeExpandedNodeId(726, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15295, 0);
    public selectClauses: SimpleAttributeOperand[] | null;
    public whereClause: ContentFilter;

    constructor(options?: EventFilterOptions | null) {

        super(options);

        if (options === null) {
         this.selectClauses =  null; /* null array */
         this.whereClause =  new ContentFilter(null);
              return;
        }
        const schema = EventFilter.schema;
        options = (schema.constructHook ? schema.constructHook(options) as EventFilterOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.selectClauses = []; // should default
        if (options.selectClauses) {
            assert(Array.isArray(options.selectClauses));
            this.selectClauses = options.selectClauses.map((e: any) => new SimpleAttributeOperand(e));
        }
        this.whereClause  =  new ContentFilter(options.whereClause);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeArray(this.selectClauses, stream, (obj, stream1) => { obj.encode(stream1); });
        this.whereClause.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.selectClauses = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new SimpleAttributeOperand(null);
            obj.decode(stream1);
            return obj;
        });
        this.whereClause.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaEventFilter; }
}
EventFilter.schema.dataTypeNodeId = EventFilter.dataTypeNodeId;
EventFilter.schema.encodingDefaultBinary = EventFilter.encodingDefaultBinary;
EventFilter.schema.encodingDefaultXml = EventFilter.encodingDefaultXml;
EventFilter.schema.encodingDefaultJson = EventFilter.encodingDefaultJson;
registerClassDefinition( EventFilter.dataTypeNodeId, "EventFilter", EventFilter);
// --------------------------------------------------------------------------------------------
const schemaEventFilterResult = buildStructuredType({
    name: "EventFilterResult",

    baseType: "MonitoringFilterResult",
    fields: [
        {
            name: "SelectClauseResults",

            fieldType: "StatusCode",
            isArray: true
        },
        {
            name: "SelectClauseDiagnosticInfos",

            fieldType: "DiagnosticInfo",
            isArray: true
        },
        {
            name: "WhereClauseResult",

            fieldType: "ContentFilterResult",
        },
    ]
});
export interface EventFilterResultOptions extends MonitoringFilterResultOptions {
    selectClauseResults?: StatusCode [] | null;
    selectClauseDiagnosticInfos?: (DiagnosticInfo | null)[] | null;
    whereClauseResult?: ContentFilterResultOptions ;
}
export class EventFilterResult extends MonitoringFilterResult {
    public static get schema(): IStructuredTypeSchema { return schemaEventFilterResult; }
    public static possibleFields: string[] = [
          "selectClauseResults",
           "selectClauseDiagnosticInfos",
           "whereClauseResult"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(734, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(736, 0);
    public static encodingDefaultXml = makeExpandedNodeId(735, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15314, 0);
    public selectClauseResults: StatusCode[] | null;
    public selectClauseDiagnosticInfos: (DiagnosticInfo | null)[] | null;
    public whereClauseResult: ContentFilterResult;

    constructor(options?: EventFilterResultOptions | null) {

        super(options);

        if (options === null) {
            this.selectClauseResults = []
            this.selectClauseDiagnosticInfos = []
         this.whereClauseResult =  new ContentFilterResult(null);
              return;
        }
        const schema = EventFilterResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) as EventFilterResultOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.selectClauseResults = initialize_field_array(schema.fields[0], options?.selectClauseResults);
        this.selectClauseDiagnosticInfos = initialize_field_array(schema.fields[1], options?.selectClauseDiagnosticInfos);
        this.whereClauseResult  =  new ContentFilterResult(options.whereClauseResult);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeArray(this.selectClauseResults, stream, encodeStatusCode);
        encodeArray(this.selectClauseDiagnosticInfos, stream, encodeDiagnosticInfo);
        this.whereClauseResult.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.selectClauseResults = decodeArray(stream, decodeStatusCode);
        this.selectClauseDiagnosticInfos = decodeArray(stream, decodeDiagnosticInfo);
        this.whereClauseResult.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaEventFilterResult; }
}
EventFilterResult.schema.dataTypeNodeId = EventFilterResult.dataTypeNodeId;
EventFilterResult.schema.encodingDefaultBinary = EventFilterResult.encodingDefaultBinary;
EventFilterResult.schema.encodingDefaultXml = EventFilterResult.encodingDefaultXml;
EventFilterResult.schema.encodingDefaultJson = EventFilterResult.encodingDefaultJson;
registerClassDefinition( EventFilterResult.dataTypeNodeId, "EventFilterResult", EventFilterResult);
// --------------------------------------------------------------------------------------------
const schemaEventNotificationList = buildStructuredType({
    name: "EventNotificationList",

    baseType: "NotificationData",
    fields: [
        {
            name: "Events",

            fieldType: "EventFieldList",
            isArray: true
        },
    ]
});
export interface EventNotificationListOptions extends NotificationDataOptions {
    events?: EventFieldListOptions [] | null;
}
export class EventNotificationList extends NotificationData {
    public static get schema(): IStructuredTypeSchema { return schemaEventNotificationList; }
    public static possibleFields: string[] = [
          "events"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(914, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(916, 0);
    public static encodingDefaultXml = makeExpandedNodeId(915, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15347, 0);
    public events: EventFieldList[] | null;

    constructor(options?: EventNotificationListOptions | null) {

        super(options);

        if (options === null) {
         this.events =  null; /* null array */
              return;
        }
        const schema = EventNotificationList.schema;
        options = (schema.constructHook ? schema.constructHook(options) as EventNotificationListOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.events = []; // should default
        if (options.events) {
            assert(Array.isArray(options.events));
            this.events = options.events.map((e: any) => new EventFieldList(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeArray(this.events, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.events = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new EventFieldList(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaEventNotificationList; }
}
EventNotificationList.schema.dataTypeNodeId = EventNotificationList.dataTypeNodeId;
EventNotificationList.schema.encodingDefaultBinary = EventNotificationList.encodingDefaultBinary;
EventNotificationList.schema.encodingDefaultXml = EventNotificationList.encodingDefaultXml;
EventNotificationList.schema.encodingDefaultJson = EventNotificationList.encodingDefaultJson;
registerClassDefinition( EventNotificationList.dataTypeNodeId, "EventNotificationList", EventNotificationList);

// --------------------------------------------------------------------------------------------
export enum OverrideValueHandling {
    Disabled = 0,
    LastUsableValue = 1,
    OverrideValue = 2,
    Invalid = 4294967295
}
const schemaOverrideValueHandling = {
    enumValues: OverrideValueHandling,
    flaggable: false,
    minValue: 0,
    maxValue: 2,
    name: "OverrideValueHandling"
};
function decodeOverrideValueHandling(stream: BinaryStream, _value?: OverrideValueHandling): OverrideValueHandling {
    let value =  stream.readUInt32() as OverrideValueHandling;
    value = (value < schemaOverrideValueHandling.minValue || value > schemaOverrideValueHandling.maxValue) ? OverrideValueHandling.Invalid : value; 
    return value;
}
function encodeOverrideValueHandling(value: OverrideValueHandling, stream: OutputBinaryStream): void {
    stream.writeUInt32(value);
}
export const _enumerationOverrideValueHandling = registerEnumeration(schemaOverrideValueHandling);
assert(_enumerationOverrideValueHandling.isFlaggable ===  false);
// --------------------------------------------------------------------------------------------
const schemaFieldTargetDataType = buildStructuredType({
    name: "FieldTargetDataType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "DataSetFieldId",

            fieldType: "Guid",
        },
        {
            name: "ReceiverIndexRange",

            fieldType: "String",
        },
        {
            name: "TargetNodeId",

            fieldType: "NodeId",
        },
        {
            name: "AttributeId",

            fieldType: "UInt32",
        },
        {
            name: "WriteIndexRange",

            fieldType: "String",
        },
        {
            name: "OverrideValueHandling",

            fieldType: "OverrideValueHandling",
        },
        {
            name: "OverrideValue",

            fieldType: "Variant",
        },
    ]
});
export interface FieldTargetDataTypeOptions {
    dataSetFieldId?: Guid ;
    receiverIndexRange?: UAString ;
    targetNodeId?: (NodeIdLike | null);
    attributeId?: UInt32 ;
    writeIndexRange?: UAString ;
    overrideValueHandling?: OverrideValueHandling;
    overrideValue?: (VariantLike | null);
}
export class FieldTargetDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaFieldTargetDataType; }
    public static possibleFields: string[] = [
          "dataSetFieldId",
           "receiverIndexRange",
           "targetNodeId",
           "attributeId",
           "writeIndexRange",
           "overrideValueHandling",
           "overrideValue"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(14744, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(14848, 0);
    public static encodingDefaultXml = makeExpandedNodeId(14804, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15061, 0);
    public dataSetFieldId: Guid;
    public receiverIndexRange: UAString;
    public targetNodeId: NodeId;
    public attributeId: UInt32;
    public writeIndexRange: UAString;
    public overrideValueHandling: OverrideValueHandling;
    public overrideValue: Variant;

    constructor(options?: FieldTargetDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.dataSetFieldId = "";
            this.receiverIndexRange = null;
            this.targetNodeId = new NodeId(null);
            this.attributeId = 0;
            this.writeIndexRange = null;
             this.overrideValueHandling =  0 as  OverrideValueHandling;
            this.overrideValue = new Variant(null);
              return;
        }
        const schema = FieldTargetDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as FieldTargetDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.dataSetFieldId = initialize_field(schema.fields[0], options?.dataSetFieldId);
        this.receiverIndexRange = initialize_field(schema.fields[1], options?.receiverIndexRange);
        this.targetNodeId = initialize_field(schema.fields[2], options?.targetNodeId);
        this.attributeId = initialize_field(schema.fields[3], options?.attributeId);
        this.writeIndexRange = initialize_field(schema.fields[4], options?.writeIndexRange);
        this.overrideValueHandling = this.setOverrideValueHandling(initialize_field(schema.fields[5], options?.overrideValueHandling));
        this.overrideValue = initialize_field(schema.fields[6], options?.overrideValue);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeGuid(this.dataSetFieldId, stream);
        encodeString(this.receiverIndexRange, stream);
        encodeNodeId(this.targetNodeId, stream);
        encodeUInt32(this.attributeId, stream);
        encodeString(this.writeIndexRange, stream);
        encodeOverrideValueHandling(this.overrideValueHandling, stream);
        encodeVariant(this.overrideValue, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.dataSetFieldId = decodeGuid(stream, this.dataSetFieldId);
        this.receiverIndexRange = decodeString(stream, this.receiverIndexRange);
        this.targetNodeId = decodeNodeId(stream, this.targetNodeId);
        this.attributeId = decodeUInt32(stream, this.attributeId);
        this.writeIndexRange = decodeString(stream, this.writeIndexRange);
        this.overrideValueHandling = decodeOverrideValueHandling(stream, this.overrideValueHandling);
        this.overrideValue = decodeVariant(stream, this.overrideValue);
    }

    // Define Enumeration setters
    public setOverrideValueHandling(value: any): OverrideValueHandling {
        const coercedValue = _enumerationOverrideValueHandling.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to OverrideValueHandling :" + value);
        }
        this.overrideValueHandling = coercedValue.value as OverrideValueHandling;
        return this.overrideValueHandling;
    }
    public get schema(): IStructuredTypeSchema { return schemaFieldTargetDataType; }
}
FieldTargetDataType.schema.dataTypeNodeId = FieldTargetDataType.dataTypeNodeId;
FieldTargetDataType.schema.encodingDefaultBinary = FieldTargetDataType.encodingDefaultBinary;
FieldTargetDataType.schema.encodingDefaultXml = FieldTargetDataType.encodingDefaultXml;
FieldTargetDataType.schema.encodingDefaultJson = FieldTargetDataType.encodingDefaultJson;
registerClassDefinition( FieldTargetDataType.dataTypeNodeId, "FieldTargetDataType", FieldTargetDataType);
// --------------------------------------------------------------------------------------------
const schemaFindServersOnNetworkRequest = buildStructuredType({
    name: "FindServersOnNetworkRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
        {
            name: "StartingRecordId",

            fieldType: "UInt32",
        },
        {
            name: "MaxRecordsToReturn",

            fieldType: "UInt32",
        },
        {
            name: "ServerCapabilityFilter",

            fieldType: "String",
            isArray: true
        },
    ]
});
export interface FindServersOnNetworkRequestOptions {
    requestHeader?: RequestHeaderOptions ;
    startingRecordId?: UInt32 ;
    maxRecordsToReturn?: UInt32 ;
    serverCapabilityFilter?: UAString [] | null;
}
export class FindServersOnNetworkRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaFindServersOnNetworkRequest; }
    public static possibleFields: string[] = [
          "requestHeader",
           "startingRecordId",
           "maxRecordsToReturn",
           "serverCapabilityFilter"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(12190, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(12208, 0);
    public static encodingDefaultXml = makeExpandedNodeId(12196, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15096, 0);
    public requestHeader: RequestHeader;
    public startingRecordId: UInt32;
    public maxRecordsToReturn: UInt32;
    public serverCapabilityFilter: UAString[] | null;

    constructor(options?: FindServersOnNetworkRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
            this.startingRecordId = 0;
            this.maxRecordsToReturn = 0;
            this.serverCapabilityFilter = []
              return;
        }
        const schema = FindServersOnNetworkRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as FindServersOnNetworkRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
        this.startingRecordId = initialize_field(schema.fields[1], options?.startingRecordId);
        this.maxRecordsToReturn = initialize_field(schema.fields[2], options?.maxRecordsToReturn);
        this.serverCapabilityFilter = initialize_field_array(schema.fields[3], options?.serverCapabilityFilter);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        encodeUInt32(this.startingRecordId, stream);
        encodeUInt32(this.maxRecordsToReturn, stream);
        encodeArray(this.serverCapabilityFilter, stream, encodeString);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.startingRecordId = decodeUInt32(stream, this.startingRecordId);
        this.maxRecordsToReturn = decodeUInt32(stream, this.maxRecordsToReturn);
        this.serverCapabilityFilter = decodeArray(stream, decodeString);
    }
    public get schema(): IStructuredTypeSchema { return schemaFindServersOnNetworkRequest; }
}
FindServersOnNetworkRequest.schema.dataTypeNodeId = FindServersOnNetworkRequest.dataTypeNodeId;
FindServersOnNetworkRequest.schema.encodingDefaultBinary = FindServersOnNetworkRequest.encodingDefaultBinary;
FindServersOnNetworkRequest.schema.encodingDefaultXml = FindServersOnNetworkRequest.encodingDefaultXml;
FindServersOnNetworkRequest.schema.encodingDefaultJson = FindServersOnNetworkRequest.encodingDefaultJson;
registerClassDefinition( FindServersOnNetworkRequest.dataTypeNodeId, "FindServersOnNetworkRequest", FindServersOnNetworkRequest);
// --------------------------------------------------------------------------------------------
const schemaServerOnNetwork = buildStructuredType({
    name: "ServerOnNetwork",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RecordId",

            fieldType: "UInt32",
        },
        {
            name: "ServerName",

            fieldType: "String",
        },
        {
            name: "DiscoveryUrl",

            fieldType: "String",
        },
        {
            name: "ServerCapabilities",

            fieldType: "String",
            isArray: true
        },
    ]
});
export interface ServerOnNetworkOptions {
    recordId?: UInt32 ;
    serverName?: UAString ;
    discoveryUrl?: UAString ;
    serverCapabilities?: UAString [] | null;
}
export class ServerOnNetwork extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaServerOnNetwork; }
    public static possibleFields: string[] = [
          "recordId",
           "serverName",
           "discoveryUrl",
           "serverCapabilities"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(12189, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(12207, 0);
    public static encodingDefaultXml = makeExpandedNodeId(12195, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15095, 0);
    public recordId: UInt32;
    public serverName: UAString;
    public discoveryUrl: UAString;
    public serverCapabilities: UAString[] | null;

    constructor(options?: ServerOnNetworkOptions | null) {

        super(options);

        if (options === null) {
            this.recordId = 0;
            this.serverName = null;
            this.discoveryUrl = null;
            this.serverCapabilities = []
              return;
        }
        const schema = ServerOnNetwork.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ServerOnNetworkOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.recordId = initialize_field(schema.fields[0], options?.recordId);
        this.serverName = initialize_field(schema.fields[1], options?.serverName);
        this.discoveryUrl = initialize_field(schema.fields[2], options?.discoveryUrl);
        this.serverCapabilities = initialize_field_array(schema.fields[3], options?.serverCapabilities);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeUInt32(this.recordId, stream);
        encodeString(this.serverName, stream);
        encodeString(this.discoveryUrl, stream);
        encodeArray(this.serverCapabilities, stream, encodeString);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.recordId = decodeUInt32(stream, this.recordId);
        this.serverName = decodeString(stream, this.serverName);
        this.discoveryUrl = decodeString(stream, this.discoveryUrl);
        this.serverCapabilities = decodeArray(stream, decodeString);
    }
    public get schema(): IStructuredTypeSchema { return schemaServerOnNetwork; }
}
ServerOnNetwork.schema.dataTypeNodeId = ServerOnNetwork.dataTypeNodeId;
ServerOnNetwork.schema.encodingDefaultBinary = ServerOnNetwork.encodingDefaultBinary;
ServerOnNetwork.schema.encodingDefaultXml = ServerOnNetwork.encodingDefaultXml;
ServerOnNetwork.schema.encodingDefaultJson = ServerOnNetwork.encodingDefaultJson;
registerClassDefinition( ServerOnNetwork.dataTypeNodeId, "ServerOnNetwork", ServerOnNetwork);
// --------------------------------------------------------------------------------------------
const schemaFindServersOnNetworkResponse = buildStructuredType({
    name: "FindServersOnNetworkResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
        {
            name: "LastCounterResetTime",

            fieldType: "DateTime",
        },
        {
            name: "Servers",

            fieldType: "ServerOnNetwork",
            isArray: true
        },
    ]
});
export interface FindServersOnNetworkResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
    lastCounterResetTime?: DateTime ;
    servers?: ServerOnNetworkOptions [] | null;
}
export class FindServersOnNetworkResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaFindServersOnNetworkResponse; }
    public static possibleFields: string[] = [
          "responseHeader",
           "lastCounterResetTime",
           "servers"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(12191, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(12209, 0);
    public static encodingDefaultXml = makeExpandedNodeId(12197, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15097, 0);
    public responseHeader: ResponseHeader;
    public lastCounterResetTime: DateTime;
    public servers: ServerOnNetwork[] | null;

    constructor(options?: FindServersOnNetworkResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
            this.lastCounterResetTime = new Date();
         this.servers =  null; /* null array */
              return;
        }
        const schema = FindServersOnNetworkResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as FindServersOnNetworkResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
        this.lastCounterResetTime = initialize_field(schema.fields[1], options?.lastCounterResetTime);
        this.servers = []; // should default
        if (options.servers) {
            assert(Array.isArray(options.servers));
            this.servers = options.servers.map((e: any) => new ServerOnNetwork(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        encodeDateTime(this.lastCounterResetTime, stream);
        encodeArray(this.servers, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.lastCounterResetTime = decodeDateTime(stream, this.lastCounterResetTime);
        this.servers = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new ServerOnNetwork(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaFindServersOnNetworkResponse; }
}
FindServersOnNetworkResponse.schema.dataTypeNodeId = FindServersOnNetworkResponse.dataTypeNodeId;
FindServersOnNetworkResponse.schema.encodingDefaultBinary = FindServersOnNetworkResponse.encodingDefaultBinary;
FindServersOnNetworkResponse.schema.encodingDefaultXml = FindServersOnNetworkResponse.encodingDefaultXml;
FindServersOnNetworkResponse.schema.encodingDefaultJson = FindServersOnNetworkResponse.encodingDefaultJson;
registerClassDefinition( FindServersOnNetworkResponse.dataTypeNodeId, "FindServersOnNetworkResponse", FindServersOnNetworkResponse);
// --------------------------------------------------------------------------------------------
const schemaFindServersRequest = buildStructuredType({
    name: "FindServersRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
        {
            name: "EndpointUrl",

            fieldType: "String",
        },
        {
            name: "LocaleIds",

            fieldType: "String",
            isArray: true
        },
        {
            name: "ServerUris",

            fieldType: "String",
            isArray: true
        },
    ]
});
export interface FindServersRequestOptions {
    requestHeader?: RequestHeaderOptions ;
    endpointUrl?: UAString ;
    localeIds?: UAString [] | null;
    serverUris?: UAString [] | null;
}
export class FindServersRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaFindServersRequest; }
    public static possibleFields: string[] = [
          "requestHeader",
           "endpointUrl",
           "localeIds",
           "serverUris"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(420, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(422, 0);
    public static encodingDefaultXml = makeExpandedNodeId(421, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15093, 0);
    public requestHeader: RequestHeader;
    public endpointUrl: UAString;
    public localeIds: UAString[] | null;
    public serverUris: UAString[] | null;

    constructor(options?: FindServersRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
            this.endpointUrl = null;
            this.localeIds = []
            this.serverUris = []
              return;
        }
        const schema = FindServersRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as FindServersRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
        this.endpointUrl = initialize_field(schema.fields[1], options?.endpointUrl);
        this.localeIds = initialize_field_array(schema.fields[2], options?.localeIds);
        this.serverUris = initialize_field_array(schema.fields[3], options?.serverUris);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        encodeString(this.endpointUrl, stream);
        encodeArray(this.localeIds, stream, encodeString);
        encodeArray(this.serverUris, stream, encodeString);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.endpointUrl = decodeString(stream, this.endpointUrl);
        this.localeIds = decodeArray(stream, decodeString);
        this.serverUris = decodeArray(stream, decodeString);
    }
    public get schema(): IStructuredTypeSchema { return schemaFindServersRequest; }
}
FindServersRequest.schema.dataTypeNodeId = FindServersRequest.dataTypeNodeId;
FindServersRequest.schema.encodingDefaultBinary = FindServersRequest.encodingDefaultBinary;
FindServersRequest.schema.encodingDefaultXml = FindServersRequest.encodingDefaultXml;
FindServersRequest.schema.encodingDefaultJson = FindServersRequest.encodingDefaultJson;
registerClassDefinition( FindServersRequest.dataTypeNodeId, "FindServersRequest", FindServersRequest);
// --------------------------------------------------------------------------------------------
const schemaFindServersResponse = buildStructuredType({
    name: "FindServersResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
        {
            name: "Servers",

            fieldType: "ApplicationDescription",
            isArray: true
        },
    ]
});
export interface FindServersResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
    servers?: ApplicationDescriptionOptions [] | null;
}
export class FindServersResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaFindServersResponse; }
    public static possibleFields: string[] = [
          "responseHeader",
           "servers"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(423, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(425, 0);
    public static encodingDefaultXml = makeExpandedNodeId(424, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15094, 0);
    public responseHeader: ResponseHeader;
    public servers: ApplicationDescription[] | null;

    constructor(options?: FindServersResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
         this.servers =  null; /* null array */
              return;
        }
        const schema = FindServersResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as FindServersResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
        this.servers = []; // should default
        if (options.servers) {
            assert(Array.isArray(options.servers));
            this.servers = options.servers.map((e: any) => new ApplicationDescription(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        encodeArray(this.servers, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.servers = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new ApplicationDescription(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaFindServersResponse; }
}
FindServersResponse.schema.dataTypeNodeId = FindServersResponse.dataTypeNodeId;
FindServersResponse.schema.encodingDefaultBinary = FindServersResponse.encodingDefaultBinary;
FindServersResponse.schema.encodingDefaultXml = FindServersResponse.encodingDefaultXml;
FindServersResponse.schema.encodingDefaultJson = FindServersResponse.encodingDefaultJson;
registerClassDefinition( FindServersResponse.dataTypeNodeId, "FindServersResponse", FindServersResponse);
// --------------------------------------------------------------------------------------------
const schemaFrame = buildStructuredType({
    name: "Frame",

    baseType: "ExtensionObject",
    fields: [
    ]
});
export interface FrameOptions {
}
export class Frame extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaFrame; }
    public static possibleFields: string[] = [
          
    ];
    public static dataTypeNodeId = makeExpandedNodeId(18813, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(18822, 0);
    public static encodingDefaultXml = makeExpandedNodeId(18858, 0);
    public static encodingDefaultJson = makeExpandedNodeId(19071, 0);

    constructor(options?: FrameOptions | null) {

        super(options);

        if (options === null) {
              return;
        }
        const schema = Frame.schema;
        options = (schema.constructHook ? schema.constructHook(options) as FrameOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaFrame; }
}
Frame.schema.dataTypeNodeId = Frame.dataTypeNodeId;
Frame.schema.encodingDefaultBinary = Frame.encodingDefaultBinary;
Frame.schema.encodingDefaultXml = Frame.encodingDefaultXml;
Frame.schema.encodingDefaultJson = Frame.encodingDefaultJson;
registerClassDefinition( Frame.dataTypeNodeId, "Frame", Frame);
// --------------------------------------------------------------------------------------------
const schemaGenericAttributeValue = buildStructuredType({
    name: "GenericAttributeValue",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "AttributeId",

            fieldType: "UInt32",
        },
        {
            name: "Value",

            fieldType: "Variant",
        },
    ]
});
export interface GenericAttributeValueOptions {
    attributeId?: UInt32 ;
    value?: (VariantLike | null);
}
export class GenericAttributeValue extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaGenericAttributeValue; }
    public static possibleFields: string[] = [
          "attributeId",
           "value"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(17606, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(17610, 0);
    public static encodingDefaultXml = makeExpandedNodeId(17608, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15163, 0);
    public attributeId: UInt32;
    public value: Variant;

    constructor(options?: GenericAttributeValueOptions | null) {

        super(options);

        if (options === null) {
            this.attributeId = 0;
            this.value = new Variant(null);
              return;
        }
        const schema = GenericAttributeValue.schema;
        options = (schema.constructHook ? schema.constructHook(options) as GenericAttributeValueOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.attributeId = initialize_field(schema.fields[0], options?.attributeId);
        this.value = initialize_field(schema.fields[1], options?.value);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeUInt32(this.attributeId, stream);
        encodeVariant(this.value, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.attributeId = decodeUInt32(stream, this.attributeId);
        this.value = decodeVariant(stream, this.value);
    }
    public get schema(): IStructuredTypeSchema { return schemaGenericAttributeValue; }
}
GenericAttributeValue.schema.dataTypeNodeId = GenericAttributeValue.dataTypeNodeId;
GenericAttributeValue.schema.encodingDefaultBinary = GenericAttributeValue.encodingDefaultBinary;
GenericAttributeValue.schema.encodingDefaultXml = GenericAttributeValue.encodingDefaultXml;
GenericAttributeValue.schema.encodingDefaultJson = GenericAttributeValue.encodingDefaultJson;
registerClassDefinition( GenericAttributeValue.dataTypeNodeId, "GenericAttributeValue", GenericAttributeValue);
// --------------------------------------------------------------------------------------------
const schemaGenericAttributes = buildStructuredType({
    name: "GenericAttributes",

    baseType: "NodeAttributes",
    fields: [
        {
            name: "AttributeValues",

            fieldType: "GenericAttributeValue",
            isArray: true
        },
    ]
});
export interface GenericAttributesOptions extends NodeAttributesOptions {
    attributeValues?: GenericAttributeValueOptions [] | null;
}
export class GenericAttributes extends NodeAttributes {
    public static get schema(): IStructuredTypeSchema { return schemaGenericAttributes; }
    public static possibleFields: string[] = [
          "specifiedAttributes",
           "displayName",
           "description",
           "writeMask",
           "userWriteMask",
           "attributeValues"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(17607, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(17611, 0);
    public static encodingDefaultXml = makeExpandedNodeId(17609, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15164, 0);
    public attributeValues: GenericAttributeValue[] | null;

    constructor(options?: GenericAttributesOptions | null) {

        super(options);

        if (options === null) {
         this.attributeValues =  null; /* null array */
              return;
        }
        const schema = GenericAttributes.schema;
        options = (schema.constructHook ? schema.constructHook(options) as GenericAttributesOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.attributeValues = []; // should default
        if (options.attributeValues) {
            assert(Array.isArray(options.attributeValues));
            this.attributeValues = options.attributeValues.map((e: any) => new GenericAttributeValue(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeArray(this.attributeValues, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.attributeValues = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new GenericAttributeValue(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaGenericAttributes; }
}
GenericAttributes.schema.dataTypeNodeId = GenericAttributes.dataTypeNodeId;
GenericAttributes.schema.encodingDefaultBinary = GenericAttributes.encodingDefaultBinary;
GenericAttributes.schema.encodingDefaultXml = GenericAttributes.encodingDefaultXml;
GenericAttributes.schema.encodingDefaultJson = GenericAttributes.encodingDefaultJson;
registerClassDefinition( GenericAttributes.dataTypeNodeId, "GenericAttributes", GenericAttributes);
// --------------------------------------------------------------------------------------------
const schemaGetEndpointsRequest = buildStructuredType({
    name: "GetEndpointsRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
        {
            name: "EndpointUrl",

            fieldType: "String",
        },
        {
            name: "LocaleIds",

            fieldType: "String",
            isArray: true
        },
        {
            name: "ProfileUris",

            fieldType: "String",
            isArray: true
        },
    ]
});
export interface GetEndpointsRequestOptions {
    requestHeader?: RequestHeaderOptions ;
    endpointUrl?: UAString ;
    localeIds?: UAString [] | null;
    profileUris?: UAString [] | null;
}
export class GetEndpointsRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaGetEndpointsRequest; }
    public static possibleFields: string[] = [
          "requestHeader",
           "endpointUrl",
           "localeIds",
           "profileUris"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(426, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(428, 0);
    public static encodingDefaultXml = makeExpandedNodeId(427, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15100, 0);
    public requestHeader: RequestHeader;
    public endpointUrl: UAString;
    public localeIds: UAString[] | null;
    public profileUris: UAString[] | null;

    constructor(options?: GetEndpointsRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
            this.endpointUrl = null;
            this.localeIds = []
            this.profileUris = []
              return;
        }
        const schema = GetEndpointsRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as GetEndpointsRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
        this.endpointUrl = initialize_field(schema.fields[1], options?.endpointUrl);
        this.localeIds = initialize_field_array(schema.fields[2], options?.localeIds);
        this.profileUris = initialize_field_array(schema.fields[3], options?.profileUris);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        encodeString(this.endpointUrl, stream);
        encodeArray(this.localeIds, stream, encodeString);
        encodeArray(this.profileUris, stream, encodeString);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.endpointUrl = decodeString(stream, this.endpointUrl);
        this.localeIds = decodeArray(stream, decodeString);
        this.profileUris = decodeArray(stream, decodeString);
    }
    public get schema(): IStructuredTypeSchema { return schemaGetEndpointsRequest; }
}
GetEndpointsRequest.schema.dataTypeNodeId = GetEndpointsRequest.dataTypeNodeId;
GetEndpointsRequest.schema.encodingDefaultBinary = GetEndpointsRequest.encodingDefaultBinary;
GetEndpointsRequest.schema.encodingDefaultXml = GetEndpointsRequest.encodingDefaultXml;
GetEndpointsRequest.schema.encodingDefaultJson = GetEndpointsRequest.encodingDefaultJson;
registerClassDefinition( GetEndpointsRequest.dataTypeNodeId, "GetEndpointsRequest", GetEndpointsRequest);
// --------------------------------------------------------------------------------------------
const schemaGetEndpointsResponse = buildStructuredType({
    name: "GetEndpointsResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
        {
            name: "Endpoints",

            fieldType: "EndpointDescription",
            isArray: true
        },
    ]
});
export interface GetEndpointsResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
    endpoints?: EndpointDescriptionOptions [] | null;
}
export class GetEndpointsResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaGetEndpointsResponse; }
    public static possibleFields: string[] = [
          "responseHeader",
           "endpoints"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(429, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(431, 0);
    public static encodingDefaultXml = makeExpandedNodeId(430, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15101, 0);
    public responseHeader: ResponseHeader;
    public endpoints: EndpointDescription[] | null;

    constructor(options?: GetEndpointsResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
         this.endpoints =  null; /* null array */
              return;
        }
        const schema = GetEndpointsResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as GetEndpointsResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
        this.endpoints = []; // should default
        if (options.endpoints) {
            assert(Array.isArray(options.endpoints));
            this.endpoints = options.endpoints.map((e: any) => new EndpointDescription(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        encodeArray(this.endpoints, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.endpoints = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new EndpointDescription(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaGetEndpointsResponse; }
}
GetEndpointsResponse.schema.dataTypeNodeId = GetEndpointsResponse.dataTypeNodeId;
GetEndpointsResponse.schema.encodingDefaultBinary = GetEndpointsResponse.encodingDefaultBinary;
GetEndpointsResponse.schema.encodingDefaultXml = GetEndpointsResponse.encodingDefaultXml;
GetEndpointsResponse.schema.encodingDefaultJson = GetEndpointsResponse.encodingDefaultJson;
registerClassDefinition( GetEndpointsResponse.dataTypeNodeId, "GetEndpointsResponse", GetEndpointsResponse);
// --------------------------------------------------------------------------------------------
const schemaHistoryData = buildStructuredType({
    name: "HistoryData",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "DataValues",

            fieldType: "DataValue",
            isArray: true
        },
    ]
});
export interface HistoryDataOptions {
    dataValues?: (DataValueLike | null)[] | null;
}
export class HistoryData extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaHistoryData; }
    public static possibleFields: string[] = [
          "dataValues"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(656, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(658, 0);
    public static encodingDefaultXml = makeExpandedNodeId(657, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15270, 0);
    public dataValues: DataValue[] | null;

    constructor(options?: HistoryDataOptions | null) {

        super(options);

        if (options === null) {
            this.dataValues = []
              return;
        }
        const schema = HistoryData.schema;
        options = (schema.constructHook ? schema.constructHook(options) as HistoryDataOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.dataValues = initialize_field_array(schema.fields[0], options?.dataValues);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeArray(this.dataValues, stream, encodeDataValue);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.dataValues = decodeArray(stream, decodeDataValue);
    }
    public get schema(): IStructuredTypeSchema { return schemaHistoryData; }
}
HistoryData.schema.dataTypeNodeId = HistoryData.dataTypeNodeId;
HistoryData.schema.encodingDefaultBinary = HistoryData.encodingDefaultBinary;
HistoryData.schema.encodingDefaultXml = HistoryData.encodingDefaultXml;
HistoryData.schema.encodingDefaultJson = HistoryData.encodingDefaultJson;
registerClassDefinition( HistoryData.dataTypeNodeId, "HistoryData", HistoryData);
// --------------------------------------------------------------------------------------------
const schemaHistoryEventFieldList = buildStructuredType({
    name: "HistoryEventFieldList",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "EventFields",

            fieldType: "Variant",
            isArray: true
        },
    ]
});
export interface HistoryEventFieldListOptions {
    eventFields?: (VariantLike | null)[] | null;
}
export class HistoryEventFieldList extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaHistoryEventFieldList; }
    public static possibleFields: string[] = [
          "eventFields"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(920, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(922, 0);
    public static encodingDefaultXml = makeExpandedNodeId(921, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15349, 0);
    public eventFields: Variant[] | null;

    constructor(options?: HistoryEventFieldListOptions | null) {

        super(options);

        if (options === null) {
            this.eventFields = []
              return;
        }
        const schema = HistoryEventFieldList.schema;
        options = (schema.constructHook ? schema.constructHook(options) as HistoryEventFieldListOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.eventFields = initialize_field_array(schema.fields[0], options?.eventFields);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeArray(this.eventFields, stream, encodeVariant);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.eventFields = decodeArray(stream, decodeVariant);
    }
    public get schema(): IStructuredTypeSchema { return schemaHistoryEventFieldList; }
}
HistoryEventFieldList.schema.dataTypeNodeId = HistoryEventFieldList.dataTypeNodeId;
HistoryEventFieldList.schema.encodingDefaultBinary = HistoryEventFieldList.encodingDefaultBinary;
HistoryEventFieldList.schema.encodingDefaultXml = HistoryEventFieldList.encodingDefaultXml;
HistoryEventFieldList.schema.encodingDefaultJson = HistoryEventFieldList.encodingDefaultJson;
registerClassDefinition( HistoryEventFieldList.dataTypeNodeId, "HistoryEventFieldList", HistoryEventFieldList);
// --------------------------------------------------------------------------------------------
const schemaHistoryEvent = buildStructuredType({
    name: "HistoryEvent",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Events",

            fieldType: "HistoryEventFieldList",
            isArray: true
        },
    ]
});
export interface HistoryEventOptions {
    events?: HistoryEventFieldListOptions [] | null;
}
export class HistoryEvent extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaHistoryEvent; }
    public static possibleFields: string[] = [
          "events"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(659, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(661, 0);
    public static encodingDefaultXml = makeExpandedNodeId(660, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15273, 0);
    public events: HistoryEventFieldList[] | null;

    constructor(options?: HistoryEventOptions | null) {

        super(options);

        if (options === null) {
         this.events =  null; /* null array */
              return;
        }
        const schema = HistoryEvent.schema;
        options = (schema.constructHook ? schema.constructHook(options) as HistoryEventOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.events = []; // should default
        if (options.events) {
            assert(Array.isArray(options.events));
            this.events = options.events.map((e: any) => new HistoryEventFieldList(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeArray(this.events, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.events = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new HistoryEventFieldList(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaHistoryEvent; }
}
HistoryEvent.schema.dataTypeNodeId = HistoryEvent.dataTypeNodeId;
HistoryEvent.schema.encodingDefaultBinary = HistoryEvent.encodingDefaultBinary;
HistoryEvent.schema.encodingDefaultXml = HistoryEvent.encodingDefaultXml;
HistoryEvent.schema.encodingDefaultJson = HistoryEvent.encodingDefaultJson;
registerClassDefinition( HistoryEvent.dataTypeNodeId, "HistoryEvent", HistoryEvent);

// --------------------------------------------------------------------------------------------
export enum HistoryUpdateType {
    Insert = 1,
    Replace = 2,
    Update = 3,
    Delete = 4,
    Invalid = 4294967295
}
const schemaHistoryUpdateType = {
    enumValues: HistoryUpdateType,
    flaggable: false,
    minValue: 1,
    maxValue: 4,
    name: "HistoryUpdateType"
};
function decodeHistoryUpdateType(stream: BinaryStream, _value?: HistoryUpdateType): HistoryUpdateType {
    let value =  stream.readUInt32() as HistoryUpdateType;
    value = (value < schemaHistoryUpdateType.minValue || value > schemaHistoryUpdateType.maxValue) ? HistoryUpdateType.Invalid : value; 
    return value;
}
function encodeHistoryUpdateType(value: HistoryUpdateType, stream: OutputBinaryStream): void {
    stream.writeUInt32(value);
}
export const _enumerationHistoryUpdateType = registerEnumeration(schemaHistoryUpdateType);
assert(_enumerationHistoryUpdateType.isFlaggable ===  false);
// --------------------------------------------------------------------------------------------
const schemaModificationInfo = buildStructuredType({
    name: "ModificationInfo",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ModificationTime",

            fieldType: "DateTime",
        },
        {
            name: "UpdateType",

            fieldType: "HistoryUpdateType",
        },
        {
            name: "UserName",

            fieldType: "String",
        },
    ]
});
export interface ModificationInfoOptions {
    modificationTime?: DateTime ;
    updateType?: HistoryUpdateType;
    userName?: UAString ;
}
export class ModificationInfo extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaModificationInfo; }
    public static possibleFields: string[] = [
          "modificationTime",
           "updateType",
           "userName"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(11216, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(11226, 0);
    public static encodingDefaultXml = makeExpandedNodeId(11218, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15271, 0);
    public modificationTime: DateTime;
    public updateType: HistoryUpdateType;
    public userName: UAString;

    constructor(options?: ModificationInfoOptions | null) {

        super(options);

        if (options === null) {
            this.modificationTime = new Date();
             this.updateType =  0 as  HistoryUpdateType;
            this.userName = null;
              return;
        }
        const schema = ModificationInfo.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ModificationInfoOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.modificationTime = initialize_field(schema.fields[0], options?.modificationTime);
        this.updateType = this.setUpdateType(initialize_field(schema.fields[1], options?.updateType));
        this.userName = initialize_field(schema.fields[2], options?.userName);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeDateTime(this.modificationTime, stream);
        encodeHistoryUpdateType(this.updateType, stream);
        encodeString(this.userName, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.modificationTime = decodeDateTime(stream, this.modificationTime);
        this.updateType = decodeHistoryUpdateType(stream, this.updateType);
        this.userName = decodeString(stream, this.userName);
    }

    // Define Enumeration setters
    public setUpdateType(value: any): HistoryUpdateType {
        const coercedValue = _enumerationHistoryUpdateType.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to HistoryUpdateType :" + value);
        }
        this.updateType = coercedValue.value as HistoryUpdateType;
        return this.updateType;
    }
    public get schema(): IStructuredTypeSchema { return schemaModificationInfo; }
}
ModificationInfo.schema.dataTypeNodeId = ModificationInfo.dataTypeNodeId;
ModificationInfo.schema.encodingDefaultBinary = ModificationInfo.encodingDefaultBinary;
ModificationInfo.schema.encodingDefaultXml = ModificationInfo.encodingDefaultXml;
ModificationInfo.schema.encodingDefaultJson = ModificationInfo.encodingDefaultJson;
registerClassDefinition( ModificationInfo.dataTypeNodeId, "ModificationInfo", ModificationInfo);
// --------------------------------------------------------------------------------------------
const schemaHistoryModifiedData = buildStructuredType({
    name: "HistoryModifiedData",

    baseType: "HistoryData",
    fields: [
        {
            name: "ModificationInfos",

            fieldType: "ModificationInfo",
            isArray: true
        },
    ]
});
export interface HistoryModifiedDataOptions extends HistoryDataOptions {
    modificationInfos?: ModificationInfoOptions [] | null;
}
export class HistoryModifiedData extends HistoryData {
    public static get schema(): IStructuredTypeSchema { return schemaHistoryModifiedData; }
    public static possibleFields: string[] = [
          "dataValues",
           "modificationInfos"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(11217, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(11227, 0);
    public static encodingDefaultXml = makeExpandedNodeId(11219, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15272, 0);
    public modificationInfos: ModificationInfo[] | null;

    constructor(options?: HistoryModifiedDataOptions | null) {

        super(options);

        if (options === null) {
         this.modificationInfos =  null; /* null array */
              return;
        }
        const schema = HistoryModifiedData.schema;
        options = (schema.constructHook ? schema.constructHook(options) as HistoryModifiedDataOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.modificationInfos = []; // should default
        if (options.modificationInfos) {
            assert(Array.isArray(options.modificationInfos));
            this.modificationInfos = options.modificationInfos.map((e: any) => new ModificationInfo(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeArray(this.modificationInfos, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.modificationInfos = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new ModificationInfo(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaHistoryModifiedData; }
}
HistoryModifiedData.schema.dataTypeNodeId = HistoryModifiedData.dataTypeNodeId;
HistoryModifiedData.schema.encodingDefaultBinary = HistoryModifiedData.encodingDefaultBinary;
HistoryModifiedData.schema.encodingDefaultXml = HistoryModifiedData.encodingDefaultXml;
HistoryModifiedData.schema.encodingDefaultJson = HistoryModifiedData.encodingDefaultJson;
registerClassDefinition( HistoryModifiedData.dataTypeNodeId, "HistoryModifiedData", HistoryModifiedData);
// --------------------------------------------------------------------------------------------
const schemaHistoryModifiedEvent = buildStructuredType({
    name: "HistoryModifiedEvent",

    baseType: "HistoryEvent",
    fields: [
        {
            name: "ModificationInfos",

            fieldType: "ModificationInfo",
            isArray: true
        },
    ]
});
export interface HistoryModifiedEventOptions extends HistoryEventOptions {
    modificationInfos?: ModificationInfoOptions [] | null;
}
export class HistoryModifiedEvent extends HistoryEvent {
    public static get schema(): IStructuredTypeSchema { return schemaHistoryModifiedEvent; }
    public static possibleFields: string[] = [
          "events",
           "modificationInfos"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(32824, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(32825, 0);
    public static encodingDefaultXml = makeExpandedNodeId(32829, 0);
    public static encodingDefaultJson = makeExpandedNodeId(32833, 0);
    public modificationInfos: ModificationInfo[] | null;

    constructor(options?: HistoryModifiedEventOptions | null) {

        super(options);

        if (options === null) {
         this.modificationInfos =  null; /* null array */
              return;
        }
        const schema = HistoryModifiedEvent.schema;
        options = (schema.constructHook ? schema.constructHook(options) as HistoryModifiedEventOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.modificationInfos = []; // should default
        if (options.modificationInfos) {
            assert(Array.isArray(options.modificationInfos));
            this.modificationInfos = options.modificationInfos.map((e: any) => new ModificationInfo(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeArray(this.modificationInfos, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.modificationInfos = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new ModificationInfo(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaHistoryModifiedEvent; }
}
HistoryModifiedEvent.schema.dataTypeNodeId = HistoryModifiedEvent.dataTypeNodeId;
HistoryModifiedEvent.schema.encodingDefaultBinary = HistoryModifiedEvent.encodingDefaultBinary;
HistoryModifiedEvent.schema.encodingDefaultXml = HistoryModifiedEvent.encodingDefaultXml;
HistoryModifiedEvent.schema.encodingDefaultJson = HistoryModifiedEvent.encodingDefaultJson;
registerClassDefinition( HistoryModifiedEvent.dataTypeNodeId, "HistoryModifiedEvent", HistoryModifiedEvent);
// --------------------------------------------------------------------------------------------
const schemaHistoryReadDetails = buildStructuredType({
    name: "HistoryReadDetails",

    baseType: "ExtensionObject",
    fields: [
    ]
});
export interface HistoryReadDetailsOptions {
}
export class HistoryReadDetails extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaHistoryReadDetails; }
    public static possibleFields: string[] = [
          
    ];
    public static dataTypeNodeId = makeExpandedNodeId(641, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(643, 0);
    public static encodingDefaultXml = makeExpandedNodeId(642, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15261, 0);

    constructor(options?: HistoryReadDetailsOptions | null) {

        super(options);

        if (options === null) {
              return;
        }
        const schema = HistoryReadDetails.schema;
        options = (schema.constructHook ? schema.constructHook(options) as HistoryReadDetailsOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaHistoryReadDetails; }
}
HistoryReadDetails.schema.dataTypeNodeId = HistoryReadDetails.dataTypeNodeId;
HistoryReadDetails.schema.encodingDefaultBinary = HistoryReadDetails.encodingDefaultBinary;
HistoryReadDetails.schema.encodingDefaultXml = HistoryReadDetails.encodingDefaultXml;
HistoryReadDetails.schema.encodingDefaultJson = HistoryReadDetails.encodingDefaultJson;
registerClassDefinition( HistoryReadDetails.dataTypeNodeId, "HistoryReadDetails", HistoryReadDetails);
// --------------------------------------------------------------------------------------------
const schemaHistoryReadValueId = buildStructuredType({
    name: "HistoryReadValueId",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "NodeId",

            fieldType: "NodeId",
        },
        {
            name: "IndexRange",

            fieldType: "NumericRange",
        },
        {
            name: "DataEncoding",

            fieldType: "QualifiedName",
        },
        {
            name: "ContinuationPoint",

            fieldType: "ByteString",
        },
    ]
});
export interface HistoryReadValueIdOptions {
    nodeId?: (NodeIdLike | null);
    indexRange?: NumericRange ;
    dataEncoding?: (QualifiedNameLike | null);
    continuationPoint?: ByteString ;
}
export class HistoryReadValueId extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaHistoryReadValueId; }
    public static possibleFields: string[] = [
          "nodeId",
           "indexRange",
           "dataEncoding",
           "continuationPoint"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(635, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(637, 0);
    public static encodingDefaultXml = makeExpandedNodeId(636, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15259, 0);
    public nodeId: NodeId;
    public indexRange: NumericRange;
    public dataEncoding: QualifiedName;
    public continuationPoint: ByteString;

    constructor(options?: HistoryReadValueIdOptions | null) {

        super(options);

        if (options === null) {
            this.nodeId = new NodeId(null);
            this.indexRange = new NumericRange(null);
            this.dataEncoding = new QualifiedName(null);
            this.continuationPoint = Buffer.alloc(0);
              return;
        }
        const schema = HistoryReadValueId.schema;
        options = (schema.constructHook ? schema.constructHook(options) as HistoryReadValueIdOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.nodeId = initialize_field(schema.fields[0], options?.nodeId);
        this.indexRange = initialize_field(schema.fields[1], options?.indexRange);
        this.dataEncoding = initialize_field(schema.fields[2], options?.dataEncoding);
        this.continuationPoint = initialize_field(schema.fields[3], options?.continuationPoint);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.nodeId, stream);
        encodeNumericRange(this.indexRange, stream);
        encodeQualifiedName(this.dataEncoding, stream);
        encodeByteString(this.continuationPoint, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.nodeId = decodeNodeId(stream, this.nodeId);
        this.indexRange = decodeNumericRange(stream, this.indexRange);
        this.dataEncoding = decodeQualifiedName(stream, this.dataEncoding);
        this.continuationPoint = decodeByteString(stream, this.continuationPoint);
    }
    public get schema(): IStructuredTypeSchema { return schemaHistoryReadValueId; }
}
HistoryReadValueId.schema.dataTypeNodeId = HistoryReadValueId.dataTypeNodeId;
HistoryReadValueId.schema.encodingDefaultBinary = HistoryReadValueId.encodingDefaultBinary;
HistoryReadValueId.schema.encodingDefaultXml = HistoryReadValueId.encodingDefaultXml;
HistoryReadValueId.schema.encodingDefaultJson = HistoryReadValueId.encodingDefaultJson;
registerClassDefinition( HistoryReadValueId.dataTypeNodeId, "HistoryReadValueId", HistoryReadValueId);
// --------------------------------------------------------------------------------------------
const schemaHistoryReadRequest = buildStructuredType({
    name: "HistoryReadRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
        {
            name: "HistoryReadDetails",

            fieldType: "ExtensionObject",
        },
        {
            name: "TimestampsToReturn",

            fieldType: "TimestampsToReturn",
        },
        {
            name: "ReleaseContinuationPoints",

            fieldType: "Boolean",
        },
        {
            name: "NodesToRead",

            fieldType: "HistoryReadValueId",
            isArray: true
        },
    ]
});
export interface HistoryReadRequestOptions {
    requestHeader?: RequestHeaderOptions ;
    historyReadDetails?: (ExtensionObject | null);
    timestampsToReturn?: TimestampsToReturn;
    releaseContinuationPoints?: UABoolean ;
    nodesToRead?: HistoryReadValueIdOptions [] | null;
}
export class HistoryReadRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaHistoryReadRequest; }
    public static possibleFields: string[] = [
          "requestHeader",
           "historyReadDetails",
           "timestampsToReturn",
           "releaseContinuationPoints",
           "nodesToRead"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(662, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(664, 0);
    public static encodingDefaultXml = makeExpandedNodeId(663, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15274, 0);
    public requestHeader: RequestHeader;
    public historyReadDetails: (ExtensionObject | null);
    public timestampsToReturn: TimestampsToReturn;
    public releaseContinuationPoints: UABoolean;
    public nodesToRead: HistoryReadValueId[] | null;

    constructor(options?: HistoryReadRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
            this.historyReadDetails = null;
             this.timestampsToReturn =  0 as  TimestampsToReturn;
            this.releaseContinuationPoints = false;
         this.nodesToRead =  null; /* null array */
              return;
        }
        const schema = HistoryReadRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as HistoryReadRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
        this.historyReadDetails = initialize_field(schema.fields[1], options?.historyReadDetails);
        this.timestampsToReturn = this.setTimestampsToReturn(initialize_field(schema.fields[2], options?.timestampsToReturn));
        this.releaseContinuationPoints = initialize_field(schema.fields[3], options?.releaseContinuationPoints);
        this.nodesToRead = []; // should default
        if (options.nodesToRead) {
            assert(Array.isArray(options.nodesToRead));
            this.nodesToRead = options.nodesToRead.map((e: any) => new HistoryReadValueId(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        encodeExtensionObject(this.historyReadDetails, stream);
        encodeTimestampsToReturn(this.timestampsToReturn, stream);
        encodeBoolean(this.releaseContinuationPoints, stream);
        encodeArray(this.nodesToRead, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.historyReadDetails = decodeExtensionObject(stream, this.historyReadDetails);
        this.timestampsToReturn = decodeTimestampsToReturn(stream, this.timestampsToReturn);
        this.releaseContinuationPoints = decodeBoolean(stream, this.releaseContinuationPoints);
        this.nodesToRead = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new HistoryReadValueId(null);
            obj.decode(stream1);
            return obj;
        });
    }

    // Define Enumeration setters
    public setTimestampsToReturn(value: any): TimestampsToReturn {
        const coercedValue = _enumerationTimestampsToReturn.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to TimestampsToReturn :" + value);
        }
        this.timestampsToReturn = coercedValue.value as TimestampsToReturn;
        return this.timestampsToReturn;
    }
    public get schema(): IStructuredTypeSchema { return schemaHistoryReadRequest; }
}
HistoryReadRequest.schema.dataTypeNodeId = HistoryReadRequest.dataTypeNodeId;
HistoryReadRequest.schema.encodingDefaultBinary = HistoryReadRequest.encodingDefaultBinary;
HistoryReadRequest.schema.encodingDefaultXml = HistoryReadRequest.encodingDefaultXml;
HistoryReadRequest.schema.encodingDefaultJson = HistoryReadRequest.encodingDefaultJson;
registerClassDefinition( HistoryReadRequest.dataTypeNodeId, "HistoryReadRequest", HistoryReadRequest);
// --------------------------------------------------------------------------------------------
const schemaHistoryReadResult = buildStructuredType({
    name: "HistoryReadResult",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "StatusCode",

            fieldType: "StatusCode",
        },
        {
            name: "ContinuationPoint",

            fieldType: "ByteString",
        },
        {
            name: "HistoryData",

            fieldType: "ExtensionObject",
        },
    ]
});
export interface HistoryReadResultOptions {
    statusCode?: StatusCode ;
    continuationPoint?: ByteString ;
    historyData?: (ExtensionObject | null);
}
export class HistoryReadResult extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaHistoryReadResult; }
    public static possibleFields: string[] = [
          "statusCode",
           "continuationPoint",
           "historyData"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(638, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(640, 0);
    public static encodingDefaultXml = makeExpandedNodeId(639, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15260, 0);
    public statusCode: StatusCode;
    public continuationPoint: ByteString;
    public historyData: (ExtensionObject | null);

    constructor(options?: HistoryReadResultOptions | null) {

        super(options);

        if (options === null) {
            this.statusCode = StatusCodes.Good;
            this.continuationPoint = Buffer.alloc(0);
            this.historyData = null;
              return;
        }
        const schema = HistoryReadResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) as HistoryReadResultOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.statusCode = initialize_field(schema.fields[0], options?.statusCode);
        this.continuationPoint = initialize_field(schema.fields[1], options?.continuationPoint);
        this.historyData = initialize_field(schema.fields[2], options?.historyData);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeStatusCode(this.statusCode, stream);
        encodeByteString(this.continuationPoint, stream);
        encodeExtensionObject(this.historyData, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.statusCode = decodeStatusCode(stream, this.statusCode);
        this.continuationPoint = decodeByteString(stream, this.continuationPoint);
        this.historyData = decodeExtensionObject(stream, this.historyData);
    }
    public get schema(): IStructuredTypeSchema { return schemaHistoryReadResult; }
}
HistoryReadResult.schema.dataTypeNodeId = HistoryReadResult.dataTypeNodeId;
HistoryReadResult.schema.encodingDefaultBinary = HistoryReadResult.encodingDefaultBinary;
HistoryReadResult.schema.encodingDefaultXml = HistoryReadResult.encodingDefaultXml;
HistoryReadResult.schema.encodingDefaultJson = HistoryReadResult.encodingDefaultJson;
registerClassDefinition( HistoryReadResult.dataTypeNodeId, "HistoryReadResult", HistoryReadResult);
// --------------------------------------------------------------------------------------------
const schemaHistoryReadResponse = buildStructuredType({
    name: "HistoryReadResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
        {
            name: "Results",

            fieldType: "HistoryReadResult",
            isArray: true
        },
        {
            name: "DiagnosticInfos",

            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
export interface HistoryReadResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
    results?: HistoryReadResultOptions [] | null;
    diagnosticInfos?: (DiagnosticInfo | null)[] | null;
}
export class HistoryReadResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaHistoryReadResponse; }
    public static possibleFields: string[] = [
          "responseHeader",
           "results",
           "diagnosticInfos"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(665, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(667, 0);
    public static encodingDefaultXml = makeExpandedNodeId(666, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15275, 0);
    public responseHeader: ResponseHeader;
    public results: HistoryReadResult[] | null;
    public diagnosticInfos: (DiagnosticInfo | null)[] | null;

    constructor(options?: HistoryReadResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
         this.results =  null; /* null array */
            this.diagnosticInfos = []
              return;
        }
        const schema = HistoryReadResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as HistoryReadResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
        this.results = []; // should default
        if (options.results) {
            assert(Array.isArray(options.results));
            this.results = options.results.map((e: any) => new HistoryReadResult(e));
        }
        this.diagnosticInfos = initialize_field_array(schema.fields[2], options?.diagnosticInfos);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        encodeArray(this.results, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.diagnosticInfos, stream, encodeDiagnosticInfo);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new HistoryReadResult(null);
            obj.decode(stream1);
            return obj;
        });
        this.diagnosticInfos = decodeArray(stream, decodeDiagnosticInfo);
    }
    public get schema(): IStructuredTypeSchema { return schemaHistoryReadResponse; }
}
HistoryReadResponse.schema.dataTypeNodeId = HistoryReadResponse.dataTypeNodeId;
HistoryReadResponse.schema.encodingDefaultBinary = HistoryReadResponse.encodingDefaultBinary;
HistoryReadResponse.schema.encodingDefaultXml = HistoryReadResponse.encodingDefaultXml;
HistoryReadResponse.schema.encodingDefaultJson = HistoryReadResponse.encodingDefaultJson;
registerClassDefinition( HistoryReadResponse.dataTypeNodeId, "HistoryReadResponse", HistoryReadResponse);
// --------------------------------------------------------------------------------------------
const schemaHistoryUpdateRequest = buildStructuredType({
    name: "HistoryUpdateRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
        {
            name: "HistoryUpdateDetails",

            fieldType: "ExtensionObject",
            isArray: true
        },
    ]
});
export interface HistoryUpdateRequestOptions {
    requestHeader?: RequestHeaderOptions ;
    historyUpdateDetails?: (ExtensionObject | null)[] | null;
}
export class HistoryUpdateRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaHistoryUpdateRequest; }
    public static possibleFields: string[] = [
          "requestHeader",
           "historyUpdateDetails"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(698, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(700, 0);
    public static encodingDefaultXml = makeExpandedNodeId(699, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15287, 0);
    public requestHeader: RequestHeader;
    public historyUpdateDetails: (ExtensionObject | null)[] | null;

    constructor(options?: HistoryUpdateRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
            this.historyUpdateDetails = []
              return;
        }
        const schema = HistoryUpdateRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as HistoryUpdateRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
        this.historyUpdateDetails = initialize_field_array(schema.fields[1], options?.historyUpdateDetails);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        encodeArray(this.historyUpdateDetails, stream, encodeExtensionObject);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.historyUpdateDetails = decodeArray(stream, decodeExtensionObject);
    }
    public get schema(): IStructuredTypeSchema { return schemaHistoryUpdateRequest; }
}
HistoryUpdateRequest.schema.dataTypeNodeId = HistoryUpdateRequest.dataTypeNodeId;
HistoryUpdateRequest.schema.encodingDefaultBinary = HistoryUpdateRequest.encodingDefaultBinary;
HistoryUpdateRequest.schema.encodingDefaultXml = HistoryUpdateRequest.encodingDefaultXml;
HistoryUpdateRequest.schema.encodingDefaultJson = HistoryUpdateRequest.encodingDefaultJson;
registerClassDefinition( HistoryUpdateRequest.dataTypeNodeId, "HistoryUpdateRequest", HistoryUpdateRequest);
// --------------------------------------------------------------------------------------------
const schemaHistoryUpdateResult = buildStructuredType({
    name: "HistoryUpdateResult",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "StatusCode",

            fieldType: "StatusCode",
        },
        {
            name: "OperationResults",

            fieldType: "StatusCode",
            isArray: true
        },
        {
            name: "DiagnosticInfos",

            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
export interface HistoryUpdateResultOptions {
    statusCode?: StatusCode ;
    operationResults?: StatusCode [] | null;
    diagnosticInfos?: (DiagnosticInfo | null)[] | null;
}
export class HistoryUpdateResult extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaHistoryUpdateResult; }
    public static possibleFields: string[] = [
          "statusCode",
           "operationResults",
           "diagnosticInfos"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(695, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(697, 0);
    public static encodingDefaultXml = makeExpandedNodeId(696, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15286, 0);
    public statusCode: StatusCode;
    public operationResults: StatusCode[] | null;
    public diagnosticInfos: (DiagnosticInfo | null)[] | null;

    constructor(options?: HistoryUpdateResultOptions | null) {

        super(options);

        if (options === null) {
            this.statusCode = StatusCodes.Good;
            this.operationResults = []
            this.diagnosticInfos = []
              return;
        }
        const schema = HistoryUpdateResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) as HistoryUpdateResultOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.statusCode = initialize_field(schema.fields[0], options?.statusCode);
        this.operationResults = initialize_field_array(schema.fields[1], options?.operationResults);
        this.diagnosticInfos = initialize_field_array(schema.fields[2], options?.diagnosticInfos);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeStatusCode(this.statusCode, stream);
        encodeArray(this.operationResults, stream, encodeStatusCode);
        encodeArray(this.diagnosticInfos, stream, encodeDiagnosticInfo);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.statusCode = decodeStatusCode(stream, this.statusCode);
        this.operationResults = decodeArray(stream, decodeStatusCode);
        this.diagnosticInfos = decodeArray(stream, decodeDiagnosticInfo);
    }
    public get schema(): IStructuredTypeSchema { return schemaHistoryUpdateResult; }
}
HistoryUpdateResult.schema.dataTypeNodeId = HistoryUpdateResult.dataTypeNodeId;
HistoryUpdateResult.schema.encodingDefaultBinary = HistoryUpdateResult.encodingDefaultBinary;
HistoryUpdateResult.schema.encodingDefaultXml = HistoryUpdateResult.encodingDefaultXml;
HistoryUpdateResult.schema.encodingDefaultJson = HistoryUpdateResult.encodingDefaultJson;
registerClassDefinition( HistoryUpdateResult.dataTypeNodeId, "HistoryUpdateResult", HistoryUpdateResult);
// --------------------------------------------------------------------------------------------
const schemaHistoryUpdateResponse = buildStructuredType({
    name: "HistoryUpdateResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
        {
            name: "Results",

            fieldType: "HistoryUpdateResult",
            isArray: true
        },
        {
            name: "DiagnosticInfos",

            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
export interface HistoryUpdateResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
    results?: HistoryUpdateResultOptions [] | null;
    diagnosticInfos?: (DiagnosticInfo | null)[] | null;
}
export class HistoryUpdateResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaHistoryUpdateResponse; }
    public static possibleFields: string[] = [
          "responseHeader",
           "results",
           "diagnosticInfos"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(701, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(703, 0);
    public static encodingDefaultXml = makeExpandedNodeId(702, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15288, 0);
    public responseHeader: ResponseHeader;
    public results: HistoryUpdateResult[] | null;
    public diagnosticInfos: (DiagnosticInfo | null)[] | null;

    constructor(options?: HistoryUpdateResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
         this.results =  null; /* null array */
            this.diagnosticInfos = []
              return;
        }
        const schema = HistoryUpdateResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as HistoryUpdateResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
        this.results = []; // should default
        if (options.results) {
            assert(Array.isArray(options.results));
            this.results = options.results.map((e: any) => new HistoryUpdateResult(e));
        }
        this.diagnosticInfos = initialize_field_array(schema.fields[2], options?.diagnosticInfos);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        encodeArray(this.results, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.diagnosticInfos, stream, encodeDiagnosticInfo);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new HistoryUpdateResult(null);
            obj.decode(stream1);
            return obj;
        });
        this.diagnosticInfos = decodeArray(stream, decodeDiagnosticInfo);
    }
    public get schema(): IStructuredTypeSchema { return schemaHistoryUpdateResponse; }
}
HistoryUpdateResponse.schema.dataTypeNodeId = HistoryUpdateResponse.dataTypeNodeId;
HistoryUpdateResponse.schema.encodingDefaultBinary = HistoryUpdateResponse.encodingDefaultBinary;
HistoryUpdateResponse.schema.encodingDefaultXml = HistoryUpdateResponse.encodingDefaultXml;
HistoryUpdateResponse.schema.encodingDefaultJson = HistoryUpdateResponse.encodingDefaultJson;
registerClassDefinition( HistoryUpdateResponse.dataTypeNodeId, "HistoryUpdateResponse", HistoryUpdateResponse);

// --------------------------------------------------------------------------------------------
export enum IdentityCriteriaType {
    UserName = 1,
    Thumbprint = 2,
    Role = 3,
    GroupId = 4,
    Anonymous = 5,
    AuthenticatedUser = 6,
    Application = 7,
    X509Subject = 8,
    TrustedApplication = 9,
    Invalid = 4294967295
}
const schemaIdentityCriteriaType = {
    enumValues: IdentityCriteriaType,
    flaggable: false,
    minValue: NaN,
    maxValue: NaN,
    name: "IdentityCriteriaType"
};
function decodeIdentityCriteriaType(stream: BinaryStream, _value?: IdentityCriteriaType): IdentityCriteriaType {
    let value =  stream.readUInt32() as IdentityCriteriaType;
    value = (value < schemaIdentityCriteriaType.minValue || value > schemaIdentityCriteriaType.maxValue) ? IdentityCriteriaType.Invalid : value; 
    return value;
}
function encodeIdentityCriteriaType(value: IdentityCriteriaType, stream: OutputBinaryStream): void {
    stream.writeUInt32(value);
}
export const _enumerationIdentityCriteriaType = registerEnumeration(schemaIdentityCriteriaType);
assert(_enumerationIdentityCriteriaType.isFlaggable ===  false);
// --------------------------------------------------------------------------------------------
const schemaIdentityMappingRuleType = buildStructuredType({
    name: "IdentityMappingRuleType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "CriteriaType",

            fieldType: "IdentityCriteriaType",
        },
        {
            name: "Criteria",

            fieldType: "String",
        },
    ]
});
export interface IdentityMappingRuleTypeOptions {
    criteriaType?: IdentityCriteriaType;
    criteria?: UAString ;
}
export class IdentityMappingRuleType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaIdentityMappingRuleType; }
    public static possibleFields: string[] = [
          "criteriaType",
           "criteria"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15634, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15736, 0);
    public static encodingDefaultXml = makeExpandedNodeId(15728, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15042, 0);
    public criteriaType: IdentityCriteriaType;
    public criteria: UAString;

    constructor(options?: IdentityMappingRuleTypeOptions | null) {

        super(options);

        if (options === null) {
             this.criteriaType =  0 as  IdentityCriteriaType;
            this.criteria = null;
              return;
        }
        const schema = IdentityMappingRuleType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as IdentityMappingRuleTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.criteriaType = this.setCriteriaType(initialize_field(schema.fields[0], options?.criteriaType));
        this.criteria = initialize_field(schema.fields[1], options?.criteria);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeIdentityCriteriaType(this.criteriaType, stream);
        encodeString(this.criteria, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.criteriaType = decodeIdentityCriteriaType(stream, this.criteriaType);
        this.criteria = decodeString(stream, this.criteria);
    }

    // Define Enumeration setters
    public setCriteriaType(value: any): IdentityCriteriaType {
        const coercedValue = _enumerationIdentityCriteriaType.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to IdentityCriteriaType :" + value);
        }
        this.criteriaType = coercedValue.value as IdentityCriteriaType;
        return this.criteriaType;
    }
    public get schema(): IStructuredTypeSchema { return schemaIdentityMappingRuleType; }
}
IdentityMappingRuleType.schema.dataTypeNodeId = IdentityMappingRuleType.dataTypeNodeId;
IdentityMappingRuleType.schema.encodingDefaultBinary = IdentityMappingRuleType.encodingDefaultBinary;
IdentityMappingRuleType.schema.encodingDefaultXml = IdentityMappingRuleType.encodingDefaultXml;
IdentityMappingRuleType.schema.encodingDefaultJson = IdentityMappingRuleType.encodingDefaultJson;
registerClassDefinition( IdentityMappingRuleType.dataTypeNodeId, "IdentityMappingRuleType", IdentityMappingRuleType);
// --------------------------------------------------------------------------------------------
const schemaIssuedIdentityToken = buildStructuredType({
    name: "IssuedIdentityToken",

    baseType: "UserIdentityToken",
    fields: [
        {
            name: "TokenData",

            fieldType: "ByteString",
        },
        {
            name: "EncryptionAlgorithm",

            fieldType: "String",
        },
    ]
});
export interface IssuedIdentityTokenOptions extends UserIdentityTokenOptions {
    tokenData?: ByteString ;
    encryptionAlgorithm?: UAString ;
}
export class IssuedIdentityToken extends UserIdentityToken {
    public static get schema(): IStructuredTypeSchema { return schemaIssuedIdentityToken; }
    public static possibleFields: string[] = [
          "policyId",
           "tokenData",
           "encryptionAlgorithm"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(938, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(940, 0);
    public static encodingDefaultXml = makeExpandedNodeId(939, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15144, 0);
    public tokenData: ByteString;
    public encryptionAlgorithm: UAString;

    constructor(options?: IssuedIdentityTokenOptions | null) {

        super(options);

        if (options === null) {
            this.tokenData = Buffer.alloc(0);
            this.encryptionAlgorithm = null;
              return;
        }
        const schema = IssuedIdentityToken.schema;
        options = (schema.constructHook ? schema.constructHook(options) as IssuedIdentityTokenOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.tokenData = initialize_field(schema.fields[0], options?.tokenData);
        this.encryptionAlgorithm = initialize_field(schema.fields[1], options?.encryptionAlgorithm);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeByteString(this.tokenData, stream);
        encodeString(this.encryptionAlgorithm, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.tokenData = decodeByteString(stream, this.tokenData);
        this.encryptionAlgorithm = decodeString(stream, this.encryptionAlgorithm);
    }
    public get schema(): IStructuredTypeSchema { return schemaIssuedIdentityToken; }
}
IssuedIdentityToken.schema.dataTypeNodeId = IssuedIdentityToken.dataTypeNodeId;
IssuedIdentityToken.schema.encodingDefaultBinary = IssuedIdentityToken.encodingDefaultBinary;
IssuedIdentityToken.schema.encodingDefaultXml = IssuedIdentityToken.encodingDefaultXml;
IssuedIdentityToken.schema.encodingDefaultJson = IssuedIdentityToken.encodingDefaultJson;
registerClassDefinition( IssuedIdentityToken.dataTypeNodeId, "IssuedIdentityToken", IssuedIdentityToken);
// --------------------------------------------------------------------------------------------
const schemaJsonActionMetaDataMessage = buildStructuredType({
    name: "JsonActionMetaDataMessage",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "MessageId",

            fieldType: "String",
        },
        {
            name: "MessageType",

            fieldType: "String",
        },
        {
            name: "PublisherId",

            fieldType: "String",
        },
        {
            name: "DataSetWriterId",

            fieldType: "UInt16",
        },
        {
            name: "DataSetWriterName",

            fieldType: "String",
        },
        {
            name: "Timestamp",

            fieldType: "DateTime",
        },
        {
            name: "ActionTargets",

            fieldType: "ActionTargetDataType",
            isArray: true
        },
        {
            name: "Request",

            fieldType: "DataSetMetaDataType",
        },
        {
            name: "Response",

            fieldType: "DataSetMetaDataType",
        },
        {
            name: "ActionMethods",

            fieldType: "ActionMethodDataType",
            isArray: true
        },
    ]
});
export interface JsonActionMetaDataMessageOptions {
    messageId?: UAString ;
    messageType?: UAString ;
    publisherId?: UAString ;
    dataSetWriterId?: UInt16 ;
    dataSetWriterName?: UAString ;
    timestamp?: DateTime ;
    actionTargets?: ActionTargetDataTypeOptions [] | null;
    request?: DataSetMetaDataTypeOptions ;
    response?: DataSetMetaDataTypeOptions ;
    actionMethods?: ActionMethodDataTypeOptions [] | null;
}
export class JsonActionMetaDataMessage extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaJsonActionMetaDataMessage; }
    public static possibleFields: string[] = [
          "messageId",
           "messageType",
           "publisherId",
           "dataSetWriterId",
           "dataSetWriterName",
           "timestamp",
           "actionTargets",
           "request",
           "response",
           "actionMethods"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(0, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(0, 0);
    public static encodingDefaultXml = makeExpandedNodeId(0, 0);
    public static encodingDefaultJson = makeExpandedNodeId(0, 0);
    public messageId: UAString;
    public messageType: UAString;
    public publisherId: UAString;
    public dataSetWriterId: UInt16;
    public dataSetWriterName: UAString;
    public timestamp: DateTime;
    public actionTargets: ActionTargetDataType[] | null;
    public request: DataSetMetaDataType;
    public response: DataSetMetaDataType;
    public actionMethods: ActionMethodDataType[] | null;

    constructor(options?: JsonActionMetaDataMessageOptions | null) {

        super(options);

        if (options === null) {
            this.messageId = null;
            this.messageType = null;
            this.publisherId = null;
            this.dataSetWriterId = 0;
            this.dataSetWriterName = null;
            this.timestamp = new Date();
         this.actionTargets =  null; /* null array */
         this.request =  new DataSetMetaDataType(null);
         this.response =  new DataSetMetaDataType(null);
         this.actionMethods =  null; /* null array */
              return;
        }
        const schema = JsonActionMetaDataMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) as JsonActionMetaDataMessageOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.messageId = initialize_field(schema.fields[0], options?.messageId);
        this.messageType = initialize_field(schema.fields[1], options?.messageType);
        this.publisherId = initialize_field(schema.fields[2], options?.publisherId);
        this.dataSetWriterId = initialize_field(schema.fields[3], options?.dataSetWriterId);
        this.dataSetWriterName = initialize_field(schema.fields[4], options?.dataSetWriterName);
        this.timestamp = initialize_field(schema.fields[5], options?.timestamp);
        this.actionTargets = []; // should default
        if (options.actionTargets) {
            assert(Array.isArray(options.actionTargets));
            this.actionTargets = options.actionTargets.map((e: any) => new ActionTargetDataType(e));
        }
        this.request  =  new DataSetMetaDataType(options.request);
        this.response  =  new DataSetMetaDataType(options.response);
        this.actionMethods = []; // should default
        if (options.actionMethods) {
            assert(Array.isArray(options.actionMethods));
            this.actionMethods = options.actionMethods.map((e: any) => new ActionMethodDataType(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.messageId, stream);
        encodeString(this.messageType, stream);
        encodeString(this.publisherId, stream);
        encodeUInt16(this.dataSetWriterId, stream);
        encodeString(this.dataSetWriterName, stream);
        encodeDateTime(this.timestamp, stream);
        encodeArray(this.actionTargets, stream, (obj, stream1) => { obj.encode(stream1); });
        this.request.encode(stream);
        this.response.encode(stream);
        encodeArray(this.actionMethods, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.messageId = decodeString(stream, this.messageId);
        this.messageType = decodeString(stream, this.messageType);
        this.publisherId = decodeString(stream, this.publisherId);
        this.dataSetWriterId = decodeUInt16(stream, this.dataSetWriterId);
        this.dataSetWriterName = decodeString(stream, this.dataSetWriterName);
        this.timestamp = decodeDateTime(stream, this.timestamp);
        this.actionTargets = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new ActionTargetDataType(null);
            obj.decode(stream1);
            return obj;
        });
        this.request.decode(stream);
        this.response.decode(stream);
        this.actionMethods = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new ActionMethodDataType(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaJsonActionMetaDataMessage; }
}
JsonActionMetaDataMessage.schema.dataTypeNodeId = JsonActionMetaDataMessage.dataTypeNodeId;
JsonActionMetaDataMessage.schema.encodingDefaultBinary = JsonActionMetaDataMessage.encodingDefaultBinary;
JsonActionMetaDataMessage.schema.encodingDefaultXml = JsonActionMetaDataMessage.encodingDefaultXml;
JsonActionMetaDataMessage.schema.encodingDefaultJson = JsonActionMetaDataMessage.encodingDefaultJson;
registerClassDefinition( JsonActionMetaDataMessage.dataTypeNodeId, "JsonActionMetaDataMessage", JsonActionMetaDataMessage);
// --------------------------------------------------------------------------------------------
const schemaJsonActionNetworkMessage = buildStructuredType({
    name: "JsonActionNetworkMessage",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "MessageId",

            fieldType: "String",
        },
        {
            name: "MessageType",

            fieldType: "String",
        },
        {
            name: "PublisherId",

            fieldType: "String",
        },
        {
            name: "Timestamp",

            fieldType: "DateTime",
        },
        {
            name: "ResponseAddress",

            fieldType: "String",
        },
        {
            name: "CorrelationData",

            fieldType: "ByteString",
        },
        {
            name: "RequestorId",

            fieldType: "String",
        },
        {
            name: "TimeoutHint",

            fieldType: "Double",
        },
        {
            name: "Messages",

            fieldType: "ExtensionObject",
            isArray: true
        },
    ]
});
export interface JsonActionNetworkMessageOptions {
    messageId?: UAString ;
    messageType?: UAString ;
    publisherId?: UAString ;
    timestamp?: DateTime ;
    responseAddress?: UAString ;
    correlationData?: ByteString ;
    requestorId?: UAString ;
    timeoutHint?: Double ;
    messages?: (ExtensionObject | null)[] | null;
}
export class JsonActionNetworkMessage extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaJsonActionNetworkMessage; }
    public static possibleFields: string[] = [
          "messageId",
           "messageType",
           "publisherId",
           "timestamp",
           "responseAddress",
           "correlationData",
           "requestorId",
           "timeoutHint",
           "messages"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(0, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(0, 0);
    public static encodingDefaultXml = makeExpandedNodeId(0, 0);
    public static encodingDefaultJson = makeExpandedNodeId(0, 0);
    public messageId: UAString;
    public messageType: UAString;
    public publisherId: UAString;
    public timestamp: DateTime;
    public responseAddress: UAString;
    public correlationData: ByteString;
    public requestorId: UAString;
    public timeoutHint: Double;
    public messages: (ExtensionObject | null)[] | null;

    constructor(options?: JsonActionNetworkMessageOptions | null) {

        super(options);

        if (options === null) {
            this.messageId = null;
            this.messageType = null;
            this.publisherId = null;
            this.timestamp = new Date();
            this.responseAddress = null;
            this.correlationData = Buffer.alloc(0);
            this.requestorId = null;
            this.timeoutHint = 0;
            this.messages = []
              return;
        }
        const schema = JsonActionNetworkMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) as JsonActionNetworkMessageOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.messageId = initialize_field(schema.fields[0], options?.messageId);
        this.messageType = initialize_field(schema.fields[1], options?.messageType);
        this.publisherId = initialize_field(schema.fields[2], options?.publisherId);
        this.timestamp = initialize_field(schema.fields[3], options?.timestamp);
        this.responseAddress = initialize_field(schema.fields[4], options?.responseAddress);
        this.correlationData = initialize_field(schema.fields[5], options?.correlationData);
        this.requestorId = initialize_field(schema.fields[6], options?.requestorId);
        this.timeoutHint = initialize_field(schema.fields[7], options?.timeoutHint);
        this.messages = initialize_field_array(schema.fields[8], options?.messages);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.messageId, stream);
        encodeString(this.messageType, stream);
        encodeString(this.publisherId, stream);
        encodeDateTime(this.timestamp, stream);
        encodeString(this.responseAddress, stream);
        encodeByteString(this.correlationData, stream);
        encodeString(this.requestorId, stream);
        encodeDouble(this.timeoutHint, stream);
        encodeArray(this.messages, stream, encodeExtensionObject);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.messageId = decodeString(stream, this.messageId);
        this.messageType = decodeString(stream, this.messageType);
        this.publisherId = decodeString(stream, this.publisherId);
        this.timestamp = decodeDateTime(stream, this.timestamp);
        this.responseAddress = decodeString(stream, this.responseAddress);
        this.correlationData = decodeByteString(stream, this.correlationData);
        this.requestorId = decodeString(stream, this.requestorId);
        this.timeoutHint = decodeDouble(stream, this.timeoutHint);
        this.messages = decodeArray(stream, decodeExtensionObject);
    }
    public get schema(): IStructuredTypeSchema { return schemaJsonActionNetworkMessage; }
}
JsonActionNetworkMessage.schema.dataTypeNodeId = JsonActionNetworkMessage.dataTypeNodeId;
JsonActionNetworkMessage.schema.encodingDefaultBinary = JsonActionNetworkMessage.encodingDefaultBinary;
JsonActionNetworkMessage.schema.encodingDefaultXml = JsonActionNetworkMessage.encodingDefaultXml;
JsonActionNetworkMessage.schema.encodingDefaultJson = JsonActionNetworkMessage.encodingDefaultJson;
registerClassDefinition( JsonActionNetworkMessage.dataTypeNodeId, "JsonActionNetworkMessage", JsonActionNetworkMessage);

// --------------------------------------------------------------------------------------------
export enum ActionState {
    Idle = 0,
    Executing = 1,
    Done = 2,
    Invalid = 4294967295
}
const schemaActionState = {
    enumValues: ActionState,
    flaggable: false,
    minValue: 0,
    maxValue: 2,
    name: "ActionState"
};
function decodeActionState(stream: BinaryStream, _value?: ActionState): ActionState {
    let value =  stream.readUInt32() as ActionState;
    value = (value < schemaActionState.minValue || value > schemaActionState.maxValue) ? ActionState.Invalid : value; 
    return value;
}
function encodeActionState(value: ActionState, stream: OutputBinaryStream): void {
    stream.writeUInt32(value);
}
export const _enumerationActionState = registerEnumeration(schemaActionState);
assert(_enumerationActionState.isFlaggable ===  false);
// --------------------------------------------------------------------------------------------
const schemaJsonActionRequestMessage = buildStructuredType({
    name: "JsonActionRequestMessage",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "DataSetWriterId",

            fieldType: "UInt16",
        },
        {
            name: "ActionTargetId",

            fieldType: "UInt16",
        },
        {
            name: "DataSetWriterName",

            fieldType: "String",
        },
        {
            name: "WriterGroupName",

            fieldType: "String",
        },
        {
            name: "MetaDataVersion",

            fieldType: "ConfigurationVersionDataType",
        },
        {
            name: "MinorVersion",

            fieldType: "UInt32",
        },
        {
            name: "Timestamp",

            fieldType: "DateTime",
        },
        {
            name: "MessageType",

            fieldType: "String",
        },
        {
            name: "RequestId",

            fieldType: "UInt16",
        },
        {
            name: "ActionState",

            fieldType: "ActionState",
        },
        {
            name: "Payload",

            fieldType: "ExtensionObject",
        },
    ]
});
export interface JsonActionRequestMessageOptions {
    dataSetWriterId?: UInt16 ;
    actionTargetId?: UInt16 ;
    dataSetWriterName?: UAString ;
    writerGroupName?: UAString ;
    metaDataVersion?: ConfigurationVersionDataTypeOptions ;
    minorVersion?: UInt32 ;
    timestamp?: DateTime ;
    messageType?: UAString ;
    requestId?: UInt16 ;
    actionState?: ActionState;
    payload?: (ExtensionObject | null);
}
export class JsonActionRequestMessage extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaJsonActionRequestMessage; }
    public static possibleFields: string[] = [
          "dataSetWriterId",
           "actionTargetId",
           "dataSetWriterName",
           "writerGroupName",
           "metaDataVersion",
           "minorVersion",
           "timestamp",
           "messageType",
           "requestId",
           "actionState",
           "payload"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(0, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(0, 0);
    public static encodingDefaultXml = makeExpandedNodeId(0, 0);
    public static encodingDefaultJson = makeExpandedNodeId(0, 0);
    public dataSetWriterId: UInt16;
    public actionTargetId: UInt16;
    public dataSetWriterName: UAString;
    public writerGroupName: UAString;
    public metaDataVersion: ConfigurationVersionDataType;
    public minorVersion: UInt32;
    public timestamp: DateTime;
    public messageType: UAString;
    public requestId: UInt16;
    public actionState: ActionState;
    public payload: (ExtensionObject | null);

    constructor(options?: JsonActionRequestMessageOptions | null) {

        super(options);

        if (options === null) {
            this.dataSetWriterId = 0;
            this.actionTargetId = 0;
            this.dataSetWriterName = null;
            this.writerGroupName = null;
         this.metaDataVersion =  new ConfigurationVersionDataType(null);
            this.minorVersion = 0;
            this.timestamp = new Date();
            this.messageType = null;
            this.requestId = 0;
             this.actionState =  0 as  ActionState;
            this.payload = null;
              return;
        }
        const schema = JsonActionRequestMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) as JsonActionRequestMessageOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.dataSetWriterId = initialize_field(schema.fields[0], options?.dataSetWriterId);
        this.actionTargetId = initialize_field(schema.fields[1], options?.actionTargetId);
        this.dataSetWriterName = initialize_field(schema.fields[2], options?.dataSetWriterName);
        this.writerGroupName = initialize_field(schema.fields[3], options?.writerGroupName);
        this.metaDataVersion  =  new ConfigurationVersionDataType(options.metaDataVersion);
        this.minorVersion = initialize_field(schema.fields[5], options?.minorVersion);
        this.timestamp = initialize_field(schema.fields[6], options?.timestamp);
        this.messageType = initialize_field(schema.fields[7], options?.messageType);
        this.requestId = initialize_field(schema.fields[8], options?.requestId);
        this.actionState = this.setActionState(initialize_field(schema.fields[9], options?.actionState));
        this.payload = initialize_field(schema.fields[10], options?.payload);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeUInt16(this.dataSetWriterId, stream);
        encodeUInt16(this.actionTargetId, stream);
        encodeString(this.dataSetWriterName, stream);
        encodeString(this.writerGroupName, stream);
        this.metaDataVersion.encode(stream);
        encodeUInt32(this.minorVersion, stream);
        encodeDateTime(this.timestamp, stream);
        encodeString(this.messageType, stream);
        encodeUInt16(this.requestId, stream);
        encodeActionState(this.actionState, stream);
        encodeExtensionObject(this.payload, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.dataSetWriterId = decodeUInt16(stream, this.dataSetWriterId);
        this.actionTargetId = decodeUInt16(stream, this.actionTargetId);
        this.dataSetWriterName = decodeString(stream, this.dataSetWriterName);
        this.writerGroupName = decodeString(stream, this.writerGroupName);
        this.metaDataVersion.decode(stream);
        this.minorVersion = decodeUInt32(stream, this.minorVersion);
        this.timestamp = decodeDateTime(stream, this.timestamp);
        this.messageType = decodeString(stream, this.messageType);
        this.requestId = decodeUInt16(stream, this.requestId);
        this.actionState = decodeActionState(stream, this.actionState);
        this.payload = decodeExtensionObject(stream, this.payload);
    }

    // Define Enumeration setters
    public setActionState(value: any): ActionState {
        const coercedValue = _enumerationActionState.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to ActionState :" + value);
        }
        this.actionState = coercedValue.value as ActionState;
        return this.actionState;
    }
    public get schema(): IStructuredTypeSchema { return schemaJsonActionRequestMessage; }
}
JsonActionRequestMessage.schema.dataTypeNodeId = JsonActionRequestMessage.dataTypeNodeId;
JsonActionRequestMessage.schema.encodingDefaultBinary = JsonActionRequestMessage.encodingDefaultBinary;
JsonActionRequestMessage.schema.encodingDefaultXml = JsonActionRequestMessage.encodingDefaultXml;
JsonActionRequestMessage.schema.encodingDefaultJson = JsonActionRequestMessage.encodingDefaultJson;
registerClassDefinition( JsonActionRequestMessage.dataTypeNodeId, "JsonActionRequestMessage", JsonActionRequestMessage);
// --------------------------------------------------------------------------------------------
const schemaPubSubGroupDataType = buildStructuredType({
    name: "PubSubGroupDataType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Name",

            fieldType: "String",
        },
        {
            name: "Enabled",

            fieldType: "Boolean",
        },
        {
            name: "SecurityMode",

            fieldType: "MessageSecurityMode",
        },
        {
            name: "SecurityGroupId",

            fieldType: "String",
        },
        {
            name: "SecurityKeyServices",

            fieldType: "EndpointDescription",
            isArray: true
        },
        {
            name: "MaxNetworkMessageSize",

            fieldType: "UInt32",
        },
        {
            name: "GroupProperties",

            fieldType: "KeyValuePair",
            isArray: true
        },
    ]
});
export interface PubSubGroupDataTypeOptions {
    name?: UAString ;
    enabled?: UABoolean ;
    securityMode?: MessageSecurityMode;
    securityGroupId?: UAString ;
    securityKeyServices?: EndpointDescriptionOptions [] | null;
    maxNetworkMessageSize?: UInt32 ;
    groupProperties?: KeyValuePairOptions [] | null;
}
export class PubSubGroupDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaPubSubGroupDataType; }
    public static possibleFields: string[] = [
          "name",
           "enabled",
           "securityMode",
           "securityGroupId",
           "securityKeyServices",
           "maxNetworkMessageSize",
           "groupProperties"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15609, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15689, 0);
    public static encodingDefaultXml = makeExpandedNodeId(15988, 0);
    public static encodingDefaultJson = makeExpandedNodeId(16159, 0);
    public name: UAString;
    public enabled: UABoolean;
    public securityMode: MessageSecurityMode;
    public securityGroupId: UAString;
    public securityKeyServices: EndpointDescription[] | null;
    public maxNetworkMessageSize: UInt32;
    public groupProperties: KeyValuePair[] | null;

    constructor(options?: PubSubGroupDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.name = null;
            this.enabled = false;
             this.securityMode =  0 as  MessageSecurityMode;
            this.securityGroupId = null;
         this.securityKeyServices =  null; /* null array */
            this.maxNetworkMessageSize = 0;
         this.groupProperties =  null; /* null array */
              return;
        }
        const schema = PubSubGroupDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as PubSubGroupDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.name = initialize_field(schema.fields[0], options?.name);
        this.enabled = initialize_field(schema.fields[1], options?.enabled);
        this.securityMode = this.setSecurityMode(initialize_field(schema.fields[2], options?.securityMode));
        this.securityGroupId = initialize_field(schema.fields[3], options?.securityGroupId);
        this.securityKeyServices = []; // should default
        if (options.securityKeyServices) {
            assert(Array.isArray(options.securityKeyServices));
            this.securityKeyServices = options.securityKeyServices.map((e: any) => new EndpointDescription(e));
        }
        this.maxNetworkMessageSize = initialize_field(schema.fields[5], options?.maxNetworkMessageSize);
        this.groupProperties = []; // should default
        if (options.groupProperties) {
            assert(Array.isArray(options.groupProperties));
            this.groupProperties = options.groupProperties.map((e: any) => new KeyValuePair(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.name, stream);
        encodeBoolean(this.enabled, stream);
        encodeMessageSecurityMode(this.securityMode, stream);
        encodeString(this.securityGroupId, stream);
        encodeArray(this.securityKeyServices, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeUInt32(this.maxNetworkMessageSize, stream);
        encodeArray(this.groupProperties, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = decodeString(stream, this.name);
        this.enabled = decodeBoolean(stream, this.enabled);
        this.securityMode = decodeMessageSecurityMode(stream, this.securityMode);
        this.securityGroupId = decodeString(stream, this.securityGroupId);
        this.securityKeyServices = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new EndpointDescription(null);
            obj.decode(stream1);
            return obj;
        });
        this.maxNetworkMessageSize = decodeUInt32(stream, this.maxNetworkMessageSize);
        this.groupProperties = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new KeyValuePair(null);
            obj.decode(stream1);
            return obj;
        });
    }

    // Define Enumeration setters
    public setSecurityMode(value: any): MessageSecurityMode {
        const coercedValue = _enumerationMessageSecurityMode.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to MessageSecurityMode :" + value);
        }
        this.securityMode = coercedValue.value as MessageSecurityMode;
        return this.securityMode;
    }
    public get schema(): IStructuredTypeSchema { return schemaPubSubGroupDataType; }
}
PubSubGroupDataType.schema.dataTypeNodeId = PubSubGroupDataType.dataTypeNodeId;
PubSubGroupDataType.schema.encodingDefaultBinary = PubSubGroupDataType.encodingDefaultBinary;
PubSubGroupDataType.schema.encodingDefaultXml = PubSubGroupDataType.encodingDefaultXml;
PubSubGroupDataType.schema.encodingDefaultJson = PubSubGroupDataType.encodingDefaultJson;
registerClassDefinition( PubSubGroupDataType.dataTypeNodeId, "PubSubGroupDataType", PubSubGroupDataType);
// --------------------------------------------------------------------------------------------
const schemaWriterGroupDataType = buildStructuredType({
    name: "WriterGroupDataType",

    baseType: "PubSubGroupDataType",
    fields: [
        {
            name: "WriterGroupId",

            fieldType: "UInt16",
        },
        {
            name: "PublishingInterval",

            fieldType: "Double",
        },
        {
            name: "KeepAliveTime",

            fieldType: "Double",
        },
        {
            name: "Priority",

            fieldType: "Byte",
        },
        {
            name: "LocaleIds",

            fieldType: "String",
            isArray: true
        },
        {
            name: "HeaderLayoutUri",

            fieldType: "String",
        },
        {
            name: "TransportSettings",

            fieldType: "ExtensionObject",
        },
        {
            name: "MessageSettings",

            fieldType: "ExtensionObject",
        },
        {
            name: "DataSetWriters",

            fieldType: "DataSetWriterDataType",
            isArray: true
        },
    ]
});
export interface WriterGroupDataTypeOptions extends PubSubGroupDataTypeOptions {
    writerGroupId?: UInt16 ;
    publishingInterval?: Double ;
    keepAliveTime?: Double ;
    priority?: Byte ;
    localeIds?: UAString [] | null;
    headerLayoutUri?: UAString ;
    transportSettings?: (ExtensionObject | null);
    messageSettings?: (ExtensionObject | null);
    dataSetWriters?: DataSetWriterDataTypeOptions [] | null;
}
export class WriterGroupDataType extends PubSubGroupDataType {
    public static get schema(): IStructuredTypeSchema { return schemaWriterGroupDataType; }
    public static possibleFields: string[] = [
          "name",
           "enabled",
           "securityMode",
           "securityGroupId",
           "securityKeyServices",
           "maxNetworkMessageSize",
           "groupProperties",
           "writerGroupId",
           "publishingInterval",
           "keepAliveTime",
           "priority",
           "localeIds",
           "headerLayoutUri",
           "transportSettings",
           "messageSettings",
           "dataSetWriters"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15480, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(21150, 0);
    public static encodingDefaultXml = makeExpandedNodeId(21174, 0);
    public static encodingDefaultJson = makeExpandedNodeId(21198, 0);
    public writerGroupId: UInt16;
    public publishingInterval: Double;
    public keepAliveTime: Double;
    public priority: Byte;
    public localeIds: UAString[] | null;
    public headerLayoutUri: UAString;
    public transportSettings: (ExtensionObject | null);
    public messageSettings: (ExtensionObject | null);
    public dataSetWriters: DataSetWriterDataType[] | null;

    constructor(options?: WriterGroupDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.writerGroupId = 0;
            this.publishingInterval = 0;
            this.keepAliveTime = 0;
            this.priority = 0;
            this.localeIds = []
            this.headerLayoutUri = null;
            this.transportSettings = null;
            this.messageSettings = null;
         this.dataSetWriters =  null; /* null array */
              return;
        }
        const schema = WriterGroupDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as WriterGroupDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.writerGroupId = initialize_field(schema.fields[0], options?.writerGroupId);
        this.publishingInterval = initialize_field(schema.fields[1], options?.publishingInterval);
        this.keepAliveTime = initialize_field(schema.fields[2], options?.keepAliveTime);
        this.priority = initialize_field(schema.fields[3], options?.priority);
        this.localeIds = initialize_field_array(schema.fields[4], options?.localeIds);
        this.headerLayoutUri = initialize_field(schema.fields[5], options?.headerLayoutUri);
        this.transportSettings = initialize_field(schema.fields[6], options?.transportSettings);
        this.messageSettings = initialize_field(schema.fields[7], options?.messageSettings);
        this.dataSetWriters = []; // should default
        if (options.dataSetWriters) {
            assert(Array.isArray(options.dataSetWriters));
            this.dataSetWriters = options.dataSetWriters.map((e: any) => new DataSetWriterDataType(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeUInt16(this.writerGroupId, stream);
        encodeDouble(this.publishingInterval, stream);
        encodeDouble(this.keepAliveTime, stream);
        encodeByte(this.priority, stream);
        encodeArray(this.localeIds, stream, encodeString);
        encodeString(this.headerLayoutUri, stream);
        encodeExtensionObject(this.transportSettings, stream);
        encodeExtensionObject(this.messageSettings, stream);
        encodeArray(this.dataSetWriters, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.writerGroupId = decodeUInt16(stream, this.writerGroupId);
        this.publishingInterval = decodeDouble(stream, this.publishingInterval);
        this.keepAliveTime = decodeDouble(stream, this.keepAliveTime);
        this.priority = decodeByte(stream, this.priority);
        this.localeIds = decodeArray(stream, decodeString);
        this.headerLayoutUri = decodeString(stream, this.headerLayoutUri);
        this.transportSettings = decodeExtensionObject(stream, this.transportSettings);
        this.messageSettings = decodeExtensionObject(stream, this.messageSettings);
        this.dataSetWriters = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new DataSetWriterDataType(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaWriterGroupDataType; }
}
WriterGroupDataType.schema.dataTypeNodeId = WriterGroupDataType.dataTypeNodeId;
WriterGroupDataType.schema.encodingDefaultBinary = WriterGroupDataType.encodingDefaultBinary;
WriterGroupDataType.schema.encodingDefaultXml = WriterGroupDataType.encodingDefaultXml;
WriterGroupDataType.schema.encodingDefaultJson = WriterGroupDataType.encodingDefaultJson;
registerClassDefinition( WriterGroupDataType.dataTypeNodeId, "WriterGroupDataType", WriterGroupDataType);
// --------------------------------------------------------------------------------------------
const schemaReaderGroupDataType = buildStructuredType({
    name: "ReaderGroupDataType",

    baseType: "PubSubGroupDataType",
    fields: [
        {
            name: "TransportSettings",

            fieldType: "ExtensionObject",
        },
        {
            name: "MessageSettings",

            fieldType: "ExtensionObject",
        },
        {
            name: "DataSetReaders",

            fieldType: "DataSetReaderDataType",
            isArray: true
        },
    ]
});
export interface ReaderGroupDataTypeOptions extends PubSubGroupDataTypeOptions {
    transportSettings?: (ExtensionObject | null);
    messageSettings?: (ExtensionObject | null);
    dataSetReaders?: DataSetReaderDataTypeOptions [] | null;
}
export class ReaderGroupDataType extends PubSubGroupDataType {
    public static get schema(): IStructuredTypeSchema { return schemaReaderGroupDataType; }
    public static possibleFields: string[] = [
          "name",
           "enabled",
           "securityMode",
           "securityGroupId",
           "securityKeyServices",
           "maxNetworkMessageSize",
           "groupProperties",
           "transportSettings",
           "messageSettings",
           "dataSetReaders"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15520, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(21153, 0);
    public static encodingDefaultXml = makeExpandedNodeId(21177, 0);
    public static encodingDefaultJson = makeExpandedNodeId(21201, 0);
    public transportSettings: (ExtensionObject | null);
    public messageSettings: (ExtensionObject | null);
    public dataSetReaders: DataSetReaderDataType[] | null;

    constructor(options?: ReaderGroupDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.transportSettings = null;
            this.messageSettings = null;
         this.dataSetReaders =  null; /* null array */
              return;
        }
        const schema = ReaderGroupDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ReaderGroupDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.transportSettings = initialize_field(schema.fields[0], options?.transportSettings);
        this.messageSettings = initialize_field(schema.fields[1], options?.messageSettings);
        this.dataSetReaders = []; // should default
        if (options.dataSetReaders) {
            assert(Array.isArray(options.dataSetReaders));
            this.dataSetReaders = options.dataSetReaders.map((e: any) => new DataSetReaderDataType(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeExtensionObject(this.transportSettings, stream);
        encodeExtensionObject(this.messageSettings, stream);
        encodeArray(this.dataSetReaders, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.transportSettings = decodeExtensionObject(stream, this.transportSettings);
        this.messageSettings = decodeExtensionObject(stream, this.messageSettings);
        this.dataSetReaders = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new DataSetReaderDataType(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaReaderGroupDataType; }
}
ReaderGroupDataType.schema.dataTypeNodeId = ReaderGroupDataType.dataTypeNodeId;
ReaderGroupDataType.schema.encodingDefaultBinary = ReaderGroupDataType.encodingDefaultBinary;
ReaderGroupDataType.schema.encodingDefaultXml = ReaderGroupDataType.encodingDefaultXml;
ReaderGroupDataType.schema.encodingDefaultJson = ReaderGroupDataType.encodingDefaultJson;
registerClassDefinition( ReaderGroupDataType.dataTypeNodeId, "ReaderGroupDataType", ReaderGroupDataType);
// --------------------------------------------------------------------------------------------
const schemaPubSubConnectionDataType = buildStructuredType({
    name: "PubSubConnectionDataType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Name",

            fieldType: "String",
        },
        {
            name: "Enabled",

            fieldType: "Boolean",
        },
        {
            name: "PublisherId",

            fieldType: "Variant",
        },
        {
            name: "TransportProfileUri",

            fieldType: "String",
        },
        {
            name: "Address",

            fieldType: "ExtensionObject",
        },
        {
            name: "ConnectionProperties",

            fieldType: "KeyValuePair",
            isArray: true
        },
        {
            name: "TransportSettings",

            fieldType: "ExtensionObject",
        },
        {
            name: "WriterGroups",

            fieldType: "WriterGroupDataType",
            isArray: true
        },
        {
            name: "ReaderGroups",

            fieldType: "ReaderGroupDataType",
            isArray: true
        },
    ]
});
export interface PubSubConnectionDataTypeOptions {
    name?: UAString ;
    enabled?: UABoolean ;
    publisherId?: (VariantLike | null);
    transportProfileUri?: UAString ;
    address?: (ExtensionObject | null);
    connectionProperties?: KeyValuePairOptions [] | null;
    transportSettings?: (ExtensionObject | null);
    writerGroups?: WriterGroupDataTypeOptions [] | null;
    readerGroups?: ReaderGroupDataTypeOptions [] | null;
}
export class PubSubConnectionDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaPubSubConnectionDataType; }
    public static possibleFields: string[] = [
          "name",
           "enabled",
           "publisherId",
           "transportProfileUri",
           "address",
           "connectionProperties",
           "transportSettings",
           "writerGroups",
           "readerGroups"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15617, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15694, 0);
    public static encodingDefaultXml = makeExpandedNodeId(15992, 0);
    public static encodingDefaultJson = makeExpandedNodeId(16281, 0);
    public name: UAString;
    public enabled: UABoolean;
    public publisherId: Variant;
    public transportProfileUri: UAString;
    public address: (ExtensionObject | null);
    public connectionProperties: KeyValuePair[] | null;
    public transportSettings: (ExtensionObject | null);
    public writerGroups: WriterGroupDataType[] | null;
    public readerGroups: ReaderGroupDataType[] | null;

    constructor(options?: PubSubConnectionDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.name = null;
            this.enabled = false;
            this.publisherId = new Variant(null);
            this.transportProfileUri = null;
            this.address = null;
         this.connectionProperties =  null; /* null array */
            this.transportSettings = null;
         this.writerGroups =  null; /* null array */
         this.readerGroups =  null; /* null array */
              return;
        }
        const schema = PubSubConnectionDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as PubSubConnectionDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.name = initialize_field(schema.fields[0], options?.name);
        this.enabled = initialize_field(schema.fields[1], options?.enabled);
        this.publisherId = initialize_field(schema.fields[2], options?.publisherId);
        this.transportProfileUri = initialize_field(schema.fields[3], options?.transportProfileUri);
        this.address = initialize_field(schema.fields[4], options?.address);
        this.connectionProperties = []; // should default
        if (options.connectionProperties) {
            assert(Array.isArray(options.connectionProperties));
            this.connectionProperties = options.connectionProperties.map((e: any) => new KeyValuePair(e));
        }
        this.transportSettings = initialize_field(schema.fields[6], options?.transportSettings);
        this.writerGroups = []; // should default
        if (options.writerGroups) {
            assert(Array.isArray(options.writerGroups));
            this.writerGroups = options.writerGroups.map((e: any) => new WriterGroupDataType(e));
        }
        this.readerGroups = []; // should default
        if (options.readerGroups) {
            assert(Array.isArray(options.readerGroups));
            this.readerGroups = options.readerGroups.map((e: any) => new ReaderGroupDataType(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.name, stream);
        encodeBoolean(this.enabled, stream);
        encodeVariant(this.publisherId, stream);
        encodeString(this.transportProfileUri, stream);
        encodeExtensionObject(this.address, stream);
        encodeArray(this.connectionProperties, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeExtensionObject(this.transportSettings, stream);
        encodeArray(this.writerGroups, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.readerGroups, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = decodeString(stream, this.name);
        this.enabled = decodeBoolean(stream, this.enabled);
        this.publisherId = decodeVariant(stream, this.publisherId);
        this.transportProfileUri = decodeString(stream, this.transportProfileUri);
        this.address = decodeExtensionObject(stream, this.address);
        this.connectionProperties = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new KeyValuePair(null);
            obj.decode(stream1);
            return obj;
        });
        this.transportSettings = decodeExtensionObject(stream, this.transportSettings);
        this.writerGroups = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new WriterGroupDataType(null);
            obj.decode(stream1);
            return obj;
        });
        this.readerGroups = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new ReaderGroupDataType(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaPubSubConnectionDataType; }
}
PubSubConnectionDataType.schema.dataTypeNodeId = PubSubConnectionDataType.dataTypeNodeId;
PubSubConnectionDataType.schema.encodingDefaultBinary = PubSubConnectionDataType.encodingDefaultBinary;
PubSubConnectionDataType.schema.encodingDefaultXml = PubSubConnectionDataType.encodingDefaultXml;
PubSubConnectionDataType.schema.encodingDefaultJson = PubSubConnectionDataType.encodingDefaultJson;
registerClassDefinition( PubSubConnectionDataType.dataTypeNodeId, "PubSubConnectionDataType", PubSubConnectionDataType);
// --------------------------------------------------------------------------------------------
const schemaJsonActionResponderMessage = buildStructuredType({
    name: "JsonActionResponderMessage",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "MessageId",

            fieldType: "String",
        },
        {
            name: "MessageType",

            fieldType: "String",
        },
        {
            name: "PublisherId",

            fieldType: "String",
        },
        {
            name: "Timestamp",

            fieldType: "DateTime",
        },
        {
            name: "Connection",

            fieldType: "PubSubConnectionDataType",
        },
    ]
});
export interface JsonActionResponderMessageOptions {
    messageId?: UAString ;
    messageType?: UAString ;
    publisherId?: UAString ;
    timestamp?: DateTime ;
    connection?: PubSubConnectionDataTypeOptions ;
}
export class JsonActionResponderMessage extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaJsonActionResponderMessage; }
    public static possibleFields: string[] = [
          "messageId",
           "messageType",
           "publisherId",
           "timestamp",
           "connection"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(0, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(0, 0);
    public static encodingDefaultXml = makeExpandedNodeId(0, 0);
    public static encodingDefaultJson = makeExpandedNodeId(0, 0);
    public messageId: UAString;
    public messageType: UAString;
    public publisherId: UAString;
    public timestamp: DateTime;
    public connection: PubSubConnectionDataType;

    constructor(options?: JsonActionResponderMessageOptions | null) {

        super(options);

        if (options === null) {
            this.messageId = null;
            this.messageType = null;
            this.publisherId = null;
            this.timestamp = new Date();
         this.connection =  new PubSubConnectionDataType(null);
              return;
        }
        const schema = JsonActionResponderMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) as JsonActionResponderMessageOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.messageId = initialize_field(schema.fields[0], options?.messageId);
        this.messageType = initialize_field(schema.fields[1], options?.messageType);
        this.publisherId = initialize_field(schema.fields[2], options?.publisherId);
        this.timestamp = initialize_field(schema.fields[3], options?.timestamp);
        this.connection  =  new PubSubConnectionDataType(options.connection);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.messageId, stream);
        encodeString(this.messageType, stream);
        encodeString(this.publisherId, stream);
        encodeDateTime(this.timestamp, stream);
        this.connection.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.messageId = decodeString(stream, this.messageId);
        this.messageType = decodeString(stream, this.messageType);
        this.publisherId = decodeString(stream, this.publisherId);
        this.timestamp = decodeDateTime(stream, this.timestamp);
        this.connection.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaJsonActionResponderMessage; }
}
JsonActionResponderMessage.schema.dataTypeNodeId = JsonActionResponderMessage.dataTypeNodeId;
JsonActionResponderMessage.schema.encodingDefaultBinary = JsonActionResponderMessage.encodingDefaultBinary;
JsonActionResponderMessage.schema.encodingDefaultXml = JsonActionResponderMessage.encodingDefaultXml;
JsonActionResponderMessage.schema.encodingDefaultJson = JsonActionResponderMessage.encodingDefaultJson;
registerClassDefinition( JsonActionResponderMessage.dataTypeNodeId, "JsonActionResponderMessage", JsonActionResponderMessage);
// --------------------------------------------------------------------------------------------
const schemaJsonActionResponseMessage = buildStructuredType({
    name: "JsonActionResponseMessage",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "DataSetWriterId",

            fieldType: "UInt16",
        },
        {
            name: "ActionTargetId",

            fieldType: "UInt16",
        },
        {
            name: "DataSetWriterName",

            fieldType: "String",
        },
        {
            name: "WriterGroupName",

            fieldType: "String",
        },
        {
            name: "MetaDataVersion",

            fieldType: "ConfigurationVersionDataType",
        },
        {
            name: "MinorVersion",

            fieldType: "UInt32",
        },
        {
            name: "Timestamp",

            fieldType: "DateTime",
        },
        {
            name: "Status",

            fieldType: "StatusCode",
        },
        {
            name: "MessageType",

            fieldType: "String",
        },
        {
            name: "RequestId",

            fieldType: "UInt16",
        },
        {
            name: "ActionState",

            fieldType: "ActionState",
        },
        {
            name: "Payload",

            fieldType: "ExtensionObject",
        },
    ]
});
export interface JsonActionResponseMessageOptions {
    dataSetWriterId?: UInt16 ;
    actionTargetId?: UInt16 ;
    dataSetWriterName?: UAString ;
    writerGroupName?: UAString ;
    metaDataVersion?: ConfigurationVersionDataTypeOptions ;
    minorVersion?: UInt32 ;
    timestamp?: DateTime ;
    status?: StatusCode ;
    messageType?: UAString ;
    requestId?: UInt16 ;
    actionState?: ActionState;
    payload?: (ExtensionObject | null);
}
export class JsonActionResponseMessage extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaJsonActionResponseMessage; }
    public static possibleFields: string[] = [
          "dataSetWriterId",
           "actionTargetId",
           "dataSetWriterName",
           "writerGroupName",
           "metaDataVersion",
           "minorVersion",
           "timestamp",
           "status",
           "messageType",
           "requestId",
           "actionState",
           "payload"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(0, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(0, 0);
    public static encodingDefaultXml = makeExpandedNodeId(0, 0);
    public static encodingDefaultJson = makeExpandedNodeId(0, 0);
    public dataSetWriterId: UInt16;
    public actionTargetId: UInt16;
    public dataSetWriterName: UAString;
    public writerGroupName: UAString;
    public metaDataVersion: ConfigurationVersionDataType;
    public minorVersion: UInt32;
    public timestamp: DateTime;
    public status: StatusCode;
    public messageType: UAString;
    public requestId: UInt16;
    public actionState: ActionState;
    public payload: (ExtensionObject | null);

    constructor(options?: JsonActionResponseMessageOptions | null) {

        super(options);

        if (options === null) {
            this.dataSetWriterId = 0;
            this.actionTargetId = 0;
            this.dataSetWriterName = null;
            this.writerGroupName = null;
         this.metaDataVersion =  new ConfigurationVersionDataType(null);
            this.minorVersion = 0;
            this.timestamp = new Date();
            this.status = StatusCodes.Good;
            this.messageType = null;
            this.requestId = 0;
             this.actionState =  0 as  ActionState;
            this.payload = null;
              return;
        }
        const schema = JsonActionResponseMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) as JsonActionResponseMessageOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.dataSetWriterId = initialize_field(schema.fields[0], options?.dataSetWriterId);
        this.actionTargetId = initialize_field(schema.fields[1], options?.actionTargetId);
        this.dataSetWriterName = initialize_field(schema.fields[2], options?.dataSetWriterName);
        this.writerGroupName = initialize_field(schema.fields[3], options?.writerGroupName);
        this.metaDataVersion  =  new ConfigurationVersionDataType(options.metaDataVersion);
        this.minorVersion = initialize_field(schema.fields[5], options?.minorVersion);
        this.timestamp = initialize_field(schema.fields[6], options?.timestamp);
        this.status = initialize_field(schema.fields[7], options?.status);
        this.messageType = initialize_field(schema.fields[8], options?.messageType);
        this.requestId = initialize_field(schema.fields[9], options?.requestId);
        this.actionState = this.setActionState(initialize_field(schema.fields[10], options?.actionState));
        this.payload = initialize_field(schema.fields[11], options?.payload);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeUInt16(this.dataSetWriterId, stream);
        encodeUInt16(this.actionTargetId, stream);
        encodeString(this.dataSetWriterName, stream);
        encodeString(this.writerGroupName, stream);
        this.metaDataVersion.encode(stream);
        encodeUInt32(this.minorVersion, stream);
        encodeDateTime(this.timestamp, stream);
        encodeStatusCode(this.status, stream);
        encodeString(this.messageType, stream);
        encodeUInt16(this.requestId, stream);
        encodeActionState(this.actionState, stream);
        encodeExtensionObject(this.payload, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.dataSetWriterId = decodeUInt16(stream, this.dataSetWriterId);
        this.actionTargetId = decodeUInt16(stream, this.actionTargetId);
        this.dataSetWriterName = decodeString(stream, this.dataSetWriterName);
        this.writerGroupName = decodeString(stream, this.writerGroupName);
        this.metaDataVersion.decode(stream);
        this.minorVersion = decodeUInt32(stream, this.minorVersion);
        this.timestamp = decodeDateTime(stream, this.timestamp);
        this.status = decodeStatusCode(stream, this.status);
        this.messageType = decodeString(stream, this.messageType);
        this.requestId = decodeUInt16(stream, this.requestId);
        this.actionState = decodeActionState(stream, this.actionState);
        this.payload = decodeExtensionObject(stream, this.payload);
    }

    // Define Enumeration setters
    public setActionState(value: any): ActionState {
        const coercedValue = _enumerationActionState.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to ActionState :" + value);
        }
        this.actionState = coercedValue.value as ActionState;
        return this.actionState;
    }
    public get schema(): IStructuredTypeSchema { return schemaJsonActionResponseMessage; }
}
JsonActionResponseMessage.schema.dataTypeNodeId = JsonActionResponseMessage.dataTypeNodeId;
JsonActionResponseMessage.schema.encodingDefaultBinary = JsonActionResponseMessage.encodingDefaultBinary;
JsonActionResponseMessage.schema.encodingDefaultXml = JsonActionResponseMessage.encodingDefaultXml;
JsonActionResponseMessage.schema.encodingDefaultJson = JsonActionResponseMessage.encodingDefaultJson;
registerClassDefinition( JsonActionResponseMessage.dataTypeNodeId, "JsonActionResponseMessage", JsonActionResponseMessage);
// --------------------------------------------------------------------------------------------
const schemaJsonApplicationDescriptionMessage = buildStructuredType({
    name: "JsonApplicationDescriptionMessage",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "MessageId",

            fieldType: "String",
        },
        {
            name: "MessageType",

            fieldType: "String",
        },
        {
            name: "PublisherId",

            fieldType: "String",
        },
        {
            name: "Timestamp",

            fieldType: "DateTime",
        },
        {
            name: "Description",

            fieldType: "ApplicationDescription",
        },
        {
            name: "ServerCapabilities",

            fieldType: "String",
            isArray: true
        },
    ]
});
export interface JsonApplicationDescriptionMessageOptions {
    messageId?: UAString ;
    messageType?: UAString ;
    publisherId?: UAString ;
    timestamp?: DateTime ;
    description?: ApplicationDescriptionOptions ;
    serverCapabilities?: UAString [] | null;
}
export class JsonApplicationDescriptionMessage extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaJsonApplicationDescriptionMessage; }
    public static possibleFields: string[] = [
          "messageId",
           "messageType",
           "publisherId",
           "timestamp",
           "description",
           "serverCapabilities"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(0, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(0, 0);
    public static encodingDefaultXml = makeExpandedNodeId(0, 0);
    public static encodingDefaultJson = makeExpandedNodeId(0, 0);
    public messageId: UAString;
    public messageType: UAString;
    public publisherId: UAString;
    public timestamp: DateTime;
    public description: ApplicationDescription;
    public serverCapabilities: UAString[] | null;

    constructor(options?: JsonApplicationDescriptionMessageOptions | null) {

        super(options);

        if (options === null) {
            this.messageId = null;
            this.messageType = null;
            this.publisherId = null;
            this.timestamp = new Date();
         this.description =  new ApplicationDescription(null);
            this.serverCapabilities = []
              return;
        }
        const schema = JsonApplicationDescriptionMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) as JsonApplicationDescriptionMessageOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.messageId = initialize_field(schema.fields[0], options?.messageId);
        this.messageType = initialize_field(schema.fields[1], options?.messageType);
        this.publisherId = initialize_field(schema.fields[2], options?.publisherId);
        this.timestamp = initialize_field(schema.fields[3], options?.timestamp);
        this.description  =  new ApplicationDescription(options.description);
        this.serverCapabilities = initialize_field_array(schema.fields[5], options?.serverCapabilities);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.messageId, stream);
        encodeString(this.messageType, stream);
        encodeString(this.publisherId, stream);
        encodeDateTime(this.timestamp, stream);
        this.description.encode(stream);
        encodeArray(this.serverCapabilities, stream, encodeString);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.messageId = decodeString(stream, this.messageId);
        this.messageType = decodeString(stream, this.messageType);
        this.publisherId = decodeString(stream, this.publisherId);
        this.timestamp = decodeDateTime(stream, this.timestamp);
        this.description.decode(stream);
        this.serverCapabilities = decodeArray(stream, decodeString);
    }
    public get schema(): IStructuredTypeSchema { return schemaJsonApplicationDescriptionMessage; }
}
JsonApplicationDescriptionMessage.schema.dataTypeNodeId = JsonApplicationDescriptionMessage.dataTypeNodeId;
JsonApplicationDescriptionMessage.schema.encodingDefaultBinary = JsonApplicationDescriptionMessage.encodingDefaultBinary;
JsonApplicationDescriptionMessage.schema.encodingDefaultXml = JsonApplicationDescriptionMessage.encodingDefaultXml;
JsonApplicationDescriptionMessage.schema.encodingDefaultJson = JsonApplicationDescriptionMessage.encodingDefaultJson;
registerClassDefinition( JsonApplicationDescriptionMessage.dataTypeNodeId, "JsonApplicationDescriptionMessage", JsonApplicationDescriptionMessage);
// --------------------------------------------------------------------------------------------
const schemaJsonDataSetMessage = buildStructuredType({
    name: "JsonDataSetMessage",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "DataSetWriterId",

            fieldType: "UInt16",
        },
        {
            name: "DataSetWriterName",

            fieldType: "String",
        },
        {
            name: "PublisherId",

            fieldType: "String",
        },
        {
            name: "WriterGroupName",

            fieldType: "String",
        },
        {
            name: "SequenceNumber",

            fieldType: "UInt32",
        },
        {
            name: "MetaDataVersion",

            fieldType: "ConfigurationVersionDataType",
        },
        {
            name: "MinorVersion",

            fieldType: "UInt32",
        },
        {
            name: "Timestamp",

            fieldType: "DateTime",
        },
        {
            name: "Status",

            fieldType: "StatusCode",
        },
        {
            name: "MessageType",

            fieldType: "String",
        },
        {
            name: "Payload",

            fieldType: "ExtensionObject",
        },
    ]
});
export interface JsonDataSetMessageOptions {
    dataSetWriterId?: UInt16 ;
    dataSetWriterName?: UAString ;
    publisherId?: UAString ;
    writerGroupName?: UAString ;
    sequenceNumber?: UInt32 ;
    metaDataVersion?: ConfigurationVersionDataTypeOptions ;
    minorVersion?: UInt32 ;
    timestamp?: DateTime ;
    status?: StatusCode ;
    messageType?: UAString ;
    payload?: (ExtensionObject | null);
}
export class JsonDataSetMessage extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaJsonDataSetMessage; }
    public static possibleFields: string[] = [
          "dataSetWriterId",
           "dataSetWriterName",
           "publisherId",
           "writerGroupName",
           "sequenceNumber",
           "metaDataVersion",
           "minorVersion",
           "timestamp",
           "status",
           "messageType",
           "payload"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(0, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(0, 0);
    public static encodingDefaultXml = makeExpandedNodeId(0, 0);
    public static encodingDefaultJson = makeExpandedNodeId(0, 0);
    public dataSetWriterId: UInt16;
    public dataSetWriterName: UAString;
    public publisherId: UAString;
    public writerGroupName: UAString;
    public sequenceNumber: UInt32;
    public metaDataVersion: ConfigurationVersionDataType;
    public minorVersion: UInt32;
    public timestamp: DateTime;
    public status: StatusCode;
    public messageType: UAString;
    public payload: (ExtensionObject | null);

    constructor(options?: JsonDataSetMessageOptions | null) {

        super(options);

        if (options === null) {
            this.dataSetWriterId = 0;
            this.dataSetWriterName = null;
            this.publisherId = null;
            this.writerGroupName = null;
            this.sequenceNumber = 0;
         this.metaDataVersion =  new ConfigurationVersionDataType(null);
            this.minorVersion = 0;
            this.timestamp = new Date();
            this.status = StatusCodes.Good;
            this.messageType = null;
            this.payload = null;
              return;
        }
        const schema = JsonDataSetMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) as JsonDataSetMessageOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.dataSetWriterId = initialize_field(schema.fields[0], options?.dataSetWriterId);
        this.dataSetWriterName = initialize_field(schema.fields[1], options?.dataSetWriterName);
        this.publisherId = initialize_field(schema.fields[2], options?.publisherId);
        this.writerGroupName = initialize_field(schema.fields[3], options?.writerGroupName);
        this.sequenceNumber = initialize_field(schema.fields[4], options?.sequenceNumber);
        this.metaDataVersion  =  new ConfigurationVersionDataType(options.metaDataVersion);
        this.minorVersion = initialize_field(schema.fields[6], options?.minorVersion);
        this.timestamp = initialize_field(schema.fields[7], options?.timestamp);
        this.status = initialize_field(schema.fields[8], options?.status);
        this.messageType = initialize_field(schema.fields[9], options?.messageType);
        this.payload = initialize_field(schema.fields[10], options?.payload);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeUInt16(this.dataSetWriterId, stream);
        encodeString(this.dataSetWriterName, stream);
        encodeString(this.publisherId, stream);
        encodeString(this.writerGroupName, stream);
        encodeUInt32(this.sequenceNumber, stream);
        this.metaDataVersion.encode(stream);
        encodeUInt32(this.minorVersion, stream);
        encodeDateTime(this.timestamp, stream);
        encodeStatusCode(this.status, stream);
        encodeString(this.messageType, stream);
        encodeExtensionObject(this.payload, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.dataSetWriterId = decodeUInt16(stream, this.dataSetWriterId);
        this.dataSetWriterName = decodeString(stream, this.dataSetWriterName);
        this.publisherId = decodeString(stream, this.publisherId);
        this.writerGroupName = decodeString(stream, this.writerGroupName);
        this.sequenceNumber = decodeUInt32(stream, this.sequenceNumber);
        this.metaDataVersion.decode(stream);
        this.minorVersion = decodeUInt32(stream, this.minorVersion);
        this.timestamp = decodeDateTime(stream, this.timestamp);
        this.status = decodeStatusCode(stream, this.status);
        this.messageType = decodeString(stream, this.messageType);
        this.payload = decodeExtensionObject(stream, this.payload);
    }
    public get schema(): IStructuredTypeSchema { return schemaJsonDataSetMessage; }
}
JsonDataSetMessage.schema.dataTypeNodeId = JsonDataSetMessage.dataTypeNodeId;
JsonDataSetMessage.schema.encodingDefaultBinary = JsonDataSetMessage.encodingDefaultBinary;
JsonDataSetMessage.schema.encodingDefaultXml = JsonDataSetMessage.encodingDefaultXml;
JsonDataSetMessage.schema.encodingDefaultJson = JsonDataSetMessage.encodingDefaultJson;
registerClassDefinition( JsonDataSetMessage.dataTypeNodeId, "JsonDataSetMessage", JsonDataSetMessage);
// --------------------------------------------------------------------------------------------
const schemaJsonDataSetMetaDataMessage = buildStructuredType({
    name: "JsonDataSetMetaDataMessage",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "MessageId",

            fieldType: "String",
        },
        {
            name: "MessageType",

            fieldType: "String",
        },
        {
            name: "PublisherId",

            fieldType: "String",
        },
        {
            name: "DataSetWriterId",

            fieldType: "UInt16",
        },
        {
            name: "WriterGroupName",

            fieldType: "String",
        },
        {
            name: "DataSetWriterName",

            fieldType: "String",
        },
        {
            name: "Timestamp",

            fieldType: "DateTime",
        },
        {
            name: "MetaData",

            fieldType: "DataSetMetaDataType",
        },
    ]
});
export interface JsonDataSetMetaDataMessageOptions {
    messageId?: UAString ;
    messageType?: UAString ;
    publisherId?: UAString ;
    dataSetWriterId?: UInt16 ;
    writerGroupName?: UAString ;
    dataSetWriterName?: UAString ;
    timestamp?: DateTime ;
    metaData?: DataSetMetaDataTypeOptions ;
}
export class JsonDataSetMetaDataMessage extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaJsonDataSetMetaDataMessage; }
    public static possibleFields: string[] = [
          "messageId",
           "messageType",
           "publisherId",
           "dataSetWriterId",
           "writerGroupName",
           "dataSetWriterName",
           "timestamp",
           "metaData"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(0, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(0, 0);
    public static encodingDefaultXml = makeExpandedNodeId(0, 0);
    public static encodingDefaultJson = makeExpandedNodeId(0, 0);
    public messageId: UAString;
    public messageType: UAString;
    public publisherId: UAString;
    public dataSetWriterId: UInt16;
    public writerGroupName: UAString;
    public dataSetWriterName: UAString;
    public timestamp: DateTime;
    public metaData: DataSetMetaDataType;

    constructor(options?: JsonDataSetMetaDataMessageOptions | null) {

        super(options);

        if (options === null) {
            this.messageId = null;
            this.messageType = null;
            this.publisherId = null;
            this.dataSetWriterId = 0;
            this.writerGroupName = null;
            this.dataSetWriterName = null;
            this.timestamp = new Date();
         this.metaData =  new DataSetMetaDataType(null);
              return;
        }
        const schema = JsonDataSetMetaDataMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) as JsonDataSetMetaDataMessageOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.messageId = initialize_field(schema.fields[0], options?.messageId);
        this.messageType = initialize_field(schema.fields[1], options?.messageType);
        this.publisherId = initialize_field(schema.fields[2], options?.publisherId);
        this.dataSetWriterId = initialize_field(schema.fields[3], options?.dataSetWriterId);
        this.writerGroupName = initialize_field(schema.fields[4], options?.writerGroupName);
        this.dataSetWriterName = initialize_field(schema.fields[5], options?.dataSetWriterName);
        this.timestamp = initialize_field(schema.fields[6], options?.timestamp);
        this.metaData  =  new DataSetMetaDataType(options.metaData);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.messageId, stream);
        encodeString(this.messageType, stream);
        encodeString(this.publisherId, stream);
        encodeUInt16(this.dataSetWriterId, stream);
        encodeString(this.writerGroupName, stream);
        encodeString(this.dataSetWriterName, stream);
        encodeDateTime(this.timestamp, stream);
        this.metaData.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.messageId = decodeString(stream, this.messageId);
        this.messageType = decodeString(stream, this.messageType);
        this.publisherId = decodeString(stream, this.publisherId);
        this.dataSetWriterId = decodeUInt16(stream, this.dataSetWriterId);
        this.writerGroupName = decodeString(stream, this.writerGroupName);
        this.dataSetWriterName = decodeString(stream, this.dataSetWriterName);
        this.timestamp = decodeDateTime(stream, this.timestamp);
        this.metaData.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaJsonDataSetMetaDataMessage; }
}
JsonDataSetMetaDataMessage.schema.dataTypeNodeId = JsonDataSetMetaDataMessage.dataTypeNodeId;
JsonDataSetMetaDataMessage.schema.encodingDefaultBinary = JsonDataSetMetaDataMessage.encodingDefaultBinary;
JsonDataSetMetaDataMessage.schema.encodingDefaultXml = JsonDataSetMetaDataMessage.encodingDefaultXml;
JsonDataSetMetaDataMessage.schema.encodingDefaultJson = JsonDataSetMetaDataMessage.encodingDefaultJson;
registerClassDefinition( JsonDataSetMetaDataMessage.dataTypeNodeId, "JsonDataSetMetaDataMessage", JsonDataSetMetaDataMessage);

// --------------------------------------------------------------------------------------------
export enum JsonNetworkMessageContentMask {
    None = 0,
    NetworkMessageHeader = 1,
    DataSetMessageHeader = 2,
    SingleDataSetMessage = 4,
    PublisherId = 8,
    DataSetClassId = 16,
    ReplyTo = 32,
    WriterGroupName = 64
}
const schemaJsonNetworkMessageContentMask = {
    enumValues: JsonNetworkMessageContentMask,
    flaggable: true,
    name: "JsonNetworkMessageContentMask"
};
function decodeJsonNetworkMessageContentMask(stream: BinaryStream, _value?: JsonNetworkMessageContentMask): JsonNetworkMessageContentMask {
    return  stream.readUInt32() as JsonNetworkMessageContentMask;
}
function encodeJsonNetworkMessageContentMask(value: JsonNetworkMessageContentMask, stream: OutputBinaryStream): void {
    stream.writeUInt32(value);
}
export const _enumerationJsonNetworkMessageContentMask = registerEnumeration(schemaJsonNetworkMessageContentMask);
assert(_enumerationJsonNetworkMessageContentMask.isFlaggable ===  true);

// --------------------------------------------------------------------------------------------
export enum JsonDataSetMessageContentMask {
    None = 0,
    DataSetWriterId = 1,
    MetaDataVersion = 2,
    SequenceNumber = 4,
    Timestamp = 8,
    Status = 16,
    MessageType = 32,
    DataSetWriterName = 64,
    FieldEncoding1 = 128,
    PublisherId = 256,
    WriterGroupName = 512,
    MinorVersion = 1024,
    FieldEncoding2 = 2048
}
const schemaJsonDataSetMessageContentMask = {
    enumValues: JsonDataSetMessageContentMask,
    flaggable: true,
    name: "JsonDataSetMessageContentMask"
};
function decodeJsonDataSetMessageContentMask(stream: BinaryStream, _value?: JsonDataSetMessageContentMask): JsonDataSetMessageContentMask {
    return  stream.readUInt32() as JsonDataSetMessageContentMask;
}
function encodeJsonDataSetMessageContentMask(value: JsonDataSetMessageContentMask, stream: OutputBinaryStream): void {
    stream.writeUInt32(value);
}
export const _enumerationJsonDataSetMessageContentMask = registerEnumeration(schemaJsonDataSetMessageContentMask);
assert(_enumerationJsonDataSetMessageContentMask.isFlaggable ===  true);
// --------------------------------------------------------------------------------------------
const schemaJsonDataSetReaderMessageDataType = buildStructuredType({
    name: "JsonDataSetReaderMessageDataType",

    baseType: "DataSetReaderMessageDataType",
    fields: [
        {
            name: "NetworkMessageContentMask",

            fieldType: "JsonNetworkMessageContentMask",
        },
        {
            name: "DataSetMessageContentMask",

            fieldType: "JsonDataSetMessageContentMask",
        },
    ]
});
export interface JsonDataSetReaderMessageDataTypeOptions extends DataSetReaderMessageDataTypeOptions {
    networkMessageContentMask?: JsonNetworkMessageContentMask;
    dataSetMessageContentMask?: JsonDataSetMessageContentMask;
}
export class JsonDataSetReaderMessageDataType extends DataSetReaderMessageDataType {
    public static get schema(): IStructuredTypeSchema { return schemaJsonDataSetReaderMessageDataType; }
    public static possibleFields: string[] = [
          "networkMessageContentMask",
           "dataSetMessageContentMask"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15665, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15725, 0);
    public static encodingDefaultXml = makeExpandedNodeId(16019, 0);
    public static encodingDefaultJson = makeExpandedNodeId(16404, 0);
    public networkMessageContentMask: JsonNetworkMessageContentMask;
    public dataSetMessageContentMask: JsonDataSetMessageContentMask;

    constructor(options?: JsonDataSetReaderMessageDataTypeOptions | null) {

        super(options);

        if (options === null) {
             this.networkMessageContentMask =  0 as  JsonNetworkMessageContentMask;
             this.dataSetMessageContentMask =  0 as  JsonDataSetMessageContentMask;
              return;
        }
        const schema = JsonDataSetReaderMessageDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as JsonDataSetReaderMessageDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.networkMessageContentMask = this.setNetworkMessageContentMask(initialize_field(schema.fields[0], options?.networkMessageContentMask));
        this.dataSetMessageContentMask = this.setDataSetMessageContentMask(initialize_field(schema.fields[1], options?.dataSetMessageContentMask));
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeJsonNetworkMessageContentMask(this.networkMessageContentMask, stream);
        encodeJsonDataSetMessageContentMask(this.dataSetMessageContentMask, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.networkMessageContentMask = decodeJsonNetworkMessageContentMask(stream, this.networkMessageContentMask);
        this.dataSetMessageContentMask = decodeJsonDataSetMessageContentMask(stream, this.dataSetMessageContentMask);
    }

    // Define Enumeration setters
    public setNetworkMessageContentMask(value: any): JsonNetworkMessageContentMask {
        const coercedValue = _enumerationJsonNetworkMessageContentMask.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to JsonNetworkMessageContentMask :" + value);
        }
        this.networkMessageContentMask = coercedValue.value as JsonNetworkMessageContentMask;
        return this.networkMessageContentMask;
    }
    public setDataSetMessageContentMask(value: any): JsonDataSetMessageContentMask {
        const coercedValue = _enumerationJsonDataSetMessageContentMask.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to JsonDataSetMessageContentMask :" + value);
        }
        this.dataSetMessageContentMask = coercedValue.value as JsonDataSetMessageContentMask;
        return this.dataSetMessageContentMask;
    }
    public get schema(): IStructuredTypeSchema { return schemaJsonDataSetReaderMessageDataType; }
}
JsonDataSetReaderMessageDataType.schema.dataTypeNodeId = JsonDataSetReaderMessageDataType.dataTypeNodeId;
JsonDataSetReaderMessageDataType.schema.encodingDefaultBinary = JsonDataSetReaderMessageDataType.encodingDefaultBinary;
JsonDataSetReaderMessageDataType.schema.encodingDefaultXml = JsonDataSetReaderMessageDataType.encodingDefaultXml;
JsonDataSetReaderMessageDataType.schema.encodingDefaultJson = JsonDataSetReaderMessageDataType.encodingDefaultJson;
registerClassDefinition( JsonDataSetReaderMessageDataType.dataTypeNodeId, "JsonDataSetReaderMessageDataType", JsonDataSetReaderMessageDataType);
// --------------------------------------------------------------------------------------------
const schemaJsonDataSetWriterMessageDataType = buildStructuredType({
    name: "JsonDataSetWriterMessageDataType",

    baseType: "DataSetWriterMessageDataType",
    fields: [
        {
            name: "DataSetMessageContentMask",

            fieldType: "JsonDataSetMessageContentMask",
        },
    ]
});
export interface JsonDataSetWriterMessageDataTypeOptions extends DataSetWriterMessageDataTypeOptions {
    dataSetMessageContentMask?: JsonDataSetMessageContentMask;
}
export class JsonDataSetWriterMessageDataType extends DataSetWriterMessageDataType {
    public static get schema(): IStructuredTypeSchema { return schemaJsonDataSetWriterMessageDataType; }
    public static possibleFields: string[] = [
          "dataSetMessageContentMask"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15664, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15724, 0);
    public static encodingDefaultXml = makeExpandedNodeId(16018, 0);
    public static encodingDefaultJson = makeExpandedNodeId(16394, 0);
    public dataSetMessageContentMask: JsonDataSetMessageContentMask;

    constructor(options?: JsonDataSetWriterMessageDataTypeOptions | null) {

        super(options);

        if (options === null) {
             this.dataSetMessageContentMask =  0 as  JsonDataSetMessageContentMask;
              return;
        }
        const schema = JsonDataSetWriterMessageDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as JsonDataSetWriterMessageDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.dataSetMessageContentMask = this.setDataSetMessageContentMask(initialize_field(schema.fields[0], options?.dataSetMessageContentMask));
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeJsonDataSetMessageContentMask(this.dataSetMessageContentMask, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.dataSetMessageContentMask = decodeJsonDataSetMessageContentMask(stream, this.dataSetMessageContentMask);
    }

    // Define Enumeration setters
    public setDataSetMessageContentMask(value: any): JsonDataSetMessageContentMask {
        const coercedValue = _enumerationJsonDataSetMessageContentMask.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to JsonDataSetMessageContentMask :" + value);
        }
        this.dataSetMessageContentMask = coercedValue.value as JsonDataSetMessageContentMask;
        return this.dataSetMessageContentMask;
    }
    public get schema(): IStructuredTypeSchema { return schemaJsonDataSetWriterMessageDataType; }
}
JsonDataSetWriterMessageDataType.schema.dataTypeNodeId = JsonDataSetWriterMessageDataType.dataTypeNodeId;
JsonDataSetWriterMessageDataType.schema.encodingDefaultBinary = JsonDataSetWriterMessageDataType.encodingDefaultBinary;
JsonDataSetWriterMessageDataType.schema.encodingDefaultXml = JsonDataSetWriterMessageDataType.encodingDefaultXml;
JsonDataSetWriterMessageDataType.schema.encodingDefaultJson = JsonDataSetWriterMessageDataType.encodingDefaultJson;
registerClassDefinition( JsonDataSetWriterMessageDataType.dataTypeNodeId, "JsonDataSetWriterMessageDataType", JsonDataSetWriterMessageDataType);
// --------------------------------------------------------------------------------------------
const schemaJsonNetworkMessage = buildStructuredType({
    name: "JsonNetworkMessage",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "MessageId",

            fieldType: "String",
        },
        {
            name: "MessageType",

            fieldType: "String",
        },
        {
            name: "PublisherId",

            fieldType: "String",
        },
        {
            name: "WriterGroupName",

            fieldType: "String",
        },
        {
            name: "DataSetClassId",

            fieldType: "String",
        },
        {
            name: "Messages",

            fieldType: "ExtensionObject",
            isArray: true
        },
    ]
});
export interface JsonNetworkMessageOptions {
    messageId?: UAString ;
    messageType?: UAString ;
    publisherId?: UAString ;
    writerGroupName?: UAString ;
    dataSetClassId?: UAString ;
    messages?: (ExtensionObject | null)[] | null;
}
export class JsonNetworkMessage extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaJsonNetworkMessage; }
    public static possibleFields: string[] = [
          "messageId",
           "messageType",
           "publisherId",
           "writerGroupName",
           "dataSetClassId",
           "messages"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(0, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(0, 0);
    public static encodingDefaultXml = makeExpandedNodeId(0, 0);
    public static encodingDefaultJson = makeExpandedNodeId(0, 0);
    public messageId: UAString;
    public messageType: UAString;
    public publisherId: UAString;
    public writerGroupName: UAString;
    public dataSetClassId: UAString;
    public messages: (ExtensionObject | null)[] | null;

    constructor(options?: JsonNetworkMessageOptions | null) {

        super(options);

        if (options === null) {
            this.messageId = null;
            this.messageType = null;
            this.publisherId = null;
            this.writerGroupName = null;
            this.dataSetClassId = null;
            this.messages = []
              return;
        }
        const schema = JsonNetworkMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) as JsonNetworkMessageOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.messageId = initialize_field(schema.fields[0], options?.messageId);
        this.messageType = initialize_field(schema.fields[1], options?.messageType);
        this.publisherId = initialize_field(schema.fields[2], options?.publisherId);
        this.writerGroupName = initialize_field(schema.fields[3], options?.writerGroupName);
        this.dataSetClassId = initialize_field(schema.fields[4], options?.dataSetClassId);
        this.messages = initialize_field_array(schema.fields[5], options?.messages);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.messageId, stream);
        encodeString(this.messageType, stream);
        encodeString(this.publisherId, stream);
        encodeString(this.writerGroupName, stream);
        encodeString(this.dataSetClassId, stream);
        encodeArray(this.messages, stream, encodeExtensionObject);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.messageId = decodeString(stream, this.messageId);
        this.messageType = decodeString(stream, this.messageType);
        this.publisherId = decodeString(stream, this.publisherId);
        this.writerGroupName = decodeString(stream, this.writerGroupName);
        this.dataSetClassId = decodeString(stream, this.dataSetClassId);
        this.messages = decodeArray(stream, decodeExtensionObject);
    }
    public get schema(): IStructuredTypeSchema { return schemaJsonNetworkMessage; }
}
JsonNetworkMessage.schema.dataTypeNodeId = JsonNetworkMessage.dataTypeNodeId;
JsonNetworkMessage.schema.encodingDefaultBinary = JsonNetworkMessage.encodingDefaultBinary;
JsonNetworkMessage.schema.encodingDefaultXml = JsonNetworkMessage.encodingDefaultXml;
JsonNetworkMessage.schema.encodingDefaultJson = JsonNetworkMessage.encodingDefaultJson;
registerClassDefinition( JsonNetworkMessage.dataTypeNodeId, "JsonNetworkMessage", JsonNetworkMessage);
// --------------------------------------------------------------------------------------------
const schemaJsonPubSubConnectionMessage = buildStructuredType({
    name: "JsonPubSubConnectionMessage",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "MessageId",

            fieldType: "String",
        },
        {
            name: "MessageType",

            fieldType: "String",
        },
        {
            name: "PublisherId",

            fieldType: "String",
        },
        {
            name: "Timestamp",

            fieldType: "DateTime",
        },
        {
            name: "Connection",

            fieldType: "PubSubConnectionDataType",
        },
    ]
});
export interface JsonPubSubConnectionMessageOptions {
    messageId?: UAString ;
    messageType?: UAString ;
    publisherId?: UAString ;
    timestamp?: DateTime ;
    connection?: PubSubConnectionDataTypeOptions ;
}
export class JsonPubSubConnectionMessage extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaJsonPubSubConnectionMessage; }
    public static possibleFields: string[] = [
          "messageId",
           "messageType",
           "publisherId",
           "timestamp",
           "connection"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(0, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(0, 0);
    public static encodingDefaultXml = makeExpandedNodeId(0, 0);
    public static encodingDefaultJson = makeExpandedNodeId(0, 0);
    public messageId: UAString;
    public messageType: UAString;
    public publisherId: UAString;
    public timestamp: DateTime;
    public connection: PubSubConnectionDataType;

    constructor(options?: JsonPubSubConnectionMessageOptions | null) {

        super(options);

        if (options === null) {
            this.messageId = null;
            this.messageType = null;
            this.publisherId = null;
            this.timestamp = new Date();
         this.connection =  new PubSubConnectionDataType(null);
              return;
        }
        const schema = JsonPubSubConnectionMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) as JsonPubSubConnectionMessageOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.messageId = initialize_field(schema.fields[0], options?.messageId);
        this.messageType = initialize_field(schema.fields[1], options?.messageType);
        this.publisherId = initialize_field(schema.fields[2], options?.publisherId);
        this.timestamp = initialize_field(schema.fields[3], options?.timestamp);
        this.connection  =  new PubSubConnectionDataType(options.connection);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.messageId, stream);
        encodeString(this.messageType, stream);
        encodeString(this.publisherId, stream);
        encodeDateTime(this.timestamp, stream);
        this.connection.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.messageId = decodeString(stream, this.messageId);
        this.messageType = decodeString(stream, this.messageType);
        this.publisherId = decodeString(stream, this.publisherId);
        this.timestamp = decodeDateTime(stream, this.timestamp);
        this.connection.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaJsonPubSubConnectionMessage; }
}
JsonPubSubConnectionMessage.schema.dataTypeNodeId = JsonPubSubConnectionMessage.dataTypeNodeId;
JsonPubSubConnectionMessage.schema.encodingDefaultBinary = JsonPubSubConnectionMessage.encodingDefaultBinary;
JsonPubSubConnectionMessage.schema.encodingDefaultXml = JsonPubSubConnectionMessage.encodingDefaultXml;
JsonPubSubConnectionMessage.schema.encodingDefaultJson = JsonPubSubConnectionMessage.encodingDefaultJson;
registerClassDefinition( JsonPubSubConnectionMessage.dataTypeNodeId, "JsonPubSubConnectionMessage", JsonPubSubConnectionMessage);
// --------------------------------------------------------------------------------------------
const schemaJsonServerEndpointsMessage = buildStructuredType({
    name: "JsonServerEndpointsMessage",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "MessageId",

            fieldType: "String",
        },
        {
            name: "MessageType",

            fieldType: "String",
        },
        {
            name: "PublisherId",

            fieldType: "String",
        },
        {
            name: "Timestamp",

            fieldType: "DateTime",
        },
        {
            name: "Description",

            fieldType: "ApplicationDescription",
        },
        {
            name: "Endpoints",

            fieldType: "EndpointDescription",
            isArray: true
        },
    ]
});
export interface JsonServerEndpointsMessageOptions {
    messageId?: UAString ;
    messageType?: UAString ;
    publisherId?: UAString ;
    timestamp?: DateTime ;
    description?: ApplicationDescriptionOptions ;
    endpoints?: EndpointDescriptionOptions [] | null;
}
export class JsonServerEndpointsMessage extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaJsonServerEndpointsMessage; }
    public static possibleFields: string[] = [
          "messageId",
           "messageType",
           "publisherId",
           "timestamp",
           "description",
           "endpoints"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(0, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(0, 0);
    public static encodingDefaultXml = makeExpandedNodeId(0, 0);
    public static encodingDefaultJson = makeExpandedNodeId(0, 0);
    public messageId: UAString;
    public messageType: UAString;
    public publisherId: UAString;
    public timestamp: DateTime;
    public description: ApplicationDescription;
    public endpoints: EndpointDescription[] | null;

    constructor(options?: JsonServerEndpointsMessageOptions | null) {

        super(options);

        if (options === null) {
            this.messageId = null;
            this.messageType = null;
            this.publisherId = null;
            this.timestamp = new Date();
         this.description =  new ApplicationDescription(null);
         this.endpoints =  null; /* null array */
              return;
        }
        const schema = JsonServerEndpointsMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) as JsonServerEndpointsMessageOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.messageId = initialize_field(schema.fields[0], options?.messageId);
        this.messageType = initialize_field(schema.fields[1], options?.messageType);
        this.publisherId = initialize_field(schema.fields[2], options?.publisherId);
        this.timestamp = initialize_field(schema.fields[3], options?.timestamp);
        this.description  =  new ApplicationDescription(options.description);
        this.endpoints = []; // should default
        if (options.endpoints) {
            assert(Array.isArray(options.endpoints));
            this.endpoints = options.endpoints.map((e: any) => new EndpointDescription(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.messageId, stream);
        encodeString(this.messageType, stream);
        encodeString(this.publisherId, stream);
        encodeDateTime(this.timestamp, stream);
        this.description.encode(stream);
        encodeArray(this.endpoints, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.messageId = decodeString(stream, this.messageId);
        this.messageType = decodeString(stream, this.messageType);
        this.publisherId = decodeString(stream, this.publisherId);
        this.timestamp = decodeDateTime(stream, this.timestamp);
        this.description.decode(stream);
        this.endpoints = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new EndpointDescription(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaJsonServerEndpointsMessage; }
}
JsonServerEndpointsMessage.schema.dataTypeNodeId = JsonServerEndpointsMessage.dataTypeNodeId;
JsonServerEndpointsMessage.schema.encodingDefaultBinary = JsonServerEndpointsMessage.encodingDefaultBinary;
JsonServerEndpointsMessage.schema.encodingDefaultXml = JsonServerEndpointsMessage.encodingDefaultXml;
JsonServerEndpointsMessage.schema.encodingDefaultJson = JsonServerEndpointsMessage.encodingDefaultJson;
registerClassDefinition( JsonServerEndpointsMessage.dataTypeNodeId, "JsonServerEndpointsMessage", JsonServerEndpointsMessage);

// --------------------------------------------------------------------------------------------
export enum PubSubState {
    Disabled = 0,
    Paused = 1,
    Operational = 2,
    Error = 3,
    PreOperational = 4,
    Invalid = 4294967295
}
const schemaPubSubState = {
    enumValues: PubSubState,
    flaggable: false,
    minValue: 0,
    maxValue: 4,
    name: "PubSubState"
};
function decodePubSubState(stream: BinaryStream, _value?: PubSubState): PubSubState {
    let value =  stream.readUInt32() as PubSubState;
    value = (value < schemaPubSubState.minValue || value > schemaPubSubState.maxValue) ? PubSubState.Invalid : value; 
    return value;
}
function encodePubSubState(value: PubSubState, stream: OutputBinaryStream): void {
    stream.writeUInt32(value);
}
export const _enumerationPubSubState = registerEnumeration(schemaPubSubState);
assert(_enumerationPubSubState.isFlaggable ===  false);
// --------------------------------------------------------------------------------------------
const schemaJsonStatusMessage = buildStructuredType({
    name: "JsonStatusMessage",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "MessageId",

            fieldType: "String",
        },
        {
            name: "MessageType",

            fieldType: "String",
        },
        {
            name: "PublisherId",

            fieldType: "String",
        },
        {
            name: "Timestamp",

            fieldType: "DateTime",
        },
        {
            name: "IsCyclic",

            fieldType: "Boolean",
        },
        {
            name: "Status",

            fieldType: "PubSubState",
        },
        {
            name: "NextReportTime",

            fieldType: "DateTime",
        },
    ]
});
export interface JsonStatusMessageOptions {
    messageId?: UAString ;
    messageType?: UAString ;
    publisherId?: UAString ;
    timestamp?: DateTime ;
    isCyclic?: UABoolean ;
    status?: PubSubState;
    nextReportTime?: DateTime ;
}
export class JsonStatusMessage extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaJsonStatusMessage; }
    public static possibleFields: string[] = [
          "messageId",
           "messageType",
           "publisherId",
           "timestamp",
           "isCyclic",
           "status",
           "nextReportTime"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(0, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(0, 0);
    public static encodingDefaultXml = makeExpandedNodeId(0, 0);
    public static encodingDefaultJson = makeExpandedNodeId(0, 0);
    public messageId: UAString;
    public messageType: UAString;
    public publisherId: UAString;
    public timestamp: DateTime;
    public isCyclic: UABoolean;
    public status: PubSubState;
    public nextReportTime: DateTime;

    constructor(options?: JsonStatusMessageOptions | null) {

        super(options);

        if (options === null) {
            this.messageId = null;
            this.messageType = null;
            this.publisherId = null;
            this.timestamp = new Date();
            this.isCyclic = false;
             this.status =  0 as  PubSubState;
            this.nextReportTime = new Date();
              return;
        }
        const schema = JsonStatusMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) as JsonStatusMessageOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.messageId = initialize_field(schema.fields[0], options?.messageId);
        this.messageType = initialize_field(schema.fields[1], options?.messageType);
        this.publisherId = initialize_field(schema.fields[2], options?.publisherId);
        this.timestamp = initialize_field(schema.fields[3], options?.timestamp);
        this.isCyclic = initialize_field(schema.fields[4], options?.isCyclic);
        this.status = this.setStatus(initialize_field(schema.fields[5], options?.status));
        this.nextReportTime = initialize_field(schema.fields[6], options?.nextReportTime);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.messageId, stream);
        encodeString(this.messageType, stream);
        encodeString(this.publisherId, stream);
        encodeDateTime(this.timestamp, stream);
        encodeBoolean(this.isCyclic, stream);
        encodePubSubState(this.status, stream);
        encodeDateTime(this.nextReportTime, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.messageId = decodeString(stream, this.messageId);
        this.messageType = decodeString(stream, this.messageType);
        this.publisherId = decodeString(stream, this.publisherId);
        this.timestamp = decodeDateTime(stream, this.timestamp);
        this.isCyclic = decodeBoolean(stream, this.isCyclic);
        this.status = decodePubSubState(stream, this.status);
        this.nextReportTime = decodeDateTime(stream, this.nextReportTime);
    }

    // Define Enumeration setters
    public setStatus(value: any): PubSubState {
        const coercedValue = _enumerationPubSubState.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to PubSubState :" + value);
        }
        this.status = coercedValue.value as PubSubState;
        return this.status;
    }
    public get schema(): IStructuredTypeSchema { return schemaJsonStatusMessage; }
}
JsonStatusMessage.schema.dataTypeNodeId = JsonStatusMessage.dataTypeNodeId;
JsonStatusMessage.schema.encodingDefaultBinary = JsonStatusMessage.encodingDefaultBinary;
JsonStatusMessage.schema.encodingDefaultXml = JsonStatusMessage.encodingDefaultXml;
JsonStatusMessage.schema.encodingDefaultJson = JsonStatusMessage.encodingDefaultJson;
registerClassDefinition( JsonStatusMessage.dataTypeNodeId, "JsonStatusMessage", JsonStatusMessage);
// --------------------------------------------------------------------------------------------
const schemaWriterGroupMessageDataType = buildStructuredType({
    name: "WriterGroupMessageDataType",

    baseType: "ExtensionObject",
    fields: [
    ]
});
export interface WriterGroupMessageDataTypeOptions {
}
export class WriterGroupMessageDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaWriterGroupMessageDataType; }
    public static possibleFields: string[] = [
          
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15616, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15693, 0);
    public static encodingDefaultXml = makeExpandedNodeId(15991, 0);
    public static encodingDefaultJson = makeExpandedNodeId(16280, 0);

    constructor(options?: WriterGroupMessageDataTypeOptions | null) {

        super(options);

        if (options === null) {
              return;
        }
        const schema = WriterGroupMessageDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as WriterGroupMessageDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaWriterGroupMessageDataType; }
}
WriterGroupMessageDataType.schema.dataTypeNodeId = WriterGroupMessageDataType.dataTypeNodeId;
WriterGroupMessageDataType.schema.encodingDefaultBinary = WriterGroupMessageDataType.encodingDefaultBinary;
WriterGroupMessageDataType.schema.encodingDefaultXml = WriterGroupMessageDataType.encodingDefaultXml;
WriterGroupMessageDataType.schema.encodingDefaultJson = WriterGroupMessageDataType.encodingDefaultJson;
registerClassDefinition( WriterGroupMessageDataType.dataTypeNodeId, "WriterGroupMessageDataType", WriterGroupMessageDataType);
// --------------------------------------------------------------------------------------------
const schemaJsonWriterGroupMessageDataType = buildStructuredType({
    name: "JsonWriterGroupMessageDataType",

    baseType: "WriterGroupMessageDataType",
    fields: [
        {
            name: "NetworkMessageContentMask",

            fieldType: "JsonNetworkMessageContentMask",
        },
    ]
});
export interface JsonWriterGroupMessageDataTypeOptions extends WriterGroupMessageDataTypeOptions {
    networkMessageContentMask?: JsonNetworkMessageContentMask;
}
export class JsonWriterGroupMessageDataType extends WriterGroupMessageDataType {
    public static get schema(): IStructuredTypeSchema { return schemaJsonWriterGroupMessageDataType; }
    public static possibleFields: string[] = [
          "networkMessageContentMask"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15657, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15719, 0);
    public static encodingDefaultXml = makeExpandedNodeId(16017, 0);
    public static encodingDefaultJson = makeExpandedNodeId(16393, 0);
    public networkMessageContentMask: JsonNetworkMessageContentMask;

    constructor(options?: JsonWriterGroupMessageDataTypeOptions | null) {

        super(options);

        if (options === null) {
             this.networkMessageContentMask =  0 as  JsonNetworkMessageContentMask;
              return;
        }
        const schema = JsonWriterGroupMessageDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as JsonWriterGroupMessageDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.networkMessageContentMask = this.setNetworkMessageContentMask(initialize_field(schema.fields[0], options?.networkMessageContentMask));
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeJsonNetworkMessageContentMask(this.networkMessageContentMask, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.networkMessageContentMask = decodeJsonNetworkMessageContentMask(stream, this.networkMessageContentMask);
    }

    // Define Enumeration setters
    public setNetworkMessageContentMask(value: any): JsonNetworkMessageContentMask {
        const coercedValue = _enumerationJsonNetworkMessageContentMask.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to JsonNetworkMessageContentMask :" + value);
        }
        this.networkMessageContentMask = coercedValue.value as JsonNetworkMessageContentMask;
        return this.networkMessageContentMask;
    }
    public get schema(): IStructuredTypeSchema { return schemaJsonWriterGroupMessageDataType; }
}
JsonWriterGroupMessageDataType.schema.dataTypeNodeId = JsonWriterGroupMessageDataType.dataTypeNodeId;
JsonWriterGroupMessageDataType.schema.encodingDefaultBinary = JsonWriterGroupMessageDataType.encodingDefaultBinary;
JsonWriterGroupMessageDataType.schema.encodingDefaultXml = JsonWriterGroupMessageDataType.encodingDefaultXml;
JsonWriterGroupMessageDataType.schema.encodingDefaultJson = JsonWriterGroupMessageDataType.encodingDefaultJson;
registerClassDefinition( JsonWriterGroupMessageDataType.dataTypeNodeId, "JsonWriterGroupMessageDataType", JsonWriterGroupMessageDataType);
// --------------------------------------------------------------------------------------------
const schemaLinearConversionDataType = buildStructuredType({
    name: "LinearConversionDataType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "InitialAddend",

            fieldType: "Float",
        },
        {
            name: "Multiplicand",

            fieldType: "Float",
        },
        {
            name: "Divisor",

            fieldType: "Float",
        },
        {
            name: "FinalAddend",

            fieldType: "Float",
        },
    ]
});
export interface LinearConversionDataTypeOptions {
    initialAddend?: Float ;
    multiplicand?: Float ;
    divisor?: Float ;
    finalAddend?: Float ;
}
export class LinearConversionDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaLinearConversionDataType; }
    public static possibleFields: string[] = [
          "initialAddend",
           "multiplicand",
           "divisor",
           "finalAddend"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(32435, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(32561, 0);
    public static encodingDefaultXml = makeExpandedNodeId(32573, 0);
    public static encodingDefaultJson = makeExpandedNodeId(32585, 0);
    public initialAddend: Float;
    public multiplicand: Float;
    public divisor: Float;
    public finalAddend: Float;

    constructor(options?: LinearConversionDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.initialAddend = 0;
            this.multiplicand = 0;
            this.divisor = 0;
            this.finalAddend = 0;
              return;
        }
        const schema = LinearConversionDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as LinearConversionDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.initialAddend = initialize_field(schema.fields[0], options?.initialAddend);
        this.multiplicand = initialize_field(schema.fields[1], options?.multiplicand);
        this.divisor = initialize_field(schema.fields[2], options?.divisor);
        this.finalAddend = initialize_field(schema.fields[3], options?.finalAddend);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeFloat(this.initialAddend, stream);
        encodeFloat(this.multiplicand, stream);
        encodeFloat(this.divisor, stream);
        encodeFloat(this.finalAddend, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.initialAddend = decodeFloat(stream, this.initialAddend);
        this.multiplicand = decodeFloat(stream, this.multiplicand);
        this.divisor = decodeFloat(stream, this.divisor);
        this.finalAddend = decodeFloat(stream, this.finalAddend);
    }
    public get schema(): IStructuredTypeSchema { return schemaLinearConversionDataType; }
}
LinearConversionDataType.schema.dataTypeNodeId = LinearConversionDataType.dataTypeNodeId;
LinearConversionDataType.schema.encodingDefaultBinary = LinearConversionDataType.encodingDefaultBinary;
LinearConversionDataType.schema.encodingDefaultXml = LinearConversionDataType.encodingDefaultXml;
LinearConversionDataType.schema.encodingDefaultJson = LinearConversionDataType.encodingDefaultJson;
registerClassDefinition( LinearConversionDataType.dataTypeNodeId, "LinearConversionDataType", LinearConversionDataType);
// --------------------------------------------------------------------------------------------
const schemaLiteralOperand = buildStructuredType({
    name: "LiteralOperand",

    baseType: "FilterOperand",
    fields: [
        {
            name: "Value",

            fieldType: "Variant",
        },
    ]
});
export interface LiteralOperandOptions extends FilterOperandOptions {
    value?: (VariantLike | null);
}
export class LiteralOperand extends FilterOperand {
    public static get schema(): IStructuredTypeSchema { return schemaLiteralOperand; }
    public static possibleFields: string[] = [
          "value"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(595, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(597, 0);
    public static encodingDefaultXml = makeExpandedNodeId(596, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15208, 0);
    public value: Variant;

    constructor(options?: LiteralOperandOptions | null) {

        super(options);

        if (options === null) {
            this.value = new Variant(null);
              return;
        }
        const schema = LiteralOperand.schema;
        options = (schema.constructHook ? schema.constructHook(options) as LiteralOperandOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.value = initialize_field(schema.fields[0], options?.value);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeVariant(this.value, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.value = decodeVariant(stream, this.value);
    }
    public get schema(): IStructuredTypeSchema { return schemaLiteralOperand; }
}
LiteralOperand.schema.dataTypeNodeId = LiteralOperand.dataTypeNodeId;
LiteralOperand.schema.encodingDefaultBinary = LiteralOperand.encodingDefaultBinary;
LiteralOperand.schema.encodingDefaultXml = LiteralOperand.encodingDefaultXml;
LiteralOperand.schema.encodingDefaultJson = LiteralOperand.encodingDefaultJson;
registerClassDefinition( LiteralOperand.dataTypeNodeId, "LiteralOperand", LiteralOperand);

// --------------------------------------------------------------------------------------------
export enum ManAddrIfSubtype {
    None = 0,
    Unknown = 1,
    PortRef = 2,
    SystemPortNumber = 3,
    Invalid = 4294967295
}
const schemaManAddrIfSubtype = {
    enumValues: ManAddrIfSubtype,
    flaggable: false,
    minValue: 0,
    maxValue: 3,
    name: "ManAddrIfSubtype"
};
function decodeManAddrIfSubtype(stream: BinaryStream, _value?: ManAddrIfSubtype): ManAddrIfSubtype {
    let value =  stream.readUInt32() as ManAddrIfSubtype;
    value = (value < schemaManAddrIfSubtype.minValue || value > schemaManAddrIfSubtype.maxValue) ? ManAddrIfSubtype.Invalid : value; 
    return value;
}
function encodeManAddrIfSubtype(value: ManAddrIfSubtype, stream: OutputBinaryStream): void {
    stream.writeUInt32(value);
}
export const _enumerationManAddrIfSubtype = registerEnumeration(schemaManAddrIfSubtype);
assert(_enumerationManAddrIfSubtype.isFlaggable ===  false);
// --------------------------------------------------------------------------------------------
const schemaLldpManagementAddressTxPortType = buildStructuredType({
    name: "LldpManagementAddressTxPortType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "AddressSubtype",

            fieldType: "UInt32",
        },
        {
            name: "ManAddress",

            fieldType: "String",
        },
        {
            name: "TxEnable",

            fieldType: "Boolean",
        },
        {
            name: "AddrLen",

            fieldType: "UInt32",
        },
        {
            name: "IfSubtype",

            fieldType: "ManAddrIfSubtype",
        },
        {
            name: "IfId",

            fieldType: "UInt32",
        },
    ]
});
export interface LldpManagementAddressTxPortTypeOptions {
    addressSubtype?: UInt32 ;
    manAddress?: UAString ;
    txEnable?: UABoolean ;
    addrLen?: UInt32 ;
    ifSubtype?: ManAddrIfSubtype;
    ifId?: UInt32 ;
}
export class LldpManagementAddressTxPortType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaLldpManagementAddressTxPortType; }
    public static possibleFields: string[] = [
          "addressSubtype",
           "manAddress",
           "txEnable",
           "addrLen",
           "ifSubtype",
           "ifId"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(0, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(0, 0);
    public static encodingDefaultXml = makeExpandedNodeId(0, 0);
    public static encodingDefaultJson = makeExpandedNodeId(0, 0);
    public addressSubtype: UInt32;
    public manAddress: UAString;
    public txEnable: UABoolean;
    public addrLen: UInt32;
    public ifSubtype: ManAddrIfSubtype;
    public ifId: UInt32;

    constructor(options?: LldpManagementAddressTxPortTypeOptions | null) {

        super(options);

        if (options === null) {
            this.addressSubtype = 0;
            this.manAddress = null;
            this.txEnable = false;
            this.addrLen = 0;
             this.ifSubtype =  0 as  ManAddrIfSubtype;
            this.ifId = 0;
              return;
        }
        const schema = LldpManagementAddressTxPortType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as LldpManagementAddressTxPortTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.addressSubtype = initialize_field(schema.fields[0], options?.addressSubtype);
        this.manAddress = initialize_field(schema.fields[1], options?.manAddress);
        this.txEnable = initialize_field(schema.fields[2], options?.txEnable);
        this.addrLen = initialize_field(schema.fields[3], options?.addrLen);
        this.ifSubtype = this.setIfSubtype(initialize_field(schema.fields[4], options?.ifSubtype));
        this.ifId = initialize_field(schema.fields[5], options?.ifId);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeUInt32(this.addressSubtype, stream);
        encodeString(this.manAddress, stream);
        encodeBoolean(this.txEnable, stream);
        encodeUInt32(this.addrLen, stream);
        encodeManAddrIfSubtype(this.ifSubtype, stream);
        encodeUInt32(this.ifId, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.addressSubtype = decodeUInt32(stream, this.addressSubtype);
        this.manAddress = decodeString(stream, this.manAddress);
        this.txEnable = decodeBoolean(stream, this.txEnable);
        this.addrLen = decodeUInt32(stream, this.addrLen);
        this.ifSubtype = decodeManAddrIfSubtype(stream, this.ifSubtype);
        this.ifId = decodeUInt32(stream, this.ifId);
    }

    // Define Enumeration setters
    public setIfSubtype(value: any): ManAddrIfSubtype {
        const coercedValue = _enumerationManAddrIfSubtype.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to ManAddrIfSubtype :" + value);
        }
        this.ifSubtype = coercedValue.value as ManAddrIfSubtype;
        return this.ifSubtype;
    }
    public get schema(): IStructuredTypeSchema { return schemaLldpManagementAddressTxPortType; }
}
LldpManagementAddressTxPortType.schema.dataTypeNodeId = LldpManagementAddressTxPortType.dataTypeNodeId;
LldpManagementAddressTxPortType.schema.encodingDefaultBinary = LldpManagementAddressTxPortType.encodingDefaultBinary;
LldpManagementAddressTxPortType.schema.encodingDefaultXml = LldpManagementAddressTxPortType.encodingDefaultXml;
LldpManagementAddressTxPortType.schema.encodingDefaultJson = LldpManagementAddressTxPortType.encodingDefaultJson;
registerClassDefinition( LldpManagementAddressTxPortType.dataTypeNodeId, "LldpManagementAddressTxPortType", LldpManagementAddressTxPortType);
// --------------------------------------------------------------------------------------------
const schemaLldpManagementAddressType = buildStructuredType({
    name: "LldpManagementAddressType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "AddressSubtype",

            fieldType: "UInt32",
        },
        {
            name: "Address",

            fieldType: "String",
        },
        {
            name: "IfSubtype",

            fieldType: "ManAddrIfSubtype",
        },
        {
            name: "IfId",

            fieldType: "UInt32",
        },
    ]
});
export interface LldpManagementAddressTypeOptions {
    addressSubtype?: UInt32 ;
    address?: UAString ;
    ifSubtype?: ManAddrIfSubtype;
    ifId?: UInt32 ;
}
export class LldpManagementAddressType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaLldpManagementAddressType; }
    public static possibleFields: string[] = [
          "addressSubtype",
           "address",
           "ifSubtype",
           "ifId"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(0, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(0, 0);
    public static encodingDefaultXml = makeExpandedNodeId(0, 0);
    public static encodingDefaultJson = makeExpandedNodeId(0, 0);
    public addressSubtype: UInt32;
    public address: UAString;
    public ifSubtype: ManAddrIfSubtype;
    public ifId: UInt32;

    constructor(options?: LldpManagementAddressTypeOptions | null) {

        super(options);

        if (options === null) {
            this.addressSubtype = 0;
            this.address = null;
             this.ifSubtype =  0 as  ManAddrIfSubtype;
            this.ifId = 0;
              return;
        }
        const schema = LldpManagementAddressType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as LldpManagementAddressTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.addressSubtype = initialize_field(schema.fields[0], options?.addressSubtype);
        this.address = initialize_field(schema.fields[1], options?.address);
        this.ifSubtype = this.setIfSubtype(initialize_field(schema.fields[2], options?.ifSubtype));
        this.ifId = initialize_field(schema.fields[3], options?.ifId);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeUInt32(this.addressSubtype, stream);
        encodeString(this.address, stream);
        encodeManAddrIfSubtype(this.ifSubtype, stream);
        encodeUInt32(this.ifId, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.addressSubtype = decodeUInt32(stream, this.addressSubtype);
        this.address = decodeString(stream, this.address);
        this.ifSubtype = decodeManAddrIfSubtype(stream, this.ifSubtype);
        this.ifId = decodeUInt32(stream, this.ifId);
    }

    // Define Enumeration setters
    public setIfSubtype(value: any): ManAddrIfSubtype {
        const coercedValue = _enumerationManAddrIfSubtype.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to ManAddrIfSubtype :" + value);
        }
        this.ifSubtype = coercedValue.value as ManAddrIfSubtype;
        return this.ifSubtype;
    }
    public get schema(): IStructuredTypeSchema { return schemaLldpManagementAddressType; }
}
LldpManagementAddressType.schema.dataTypeNodeId = LldpManagementAddressType.dataTypeNodeId;
LldpManagementAddressType.schema.encodingDefaultBinary = LldpManagementAddressType.encodingDefaultBinary;
LldpManagementAddressType.schema.encodingDefaultXml = LldpManagementAddressType.encodingDefaultXml;
LldpManagementAddressType.schema.encodingDefaultJson = LldpManagementAddressType.encodingDefaultJson;
registerClassDefinition( LldpManagementAddressType.dataTypeNodeId, "LldpManagementAddressType", LldpManagementAddressType);
// --------------------------------------------------------------------------------------------
const schemaLldpTlvType = buildStructuredType({
    name: "LldpTlvType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "TlvType",

            fieldType: "UInt32",
        },
        {
            name: "TlvInfo",

            fieldType: "ByteString",
        },
    ]
});
export interface LldpTlvTypeOptions {
    tlvType?: UInt32 ;
    tlvInfo?: ByteString ;
}
export class LldpTlvType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaLldpTlvType; }
    public static possibleFields: string[] = [
          "tlvType",
           "tlvInfo"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(0, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(0, 0);
    public static encodingDefaultXml = makeExpandedNodeId(0, 0);
    public static encodingDefaultJson = makeExpandedNodeId(0, 0);
    public tlvType: UInt32;
    public tlvInfo: ByteString;

    constructor(options?: LldpTlvTypeOptions | null) {

        super(options);

        if (options === null) {
            this.tlvType = 0;
            this.tlvInfo = Buffer.alloc(0);
              return;
        }
        const schema = LldpTlvType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as LldpTlvTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.tlvType = initialize_field(schema.fields[0], options?.tlvType);
        this.tlvInfo = initialize_field(schema.fields[1], options?.tlvInfo);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeUInt32(this.tlvType, stream);
        encodeByteString(this.tlvInfo, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.tlvType = decodeUInt32(stream, this.tlvType);
        this.tlvInfo = decodeByteString(stream, this.tlvInfo);
    }
    public get schema(): IStructuredTypeSchema { return schemaLldpTlvType; }
}
LldpTlvType.schema.dataTypeNodeId = LldpTlvType.dataTypeNodeId;
LldpTlvType.schema.encodingDefaultBinary = LldpTlvType.encodingDefaultBinary;
LldpTlvType.schema.encodingDefaultXml = LldpTlvType.encodingDefaultXml;
LldpTlvType.schema.encodingDefaultJson = LldpTlvType.encodingDefaultJson;
registerClassDefinition( LldpTlvType.dataTypeNodeId, "LldpTlvType", LldpTlvType);
// --------------------------------------------------------------------------------------------
const schemaMdnsDiscoveryConfiguration = buildStructuredType({
    name: "MdnsDiscoveryConfiguration",

    baseType: "DiscoveryConfiguration",
    fields: [
        {
            name: "MdnsServerName",

            fieldType: "String",
        },
        {
            name: "ServerCapabilities",

            fieldType: "String",
            isArray: true
        },
    ]
});
export interface MdnsDiscoveryConfigurationOptions extends DiscoveryConfigurationOptions {
    mdnsServerName?: UAString ;
    serverCapabilities?: UAString [] | null;
}
export class MdnsDiscoveryConfiguration extends DiscoveryConfiguration {
    public static get schema(): IStructuredTypeSchema { return schemaMdnsDiscoveryConfiguration; }
    public static possibleFields: string[] = [
          "mdnsServerName",
           "serverCapabilities"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(12891, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(12901, 0);
    public static encodingDefaultXml = makeExpandedNodeId(12893, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15106, 0);
    public mdnsServerName: UAString;
    public serverCapabilities: UAString[] | null;

    constructor(options?: MdnsDiscoveryConfigurationOptions | null) {

        super(options);

        if (options === null) {
            this.mdnsServerName = null;
            this.serverCapabilities = []
              return;
        }
        const schema = MdnsDiscoveryConfiguration.schema;
        options = (schema.constructHook ? schema.constructHook(options) as MdnsDiscoveryConfigurationOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.mdnsServerName = initialize_field(schema.fields[0], options?.mdnsServerName);
        this.serverCapabilities = initialize_field_array(schema.fields[1], options?.serverCapabilities);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.mdnsServerName, stream);
        encodeArray(this.serverCapabilities, stream, encodeString);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.mdnsServerName = decodeString(stream, this.mdnsServerName);
        this.serverCapabilities = decodeArray(stream, decodeString);
    }
    public get schema(): IStructuredTypeSchema { return schemaMdnsDiscoveryConfiguration; }
}
MdnsDiscoveryConfiguration.schema.dataTypeNodeId = MdnsDiscoveryConfiguration.dataTypeNodeId;
MdnsDiscoveryConfiguration.schema.encodingDefaultBinary = MdnsDiscoveryConfiguration.encodingDefaultBinary;
MdnsDiscoveryConfiguration.schema.encodingDefaultXml = MdnsDiscoveryConfiguration.encodingDefaultXml;
MdnsDiscoveryConfiguration.schema.encodingDefaultJson = MdnsDiscoveryConfiguration.encodingDefaultJson;
registerClassDefinition( MdnsDiscoveryConfiguration.dataTypeNodeId, "MdnsDiscoveryConfiguration", MdnsDiscoveryConfiguration);
// --------------------------------------------------------------------------------------------
const schemaMethodAttributes = buildStructuredType({
    name: "MethodAttributes",

    baseType: "NodeAttributes",
    fields: [
        {
            name: "Executable",

            fieldType: "Boolean",
        },
        {
            name: "UserExecutable",

            fieldType: "Boolean",
        },
    ]
});
export interface MethodAttributesOptions extends NodeAttributesOptions {
    executable?: UABoolean ;
    userExecutable?: UABoolean ;
}
export class MethodAttributes extends NodeAttributes {
    public static get schema(): IStructuredTypeSchema { return schemaMethodAttributes; }
    public static possibleFields: string[] = [
          "specifiedAttributes",
           "displayName",
           "description",
           "writeMask",
           "userWriteMask",
           "executable",
           "userExecutable"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(358, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(360, 0);
    public static encodingDefaultXml = makeExpandedNodeId(359, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15157, 0);
    public executable: UABoolean;
    public userExecutable: UABoolean;

    constructor(options?: MethodAttributesOptions | null) {

        super(options);

        if (options === null) {
            this.executable = false;
            this.userExecutable = false;
              return;
        }
        const schema = MethodAttributes.schema;
        options = (schema.constructHook ? schema.constructHook(options) as MethodAttributesOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.executable = initialize_field(schema.fields[0], options?.executable);
        this.userExecutable = initialize_field(schema.fields[1], options?.userExecutable);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeBoolean(this.executable, stream);
        encodeBoolean(this.userExecutable, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.executable = decodeBoolean(stream, this.executable);
        this.userExecutable = decodeBoolean(stream, this.userExecutable);
    }
    public get schema(): IStructuredTypeSchema { return schemaMethodAttributes; }
}
MethodAttributes.schema.dataTypeNodeId = MethodAttributes.dataTypeNodeId;
MethodAttributes.schema.encodingDefaultBinary = MethodAttributes.encodingDefaultBinary;
MethodAttributes.schema.encodingDefaultXml = MethodAttributes.encodingDefaultXml;
MethodAttributes.schema.encodingDefaultJson = MethodAttributes.encodingDefaultJson;
registerClassDefinition( MethodAttributes.dataTypeNodeId, "MethodAttributes", MethodAttributes);
// --------------------------------------------------------------------------------------------
const schemaModelChangeStructureDataType = buildStructuredType({
    name: "ModelChangeStructureDataType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Affected",

            fieldType: "NodeId",
        },
        {
            name: "AffectedType",

            fieldType: "NodeId",
        },
        {
            name: "Verb",

            fieldType: "Byte",
        },
    ]
});
export interface ModelChangeStructureDataTypeOptions {
    affected?: (NodeIdLike | null);
    affectedType?: (NodeIdLike | null);
    verb?: Byte ;
}
export class ModelChangeStructureDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaModelChangeStructureDataType; }
    public static possibleFields: string[] = [
          "affected",
           "affectedType",
           "verb"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(877, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(879, 0);
    public static encodingDefaultXml = makeExpandedNodeId(878, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15373, 0);
    public affected: NodeId;
    public affectedType: NodeId;
    public verb: Byte;

    constructor(options?: ModelChangeStructureDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.affected = new NodeId(null);
            this.affectedType = new NodeId(null);
            this.verb = 0;
              return;
        }
        const schema = ModelChangeStructureDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ModelChangeStructureDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.affected = initialize_field(schema.fields[0], options?.affected);
        this.affectedType = initialize_field(schema.fields[1], options?.affectedType);
        this.verb = initialize_field(schema.fields[2], options?.verb);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.affected, stream);
        encodeNodeId(this.affectedType, stream);
        encodeByte(this.verb, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.affected = decodeNodeId(stream, this.affected);
        this.affectedType = decodeNodeId(stream, this.affectedType);
        this.verb = decodeByte(stream, this.verb);
    }
    public get schema(): IStructuredTypeSchema { return schemaModelChangeStructureDataType; }
}
ModelChangeStructureDataType.schema.dataTypeNodeId = ModelChangeStructureDataType.dataTypeNodeId;
ModelChangeStructureDataType.schema.encodingDefaultBinary = ModelChangeStructureDataType.encodingDefaultBinary;
ModelChangeStructureDataType.schema.encodingDefaultXml = ModelChangeStructureDataType.encodingDefaultXml;
ModelChangeStructureDataType.schema.encodingDefaultJson = ModelChangeStructureDataType.encodingDefaultJson;
registerClassDefinition( ModelChangeStructureDataType.dataTypeNodeId, "ModelChangeStructureDataType", ModelChangeStructureDataType);
// --------------------------------------------------------------------------------------------
const schemaMonitoredItemModifyRequest = buildStructuredType({
    name: "MonitoredItemModifyRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "MonitoredItemId",

            fieldType: "UInt32",
        },
        {
            name: "RequestedParameters",

            fieldType: "MonitoringParameters",
        },
    ]
});
export interface MonitoredItemModifyRequestOptions {
    monitoredItemId?: UInt32 ;
    requestedParameters?: MonitoringParametersOptions ;
}
export class MonitoredItemModifyRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaMonitoredItemModifyRequest; }
    public static possibleFields: string[] = [
          "monitoredItemId",
           "requestedParameters"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(755, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(757, 0);
    public static encodingDefaultXml = makeExpandedNodeId(756, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15325, 0);
    public monitoredItemId: UInt32;
    public requestedParameters: MonitoringParameters;

    constructor(options?: MonitoredItemModifyRequestOptions | null) {

        super(options);

        if (options === null) {
            this.monitoredItemId = 0;
         this.requestedParameters =  new MonitoringParameters(null);
              return;
        }
        const schema = MonitoredItemModifyRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as MonitoredItemModifyRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.monitoredItemId = initialize_field(schema.fields[0], options?.monitoredItemId);
        this.requestedParameters  =  new MonitoringParameters(options.requestedParameters);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeUInt32(this.monitoredItemId, stream);
        this.requestedParameters.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.monitoredItemId = decodeUInt32(stream, this.monitoredItemId);
        this.requestedParameters.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaMonitoredItemModifyRequest; }
}
MonitoredItemModifyRequest.schema.dataTypeNodeId = MonitoredItemModifyRequest.dataTypeNodeId;
MonitoredItemModifyRequest.schema.encodingDefaultBinary = MonitoredItemModifyRequest.encodingDefaultBinary;
MonitoredItemModifyRequest.schema.encodingDefaultXml = MonitoredItemModifyRequest.encodingDefaultXml;
MonitoredItemModifyRequest.schema.encodingDefaultJson = MonitoredItemModifyRequest.encodingDefaultJson;
registerClassDefinition( MonitoredItemModifyRequest.dataTypeNodeId, "MonitoredItemModifyRequest", MonitoredItemModifyRequest);
// --------------------------------------------------------------------------------------------
const schemaModifyMonitoredItemsRequest = buildStructuredType({
    name: "ModifyMonitoredItemsRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
        {
            name: "SubscriptionId",

            fieldType: "UInt32",
        },
        {
            name: "TimestampsToReturn",

            fieldType: "TimestampsToReturn",
        },
        {
            name: "ItemsToModify",

            fieldType: "MonitoredItemModifyRequest",
            isArray: true
        },
    ]
});
export interface ModifyMonitoredItemsRequestOptions {
    requestHeader?: RequestHeaderOptions ;
    subscriptionId?: UInt32 ;
    timestampsToReturn?: TimestampsToReturn;
    itemsToModify?: MonitoredItemModifyRequestOptions [] | null;
}
export class ModifyMonitoredItemsRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaModifyMonitoredItemsRequest; }
    public static possibleFields: string[] = [
          "requestHeader",
           "subscriptionId",
           "timestampsToReturn",
           "itemsToModify"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(761, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(763, 0);
    public static encodingDefaultXml = makeExpandedNodeId(762, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15327, 0);
    public requestHeader: RequestHeader;
    public subscriptionId: UInt32;
    public timestampsToReturn: TimestampsToReturn;
    public itemsToModify: MonitoredItemModifyRequest[] | null;

    constructor(options?: ModifyMonitoredItemsRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
            this.subscriptionId = 0;
             this.timestampsToReturn =  0 as  TimestampsToReturn;
         this.itemsToModify =  null; /* null array */
              return;
        }
        const schema = ModifyMonitoredItemsRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ModifyMonitoredItemsRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
        this.subscriptionId = initialize_field(schema.fields[1], options?.subscriptionId);
        this.timestampsToReturn = this.setTimestampsToReturn(initialize_field(schema.fields[2], options?.timestampsToReturn));
        this.itemsToModify = []; // should default
        if (options.itemsToModify) {
            assert(Array.isArray(options.itemsToModify));
            this.itemsToModify = options.itemsToModify.map((e: any) => new MonitoredItemModifyRequest(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        encodeUInt32(this.subscriptionId, stream);
        encodeTimestampsToReturn(this.timestampsToReturn, stream);
        encodeArray(this.itemsToModify, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.subscriptionId = decodeUInt32(stream, this.subscriptionId);
        this.timestampsToReturn = decodeTimestampsToReturn(stream, this.timestampsToReturn);
        this.itemsToModify = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new MonitoredItemModifyRequest(null);
            obj.decode(stream1);
            return obj;
        });
    }

    // Define Enumeration setters
    public setTimestampsToReturn(value: any): TimestampsToReturn {
        const coercedValue = _enumerationTimestampsToReturn.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to TimestampsToReturn :" + value);
        }
        this.timestampsToReturn = coercedValue.value as TimestampsToReturn;
        return this.timestampsToReturn;
    }
    public get schema(): IStructuredTypeSchema { return schemaModifyMonitoredItemsRequest; }
}
ModifyMonitoredItemsRequest.schema.dataTypeNodeId = ModifyMonitoredItemsRequest.dataTypeNodeId;
ModifyMonitoredItemsRequest.schema.encodingDefaultBinary = ModifyMonitoredItemsRequest.encodingDefaultBinary;
ModifyMonitoredItemsRequest.schema.encodingDefaultXml = ModifyMonitoredItemsRequest.encodingDefaultXml;
ModifyMonitoredItemsRequest.schema.encodingDefaultJson = ModifyMonitoredItemsRequest.encodingDefaultJson;
registerClassDefinition( ModifyMonitoredItemsRequest.dataTypeNodeId, "ModifyMonitoredItemsRequest", ModifyMonitoredItemsRequest);
// --------------------------------------------------------------------------------------------
const schemaMonitoredItemModifyResult = buildStructuredType({
    name: "MonitoredItemModifyResult",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "StatusCode",

            fieldType: "StatusCode",
        },
        {
            name: "RevisedSamplingInterval",

            fieldType: "Double",
        },
        {
            name: "RevisedQueueSize",

            fieldType: "UInt32",
        },
        {
            name: "FilterResult",

            fieldType: "ExtensionObject",
        },
    ]
});
export interface MonitoredItemModifyResultOptions {
    statusCode?: StatusCode ;
    revisedSamplingInterval?: Double ;
    revisedQueueSize?: UInt32 ;
    filterResult?: (ExtensionObject | null);
}
export class MonitoredItemModifyResult extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaMonitoredItemModifyResult; }
    public static possibleFields: string[] = [
          "statusCode",
           "revisedSamplingInterval",
           "revisedQueueSize",
           "filterResult"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(758, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(760, 0);
    public static encodingDefaultXml = makeExpandedNodeId(759, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15326, 0);
    public statusCode: StatusCode;
    public revisedSamplingInterval: Double;
    public revisedQueueSize: UInt32;
    public filterResult: (ExtensionObject | null);

    constructor(options?: MonitoredItemModifyResultOptions | null) {

        super(options);

        if (options === null) {
            this.statusCode = StatusCodes.Good;
            this.revisedSamplingInterval = 0;
            this.revisedQueueSize = 0;
            this.filterResult = null;
              return;
        }
        const schema = MonitoredItemModifyResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) as MonitoredItemModifyResultOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.statusCode = initialize_field(schema.fields[0], options?.statusCode);
        this.revisedSamplingInterval = initialize_field(schema.fields[1], options?.revisedSamplingInterval);
        this.revisedQueueSize = initialize_field(schema.fields[2], options?.revisedQueueSize);
        this.filterResult = initialize_field(schema.fields[3], options?.filterResult);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeStatusCode(this.statusCode, stream);
        encodeDouble(this.revisedSamplingInterval, stream);
        encodeUInt32(this.revisedQueueSize, stream);
        encodeExtensionObject(this.filterResult, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.statusCode = decodeStatusCode(stream, this.statusCode);
        this.revisedSamplingInterval = decodeDouble(stream, this.revisedSamplingInterval);
        this.revisedQueueSize = decodeUInt32(stream, this.revisedQueueSize);
        this.filterResult = decodeExtensionObject(stream, this.filterResult);
    }
    public get schema(): IStructuredTypeSchema { return schemaMonitoredItemModifyResult; }
}
MonitoredItemModifyResult.schema.dataTypeNodeId = MonitoredItemModifyResult.dataTypeNodeId;
MonitoredItemModifyResult.schema.encodingDefaultBinary = MonitoredItemModifyResult.encodingDefaultBinary;
MonitoredItemModifyResult.schema.encodingDefaultXml = MonitoredItemModifyResult.encodingDefaultXml;
MonitoredItemModifyResult.schema.encodingDefaultJson = MonitoredItemModifyResult.encodingDefaultJson;
registerClassDefinition( MonitoredItemModifyResult.dataTypeNodeId, "MonitoredItemModifyResult", MonitoredItemModifyResult);
// --------------------------------------------------------------------------------------------
const schemaModifyMonitoredItemsResponse = buildStructuredType({
    name: "ModifyMonitoredItemsResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
        {
            name: "Results",

            fieldType: "MonitoredItemModifyResult",
            isArray: true
        },
        {
            name: "DiagnosticInfos",

            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
export interface ModifyMonitoredItemsResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
    results?: MonitoredItemModifyResultOptions [] | null;
    diagnosticInfos?: (DiagnosticInfo | null)[] | null;
}
export class ModifyMonitoredItemsResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaModifyMonitoredItemsResponse; }
    public static possibleFields: string[] = [
          "responseHeader",
           "results",
           "diagnosticInfos"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(764, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(766, 0);
    public static encodingDefaultXml = makeExpandedNodeId(765, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15328, 0);
    public responseHeader: ResponseHeader;
    public results: MonitoredItemModifyResult[] | null;
    public diagnosticInfos: (DiagnosticInfo | null)[] | null;

    constructor(options?: ModifyMonitoredItemsResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
         this.results =  null; /* null array */
            this.diagnosticInfos = []
              return;
        }
        const schema = ModifyMonitoredItemsResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ModifyMonitoredItemsResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
        this.results = []; // should default
        if (options.results) {
            assert(Array.isArray(options.results));
            this.results = options.results.map((e: any) => new MonitoredItemModifyResult(e));
        }
        this.diagnosticInfos = initialize_field_array(schema.fields[2], options?.diagnosticInfos);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        encodeArray(this.results, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.diagnosticInfos, stream, encodeDiagnosticInfo);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new MonitoredItemModifyResult(null);
            obj.decode(stream1);
            return obj;
        });
        this.diagnosticInfos = decodeArray(stream, decodeDiagnosticInfo);
    }
    public get schema(): IStructuredTypeSchema { return schemaModifyMonitoredItemsResponse; }
}
ModifyMonitoredItemsResponse.schema.dataTypeNodeId = ModifyMonitoredItemsResponse.dataTypeNodeId;
ModifyMonitoredItemsResponse.schema.encodingDefaultBinary = ModifyMonitoredItemsResponse.encodingDefaultBinary;
ModifyMonitoredItemsResponse.schema.encodingDefaultXml = ModifyMonitoredItemsResponse.encodingDefaultXml;
ModifyMonitoredItemsResponse.schema.encodingDefaultJson = ModifyMonitoredItemsResponse.encodingDefaultJson;
registerClassDefinition( ModifyMonitoredItemsResponse.dataTypeNodeId, "ModifyMonitoredItemsResponse", ModifyMonitoredItemsResponse);
// --------------------------------------------------------------------------------------------
const schemaModifySubscriptionRequest = buildStructuredType({
    name: "ModifySubscriptionRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
        {
            name: "SubscriptionId",

            fieldType: "UInt32",
        },
        {
            name: "RequestedPublishingInterval",

            fieldType: "Double",
        },
        {
            name: "RequestedLifetimeCount",

            fieldType: "UInt32",
        },
        {
            name: "RequestedMaxKeepAliveCount",

            fieldType: "UInt32",
        },
        {
            name: "MaxNotificationsPerPublish",

            fieldType: "UInt32",
        },
        {
            name: "Priority",

            fieldType: "Byte",
        },
    ]
});
export interface ModifySubscriptionRequestOptions {
    requestHeader?: RequestHeaderOptions ;
    subscriptionId?: UInt32 ;
    requestedPublishingInterval?: Double ;
    requestedLifetimeCount?: UInt32 ;
    requestedMaxKeepAliveCount?: UInt32 ;
    maxNotificationsPerPublish?: UInt32 ;
    priority?: Byte ;
}
export class ModifySubscriptionRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaModifySubscriptionRequest; }
    public static possibleFields: string[] = [
          "requestHeader",
           "subscriptionId",
           "requestedPublishingInterval",
           "requestedLifetimeCount",
           "requestedMaxKeepAliveCount",
           "maxNotificationsPerPublish",
           "priority"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(791, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(793, 0);
    public static encodingDefaultXml = makeExpandedNodeId(792, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15339, 0);
    public requestHeader: RequestHeader;
    public subscriptionId: UInt32;
    public requestedPublishingInterval: Double;
    public requestedLifetimeCount: UInt32;
    public requestedMaxKeepAliveCount: UInt32;
    public maxNotificationsPerPublish: UInt32;
    public priority: Byte;

    constructor(options?: ModifySubscriptionRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
            this.subscriptionId = 0;
            this.requestedPublishingInterval = 0;
            this.requestedLifetimeCount = 0;
            this.requestedMaxKeepAliveCount = 0;
            this.maxNotificationsPerPublish = 0;
            this.priority = 0;
              return;
        }
        const schema = ModifySubscriptionRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ModifySubscriptionRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
        this.subscriptionId = initialize_field(schema.fields[1], options?.subscriptionId);
        this.requestedPublishingInterval = initialize_field(schema.fields[2], options?.requestedPublishingInterval);
        this.requestedLifetimeCount = initialize_field(schema.fields[3], options?.requestedLifetimeCount);
        this.requestedMaxKeepAliveCount = initialize_field(schema.fields[4], options?.requestedMaxKeepAliveCount);
        this.maxNotificationsPerPublish = initialize_field(schema.fields[5], options?.maxNotificationsPerPublish);
        this.priority = initialize_field(schema.fields[6], options?.priority);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        encodeUInt32(this.subscriptionId, stream);
        encodeDouble(this.requestedPublishingInterval, stream);
        encodeUInt32(this.requestedLifetimeCount, stream);
        encodeUInt32(this.requestedMaxKeepAliveCount, stream);
        encodeUInt32(this.maxNotificationsPerPublish, stream);
        encodeByte(this.priority, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.subscriptionId = decodeUInt32(stream, this.subscriptionId);
        this.requestedPublishingInterval = decodeDouble(stream, this.requestedPublishingInterval);
        this.requestedLifetimeCount = decodeUInt32(stream, this.requestedLifetimeCount);
        this.requestedMaxKeepAliveCount = decodeUInt32(stream, this.requestedMaxKeepAliveCount);
        this.maxNotificationsPerPublish = decodeUInt32(stream, this.maxNotificationsPerPublish);
        this.priority = decodeByte(stream, this.priority);
    }
    public get schema(): IStructuredTypeSchema { return schemaModifySubscriptionRequest; }
}
ModifySubscriptionRequest.schema.dataTypeNodeId = ModifySubscriptionRequest.dataTypeNodeId;
ModifySubscriptionRequest.schema.encodingDefaultBinary = ModifySubscriptionRequest.encodingDefaultBinary;
ModifySubscriptionRequest.schema.encodingDefaultXml = ModifySubscriptionRequest.encodingDefaultXml;
ModifySubscriptionRequest.schema.encodingDefaultJson = ModifySubscriptionRequest.encodingDefaultJson;
registerClassDefinition( ModifySubscriptionRequest.dataTypeNodeId, "ModifySubscriptionRequest", ModifySubscriptionRequest);
// --------------------------------------------------------------------------------------------
const schemaModifySubscriptionResponse = buildStructuredType({
    name: "ModifySubscriptionResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
        {
            name: "RevisedPublishingInterval",

            fieldType: "Double",
        },
        {
            name: "RevisedLifetimeCount",

            fieldType: "UInt32",
        },
        {
            name: "RevisedMaxKeepAliveCount",

            fieldType: "UInt32",
        },
    ]
});
export interface ModifySubscriptionResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
    revisedPublishingInterval?: Double ;
    revisedLifetimeCount?: UInt32 ;
    revisedMaxKeepAliveCount?: UInt32 ;
}
export class ModifySubscriptionResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaModifySubscriptionResponse; }
    public static possibleFields: string[] = [
          "responseHeader",
           "revisedPublishingInterval",
           "revisedLifetimeCount",
           "revisedMaxKeepAliveCount"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(794, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(796, 0);
    public static encodingDefaultXml = makeExpandedNodeId(795, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15340, 0);
    public responseHeader: ResponseHeader;
    public revisedPublishingInterval: Double;
    public revisedLifetimeCount: UInt32;
    public revisedMaxKeepAliveCount: UInt32;

    constructor(options?: ModifySubscriptionResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
            this.revisedPublishingInterval = 0;
            this.revisedLifetimeCount = 0;
            this.revisedMaxKeepAliveCount = 0;
              return;
        }
        const schema = ModifySubscriptionResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ModifySubscriptionResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
        this.revisedPublishingInterval = initialize_field(schema.fields[1], options?.revisedPublishingInterval);
        this.revisedLifetimeCount = initialize_field(schema.fields[2], options?.revisedLifetimeCount);
        this.revisedMaxKeepAliveCount = initialize_field(schema.fields[3], options?.revisedMaxKeepAliveCount);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        encodeDouble(this.revisedPublishingInterval, stream);
        encodeUInt32(this.revisedLifetimeCount, stream);
        encodeUInt32(this.revisedMaxKeepAliveCount, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.revisedPublishingInterval = decodeDouble(stream, this.revisedPublishingInterval);
        this.revisedLifetimeCount = decodeUInt32(stream, this.revisedLifetimeCount);
        this.revisedMaxKeepAliveCount = decodeUInt32(stream, this.revisedMaxKeepAliveCount);
    }
    public get schema(): IStructuredTypeSchema { return schemaModifySubscriptionResponse; }
}
ModifySubscriptionResponse.schema.dataTypeNodeId = ModifySubscriptionResponse.dataTypeNodeId;
ModifySubscriptionResponse.schema.encodingDefaultBinary = ModifySubscriptionResponse.encodingDefaultBinary;
ModifySubscriptionResponse.schema.encodingDefaultXml = ModifySubscriptionResponse.encodingDefaultXml;
ModifySubscriptionResponse.schema.encodingDefaultJson = ModifySubscriptionResponse.encodingDefaultJson;
registerClassDefinition( ModifySubscriptionResponse.dataTypeNodeId, "ModifySubscriptionResponse", ModifySubscriptionResponse);
// --------------------------------------------------------------------------------------------
const schemaNetworkAddressDataType = buildStructuredType({
    name: "NetworkAddressDataType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "NetworkInterface",

            fieldType: "String",
        },
    ]
});
export interface NetworkAddressDataTypeOptions {
    networkInterface?: UAString ;
}
export class NetworkAddressDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaNetworkAddressDataType; }
    public static possibleFields: string[] = [
          "networkInterface"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15502, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(21151, 0);
    public static encodingDefaultXml = makeExpandedNodeId(21175, 0);
    public static encodingDefaultJson = makeExpandedNodeId(21199, 0);
    public networkInterface: UAString;

    constructor(options?: NetworkAddressDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.networkInterface = null;
              return;
        }
        const schema = NetworkAddressDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as NetworkAddressDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.networkInterface = initialize_field(schema.fields[0], options?.networkInterface);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.networkInterface, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.networkInterface = decodeString(stream, this.networkInterface);
    }
    public get schema(): IStructuredTypeSchema { return schemaNetworkAddressDataType; }
}
NetworkAddressDataType.schema.dataTypeNodeId = NetworkAddressDataType.dataTypeNodeId;
NetworkAddressDataType.schema.encodingDefaultBinary = NetworkAddressDataType.encodingDefaultBinary;
NetworkAddressDataType.schema.encodingDefaultXml = NetworkAddressDataType.encodingDefaultXml;
NetworkAddressDataType.schema.encodingDefaultJson = NetworkAddressDataType.encodingDefaultJson;
registerClassDefinition( NetworkAddressDataType.dataTypeNodeId, "NetworkAddressDataType", NetworkAddressDataType);
// --------------------------------------------------------------------------------------------
const schemaNetworkAddressUrlDataType = buildStructuredType({
    name: "NetworkAddressUrlDataType",

    baseType: "NetworkAddressDataType",
    fields: [
        {
            name: "Url",

            fieldType: "String",
        },
    ]
});
export interface NetworkAddressUrlDataTypeOptions extends NetworkAddressDataTypeOptions {
    url?: UAString ;
}
export class NetworkAddressUrlDataType extends NetworkAddressDataType {
    public static get schema(): IStructuredTypeSchema { return schemaNetworkAddressUrlDataType; }
    public static possibleFields: string[] = [
          "networkInterface",
           "url"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15510, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(21152, 0);
    public static encodingDefaultXml = makeExpandedNodeId(21176, 0);
    public static encodingDefaultJson = makeExpandedNodeId(21200, 0);
    public url: UAString;

    constructor(options?: NetworkAddressUrlDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.url = null;
              return;
        }
        const schema = NetworkAddressUrlDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as NetworkAddressUrlDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.url = initialize_field(schema.fields[0], options?.url);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.url, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.url = decodeString(stream, this.url);
    }
    public get schema(): IStructuredTypeSchema { return schemaNetworkAddressUrlDataType; }
}
NetworkAddressUrlDataType.schema.dataTypeNodeId = NetworkAddressUrlDataType.dataTypeNodeId;
NetworkAddressUrlDataType.schema.encodingDefaultBinary = NetworkAddressUrlDataType.encodingDefaultBinary;
NetworkAddressUrlDataType.schema.encodingDefaultXml = NetworkAddressUrlDataType.encodingDefaultXml;
NetworkAddressUrlDataType.schema.encodingDefaultJson = NetworkAddressUrlDataType.encodingDefaultJson;
registerClassDefinition( NetworkAddressUrlDataType.dataTypeNodeId, "NetworkAddressUrlDataType", NetworkAddressUrlDataType);
// --------------------------------------------------------------------------------------------
const schemaNetworkGroupDataType = buildStructuredType({
    name: "NetworkGroupDataType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ServerUri",

            fieldType: "String",
        },
        {
            name: "NetworkPaths",

            fieldType: "EndpointUrlListDataType",
            isArray: true
        },
    ]
});
export interface NetworkGroupDataTypeOptions {
    serverUri?: UAString ;
    networkPaths?: EndpointUrlListDataTypeOptions [] | null;
}
export class NetworkGroupDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaNetworkGroupDataType; }
    public static possibleFields: string[] = [
          "serverUri",
           "networkPaths"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(11944, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(11958, 0);
    public static encodingDefaultXml = makeExpandedNodeId(11950, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15364, 0);
    public serverUri: UAString;
    public networkPaths: EndpointUrlListDataType[] | null;

    constructor(options?: NetworkGroupDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.serverUri = null;
         this.networkPaths =  null; /* null array */
              return;
        }
        const schema = NetworkGroupDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as NetworkGroupDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.serverUri = initialize_field(schema.fields[0], options?.serverUri);
        this.networkPaths = []; // should default
        if (options.networkPaths) {
            assert(Array.isArray(options.networkPaths));
            this.networkPaths = options.networkPaths.map((e: any) => new EndpointUrlListDataType(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.serverUri, stream);
        encodeArray(this.networkPaths, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.serverUri = decodeString(stream, this.serverUri);
        this.networkPaths = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new EndpointUrlListDataType(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaNetworkGroupDataType; }
}
NetworkGroupDataType.schema.dataTypeNodeId = NetworkGroupDataType.dataTypeNodeId;
NetworkGroupDataType.schema.encodingDefaultBinary = NetworkGroupDataType.encodingDefaultBinary;
NetworkGroupDataType.schema.encodingDefaultXml = NetworkGroupDataType.encodingDefaultXml;
NetworkGroupDataType.schema.encodingDefaultJson = NetworkGroupDataType.encodingDefaultJson;
registerClassDefinition( NetworkGroupDataType.dataTypeNodeId, "NetworkGroupDataType", NetworkGroupDataType);
// --------------------------------------------------------------------------------------------
const schemaNodeReference = buildStructuredType({
    name: "NodeReference",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "NodeId",

            fieldType: "NodeId",
        },
        {
            name: "ReferenceTypeId",

            fieldType: "NodeId",
        },
        {
            name: "IsForward",

            fieldType: "Boolean",
        },
        {
            name: "ReferencedNodeIds",

            fieldType: "NodeId",
            isArray: true
        },
    ]
});
export interface NodeReferenceOptions {
    nodeId?: (NodeIdLike | null);
    referenceTypeId?: (NodeIdLike | null);
    isForward?: UABoolean ;
    referencedNodeIds?: (NodeIdLike | null)[] | null;
}
export class NodeReference extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaNodeReference; }
    public static possibleFields: string[] = [
          "nodeId",
           "referenceTypeId",
           "isForward",
           "referencedNodeIds"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(580, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(582, 0);
    public static encodingDefaultXml = makeExpandedNodeId(581, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15203, 0);
    public nodeId: NodeId;
    public referenceTypeId: NodeId;
    public isForward: UABoolean;
    public referencedNodeIds: NodeId[] | null;

    constructor(options?: NodeReferenceOptions | null) {

        super(options);

        if (options === null) {
            this.nodeId = new NodeId(null);
            this.referenceTypeId = new NodeId(null);
            this.isForward = false;
            this.referencedNodeIds = []
              return;
        }
        const schema = NodeReference.schema;
        options = (schema.constructHook ? schema.constructHook(options) as NodeReferenceOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.nodeId = initialize_field(schema.fields[0], options?.nodeId);
        this.referenceTypeId = initialize_field(schema.fields[1], options?.referenceTypeId);
        this.isForward = initialize_field(schema.fields[2], options?.isForward);
        this.referencedNodeIds = initialize_field_array(schema.fields[3], options?.referencedNodeIds);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.nodeId, stream);
        encodeNodeId(this.referenceTypeId, stream);
        encodeBoolean(this.isForward, stream);
        encodeArray(this.referencedNodeIds, stream, encodeNodeId);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.nodeId = decodeNodeId(stream, this.nodeId);
        this.referenceTypeId = decodeNodeId(stream, this.referenceTypeId);
        this.isForward = decodeBoolean(stream, this.isForward);
        this.referencedNodeIds = decodeArray(stream, decodeNodeId);
    }
    public get schema(): IStructuredTypeSchema { return schemaNodeReference; }
}
NodeReference.schema.dataTypeNodeId = NodeReference.dataTypeNodeId;
NodeReference.schema.encodingDefaultBinary = NodeReference.encodingDefaultBinary;
NodeReference.schema.encodingDefaultXml = NodeReference.encodingDefaultXml;
NodeReference.schema.encodingDefaultJson = NodeReference.encodingDefaultJson;
registerClassDefinition( NodeReference.dataTypeNodeId, "NodeReference", NodeReference);
// --------------------------------------------------------------------------------------------
const schemaQueryDataDescription = buildStructuredType({
    name: "QueryDataDescription",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RelativePath",

            fieldType: "RelativePath",
        },
        {
            name: "AttributeId",

            fieldType: "UInt32",
        },
        {
            name: "IndexRange",

            fieldType: "NumericRange",
        },
    ]
});
export interface QueryDataDescriptionOptions {
    relativePath?: RelativePathOptions ;
    attributeId?: UInt32 ;
    indexRange?: NumericRange ;
}
export class QueryDataDescription extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaQueryDataDescription; }
    public static possibleFields: string[] = [
          "relativePath",
           "attributeId",
           "indexRange"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(570, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(572, 0);
    public static encodingDefaultXml = makeExpandedNodeId(571, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15200, 0);
    public relativePath: RelativePath;
    public attributeId: UInt32;
    public indexRange: NumericRange;

    constructor(options?: QueryDataDescriptionOptions | null) {

        super(options);

        if (options === null) {
         this.relativePath =  new RelativePath(null);
            this.attributeId = 0;
            this.indexRange = new NumericRange(null);
              return;
        }
        const schema = QueryDataDescription.schema;
        options = (schema.constructHook ? schema.constructHook(options) as QueryDataDescriptionOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.relativePath  =  new RelativePath(options.relativePath);
        this.attributeId = initialize_field(schema.fields[1], options?.attributeId);
        this.indexRange = initialize_field(schema.fields[2], options?.indexRange);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.relativePath.encode(stream);
        encodeUInt32(this.attributeId, stream);
        encodeNumericRange(this.indexRange, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.relativePath.decode(stream);
        this.attributeId = decodeUInt32(stream, this.attributeId);
        this.indexRange = decodeNumericRange(stream, this.indexRange);
    }
    public get schema(): IStructuredTypeSchema { return schemaQueryDataDescription; }
}
QueryDataDescription.schema.dataTypeNodeId = QueryDataDescription.dataTypeNodeId;
QueryDataDescription.schema.encodingDefaultBinary = QueryDataDescription.encodingDefaultBinary;
QueryDataDescription.schema.encodingDefaultXml = QueryDataDescription.encodingDefaultXml;
QueryDataDescription.schema.encodingDefaultJson = QueryDataDescription.encodingDefaultJson;
registerClassDefinition( QueryDataDescription.dataTypeNodeId, "QueryDataDescription", QueryDataDescription);
// --------------------------------------------------------------------------------------------
const schemaNodeTypeDescription = buildStructuredType({
    name: "NodeTypeDescription",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "TypeDefinitionNode",

            fieldType: "ExpandedNodeId",
        },
        {
            name: "IncludeSubTypes",

            fieldType: "Boolean",
        },
        {
            name: "DataToReturn",

            fieldType: "QueryDataDescription",
            isArray: true
        },
    ]
});
export interface NodeTypeDescriptionOptions {
    typeDefinitionNode?: ExpandedNodeId ;
    includeSubTypes?: UABoolean ;
    dataToReturn?: QueryDataDescriptionOptions [] | null;
}
export class NodeTypeDescription extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaNodeTypeDescription; }
    public static possibleFields: string[] = [
          "typeDefinitionNode",
           "includeSubTypes",
           "dataToReturn"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(573, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(575, 0);
    public static encodingDefaultXml = makeExpandedNodeId(574, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15201, 0);
    public typeDefinitionNode: ExpandedNodeId;
    public includeSubTypes: UABoolean;
    public dataToReturn: QueryDataDescription[] | null;

    constructor(options?: NodeTypeDescriptionOptions | null) {

        super(options);

        if (options === null) {
            this.typeDefinitionNode = new ExpandedNodeId(null);
            this.includeSubTypes = false;
         this.dataToReturn =  null; /* null array */
              return;
        }
        const schema = NodeTypeDescription.schema;
        options = (schema.constructHook ? schema.constructHook(options) as NodeTypeDescriptionOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.typeDefinitionNode = initialize_field(schema.fields[0], options?.typeDefinitionNode);
        this.includeSubTypes = initialize_field(schema.fields[1], options?.includeSubTypes);
        this.dataToReturn = []; // should default
        if (options.dataToReturn) {
            assert(Array.isArray(options.dataToReturn));
            this.dataToReturn = options.dataToReturn.map((e: any) => new QueryDataDescription(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeExpandedNodeId(this.typeDefinitionNode, stream);
        encodeBoolean(this.includeSubTypes, stream);
        encodeArray(this.dataToReturn, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.typeDefinitionNode = decodeExpandedNodeId(stream, this.typeDefinitionNode);
        this.includeSubTypes = decodeBoolean(stream, this.includeSubTypes);
        this.dataToReturn = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new QueryDataDescription(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaNodeTypeDescription; }
}
NodeTypeDescription.schema.dataTypeNodeId = NodeTypeDescription.dataTypeNodeId;
NodeTypeDescription.schema.encodingDefaultBinary = NodeTypeDescription.encodingDefaultBinary;
NodeTypeDescription.schema.encodingDefaultXml = NodeTypeDescription.encodingDefaultXml;
NodeTypeDescription.schema.encodingDefaultJson = NodeTypeDescription.encodingDefaultJson;
registerClassDefinition( NodeTypeDescription.dataTypeNodeId, "NodeTypeDescription", NodeTypeDescription);
// --------------------------------------------------------------------------------------------
const schemaNotificationMessage = buildStructuredType({
    name: "NotificationMessage",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "SequenceNumber",

            fieldType: "UInt32",
        },
        {
            name: "PublishTime",

            fieldType: "DateTime",
        },
        {
            name: "NotificationData",

            fieldType: "ExtensionObject",
            isArray: true
        },
    ]
});
export interface NotificationMessageOptions {
    sequenceNumber?: UInt32 ;
    publishTime?: DateTime ;
    notificationData?: (ExtensionObject | null)[] | null;
}
export class NotificationMessage extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaNotificationMessage; }
    public static possibleFields: string[] = [
          "sequenceNumber",
           "publishTime",
           "notificationData"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(803, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(805, 0);
    public static encodingDefaultXml = makeExpandedNodeId(804, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15343, 0);
    public sequenceNumber: UInt32;
    public publishTime: DateTime;
    public notificationData: (ExtensionObject | null)[] | null;

    constructor(options?: NotificationMessageOptions | null) {

        super(options);

        if (options === null) {
            this.sequenceNumber = 0;
            this.publishTime = new Date();
            this.notificationData = []
              return;
        }
        const schema = NotificationMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) as NotificationMessageOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.sequenceNumber = initialize_field(schema.fields[0], options?.sequenceNumber);
        this.publishTime = initialize_field(schema.fields[1], options?.publishTime);
        this.notificationData = initialize_field_array(schema.fields[2], options?.notificationData);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeUInt32(this.sequenceNumber, stream);
        encodeDateTime(this.publishTime, stream);
        encodeArray(this.notificationData, stream, encodeExtensionObject);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.sequenceNumber = decodeUInt32(stream, this.sequenceNumber);
        this.publishTime = decodeDateTime(stream, this.publishTime);
        this.notificationData = decodeArray(stream, decodeExtensionObject);
    }
    public get schema(): IStructuredTypeSchema { return schemaNotificationMessage; }
}
NotificationMessage.schema.dataTypeNodeId = NotificationMessage.dataTypeNodeId;
NotificationMessage.schema.encodingDefaultBinary = NotificationMessage.encodingDefaultBinary;
NotificationMessage.schema.encodingDefaultXml = NotificationMessage.encodingDefaultXml;
NotificationMessage.schema.encodingDefaultJson = NotificationMessage.encodingDefaultJson;
registerClassDefinition( NotificationMessage.dataTypeNodeId, "NotificationMessage", NotificationMessage);
// --------------------------------------------------------------------------------------------
const schemaObjectAttributes = buildStructuredType({
    name: "ObjectAttributes",

    baseType: "NodeAttributes",
    fields: [
        {
            name: "EventNotifier",

            fieldType: "Byte",
        },
    ]
});
export interface ObjectAttributesOptions extends NodeAttributesOptions {
    eventNotifier?: Byte ;
}
export class ObjectAttributes extends NodeAttributes {
    public static get schema(): IStructuredTypeSchema { return schemaObjectAttributes; }
    public static possibleFields: string[] = [
          "specifiedAttributes",
           "displayName",
           "description",
           "writeMask",
           "userWriteMask",
           "eventNotifier"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(352, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(354, 0);
    public static encodingDefaultXml = makeExpandedNodeId(353, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15152, 0);
    public eventNotifier: Byte;

    constructor(options?: ObjectAttributesOptions | null) {

        super(options);

        if (options === null) {
            this.eventNotifier = 0;
              return;
        }
        const schema = ObjectAttributes.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ObjectAttributesOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.eventNotifier = initialize_field(schema.fields[0], options?.eventNotifier);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeByte(this.eventNotifier, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.eventNotifier = decodeByte(stream, this.eventNotifier);
    }
    public get schema(): IStructuredTypeSchema { return schemaObjectAttributes; }
}
ObjectAttributes.schema.dataTypeNodeId = ObjectAttributes.dataTypeNodeId;
ObjectAttributes.schema.encodingDefaultBinary = ObjectAttributes.encodingDefaultBinary;
ObjectAttributes.schema.encodingDefaultXml = ObjectAttributes.encodingDefaultXml;
ObjectAttributes.schema.encodingDefaultJson = ObjectAttributes.encodingDefaultJson;
registerClassDefinition( ObjectAttributes.dataTypeNodeId, "ObjectAttributes", ObjectAttributes);
// --------------------------------------------------------------------------------------------
const schemaObjectTypeAttributes = buildStructuredType({
    name: "ObjectTypeAttributes",

    baseType: "NodeAttributes",
    fields: [
        {
            name: "IsAbstract",

            fieldType: "Boolean",
        },
    ]
});
export interface ObjectTypeAttributesOptions extends NodeAttributesOptions {
    isAbstract?: UABoolean ;
}
export class ObjectTypeAttributes extends NodeAttributes {
    public static get schema(): IStructuredTypeSchema { return schemaObjectTypeAttributes; }
    public static possibleFields: string[] = [
          "specifiedAttributes",
           "displayName",
           "description",
           "writeMask",
           "userWriteMask",
           "isAbstract"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(361, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(363, 0);
    public static encodingDefaultXml = makeExpandedNodeId(362, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15158, 0);
    public isAbstract: UABoolean;

    constructor(options?: ObjectTypeAttributesOptions | null) {

        super(options);

        if (options === null) {
            this.isAbstract = false;
              return;
        }
        const schema = ObjectTypeAttributes.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ObjectTypeAttributesOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.isAbstract = initialize_field(schema.fields[0], options?.isAbstract);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeBoolean(this.isAbstract, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.isAbstract = decodeBoolean(stream, this.isAbstract);
    }
    public get schema(): IStructuredTypeSchema { return schemaObjectTypeAttributes; }
}
ObjectTypeAttributes.schema.dataTypeNodeId = ObjectTypeAttributes.dataTypeNodeId;
ObjectTypeAttributes.schema.encodingDefaultBinary = ObjectTypeAttributes.encodingDefaultBinary;
ObjectTypeAttributes.schema.encodingDefaultXml = ObjectTypeAttributes.encodingDefaultXml;
ObjectTypeAttributes.schema.encodingDefaultJson = ObjectTypeAttributes.encodingDefaultJson;
registerClassDefinition( ObjectTypeAttributes.dataTypeNodeId, "ObjectTypeAttributes", ObjectTypeAttributes);

// --------------------------------------------------------------------------------------------
export enum SecurityTokenRequestType {
    Issue = 0,
    Renew = 1,
    Invalid = 4294967295
}
const schemaSecurityTokenRequestType = {
    enumValues: SecurityTokenRequestType,
    flaggable: false,
    minValue: 0,
    maxValue: 1,
    name: "SecurityTokenRequestType"
};
function decodeSecurityTokenRequestType(stream: BinaryStream, _value?: SecurityTokenRequestType): SecurityTokenRequestType {
    let value =  stream.readUInt32() as SecurityTokenRequestType;
    value = (value < schemaSecurityTokenRequestType.minValue || value > schemaSecurityTokenRequestType.maxValue) ? SecurityTokenRequestType.Invalid : value; 
    return value;
}
function encodeSecurityTokenRequestType(value: SecurityTokenRequestType, stream: OutputBinaryStream): void {
    stream.writeUInt32(value);
}
export const _enumerationSecurityTokenRequestType = registerEnumeration(schemaSecurityTokenRequestType);
assert(_enumerationSecurityTokenRequestType.isFlaggable ===  false);
// --------------------------------------------------------------------------------------------
const schemaOpenSecureChannelRequest = buildStructuredType({
    name: "OpenSecureChannelRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
        {
            name: "ClientProtocolVersion",

            fieldType: "UInt32",
        },
        {
            name: "RequestType",

            fieldType: "SecurityTokenRequestType",
        },
        {
            name: "SecurityMode",

            fieldType: "MessageSecurityMode",
        },
        {
            name: "ClientNonce",

            fieldType: "ByteString",
        },
        {
            name: "RequestedLifetime",

            fieldType: "UInt32",
        },
    ]
});
export interface OpenSecureChannelRequestOptions {
    requestHeader?: RequestHeaderOptions ;
    clientProtocolVersion?: UInt32 ;
    requestType?: SecurityTokenRequestType;
    securityMode?: MessageSecurityMode;
    clientNonce?: ByteString ;
    requestedLifetime?: UInt32 ;
}
export class OpenSecureChannelRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaOpenSecureChannelRequest; }
    public static possibleFields: string[] = [
          "requestHeader",
           "clientProtocolVersion",
           "requestType",
           "securityMode",
           "clientNonce",
           "requestedLifetime"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(444, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(446, 0);
    public static encodingDefaultXml = makeExpandedNodeId(445, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15132, 0);
    public requestHeader: RequestHeader;
    public clientProtocolVersion: UInt32;
    public requestType: SecurityTokenRequestType;
    public securityMode: MessageSecurityMode;
    public clientNonce: ByteString;
    public requestedLifetime: UInt32;

    constructor(options?: OpenSecureChannelRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
            this.clientProtocolVersion = 0;
             this.requestType =  0 as  SecurityTokenRequestType;
             this.securityMode =  0 as  MessageSecurityMode;
            this.clientNonce = Buffer.alloc(0);
            this.requestedLifetime = 0;
              return;
        }
        const schema = OpenSecureChannelRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as OpenSecureChannelRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
        this.clientProtocolVersion = initialize_field(schema.fields[1], options?.clientProtocolVersion);
        this.requestType = this.setRequestType(initialize_field(schema.fields[2], options?.requestType));
        this.securityMode = this.setSecurityMode(initialize_field(schema.fields[3], options?.securityMode));
        this.clientNonce = initialize_field(schema.fields[4], options?.clientNonce);
        this.requestedLifetime = initialize_field(schema.fields[5], options?.requestedLifetime);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        encodeUInt32(this.clientProtocolVersion, stream);
        encodeSecurityTokenRequestType(this.requestType, stream);
        encodeMessageSecurityMode(this.securityMode, stream);
        encodeByteString(this.clientNonce, stream);
        encodeUInt32(this.requestedLifetime, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.clientProtocolVersion = decodeUInt32(stream, this.clientProtocolVersion);
        this.requestType = decodeSecurityTokenRequestType(stream, this.requestType);
        this.securityMode = decodeMessageSecurityMode(stream, this.securityMode);
        this.clientNonce = decodeByteString(stream, this.clientNonce);
        this.requestedLifetime = decodeUInt32(stream, this.requestedLifetime);
    }

    // Define Enumeration setters
    public setRequestType(value: any): SecurityTokenRequestType {
        const coercedValue = _enumerationSecurityTokenRequestType.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to SecurityTokenRequestType :" + value);
        }
        this.requestType = coercedValue.value as SecurityTokenRequestType;
        return this.requestType;
    }
    public setSecurityMode(value: any): MessageSecurityMode {
        const coercedValue = _enumerationMessageSecurityMode.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to MessageSecurityMode :" + value);
        }
        this.securityMode = coercedValue.value as MessageSecurityMode;
        return this.securityMode;
    }
    public get schema(): IStructuredTypeSchema { return schemaOpenSecureChannelRequest; }
}
OpenSecureChannelRequest.schema.dataTypeNodeId = OpenSecureChannelRequest.dataTypeNodeId;
OpenSecureChannelRequest.schema.encodingDefaultBinary = OpenSecureChannelRequest.encodingDefaultBinary;
OpenSecureChannelRequest.schema.encodingDefaultXml = OpenSecureChannelRequest.encodingDefaultXml;
OpenSecureChannelRequest.schema.encodingDefaultJson = OpenSecureChannelRequest.encodingDefaultJson;
registerClassDefinition( OpenSecureChannelRequest.dataTypeNodeId, "OpenSecureChannelRequest", OpenSecureChannelRequest);
// --------------------------------------------------------------------------------------------
const schemaOpenSecureChannelResponse = buildStructuredType({
    name: "OpenSecureChannelResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
        {
            name: "ServerProtocolVersion",

            fieldType: "UInt32",
        },
        {
            name: "SecurityToken",

            fieldType: "ChannelSecurityToken",
        },
        {
            name: "ServerNonce",

            fieldType: "ByteString",
        },
    ]
});
export interface OpenSecureChannelResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
    serverProtocolVersion?: UInt32 ;
    securityToken?: ChannelSecurityTokenOptions ;
    serverNonce?: ByteString ;
}
export class OpenSecureChannelResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaOpenSecureChannelResponse; }
    public static possibleFields: string[] = [
          "responseHeader",
           "serverProtocolVersion",
           "securityToken",
           "serverNonce"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(447, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(449, 0);
    public static encodingDefaultXml = makeExpandedNodeId(448, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15133, 0);
    public responseHeader: ResponseHeader;
    public serverProtocolVersion: UInt32;
    public securityToken: ChannelSecurityToken;
    public serverNonce: ByteString;

    constructor(options?: OpenSecureChannelResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
            this.serverProtocolVersion = 0;
         this.securityToken =  new ChannelSecurityToken(null);
            this.serverNonce = Buffer.alloc(0);
              return;
        }
        const schema = OpenSecureChannelResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as OpenSecureChannelResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
        this.serverProtocolVersion = initialize_field(schema.fields[1], options?.serverProtocolVersion);
        this.securityToken  =  new ChannelSecurityToken(options.securityToken);
        this.serverNonce = initialize_field(schema.fields[3], options?.serverNonce);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        encodeUInt32(this.serverProtocolVersion, stream);
        this.securityToken.encode(stream);
        encodeByteString(this.serverNonce, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.serverProtocolVersion = decodeUInt32(stream, this.serverProtocolVersion);
        this.securityToken.decode(stream);
        this.serverNonce = decodeByteString(stream, this.serverNonce);
    }
    public get schema(): IStructuredTypeSchema { return schemaOpenSecureChannelResponse; }
}
OpenSecureChannelResponse.schema.dataTypeNodeId = OpenSecureChannelResponse.dataTypeNodeId;
OpenSecureChannelResponse.schema.encodingDefaultBinary = OpenSecureChannelResponse.encodingDefaultBinary;
OpenSecureChannelResponse.schema.encodingDefaultXml = OpenSecureChannelResponse.encodingDefaultXml;
OpenSecureChannelResponse.schema.encodingDefaultJson = OpenSecureChannelResponse.encodingDefaultJson;
registerClassDefinition( OpenSecureChannelResponse.dataTypeNodeId, "OpenSecureChannelResponse", OpenSecureChannelResponse);
// --------------------------------------------------------------------------------------------
const schemaOptionSet = buildStructuredType({
    name: "OptionSet",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Value",

            fieldType: "ByteString",
        },
        {
            name: "ValidBits",

            fieldType: "ByteString",
        },
    ]
});
export interface OptionSetOptions {
    value?: ByteString ;
    validBits?: ByteString ;
}
export class OptionSet extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaOptionSet; }
    public static possibleFields: string[] = [
          "value",
           "validBits"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(12755, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(12765, 0);
    public static encodingDefaultXml = makeExpandedNodeId(12757, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15084, 0);
    public value: ByteString;
    public validBits: ByteString;

    constructor(options?: OptionSetOptions | null) {

        super(options);

        if (options === null) {
            this.value = Buffer.alloc(0);
            this.validBits = Buffer.alloc(0);
              return;
        }
        const schema = OptionSet.schema;
        options = (schema.constructHook ? schema.constructHook(options) as OptionSetOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.value = initialize_field(schema.fields[0], options?.value);
        this.validBits = initialize_field(schema.fields[1], options?.validBits);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeByteString(this.value, stream);
        encodeByteString(this.validBits, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.value = decodeByteString(stream, this.value);
        this.validBits = decodeByteString(stream, this.validBits);
    }
    public get schema(): IStructuredTypeSchema { return schemaOptionSet; }
}
OptionSet.schema.dataTypeNodeId = OptionSet.dataTypeNodeId;
OptionSet.schema.encodingDefaultBinary = OptionSet.encodingDefaultBinary;
OptionSet.schema.encodingDefaultXml = OptionSet.encodingDefaultXml;
OptionSet.schema.encodingDefaultJson = OptionSet.encodingDefaultJson;
registerClassDefinition( OptionSet.dataTypeNodeId, "OptionSet", OptionSet);
// --------------------------------------------------------------------------------------------
const schemaOrientation = buildStructuredType({
    name: "Orientation",

    baseType: "ExtensionObject",
    fields: [
    ]
});
export interface OrientationOptions {
}
export class Orientation extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaOrientation; }
    public static possibleFields: string[] = [
          
    ];
    public static dataTypeNodeId = makeExpandedNodeId(18811, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(18820, 0);
    public static encodingDefaultXml = makeExpandedNodeId(18856, 0);
    public static encodingDefaultJson = makeExpandedNodeId(19069, 0);

    constructor(options?: OrientationOptions | null) {

        super(options);

        if (options === null) {
              return;
        }
        const schema = Orientation.schema;
        options = (schema.constructHook ? schema.constructHook(options) as OrientationOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaOrientation; }
}
Orientation.schema.dataTypeNodeId = Orientation.dataTypeNodeId;
Orientation.schema.encodingDefaultBinary = Orientation.encodingDefaultBinary;
Orientation.schema.encodingDefaultXml = Orientation.encodingDefaultXml;
Orientation.schema.encodingDefaultJson = Orientation.encodingDefaultJson;
registerClassDefinition( Orientation.dataTypeNodeId, "Orientation", Orientation);
// --------------------------------------------------------------------------------------------
const schemaParsingResult = buildStructuredType({
    name: "ParsingResult",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "StatusCode",

            fieldType: "StatusCode",
        },
        {
            name: "DataStatusCodes",

            fieldType: "StatusCode",
            isArray: true
        },
        {
            name: "DataDiagnosticInfos",

            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
export interface ParsingResultOptions {
    statusCode?: StatusCode ;
    dataStatusCodes?: StatusCode [] | null;
    dataDiagnosticInfos?: (DiagnosticInfo | null)[] | null;
}
export class ParsingResult extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaParsingResult; }
    public static possibleFields: string[] = [
          "statusCode",
           "dataStatusCodes",
           "dataDiagnosticInfos"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(610, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(612, 0);
    public static encodingDefaultXml = makeExpandedNodeId(611, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15236, 0);
    public statusCode: StatusCode;
    public dataStatusCodes: StatusCode[] | null;
    public dataDiagnosticInfos: (DiagnosticInfo | null)[] | null;

    constructor(options?: ParsingResultOptions | null) {

        super(options);

        if (options === null) {
            this.statusCode = StatusCodes.Good;
            this.dataStatusCodes = []
            this.dataDiagnosticInfos = []
              return;
        }
        const schema = ParsingResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ParsingResultOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.statusCode = initialize_field(schema.fields[0], options?.statusCode);
        this.dataStatusCodes = initialize_field_array(schema.fields[1], options?.dataStatusCodes);
        this.dataDiagnosticInfos = initialize_field_array(schema.fields[2], options?.dataDiagnosticInfos);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeStatusCode(this.statusCode, stream);
        encodeArray(this.dataStatusCodes, stream, encodeStatusCode);
        encodeArray(this.dataDiagnosticInfos, stream, encodeDiagnosticInfo);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.statusCode = decodeStatusCode(stream, this.statusCode);
        this.dataStatusCodes = decodeArray(stream, decodeStatusCode);
        this.dataDiagnosticInfos = decodeArray(stream, decodeDiagnosticInfo);
    }
    public get schema(): IStructuredTypeSchema { return schemaParsingResult; }
}
ParsingResult.schema.dataTypeNodeId = ParsingResult.dataTypeNodeId;
ParsingResult.schema.encodingDefaultBinary = ParsingResult.encodingDefaultBinary;
ParsingResult.schema.encodingDefaultXml = ParsingResult.encodingDefaultXml;
ParsingResult.schema.encodingDefaultJson = ParsingResult.encodingDefaultJson;
registerClassDefinition( ParsingResult.dataTypeNodeId, "ParsingResult", ParsingResult);
// --------------------------------------------------------------------------------------------
const schemaPortableNodeId = buildStructuredType({
    name: "PortableNodeId",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "NamespaceUri",

            fieldType: "String",
        },
        {
            name: "Identifier",

            fieldType: "NodeId",
        },
    ]
});
export interface PortableNodeIdOptions {
    namespaceUri?: UAString ;
    identifier?: (NodeIdLike | null);
}
export class PortableNodeId extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaPortableNodeId; }
    public static possibleFields: string[] = [
          "namespaceUri",
           "identifier"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(24106, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(24109, 0);
    public static encodingDefaultXml = makeExpandedNodeId(24121, 0);
    public static encodingDefaultJson = makeExpandedNodeId(24133, 0);
    public namespaceUri: UAString;
    public identifier: NodeId;

    constructor(options?: PortableNodeIdOptions | null) {

        super(options);

        if (options === null) {
            this.namespaceUri = null;
            this.identifier = new NodeId(null);
              return;
        }
        const schema = PortableNodeId.schema;
        options = (schema.constructHook ? schema.constructHook(options) as PortableNodeIdOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.namespaceUri = initialize_field(schema.fields[0], options?.namespaceUri);
        this.identifier = initialize_field(schema.fields[1], options?.identifier);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.namespaceUri, stream);
        encodeNodeId(this.identifier, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.namespaceUri = decodeString(stream, this.namespaceUri);
        this.identifier = decodeNodeId(stream, this.identifier);
    }
    public get schema(): IStructuredTypeSchema { return schemaPortableNodeId; }
}
PortableNodeId.schema.dataTypeNodeId = PortableNodeId.dataTypeNodeId;
PortableNodeId.schema.encodingDefaultBinary = PortableNodeId.encodingDefaultBinary;
PortableNodeId.schema.encodingDefaultXml = PortableNodeId.encodingDefaultXml;
PortableNodeId.schema.encodingDefaultJson = PortableNodeId.encodingDefaultJson;
registerClassDefinition( PortableNodeId.dataTypeNodeId, "PortableNodeId", PortableNodeId);
// --------------------------------------------------------------------------------------------
const schemaPortableQualifiedName = buildStructuredType({
    name: "PortableQualifiedName",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "NamespaceUri",

            fieldType: "String",
        },
        {
            name: "Name",

            fieldType: "String",
        },
    ]
});
export interface PortableQualifiedNameOptions {
    namespaceUri?: UAString ;
    name?: UAString ;
}
export class PortableQualifiedName extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaPortableQualifiedName; }
    public static possibleFields: string[] = [
          "namespaceUri",
           "name"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(24105, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(24108, 0);
    public static encodingDefaultXml = makeExpandedNodeId(24120, 0);
    public static encodingDefaultJson = makeExpandedNodeId(24132, 0);
    public namespaceUri: UAString;
    public name: UAString;

    constructor(options?: PortableQualifiedNameOptions | null) {

        super(options);

        if (options === null) {
            this.namespaceUri = null;
            this.name = null;
              return;
        }
        const schema = PortableQualifiedName.schema;
        options = (schema.constructHook ? schema.constructHook(options) as PortableQualifiedNameOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.namespaceUri = initialize_field(schema.fields[0], options?.namespaceUri);
        this.name = initialize_field(schema.fields[1], options?.name);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.namespaceUri, stream);
        encodeString(this.name, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.namespaceUri = decodeString(stream, this.namespaceUri);
        this.name = decodeString(stream, this.name);
    }
    public get schema(): IStructuredTypeSchema { return schemaPortableQualifiedName; }
}
PortableQualifiedName.schema.dataTypeNodeId = PortableQualifiedName.dataTypeNodeId;
PortableQualifiedName.schema.encodingDefaultBinary = PortableQualifiedName.encodingDefaultBinary;
PortableQualifiedName.schema.encodingDefaultXml = PortableQualifiedName.encodingDefaultXml;
PortableQualifiedName.schema.encodingDefaultJson = PortableQualifiedName.encodingDefaultJson;
registerClassDefinition( PortableQualifiedName.dataTypeNodeId, "PortableQualifiedName", PortableQualifiedName);
// --------------------------------------------------------------------------------------------
const schemaPriorityMappingEntryType = buildStructuredType({
    name: "PriorityMappingEntryType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "MappingUri",

            fieldType: "String",
        },
        {
            name: "PriorityLabel",

            fieldType: "String",
        },
        {
            name: "PriorityValue_PCP",

            fieldType: "Byte",
        },
        {
            name: "PriorityValue_DSCP",

            fieldType: "UInt32",
        },
    ]
});
export interface PriorityMappingEntryTypeOptions {
    mappingUri?: UAString ;
    priorityLabel?: UAString ;
    priorityValue_PCP?: Byte ;
    priorityValue_DSCP?: UInt32 ;
}
export class PriorityMappingEntryType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaPriorityMappingEntryType; }
    public static possibleFields: string[] = [
          "mappingUri",
           "priorityLabel",
           "priorityValue_PCP",
           "priorityValue_DSCP"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(25220, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(25239, 0);
    public static encodingDefaultXml = makeExpandedNodeId(25243, 0);
    public static encodingDefaultJson = makeExpandedNodeId(25247, 0);
    public mappingUri: UAString;
    public priorityLabel: UAString;
    public priorityValue_PCP: Byte;
    public priorityValue_DSCP: UInt32;

    constructor(options?: PriorityMappingEntryTypeOptions | null) {

        super(options);

        if (options === null) {
            this.mappingUri = null;
            this.priorityLabel = null;
            this.priorityValue_PCP = 0;
            this.priorityValue_DSCP = 0;
              return;
        }
        const schema = PriorityMappingEntryType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as PriorityMappingEntryTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.mappingUri = initialize_field(schema.fields[0], options?.mappingUri);
        this.priorityLabel = initialize_field(schema.fields[1], options?.priorityLabel);
        this.priorityValue_PCP = initialize_field(schema.fields[2], options?.priorityValue_PCP);
        this.priorityValue_DSCP = initialize_field(schema.fields[3], options?.priorityValue_DSCP);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.mappingUri, stream);
        encodeString(this.priorityLabel, stream);
        encodeByte(this.priorityValue_PCP, stream);
        encodeUInt32(this.priorityValue_DSCP, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.mappingUri = decodeString(stream, this.mappingUri);
        this.priorityLabel = decodeString(stream, this.priorityLabel);
        this.priorityValue_PCP = decodeByte(stream, this.priorityValue_PCP);
        this.priorityValue_DSCP = decodeUInt32(stream, this.priorityValue_DSCP);
    }
    public get schema(): IStructuredTypeSchema { return schemaPriorityMappingEntryType; }
}
PriorityMappingEntryType.schema.dataTypeNodeId = PriorityMappingEntryType.dataTypeNodeId;
PriorityMappingEntryType.schema.encodingDefaultBinary = PriorityMappingEntryType.encodingDefaultBinary;
PriorityMappingEntryType.schema.encodingDefaultXml = PriorityMappingEntryType.encodingDefaultXml;
PriorityMappingEntryType.schema.encodingDefaultJson = PriorityMappingEntryType.encodingDefaultJson;
registerClassDefinition( PriorityMappingEntryType.dataTypeNodeId, "PriorityMappingEntryType", PriorityMappingEntryType);
// --------------------------------------------------------------------------------------------
const schemaProgramDiagnostic2DataType = buildStructuredType({
    name: "ProgramDiagnostic2DataType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "CreateSessionId",

            fieldType: "NodeId",
        },
        {
            name: "CreateClientName",

            fieldType: "String",
        },
        {
            name: "InvocationCreationTime",

            fieldType: "DateTime",
        },
        {
            name: "LastTransitionTime",

            fieldType: "DateTime",
        },
        {
            name: "LastMethodCall",

            fieldType: "String",
        },
        {
            name: "LastMethodSessionId",

            fieldType: "NodeId",
        },
        {
            name: "LastMethodInputArguments",

            fieldType: "Argument",
            isArray: true
        },
        {
            name: "LastMethodOutputArguments",

            fieldType: "Argument",
            isArray: true
        },
        {
            name: "LastMethodInputValues",

            fieldType: "Variant",
            isArray: true
        },
        {
            name: "LastMethodOutputValues",

            fieldType: "Variant",
            isArray: true
        },
        {
            name: "LastMethodCallTime",

            fieldType: "DateTime",
        },
        {
            name: "LastMethodReturnStatus",

            fieldType: "StatusCode",
        },
    ]
});
export interface ProgramDiagnostic2DataTypeOptions {
    createSessionId?: (NodeIdLike | null);
    createClientName?: UAString ;
    invocationCreationTime?: DateTime ;
    lastTransitionTime?: DateTime ;
    lastMethodCall?: UAString ;
    lastMethodSessionId?: (NodeIdLike | null);
    lastMethodInputArguments?: ArgumentOptions [] | null;
    lastMethodOutputArguments?: ArgumentOptions [] | null;
    lastMethodInputValues?: (VariantLike | null)[] | null;
    lastMethodOutputValues?: (VariantLike | null)[] | null;
    lastMethodCallTime?: DateTime ;
    lastMethodReturnStatus?: StatusCode ;
}
export class ProgramDiagnostic2DataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaProgramDiagnostic2DataType; }
    public static possibleFields: string[] = [
          "createSessionId",
           "createClientName",
           "invocationCreationTime",
           "lastTransitionTime",
           "lastMethodCall",
           "lastMethodSessionId",
           "lastMethodInputArguments",
           "lastMethodOutputArguments",
           "lastMethodInputValues",
           "lastMethodOutputValues",
           "lastMethodCallTime",
           "lastMethodReturnStatus"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(24033, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(24034, 0);
    public static encodingDefaultXml = makeExpandedNodeId(24038, 0);
    public static encodingDefaultJson = makeExpandedNodeId(24042, 0);
    public createSessionId: NodeId;
    public createClientName: UAString;
    public invocationCreationTime: DateTime;
    public lastTransitionTime: DateTime;
    public lastMethodCall: UAString;
    public lastMethodSessionId: NodeId;
    public lastMethodInputArguments: Argument[] | null;
    public lastMethodOutputArguments: Argument[] | null;
    public lastMethodInputValues: Variant[] | null;
    public lastMethodOutputValues: Variant[] | null;
    public lastMethodCallTime: DateTime;
    public lastMethodReturnStatus: StatusCode;

    constructor(options?: ProgramDiagnostic2DataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.createSessionId = new NodeId(null);
            this.createClientName = null;
            this.invocationCreationTime = new Date();
            this.lastTransitionTime = new Date();
            this.lastMethodCall = null;
            this.lastMethodSessionId = new NodeId(null);
         this.lastMethodInputArguments =  null; /* null array */
         this.lastMethodOutputArguments =  null; /* null array */
            this.lastMethodInputValues = []
            this.lastMethodOutputValues = []
            this.lastMethodCallTime = new Date();
            this.lastMethodReturnStatus = StatusCodes.Good;
              return;
        }
        const schema = ProgramDiagnostic2DataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ProgramDiagnostic2DataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.createSessionId = initialize_field(schema.fields[0], options?.createSessionId);
        this.createClientName = initialize_field(schema.fields[1], options?.createClientName);
        this.invocationCreationTime = initialize_field(schema.fields[2], options?.invocationCreationTime);
        this.lastTransitionTime = initialize_field(schema.fields[3], options?.lastTransitionTime);
        this.lastMethodCall = initialize_field(schema.fields[4], options?.lastMethodCall);
        this.lastMethodSessionId = initialize_field(schema.fields[5], options?.lastMethodSessionId);
        this.lastMethodInputArguments = []; // should default
        if (options.lastMethodInputArguments) {
            assert(Array.isArray(options.lastMethodInputArguments));
            this.lastMethodInputArguments = options.lastMethodInputArguments.map((e: any) => new Argument(e));
        }
        this.lastMethodOutputArguments = []; // should default
        if (options.lastMethodOutputArguments) {
            assert(Array.isArray(options.lastMethodOutputArguments));
            this.lastMethodOutputArguments = options.lastMethodOutputArguments.map((e: any) => new Argument(e));
        }
        this.lastMethodInputValues = initialize_field_array(schema.fields[8], options?.lastMethodInputValues);
        this.lastMethodOutputValues = initialize_field_array(schema.fields[9], options?.lastMethodOutputValues);
        this.lastMethodCallTime = initialize_field(schema.fields[10], options?.lastMethodCallTime);
        this.lastMethodReturnStatus = initialize_field(schema.fields[11], options?.lastMethodReturnStatus);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.createSessionId, stream);
        encodeString(this.createClientName, stream);
        encodeDateTime(this.invocationCreationTime, stream);
        encodeDateTime(this.lastTransitionTime, stream);
        encodeString(this.lastMethodCall, stream);
        encodeNodeId(this.lastMethodSessionId, stream);
        encodeArray(this.lastMethodInputArguments, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.lastMethodOutputArguments, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.lastMethodInputValues, stream, encodeVariant);
        encodeArray(this.lastMethodOutputValues, stream, encodeVariant);
        encodeDateTime(this.lastMethodCallTime, stream);
        encodeStatusCode(this.lastMethodReturnStatus, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.createSessionId = decodeNodeId(stream, this.createSessionId);
        this.createClientName = decodeString(stream, this.createClientName);
        this.invocationCreationTime = decodeDateTime(stream, this.invocationCreationTime);
        this.lastTransitionTime = decodeDateTime(stream, this.lastTransitionTime);
        this.lastMethodCall = decodeString(stream, this.lastMethodCall);
        this.lastMethodSessionId = decodeNodeId(stream, this.lastMethodSessionId);
        this.lastMethodInputArguments = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new Argument(null);
            obj.decode(stream1);
            return obj;
        });
        this.lastMethodOutputArguments = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new Argument(null);
            obj.decode(stream1);
            return obj;
        });
        this.lastMethodInputValues = decodeArray(stream, decodeVariant);
        this.lastMethodOutputValues = decodeArray(stream, decodeVariant);
        this.lastMethodCallTime = decodeDateTime(stream, this.lastMethodCallTime);
        this.lastMethodReturnStatus = decodeStatusCode(stream, this.lastMethodReturnStatus);
    }
    public get schema(): IStructuredTypeSchema { return schemaProgramDiagnostic2DataType; }
}
ProgramDiagnostic2DataType.schema.dataTypeNodeId = ProgramDiagnostic2DataType.dataTypeNodeId;
ProgramDiagnostic2DataType.schema.encodingDefaultBinary = ProgramDiagnostic2DataType.encodingDefaultBinary;
ProgramDiagnostic2DataType.schema.encodingDefaultXml = ProgramDiagnostic2DataType.encodingDefaultXml;
ProgramDiagnostic2DataType.schema.encodingDefaultJson = ProgramDiagnostic2DataType.encodingDefaultJson;
registerClassDefinition( ProgramDiagnostic2DataType.dataTypeNodeId, "ProgramDiagnostic2DataType", ProgramDiagnostic2DataType);
// --------------------------------------------------------------------------------------------
const schemaStatusResult = buildStructuredType({
    name: "StatusResult",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "StatusCode",

            fieldType: "StatusCode",
        },
        {
            name: "DiagnosticInfo",

            fieldType: "DiagnosticInfo",
        },
    ]
});
export interface StatusResultOptions {
    statusCode?: StatusCode ;
    diagnosticInfo?: (DiagnosticInfo | null);
}
export class StatusResult extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaStatusResult; }
    public static possibleFields: string[] = [
          "statusCode",
           "diagnosticInfo"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(299, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(301, 0);
    public static encodingDefaultXml = makeExpandedNodeId(300, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15371, 0);
    public statusCode: StatusCode;
    public diagnosticInfo: (DiagnosticInfo | null);

    constructor(options?: StatusResultOptions | null) {

        super(options);

        if (options === null) {
            this.statusCode = StatusCodes.Good;
            this.diagnosticInfo = null;
              return;
        }
        const schema = StatusResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) as StatusResultOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.statusCode = initialize_field(schema.fields[0], options?.statusCode);
        this.diagnosticInfo = initialize_field(schema.fields[1], options?.diagnosticInfo);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeStatusCode(this.statusCode, stream);
        encodeDiagnosticInfo(this.diagnosticInfo, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.statusCode = decodeStatusCode(stream, this.statusCode);
        this.diagnosticInfo = decodeDiagnosticInfo(stream, this.diagnosticInfo);
    }
    public get schema(): IStructuredTypeSchema { return schemaStatusResult; }
}
StatusResult.schema.dataTypeNodeId = StatusResult.dataTypeNodeId;
StatusResult.schema.encodingDefaultBinary = StatusResult.encodingDefaultBinary;
StatusResult.schema.encodingDefaultXml = StatusResult.encodingDefaultXml;
StatusResult.schema.encodingDefaultJson = StatusResult.encodingDefaultJson;
registerClassDefinition( StatusResult.dataTypeNodeId, "StatusResult", StatusResult);
// --------------------------------------------------------------------------------------------
const schemaProgramDiagnosticDataType = buildStructuredType({
    name: "ProgramDiagnosticDataType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "CreateSessionId",

            fieldType: "NodeId",
        },
        {
            name: "CreateClientName",

            fieldType: "String",
        },
        {
            name: "InvocationCreationTime",

            fieldType: "DateTime",
        },
        {
            name: "LastTransitionTime",

            fieldType: "DateTime",
        },
        {
            name: "LastMethodCall",

            fieldType: "String",
        },
        {
            name: "LastMethodSessionId",

            fieldType: "NodeId",
        },
        {
            name: "LastMethodInputArguments",

            fieldType: "Argument",
            isArray: true
        },
        {
            name: "LastMethodOutputArguments",

            fieldType: "Argument",
            isArray: true
        },
        {
            name: "LastMethodCallTime",

            fieldType: "DateTime",
        },
        {
            name: "LastMethodReturnStatus",

            fieldType: "StatusResult",
        },
    ]
});
export interface ProgramDiagnosticDataTypeOptions {
    createSessionId?: (NodeIdLike | null);
    createClientName?: UAString ;
    invocationCreationTime?: DateTime ;
    lastTransitionTime?: DateTime ;
    lastMethodCall?: UAString ;
    lastMethodSessionId?: (NodeIdLike | null);
    lastMethodInputArguments?: ArgumentOptions [] | null;
    lastMethodOutputArguments?: ArgumentOptions [] | null;
    lastMethodCallTime?: DateTime ;
    lastMethodReturnStatus?: StatusResultOptions ;
}
export class ProgramDiagnosticDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaProgramDiagnosticDataType; }
    public static possibleFields: string[] = [
          "createSessionId",
           "createClientName",
           "invocationCreationTime",
           "lastTransitionTime",
           "lastMethodCall",
           "lastMethodSessionId",
           "lastMethodInputArguments",
           "lastMethodOutputArguments",
           "lastMethodCallTime",
           "lastMethodReturnStatus"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(894, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(896, 0);
    public static encodingDefaultXml = makeExpandedNodeId(895, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15381, 0);
    public createSessionId: NodeId;
    public createClientName: UAString;
    public invocationCreationTime: DateTime;
    public lastTransitionTime: DateTime;
    public lastMethodCall: UAString;
    public lastMethodSessionId: NodeId;
    public lastMethodInputArguments: Argument[] | null;
    public lastMethodOutputArguments: Argument[] | null;
    public lastMethodCallTime: DateTime;
    public lastMethodReturnStatus: StatusResult;

    constructor(options?: ProgramDiagnosticDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.createSessionId = new NodeId(null);
            this.createClientName = null;
            this.invocationCreationTime = new Date();
            this.lastTransitionTime = new Date();
            this.lastMethodCall = null;
            this.lastMethodSessionId = new NodeId(null);
         this.lastMethodInputArguments =  null; /* null array */
         this.lastMethodOutputArguments =  null; /* null array */
            this.lastMethodCallTime = new Date();
         this.lastMethodReturnStatus =  new StatusResult(null);
              return;
        }
        const schema = ProgramDiagnosticDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as ProgramDiagnosticDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.createSessionId = initialize_field(schema.fields[0], options?.createSessionId);
        this.createClientName = initialize_field(schema.fields[1], options?.createClientName);
        this.invocationCreationTime = initialize_field(schema.fields[2], options?.invocationCreationTime);
        this.lastTransitionTime = initialize_field(schema.fields[3], options?.lastTransitionTime);
        this.lastMethodCall = initialize_field(schema.fields[4], options?.lastMethodCall);
        this.lastMethodSessionId = initialize_field(schema.fields[5], options?.lastMethodSessionId);
        this.lastMethodInputArguments = []; // should default
        if (options.lastMethodInputArguments) {
            assert(Array.isArray(options.lastMethodInputArguments));
            this.lastMethodInputArguments = options.lastMethodInputArguments.map((e: any) => new Argument(e));
        }
        this.lastMethodOutputArguments = []; // should default
        if (options.lastMethodOutputArguments) {
            assert(Array.isArray(options.lastMethodOutputArguments));
            this.lastMethodOutputArguments = options.lastMethodOutputArguments.map((e: any) => new Argument(e));
        }
        this.lastMethodCallTime = initialize_field(schema.fields[8], options?.lastMethodCallTime);
        this.lastMethodReturnStatus  =  new StatusResult(options.lastMethodReturnStatus);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.createSessionId, stream);
        encodeString(this.createClientName, stream);
        encodeDateTime(this.invocationCreationTime, stream);
        encodeDateTime(this.lastTransitionTime, stream);
        encodeString(this.lastMethodCall, stream);
        encodeNodeId(this.lastMethodSessionId, stream);
        encodeArray(this.lastMethodInputArguments, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.lastMethodOutputArguments, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeDateTime(this.lastMethodCallTime, stream);
        this.lastMethodReturnStatus.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.createSessionId = decodeNodeId(stream, this.createSessionId);
        this.createClientName = decodeString(stream, this.createClientName);
        this.invocationCreationTime = decodeDateTime(stream, this.invocationCreationTime);
        this.lastTransitionTime = decodeDateTime(stream, this.lastTransitionTime);
        this.lastMethodCall = decodeString(stream, this.lastMethodCall);
        this.lastMethodSessionId = decodeNodeId(stream, this.lastMethodSessionId);
        this.lastMethodInputArguments = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new Argument(null);
            obj.decode(stream1);
            return obj;
        });
        this.lastMethodOutputArguments = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new Argument(null);
            obj.decode(stream1);
            return obj;
        });
        this.lastMethodCallTime = decodeDateTime(stream, this.lastMethodCallTime);
        this.lastMethodReturnStatus.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaProgramDiagnosticDataType; }
}
ProgramDiagnosticDataType.schema.dataTypeNodeId = ProgramDiagnosticDataType.dataTypeNodeId;
ProgramDiagnosticDataType.schema.encodingDefaultBinary = ProgramDiagnosticDataType.encodingDefaultBinary;
ProgramDiagnosticDataType.schema.encodingDefaultXml = ProgramDiagnosticDataType.encodingDefaultXml;
ProgramDiagnosticDataType.schema.encodingDefaultJson = ProgramDiagnosticDataType.encodingDefaultJson;
registerClassDefinition( ProgramDiagnosticDataType.dataTypeNodeId, "ProgramDiagnosticDataType", ProgramDiagnosticDataType);
// --------------------------------------------------------------------------------------------
const schemaPublishedDataSetDataType = buildStructuredType({
    name: "PublishedDataSetDataType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Name",

            fieldType: "String",
        },
        {
            name: "DataSetFolder",

            fieldType: "String",
            isArray: true
        },
        {
            name: "DataSetMetaData",

            fieldType: "DataSetMetaDataType",
        },
        {
            name: "ExtensionFields",

            fieldType: "KeyValuePair",
            isArray: true
        },
        {
            name: "DataSetSource",

            fieldType: "ExtensionObject",
        },
    ]
});
export interface PublishedDataSetDataTypeOptions {
    name?: UAString ;
    dataSetFolder?: UAString [] | null;
    dataSetMetaData?: DataSetMetaDataTypeOptions ;
    extensionFields?: KeyValuePairOptions [] | null;
    dataSetSource?: (ExtensionObject | null);
}
export class PublishedDataSetDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaPublishedDataSetDataType; }
    public static possibleFields: string[] = [
          "name",
           "dataSetFolder",
           "dataSetMetaData",
           "extensionFields",
           "dataSetSource"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15578, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15677, 0);
    public static encodingDefaultXml = makeExpandedNodeId(15951, 0);
    public static encodingDefaultJson = makeExpandedNodeId(16152, 0);
    public name: UAString;
    public dataSetFolder: UAString[] | null;
    public dataSetMetaData: DataSetMetaDataType;
    public extensionFields: KeyValuePair[] | null;
    public dataSetSource: (ExtensionObject | null);

    constructor(options?: PublishedDataSetDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.name = null;
            this.dataSetFolder = []
         this.dataSetMetaData =  new DataSetMetaDataType(null);
         this.extensionFields =  null; /* null array */
            this.dataSetSource = null;
              return;
        }
        const schema = PublishedDataSetDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as PublishedDataSetDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.name = initialize_field(schema.fields[0], options?.name);
        this.dataSetFolder = initialize_field_array(schema.fields[1], options?.dataSetFolder);
        this.dataSetMetaData  =  new DataSetMetaDataType(options.dataSetMetaData);
        this.extensionFields = []; // should default
        if (options.extensionFields) {
            assert(Array.isArray(options.extensionFields));
            this.extensionFields = options.extensionFields.map((e: any) => new KeyValuePair(e));
        }
        this.dataSetSource = initialize_field(schema.fields[4], options?.dataSetSource);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.name, stream);
        encodeArray(this.dataSetFolder, stream, encodeString);
        this.dataSetMetaData.encode(stream);
        encodeArray(this.extensionFields, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeExtensionObject(this.dataSetSource, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = decodeString(stream, this.name);
        this.dataSetFolder = decodeArray(stream, decodeString);
        this.dataSetMetaData.decode(stream);
        this.extensionFields = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new KeyValuePair(null);
            obj.decode(stream1);
            return obj;
        });
        this.dataSetSource = decodeExtensionObject(stream, this.dataSetSource);
    }
    public get schema(): IStructuredTypeSchema { return schemaPublishedDataSetDataType; }
}
PublishedDataSetDataType.schema.dataTypeNodeId = PublishedDataSetDataType.dataTypeNodeId;
PublishedDataSetDataType.schema.encodingDefaultBinary = PublishedDataSetDataType.encodingDefaultBinary;
PublishedDataSetDataType.schema.encodingDefaultXml = PublishedDataSetDataType.encodingDefaultXml;
PublishedDataSetDataType.schema.encodingDefaultJson = PublishedDataSetDataType.encodingDefaultJson;
registerClassDefinition( PublishedDataSetDataType.dataTypeNodeId, "PublishedDataSetDataType", PublishedDataSetDataType);
// --------------------------------------------------------------------------------------------
const schemaPubSubConfigurationDataType = buildStructuredType({
    name: "PubSubConfigurationDataType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "PublishedDataSets",

            fieldType: "PublishedDataSetDataType",
            isArray: true
        },
        {
            name: "Connections",

            fieldType: "PubSubConnectionDataType",
            isArray: true
        },
        {
            name: "Enabled",

            fieldType: "Boolean",
        },
    ]
});
export interface PubSubConfigurationDataTypeOptions {
    publishedDataSets?: PublishedDataSetDataTypeOptions [] | null;
    connections?: PubSubConnectionDataTypeOptions [] | null;
    enabled?: UABoolean ;
}
export class PubSubConfigurationDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaPubSubConfigurationDataType; }
    public static possibleFields: string[] = [
          "publishedDataSets",
           "connections",
           "enabled"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15530, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(21154, 0);
    public static encodingDefaultXml = makeExpandedNodeId(21178, 0);
    public static encodingDefaultJson = makeExpandedNodeId(21202, 0);
    public publishedDataSets: PublishedDataSetDataType[] | null;
    public connections: PubSubConnectionDataType[] | null;
    public enabled: UABoolean;

    constructor(options?: PubSubConfigurationDataTypeOptions | null) {

        super(options);

        if (options === null) {
         this.publishedDataSets =  null; /* null array */
         this.connections =  null; /* null array */
            this.enabled = false;
              return;
        }
        const schema = PubSubConfigurationDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as PubSubConfigurationDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.publishedDataSets = []; // should default
        if (options.publishedDataSets) {
            assert(Array.isArray(options.publishedDataSets));
            this.publishedDataSets = options.publishedDataSets.map((e: any) => new PublishedDataSetDataType(e));
        }
        this.connections = []; // should default
        if (options.connections) {
            assert(Array.isArray(options.connections));
            this.connections = options.connections.map((e: any) => new PubSubConnectionDataType(e));
        }
        this.enabled = initialize_field(schema.fields[2], options?.enabled);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeArray(this.publishedDataSets, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.connections, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeBoolean(this.enabled, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.publishedDataSets = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new PublishedDataSetDataType(null);
            obj.decode(stream1);
            return obj;
        });
        this.connections = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new PubSubConnectionDataType(null);
            obj.decode(stream1);
            return obj;
        });
        this.enabled = decodeBoolean(stream, this.enabled);
    }
    public get schema(): IStructuredTypeSchema { return schemaPubSubConfigurationDataType; }
}
PubSubConfigurationDataType.schema.dataTypeNodeId = PubSubConfigurationDataType.dataTypeNodeId;
PubSubConfigurationDataType.schema.encodingDefaultBinary = PubSubConfigurationDataType.encodingDefaultBinary;
PubSubConfigurationDataType.schema.encodingDefaultXml = PubSubConfigurationDataType.encodingDefaultXml;
PubSubConfigurationDataType.schema.encodingDefaultJson = PubSubConfigurationDataType.encodingDefaultJson;
registerClassDefinition( PubSubConfigurationDataType.dataTypeNodeId, "PubSubConfigurationDataType", PubSubConfigurationDataType);
// --------------------------------------------------------------------------------------------
const schemaSubscribedDataSetDataType = buildStructuredType({
    name: "SubscribedDataSetDataType",

    baseType: "ExtensionObject",
    fields: [
    ]
});
export interface SubscribedDataSetDataTypeOptions {
}
export class SubscribedDataSetDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaSubscribedDataSetDataType; }
    public static possibleFields: string[] = [
          
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15630, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15707, 0);
    public static encodingDefaultXml = makeExpandedNodeId(16010, 0);
    public static encodingDefaultJson = makeExpandedNodeId(16308, 0);

    constructor(options?: SubscribedDataSetDataTypeOptions | null) {

        super(options);

        if (options === null) {
              return;
        }
        const schema = SubscribedDataSetDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as SubscribedDataSetDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaSubscribedDataSetDataType; }
}
SubscribedDataSetDataType.schema.dataTypeNodeId = SubscribedDataSetDataType.dataTypeNodeId;
SubscribedDataSetDataType.schema.encodingDefaultBinary = SubscribedDataSetDataType.encodingDefaultBinary;
SubscribedDataSetDataType.schema.encodingDefaultXml = SubscribedDataSetDataType.encodingDefaultXml;
SubscribedDataSetDataType.schema.encodingDefaultJson = SubscribedDataSetDataType.encodingDefaultJson;
registerClassDefinition( SubscribedDataSetDataType.dataTypeNodeId, "SubscribedDataSetDataType", SubscribedDataSetDataType);
// --------------------------------------------------------------------------------------------
const schemaStandaloneSubscribedDataSetDataType = buildStructuredType({
    name: "StandaloneSubscribedDataSetDataType",

    baseType: "SubscribedDataSetDataType",
    fields: [
        {
            name: "Name",

            fieldType: "String",
        },
        {
            name: "DataSetFolder",

            fieldType: "String",
            isArray: true
        },
        {
            name: "DataSetMetaData",

            fieldType: "DataSetMetaDataType",
        },
        {
            name: "SubscribedDataSet",

            fieldType: "ExtensionObject",
        },
    ]
});
export interface StandaloneSubscribedDataSetDataTypeOptions extends SubscribedDataSetDataTypeOptions {
    name?: UAString ;
    dataSetFolder?: UAString [] | null;
    dataSetMetaData?: DataSetMetaDataTypeOptions ;
    subscribedDataSet?: (ExtensionObject | null);
}
export class StandaloneSubscribedDataSetDataType extends SubscribedDataSetDataType {
    public static get schema(): IStructuredTypeSchema { return schemaStandaloneSubscribedDataSetDataType; }
    public static possibleFields: string[] = [
          "name",
           "dataSetFolder",
           "dataSetMetaData",
           "subscribedDataSet"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(23600, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(23852, 0);
    public static encodingDefaultXml = makeExpandedNodeId(23920, 0);
    public static encodingDefaultJson = makeExpandedNodeId(23988, 0);
    public name: UAString;
    public dataSetFolder: UAString[] | null;
    public dataSetMetaData: DataSetMetaDataType;
    public subscribedDataSet: (ExtensionObject | null);

    constructor(options?: StandaloneSubscribedDataSetDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.name = null;
            this.dataSetFolder = []
         this.dataSetMetaData =  new DataSetMetaDataType(null);
            this.subscribedDataSet = null;
              return;
        }
        const schema = StandaloneSubscribedDataSetDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as StandaloneSubscribedDataSetDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.name = initialize_field(schema.fields[0], options?.name);
        this.dataSetFolder = initialize_field_array(schema.fields[1], options?.dataSetFolder);
        this.dataSetMetaData  =  new DataSetMetaDataType(options.dataSetMetaData);
        this.subscribedDataSet = initialize_field(schema.fields[3], options?.subscribedDataSet);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.name, stream);
        encodeArray(this.dataSetFolder, stream, encodeString);
        this.dataSetMetaData.encode(stream);
        encodeExtensionObject(this.subscribedDataSet, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = decodeString(stream, this.name);
        this.dataSetFolder = decodeArray(stream, decodeString);
        this.dataSetMetaData.decode(stream);
        this.subscribedDataSet = decodeExtensionObject(stream, this.subscribedDataSet);
    }
    public get schema(): IStructuredTypeSchema { return schemaStandaloneSubscribedDataSetDataType; }
}
StandaloneSubscribedDataSetDataType.schema.dataTypeNodeId = StandaloneSubscribedDataSetDataType.dataTypeNodeId;
StandaloneSubscribedDataSetDataType.schema.encodingDefaultBinary = StandaloneSubscribedDataSetDataType.encodingDefaultBinary;
StandaloneSubscribedDataSetDataType.schema.encodingDefaultXml = StandaloneSubscribedDataSetDataType.encodingDefaultXml;
StandaloneSubscribedDataSetDataType.schema.encodingDefaultJson = StandaloneSubscribedDataSetDataType.encodingDefaultJson;
registerClassDefinition( StandaloneSubscribedDataSetDataType.dataTypeNodeId, "StandaloneSubscribedDataSetDataType", StandaloneSubscribedDataSetDataType);

// --------------------------------------------------------------------------------------------
export enum PermissionType {
    None = 0,
    Browse = 1,
    ReadRolePermissions = 2,
    WriteAttribute = 4,
    WriteRolePermissions = 8,
    WriteHistorizing = 16,
    Read = 32,
    Write = 64,
    ReadHistory = 128,
    InsertHistory = 256,
    ModifyHistory = 512,
    DeleteHistory = 1024,
    ReceiveEvents = 2048,
    Call = 4096,
    AddReference = 8192,
    RemoveReference = 16384,
    DeleteNode = 32768,
    AddNode = 65536
}
const schemaPermissionType = {
    enumValues: PermissionType,
    flaggable: true,
    name: "PermissionType"
};
function decodePermissionType(stream: BinaryStream, _value?: PermissionType): PermissionType {
    return  stream.readUInt32() as PermissionType;
}
function encodePermissionType(value: PermissionType, stream: OutputBinaryStream): void {
    stream.writeUInt32(value);
}
export const _enumerationPermissionType = registerEnumeration(schemaPermissionType);
assert(_enumerationPermissionType.isFlaggable ===  true);
// --------------------------------------------------------------------------------------------
const schemaRolePermissionType = buildStructuredType({
    name: "RolePermissionType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RoleId",

            fieldType: "NodeId",
        },
        {
            name: "Permissions",

            fieldType: "PermissionType",
        },
    ]
});
export interface RolePermissionTypeOptions {
    roleId?: (NodeIdLike | null);
    permissions?: PermissionType;
}
export class RolePermissionType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaRolePermissionType; }
    public static possibleFields: string[] = [
          "roleId",
           "permissions"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(96, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(128, 0);
    public static encodingDefaultXml = makeExpandedNodeId(16126, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15062, 0);
    public roleId: NodeId;
    public permissions: PermissionType;

    constructor(options?: RolePermissionTypeOptions | null) {

        super(options);

        if (options === null) {
            this.roleId = new NodeId(null);
             this.permissions =  0 as  PermissionType;
              return;
        }
        const schema = RolePermissionType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as RolePermissionTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.roleId = initialize_field(schema.fields[0], options?.roleId);
        this.permissions = this.setPermissions(initialize_field(schema.fields[1], options?.permissions));
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.roleId, stream);
        encodePermissionType(this.permissions, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.roleId = decodeNodeId(stream, this.roleId);
        this.permissions = decodePermissionType(stream, this.permissions);
    }

    // Define Enumeration setters
    public setPermissions(value: any): PermissionType {
        const coercedValue = _enumerationPermissionType.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to PermissionType :" + value);
        }
        this.permissions = coercedValue.value as PermissionType;
        return this.permissions;
    }
    public get schema(): IStructuredTypeSchema { return schemaRolePermissionType; }
}
RolePermissionType.schema.dataTypeNodeId = RolePermissionType.dataTypeNodeId;
RolePermissionType.schema.encodingDefaultBinary = RolePermissionType.encodingDefaultBinary;
RolePermissionType.schema.encodingDefaultXml = RolePermissionType.encodingDefaultXml;
RolePermissionType.schema.encodingDefaultJson = RolePermissionType.encodingDefaultJson;
registerClassDefinition( RolePermissionType.dataTypeNodeId, "RolePermissionType", RolePermissionType);
// --------------------------------------------------------------------------------------------
const schemaSecurityGroupDataType = buildStructuredType({
    name: "SecurityGroupDataType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "Name",

            fieldType: "String",
        },
        {
            name: "SecurityGroupFolder",

            fieldType: "String",
            isArray: true
        },
        {
            name: "KeyLifetime",

            fieldType: "Double",
        },
        {
            name: "SecurityPolicyUri",

            fieldType: "String",
        },
        {
            name: "MaxFutureKeyCount",

            fieldType: "UInt32",
        },
        {
            name: "MaxPastKeyCount",

            fieldType: "UInt32",
        },
        {
            name: "SecurityGroupId",

            fieldType: "String",
        },
        {
            name: "RolePermissions",

            fieldType: "RolePermissionType",
            isArray: true
        },
        {
            name: "GroupProperties",

            fieldType: "KeyValuePair",
            isArray: true
        },
    ]
});
export interface SecurityGroupDataTypeOptions {
    name?: UAString ;
    securityGroupFolder?: UAString [] | null;
    keyLifetime?: Double ;
    securityPolicyUri?: UAString ;
    maxFutureKeyCount?: UInt32 ;
    maxPastKeyCount?: UInt32 ;
    securityGroupId?: UAString ;
    rolePermissions?: RolePermissionTypeOptions [] | null;
    groupProperties?: KeyValuePairOptions [] | null;
}
export class SecurityGroupDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaSecurityGroupDataType; }
    public static possibleFields: string[] = [
          "name",
           "securityGroupFolder",
           "keyLifetime",
           "securityPolicyUri",
           "maxFutureKeyCount",
           "maxPastKeyCount",
           "securityGroupId",
           "rolePermissions",
           "groupProperties"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(23601, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(23853, 0);
    public static encodingDefaultXml = makeExpandedNodeId(23921, 0);
    public static encodingDefaultJson = makeExpandedNodeId(23989, 0);
    public name: UAString;
    public securityGroupFolder: UAString[] | null;
    public keyLifetime: Double;
    public securityPolicyUri: UAString;
    public maxFutureKeyCount: UInt32;
    public maxPastKeyCount: UInt32;
    public securityGroupId: UAString;
    public rolePermissions: RolePermissionType[] | null;
    public groupProperties: KeyValuePair[] | null;

    constructor(options?: SecurityGroupDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.name = null;
            this.securityGroupFolder = []
            this.keyLifetime = 0;
            this.securityPolicyUri = null;
            this.maxFutureKeyCount = 0;
            this.maxPastKeyCount = 0;
            this.securityGroupId = null;
         this.rolePermissions =  null; /* null array */
         this.groupProperties =  null; /* null array */
              return;
        }
        const schema = SecurityGroupDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as SecurityGroupDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.name = initialize_field(schema.fields[0], options?.name);
        this.securityGroupFolder = initialize_field_array(schema.fields[1], options?.securityGroupFolder);
        this.keyLifetime = initialize_field(schema.fields[2], options?.keyLifetime);
        this.securityPolicyUri = initialize_field(schema.fields[3], options?.securityPolicyUri);
        this.maxFutureKeyCount = initialize_field(schema.fields[4], options?.maxFutureKeyCount);
        this.maxPastKeyCount = initialize_field(schema.fields[5], options?.maxPastKeyCount);
        this.securityGroupId = initialize_field(schema.fields[6], options?.securityGroupId);
        this.rolePermissions = []; // should default
        if (options.rolePermissions) {
            assert(Array.isArray(options.rolePermissions));
            this.rolePermissions = options.rolePermissions.map((e: any) => new RolePermissionType(e));
        }
        this.groupProperties = []; // should default
        if (options.groupProperties) {
            assert(Array.isArray(options.groupProperties));
            this.groupProperties = options.groupProperties.map((e: any) => new KeyValuePair(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.name, stream);
        encodeArray(this.securityGroupFolder, stream, encodeString);
        encodeDouble(this.keyLifetime, stream);
        encodeString(this.securityPolicyUri, stream);
        encodeUInt32(this.maxFutureKeyCount, stream);
        encodeUInt32(this.maxPastKeyCount, stream);
        encodeString(this.securityGroupId, stream);
        encodeArray(this.rolePermissions, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.groupProperties, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = decodeString(stream, this.name);
        this.securityGroupFolder = decodeArray(stream, decodeString);
        this.keyLifetime = decodeDouble(stream, this.keyLifetime);
        this.securityPolicyUri = decodeString(stream, this.securityPolicyUri);
        this.maxFutureKeyCount = decodeUInt32(stream, this.maxFutureKeyCount);
        this.maxPastKeyCount = decodeUInt32(stream, this.maxPastKeyCount);
        this.securityGroupId = decodeString(stream, this.securityGroupId);
        this.rolePermissions = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new RolePermissionType(null);
            obj.decode(stream1);
            return obj;
        });
        this.groupProperties = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new KeyValuePair(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaSecurityGroupDataType; }
}
SecurityGroupDataType.schema.dataTypeNodeId = SecurityGroupDataType.dataTypeNodeId;
SecurityGroupDataType.schema.encodingDefaultBinary = SecurityGroupDataType.encodingDefaultBinary;
SecurityGroupDataType.schema.encodingDefaultXml = SecurityGroupDataType.encodingDefaultXml;
SecurityGroupDataType.schema.encodingDefaultJson = SecurityGroupDataType.encodingDefaultJson;
registerClassDefinition( SecurityGroupDataType.dataTypeNodeId, "SecurityGroupDataType", SecurityGroupDataType);
// --------------------------------------------------------------------------------------------
const schemaPubSubKeyPushTargetDataType = buildStructuredType({
    name: "PubSubKeyPushTargetDataType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ApplicationUri",

            fieldType: "String",
        },
        {
            name: "PushTargetFolder",

            fieldType: "String",
            isArray: true
        },
        {
            name: "EndpointUrl",

            fieldType: "String",
        },
        {
            name: "SecurityPolicyUri",

            fieldType: "String",
        },
        {
            name: "UserTokenType",

            fieldType: "UserTokenPolicy",
        },
        {
            name: "RequestedKeyCount",

            fieldType: "UInt16",
        },
        {
            name: "RetryInterval",

            fieldType: "Double",
        },
        {
            name: "PushTargetProperties",

            fieldType: "KeyValuePair",
            isArray: true
        },
        {
            name: "SecurityGroups",

            fieldType: "String",
            isArray: true
        },
    ]
});
export interface PubSubKeyPushTargetDataTypeOptions {
    applicationUri?: UAString ;
    pushTargetFolder?: UAString [] | null;
    endpointUrl?: UAString ;
    securityPolicyUri?: UAString ;
    userTokenType?: UserTokenPolicyOptions ;
    requestedKeyCount?: UInt16 ;
    retryInterval?: Double ;
    pushTargetProperties?: KeyValuePairOptions [] | null;
    securityGroups?: UAString [] | null;
}
export class PubSubKeyPushTargetDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaPubSubKeyPushTargetDataType; }
    public static possibleFields: string[] = [
          "applicationUri",
           "pushTargetFolder",
           "endpointUrl",
           "securityPolicyUri",
           "userTokenType",
           "requestedKeyCount",
           "retryInterval",
           "pushTargetProperties",
           "securityGroups"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(25270, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(25530, 0);
    public static encodingDefaultXml = makeExpandedNodeId(25546, 0);
    public static encodingDefaultJson = makeExpandedNodeId(25562, 0);
    public applicationUri: UAString;
    public pushTargetFolder: UAString[] | null;
    public endpointUrl: UAString;
    public securityPolicyUri: UAString;
    public userTokenType: UserTokenPolicy;
    public requestedKeyCount: UInt16;
    public retryInterval: Double;
    public pushTargetProperties: KeyValuePair[] | null;
    public securityGroups: UAString[] | null;

    constructor(options?: PubSubKeyPushTargetDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.applicationUri = null;
            this.pushTargetFolder = []
            this.endpointUrl = null;
            this.securityPolicyUri = null;
         this.userTokenType =  new UserTokenPolicy(null);
            this.requestedKeyCount = 0;
            this.retryInterval = 0;
         this.pushTargetProperties =  null; /* null array */
            this.securityGroups = []
              return;
        }
        const schema = PubSubKeyPushTargetDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as PubSubKeyPushTargetDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.applicationUri = initialize_field(schema.fields[0], options?.applicationUri);
        this.pushTargetFolder = initialize_field_array(schema.fields[1], options?.pushTargetFolder);
        this.endpointUrl = initialize_field(schema.fields[2], options?.endpointUrl);
        this.securityPolicyUri = initialize_field(schema.fields[3], options?.securityPolicyUri);
        this.userTokenType  =  new UserTokenPolicy(options.userTokenType);
        this.requestedKeyCount = initialize_field(schema.fields[5], options?.requestedKeyCount);
        this.retryInterval = initialize_field(schema.fields[6], options?.retryInterval);
        this.pushTargetProperties = []; // should default
        if (options.pushTargetProperties) {
            assert(Array.isArray(options.pushTargetProperties));
            this.pushTargetProperties = options.pushTargetProperties.map((e: any) => new KeyValuePair(e));
        }
        this.securityGroups = initialize_field_array(schema.fields[8], options?.securityGroups);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeString(this.applicationUri, stream);
        encodeArray(this.pushTargetFolder, stream, encodeString);
        encodeString(this.endpointUrl, stream);
        encodeString(this.securityPolicyUri, stream);
        this.userTokenType.encode(stream);
        encodeUInt16(this.requestedKeyCount, stream);
        encodeDouble(this.retryInterval, stream);
        encodeArray(this.pushTargetProperties, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.securityGroups, stream, encodeString);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.applicationUri = decodeString(stream, this.applicationUri);
        this.pushTargetFolder = decodeArray(stream, decodeString);
        this.endpointUrl = decodeString(stream, this.endpointUrl);
        this.securityPolicyUri = decodeString(stream, this.securityPolicyUri);
        this.userTokenType.decode(stream);
        this.requestedKeyCount = decodeUInt16(stream, this.requestedKeyCount);
        this.retryInterval = decodeDouble(stream, this.retryInterval);
        this.pushTargetProperties = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new KeyValuePair(null);
            obj.decode(stream1);
            return obj;
        });
        this.securityGroups = decodeArray(stream, decodeString);
    }
    public get schema(): IStructuredTypeSchema { return schemaPubSubKeyPushTargetDataType; }
}
PubSubKeyPushTargetDataType.schema.dataTypeNodeId = PubSubKeyPushTargetDataType.dataTypeNodeId;
PubSubKeyPushTargetDataType.schema.encodingDefaultBinary = PubSubKeyPushTargetDataType.encodingDefaultBinary;
PubSubKeyPushTargetDataType.schema.encodingDefaultXml = PubSubKeyPushTargetDataType.encodingDefaultXml;
PubSubKeyPushTargetDataType.schema.encodingDefaultJson = PubSubKeyPushTargetDataType.encodingDefaultJson;
registerClassDefinition( PubSubKeyPushTargetDataType.dataTypeNodeId, "PubSubKeyPushTargetDataType", PubSubKeyPushTargetDataType);
// --------------------------------------------------------------------------------------------
const schemaPubSubConfiguration2DataType = buildStructuredType({
    name: "PubSubConfiguration2DataType",

    baseType: "PubSubConfigurationDataType",
    fields: [
        {
            name: "SubscribedDataSets",

            fieldType: "StandaloneSubscribedDataSetDataType",
            isArray: true
        },
        {
            name: "DataSetClasses",

            fieldType: "DataSetMetaDataType",
            isArray: true
        },
        {
            name: "DefaultSecurityKeyServices",

            fieldType: "EndpointDescription",
            isArray: true
        },
        {
            name: "SecurityGroups",

            fieldType: "SecurityGroupDataType",
            isArray: true
        },
        {
            name: "PubSubKeyPushTargets",

            fieldType: "PubSubKeyPushTargetDataType",
            isArray: true
        },
        {
            name: "ConfigurationVersion",

            fieldType: "UInt32",
        },
        {
            name: "ConfigurationProperties",

            fieldType: "KeyValuePair",
            isArray: true
        },
    ]
});
export interface PubSubConfiguration2DataTypeOptions extends PubSubConfigurationDataTypeOptions {
    subscribedDataSets?: StandaloneSubscribedDataSetDataTypeOptions [] | null;
    dataSetClasses?: DataSetMetaDataTypeOptions [] | null;
    defaultSecurityKeyServices?: EndpointDescriptionOptions [] | null;
    securityGroups?: SecurityGroupDataTypeOptions [] | null;
    pubSubKeyPushTargets?: PubSubKeyPushTargetDataTypeOptions [] | null;
    configurationVersion?: UInt32 ;
    configurationProperties?: KeyValuePairOptions [] | null;
}
export class PubSubConfiguration2DataType extends PubSubConfigurationDataType {
    public static get schema(): IStructuredTypeSchema { return schemaPubSubConfiguration2DataType; }
    public static possibleFields: string[] = [
          "publishedDataSets",
           "connections",
           "enabled",
           "subscribedDataSets",
           "dataSetClasses",
           "defaultSecurityKeyServices",
           "securityGroups",
           "pubSubKeyPushTargets",
           "configurationVersion",
           "configurationProperties"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(23602, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(23854, 0);
    public static encodingDefaultXml = makeExpandedNodeId(23922, 0);
    public static encodingDefaultJson = makeExpandedNodeId(23990, 0);
    public subscribedDataSets: StandaloneSubscribedDataSetDataType[] | null;
    public dataSetClasses: DataSetMetaDataType[] | null;
    public defaultSecurityKeyServices: EndpointDescription[] | null;
    public securityGroups: SecurityGroupDataType[] | null;
    public pubSubKeyPushTargets: PubSubKeyPushTargetDataType[] | null;
    public configurationVersion: UInt32;
    public configurationProperties: KeyValuePair[] | null;

    constructor(options?: PubSubConfiguration2DataTypeOptions | null) {

        super(options);

        if (options === null) {
         this.subscribedDataSets =  null; /* null array */
         this.dataSetClasses =  null; /* null array */
         this.defaultSecurityKeyServices =  null; /* null array */
         this.securityGroups =  null; /* null array */
         this.pubSubKeyPushTargets =  null; /* null array */
            this.configurationVersion = 0;
         this.configurationProperties =  null; /* null array */
              return;
        }
        const schema = PubSubConfiguration2DataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as PubSubConfiguration2DataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.subscribedDataSets = []; // should default
        if (options.subscribedDataSets) {
            assert(Array.isArray(options.subscribedDataSets));
            this.subscribedDataSets = options.subscribedDataSets.map((e: any) => new StandaloneSubscribedDataSetDataType(e));
        }
        this.dataSetClasses = []; // should default
        if (options.dataSetClasses) {
            assert(Array.isArray(options.dataSetClasses));
            this.dataSetClasses = options.dataSetClasses.map((e: any) => new DataSetMetaDataType(e));
        }
        this.defaultSecurityKeyServices = []; // should default
        if (options.defaultSecurityKeyServices) {
            assert(Array.isArray(options.defaultSecurityKeyServices));
            this.defaultSecurityKeyServices = options.defaultSecurityKeyServices.map((e: any) => new EndpointDescription(e));
        }
        this.securityGroups = []; // should default
        if (options.securityGroups) {
            assert(Array.isArray(options.securityGroups));
            this.securityGroups = options.securityGroups.map((e: any) => new SecurityGroupDataType(e));
        }
        this.pubSubKeyPushTargets = []; // should default
        if (options.pubSubKeyPushTargets) {
            assert(Array.isArray(options.pubSubKeyPushTargets));
            this.pubSubKeyPushTargets = options.pubSubKeyPushTargets.map((e: any) => new PubSubKeyPushTargetDataType(e));
        }
        this.configurationVersion = initialize_field(schema.fields[5], options?.configurationVersion);
        this.configurationProperties = []; // should default
        if (options.configurationProperties) {
            assert(Array.isArray(options.configurationProperties));
            this.configurationProperties = options.configurationProperties.map((e: any) => new KeyValuePair(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeArray(this.subscribedDataSets, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.dataSetClasses, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.defaultSecurityKeyServices, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.securityGroups, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.pubSubKeyPushTargets, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeUInt32(this.configurationVersion, stream);
        encodeArray(this.configurationProperties, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.subscribedDataSets = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new StandaloneSubscribedDataSetDataType(null);
            obj.decode(stream1);
            return obj;
        });
        this.dataSetClasses = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new DataSetMetaDataType(null);
            obj.decode(stream1);
            return obj;
        });
        this.defaultSecurityKeyServices = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new EndpointDescription(null);
            obj.decode(stream1);
            return obj;
        });
        this.securityGroups = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new SecurityGroupDataType(null);
            obj.decode(stream1);
            return obj;
        });
        this.pubSubKeyPushTargets = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new PubSubKeyPushTargetDataType(null);
            obj.decode(stream1);
            return obj;
        });
        this.configurationVersion = decodeUInt32(stream, this.configurationVersion);
        this.configurationProperties = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new KeyValuePair(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaPubSubConfiguration2DataType; }
}
PubSubConfiguration2DataType.schema.dataTypeNodeId = PubSubConfiguration2DataType.dataTypeNodeId;
PubSubConfiguration2DataType.schema.encodingDefaultBinary = PubSubConfiguration2DataType.encodingDefaultBinary;
PubSubConfiguration2DataType.schema.encodingDefaultXml = PubSubConfiguration2DataType.encodingDefaultXml;
PubSubConfiguration2DataType.schema.encodingDefaultJson = PubSubConfiguration2DataType.encodingDefaultJson;
registerClassDefinition( PubSubConfiguration2DataType.dataTypeNodeId, "PubSubConfiguration2DataType", PubSubConfiguration2DataType);

// --------------------------------------------------------------------------------------------
export enum PubSubConfigurationRefMask {
    None = 0,
    ElementAdd = 1,
    ElementMatch = 2,
    ElementModify = 4,
    ElementRemove = 8,
    ReferenceWriter = 16,
    ReferenceReader = 32,
    ReferenceWriterGroup = 64,
    ReferenceReaderGroup = 128,
    ReferenceConnection = 256,
    ReferencePubDataset = 512,
    ReferenceSubDataset = 1024,
    ReferenceSecurityGroup = 2048,
    ReferencePushTarget = 4096
}
const schemaPubSubConfigurationRefMask = {
    enumValues: PubSubConfigurationRefMask,
    flaggable: true,
    name: "PubSubConfigurationRefMask"
};
function decodePubSubConfigurationRefMask(stream: BinaryStream, _value?: PubSubConfigurationRefMask): PubSubConfigurationRefMask {
    return  stream.readUInt32() as PubSubConfigurationRefMask;
}
function encodePubSubConfigurationRefMask(value: PubSubConfigurationRefMask, stream: OutputBinaryStream): void {
    stream.writeUInt32(value);
}
export const _enumerationPubSubConfigurationRefMask = registerEnumeration(schemaPubSubConfigurationRefMask);
assert(_enumerationPubSubConfigurationRefMask.isFlaggable ===  true);
// --------------------------------------------------------------------------------------------
const schemaPubSubConfigurationRefDataType = buildStructuredType({
    name: "PubSubConfigurationRefDataType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ConfigurationMask",

            fieldType: "PubSubConfigurationRefMask",
        },
        {
            name: "ElementIndex",

            fieldType: "UInt16",
        },
        {
            name: "ConnectionIndex",

            fieldType: "UInt16",
        },
        {
            name: "GroupIndex",

            fieldType: "UInt16",
        },
    ]
});
export interface PubSubConfigurationRefDataTypeOptions {
    configurationMask?: PubSubConfigurationRefMask;
    elementIndex?: UInt16 ;
    connectionIndex?: UInt16 ;
    groupIndex?: UInt16 ;
}
export class PubSubConfigurationRefDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaPubSubConfigurationRefDataType; }
    public static possibleFields: string[] = [
          "configurationMask",
           "elementIndex",
           "connectionIndex",
           "groupIndex"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(25519, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(25531, 0);
    public static encodingDefaultXml = makeExpandedNodeId(25547, 0);
    public static encodingDefaultJson = makeExpandedNodeId(25563, 0);
    public configurationMask: PubSubConfigurationRefMask;
    public elementIndex: UInt16;
    public connectionIndex: UInt16;
    public groupIndex: UInt16;

    constructor(options?: PubSubConfigurationRefDataTypeOptions | null) {

        super(options);

        if (options === null) {
             this.configurationMask =  0 as  PubSubConfigurationRefMask;
            this.elementIndex = 0;
            this.connectionIndex = 0;
            this.groupIndex = 0;
              return;
        }
        const schema = PubSubConfigurationRefDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as PubSubConfigurationRefDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.configurationMask = this.setConfigurationMask(initialize_field(schema.fields[0], options?.configurationMask));
        this.elementIndex = initialize_field(schema.fields[1], options?.elementIndex);
        this.connectionIndex = initialize_field(schema.fields[2], options?.connectionIndex);
        this.groupIndex = initialize_field(schema.fields[3], options?.groupIndex);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodePubSubConfigurationRefMask(this.configurationMask, stream);
        encodeUInt16(this.elementIndex, stream);
        encodeUInt16(this.connectionIndex, stream);
        encodeUInt16(this.groupIndex, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.configurationMask = decodePubSubConfigurationRefMask(stream, this.configurationMask);
        this.elementIndex = decodeUInt16(stream, this.elementIndex);
        this.connectionIndex = decodeUInt16(stream, this.connectionIndex);
        this.groupIndex = decodeUInt16(stream, this.groupIndex);
    }

    // Define Enumeration setters
    public setConfigurationMask(value: any): PubSubConfigurationRefMask {
        const coercedValue = _enumerationPubSubConfigurationRefMask.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
           throw new Error("value cannot be coerced to PubSubConfigurationRefMask :" + value);
        }
        this.configurationMask = coercedValue.value as PubSubConfigurationRefMask;
        return this.configurationMask;
    }
    public get schema(): IStructuredTypeSchema { return schemaPubSubConfigurationRefDataType; }
}
PubSubConfigurationRefDataType.schema.dataTypeNodeId = PubSubConfigurationRefDataType.dataTypeNodeId;
PubSubConfigurationRefDataType.schema.encodingDefaultBinary = PubSubConfigurationRefDataType.encodingDefaultBinary;
PubSubConfigurationRefDataType.schema.encodingDefaultXml = PubSubConfigurationRefDataType.encodingDefaultXml;
PubSubConfigurationRefDataType.schema.encodingDefaultJson = PubSubConfigurationRefDataType.encodingDefaultJson;
registerClassDefinition( PubSubConfigurationRefDataType.dataTypeNodeId, "PubSubConfigurationRefDataType", PubSubConfigurationRefDataType);
// --------------------------------------------------------------------------------------------
const schemaPubSubConfigurationValueDataType = buildStructuredType({
    name: "PubSubConfigurationValueDataType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ConfigurationElement",

            fieldType: "PubSubConfigurationRefDataType",
        },
        {
            name: "Name",

            fieldType: "String",
        },
        {
            name: "Identifier",

            fieldType: "Variant",
        },
    ]
});
export interface PubSubConfigurationValueDataTypeOptions {
    configurationElement?: PubSubConfigurationRefDataTypeOptions ;
    name?: UAString ;
    identifier?: (VariantLike | null);
}
export class PubSubConfigurationValueDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaPubSubConfigurationValueDataType; }
    public static possibleFields: string[] = [
          "configurationElement",
           "name",
           "identifier"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(25520, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(25532, 0);
    public static encodingDefaultXml = makeExpandedNodeId(25548, 0);
    public static encodingDefaultJson = makeExpandedNodeId(25564, 0);
    public configurationElement: PubSubConfigurationRefDataType;
    public name: UAString;
    public identifier: Variant;

    constructor(options?: PubSubConfigurationValueDataTypeOptions | null) {

        super(options);

        if (options === null) {
         this.configurationElement =  new PubSubConfigurationRefDataType(null);
            this.name = null;
            this.identifier = new Variant(null);
              return;
        }
        const schema = PubSubConfigurationValueDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as PubSubConfigurationValueDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.configurationElement  =  new PubSubConfigurationRefDataType(options.configurationElement);
        this.name = initialize_field(schema.fields[1], options?.name);
        this.identifier = initialize_field(schema.fields[2], options?.identifier);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.configurationElement.encode(stream);
        encodeString(this.name, stream);
        encodeVariant(this.identifier, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.configurationElement.decode(stream);
        this.name = decodeString(stream, this.name);
        this.identifier = decodeVariant(stream, this.identifier);
    }
    public get schema(): IStructuredTypeSchema { return schemaPubSubConfigurationValueDataType; }
}
PubSubConfigurationValueDataType.schema.dataTypeNodeId = PubSubConfigurationValueDataType.dataTypeNodeId;
PubSubConfigurationValueDataType.schema.encodingDefaultBinary = PubSubConfigurationValueDataType.encodingDefaultBinary;
PubSubConfigurationValueDataType.schema.encodingDefaultXml = PubSubConfigurationValueDataType.encodingDefaultXml;
PubSubConfigurationValueDataType.schema.encodingDefaultJson = PubSubConfigurationValueDataType.encodingDefaultJson;
registerClassDefinition( PubSubConfigurationValueDataType.dataTypeNodeId, "PubSubConfigurationValueDataType", PubSubConfigurationValueDataType);
// --------------------------------------------------------------------------------------------
const schemaSubscriptionAcknowledgement = buildStructuredType({
    name: "SubscriptionAcknowledgement",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "SubscriptionId",

            fieldType: "UInt32",
        },
        {
            name: "SequenceNumber",

            fieldType: "UInt32",
        },
    ]
});
export interface SubscriptionAcknowledgementOptions {
    subscriptionId?: UInt32 ;
    sequenceNumber?: UInt32 ;
}
export class SubscriptionAcknowledgement extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaSubscriptionAcknowledgement; }
    public static possibleFields: string[] = [
          "subscriptionId",
           "sequenceNumber"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(821, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(823, 0);
    public static encodingDefaultXml = makeExpandedNodeId(822, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15351, 0);
    public subscriptionId: UInt32;
    public sequenceNumber: UInt32;

    constructor(options?: SubscriptionAcknowledgementOptions | null) {

        super(options);

        if (options === null) {
            this.subscriptionId = 0;
            this.sequenceNumber = 0;
              return;
        }
        const schema = SubscriptionAcknowledgement.schema;
        options = (schema.constructHook ? schema.constructHook(options) as SubscriptionAcknowledgementOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.subscriptionId = initialize_field(schema.fields[0], options?.subscriptionId);
        this.sequenceNumber = initialize_field(schema.fields[1], options?.sequenceNumber);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeUInt32(this.subscriptionId, stream);
        encodeUInt32(this.sequenceNumber, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.subscriptionId = decodeUInt32(stream, this.subscriptionId);
        this.sequenceNumber = decodeUInt32(stream, this.sequenceNumber);
    }
    public get schema(): IStructuredTypeSchema { return schemaSubscriptionAcknowledgement; }
}
SubscriptionAcknowledgement.schema.dataTypeNodeId = SubscriptionAcknowledgement.dataTypeNodeId;
SubscriptionAcknowledgement.schema.encodingDefaultBinary = SubscriptionAcknowledgement.encodingDefaultBinary;
SubscriptionAcknowledgement.schema.encodingDefaultXml = SubscriptionAcknowledgement.encodingDefaultXml;
SubscriptionAcknowledgement.schema.encodingDefaultJson = SubscriptionAcknowledgement.encodingDefaultJson;
registerClassDefinition( SubscriptionAcknowledgement.dataTypeNodeId, "SubscriptionAcknowledgement", SubscriptionAcknowledgement);
// --------------------------------------------------------------------------------------------
const schemaPublishRequest = buildStructuredType({
    name: "PublishRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
        {
            name: "SubscriptionAcknowledgements",

            fieldType: "SubscriptionAcknowledgement",
            isArray: true
        },
    ]
});
export interface PublishRequestOptions {
    requestHeader?: RequestHeaderOptions ;
    subscriptionAcknowledgements?: SubscriptionAcknowledgementOptions [] | null;
}
export class PublishRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaPublishRequest; }
    public static possibleFields: string[] = [
          "requestHeader",
           "subscriptionAcknowledgements"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(824, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(826, 0);
    public static encodingDefaultXml = makeExpandedNodeId(825, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15352, 0);
    public requestHeader: RequestHeader;
    public subscriptionAcknowledgements: SubscriptionAcknowledgement[] | null;

    constructor(options?: PublishRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
         this.subscriptionAcknowledgements =  null; /* null array */
              return;
        }
        const schema = PublishRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as PublishRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
        this.subscriptionAcknowledgements = []; // should default
        if (options.subscriptionAcknowledgements) {
            assert(Array.isArray(options.subscriptionAcknowledgements));
            this.subscriptionAcknowledgements = options.subscriptionAcknowledgements.map((e: any) => new SubscriptionAcknowledgement(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        encodeArray(this.subscriptionAcknowledgements, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.subscriptionAcknowledgements = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new SubscriptionAcknowledgement(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaPublishRequest; }
}
PublishRequest.schema.dataTypeNodeId = PublishRequest.dataTypeNodeId;
PublishRequest.schema.encodingDefaultBinary = PublishRequest.encodingDefaultBinary;
PublishRequest.schema.encodingDefaultXml = PublishRequest.encodingDefaultXml;
PublishRequest.schema.encodingDefaultJson = PublishRequest.encodingDefaultJson;
registerClassDefinition( PublishRequest.dataTypeNodeId, "PublishRequest", PublishRequest);
// --------------------------------------------------------------------------------------------
const schemaPublishResponse = buildStructuredType({
    name: "PublishResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
        {
            name: "SubscriptionId",

            fieldType: "UInt32",
        },
        {
            name: "AvailableSequenceNumbers",

            fieldType: "UInt32",
            isArray: true
        },
        {
            name: "MoreNotifications",

            fieldType: "Boolean",
        },
        {
            name: "NotificationMessage",

            fieldType: "NotificationMessage",
        },
        {
            name: "Results",

            fieldType: "StatusCode",
            isArray: true
        },
        {
            name: "DiagnosticInfos",

            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
export interface PublishResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
    subscriptionId?: UInt32 ;
    availableSequenceNumbers?: UInt32 [] | null;
    moreNotifications?: UABoolean ;
    notificationMessage?: NotificationMessageOptions ;
    results?: StatusCode [] | null;
    diagnosticInfos?: (DiagnosticInfo | null)[] | null;
}
export class PublishResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaPublishResponse; }
    public static possibleFields: string[] = [
          "responseHeader",
           "subscriptionId",
           "availableSequenceNumbers",
           "moreNotifications",
           "notificationMessage",
           "results",
           "diagnosticInfos"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(827, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(829, 0);
    public static encodingDefaultXml = makeExpandedNodeId(828, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15353, 0);
    public responseHeader: ResponseHeader;
    public subscriptionId: UInt32;
    public availableSequenceNumbers: UInt32[] | null;
    public moreNotifications: UABoolean;
    public notificationMessage: NotificationMessage;
    public results: StatusCode[] | null;
    public diagnosticInfos: (DiagnosticInfo | null)[] | null;

    constructor(options?: PublishResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
            this.subscriptionId = 0;
            this.availableSequenceNumbers = []
            this.moreNotifications = false;
         this.notificationMessage =  new NotificationMessage(null);
            this.results = []
            this.diagnosticInfos = []
              return;
        }
        const schema = PublishResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as PublishResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
        this.subscriptionId = initialize_field(schema.fields[1], options?.subscriptionId);
        this.availableSequenceNumbers = initialize_field_array(schema.fields[2], options?.availableSequenceNumbers);
        this.moreNotifications = initialize_field(schema.fields[3], options?.moreNotifications);
        this.notificationMessage  =  new NotificationMessage(options.notificationMessage);
        this.results = initialize_field_array(schema.fields[5], options?.results);
        this.diagnosticInfos = initialize_field_array(schema.fields[6], options?.diagnosticInfos);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        encodeUInt32(this.subscriptionId, stream);
        encodeArray(this.availableSequenceNumbers, stream, encodeUInt32);
        encodeBoolean(this.moreNotifications, stream);
        this.notificationMessage.encode(stream);
        encodeArray(this.results, stream, encodeStatusCode);
        encodeArray(this.diagnosticInfos, stream, encodeDiagnosticInfo);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.subscriptionId = decodeUInt32(stream, this.subscriptionId);
        this.availableSequenceNumbers = decodeArray(stream, decodeUInt32);
        this.moreNotifications = decodeBoolean(stream, this.moreNotifications);
        this.notificationMessage.decode(stream);
        this.results = decodeArray(stream, decodeStatusCode);
        this.diagnosticInfos = decodeArray(stream, decodeDiagnosticInfo);
    }
    public get schema(): IStructuredTypeSchema { return schemaPublishResponse; }
}
PublishResponse.schema.dataTypeNodeId = PublishResponse.dataTypeNodeId;
PublishResponse.schema.encodingDefaultBinary = PublishResponse.encodingDefaultBinary;
PublishResponse.schema.encodingDefaultXml = PublishResponse.encodingDefaultXml;
PublishResponse.schema.encodingDefaultJson = PublishResponse.encodingDefaultJson;
registerClassDefinition( PublishResponse.dataTypeNodeId, "PublishResponse", PublishResponse);
// --------------------------------------------------------------------------------------------
const schemaPublishedDataSetSourceDataType = buildStructuredType({
    name: "PublishedDataSetSourceDataType",

    baseType: "ExtensionObject",
    fields: [
    ]
});
export interface PublishedDataSetSourceDataTypeOptions {
}
export class PublishedDataSetSourceDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaPublishedDataSetSourceDataType; }
    public static possibleFields: string[] = [
          
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15580, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15678, 0);
    public static encodingDefaultXml = makeExpandedNodeId(15952, 0);
    public static encodingDefaultJson = makeExpandedNodeId(16153, 0);

    constructor(options?: PublishedDataSetSourceDataTypeOptions | null) {

        super(options);

        if (options === null) {
              return;
        }
        const schema = PublishedDataSetSourceDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as PublishedDataSetSourceDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaPublishedDataSetSourceDataType; }
}
PublishedDataSetSourceDataType.schema.dataTypeNodeId = PublishedDataSetSourceDataType.dataTypeNodeId;
PublishedDataSetSourceDataType.schema.encodingDefaultBinary = PublishedDataSetSourceDataType.encodingDefaultBinary;
PublishedDataSetSourceDataType.schema.encodingDefaultXml = PublishedDataSetSourceDataType.encodingDefaultXml;
PublishedDataSetSourceDataType.schema.encodingDefaultJson = PublishedDataSetSourceDataType.encodingDefaultJson;
registerClassDefinition( PublishedDataSetSourceDataType.dataTypeNodeId, "PublishedDataSetSourceDataType", PublishedDataSetSourceDataType);
// --------------------------------------------------------------------------------------------
const schemaPublishedActionDataType = buildStructuredType({
    name: "PublishedActionDataType",

    baseType: "PublishedDataSetSourceDataType",
    fields: [
        {
            name: "RequestDataSetMetaData",

            fieldType: "DataSetMetaDataType",
        },
        {
            name: "ActionTargets",

            fieldType: "ActionTargetDataType",
            isArray: true
        },
    ]
});
export interface PublishedActionDataTypeOptions extends PublishedDataSetSourceDataTypeOptions {
    requestDataSetMetaData?: DataSetMetaDataTypeOptions ;
    actionTargets?: ActionTargetDataTypeOptions [] | null;
}
export class PublishedActionDataType extends PublishedDataSetSourceDataType {
    public static get schema(): IStructuredTypeSchema { return schemaPublishedActionDataType; }
    public static possibleFields: string[] = [
          "requestDataSetMetaData",
           "actionTargets"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(0, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(0, 0);
    public static encodingDefaultXml = makeExpandedNodeId(0, 0);
    public static encodingDefaultJson = makeExpandedNodeId(0, 0);
    public requestDataSetMetaData: DataSetMetaDataType;
    public actionTargets: ActionTargetDataType[] | null;

    constructor(options?: PublishedActionDataTypeOptions | null) {

        super(options);

        if (options === null) {
         this.requestDataSetMetaData =  new DataSetMetaDataType(null);
         this.actionTargets =  null; /* null array */
              return;
        }
        const schema = PublishedActionDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as PublishedActionDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestDataSetMetaData  =  new DataSetMetaDataType(options.requestDataSetMetaData);
        this.actionTargets = []; // should default
        if (options.actionTargets) {
            assert(Array.isArray(options.actionTargets));
            this.actionTargets = options.actionTargets.map((e: any) => new ActionTargetDataType(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestDataSetMetaData.encode(stream);
        encodeArray(this.actionTargets, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestDataSetMetaData.decode(stream);
        this.actionTargets = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new ActionTargetDataType(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaPublishedActionDataType; }
}
PublishedActionDataType.schema.dataTypeNodeId = PublishedActionDataType.dataTypeNodeId;
PublishedActionDataType.schema.encodingDefaultBinary = PublishedActionDataType.encodingDefaultBinary;
PublishedActionDataType.schema.encodingDefaultXml = PublishedActionDataType.encodingDefaultXml;
PublishedActionDataType.schema.encodingDefaultJson = PublishedActionDataType.encodingDefaultJson;
registerClassDefinition( PublishedActionDataType.dataTypeNodeId, "PublishedActionDataType", PublishedActionDataType);
// --------------------------------------------------------------------------------------------
const schemaPublishedActionMethodDataType = buildStructuredType({
    name: "PublishedActionMethodDataType",

    baseType: "PublishedActionDataType",
    fields: [
        {
            name: "ActionMethods",

            fieldType: "ActionMethodDataType",
            isArray: true
        },
    ]
});
export interface PublishedActionMethodDataTypeOptions extends PublishedActionDataTypeOptions {
    actionMethods?: ActionMethodDataTypeOptions [] | null;
}
export class PublishedActionMethodDataType extends PublishedActionDataType {
    public static get schema(): IStructuredTypeSchema { return schemaPublishedActionMethodDataType; }
    public static possibleFields: string[] = [
          "requestDataSetMetaData",
           "actionTargets",
           "actionMethods"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(0, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(0, 0);
    public static encodingDefaultXml = makeExpandedNodeId(0, 0);
    public static encodingDefaultJson = makeExpandedNodeId(0, 0);
    public actionMethods: ActionMethodDataType[] | null;

    constructor(options?: PublishedActionMethodDataTypeOptions | null) {

        super(options);

        if (options === null) {
         this.actionMethods =  null; /* null array */
              return;
        }
        const schema = PublishedActionMethodDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as PublishedActionMethodDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.actionMethods = []; // should default
        if (options.actionMethods) {
            assert(Array.isArray(options.actionMethods));
            this.actionMethods = options.actionMethods.map((e: any) => new ActionMethodDataType(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeArray(this.actionMethods, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.actionMethods = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new ActionMethodDataType(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaPublishedActionMethodDataType; }
}
PublishedActionMethodDataType.schema.dataTypeNodeId = PublishedActionMethodDataType.dataTypeNodeId;
PublishedActionMethodDataType.schema.encodingDefaultBinary = PublishedActionMethodDataType.encodingDefaultBinary;
PublishedActionMethodDataType.schema.encodingDefaultXml = PublishedActionMethodDataType.encodingDefaultXml;
PublishedActionMethodDataType.schema.encodingDefaultJson = PublishedActionMethodDataType.encodingDefaultJson;
registerClassDefinition( PublishedActionMethodDataType.dataTypeNodeId, "PublishedActionMethodDataType", PublishedActionMethodDataType);
// --------------------------------------------------------------------------------------------
const schemaPublishedVariableDataType = buildStructuredType({
    name: "PublishedVariableDataType",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "PublishedVariable",

            fieldType: "NodeId",
        },
        {
            name: "AttributeId",

            fieldType: "UInt32",
        },
        {
            name: "SamplingIntervalHint",

            fieldType: "Double",
        },
        {
            name: "DeadbandType",

            fieldType: "UInt32",
        },
        {
            name: "DeadbandValue",

            fieldType: "Double",
        },
        {
            name: "IndexRange",

            fieldType: "NumericRange",
        },
        {
            name: "SubstituteValue",

            fieldType: "Variant",
        },
        {
            name: "MetaDataProperties",

            fieldType: "QualifiedName",
            isArray: true
        },
    ]
});
export interface PublishedVariableDataTypeOptions {
    publishedVariable?: (NodeIdLike | null);
    attributeId?: UInt32 ;
    samplingIntervalHint?: Double ;
    deadbandType?: UInt32 ;
    deadbandValue?: Double ;
    indexRange?: NumericRange ;
    substituteValue?: (VariantLike | null);
    metaDataProperties?: (QualifiedNameLike | null)[] | null;
}
export class PublishedVariableDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaPublishedVariableDataType; }
    public static possibleFields: string[] = [
          "publishedVariable",
           "attributeId",
           "samplingIntervalHint",
           "deadbandType",
           "deadbandValue",
           "indexRange",
           "substituteValue",
           "metaDataProperties"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(14273, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(14323, 0);
    public static encodingDefaultXml = makeExpandedNodeId(14319, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15060, 0);
    public publishedVariable: NodeId;
    public attributeId: UInt32;
    public samplingIntervalHint: Double;
    public deadbandType: UInt32;
    public deadbandValue: Double;
    public indexRange: NumericRange;
    public substituteValue: Variant;
    public metaDataProperties: QualifiedName[] | null;

    constructor(options?: PublishedVariableDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.publishedVariable = new NodeId(null);
            this.attributeId = 0;
            this.samplingIntervalHint = 0;
            this.deadbandType = 0;
            this.deadbandValue = 0;
            this.indexRange = new NumericRange(null);
            this.substituteValue = new Variant(null);
            this.metaDataProperties = []
              return;
        }
        const schema = PublishedVariableDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as PublishedVariableDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.publishedVariable = initialize_field(schema.fields[0], options?.publishedVariable);
        this.attributeId = initialize_field(schema.fields[1], options?.attributeId);
        this.samplingIntervalHint = initialize_field(schema.fields[2], options?.samplingIntervalHint);
        this.deadbandType = initialize_field(schema.fields[3], options?.deadbandType);
        this.deadbandValue = initialize_field(schema.fields[4], options?.deadbandValue);
        this.indexRange = initialize_field(schema.fields[5], options?.indexRange);
        this.substituteValue = initialize_field(schema.fields[6], options?.substituteValue);
        this.metaDataProperties = initialize_field_array(schema.fields[7], options?.metaDataProperties);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.publishedVariable, stream);
        encodeUInt32(this.attributeId, stream);
        encodeDouble(this.samplingIntervalHint, stream);
        encodeUInt32(this.deadbandType, stream);
        encodeDouble(this.deadbandValue, stream);
        encodeNumericRange(this.indexRange, stream);
        encodeVariant(this.substituteValue, stream);
        encodeArray(this.metaDataProperties, stream, encodeQualifiedName);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.publishedVariable = decodeNodeId(stream, this.publishedVariable);
        this.attributeId = decodeUInt32(stream, this.attributeId);
        this.samplingIntervalHint = decodeDouble(stream, this.samplingIntervalHint);
        this.deadbandType = decodeUInt32(stream, this.deadbandType);
        this.deadbandValue = decodeDouble(stream, this.deadbandValue);
        this.indexRange = decodeNumericRange(stream, this.indexRange);
        this.substituteValue = decodeVariant(stream, this.substituteValue);
        this.metaDataProperties = decodeArray(stream, decodeQualifiedName);
    }
    public get schema(): IStructuredTypeSchema { return schemaPublishedVariableDataType; }
}
PublishedVariableDataType.schema.dataTypeNodeId = PublishedVariableDataType.dataTypeNodeId;
PublishedVariableDataType.schema.encodingDefaultBinary = PublishedVariableDataType.encodingDefaultBinary;
PublishedVariableDataType.schema.encodingDefaultXml = PublishedVariableDataType.encodingDefaultXml;
PublishedVariableDataType.schema.encodingDefaultJson = PublishedVariableDataType.encodingDefaultJson;
registerClassDefinition( PublishedVariableDataType.dataTypeNodeId, "PublishedVariableDataType", PublishedVariableDataType);
// --------------------------------------------------------------------------------------------
const schemaPublishedDataItemsDataType = buildStructuredType({
    name: "PublishedDataItemsDataType",

    baseType: "PublishedDataSetSourceDataType",
    fields: [
        {
            name: "PublishedData",

            fieldType: "PublishedVariableDataType",
            isArray: true
        },
    ]
});
export interface PublishedDataItemsDataTypeOptions extends PublishedDataSetSourceDataTypeOptions {
    publishedData?: PublishedVariableDataTypeOptions [] | null;
}
export class PublishedDataItemsDataType extends PublishedDataSetSourceDataType {
    public static get schema(): IStructuredTypeSchema { return schemaPublishedDataItemsDataType; }
    public static possibleFields: string[] = [
          "publishedData"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15581, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15679, 0);
    public static encodingDefaultXml = makeExpandedNodeId(15953, 0);
    public static encodingDefaultJson = makeExpandedNodeId(16154, 0);
    public publishedData: PublishedVariableDataType[] | null;

    constructor(options?: PublishedDataItemsDataTypeOptions | null) {

        super(options);

        if (options === null) {
         this.publishedData =  null; /* null array */
              return;
        }
        const schema = PublishedDataItemsDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as PublishedDataItemsDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.publishedData = []; // should default
        if (options.publishedData) {
            assert(Array.isArray(options.publishedData));
            this.publishedData = options.publishedData.map((e: any) => new PublishedVariableDataType(e));
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeArray(this.publishedData, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.publishedData = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new PublishedVariableDataType(null);
            obj.decode(stream1);
            return obj;
        });
    }
    public get schema(): IStructuredTypeSchema { return schemaPublishedDataItemsDataType; }
}
PublishedDataItemsDataType.schema.dataTypeNodeId = PublishedDataItemsDataType.dataTypeNodeId;
PublishedDataItemsDataType.schema.encodingDefaultBinary = PublishedDataItemsDataType.encodingDefaultBinary;
PublishedDataItemsDataType.schema.encodingDefaultXml = PublishedDataItemsDataType.encodingDefaultXml;
PublishedDataItemsDataType.schema.encodingDefaultJson = PublishedDataItemsDataType.encodingDefaultJson;
registerClassDefinition( PublishedDataItemsDataType.dataTypeNodeId, "PublishedDataItemsDataType", PublishedDataItemsDataType);
// --------------------------------------------------------------------------------------------
const schemaPublishedDataSetCustomSourceDataType = buildStructuredType({
    name: "PublishedDataSetCustomSourceDataType",

    baseType: "PublishedDataSetSourceDataType",
    fields: [
        {
            name: "CyclicDataSet",

            fieldType: "Boolean",
        },
    ]
});
export interface PublishedDataSetCustomSourceDataTypeOptions extends PublishedDataSetSourceDataTypeOptions {
    cyclicDataSet?: UABoolean ;
}
export class PublishedDataSetCustomSourceDataType extends PublishedDataSetSourceDataType {
    public static get schema(): IStructuredTypeSchema { return schemaPublishedDataSetCustomSourceDataType; }
    public static possibleFields: string[] = [
          "cyclicDataSet"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(25269, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(25529, 0);
    public static encodingDefaultXml = makeExpandedNodeId(25545, 0);
    public static encodingDefaultJson = makeExpandedNodeId(25561, 0);
    public cyclicDataSet: UABoolean;

    constructor(options?: PublishedDataSetCustomSourceDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.cyclicDataSet = false;
              return;
        }
        const schema = PublishedDataSetCustomSourceDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as PublishedDataSetCustomSourceDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.cyclicDataSet = initialize_field(schema.fields[0], options?.cyclicDataSet);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeBoolean(this.cyclicDataSet, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.cyclicDataSet = decodeBoolean(stream, this.cyclicDataSet);
    }
    public get schema(): IStructuredTypeSchema { return schemaPublishedDataSetCustomSourceDataType; }
}
PublishedDataSetCustomSourceDataType.schema.dataTypeNodeId = PublishedDataSetCustomSourceDataType.dataTypeNodeId;
PublishedDataSetCustomSourceDataType.schema.encodingDefaultBinary = PublishedDataSetCustomSourceDataType.encodingDefaultBinary;
PublishedDataSetCustomSourceDataType.schema.encodingDefaultXml = PublishedDataSetCustomSourceDataType.encodingDefaultXml;
PublishedDataSetCustomSourceDataType.schema.encodingDefaultJson = PublishedDataSetCustomSourceDataType.encodingDefaultJson;
registerClassDefinition( PublishedDataSetCustomSourceDataType.dataTypeNodeId, "PublishedDataSetCustomSourceDataType", PublishedDataSetCustomSourceDataType);
// --------------------------------------------------------------------------------------------
const schemaPublishedEventsDataType = buildStructuredType({
    name: "PublishedEventsDataType",

    baseType: "PublishedDataSetSourceDataType",
    fields: [
        {
            name: "EventNotifier",

            fieldType: "NodeId",
        },
        {
            name: "SelectedFields",

            fieldType: "SimpleAttributeOperand",
            isArray: true
        },
        {
            name: "Filter",

            fieldType: "ContentFilter",
        },
    ]
});
export interface PublishedEventsDataTypeOptions extends PublishedDataSetSourceDataTypeOptions {
    eventNotifier?: (NodeIdLike | null);
    selectedFields?: SimpleAttributeOperandOptions [] | null;
    filter?: ContentFilterOptions ;
}
export class PublishedEventsDataType extends PublishedDataSetSourceDataType {
    public static get schema(): IStructuredTypeSchema { return schemaPublishedEventsDataType; }
    public static possibleFields: string[] = [
          "eventNotifier",
           "selectedFields",
           "filter"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(15582, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(15681, 0);
    public static encodingDefaultXml = makeExpandedNodeId(15954, 0);
    public static encodingDefaultJson = makeExpandedNodeId(16155, 0);
    public eventNotifier: NodeId;
    public selectedFields: SimpleAttributeOperand[] | null;
    public filter: ContentFilter;

    constructor(options?: PublishedEventsDataTypeOptions | null) {

        super(options);

        if (options === null) {
            this.eventNotifier = new NodeId(null);
         this.selectedFields =  null; /* null array */
         this.filter =  new ContentFilter(null);
              return;
        }
        const schema = PublishedEventsDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as PublishedEventsDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.eventNotifier = initialize_field(schema.fields[0], options?.eventNotifier);
        this.selectedFields = []; // should default
        if (options.selectedFields) {
            assert(Array.isArray(options.selectedFields));
            this.selectedFields = options.selectedFields.map((e: any) => new SimpleAttributeOperand(e));
        }
        this.filter  =  new ContentFilter(options.filter);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeNodeId(this.eventNotifier, stream);
        encodeArray(this.selectedFields, stream, (obj, stream1) => { obj.encode(stream1); });
        this.filter.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.eventNotifier = decodeNodeId(stream, this.eventNotifier);
        this.selectedFields = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new SimpleAttributeOperand(null);
            obj.decode(stream1);
            return obj;
        });
        this.filter.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaPublishedEventsDataType; }
}
PublishedEventsDataType.schema.dataTypeNodeId = PublishedEventsDataType.dataTypeNodeId;
PublishedEventsDataType.schema.encodingDefaultBinary = PublishedEventsDataType.encodingDefaultBinary;
PublishedEventsDataType.schema.encodingDefaultXml = PublishedEventsDataType.encodingDefaultXml;
PublishedEventsDataType.schema.encodingDefaultJson = PublishedEventsDataType.encodingDefaultJson;
registerClassDefinition( PublishedEventsDataType.dataTypeNodeId, "PublishedEventsDataType", PublishedEventsDataType);
// --------------------------------------------------------------------------------------------
const schemaQosDataType = buildStructuredType({
    name: "QosDataType",

    baseType: "ExtensionObject",
    fields: [
    ]
});
export interface QosDataTypeOptions {
}
export class QosDataType extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaQosDataType; }
    public static possibleFields: string[] = [
          
    ];
    public static dataTypeNodeId = makeExpandedNodeId(23603, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(23855, 0);
    public static encodingDefaultXml = makeExpandedNodeId(23923, 0);
    public static encodingDefaultJson = makeExpandedNodeId(23991, 0);

    constructor(options?: QosDataTypeOptions | null) {

        super(options);

        if (options === null) {
              return;
        }
        const schema = QosDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) as QosDataTypeOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    public get schema(): IStructuredTypeSchema { return schemaQosDataType; }
}
QosDataType.schema.dataTypeNodeId = QosDataType.dataTypeNodeId;
QosDataType.schema.encodingDefaultBinary = QosDataType.encodingDefaultBinary;
QosDataType.schema.encodingDefaultXml = QosDataType.encodingDefaultXml;
QosDataType.schema.encodingDefaultJson = QosDataType.encodingDefaultJson;
registerClassDefinition( QosDataType.dataTypeNodeId, "QosDataType", QosDataType);
// --------------------------------------------------------------------------------------------
const schemaQuantityDimension = buildStructuredType({
    name: "QuantityDimension",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "MassExponent",

            fieldType: "SByte",
        },
        {
            name: "LengthExponent",

            fieldType: "SByte",
        },
        {
            name: "TimeExponent",

            fieldType: "SByte",
        },
        {
            name: "ElectricCurrentExponent",

            fieldType: "SByte",
        },
        {
            name: "AmountOfSubstanceExponent",

            fieldType: "SByte",
        },
        {
            name: "LuminousIntensityExponent",

            fieldType: "SByte",
        },
        {
            name: "AbsoluteTemperatureExponent",

            fieldType: "SByte",
        },
        {
            name: "DimensionlessExponent",

            fieldType: "SByte",
        },
    ]
});
export interface QuantityDimensionOptions {
    massExponent?: SByte ;
    lengthExponent?: SByte ;
    timeExponent?: SByte ;
    electricCurrentExponent?: SByte ;
    amountOfSubstanceExponent?: SByte ;
    luminousIntensityExponent?: SByte ;
    absoluteTemperatureExponent?: SByte ;
    dimensionlessExponent?: SByte ;
}
export class QuantityDimension extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaQuantityDimension; }
    public static possibleFields: string[] = [
          "massExponent",
           "lengthExponent",
           "timeExponent",
           "electricCurrentExponent",
           "amountOfSubstanceExponent",
           "luminousIntensityExponent",
           "absoluteTemperatureExponent",
           "dimensionlessExponent"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(32438, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(32562, 0);
    public static encodingDefaultXml = makeExpandedNodeId(32574, 0);
    public static encodingDefaultJson = makeExpandedNodeId(32586, 0);
    public massExponent: SByte;
    public lengthExponent: SByte;
    public timeExponent: SByte;
    public electricCurrentExponent: SByte;
    public amountOfSubstanceExponent: SByte;
    public luminousIntensityExponent: SByte;
    public absoluteTemperatureExponent: SByte;
    public dimensionlessExponent: SByte;

    constructor(options?: QuantityDimensionOptions | null) {

        super(options);

        if (options === null) {
            this.massExponent = 0;
            this.lengthExponent = 0;
            this.timeExponent = 0;
            this.electricCurrentExponent = 0;
            this.amountOfSubstanceExponent = 0;
            this.luminousIntensityExponent = 0;
            this.absoluteTemperatureExponent = 0;
            this.dimensionlessExponent = 0;
              return;
        }
        const schema = QuantityDimension.schema;
        options = (schema.constructHook ? schema.constructHook(options) as QuantityDimensionOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.massExponent = initialize_field(schema.fields[0], options?.massExponent);
        this.lengthExponent = initialize_field(schema.fields[1], options?.lengthExponent);
        this.timeExponent = initialize_field(schema.fields[2], options?.timeExponent);
        this.electricCurrentExponent = initialize_field(schema.fields[3], options?.electricCurrentExponent);
        this.amountOfSubstanceExponent = initialize_field(schema.fields[4], options?.amountOfSubstanceExponent);
        this.luminousIntensityExponent = initialize_field(schema.fields[5], options?.luminousIntensityExponent);
        this.absoluteTemperatureExponent = initialize_field(schema.fields[6], options?.absoluteTemperatureExponent);
        this.dimensionlessExponent = initialize_field(schema.fields[7], options?.dimensionlessExponent);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeSByte(this.massExponent, stream);
        encodeSByte(this.lengthExponent, stream);
        encodeSByte(this.timeExponent, stream);
        encodeSByte(this.electricCurrentExponent, stream);
        encodeSByte(this.amountOfSubstanceExponent, stream);
        encodeSByte(this.luminousIntensityExponent, stream);
        encodeSByte(this.absoluteTemperatureExponent, stream);
        encodeSByte(this.dimensionlessExponent, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.massExponent = decodeSByte(stream, this.massExponent);
        this.lengthExponent = decodeSByte(stream, this.lengthExponent);
        this.timeExponent = decodeSByte(stream, this.timeExponent);
        this.electricCurrentExponent = decodeSByte(stream, this.electricCurrentExponent);
        this.amountOfSubstanceExponent = decodeSByte(stream, this.amountOfSubstanceExponent);
        this.luminousIntensityExponent = decodeSByte(stream, this.luminousIntensityExponent);
        this.absoluteTemperatureExponent = decodeSByte(stream, this.absoluteTemperatureExponent);
        this.dimensionlessExponent = decodeSByte(stream, this.dimensionlessExponent);
    }
    public get schema(): IStructuredTypeSchema { return schemaQuantityDimension; }
}
QuantityDimension.schema.dataTypeNodeId = QuantityDimension.dataTypeNodeId;
QuantityDimension.schema.encodingDefaultBinary = QuantityDimension.encodingDefaultBinary;
QuantityDimension.schema.encodingDefaultXml = QuantityDimension.encodingDefaultXml;
QuantityDimension.schema.encodingDefaultJson = QuantityDimension.encodingDefaultJson;
registerClassDefinition( QuantityDimension.dataTypeNodeId, "QuantityDimension", QuantityDimension);
// --------------------------------------------------------------------------------------------
const schemaQueryDataSet = buildStructuredType({
    name: "QueryDataSet",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "NodeId",

            fieldType: "ExpandedNodeId",
        },
        {
            name: "TypeDefinitionNode",

            fieldType: "ExpandedNodeId",
        },
        {
            name: "Values",

            fieldType: "Variant",
            isArray: true
        },
    ]
});
export interface QueryDataSetOptions {
    nodeId?: ExpandedNodeId ;
    typeDefinitionNode?: ExpandedNodeId ;
    values?: (VariantLike | null)[] | null;
}
export class QueryDataSet extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaQueryDataSet; }
    public static possibleFields: string[] = [
          "nodeId",
           "typeDefinitionNode",
           "values"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(577, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(579, 0);
    public static encodingDefaultXml = makeExpandedNodeId(578, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15202, 0);
    public nodeId: ExpandedNodeId;
    public typeDefinitionNode: ExpandedNodeId;
    public values: Variant[] | null;

    constructor(options?: QueryDataSetOptions | null) {

        super(options);

        if (options === null) {
            this.nodeId = new ExpandedNodeId(null);
            this.typeDefinitionNode = new ExpandedNodeId(null);
            this.values = []
              return;
        }
        const schema = QueryDataSet.schema;
        options = (schema.constructHook ? schema.constructHook(options) as QueryDataSetOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.nodeId = initialize_field(schema.fields[0], options?.nodeId);
        this.typeDefinitionNode = initialize_field(schema.fields[1], options?.typeDefinitionNode);
        this.values = initialize_field_array(schema.fields[2], options?.values);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        encodeExpandedNodeId(this.nodeId, stream);
        encodeExpandedNodeId(this.typeDefinitionNode, stream);
        encodeArray(this.values, stream, encodeVariant);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.nodeId = decodeExpandedNodeId(stream, this.nodeId);
        this.typeDefinitionNode = decodeExpandedNodeId(stream, this.typeDefinitionNode);
        this.values = decodeArray(stream, decodeVariant);
    }
    public get schema(): IStructuredTypeSchema { return schemaQueryDataSet; }
}
QueryDataSet.schema.dataTypeNodeId = QueryDataSet.dataTypeNodeId;
QueryDataSet.schema.encodingDefaultBinary = QueryDataSet.encodingDefaultBinary;
QueryDataSet.schema.encodingDefaultXml = QueryDataSet.encodingDefaultXml;
QueryDataSet.schema.encodingDefaultJson = QueryDataSet.encodingDefaultJson;
registerClassDefinition( QueryDataSet.dataTypeNodeId, "QueryDataSet", QueryDataSet);
// --------------------------------------------------------------------------------------------
const schemaQueryFirstRequest = buildStructuredType({
    name: "QueryFirstRequest",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",

            fieldType: "RequestHeader",
        },
        {
            name: "View",

            fieldType: "ViewDescription",
        },
        {
            name: "NodeTypes",

            fieldType: "NodeTypeDescription",
            isArray: true
        },
        {
            name: "Filter",

            fieldType: "ContentFilter",
        },
        {
            name: "MaxDataSetsToReturn",

            fieldType: "UInt32",
        },
        {
            name: "MaxReferencesToReturn",

            fieldType: "UInt32",
        },
    ]
});
export interface QueryFirstRequestOptions {
    requestHeader?: RequestHeaderOptions ;
    view?: ViewDescriptionOptions ;
    nodeTypes?: NodeTypeDescriptionOptions [] | null;
    filter?: ContentFilterOptions ;
    maxDataSetsToReturn?: UInt32 ;
    maxReferencesToReturn?: UInt32 ;
}
export class QueryFirstRequest extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaQueryFirstRequest; }
    public static possibleFields: string[] = [
          "requestHeader",
           "view",
           "nodeTypes",
           "filter",
           "maxDataSetsToReturn",
           "maxReferencesToReturn"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(613, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(615, 0);
    public static encodingDefaultXml = makeExpandedNodeId(614, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15244, 0);
    public requestHeader: RequestHeader;
    public view: ViewDescription;
    public nodeTypes: NodeTypeDescription[] | null;
    public filter: ContentFilter;
    public maxDataSetsToReturn: UInt32;
    public maxReferencesToReturn: UInt32;

    constructor(options?: QueryFirstRequestOptions | null) {

        super(options);

        if (options === null) {
         this.requestHeader =  new RequestHeader(null);
         this.view =  new ViewDescription(null);
         this.nodeTypes =  null; /* null array */
         this.filter =  new ContentFilter(null);
            this.maxDataSetsToReturn = 0;
            this.maxReferencesToReturn = 0;
              return;
        }
        const schema = QueryFirstRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) as QueryFirstRequestOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.requestHeader  =  new RequestHeader(options.requestHeader);
        this.view  =  new ViewDescription(options.view);
        this.nodeTypes = []; // should default
        if (options.nodeTypes) {
            assert(Array.isArray(options.nodeTypes));
            this.nodeTypes = options.nodeTypes.map((e: any) => new NodeTypeDescription(e));
        }
        this.filter  =  new ContentFilter(options.filter);
        this.maxDataSetsToReturn = initialize_field(schema.fields[4], options?.maxDataSetsToReturn);
        this.maxReferencesToReturn = initialize_field(schema.fields[5], options?.maxReferencesToReturn);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        this.view.encode(stream);
        encodeArray(this.nodeTypes, stream, (obj, stream1) => { obj.encode(stream1); });
        this.filter.encode(stream);
        encodeUInt32(this.maxDataSetsToReturn, stream);
        encodeUInt32(this.maxReferencesToReturn, stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.view.decode(stream);
        this.nodeTypes = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new NodeTypeDescription(null);
            obj.decode(stream1);
            return obj;
        });
        this.filter.decode(stream);
        this.maxDataSetsToReturn = decodeUInt32(stream, this.maxDataSetsToReturn);
        this.maxReferencesToReturn = decodeUInt32(stream, this.maxReferencesToReturn);
    }
    public get schema(): IStructuredTypeSchema { return schemaQueryFirstRequest; }
}
QueryFirstRequest.schema.dataTypeNodeId = QueryFirstRequest.dataTypeNodeId;
QueryFirstRequest.schema.encodingDefaultBinary = QueryFirstRequest.encodingDefaultBinary;
QueryFirstRequest.schema.encodingDefaultXml = QueryFirstRequest.encodingDefaultXml;
QueryFirstRequest.schema.encodingDefaultJson = QueryFirstRequest.encodingDefaultJson;
registerClassDefinition( QueryFirstRequest.dataTypeNodeId, "QueryFirstRequest", QueryFirstRequest);
// --------------------------------------------------------------------------------------------
const schemaQueryFirstResponse = buildStructuredType({
    name: "QueryFirstResponse",

    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",

            fieldType: "ResponseHeader",
        },
        {
            name: "QueryDataSets",

            fieldType: "QueryDataSet",
            isArray: true
        },
        {
            name: "ContinuationPoint",

            fieldType: "ByteString",
        },
        {
            name: "ParsingResults",

            fieldType: "ParsingResult",
            isArray: true
        },
        {
            name: "DiagnosticInfos",

            fieldType: "DiagnosticInfo",
            isArray: true
        },
        {
            name: "FilterResult",

            fieldType: "ContentFilterResult",
        },
    ]
});
export interface QueryFirstResponseOptions {
    responseHeader?: ResponseHeaderOptions ;
    queryDataSets?: QueryDataSetOptions [] | null;
    continuationPoint?: ByteString ;
    parsingResults?: ParsingResultOptions [] | null;
    diagnosticInfos?: (DiagnosticInfo | null)[] | null;
    filterResult?: ContentFilterResultOptions ;
}
export class QueryFirstResponse extends ExtensionObject {
    public static get schema(): IStructuredTypeSchema { return schemaQueryFirstResponse; }
    public static possibleFields: string[] = [
          "responseHeader",
           "queryDataSets",
           "continuationPoint",
           "parsingResults",
           "diagnosticInfos",
           "filterResult"
    ];
    public static dataTypeNodeId = makeExpandedNodeId(616, 0);
    public static encodingDefaultBinary = makeExpandedNodeId(618, 0);
    public static encodingDefaultXml = makeExpandedNodeId(617, 0);
    public static encodingDefaultJson = makeExpandedNodeId(15252, 0);
    public responseHeader: ResponseHeader;
    public queryDataSets: QueryDataSet[] | null;
    public continuationPoint: ByteString;
    public parsingResults: ParsingResult[] | null;
    public diagnosticInfos: (DiagnosticInfo | null)[] | null;
    public filterResult: ContentFilterResult;

    constructor(options?: QueryFirstResponseOptions | null) {

        super(options);

        if (options === null) {
         this.responseHeader =  new ResponseHeader(null);
         this.queryDataSets =  null; /* null array */
            this.continuationPoint = Buffer.alloc(0);
         this.parsingResults =  null; /* null array */
            this.diagnosticInfos = []
         this.filterResult =  new ContentFilterResult(null);
              return;
        }
        const schema = QueryFirstResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) as QueryFirstResponseOptions: options ) || {};
        /* istanbul ignore next */
        if (parameters.debugSchemaHelper) {
            check_options_correctness_against_schema(this, schema, options);
        }
        this.responseHeader  =  new ResponseHeader(options.responseHeader);
        this.queryDataSets = []; // should default
        if (options.queryDataSets) {
            assert(Array.isArray(options.queryDataSets));
            this.queryDataSets = options.queryDataSets.map((e: any) => new QueryDataSet(e));
        }
        this.continuationPoint = initialize_field(schema.fields[2], options?.continuationPoint);
        this.parsingResults = []; // should default
        if (options.parsingResults) {
            assert(Array.isArray(options.parsingResults));
            this.parsingResults = options.parsingResults.map((e: any) => new ParsingResult(e));
        }
        this.diagnosticInfos = initialize_field_array(schema.fields[4], options?.diagnosticInfos);
        this.filterResult  =  new ContentFilterResult(options.filterResult);
    }
     public encode(stream: OutputBinaryStream): void {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        encodeArray(this.queryDataSets, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeByteString(this.continuationPoint, stream);
        encodeArray(this.parsingResults, stream, (obj, stream1) => { obj.encode(stream1); });
        encodeArray(this.diagnosticInfos, stream, encodeDiagnosticInfo);
        this.filterResult.encode(stream);
    }
    public decode(stream: BinaryStream): void {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.queryDataSets = decodeArray(stream, (stream1: BinaryStream) => {
            const obj = new QueryDataSet(null);
            obj.decode(stream1);
            return obj;
        });
        this.continuationPoint = decodeByteString(stream, this.continuationPoint);
        this.parsingResults = decod