"use strict";
// --------- This code has been automatically generated !!! 2025-09-24T21:15:01.295Z
/**
 * @module node-opcua-types
 */
// tslint:disable:no-this-assignment
// tslint:disable:max-classes-per-file
// tslint:disable:no-empty-interface
// tslint:disable:no-trailing-whitespace
// tslint:disable:array-type
// tslint:disable:object-literal-sort-keys
// tslint:disable:max-line-length
Object.defineProperty(exports, "__esModule", { value: true });
exports.BrokerDataSetReaderTransportDataType = exports._enumerationBrokerTransportQualityOfService = exports.BrokerTransportQualityOfService = exports.DataSetReaderTransportDataType = exports.BrokerConnectionTransportDataType = exports.ConnectionTransportDataType = exports.BitFieldDefinition = exports.AttributeOperand = exports.RelativePath = exports.RelativePathElement = exports.Argument = exports.ApplicationDescription = exports._enumerationApplicationType = exports.ApplicationType = exports.AnonymousIdentityToken = exports.UserIdentityToken = exports.AnnotationDataType = exports.Annotation = exports.AliasNameDataType = exports.AggregateFilterResult = exports.MonitoringFilterResult = exports.AggregateFilter = exports.MonitoringFilter = exports.AggregateConfiguration = exports.AdditionalParametersType = exports.KeyValuePair = exports.AddReferencesResponse = exports.AddReferencesRequest = exports.AddReferencesItem = exports.AddNodesResponse = exports.AddNodesResult = exports.AddNodesRequest = exports.AddNodesItem = exports._enumerationNodeClass = exports.NodeClass = exports.ActivateSessionResponse = exports.ResponseHeader = exports.ActivateSessionRequest = exports.SignedSoftwareCertificate = exports.SignatureData = exports.RequestHeader = exports.ActionTargetDataType = exports.ActionMethodDataType = exports.SimpleAttributeOperand = exports.FilterOperand = exports.AxisInformation = exports._enumerationAxisScaleEnumeration = exports.AxisScaleEnumeration = exports.Range = exports.EUInformation = void 0;
exports.UserTokenPolicy = exports._enumerationUserTokenType = exports.UserTokenType = exports._enumerationMessageSecurityMode = exports.MessageSecurityMode = exports.CreateSessionRequest = exports.CreateMonitoredItemsResponse = exports.MonitoredItemCreateResult = exports.CreateMonitoredItemsRequest = exports.MonitoredItemCreateRequest = exports.MonitoringParameters = exports._enumerationMonitoringMode = exports.MonitoringMode = exports.ReadValueId = exports.ContentFilterResult = exports.ContentFilterElementResult = exports.ContentFilter = exports.ContentFilterElement = exports._enumerationFilterOperator = exports.FilterOperator = exports.ConfigurationVersionDataType = exports.ComplexNumberType = exports.CloseSessionResponse = exports.CloseSessionRequest = exports.CloseSecureChannelResponse = exports.CloseSecureChannelRequest = exports.ChannelSecurityToken = exports.CartesianCoordinates = exports.CancelResponse = exports.CancelRequest = exports.CallResponse = exports.CallRequest = exports.CallMethodResult = exports.CallMethodRequest = exports.BuildInfo = exports.BrowseResponse = exports.BrowseRequest = exports.ViewDescription = exports.BrowsePathResult = exports.BrowsePathTarget = exports.BrowsePath = exports.BrowseNextResponse = exports.BrowseResult = exports.ReferenceDescription = exports.BrowseNextRequest = exports.BrowseDescription = exports.BrokerWriterGroupTransportDataType = exports.WriterGroupTransportDataType = exports.BrokerDataSetWriterTransportDataType = exports.DataSetWriterTransportDataType = void 0;
exports.DeleteRawModifiedDetails = exports.DeleteNodesResponse = exports.DeleteNodesRequest = exports.DeleteNodesItem = exports.DeleteMonitoredItemsResponse = exports.DeleteMonitoredItemsRequest = exports.DeleteEventDetails = exports.DeleteAtTimeDetails = exports.HistoryUpdateDetails = exports.DatagramWriterGroupTransport2DataType = exports.DatagramWriterGroupTransportDataType = exports.DatagramDataSetReaderTransportDataType = exports.DatagramConnectionTransport2DataType = exports.DatagramConnectionTransportDataType = exports.DataTypeAttributes = exports.NodeAttributes = exports.DataSetWriterMessageDataType = exports.DataSetWriterDataType = exports.DataSetReaderMessageDataType = exports.DataSetReaderDataType = exports._enumerationDataSetFieldContentMask = exports.DataSetFieldContentMask = exports.DataSetMetaDataType = exports.FieldMetaData = exports._enumerationDataSetFieldFlags = exports.DataSetFieldFlags = exports.DataTypeSchemaHeader = exports.SimpleTypeDescription = exports.EnumDescription = exports.EnumDefinition = exports.EnumField = exports.EnumValueType = exports.StructureDescription = exports.StructureDefinition = exports.StructureField = exports._enumerationStructureType = exports.StructureType = exports.DataTypeDefinition = exports.DataTypeDescription = exports.DataChangeNotification = exports.MonitoredItemNotification = exports.NotificationData = exports.DataChangeFilter = exports._enumerationDataChangeTrigger = exports.DataChangeTrigger = exports.CurrencyUnitType = exports.CreateSubscriptionResponse = exports.CreateSubscriptionRequest = exports.CreateSessionResponse = exports.EndpointDescription = void 0;
exports.IssuedIdentityToken = exports.IdentityMappingRuleType = exports._enumerationIdentityCriteriaType = exports.IdentityCriteriaType = exports.HistoryUpdateResponse = exports.HistoryUpdateResult = exports.HistoryUpdateRequest = exports.HistoryReadResponse = exports.HistoryReadResult = exports.HistoryReadRequest = exports.HistoryReadValueId = exports.HistoryReadDetails = exports.HistoryModifiedEvent = exports.HistoryModifiedData = exports.ModificationInfo = exports._enumerationHistoryUpdateType = exports.HistoryUpdateType = exports.HistoryEvent = exports.HistoryEventFieldList = exports.HistoryData = exports.GetEndpointsResponse = exports.GetEndpointsRequest = exports.GenericAttributes = exports.GenericAttributeValue = exports.Frame = exports.FindServersResponse = exports.FindServersRequest = exports.FindServersOnNetworkResponse = exports.ServerOnNetwork = exports.FindServersOnNetworkRequest = exports.FieldTargetDataType = exports._enumerationOverrideValueHandling = exports.OverrideValueHandling = exports.EventNotificationList = exports.EventFilterResult = exports.EventFilter = exports.EventFieldList = exports.EphemeralKeyType = exports.EndpointUrlListDataType = exports.EndpointType = exports.EndpointConfiguration = exports.ElementOperand = exports.DtlsPubSubConnectionDataType = exports.DoubleComplexNumberType = exports.DiscoveryConfiguration = exports.DeleteSubscriptionsResponse = exports.DeleteSubscriptionsRequest = exports.DeleteReferencesResponse = exports.DeleteReferencesRequest = exports.DeleteReferencesItem = void 0;
exports.NodeTypeDescription = exports.QueryDataDescription = exports.NodeReference = exports.NetworkGroupDataType = exports.NetworkAddressUrlDataType = exports.NetworkAddressDataType = exports.ModifySubscriptionResponse = exports.ModifySubscriptionRequest = exports.ModifyMonitoredItemsResponse = exports.MonitoredItemModifyResult = exports.ModifyMonitoredItemsRequest = exports.MonitoredItemModifyRequest = exports.ModelChangeStructureDataType = exports.MethodAttributes = exports.MdnsDiscoveryConfiguration = exports.LldpTlvType = exports.LldpManagementAddressType = exports.LldpManagementAddressTxPortType = exports._enumerationManAddrIfSubtype = exports.ManAddrIfSubtype = exports.LiteralOperand = exports.LinearConversionDataType = exports.JsonWriterGroupMessageDataType = exports.WriterGroupMessageDataType = exports.JsonStatusMessage = exports._enumerationPubSubState = exports.PubSubState = exports.JsonServerEndpointsMessage = exports.JsonPubSubConnectionMessage = exports.JsonNetworkMessage = exports.JsonDataSetWriterMessageDataType = exports.JsonDataSetReaderMessageDataType = exports._enumerationJsonDataSetMessageContentMask = exports.JsonDataSetMessageContentMask = exports._enumerationJsonNetworkMessageContentMask = exports.JsonNetworkMessageContentMask = exports.JsonDataSetMetaDataMessage = exports.JsonDataSetMessage = exports.JsonApplicationDescriptionMessage = exports.JsonActionResponseMessage = exports.JsonActionResponderMessage = exports.PubSubConnectionDataType = exports.ReaderGroupDataType = exports.WriterGroupDataType = exports.PubSubGroupDataType = exports.JsonActionRequestMessage = exports._enumerationActionState = exports.ActionState = exports.JsonActionNetworkMessage = exports.JsonActionMetaDataMessage = void 0;
exports.ReadAtTimeDetails = exports.ReadAnnotationDataDetails = exports.RationalNumber = exports.QueryNextResponse = exports.QueryNextRequest = exports.QueryFirstResponse = exports.QueryFirstRequest = exports.QueryDataSet = exports.QuantityDimension = exports.QosDataType = exports.PublishedEventsDataType = exports.PublishedDataSetCustomSourceDataType = exports.PublishedDataItemsDataType = exports.PublishedVariableDataType = exports.PublishedActionMethodDataType = exports.PublishedActionDataType = exports.PublishedDataSetSourceDataType = exports.PublishResponse = exports.PublishRequest = exports.SubscriptionAcknowledgement = exports.PubSubConfigurationValueDataType = exports.PubSubConfigurationRefDataType = exports._enumerationPubSubConfigurationRefMask = exports.PubSubConfigurationRefMask = exports.PubSubConfiguration2DataType = exports.PubSubKeyPushTargetDataType = exports.SecurityGroupDataType = exports.RolePermissionType = exports._enumerationPermissionType = exports.PermissionType = exports.StandaloneSubscribedDataSetDataType = exports.SubscribedDataSetDataType = exports.PubSubConfigurationDataType = exports.PublishedDataSetDataType = exports.ProgramDiagnosticDataType = exports.StatusResult = exports.ProgramDiagnostic2DataType = exports.PriorityMappingEntryType = exports.PortableQualifiedName = exports.PortableNodeId = exports.ParsingResult = exports.Orientation = exports.OptionSet = exports.OpenSecureChannelResponse = exports.OpenSecureChannelRequest = exports._enumerationSecurityTokenRequestType = exports.SecurityTokenRequestType = exports.ObjectTypeAttributes = exports.ObjectAttributes = exports.NotificationMessage = void 0;
exports.TargetVariablesDataType = exports.SubscriptionDiagnosticsDataType = exports.SubscribedDataSetMirrorDataType = exports.StatusChangeNotification = exports.StandaloneSubscribedDataSetRefDataType = exports.SetTriggeringResponse = exports.SetTriggeringRequest = exports.SetPublishingModeResponse = exports.SetPublishingModeRequest = exports.SetMonitoringModeResponse = exports.SetMonitoringModeRequest = exports.SessionlessInvokeResponseType = exports.SessionlessInvokeRequestType = exports.SessionSecurityDiagnosticsDataType = exports.SessionDiagnosticsDataType = exports.ServiceFault = exports.ServiceCounterDataType = exports.ServerStatusDataType = exports.ServerDiagnosticsSummaryDataType = exports.SemanticChangeStructureDataType = exports.SamplingIntervalDiagnosticsDataType = exports.RepublishResponse = exports.RepublishRequest = exports.RegisterServerResponse = exports.RegisterServerRequest = exports.RegisterServer2Response = exports.RegisterServer2Request = exports.RegisteredServer = exports.RegisterNodesResponse = exports.RegisterNodesRequest = exports.ReferenceTypeAttributes = exports.ReferenceListEntryDataType = exports.ReferenceDescriptionDataType = exports.RedundantServerDataType = exports._enumerationServerState = exports.ServerState = exports.ReceiveQosPriorityDataType = exports.ReceiveQosDataType = exports.ReaderGroupTransportDataType = exports.ReaderGroupMessageDataType = exports.ReadResponse = exports.ReadRequest = exports.ReadRawModifiedDetails = exports.ReadProcessedDetails = exports.ReadEventDetailsSorted = exports.SortRuleElement = exports._enumerationSortOrderType = exports.SortOrderType = exports.ReadEventDetails2 = exports.ReadEventDetails = void 0;
exports.XVType = exports.X509IdentityToken = exports.WriteResponse = exports.WriteRequest = exports.WriteValue = exports.ViewAttributes = exports.VariableTypeAttributes = exports.VariableAttributes = exports.UserNameIdentityToken = exports.UserManagementDataType = exports._enumerationUserConfigurationMask = exports.UserConfigurationMask = exports.UpdateStructureDataDetails = exports.UpdateEventDetails = exports.UpdateDataDetails = exports._enumerationPerformUpdateType = exports.PerformUpdateType = exports.UnsignedRationalNumber = exports.UnregisterNodesResponse = exports.UnregisterNodesRequest = exports.Union = exports.UadpWriterGroupMessageDataType = exports._enumerationDataSetOrderingType = exports.DataSetOrderingType = exports.UadpDataSetWriterMessageDataType = exports.UadpDataSetReaderMessageDataType = exports._enumerationUadpDataSetMessageContentMask = exports.UadpDataSetMessageContentMask = exports._enumerationUadpNetworkMessageContentMask = exports.UadpNetworkMessageContentMask = exports.UABinaryFileDataType = exports.TrustListDataType = exports.TransmitQosPriorityDataType = exports.TransmitQosDataType = exports.TranslateBrowsePathsToNodeIdsResponse = exports.TranslateBrowsePathsToNodeIdsRequest = exports.TransferSubscriptionsResponse = exports.TransferSubscriptionsRequest = exports.TransferResult = exports.TransactionErrorType = exports.TimeZoneDataType = exports.ThreeDVector = exports.Vector = exports.ThreeDFrame = exports.ThreeDOrientation = exports.ThreeDCartesianCoordinates = void 0;
const node_opcua_assert_1 = require("node-opcua-assert");
const node_opcua_basic_types_1 = require("node-opcua-basic-types");
const node_opcua_data_model_1 = require("node-opcua-data-model");
const node_opcua_data_value_1 = require("node-opcua-data-value");
const node_opcua_extension_object_1 = require("node-opcua-extension-object");
const node_opcua_factory_1 = require("node-opcua-factory");
const node_opcua_nodeid_1 = require("node-opcua-nodeid");
const node_opcua_numeric_range_1 = require("node-opcua-numeric-range");
const node_opcua_status_code_1 = require("node-opcua-status-code");
const node_opcua_variant_1 = require("node-opcua-variant");
// --------------------------------------------------------------------------------------------
const schemaEUInformation = (0, node_opcua_factory_1.buildStructuredType)({
    name: "EUInformation",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "NamespaceUri",
            fieldType: "String",
        },
        {
            name: "UnitId",
            fieldType: "Int32",
        },
        {
            name: "DisplayName",
            fieldType: "LocalizedText",
        },
        {
            name: "Description",
            fieldType: "LocalizedText",
        },
    ]
});
class EUInformation extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaEUInformation; }
    static possibleFields = [
        "namespaceUri",
        "unitId",
        "displayName",
        "description"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(887, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(889, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(888, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15376, 0);
    namespaceUri;
    unitId;
    displayName;
    description;
    constructor(options) {
        super(options);
        if (options === null) {
            this.namespaceUri = null;
            this.unitId = 0;
            this.displayName = new node_opcua_data_model_1.LocalizedText(null);
            this.description = new node_opcua_data_model_1.LocalizedText(null);
            return;
        }
        const schema = EUInformation.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.namespaceUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.namespaceUri);
        this.unitId = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.unitId);
        this.displayName = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.displayName);
        this.description = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.description);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.namespaceUri, stream);
        (0, node_opcua_basic_types_1.encodeInt32)(this.unitId, stream);
        (0, node_opcua_data_model_1.encodeLocalizedText)(this.displayName, stream);
        (0, node_opcua_data_model_1.encodeLocalizedText)(this.description, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.namespaceUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.namespaceUri);
        this.unitId = (0, node_opcua_basic_types_1.decodeInt32)(stream, this.unitId);
        this.displayName = (0, node_opcua_data_model_1.decodeLocalizedText)(stream, this.displayName);
        this.description = (0, node_opcua_data_model_1.decodeLocalizedText)(stream, this.description);
    }
    get schema() { return schemaEUInformation; }
}
exports.EUInformation = EUInformation;
EUInformation.schema.dataTypeNodeId = EUInformation.dataTypeNodeId;
EUInformation.schema.encodingDefaultBinary = EUInformation.encodingDefaultBinary;
EUInformation.schema.encodingDefaultXml = EUInformation.encodingDefaultXml;
EUInformation.schema.encodingDefaultJson = EUInformation.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(EUInformation.dataTypeNodeId, "EUInformation", EUInformation);
// --------------------------------------------------------------------------------------------
const schemaRange = (0, node_opcua_factory_1.buildStructuredType)({
    name: "Range",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Low",
            fieldType: "Double",
        },
        {
            name: "High",
            fieldType: "Double",
        },
    ]
});
class Range extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaRange; }
    static possibleFields = [
        "low",
        "high"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(884, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(886, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(885, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15375, 0);
    low;
    high;
    constructor(options) {
        super(options);
        if (options === null) {
            this.low = 0;
            this.high = 0;
            return;
        }
        const schema = Range.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.low = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.low);
        this.high = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.high);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeDouble)(this.low, stream);
        (0, node_opcua_basic_types_1.encodeDouble)(this.high, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.low = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.low);
        this.high = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.high);
    }
    get schema() { return schemaRange; }
}
exports.Range = Range;
Range.schema.dataTypeNodeId = Range.dataTypeNodeId;
Range.schema.encodingDefaultBinary = Range.encodingDefaultBinary;
Range.schema.encodingDefaultXml = Range.encodingDefaultXml;
Range.schema.encodingDefaultJson = Range.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(Range.dataTypeNodeId, "Range", Range);
// --------------------------------------------------------------------------------------------
var AxisScaleEnumeration;
(function (AxisScaleEnumeration) {
    AxisScaleEnumeration[AxisScaleEnumeration["Linear"] = 0] = "Linear";
    AxisScaleEnumeration[AxisScaleEnumeration["Log"] = 1] = "Log";
    AxisScaleEnumeration[AxisScaleEnumeration["Ln"] = 2] = "Ln";
    AxisScaleEnumeration[AxisScaleEnumeration["Invalid"] = 4294967295] = "Invalid";
})(AxisScaleEnumeration || (exports.AxisScaleEnumeration = AxisScaleEnumeration = {}));
const schemaAxisScaleEnumeration = {
    enumValues: AxisScaleEnumeration,
    flaggable: false,
    minValue: 0,
    maxValue: 2,
    name: "AxisScaleEnumeration"
};
function decodeAxisScaleEnumeration(stream, _value) {
    let value = stream.readUInt32();
    value = (value < schemaAxisScaleEnumeration.minValue || value > schemaAxisScaleEnumeration.maxValue) ? AxisScaleEnumeration.Invalid : value;
    return value;
}
function encodeAxisScaleEnumeration(value, stream) {
    stream.writeUInt32(value);
}
exports._enumerationAxisScaleEnumeration = (0, node_opcua_factory_1.registerEnumeration)(schemaAxisScaleEnumeration);
(0, node_opcua_assert_1.assert)(exports._enumerationAxisScaleEnumeration.isFlaggable === false);
// --------------------------------------------------------------------------------------------
const schemaAxisInformation = (0, node_opcua_factory_1.buildStructuredType)({
    name: "AxisInformation",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "EngineeringUnits",
            fieldType: "EUInformation",
        },
        {
            name: "EURange",
            fieldType: "Range",
        },
        {
            name: "Title",
            fieldType: "LocalizedText",
        },
        {
            name: "AxisScaleType",
            fieldType: "AxisScaleEnumeration",
        },
        {
            name: "AxisSteps",
            fieldType: "Double",
            isArray: true
        },
    ]
});
class AxisInformation extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaAxisInformation; }
    static possibleFields = [
        "engineeringUnits",
        "euRange",
        "title",
        "axisScaleType",
        "axisSteps"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12079, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12089, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12081, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15379, 0);
    engineeringUnits;
    euRange;
    title;
    axisScaleType;
    axisSteps;
    constructor(options) {
        super(options);
        if (options === null) {
            this.engineeringUnits = new EUInformation(null);
            this.euRange = new Range(null);
            this.title = new node_opcua_data_model_1.LocalizedText(null);
            this.axisScaleType = 0;
            this.axisSteps = [];
            return;
        }
        const schema = AxisInformation.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.engineeringUnits = new EUInformation(options.engineeringUnits);
        this.euRange = new Range(options.euRange);
        this.title = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.title);
        this.axisScaleType = this.setAxisScaleType((0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.axisScaleType));
        this.axisSteps = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[4], options?.axisSteps);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.engineeringUnits.encode(stream);
        this.euRange.encode(stream);
        (0, node_opcua_data_model_1.encodeLocalizedText)(this.title, stream);
        encodeAxisScaleEnumeration(this.axisScaleType, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.axisSteps, stream, node_opcua_basic_types_1.encodeDouble);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.engineeringUnits.decode(stream);
        this.euRange.decode(stream);
        this.title = (0, node_opcua_data_model_1.decodeLocalizedText)(stream, this.title);
        this.axisScaleType = decodeAxisScaleEnumeration(stream, this.axisScaleType);
        this.axisSteps = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeDouble);
    }
    // Define Enumeration setters
    setAxisScaleType(value) {
        const coercedValue = exports._enumerationAxisScaleEnumeration.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to AxisScaleEnumeration :" + value);
        }
        this.axisScaleType = coercedValue.value;
        return this.axisScaleType;
    }
    get schema() { return schemaAxisInformation; }
}
exports.AxisInformation = AxisInformation;
AxisInformation.schema.dataTypeNodeId = AxisInformation.dataTypeNodeId;
AxisInformation.schema.encodingDefaultBinary = AxisInformation.encodingDefaultBinary;
AxisInformation.schema.encodingDefaultXml = AxisInformation.encodingDefaultXml;
AxisInformation.schema.encodingDefaultJson = AxisInformation.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(AxisInformation.dataTypeNodeId, "AxisInformation", AxisInformation);
// --------------------------------------------------------------------------------------------
const schemaFilterOperand = (0, node_opcua_factory_1.buildStructuredType)({
    name: "FilterOperand",
    baseType: "ExtensionObject",
    fields: []
});
class FilterOperand extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaFilterOperand; }
    static possibleFields = [];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(589, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(591, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(590, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15206, 0);
    constructor(options) {
        super(options);
        if (options === null) {
            return;
        }
        const schema = FilterOperand.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    get schema() { return schemaFilterOperand; }
}
exports.FilterOperand = FilterOperand;
FilterOperand.schema.dataTypeNodeId = FilterOperand.dataTypeNodeId;
FilterOperand.schema.encodingDefaultBinary = FilterOperand.encodingDefaultBinary;
FilterOperand.schema.encodingDefaultXml = FilterOperand.encodingDefaultXml;
FilterOperand.schema.encodingDefaultJson = FilterOperand.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(FilterOperand.dataTypeNodeId, "FilterOperand", FilterOperand);
// --------------------------------------------------------------------------------------------
const schemaSimpleAttributeOperand = (0, node_opcua_factory_1.buildStructuredType)({
    name: "SimpleAttributeOperand",
    baseType: "FilterOperand",
    fields: [
        {
            name: "TypeDefinitionId",
            fieldType: "NodeId",
        },
        {
            name: "BrowsePath",
            fieldType: "QualifiedName",
            isArray: true
        },
        {
            name: "AttributeId",
            fieldType: "UInt32",
        },
        {
            name: "IndexRange",
            fieldType: "NumericRange",
        },
    ]
});
class SimpleAttributeOperand extends FilterOperand {
    static get schema() { return schemaSimpleAttributeOperand; }
    static possibleFields = [
        "typeDefinitionId",
        "browsePath",
        "attributeId",
        "indexRange"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(601, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(603, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(602, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15210, 0);
    typeDefinitionId;
    browsePath;
    attributeId;
    indexRange;
    constructor(options) {
        super(options);
        if (options === null) {
            this.typeDefinitionId = new node_opcua_nodeid_1.NodeId(null);
            this.browsePath = [];
            this.attributeId = 0;
            this.indexRange = new node_opcua_numeric_range_1.NumericRange(null);
            return;
        }
        const schema = SimpleAttributeOperand.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.typeDefinitionId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.typeDefinitionId);
        this.browsePath = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.browsePath);
        this.attributeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.attributeId);
        this.indexRange = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.indexRange);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.typeDefinitionId, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.browsePath, stream, node_opcua_data_model_1.encodeQualifiedName);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.attributeId, stream);
        (0, node_opcua_numeric_range_1.encodeNumericRange)(this.indexRange, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.typeDefinitionId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.typeDefinitionId);
        this.browsePath = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_data_model_1.decodeQualifiedName);
        this.attributeId = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.attributeId);
        this.indexRange = (0, node_opcua_numeric_range_1.decodeNumericRange)(stream, this.indexRange);
    }
    get schema() { return schemaSimpleAttributeOperand; }
}
exports.SimpleAttributeOperand = SimpleAttributeOperand;
SimpleAttributeOperand.schema.dataTypeNodeId = SimpleAttributeOperand.dataTypeNodeId;
SimpleAttributeOperand.schema.encodingDefaultBinary = SimpleAttributeOperand.encodingDefaultBinary;
SimpleAttributeOperand.schema.encodingDefaultXml = SimpleAttributeOperand.encodingDefaultXml;
SimpleAttributeOperand.schema.encodingDefaultJson = SimpleAttributeOperand.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(SimpleAttributeOperand.dataTypeNodeId, "SimpleAttributeOperand", SimpleAttributeOperand);
// --------------------------------------------------------------------------------------------
const schemaActionMethodDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ActionMethodDataType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ObjectId",
            fieldType: "NodeId",
        },
        {
            name: "MethodId",
            fieldType: "NodeId",
        },
    ]
});
class ActionMethodDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaActionMethodDataType; }
    static possibleFields = [
        "objectId",
        "methodId"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    objectId;
    methodId;
    constructor(options) {
        super(options);
        if (options === null) {
            this.objectId = new node_opcua_nodeid_1.NodeId(null);
            this.methodId = new node_opcua_nodeid_1.NodeId(null);
            return;
        }
        const schema = ActionMethodDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.objectId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.objectId);
        this.methodId = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.methodId);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.objectId, stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.methodId, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.objectId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.objectId);
        this.methodId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.methodId);
    }
    get schema() { return schemaActionMethodDataType; }
}
exports.ActionMethodDataType = ActionMethodDataType;
ActionMethodDataType.schema.dataTypeNodeId = ActionMethodDataType.dataTypeNodeId;
ActionMethodDataType.schema.encodingDefaultBinary = ActionMethodDataType.encodingDefaultBinary;
ActionMethodDataType.schema.encodingDefaultXml = ActionMethodDataType.encodingDefaultXml;
ActionMethodDataType.schema.encodingDefaultJson = ActionMethodDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ActionMethodDataType.dataTypeNodeId, "ActionMethodDataType", ActionMethodDataType);
// --------------------------------------------------------------------------------------------
const schemaActionTargetDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ActionTargetDataType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ActionTargetId",
            fieldType: "UInt16",
        },
        {
            name: "Name",
            fieldType: "String",
        },
        {
            name: "Description",
            fieldType: "LocalizedText",
        },
    ]
});
class ActionTargetDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaActionTargetDataType; }
    static possibleFields = [
        "actionTargetId",
        "name",
        "description"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    actionTargetId;
    name;
    description;
    constructor(options) {
        super(options);
        if (options === null) {
            this.actionTargetId = 0;
            this.name = null;
            this.description = new node_opcua_data_model_1.LocalizedText(null);
            return;
        }
        const schema = ActionTargetDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.actionTargetId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.actionTargetId);
        this.name = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.name);
        this.description = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.description);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt16)(this.actionTargetId, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.name, stream);
        (0, node_opcua_data_model_1.encodeLocalizedText)(this.description, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.actionTargetId = (0, node_opcua_basic_types_1.decodeUInt16)(stream, this.actionTargetId);
        this.name = (0, node_opcua_basic_types_1.decodeString)(stream, this.name);
        this.description = (0, node_opcua_data_model_1.decodeLocalizedText)(stream, this.description);
    }
    get schema() { return schemaActionTargetDataType; }
}
exports.ActionTargetDataType = ActionTargetDataType;
ActionTargetDataType.schema.dataTypeNodeId = ActionTargetDataType.dataTypeNodeId;
ActionTargetDataType.schema.encodingDefaultBinary = ActionTargetDataType.encodingDefaultBinary;
ActionTargetDataType.schema.encodingDefaultXml = ActionTargetDataType.encodingDefaultXml;
ActionTargetDataType.schema.encodingDefaultJson = ActionTargetDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ActionTargetDataType.dataTypeNodeId, "ActionTargetDataType", ActionTargetDataType);
// --------------------------------------------------------------------------------------------
const schemaRequestHeader = (0, node_opcua_factory_1.buildStructuredType)({
    name: "RequestHeader",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "AuthenticationToken",
            fieldType: "NodeId",
        },
        {
            name: "Timestamp",
            fieldType: "DateTime",
        },
        {
            name: "RequestHandle",
            fieldType: "UInt32",
        },
        {
            name: "ReturnDiagnostics",
            fieldType: "UInt32",
        },
        {
            name: "AuditEntryId",
            fieldType: "String",
        },
        {
            name: "TimeoutHint",
            fieldType: "UInt32",
        },
        {
            name: "AdditionalHeader",
            fieldType: "ExtensionObject",
        },
    ]
});
class RequestHeader extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaRequestHeader; }
    static possibleFields = [
        "authenticationToken",
        "timestamp",
        "requestHandle",
        "returnDiagnostics",
        "auditEntryId",
        "timeoutHint",
        "additionalHeader"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(389, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(391, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(390, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15088, 0);
    authenticationToken;
    timestamp;
    requestHandle;
    returnDiagnostics;
    auditEntryId;
    timeoutHint;
    additionalHeader;
    constructor(options) {
        super(options);
        if (options === null) {
            this.authenticationToken = new node_opcua_nodeid_1.NodeId(null);
            this.timestamp = new Date();
            this.requestHandle = 0;
            this.returnDiagnostics = 0;
            this.auditEntryId = null;
            this.timeoutHint = 0;
            this.additionalHeader = null;
            return;
        }
        const schema = RequestHeader.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.authenticationToken = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.authenticationToken);
        this.timestamp = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.timestamp);
        this.requestHandle = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.requestHandle);
        this.returnDiagnostics = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.returnDiagnostics);
        this.auditEntryId = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.auditEntryId);
        this.timeoutHint = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.timeoutHint);
        this.additionalHeader = (0, node_opcua_factory_1.initialize_field)(schema.fields[6], options?.additionalHeader);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.authenticationToken, stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.timestamp, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.requestHandle, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.returnDiagnostics, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.auditEntryId, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.timeoutHint, stream);
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.additionalHeader, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.authenticationToken = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.authenticationToken);
        this.timestamp = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.timestamp);
        this.requestHandle = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.requestHandle);
        this.returnDiagnostics = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.returnDiagnostics);
        this.auditEntryId = (0, node_opcua_basic_types_1.decodeString)(stream, this.auditEntryId);
        this.timeoutHint = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.timeoutHint);
        this.additionalHeader = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.additionalHeader);
    }
    get schema() { return schemaRequestHeader; }
}
exports.RequestHeader = RequestHeader;
RequestHeader.schema.dataTypeNodeId = RequestHeader.dataTypeNodeId;
RequestHeader.schema.encodingDefaultBinary = RequestHeader.encodingDefaultBinary;
RequestHeader.schema.encodingDefaultXml = RequestHeader.encodingDefaultXml;
RequestHeader.schema.encodingDefaultJson = RequestHeader.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(RequestHeader.dataTypeNodeId, "RequestHeader", RequestHeader);
// --------------------------------------------------------------------------------------------
const schemaSignatureData = (0, node_opcua_factory_1.buildStructuredType)({
    name: "SignatureData",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Algorithm",
            fieldType: "String",
        },
        {
            name: "Signature",
            fieldType: "ByteString",
        },
    ]
});
class SignatureData extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaSignatureData; }
    static possibleFields = [
        "algorithm",
        "signature"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(456, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(458, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(457, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15137, 0);
    algorithm;
    signature;
    constructor(options) {
        super(options);
        if (options === null) {
            this.algorithm = null;
            this.signature = Buffer.alloc(0);
            return;
        }
        const schema = SignatureData.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.algorithm = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.algorithm);
        this.signature = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.signature);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.algorithm, stream);
        (0, node_opcua_basic_types_1.encodeByteString)(this.signature, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.algorithm = (0, node_opcua_basic_types_1.decodeString)(stream, this.algorithm);
        this.signature = (0, node_opcua_basic_types_1.decodeByteString)(stream, this.signature);
    }
    get schema() { return schemaSignatureData; }
}
exports.SignatureData = SignatureData;
SignatureData.schema.dataTypeNodeId = SignatureData.dataTypeNodeId;
SignatureData.schema.encodingDefaultBinary = SignatureData.encodingDefaultBinary;
SignatureData.schema.encodingDefaultXml = SignatureData.encodingDefaultXml;
SignatureData.schema.encodingDefaultJson = SignatureData.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(SignatureData.dataTypeNodeId, "SignatureData", SignatureData);
// --------------------------------------------------------------------------------------------
const schemaSignedSoftwareCertificate = (0, node_opcua_factory_1.buildStructuredType)({
    name: "SignedSoftwareCertificate",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "CertificateData",
            fieldType: "ByteString",
        },
        {
            name: "Signature",
            fieldType: "ByteString",
        },
    ]
});
class SignedSoftwareCertificate extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaSignedSoftwareCertificate; }
    static possibleFields = [
        "certificateData",
        "signature"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(344, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(346, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(345, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15136, 0);
    certificateData;
    signature;
    constructor(options) {
        super(options);
        if (options === null) {
            this.certificateData = Buffer.alloc(0);
            this.signature = Buffer.alloc(0);
            return;
        }
        const schema = SignedSoftwareCertificate.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.certificateData = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.certificateData);
        this.signature = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.signature);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeByteString)(this.certificateData, stream);
        (0, node_opcua_basic_types_1.encodeByteString)(this.signature, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.certificateData = (0, node_opcua_basic_types_1.decodeByteString)(stream, this.certificateData);
        this.signature = (0, node_opcua_basic_types_1.decodeByteString)(stream, this.signature);
    }
    get schema() { return schemaSignedSoftwareCertificate; }
}
exports.SignedSoftwareCertificate = SignedSoftwareCertificate;
SignedSoftwareCertificate.schema.dataTypeNodeId = SignedSoftwareCertificate.dataTypeNodeId;
SignedSoftwareCertificate.schema.encodingDefaultBinary = SignedSoftwareCertificate.encodingDefaultBinary;
SignedSoftwareCertificate.schema.encodingDefaultXml = SignedSoftwareCertificate.encodingDefaultXml;
SignedSoftwareCertificate.schema.encodingDefaultJson = SignedSoftwareCertificate.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(SignedSoftwareCertificate.dataTypeNodeId, "SignedSoftwareCertificate", SignedSoftwareCertificate);
// --------------------------------------------------------------------------------------------
const schemaActivateSessionRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ActivateSessionRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",
            fieldType: "RequestHeader",
        },
        {
            name: "ClientSignature",
            fieldType: "SignatureData",
        },
        {
            name: "ClientSoftwareCertificates",
            fieldType: "SignedSoftwareCertificate",
            isArray: true
        },
        {
            name: "LocaleIds",
            fieldType: "String",
            isArray: true
        },
        {
            name: "UserIdentityToken",
            fieldType: "ExtensionObject",
        },
        {
            name: "UserTokenSignature",
            fieldType: "SignatureData",
        },
    ]
});
class ActivateSessionRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaActivateSessionRequest; }
    static possibleFields = [
        "requestHeader",
        "clientSignature",
        "clientSoftwareCertificates",
        "localeIds",
        "userIdentityToken",
        "userTokenSignature"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(465, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(467, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(466, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15145, 0);
    requestHeader;
    clientSignature;
    clientSoftwareCertificates;
    localeIds;
    userIdentityToken;
    userTokenSignature;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestHeader = new RequestHeader(null);
            this.clientSignature = new SignatureData(null);
            this.clientSoftwareCertificates = null; /* null array */
            this.localeIds = [];
            this.userIdentityToken = null;
            this.userTokenSignature = new SignatureData(null);
            return;
        }
        const schema = ActivateSessionRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestHeader = new RequestHeader(options.requestHeader);
        this.clientSignature = new SignatureData(options.clientSignature);
        this.clientSoftwareCertificates = []; // should default
        if (options.clientSoftwareCertificates) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.clientSoftwareCertificates));
            this.clientSoftwareCertificates = options.clientSoftwareCertificates.map((e) => new SignedSoftwareCertificate(e));
        }
        this.localeIds = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[3], options?.localeIds);
        this.userIdentityToken = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.userIdentityToken);
        this.userTokenSignature = new SignatureData(options.userTokenSignature);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        this.clientSignature.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.clientSoftwareCertificates, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.localeIds, stream, node_opcua_basic_types_1.encodeString);
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.userIdentityToken, stream);
        this.userTokenSignature.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.clientSignature.decode(stream);
        this.clientSoftwareCertificates = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new SignedSoftwareCertificate(null);
            obj.decode(stream1);
            return obj;
        });
        this.localeIds = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeString);
        this.userIdentityToken = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.userIdentityToken);
        this.userTokenSignature.decode(stream);
    }
    get schema() { return schemaActivateSessionRequest; }
}
exports.ActivateSessionRequest = ActivateSessionRequest;
ActivateSessionRequest.schema.dataTypeNodeId = ActivateSessionRequest.dataTypeNodeId;
ActivateSessionRequest.schema.encodingDefaultBinary = ActivateSessionRequest.encodingDefaultBinary;
ActivateSessionRequest.schema.encodingDefaultXml = ActivateSessionRequest.encodingDefaultXml;
ActivateSessionRequest.schema.encodingDefaultJson = ActivateSessionRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ActivateSessionRequest.dataTypeNodeId, "ActivateSessionRequest", ActivateSessionRequest);
// --------------------------------------------------------------------------------------------
const schemaResponseHeader = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ResponseHeader",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Timestamp",
            fieldType: "DateTime",
        },
        {
            name: "RequestHandle",
            fieldType: "UInt32",
        },
        {
            name: "ServiceResult",
            fieldType: "StatusCode",
        },
        {
            name: "ServiceDiagnostics",
            fieldType: "DiagnosticInfo",
        },
        {
            name: "StringTable",
            fieldType: "String",
            isArray: true
        },
        {
            name: "AdditionalHeader",
            fieldType: "ExtensionObject",
        },
    ]
});
class ResponseHeader extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaResponseHeader; }
    static possibleFields = [
        "timestamp",
        "requestHandle",
        "serviceResult",
        "serviceDiagnostics",
        "stringTable",
        "additionalHeader"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(392, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(394, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(393, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15089, 0);
    timestamp;
    requestHandle;
    serviceResult;
    serviceDiagnostics;
    stringTable;
    additionalHeader;
    constructor(options) {
        super(options);
        if (options === null) {
            this.timestamp = new Date();
            this.requestHandle = 0;
            this.serviceResult = node_opcua_status_code_1.StatusCodes.Good;
            this.serviceDiagnostics = null;
            this.stringTable = [];
            this.additionalHeader = null;
            return;
        }
        const schema = ResponseHeader.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.timestamp = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.timestamp);
        this.requestHandle = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.requestHandle);
        this.serviceResult = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.serviceResult);
        this.serviceDiagnostics = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.serviceDiagnostics);
        this.stringTable = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[4], options?.stringTable);
        this.additionalHeader = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.additionalHeader);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.timestamp, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.requestHandle, stream);
        (0, node_opcua_status_code_1.encodeStatusCode)(this.serviceResult, stream);
        (0, node_opcua_data_model_1.encodeDiagnosticInfo)(this.serviceDiagnostics, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.stringTable, stream, node_opcua_basic_types_1.encodeString);
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.additionalHeader, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.timestamp = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.timestamp);
        this.requestHandle = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.requestHandle);
        this.serviceResult = (0, node_opcua_status_code_1.decodeStatusCode)(stream, this.serviceResult);
        this.serviceDiagnostics = (0, node_opcua_data_model_1.decodeDiagnosticInfo)(stream, this.serviceDiagnostics);
        this.stringTable = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeString);
        this.additionalHeader = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.additionalHeader);
    }
    get schema() { return schemaResponseHeader; }
}
exports.ResponseHeader = ResponseHeader;
ResponseHeader.schema.dataTypeNodeId = ResponseHeader.dataTypeNodeId;
ResponseHeader.schema.encodingDefaultBinary = ResponseHeader.encodingDefaultBinary;
ResponseHeader.schema.encodingDefaultXml = ResponseHeader.encodingDefaultXml;
ResponseHeader.schema.encodingDefaultJson = ResponseHeader.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ResponseHeader.dataTypeNodeId, "ResponseHeader", ResponseHeader);
// --------------------------------------------------------------------------------------------
const schemaActivateSessionResponse = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ActivateSessionResponse",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",
            fieldType: "ResponseHeader",
        },
        {
            name: "ServerNonce",
            fieldType: "ByteString",
        },
        {
            name: "Results",
            fieldType: "StatusCode",
            isArray: true
        },
        {
            name: "DiagnosticInfos",
            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
class ActivateSessionResponse extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaActivateSessionResponse; }
    static possibleFields = [
        "responseHeader",
        "serverNonce",
        "results",
        "diagnosticInfos"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(468, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(470, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(469, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15146, 0);
    responseHeader;
    serverNonce;
    results;
    diagnosticInfos;
    constructor(options) {
        super(options);
        if (options === null) {
            this.responseHeader = new ResponseHeader(null);
            this.serverNonce = Buffer.alloc(0);
            this.results = [];
            this.diagnosticInfos = [];
            return;
        }
        const schema = ActivateSessionResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.responseHeader = new ResponseHeader(options.responseHeader);
        this.serverNonce = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.serverNonce);
        this.results = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.results);
        this.diagnosticInfos = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[3], options?.diagnosticInfos);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeByteString)(this.serverNonce, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.results, stream, node_opcua_status_code_1.encodeStatusCode);
        (0, node_opcua_basic_types_1.encodeArray)(this.diagnosticInfos, stream, node_opcua_data_model_1.encodeDiagnosticInfo);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.serverNonce = (0, node_opcua_basic_types_1.decodeByteString)(stream, this.serverNonce);
        this.results = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_status_code_1.decodeStatusCode);
        this.diagnosticInfos = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_data_model_1.decodeDiagnosticInfo);
    }
    get schema() { return schemaActivateSessionResponse; }
}
exports.ActivateSessionResponse = ActivateSessionResponse;
ActivateSessionResponse.schema.dataTypeNodeId = ActivateSessionResponse.dataTypeNodeId;
ActivateSessionResponse.schema.encodingDefaultBinary = ActivateSessionResponse.encodingDefaultBinary;
ActivateSessionResponse.schema.encodingDefaultXml = ActivateSessionResponse.encodingDefaultXml;
ActivateSessionResponse.schema.encodingDefaultJson = ActivateSessionResponse.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ActivateSessionResponse.dataTypeNodeId, "ActivateSessionResponse", ActivateSessionResponse);
// --------------------------------------------------------------------------------------------
var NodeClass;
(function (NodeClass) {
    NodeClass[NodeClass["Unspecified"] = 0] = "Unspecified";
    NodeClass[NodeClass["Object"] = 1] = "Object";
    NodeClass[NodeClass["Variable"] = 2] = "Variable";
    NodeClass[NodeClass["Method"] = 4] = "Method";
    NodeClass[NodeClass["ObjectType"] = 8] = "ObjectType";
    NodeClass[NodeClass["VariableType"] = 16] = "VariableType";
    NodeClass[NodeClass["ReferenceType"] = 32] = "ReferenceType";
    NodeClass[NodeClass["DataType"] = 64] = "DataType";
    NodeClass[NodeClass["View"] = 128] = "View";
})(NodeClass || (exports.NodeClass = NodeClass = {}));
const schemaNodeClass = {
    enumValues: NodeClass,
    flaggable: true,
    name: "NodeClass"
};
function decodeNodeClass(stream, _value) {
    return stream.readUInt32();
}
function encodeNodeClass(value, stream) {
    stream.writeUInt32(value);
}
exports._enumerationNodeClass = (0, node_opcua_factory_1.registerEnumeration)(schemaNodeClass);
(0, node_opcua_assert_1.assert)(exports._enumerationNodeClass.isFlaggable === true);
// --------------------------------------------------------------------------------------------
const schemaAddNodesItem = (0, node_opcua_factory_1.buildStructuredType)({
    name: "AddNodesItem",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ParentNodeId",
            fieldType: "ExpandedNodeId",
        },
        {
            name: "ReferenceTypeId",
            fieldType: "NodeId",
        },
        {
            name: "RequestedNewNodeId",
            fieldType: "ExpandedNodeId",
        },
        {
            name: "BrowseName",
            fieldType: "QualifiedName",
        },
        {
            name: "NodeClass",
            fieldType: "NodeClass",
        },
        {
            name: "NodeAttributes",
            fieldType: "ExtensionObject",
        },
        {
            name: "TypeDefinition",
            fieldType: "ExpandedNodeId",
        },
    ]
});
class AddNodesItem extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaAddNodesItem; }
    static possibleFields = [
        "parentNodeId",
        "referenceTypeId",
        "requestedNewNodeId",
        "browseName",
        "nodeClass",
        "nodeAttributes",
        "typeDefinition"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(376, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(378, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(377, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15165, 0);
    parentNodeId;
    referenceTypeId;
    requestedNewNodeId;
    browseName;
    nodeClass;
    nodeAttributes;
    typeDefinition;
    constructor(options) {
        super(options);
        if (options === null) {
            this.parentNodeId = new node_opcua_nodeid_1.ExpandedNodeId(null);
            this.referenceTypeId = new node_opcua_nodeid_1.NodeId(null);
            this.requestedNewNodeId = new node_opcua_nodeid_1.ExpandedNodeId(null);
            this.browseName = new node_opcua_data_model_1.QualifiedName(null);
            this.nodeClass = 0;
            this.nodeAttributes = null;
            this.typeDefinition = new node_opcua_nodeid_1.ExpandedNodeId(null);
            return;
        }
        const schema = AddNodesItem.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.parentNodeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.parentNodeId);
        this.referenceTypeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.referenceTypeId);
        this.requestedNewNodeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.requestedNewNodeId);
        this.browseName = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.browseName);
        this.nodeClass = this.setNodeClass((0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.nodeClass));
        this.nodeAttributes = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.nodeAttributes);
        this.typeDefinition = (0, node_opcua_factory_1.initialize_field)(schema.fields[6], options?.typeDefinition);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeExpandedNodeId)(this.parentNodeId, stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.referenceTypeId, stream);
        (0, node_opcua_basic_types_1.encodeExpandedNodeId)(this.requestedNewNodeId, stream);
        (0, node_opcua_data_model_1.encodeQualifiedName)(this.browseName, stream);
        encodeNodeClass(this.nodeClass, stream);
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.nodeAttributes, stream);
        (0, node_opcua_basic_types_1.encodeExpandedNodeId)(this.typeDefinition, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.parentNodeId = (0, node_opcua_basic_types_1.decodeExpandedNodeId)(stream, this.parentNodeId);
        this.referenceTypeId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.referenceTypeId);
        this.requestedNewNodeId = (0, node_opcua_basic_types_1.decodeExpandedNodeId)(stream, this.requestedNewNodeId);
        this.browseName = (0, node_opcua_data_model_1.decodeQualifiedName)(stream, this.browseName);
        this.nodeClass = decodeNodeClass(stream, this.nodeClass);
        this.nodeAttributes = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.nodeAttributes);
        this.typeDefinition = (0, node_opcua_basic_types_1.decodeExpandedNodeId)(stream, this.typeDefinition);
    }
    // Define Enumeration setters
    setNodeClass(value) {
        const coercedValue = exports._enumerationNodeClass.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to NodeClass :" + value);
        }
        this.nodeClass = coercedValue.value;
        return this.nodeClass;
    }
    get schema() { return schemaAddNodesItem; }
}
exports.AddNodesItem = AddNodesItem;
AddNodesItem.schema.dataTypeNodeId = AddNodesItem.dataTypeNodeId;
AddNodesItem.schema.encodingDefaultBinary = AddNodesItem.encodingDefaultBinary;
AddNodesItem.schema.encodingDefaultXml = AddNodesItem.encodingDefaultXml;
AddNodesItem.schema.encodingDefaultJson = AddNodesItem.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(AddNodesItem.dataTypeNodeId, "AddNodesItem", AddNodesItem);
// --------------------------------------------------------------------------------------------
const schemaAddNodesRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "AddNodesRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",
            fieldType: "RequestHeader",
        },
        {
            name: "NodesToAdd",
            fieldType: "AddNodesItem",
            isArray: true
        },
    ]
});
class AddNodesRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaAddNodesRequest; }
    static possibleFields = [
        "requestHeader",
        "nodesToAdd"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(486, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(488, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(487, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15167, 0);
    requestHeader;
    nodesToAdd;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestHeader = new RequestHeader(null);
            this.nodesToAdd = null; /* null array */
            return;
        }
        const schema = AddNodesRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestHeader = new RequestHeader(options.requestHeader);
        this.nodesToAdd = []; // should default
        if (options.nodesToAdd) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.nodesToAdd));
            this.nodesToAdd = options.nodesToAdd.map((e) => new AddNodesItem(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.nodesToAdd, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.nodesToAdd = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new AddNodesItem(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaAddNodesRequest; }
}
exports.AddNodesRequest = AddNodesRequest;
AddNodesRequest.schema.dataTypeNodeId = AddNodesRequest.dataTypeNodeId;
AddNodesRequest.schema.encodingDefaultBinary = AddNodesRequest.encodingDefaultBinary;
AddNodesRequest.schema.encodingDefaultXml = AddNodesRequest.encodingDefaultXml;
AddNodesRequest.schema.encodingDefaultJson = AddNodesRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(AddNodesRequest.dataTypeNodeId, "AddNodesRequest", AddNodesRequest);
// --------------------------------------------------------------------------------------------
const schemaAddNodesResult = (0, node_opcua_factory_1.buildStructuredType)({
    name: "AddNodesResult",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "StatusCode",
            fieldType: "StatusCode",
        },
        {
            name: "AddedNodeId",
            fieldType: "NodeId",
        },
    ]
});
class AddNodesResult extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaAddNodesResult; }
    static possibleFields = [
        "statusCode",
        "addedNodeId"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(483, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(485, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(484, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15166, 0);
    statusCode;
    addedNodeId;
    constructor(options) {
        super(options);
        if (options === null) {
            this.statusCode = node_opcua_status_code_1.StatusCodes.Good;
            this.addedNodeId = new node_opcua_nodeid_1.NodeId(null);
            return;
        }
        const schema = AddNodesResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.statusCode = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.statusCode);
        this.addedNodeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.addedNodeId);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_status_code_1.encodeStatusCode)(this.statusCode, stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.addedNodeId, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.statusCode = (0, node_opcua_status_code_1.decodeStatusCode)(stream, this.statusCode);
        this.addedNodeId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.addedNodeId);
    }
    get schema() { return schemaAddNodesResult; }
}
exports.AddNodesResult = AddNodesResult;
AddNodesResult.schema.dataTypeNodeId = AddNodesResult.dataTypeNodeId;
AddNodesResult.schema.encodingDefaultBinary = AddNodesResult.encodingDefaultBinary;
AddNodesResult.schema.encodingDefaultXml = AddNodesResult.encodingDefaultXml;
AddNodesResult.schema.encodingDefaultJson = AddNodesResult.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(AddNodesResult.dataTypeNodeId, "AddNodesResult", AddNodesResult);
// --------------------------------------------------------------------------------------------
const schemaAddNodesResponse = (0, node_opcua_factory_1.buildStructuredType)({
    name: "AddNodesResponse",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",
            fieldType: "ResponseHeader",
        },
        {
            name: "Results",
            fieldType: "AddNodesResult",
            isArray: true
        },
        {
            name: "DiagnosticInfos",
            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
class AddNodesResponse extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaAddNodesResponse; }
    static possibleFields = [
        "responseHeader",
        "results",
        "diagnosticInfos"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(489, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(491, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(490, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15168, 0);
    responseHeader;
    results;
    diagnosticInfos;
    constructor(options) {
        super(options);
        if (options === null) {
            this.responseHeader = new ResponseHeader(null);
            this.results = null; /* null array */
            this.diagnosticInfos = [];
            return;
        }
        const schema = AddNodesResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.responseHeader = new ResponseHeader(options.responseHeader);
        this.results = []; // should default
        if (options.results) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.results));
            this.results = options.results.map((e) => new AddNodesResult(e));
        }
        this.diagnosticInfos = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.diagnosticInfos);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.results, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.diagnosticInfos, stream, node_opcua_data_model_1.encodeDiagnosticInfo);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new AddNodesResult(null);
            obj.decode(stream1);
            return obj;
        });
        this.diagnosticInfos = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_data_model_1.decodeDiagnosticInfo);
    }
    get schema() { return schemaAddNodesResponse; }
}
exports.AddNodesResponse = AddNodesResponse;
AddNodesResponse.schema.dataTypeNodeId = AddNodesResponse.dataTypeNodeId;
AddNodesResponse.schema.encodingDefaultBinary = AddNodesResponse.encodingDefaultBinary;
AddNodesResponse.schema.encodingDefaultXml = AddNodesResponse.encodingDefaultXml;
AddNodesResponse.schema.encodingDefaultJson = AddNodesResponse.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(AddNodesResponse.dataTypeNodeId, "AddNodesResponse", AddNodesResponse);
// --------------------------------------------------------------------------------------------
const schemaAddReferencesItem = (0, node_opcua_factory_1.buildStructuredType)({
    name: "AddReferencesItem",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "SourceNodeId",
            fieldType: "NodeId",
        },
        {
            name: "ReferenceTypeId",
            fieldType: "NodeId",
        },
        {
            name: "IsForward",
            fieldType: "Boolean",
        },
        {
            name: "TargetServerUri",
            fieldType: "String",
        },
        {
            name: "TargetNodeId",
            fieldType: "ExpandedNodeId",
        },
        {
            name: "TargetNodeClass",
            fieldType: "NodeClass",
        },
    ]
});
class AddReferencesItem extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaAddReferencesItem; }
    static possibleFields = [
        "sourceNodeId",
        "referenceTypeId",
        "isForward",
        "targetServerUri",
        "targetNodeId",
        "targetNodeClass"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(379, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(381, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(380, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15169, 0);
    sourceNodeId;
    referenceTypeId;
    isForward;
    targetServerUri;
    targetNodeId;
    targetNodeClass;
    constructor(options) {
        super(options);
        if (options === null) {
            this.sourceNodeId = new node_opcua_nodeid_1.NodeId(null);
            this.referenceTypeId = new node_opcua_nodeid_1.NodeId(null);
            this.isForward = false;
            this.targetServerUri = null;
            this.targetNodeId = new node_opcua_nodeid_1.ExpandedNodeId(null);
            this.targetNodeClass = 0;
            return;
        }
        const schema = AddReferencesItem.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.sourceNodeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.sourceNodeId);
        this.referenceTypeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.referenceTypeId);
        this.isForward = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.isForward);
        this.targetServerUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.targetServerUri);
        this.targetNodeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.targetNodeId);
        this.targetNodeClass = this.setTargetNodeClass((0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.targetNodeClass));
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.sourceNodeId, stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.referenceTypeId, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.isForward, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.targetServerUri, stream);
        (0, node_opcua_basic_types_1.encodeExpandedNodeId)(this.targetNodeId, stream);
        encodeNodeClass(this.targetNodeClass, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.sourceNodeId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.sourceNodeId);
        this.referenceTypeId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.referenceTypeId);
        this.isForward = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.isForward);
        this.targetServerUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.targetServerUri);
        this.targetNodeId = (0, node_opcua_basic_types_1.decodeExpandedNodeId)(stream, this.targetNodeId);
        this.targetNodeClass = decodeNodeClass(stream, this.targetNodeClass);
    }
    // Define Enumeration setters
    setTargetNodeClass(value) {
        const coercedValue = exports._enumerationNodeClass.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to NodeClass :" + value);
        }
        this.targetNodeClass = coercedValue.value;
        return this.targetNodeClass;
    }
    get schema() { return schemaAddReferencesItem; }
}
exports.AddReferencesItem = AddReferencesItem;
AddReferencesItem.schema.dataTypeNodeId = AddReferencesItem.dataTypeNodeId;
AddReferencesItem.schema.encodingDefaultBinary = AddReferencesItem.encodingDefaultBinary;
AddReferencesItem.schema.encodingDefaultXml = AddReferencesItem.encodingDefaultXml;
AddReferencesItem.schema.encodingDefaultJson = AddReferencesItem.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(AddReferencesItem.dataTypeNodeId, "AddReferencesItem", AddReferencesItem);
// --------------------------------------------------------------------------------------------
const schemaAddReferencesRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "AddReferencesRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",
            fieldType: "RequestHeader",
        },
        {
            name: "ReferencesToAdd",
            fieldType: "AddReferencesItem",
            isArray: true
        },
    ]
});
class AddReferencesRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaAddReferencesRequest; }
    static possibleFields = [
        "requestHeader",
        "referencesToAdd"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(492, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(494, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(493, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15170, 0);
    requestHeader;
    referencesToAdd;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestHeader = new RequestHeader(null);
            this.referencesToAdd = null; /* null array */
            return;
        }
        const schema = AddReferencesRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestHeader = new RequestHeader(options.requestHeader);
        this.referencesToAdd = []; // should default
        if (options.referencesToAdd) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.referencesToAdd));
            this.referencesToAdd = options.referencesToAdd.map((e) => new AddReferencesItem(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.referencesToAdd, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.referencesToAdd = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new AddReferencesItem(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaAddReferencesRequest; }
}
exports.AddReferencesRequest = AddReferencesRequest;
AddReferencesRequest.schema.dataTypeNodeId = AddReferencesRequest.dataTypeNodeId;
AddReferencesRequest.schema.encodingDefaultBinary = AddReferencesRequest.encodingDefaultBinary;
AddReferencesRequest.schema.encodingDefaultXml = AddReferencesRequest.encodingDefaultXml;
AddReferencesRequest.schema.encodingDefaultJson = AddReferencesRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(AddReferencesRequest.dataTypeNodeId, "AddReferencesRequest", AddReferencesRequest);
// --------------------------------------------------------------------------------------------
const schemaAddReferencesResponse = (0, node_opcua_factory_1.buildStructuredType)({
    name: "AddReferencesResponse",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",
            fieldType: "ResponseHeader",
        },
        {
            name: "Results",
            fieldType: "StatusCode",
            isArray: true
        },
        {
            name: "DiagnosticInfos",
            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
class AddReferencesResponse extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaAddReferencesResponse; }
    static possibleFields = [
        "responseHeader",
        "results",
        "diagnosticInfos"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(495, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(497, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(496, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15171, 0);
    responseHeader;
    results;
    diagnosticInfos;
    constructor(options) {
        super(options);
        if (options === null) {
            this.responseHeader = new ResponseHeader(null);
            this.results = [];
            this.diagnosticInfos = [];
            return;
        }
        const schema = AddReferencesResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.responseHeader = new ResponseHeader(options.responseHeader);
        this.results = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.results);
        this.diagnosticInfos = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.diagnosticInfos);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.results, stream, node_opcua_status_code_1.encodeStatusCode);
        (0, node_opcua_basic_types_1.encodeArray)(this.diagnosticInfos, stream, node_opcua_data_model_1.encodeDiagnosticInfo);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_status_code_1.decodeStatusCode);
        this.diagnosticInfos = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_data_model_1.decodeDiagnosticInfo);
    }
    get schema() { return schemaAddReferencesResponse; }
}
exports.AddReferencesResponse = AddReferencesResponse;
AddReferencesResponse.schema.dataTypeNodeId = AddReferencesResponse.dataTypeNodeId;
AddReferencesResponse.schema.encodingDefaultBinary = AddReferencesResponse.encodingDefaultBinary;
AddReferencesResponse.schema.encodingDefaultXml = AddReferencesResponse.encodingDefaultXml;
AddReferencesResponse.schema.encodingDefaultJson = AddReferencesResponse.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(AddReferencesResponse.dataTypeNodeId, "AddReferencesResponse", AddReferencesResponse);
// --------------------------------------------------------------------------------------------
const schemaKeyValuePair = (0, node_opcua_factory_1.buildStructuredType)({
    name: "KeyValuePair",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Key",
            fieldType: "QualifiedName",
        },
        {
            name: "Value",
            fieldType: "Variant",
        },
    ]
});
class KeyValuePair extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaKeyValuePair; }
    static possibleFields = [
        "key",
        "value"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14533, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14846, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14802, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15041, 0);
    key;
    value;
    constructor(options) {
        super(options);
        if (options === null) {
            this.key = new node_opcua_data_model_1.QualifiedName(null);
            this.value = new node_opcua_variant_1.Variant(null);
            return;
        }
        const schema = KeyValuePair.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.key = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.key);
        this.value = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.value);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_data_model_1.encodeQualifiedName)(this.key, stream);
        (0, node_opcua_variant_1.encodeVariant)(this.value, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.key = (0, node_opcua_data_model_1.decodeQualifiedName)(stream, this.key);
        this.value = (0, node_opcua_variant_1.decodeVariant)(stream, this.value);
    }
    get schema() { return schemaKeyValuePair; }
}
exports.KeyValuePair = KeyValuePair;
KeyValuePair.schema.dataTypeNodeId = KeyValuePair.dataTypeNodeId;
KeyValuePair.schema.encodingDefaultBinary = KeyValuePair.encodingDefaultBinary;
KeyValuePair.schema.encodingDefaultXml = KeyValuePair.encodingDefaultXml;
KeyValuePair.schema.encodingDefaultJson = KeyValuePair.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(KeyValuePair.dataTypeNodeId, "KeyValuePair", KeyValuePair);
// --------------------------------------------------------------------------------------------
const schemaAdditionalParametersType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "AdditionalParametersType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Parameters",
            fieldType: "KeyValuePair",
            isArray: true
        },
    ]
});
class AdditionalParametersType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaAdditionalParametersType; }
    static possibleFields = [
        "parameters"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16313, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(17537, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(17541, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(17547, 0);
    parameters;
    constructor(options) {
        super(options);
        if (options === null) {
            this.parameters = null; /* null array */
            return;
        }
        const schema = AdditionalParametersType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.parameters = []; // should default
        if (options.parameters) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.parameters));
            this.parameters = options.parameters.map((e) => new KeyValuePair(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.parameters, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.parameters = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new KeyValuePair(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaAdditionalParametersType; }
}
exports.AdditionalParametersType = AdditionalParametersType;
AdditionalParametersType.schema.dataTypeNodeId = AdditionalParametersType.dataTypeNodeId;
AdditionalParametersType.schema.encodingDefaultBinary = AdditionalParametersType.encodingDefaultBinary;
AdditionalParametersType.schema.encodingDefaultXml = AdditionalParametersType.encodingDefaultXml;
AdditionalParametersType.schema.encodingDefaultJson = AdditionalParametersType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(AdditionalParametersType.dataTypeNodeId, "AdditionalParametersType", AdditionalParametersType);
// --------------------------------------------------------------------------------------------
const schemaAggregateConfiguration = (0, node_opcua_factory_1.buildStructuredType)({
    name: "AggregateConfiguration",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "UseServerCapabilitiesDefaults",
            fieldType: "Boolean",
        },
        {
            name: "TreatUncertainAsBad",
            fieldType: "Boolean",
        },
        {
            name: "PercentDataBad",
            fieldType: "Byte",
        },
        {
            name: "PercentDataGood",
            fieldType: "Byte",
        },
        {
            name: "UseSlopedExtrapolation",
            fieldType: "Boolean",
        },
    ]
});
class AggregateConfiguration extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaAggregateConfiguration; }
    static possibleFields = [
        "useServerCapabilitiesDefaults",
        "treatUncertainAsBad",
        "percentDataBad",
        "percentDataGood",
        "useSlopedExtrapolation"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(948, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(950, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(949, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15304, 0);
    useServerCapabilitiesDefaults;
    treatUncertainAsBad;
    percentDataBad;
    percentDataGood;
    useSlopedExtrapolation;
    constructor(options) {
        super(options);
        if (options === null) {
            this.useServerCapabilitiesDefaults = false;
            this.treatUncertainAsBad = false;
            this.percentDataBad = 0;
            this.percentDataGood = 0;
            this.useSlopedExtrapolation = false;
            return;
        }
        const schema = AggregateConfiguration.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.useServerCapabilitiesDefaults = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.useServerCapabilitiesDefaults);
        this.treatUncertainAsBad = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.treatUncertainAsBad);
        this.percentDataBad = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.percentDataBad);
        this.percentDataGood = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.percentDataGood);
        this.useSlopedExtrapolation = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.useSlopedExtrapolation);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.useServerCapabilitiesDefaults, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.treatUncertainAsBad, stream);
        (0, node_opcua_basic_types_1.encodeByte)(this.percentDataBad, stream);
        (0, node_opcua_basic_types_1.encodeByte)(this.percentDataGood, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.useSlopedExtrapolation, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.useServerCapabilitiesDefaults = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.useServerCapabilitiesDefaults);
        this.treatUncertainAsBad = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.treatUncertainAsBad);
        this.percentDataBad = (0, node_opcua_basic_types_1.decodeByte)(stream, this.percentDataBad);
        this.percentDataGood = (0, node_opcua_basic_types_1.decodeByte)(stream, this.percentDataGood);
        this.useSlopedExtrapolation = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.useSlopedExtrapolation);
    }
    get schema() { return schemaAggregateConfiguration; }
}
exports.AggregateConfiguration = AggregateConfiguration;
AggregateConfiguration.schema.dataTypeNodeId = AggregateConfiguration.dataTypeNodeId;
AggregateConfiguration.schema.encodingDefaultBinary = AggregateConfiguration.encodingDefaultBinary;
AggregateConfiguration.schema.encodingDefaultXml = AggregateConfiguration.encodingDefaultXml;
AggregateConfiguration.schema.encodingDefaultJson = AggregateConfiguration.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(AggregateConfiguration.dataTypeNodeId, "AggregateConfiguration", AggregateConfiguration);
// --------------------------------------------------------------------------------------------
const schemaMonitoringFilter = (0, node_opcua_factory_1.buildStructuredType)({
    name: "MonitoringFilter",
    baseType: "ExtensionObject",
    fields: []
});
class MonitoringFilter extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaMonitoringFilter; }
    static possibleFields = [];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(719, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(721, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(720, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15293, 0);
    constructor(options) {
        super(options);
        if (options === null) {
            return;
        }
        const schema = MonitoringFilter.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    get schema() { return schemaMonitoringFilter; }
}
exports.MonitoringFilter = MonitoringFilter;
MonitoringFilter.schema.dataTypeNodeId = MonitoringFilter.dataTypeNodeId;
MonitoringFilter.schema.encodingDefaultBinary = MonitoringFilter.encodingDefaultBinary;
MonitoringFilter.schema.encodingDefaultXml = MonitoringFilter.encodingDefaultXml;
MonitoringFilter.schema.encodingDefaultJson = MonitoringFilter.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(MonitoringFilter.dataTypeNodeId, "MonitoringFilter", MonitoringFilter);
// --------------------------------------------------------------------------------------------
const schemaAggregateFilter = (0, node_opcua_factory_1.buildStructuredType)({
    name: "AggregateFilter",
    baseType: "MonitoringFilter",
    fields: [
        {
            name: "StartTime",
            fieldType: "DateTime",
        },
        {
            name: "AggregateType",
            fieldType: "NodeId",
        },
        {
            name: "ProcessingInterval",
            fieldType: "Double",
        },
        {
            name: "AggregateConfiguration",
            fieldType: "AggregateConfiguration",
        },
    ]
});
class AggregateFilter extends MonitoringFilter {
    static get schema() { return schemaAggregateFilter; }
    static possibleFields = [
        "startTime",
        "aggregateType",
        "processingInterval",
        "aggregateConfiguration"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(728, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(730, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(729, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15312, 0);
    startTime;
    aggregateType;
    processingInterval;
    aggregateConfiguration;
    constructor(options) {
        super(options);
        if (options === null) {
            this.startTime = new Date();
            this.aggregateType = new node_opcua_nodeid_1.NodeId(null);
            this.processingInterval = 0;
            this.aggregateConfiguration = new AggregateConfiguration(null);
            return;
        }
        const schema = AggregateFilter.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.startTime = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.startTime);
        this.aggregateType = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.aggregateType);
        this.processingInterval = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.processingInterval);
        this.aggregateConfiguration = new AggregateConfiguration(options.aggregateConfiguration);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.startTime, stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.aggregateType, stream);
        (0, node_opcua_basic_types_1.encodeDouble)(this.processingInterval, stream);
        this.aggregateConfiguration.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.startTime = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.startTime);
        this.aggregateType = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.aggregateType);
        this.processingInterval = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.processingInterval);
        this.aggregateConfiguration.decode(stream);
    }
    get schema() { return schemaAggregateFilter; }
}
exports.AggregateFilter = AggregateFilter;
AggregateFilter.schema.dataTypeNodeId = AggregateFilter.dataTypeNodeId;
AggregateFilter.schema.encodingDefaultBinary = AggregateFilter.encodingDefaultBinary;
AggregateFilter.schema.encodingDefaultXml = AggregateFilter.encodingDefaultXml;
AggregateFilter.schema.encodingDefaultJson = AggregateFilter.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(AggregateFilter.dataTypeNodeId, "AggregateFilter", AggregateFilter);
// --------------------------------------------------------------------------------------------
const schemaMonitoringFilterResult = (0, node_opcua_factory_1.buildStructuredType)({
    name: "MonitoringFilterResult",
    baseType: "ExtensionObject",
    fields: []
});
class MonitoringFilterResult extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaMonitoringFilterResult; }
    static possibleFields = [];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(731, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(733, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(732, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15313, 0);
    constructor(options) {
        super(options);
        if (options === null) {
            return;
        }
        const schema = MonitoringFilterResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    get schema() { return schemaMonitoringFilterResult; }
}
exports.MonitoringFilterResult = MonitoringFilterResult;
MonitoringFilterResult.schema.dataTypeNodeId = MonitoringFilterResult.dataTypeNodeId;
MonitoringFilterResult.schema.encodingDefaultBinary = MonitoringFilterResult.encodingDefaultBinary;
MonitoringFilterResult.schema.encodingDefaultXml = MonitoringFilterResult.encodingDefaultXml;
MonitoringFilterResult.schema.encodingDefaultJson = MonitoringFilterResult.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(MonitoringFilterResult.dataTypeNodeId, "MonitoringFilterResult", MonitoringFilterResult);
// --------------------------------------------------------------------------------------------
const schemaAggregateFilterResult = (0, node_opcua_factory_1.buildStructuredType)({
    name: "AggregateFilterResult",
    baseType: "MonitoringFilterResult",
    fields: [
        {
            name: "RevisedStartTime",
            fieldType: "DateTime",
        },
        {
            name: "RevisedProcessingInterval",
            fieldType: "Double",
        },
        {
            name: "RevisedAggregateConfiguration",
            fieldType: "AggregateConfiguration",
        },
    ]
});
class AggregateFilterResult extends MonitoringFilterResult {
    static get schema() { return schemaAggregateFilterResult; }
    static possibleFields = [
        "revisedStartTime",
        "revisedProcessingInterval",
        "revisedAggregateConfiguration"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(737, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(739, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(738, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15315, 0);
    revisedStartTime;
    revisedProcessingInterval;
    revisedAggregateConfiguration;
    constructor(options) {
        super(options);
        if (options === null) {
            this.revisedStartTime = new Date();
            this.revisedProcessingInterval = 0;
            this.revisedAggregateConfiguration = new AggregateConfiguration(null);
            return;
        }
        const schema = AggregateFilterResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.revisedStartTime = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.revisedStartTime);
        this.revisedProcessingInterval = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.revisedProcessingInterval);
        this.revisedAggregateConfiguration = new AggregateConfiguration(options.revisedAggregateConfiguration);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.revisedStartTime, stream);
        (0, node_opcua_basic_types_1.encodeDouble)(this.revisedProcessingInterval, stream);
        this.revisedAggregateConfiguration.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.revisedStartTime = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.revisedStartTime);
        this.revisedProcessingInterval = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.revisedProcessingInterval);
        this.revisedAggregateConfiguration.decode(stream);
    }
    get schema() { return schemaAggregateFilterResult; }
}
exports.AggregateFilterResult = AggregateFilterResult;
AggregateFilterResult.schema.dataTypeNodeId = AggregateFilterResult.dataTypeNodeId;
AggregateFilterResult.schema.encodingDefaultBinary = AggregateFilterResult.encodingDefaultBinary;
AggregateFilterResult.schema.encodingDefaultXml = AggregateFilterResult.encodingDefaultXml;
AggregateFilterResult.schema.encodingDefaultJson = AggregateFilterResult.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(AggregateFilterResult.dataTypeNodeId, "AggregateFilterResult", AggregateFilterResult);
// --------------------------------------------------------------------------------------------
const schemaAliasNameDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "AliasNameDataType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "AliasName",
            fieldType: "QualifiedName",
        },
        {
            name: "ReferencedNodes",
            fieldType: "ExpandedNodeId",
            isArray: true
        },
    ]
});
class AliasNameDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaAliasNameDataType; }
    static possibleFields = [
        "aliasName",
        "referencedNodes"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23468, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23499, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23505, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23511, 0);
    aliasName;
    referencedNodes;
    constructor(options) {
        super(options);
        if (options === null) {
            this.aliasName = new node_opcua_data_model_1.QualifiedName(null);
            this.referencedNodes = [];
            return;
        }
        const schema = AliasNameDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.aliasName = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.aliasName);
        this.referencedNodes = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.referencedNodes);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_data_model_1.encodeQualifiedName)(this.aliasName, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.referencedNodes, stream, node_opcua_basic_types_1.encodeExpandedNodeId);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.aliasName = (0, node_opcua_data_model_1.decodeQualifiedName)(stream, this.aliasName);
        this.referencedNodes = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeExpandedNodeId);
    }
    get schema() { return schemaAliasNameDataType; }
}
exports.AliasNameDataType = AliasNameDataType;
AliasNameDataType.schema.dataTypeNodeId = AliasNameDataType.dataTypeNodeId;
AliasNameDataType.schema.encodingDefaultBinary = AliasNameDataType.encodingDefaultBinary;
AliasNameDataType.schema.encodingDefaultXml = AliasNameDataType.encodingDefaultXml;
AliasNameDataType.schema.encodingDefaultJson = AliasNameDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(AliasNameDataType.dataTypeNodeId, "AliasNameDataType", AliasNameDataType);
// --------------------------------------------------------------------------------------------
const schemaAnnotation = (0, node_opcua_factory_1.buildStructuredType)({
    name: "Annotation",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Message",
            fieldType: "String",
        },
        {
            name: "UserName",
            fieldType: "String",
        },
        {
            name: "AnnotationTime",
            fieldType: "DateTime",
        },
    ]
});
class Annotation extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaAnnotation; }
    static possibleFields = [
        "message",
        "userName",
        "annotationTime"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(891, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(893, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(892, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15382, 0);
    message;
    userName;
    annotationTime;
    constructor(options) {
        super(options);
        if (options === null) {
            this.message = null;
            this.userName = null;
            this.annotationTime = new Date();
            return;
        }
        const schema = Annotation.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.message = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.message);
        this.userName = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.userName);
        this.annotationTime = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.annotationTime);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.message, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.userName, stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.annotationTime, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.message = (0, node_opcua_basic_types_1.decodeString)(stream, this.message);
        this.userName = (0, node_opcua_basic_types_1.decodeString)(stream, this.userName);
        this.annotationTime = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.annotationTime);
    }
    get schema() { return schemaAnnotation; }
}
exports.Annotation = Annotation;
Annotation.schema.dataTypeNodeId = Annotation.dataTypeNodeId;
Annotation.schema.encodingDefaultBinary = Annotation.encodingDefaultBinary;
Annotation.schema.encodingDefaultXml = Annotation.encodingDefaultXml;
Annotation.schema.encodingDefaultJson = Annotation.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(Annotation.dataTypeNodeId, "Annotation", Annotation);
// --------------------------------------------------------------------------------------------
const schemaAnnotationDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "AnnotationDataType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Annotation",
            fieldType: "String",
        },
        {
            name: "Discipline",
            fieldType: "String",
        },
        {
            name: "Uri",
            fieldType: "String",
        },
    ]
});
class AnnotationDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaAnnotationDataType; }
    static possibleFields = [
        "annotation",
        "discipline",
        "uri"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(32434, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(32560, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(32572, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(32584, 0);
    annotation;
    discipline;
    uri;
    constructor(options) {
        super(options);
        if (options === null) {
            this.annotation = null;
            this.discipline = null;
            this.uri = null;
            return;
        }
        const schema = AnnotationDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.annotation = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.annotation);
        this.discipline = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.discipline);
        this.uri = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.uri);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.annotation, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.discipline, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.uri, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.annotation = (0, node_opcua_basic_types_1.decodeString)(stream, this.annotation);
        this.discipline = (0, node_opcua_basic_types_1.decodeString)(stream, this.discipline);
        this.uri = (0, node_opcua_basic_types_1.decodeString)(stream, this.uri);
    }
    get schema() { return schemaAnnotationDataType; }
}
exports.AnnotationDataType = AnnotationDataType;
AnnotationDataType.schema.dataTypeNodeId = AnnotationDataType.dataTypeNodeId;
AnnotationDataType.schema.encodingDefaultBinary = AnnotationDataType.encodingDefaultBinary;
AnnotationDataType.schema.encodingDefaultXml = AnnotationDataType.encodingDefaultXml;
AnnotationDataType.schema.encodingDefaultJson = AnnotationDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(AnnotationDataType.dataTypeNodeId, "AnnotationDataType", AnnotationDataType);
// --------------------------------------------------------------------------------------------
const schemaUserIdentityToken = (0, node_opcua_factory_1.buildStructuredType)({
    name: "UserIdentityToken",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "PolicyId",
            fieldType: "String",
        },
    ]
});
class UserIdentityToken extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaUserIdentityToken; }
    static possibleFields = [
        "policyId"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(316, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(318, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(317, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15140, 0);
    policyId;
    constructor(options) {
        super(options);
        if (options === null) {
            this.policyId = null;
            return;
        }
        const schema = UserIdentityToken.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.policyId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.policyId);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.policyId, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.policyId = (0, node_opcua_basic_types_1.decodeString)(stream, this.policyId);
    }
    get schema() { return schemaUserIdentityToken; }
}
exports.UserIdentityToken = UserIdentityToken;
UserIdentityToken.schema.dataTypeNodeId = UserIdentityToken.dataTypeNodeId;
UserIdentityToken.schema.encodingDefaultBinary = UserIdentityToken.encodingDefaultBinary;
UserIdentityToken.schema.encodingDefaultXml = UserIdentityToken.encodingDefaultXml;
UserIdentityToken.schema.encodingDefaultJson = UserIdentityToken.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(UserIdentityToken.dataTypeNodeId, "UserIdentityToken", UserIdentityToken);
// --------------------------------------------------------------------------------------------
const schemaAnonymousIdentityToken = (0, node_opcua_factory_1.buildStructuredType)({
    name: "AnonymousIdentityToken",
    baseType: "UserIdentityToken",
    fields: []
});
class AnonymousIdentityToken extends UserIdentityToken {
    static get schema() { return schemaAnonymousIdentityToken; }
    static possibleFields = [
        "policyId"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(319, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(321, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(320, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15141, 0);
    constructor(options) {
        super(options);
        if (options === null) {
            return;
        }
        const schema = AnonymousIdentityToken.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    get schema() { return schemaAnonymousIdentityToken; }
}
exports.AnonymousIdentityToken = AnonymousIdentityToken;
AnonymousIdentityToken.schema.dataTypeNodeId = AnonymousIdentityToken.dataTypeNodeId;
AnonymousIdentityToken.schema.encodingDefaultBinary = AnonymousIdentityToken.encodingDefaultBinary;
AnonymousIdentityToken.schema.encodingDefaultXml = AnonymousIdentityToken.encodingDefaultXml;
AnonymousIdentityToken.schema.encodingDefaultJson = AnonymousIdentityToken.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(AnonymousIdentityToken.dataTypeNodeId, "AnonymousIdentityToken", AnonymousIdentityToken);
// --------------------------------------------------------------------------------------------
var ApplicationType;
(function (ApplicationType) {
    ApplicationType[ApplicationType["Server"] = 0] = "Server";
    ApplicationType[ApplicationType["Client"] = 1] = "Client";
    ApplicationType[ApplicationType["ClientAndServer"] = 2] = "ClientAndServer";
    ApplicationType[ApplicationType["DiscoveryServer"] = 3] = "DiscoveryServer";
    ApplicationType[ApplicationType["Invalid"] = 4294967295] = "Invalid";
})(ApplicationType || (exports.ApplicationType = ApplicationType = {}));
const schemaApplicationType = {
    enumValues: ApplicationType,
    flaggable: false,
    minValue: 0,
    maxValue: 3,
    name: "ApplicationType"
};
function decodeApplicationType(stream, _value) {
    let value = stream.readUInt32();
    value = (value < schemaApplicationType.minValue || value > schemaApplicationType.maxValue) ? ApplicationType.Invalid : value;
    return value;
}
function encodeApplicationType(value, stream) {
    stream.writeUInt32(value);
}
exports._enumerationApplicationType = (0, node_opcua_factory_1.registerEnumeration)(schemaApplicationType);
(0, node_opcua_assert_1.assert)(exports._enumerationApplicationType.isFlaggable === false);
// --------------------------------------------------------------------------------------------
const schemaApplicationDescription = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ApplicationDescription",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ApplicationUri",
            fieldType: "String",
        },
        {
            name: "ProductUri",
            fieldType: "String",
        },
        {
            name: "ApplicationName",
            fieldType: "LocalizedText",
        },
        {
            name: "ApplicationType",
            fieldType: "ApplicationType",
        },
        {
            name: "GatewayServerUri",
            fieldType: "String",
        },
        {
            name: "DiscoveryProfileUri",
            fieldType: "String",
        },
        {
            name: "DiscoveryUrls",
            fieldType: "String",
            isArray: true
        },
    ]
});
class ApplicationDescription extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaApplicationDescription; }
    static possibleFields = [
        "applicationUri",
        "productUri",
        "applicationName",
        "applicationType",
        "gatewayServerUri",
        "discoveryProfileUri",
        "discoveryUrls"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(308, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(310, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(309, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15087, 0);
    applicationUri;
    productUri;
    applicationName;
    applicationType;
    gatewayServerUri;
    discoveryProfileUri;
    discoveryUrls;
    constructor(options) {
        super(options);
        if (options === null) {
            this.applicationUri = null;
            this.productUri = null;
            this.applicationName = new node_opcua_data_model_1.LocalizedText(null);
            this.applicationType = 0;
            this.gatewayServerUri = null;
            this.discoveryProfileUri = null;
            this.discoveryUrls = [];
            return;
        }
        const schema = ApplicationDescription.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.applicationUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.applicationUri);
        this.productUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.productUri);
        this.applicationName = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.applicationName);
        this.applicationType = this.setApplicationType((0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.applicationType));
        this.gatewayServerUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.gatewayServerUri);
        this.discoveryProfileUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.discoveryProfileUri);
        this.discoveryUrls = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[6], options?.discoveryUrls);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.applicationUri, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.productUri, stream);
        (0, node_opcua_data_model_1.encodeLocalizedText)(this.applicationName, stream);
        encodeApplicationType(this.applicationType, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.gatewayServerUri, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.discoveryProfileUri, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.discoveryUrls, stream, node_opcua_basic_types_1.encodeString);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.applicationUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.applicationUri);
        this.productUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.productUri);
        this.applicationName = (0, node_opcua_data_model_1.decodeLocalizedText)(stream, this.applicationName);
        this.applicationType = decodeApplicationType(stream, this.applicationType);
        this.gatewayServerUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.gatewayServerUri);
        this.discoveryProfileUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.discoveryProfileUri);
        this.discoveryUrls = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeString);
    }
    // Define Enumeration setters
    setApplicationType(value) {
        const coercedValue = exports._enumerationApplicationType.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to ApplicationType :" + value);
        }
        this.applicationType = coercedValue.value;
        return this.applicationType;
    }
    get schema() { return schemaApplicationDescription; }
}
exports.ApplicationDescription = ApplicationDescription;
ApplicationDescription.schema.dataTypeNodeId = ApplicationDescription.dataTypeNodeId;
ApplicationDescription.schema.encodingDefaultBinary = ApplicationDescription.encodingDefaultBinary;
ApplicationDescription.schema.encodingDefaultXml = ApplicationDescription.encodingDefaultXml;
ApplicationDescription.schema.encodingDefaultJson = ApplicationDescription.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ApplicationDescription.dataTypeNodeId, "ApplicationDescription", ApplicationDescription);
// --------------------------------------------------------------------------------------------
const schemaArgument = (0, node_opcua_factory_1.buildStructuredType)({
    name: "Argument",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Name",
            fieldType: "String",
        },
        {
            name: "DataType",
            fieldType: "NodeId",
        },
        {
            name: "ValueRank",
            fieldType: "Int32",
        },
        {
            name: "ArrayDimensions",
            fieldType: "UInt32",
            isArray: true
        },
        {
            name: "Description",
            fieldType: "LocalizedText",
        },
    ]
});
class Argument extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaArgument; }
    static possibleFields = [
        "name",
        "dataType",
        "valueRank",
        "arrayDimensions",
        "description"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(296, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(298, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(297, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15081, 0);
    name;
    dataType;
    valueRank;
    arrayDimensions;
    description;
    constructor(options) {
        super(options);
        if (options === null) {
            this.name = null;
            this.dataType = new node_opcua_nodeid_1.NodeId(null);
            this.valueRank = 0;
            this.arrayDimensions = [];
            this.description = new node_opcua_data_model_1.LocalizedText(null);
            return;
        }
        const schema = Argument.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.name = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.name);
        this.dataType = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.dataType);
        this.valueRank = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.valueRank);
        this.arrayDimensions = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[3], options?.arrayDimensions);
        this.description = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.description);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.name, stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.dataType, stream);
        (0, node_opcua_basic_types_1.encodeInt32)(this.valueRank, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.arrayDimensions, stream, node_opcua_basic_types_1.encodeUInt32);
        (0, node_opcua_data_model_1.encodeLocalizedText)(this.description, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = (0, node_opcua_basic_types_1.decodeString)(stream, this.name);
        this.dataType = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.dataType);
        this.valueRank = (0, node_opcua_basic_types_1.decodeInt32)(stream, this.valueRank);
        this.arrayDimensions = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeUInt32);
        this.description = (0, node_opcua_data_model_1.decodeLocalizedText)(stream, this.description);
    }
    get schema() { return schemaArgument; }
}
exports.Argument = Argument;
Argument.schema.dataTypeNodeId = Argument.dataTypeNodeId;
Argument.schema.encodingDefaultBinary = Argument.encodingDefaultBinary;
Argument.schema.encodingDefaultXml = Argument.encodingDefaultXml;
Argument.schema.encodingDefaultJson = Argument.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(Argument.dataTypeNodeId, "Argument", Argument);
// --------------------------------------------------------------------------------------------
const schemaRelativePathElement = (0, node_opcua_factory_1.buildStructuredType)({
    name: "RelativePathElement",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ReferenceTypeId",
            fieldType: "NodeId",
        },
        {
            name: "IsInverse",
            fieldType: "Boolean",
        },
        {
            name: "IncludeSubtypes",
            fieldType: "Boolean",
        },
        {
            name: "TargetName",
            fieldType: "QualifiedName",
        },
    ]
});
class RelativePathElement extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaRelativePathElement; }
    static possibleFields = [
        "referenceTypeId",
        "isInverse",
        "includeSubtypes",
        "targetName"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(537, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(539, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(538, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15188, 0);
    referenceTypeId;
    isInverse;
    includeSubtypes;
    targetName;
    constructor(options) {
        super(options);
        if (options === null) {
            this.referenceTypeId = new node_opcua_nodeid_1.NodeId(null);
            this.isInverse = false;
            this.includeSubtypes = false;
            this.targetName = new node_opcua_data_model_1.QualifiedName(null);
            return;
        }
        const schema = RelativePathElement.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.referenceTypeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.referenceTypeId);
        this.isInverse = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.isInverse);
        this.includeSubtypes = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.includeSubtypes);
        this.targetName = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.targetName);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.referenceTypeId, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.isInverse, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.includeSubtypes, stream);
        (0, node_opcua_data_model_1.encodeQualifiedName)(this.targetName, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.referenceTypeId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.referenceTypeId);
        this.isInverse = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.isInverse);
        this.includeSubtypes = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.includeSubtypes);
        this.targetName = (0, node_opcua_data_model_1.decodeQualifiedName)(stream, this.targetName);
    }
    get schema() { return schemaRelativePathElement; }
}
exports.RelativePathElement = RelativePathElement;
RelativePathElement.schema.dataTypeNodeId = RelativePathElement.dataTypeNodeId;
RelativePathElement.schema.encodingDefaultBinary = RelativePathElement.encodingDefaultBinary;
RelativePathElement.schema.encodingDefaultXml = RelativePathElement.encodingDefaultXml;
RelativePathElement.schema.encodingDefaultJson = RelativePathElement.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(RelativePathElement.dataTypeNodeId, "RelativePathElement", RelativePathElement);
// --------------------------------------------------------------------------------------------
const schemaRelativePath = (0, node_opcua_factory_1.buildStructuredType)({
    name: "RelativePath",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Elements",
            fieldType: "RelativePathElement",
            isArray: true
        },
    ]
});
class RelativePath extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaRelativePath; }
    static possibleFields = [
        "elements"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(540, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(542, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(541, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15189, 0);
    elements;
    constructor(options) {
        super(options);
        if (options === null) {
            this.elements = null; /* null array */
            return;
        }
        const schema = RelativePath.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.elements = []; // should default
        if (options.elements) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.elements));
            this.elements = options.elements.map((e) => new RelativePathElement(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.elements, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.elements = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new RelativePathElement(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaRelativePath; }
}
exports.RelativePath = RelativePath;
RelativePath.schema.dataTypeNodeId = RelativePath.dataTypeNodeId;
RelativePath.schema.encodingDefaultBinary = RelativePath.encodingDefaultBinary;
RelativePath.schema.encodingDefaultXml = RelativePath.encodingDefaultXml;
RelativePath.schema.encodingDefaultJson = RelativePath.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(RelativePath.dataTypeNodeId, "RelativePath", RelativePath);
// --------------------------------------------------------------------------------------------
const schemaAttributeOperand = (0, node_opcua_factory_1.buildStructuredType)({
    name: "AttributeOperand",
    baseType: "FilterOperand",
    fields: [
        {
            name: "NodeId",
            fieldType: "NodeId",
        },
        {
            name: "Alias",
            fieldType: "String",
        },
        {
            name: "BrowsePath",
            fieldType: "RelativePath",
        },
        {
            name: "AttributeId",
            fieldType: "UInt32",
        },
        {
            name: "IndexRange",
            fieldType: "NumericRange",
        },
    ]
});
class AttributeOperand extends FilterOperand {
    static get schema() { return schemaAttributeOperand; }
    static possibleFields = [
        "nodeId",
        "alias",
        "browsePath",
        "attributeId",
        "indexRange"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(598, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(600, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(599, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15209, 0);
    nodeId;
    alias;
    browsePath;
    attributeId;
    indexRange;
    constructor(options) {
        super(options);
        if (options === null) {
            this.nodeId = new node_opcua_nodeid_1.NodeId(null);
            this.alias = null;
            this.browsePath = new RelativePath(null);
            this.attributeId = 0;
            this.indexRange = new node_opcua_numeric_range_1.NumericRange(null);
            return;
        }
        const schema = AttributeOperand.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.nodeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.nodeId);
        this.alias = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.alias);
        this.browsePath = new RelativePath(options.browsePath);
        this.attributeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.attributeId);
        this.indexRange = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.indexRange);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.nodeId, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.alias, stream);
        this.browsePath.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.attributeId, stream);
        (0, node_opcua_numeric_range_1.encodeNumericRange)(this.indexRange, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.nodeId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.nodeId);
        this.alias = (0, node_opcua_basic_types_1.decodeString)(stream, this.alias);
        this.browsePath.decode(stream);
        this.attributeId = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.attributeId);
        this.indexRange = (0, node_opcua_numeric_range_1.decodeNumericRange)(stream, this.indexRange);
    }
    get schema() { return schemaAttributeOperand; }
}
exports.AttributeOperand = AttributeOperand;
AttributeOperand.schema.dataTypeNodeId = AttributeOperand.dataTypeNodeId;
AttributeOperand.schema.encodingDefaultBinary = AttributeOperand.encodingDefaultBinary;
AttributeOperand.schema.encodingDefaultXml = AttributeOperand.encodingDefaultXml;
AttributeOperand.schema.encodingDefaultJson = AttributeOperand.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(AttributeOperand.dataTypeNodeId, "AttributeOperand", AttributeOperand);
// --------------------------------------------------------------------------------------------
const schemaBitFieldDefinition = (0, node_opcua_factory_1.buildStructuredType)({
    name: "BitFieldDefinition",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Name",
            fieldType: "String",
        },
        {
            name: "Description",
            fieldType: "LocalizedText",
        },
        {
            name: "Reserved",
            fieldType: "Boolean",
        },
        {
            name: "StartingBitPosition",
            fieldType: "UInt32",
        },
        {
            name: "EndingBitPosition",
            fieldType: "UInt32",
        },
    ]
});
class BitFieldDefinition extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaBitFieldDefinition; }
    static possibleFields = [
        "name",
        "description",
        "reserved",
        "startingBitPosition",
        "endingBitPosition"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(32421, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(32422, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(32426, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(32430, 0);
    name;
    description;
    reserved;
    startingBitPosition;
    endingBitPosition;
    constructor(options) {
        super(options);
        if (options === null) {
            this.name = null;
            this.description = new node_opcua_data_model_1.LocalizedText(null);
            this.reserved = false;
            this.startingBitPosition = 0;
            this.endingBitPosition = 0;
            return;
        }
        const schema = BitFieldDefinition.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.name = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.name);
        this.description = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.description);
        this.reserved = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.reserved);
        this.startingBitPosition = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.startingBitPosition);
        this.endingBitPosition = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.endingBitPosition);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.name, stream);
        (0, node_opcua_data_model_1.encodeLocalizedText)(this.description, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.reserved, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.startingBitPosition, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.endingBitPosition, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = (0, node_opcua_basic_types_1.decodeString)(stream, this.name);
        this.description = (0, node_opcua_data_model_1.decodeLocalizedText)(stream, this.description);
        this.reserved = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.reserved);
        this.startingBitPosition = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.startingBitPosition);
        this.endingBitPosition = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.endingBitPosition);
    }
    get schema() { return schemaBitFieldDefinition; }
}
exports.BitFieldDefinition = BitFieldDefinition;
BitFieldDefinition.schema.dataTypeNodeId = BitFieldDefinition.dataTypeNodeId;
BitFieldDefinition.schema.encodingDefaultBinary = BitFieldDefinition.encodingDefaultBinary;
BitFieldDefinition.schema.encodingDefaultXml = BitFieldDefinition.encodingDefaultXml;
BitFieldDefinition.schema.encodingDefaultJson = BitFieldDefinition.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(BitFieldDefinition.dataTypeNodeId, "BitFieldDefinition", BitFieldDefinition);
// --------------------------------------------------------------------------------------------
const schemaConnectionTransportDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ConnectionTransportDataType",
    baseType: "ExtensionObject",
    fields: []
});
class ConnectionTransportDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaConnectionTransportDataType; }
    static possibleFields = [];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15618, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15695, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15993, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16282, 0);
    constructor(options) {
        super(options);
        if (options === null) {
            return;
        }
        const schema = ConnectionTransportDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    get schema() { return schemaConnectionTransportDataType; }
}
exports.ConnectionTransportDataType = ConnectionTransportDataType;
ConnectionTransportDataType.schema.dataTypeNodeId = ConnectionTransportDataType.dataTypeNodeId;
ConnectionTransportDataType.schema.encodingDefaultBinary = ConnectionTransportDataType.encodingDefaultBinary;
ConnectionTransportDataType.schema.encodingDefaultXml = ConnectionTransportDataType.encodingDefaultXml;
ConnectionTransportDataType.schema.encodingDefaultJson = ConnectionTransportDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ConnectionTransportDataType.dataTypeNodeId, "ConnectionTransportDataType", ConnectionTransportDataType);
// --------------------------------------------------------------------------------------------
const schemaBrokerConnectionTransportDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "BrokerConnectionTransportDataType",
    baseType: "ConnectionTransportDataType",
    fields: [
        {
            name: "ResourceUri",
            fieldType: "String",
        },
        {
            name: "AuthenticationProfileUri",
            fieldType: "String",
        },
    ]
});
class BrokerConnectionTransportDataType extends ConnectionTransportDataType {
    static get schema() { return schemaBrokerConnectionTransportDataType; }
    static possibleFields = [
        "resourceUri",
        "authenticationProfileUri"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15007, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15479, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15579, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15726, 0);
    resourceUri;
    authenticationProfileUri;
    constructor(options) {
        super(options);
        if (options === null) {
            this.resourceUri = null;
            this.authenticationProfileUri = null;
            return;
        }
        const schema = BrokerConnectionTransportDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.resourceUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.resourceUri);
        this.authenticationProfileUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.authenticationProfileUri);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.resourceUri, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.authenticationProfileUri, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.resourceUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.resourceUri);
        this.authenticationProfileUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.authenticationProfileUri);
    }
    get schema() { return schemaBrokerConnectionTransportDataType; }
}
exports.BrokerConnectionTransportDataType = BrokerConnectionTransportDataType;
BrokerConnectionTransportDataType.schema.dataTypeNodeId = BrokerConnectionTransportDataType.dataTypeNodeId;
BrokerConnectionTransportDataType.schema.encodingDefaultBinary = BrokerConnectionTransportDataType.encodingDefaultBinary;
BrokerConnectionTransportDataType.schema.encodingDefaultXml = BrokerConnectionTransportDataType.encodingDefaultXml;
BrokerConnectionTransportDataType.schema.encodingDefaultJson = BrokerConnectionTransportDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(BrokerConnectionTransportDataType.dataTypeNodeId, "BrokerConnectionTransportDataType", BrokerConnectionTransportDataType);
// --------------------------------------------------------------------------------------------
const schemaDataSetReaderTransportDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DataSetReaderTransportDataType",
    baseType: "ExtensionObject",
    fields: []
});
class DataSetReaderTransportDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaDataSetReaderTransportDataType; }
    static possibleFields = [];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15628, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15705, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16008, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16287, 0);
    constructor(options) {
        super(options);
        if (options === null) {
            return;
        }
        const schema = DataSetReaderTransportDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    get schema() { return schemaDataSetReaderTransportDataType; }
}
exports.DataSetReaderTransportDataType = DataSetReaderTransportDataType;
DataSetReaderTransportDataType.schema.dataTypeNodeId = DataSetReaderTransportDataType.dataTypeNodeId;
DataSetReaderTransportDataType.schema.encodingDefaultBinary = DataSetReaderTransportDataType.encodingDefaultBinary;
DataSetReaderTransportDataType.schema.encodingDefaultXml = DataSetReaderTransportDataType.encodingDefaultXml;
DataSetReaderTransportDataType.schema.encodingDefaultJson = DataSetReaderTransportDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DataSetReaderTransportDataType.dataTypeNodeId, "DataSetReaderTransportDataType", DataSetReaderTransportDataType);
// --------------------------------------------------------------------------------------------
var BrokerTransportQualityOfService;
(function (BrokerTransportQualityOfService) {
    BrokerTransportQualityOfService[BrokerTransportQualityOfService["NotSpecified"] = 0] = "NotSpecified";
    BrokerTransportQualityOfService[BrokerTransportQualityOfService["BestEffort"] = 1] = "BestEffort";
    BrokerTransportQualityOfService[BrokerTransportQualityOfService["AtLeastOnce"] = 2] = "AtLeastOnce";
    BrokerTransportQualityOfService[BrokerTransportQualityOfService["AtMostOnce"] = 3] = "AtMostOnce";
    BrokerTransportQualityOfService[BrokerTransportQualityOfService["ExactlyOnce"] = 4] = "ExactlyOnce";
    BrokerTransportQualityOfService[BrokerTransportQualityOfService["Invalid"] = 4294967295] = "Invalid";
})(BrokerTransportQualityOfService || (exports.BrokerTransportQualityOfService = BrokerTransportQualityOfService = {}));
const schemaBrokerTransportQualityOfService = {
    enumValues: BrokerTransportQualityOfService,
    flaggable: false,
    minValue: 0,
    maxValue: 4,
    name: "BrokerTransportQualityOfService"
};
function decodeBrokerTransportQualityOfService(stream, _value) {
    let value = stream.readUInt32();
    value = (value < schemaBrokerTransportQualityOfService.minValue || value > schemaBrokerTransportQualityOfService.maxValue) ? BrokerTransportQualityOfService.Invalid : value;
    return value;
}
function encodeBrokerTransportQualityOfService(value, stream) {
    stream.writeUInt32(value);
}
exports._enumerationBrokerTransportQualityOfService = (0, node_opcua_factory_1.registerEnumeration)(schemaBrokerTransportQualityOfService);
(0, node_opcua_assert_1.assert)(exports._enumerationBrokerTransportQualityOfService.isFlaggable === false);
// --------------------------------------------------------------------------------------------
const schemaBrokerDataSetReaderTransportDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "BrokerDataSetReaderTransportDataType",
    baseType: "DataSetReaderTransportDataType",
    fields: [
        {
            name: "QueueName",
            fieldType: "String",
        },
        {
            name: "ResourceUri",
            fieldType: "String",
        },
        {
            name: "AuthenticationProfileUri",
            fieldType: "String",
        },
        {
            name: "RequestedDeliveryGuarantee",
            fieldType: "BrokerTransportQualityOfService",
        },
        {
            name: "MetaDataQueueName",
            fieldType: "String",
        },
    ]
});
class BrokerDataSetReaderTransportDataType extends DataSetReaderTransportDataType {
    static get schema() { return schemaBrokerDataSetReaderTransportDataType; }
    static possibleFields = [
        "queueName",
        "resourceUri",
        "authenticationProfileUri",
        "requestedDeliveryGuarantee",
        "metaDataQueueName"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15670, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15733, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16023, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16526, 0);
    queueName;
    resourceUri;
    authenticationProfileUri;
    requestedDeliveryGuarantee;
    metaDataQueueName;
    constructor(options) {
        super(options);
        if (options === null) {
            this.queueName = null;
            this.resourceUri = null;
            this.authenticationProfileUri = null;
            this.requestedDeliveryGuarantee = 0;
            this.metaDataQueueName = null;
            return;
        }
        const schema = BrokerDataSetReaderTransportDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.queueName = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.queueName);
        this.resourceUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.resourceUri);
        this.authenticationProfileUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.authenticationProfileUri);
        this.requestedDeliveryGuarantee = this.setRequestedDeliveryGuarantee((0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.requestedDeliveryGuarantee));
        this.metaDataQueueName = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.metaDataQueueName);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.queueName, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.resourceUri, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.authenticationProfileUri, stream);
        encodeBrokerTransportQualityOfService(this.requestedDeliveryGuarantee, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.metaDataQueueName, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.queueName = (0, node_opcua_basic_types_1.decodeString)(stream, this.queueName);
        this.resourceUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.resourceUri);
        this.authenticationProfileUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.authenticationProfileUri);
        this.requestedDeliveryGuarantee = decodeBrokerTransportQualityOfService(stream, this.requestedDeliveryGuarantee);
        this.metaDataQueueName = (0, node_opcua_basic_types_1.decodeString)(stream, this.metaDataQueueName);
    }
    // Define Enumeration setters
    setRequestedDeliveryGuarantee(value) {
        const coercedValue = exports._enumerationBrokerTransportQualityOfService.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to BrokerTransportQualityOfService :" + value);
        }
        this.requestedDeliveryGuarantee = coercedValue.value;
        return this.requestedDeliveryGuarantee;
    }
    get schema() { return schemaBrokerDataSetReaderTransportDataType; }
}
exports.BrokerDataSetReaderTransportDataType = BrokerDataSetReaderTransportDataType;
BrokerDataSetReaderTransportDataType.schema.dataTypeNodeId = BrokerDataSetReaderTransportDataType.dataTypeNodeId;
BrokerDataSetReaderTransportDataType.schema.encodingDefaultBinary = BrokerDataSetReaderTransportDataType.encodingDefaultBinary;
BrokerDataSetReaderTransportDataType.schema.encodingDefaultXml = BrokerDataSetReaderTransportDataType.encodingDefaultXml;
BrokerDataSetReaderTransportDataType.schema.encodingDefaultJson = BrokerDataSetReaderTransportDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(BrokerDataSetReaderTransportDataType.dataTypeNodeId, "BrokerDataSetReaderTransportDataType", BrokerDataSetReaderTransportDataType);
// --------------------------------------------------------------------------------------------
const schemaDataSetWriterTransportDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DataSetWriterTransportDataType",
    baseType: "ExtensionObject",
    fields: []
});
class DataSetWriterTransportDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaDataSetWriterTransportDataType; }
    static possibleFields = [];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15598, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15683, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15956, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16157, 0);
    constructor(options) {
        super(options);
        if (options === null) {
            return;
        }
        const schema = DataSetWriterTransportDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    get schema() { return schemaDataSetWriterTransportDataType; }
}
exports.DataSetWriterTransportDataType = DataSetWriterTransportDataType;
DataSetWriterTransportDataType.schema.dataTypeNodeId = DataSetWriterTransportDataType.dataTypeNodeId;
DataSetWriterTransportDataType.schema.encodingDefaultBinary = DataSetWriterTransportDataType.encodingDefaultBinary;
DataSetWriterTransportDataType.schema.encodingDefaultXml = DataSetWriterTransportDataType.encodingDefaultXml;
DataSetWriterTransportDataType.schema.encodingDefaultJson = DataSetWriterTransportDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DataSetWriterTransportDataType.dataTypeNodeId, "DataSetWriterTransportDataType", DataSetWriterTransportDataType);
// --------------------------------------------------------------------------------------------
const schemaBrokerDataSetWriterTransportDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "BrokerDataSetWriterTransportDataType",
    baseType: "DataSetWriterTransportDataType",
    fields: [
        {
            name: "QueueName",
            fieldType: "String",
        },
        {
            name: "ResourceUri",
            fieldType: "String",
        },
        {
            name: "AuthenticationProfileUri",
            fieldType: "String",
        },
        {
            name: "RequestedDeliveryGuarantee",
            fieldType: "BrokerTransportQualityOfService",
        },
        {
            name: "MetaDataQueueName",
            fieldType: "String",
        },
        {
            name: "MetaDataUpdateTime",
            fieldType: "Double",
        },
    ]
});
class BrokerDataSetWriterTransportDataType extends DataSetWriterTransportDataType {
    static get schema() { return schemaBrokerDataSetWriterTransportDataType; }
    static possibleFields = [
        "queueName",
        "resourceUri",
        "authenticationProfileUri",
        "requestedDeliveryGuarantee",
        "metaDataQueueName",
        "metaDataUpdateTime"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15669, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15729, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16022, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16525, 0);
    queueName;
    resourceUri;
    authenticationProfileUri;
    requestedDeliveryGuarantee;
    metaDataQueueName;
    metaDataUpdateTime;
    constructor(options) {
        super(options);
        if (options === null) {
            this.queueName = null;
            this.resourceUri = null;
            this.authenticationProfileUri = null;
            this.requestedDeliveryGuarantee = 0;
            this.metaDataQueueName = null;
            this.metaDataUpdateTime = 0;
            return;
        }
        const schema = BrokerDataSetWriterTransportDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.queueName = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.queueName);
        this.resourceUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.resourceUri);
        this.authenticationProfileUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.authenticationProfileUri);
        this.requestedDeliveryGuarantee = this.setRequestedDeliveryGuarantee((0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.requestedDeliveryGuarantee));
        this.metaDataQueueName = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.metaDataQueueName);
        this.metaDataUpdateTime = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.metaDataUpdateTime);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.queueName, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.resourceUri, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.authenticationProfileUri, stream);
        encodeBrokerTransportQualityOfService(this.requestedDeliveryGuarantee, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.metaDataQueueName, stream);
        (0, node_opcua_basic_types_1.encodeDouble)(this.metaDataUpdateTime, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.queueName = (0, node_opcua_basic_types_1.decodeString)(stream, this.queueName);
        this.resourceUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.resourceUri);
        this.authenticationProfileUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.authenticationProfileUri);
        this.requestedDeliveryGuarantee = decodeBrokerTransportQualityOfService(stream, this.requestedDeliveryGuarantee);
        this.metaDataQueueName = (0, node_opcua_basic_types_1.decodeString)(stream, this.metaDataQueueName);
        this.metaDataUpdateTime = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.metaDataUpdateTime);
    }
    // Define Enumeration setters
    setRequestedDeliveryGuarantee(value) {
        const coercedValue = exports._enumerationBrokerTransportQualityOfService.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to BrokerTransportQualityOfService :" + value);
        }
        this.requestedDeliveryGuarantee = coercedValue.value;
        return this.requestedDeliveryGuarantee;
    }
    get schema() { return schemaBrokerDataSetWriterTransportDataType; }
}
exports.BrokerDataSetWriterTransportDataType = BrokerDataSetWriterTransportDataType;
BrokerDataSetWriterTransportDataType.schema.dataTypeNodeId = BrokerDataSetWriterTransportDataType.dataTypeNodeId;
BrokerDataSetWriterTransportDataType.schema.encodingDefaultBinary = BrokerDataSetWriterTransportDataType.encodingDefaultBinary;
BrokerDataSetWriterTransportDataType.schema.encodingDefaultXml = BrokerDataSetWriterTransportDataType.encodingDefaultXml;
BrokerDataSetWriterTransportDataType.schema.encodingDefaultJson = BrokerDataSetWriterTransportDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(BrokerDataSetWriterTransportDataType.dataTypeNodeId, "BrokerDataSetWriterTransportDataType", BrokerDataSetWriterTransportDataType);
// --------------------------------------------------------------------------------------------
const schemaWriterGroupTransportDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "WriterGroupTransportDataType",
    baseType: "ExtensionObject",
    fields: []
});
class WriterGroupTransportDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaWriterGroupTransportDataType; }
    static possibleFields = [];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15611, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15691, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15990, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16161, 0);
    constructor(options) {
        super(options);
        if (options === null) {
            return;
        }
        const schema = WriterGroupTransportDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    get schema() { return schemaWriterGroupTransportDataType; }
}
exports.WriterGroupTransportDataType = WriterGroupTransportDataType;
WriterGroupTransportDataType.schema.dataTypeNodeId = WriterGroupTransportDataType.dataTypeNodeId;
WriterGroupTransportDataType.schema.encodingDefaultBinary = WriterGroupTransportDataType.encodingDefaultBinary;
WriterGroupTransportDataType.schema.encodingDefaultXml = WriterGroupTransportDataType.encodingDefaultXml;
WriterGroupTransportDataType.schema.encodingDefaultJson = WriterGroupTransportDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(WriterGroupTransportDataType.dataTypeNodeId, "WriterGroupTransportDataType", WriterGroupTransportDataType);
// --------------------------------------------------------------------------------------------
const schemaBrokerWriterGroupTransportDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "BrokerWriterGroupTransportDataType",
    baseType: "WriterGroupTransportDataType",
    fields: [
        {
            name: "QueueName",
            fieldType: "String",
        },
        {
            name: "ResourceUri",
            fieldType: "String",
        },
        {
            name: "AuthenticationProfileUri",
            fieldType: "String",
        },
        {
            name: "RequestedDeliveryGuarantee",
            fieldType: "BrokerTransportQualityOfService",
        },
    ]
});
class BrokerWriterGroupTransportDataType extends WriterGroupTransportDataType {
    static get schema() { return schemaBrokerWriterGroupTransportDataType; }
    static possibleFields = [
        "queueName",
        "resourceUri",
        "authenticationProfileUri",
        "requestedDeliveryGuarantee"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15667, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15727, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16021, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16524, 0);
    queueName;
    resourceUri;
    authenticationProfileUri;
    requestedDeliveryGuarantee;
    constructor(options) {
        super(options);
        if (options === null) {
            this.queueName = null;
            this.resourceUri = null;
            this.authenticationProfileUri = null;
            this.requestedDeliveryGuarantee = 0;
            return;
        }
        const schema = BrokerWriterGroupTransportDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.queueName = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.queueName);
        this.resourceUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.resourceUri);
        this.authenticationProfileUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.authenticationProfileUri);
        this.requestedDeliveryGuarantee = this.setRequestedDeliveryGuarantee((0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.requestedDeliveryGuarantee));
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.queueName, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.resourceUri, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.authenticationProfileUri, stream);
        encodeBrokerTransportQualityOfService(this.requestedDeliveryGuarantee, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.queueName = (0, node_opcua_basic_types_1.decodeString)(stream, this.queueName);
        this.resourceUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.resourceUri);
        this.authenticationProfileUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.authenticationProfileUri);
        this.requestedDeliveryGuarantee = decodeBrokerTransportQualityOfService(stream, this.requestedDeliveryGuarantee);
    }
    // Define Enumeration setters
    setRequestedDeliveryGuarantee(value) {
        const coercedValue = exports._enumerationBrokerTransportQualityOfService.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to BrokerTransportQualityOfService :" + value);
        }
        this.requestedDeliveryGuarantee = coercedValue.value;
        return this.requestedDeliveryGuarantee;
    }
    get schema() { return schemaBrokerWriterGroupTransportDataType; }
}
exports.BrokerWriterGroupTransportDataType = BrokerWriterGroupTransportDataType;
BrokerWriterGroupTransportDataType.schema.dataTypeNodeId = BrokerWriterGroupTransportDataType.dataTypeNodeId;
BrokerWriterGroupTransportDataType.schema.encodingDefaultBinary = BrokerWriterGroupTransportDataType.encodingDefaultBinary;
BrokerWriterGroupTransportDataType.schema.encodingDefaultXml = BrokerWriterGroupTransportDataType.encodingDefaultXml;
BrokerWriterGroupTransportDataType.schema.encodingDefaultJson = BrokerWriterGroupTransportDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(BrokerWriterGroupTransportDataType.dataTypeNodeId, "BrokerWriterGroupTransportDataType", BrokerWriterGroupTransportDataType);
// --------------------------------------------------------------------------------------------
const schemaBrowseDescription = (0, node_opcua_factory_1.buildStructuredType)({
    name: "BrowseDescription",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "NodeId",
            fieldType: "NodeId",
        },
        {
            name: "BrowseDirection",
            fieldType: "BrowseDirection",
        },
        {
            name: "ReferenceTypeId",
            fieldType: "NodeId",
        },
        {
            name: "IncludeSubtypes",
            fieldType: "Boolean",
        },
        {
            name: "NodeClassMask",
            fieldType: "UInt32",
        },
        {
            name: "ResultMask",
            fieldType: "UInt32",
        },
    ]
});
class BrowseDescription extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaBrowseDescription; }
    static possibleFields = [
        "nodeId",
        "browseDirection",
        "referenceTypeId",
        "includeSubtypes",
        "nodeClassMask",
        "resultMask"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(514, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(516, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(515, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15180, 0);
    nodeId;
    browseDirection;
    referenceTypeId;
    includeSubtypes;
    nodeClassMask;
    resultMask;
    constructor(options) {
        super(options);
        if (options === null) {
            this.nodeId = new node_opcua_nodeid_1.NodeId(null);
            this.browseDirection = 0;
            this.referenceTypeId = new node_opcua_nodeid_1.NodeId(null);
            this.includeSubtypes = false;
            this.nodeClassMask = 0;
            this.resultMask = 0;
            return;
        }
        const schema = BrowseDescription.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.nodeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.nodeId);
        this.browseDirection = this.setBrowseDirection((0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.browseDirection));
        this.referenceTypeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.referenceTypeId);
        this.includeSubtypes = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.includeSubtypes);
        this.nodeClassMask = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.nodeClassMask);
        this.resultMask = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.resultMask);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.nodeId, stream);
        (0, node_opcua_data_model_1.encodeBrowseDirection)(this.browseDirection, stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.referenceTypeId, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.includeSubtypes, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.nodeClassMask, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.resultMask, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.nodeId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.nodeId);
        this.browseDirection = (0, node_opcua_data_model_1.decodeBrowseDirection)(stream, this.browseDirection);
        this.referenceTypeId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.referenceTypeId);
        this.includeSubtypes = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.includeSubtypes);
        this.nodeClassMask = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.nodeClassMask);
        this.resultMask = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.resultMask);
    }
    // Define Enumeration setters
    setBrowseDirection(value) {
        const coercedValue = node_opcua_data_model_1._enumerationBrowseDirection.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to BrowseDirection :" + value);
        }
        this.browseDirection = coercedValue.value;
        return this.browseDirection;
    }
    get schema() { return schemaBrowseDescription; }
}
exports.BrowseDescription = BrowseDescription;
BrowseDescription.schema.dataTypeNodeId = BrowseDescription.dataTypeNodeId;
BrowseDescription.schema.encodingDefaultBinary = BrowseDescription.encodingDefaultBinary;
BrowseDescription.schema.encodingDefaultXml = BrowseDescription.encodingDefaultXml;
BrowseDescription.schema.encodingDefaultJson = BrowseDescription.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(BrowseDescription.dataTypeNodeId, "BrowseDescription", BrowseDescription);
// --------------------------------------------------------------------------------------------
const schemaBrowseNextRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "BrowseNextRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",
            fieldType: "RequestHeader",
        },
        {
            name: "ReleaseContinuationPoints",
            fieldType: "Boolean",
        },
        {
            name: "ContinuationPoints",
            fieldType: "ByteString",
            isArray: true
        },
    ]
});
class BrowseNextRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaBrowseNextRequest; }
    static possibleFields = [
        "requestHeader",
        "releaseContinuationPoints",
        "continuationPoints"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(531, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(533, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(532, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15186, 0);
    requestHeader;
    releaseContinuationPoints;
    continuationPoints;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestHeader = new RequestHeader(null);
            this.releaseContinuationPoints = false;
            this.continuationPoints = [];
            return;
        }
        const schema = BrowseNextRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestHeader = new RequestHeader(options.requestHeader);
        this.releaseContinuationPoints = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.releaseContinuationPoints);
        this.continuationPoints = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.continuationPoints);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.releaseContinuationPoints, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.continuationPoints, stream, node_opcua_basic_types_1.encodeByteString);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.releaseContinuationPoints = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.releaseContinuationPoints);
        this.continuationPoints = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeByteString);
    }
    get schema() { return schemaBrowseNextRequest; }
}
exports.BrowseNextRequest = BrowseNextRequest;
BrowseNextRequest.schema.dataTypeNodeId = BrowseNextRequest.dataTypeNodeId;
BrowseNextRequest.schema.encodingDefaultBinary = BrowseNextRequest.encodingDefaultBinary;
BrowseNextRequest.schema.encodingDefaultXml = BrowseNextRequest.encodingDefaultXml;
BrowseNextRequest.schema.encodingDefaultJson = BrowseNextRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(BrowseNextRequest.dataTypeNodeId, "BrowseNextRequest", BrowseNextRequest);
// --------------------------------------------------------------------------------------------
const schemaReferenceDescription = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ReferenceDescription",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ReferenceTypeId",
            fieldType: "NodeId",
        },
        {
            name: "IsForward",
            fieldType: "Boolean",
        },
        {
            name: "NodeId",
            fieldType: "ExpandedNodeId",
        },
        {
            name: "BrowseName",
            fieldType: "QualifiedName",
        },
        {
            name: "DisplayName",
            fieldType: "LocalizedText",
        },
        {
            name: "NodeClass",
            fieldType: "NodeClass",
        },
        {
            name: "TypeDefinition",
            fieldType: "ExpandedNodeId",
        },
    ]
});
class ReferenceDescription extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaReferenceDescription; }
    static possibleFields = [
        "referenceTypeId",
        "isForward",
        "nodeId",
        "browseName",
        "displayName",
        "nodeClass",
        "typeDefinition"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(518, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(520, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(519, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15182, 0);
    referenceTypeId;
    isForward;
    nodeId;
    browseName;
    displayName;
    nodeClass;
    typeDefinition;
    constructor(options) {
        super(options);
        if (options === null) {
            this.referenceTypeId = new node_opcua_nodeid_1.NodeId(null);
            this.isForward = false;
            this.nodeId = new node_opcua_nodeid_1.ExpandedNodeId(null);
            this.browseName = new node_opcua_data_model_1.QualifiedName(null);
            this.displayName = new node_opcua_data_model_1.LocalizedText(null);
            this.nodeClass = 0;
            this.typeDefinition = new node_opcua_nodeid_1.ExpandedNodeId(null);
            return;
        }
        const schema = ReferenceDescription.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.referenceTypeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.referenceTypeId);
        this.isForward = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.isForward);
        this.nodeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.nodeId);
        this.browseName = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.browseName);
        this.displayName = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.displayName);
        this.nodeClass = this.setNodeClass((0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.nodeClass));
        this.typeDefinition = (0, node_opcua_factory_1.initialize_field)(schema.fields[6], options?.typeDefinition);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.referenceTypeId, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.isForward, stream);
        (0, node_opcua_basic_types_1.encodeExpandedNodeId)(this.nodeId, stream);
        (0, node_opcua_data_model_1.encodeQualifiedName)(this.browseName, stream);
        (0, node_opcua_data_model_1.encodeLocalizedText)(this.displayName, stream);
        encodeNodeClass(this.nodeClass, stream);
        (0, node_opcua_basic_types_1.encodeExpandedNodeId)(this.typeDefinition, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.referenceTypeId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.referenceTypeId);
        this.isForward = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.isForward);
        this.nodeId = (0, node_opcua_basic_types_1.decodeExpandedNodeId)(stream, this.nodeId);
        this.browseName = (0, node_opcua_data_model_1.decodeQualifiedName)(stream, this.browseName);
        this.displayName = (0, node_opcua_data_model_1.decodeLocalizedText)(stream, this.displayName);
        this.nodeClass = decodeNodeClass(stream, this.nodeClass);
        this.typeDefinition = (0, node_opcua_basic_types_1.decodeExpandedNodeId)(stream, this.typeDefinition);
    }
    // Define Enumeration setters
    setNodeClass(value) {
        const coercedValue = exports._enumerationNodeClass.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to NodeClass :" + value);
        }
        this.nodeClass = coercedValue.value;
        return this.nodeClass;
    }
    get schema() { return schemaReferenceDescription; }
}
exports.ReferenceDescription = ReferenceDescription;
ReferenceDescription.schema.dataTypeNodeId = ReferenceDescription.dataTypeNodeId;
ReferenceDescription.schema.encodingDefaultBinary = ReferenceDescription.encodingDefaultBinary;
ReferenceDescription.schema.encodingDefaultXml = ReferenceDescription.encodingDefaultXml;
ReferenceDescription.schema.encodingDefaultJson = ReferenceDescription.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ReferenceDescription.dataTypeNodeId, "ReferenceDescription", ReferenceDescription);
// --------------------------------------------------------------------------------------------
const schemaBrowseResult = (0, node_opcua_factory_1.buildStructuredType)({
    name: "BrowseResult",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "StatusCode",
            fieldType: "StatusCode",
        },
        {
            name: "ContinuationPoint",
            fieldType: "ByteString",
        },
        {
            name: "References",
            fieldType: "ReferenceDescription",
            isArray: true
        },
    ]
});
class BrowseResult extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaBrowseResult; }
    static possibleFields = [
        "statusCode",
        "continuationPoint",
        "references"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(522, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(524, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(523, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15183, 0);
    statusCode;
    continuationPoint;
    references;
    constructor(options) {
        super(options);
        if (options === null) {
            this.statusCode = node_opcua_status_code_1.StatusCodes.Good;
            this.continuationPoint = Buffer.alloc(0);
            this.references = null; /* null array */
            return;
        }
        const schema = BrowseResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.statusCode = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.statusCode);
        this.continuationPoint = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.continuationPoint);
        this.references = []; // should default
        if (options.references) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.references));
            this.references = options.references.map((e) => new ReferenceDescription(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_status_code_1.encodeStatusCode)(this.statusCode, stream);
        (0, node_opcua_basic_types_1.encodeByteString)(this.continuationPoint, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.references, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.statusCode = (0, node_opcua_status_code_1.decodeStatusCode)(stream, this.statusCode);
        this.continuationPoint = (0, node_opcua_basic_types_1.decodeByteString)(stream, this.continuationPoint);
        this.references = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new ReferenceDescription(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaBrowseResult; }
}
exports.BrowseResult = BrowseResult;
BrowseResult.schema.dataTypeNodeId = BrowseResult.dataTypeNodeId;
BrowseResult.schema.encodingDefaultBinary = BrowseResult.encodingDefaultBinary;
BrowseResult.schema.encodingDefaultXml = BrowseResult.encodingDefaultXml;
BrowseResult.schema.encodingDefaultJson = BrowseResult.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(BrowseResult.dataTypeNodeId, "BrowseResult", BrowseResult);
// --------------------------------------------------------------------------------------------
const schemaBrowseNextResponse = (0, node_opcua_factory_1.buildStructuredType)({
    name: "BrowseNextResponse",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",
            fieldType: "ResponseHeader",
        },
        {
            name: "Results",
            fieldType: "BrowseResult",
            isArray: true
        },
        {
            name: "DiagnosticInfos",
            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
class BrowseNextResponse extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaBrowseNextResponse; }
    static possibleFields = [
        "responseHeader",
        "results",
        "diagnosticInfos"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(534, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(536, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(535, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15187, 0);
    responseHeader;
    results;
    diagnosticInfos;
    constructor(options) {
        super(options);
        if (options === null) {
            this.responseHeader = new ResponseHeader(null);
            this.results = null; /* null array */
            this.diagnosticInfos = [];
            return;
        }
        const schema = BrowseNextResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.responseHeader = new ResponseHeader(options.responseHeader);
        this.results = []; // should default
        if (options.results) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.results));
            this.results = options.results.map((e) => new BrowseResult(e));
        }
        this.diagnosticInfos = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.diagnosticInfos);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.results, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.diagnosticInfos, stream, node_opcua_data_model_1.encodeDiagnosticInfo);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new BrowseResult(null);
            obj.decode(stream1);
            return obj;
        });
        this.diagnosticInfos = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_data_model_1.decodeDiagnosticInfo);
    }
    get schema() { return schemaBrowseNextResponse; }
}
exports.BrowseNextResponse = BrowseNextResponse;
BrowseNextResponse.schema.dataTypeNodeId = BrowseNextResponse.dataTypeNodeId;
BrowseNextResponse.schema.encodingDefaultBinary = BrowseNextResponse.encodingDefaultBinary;
BrowseNextResponse.schema.encodingDefaultXml = BrowseNextResponse.encodingDefaultXml;
BrowseNextResponse.schema.encodingDefaultJson = BrowseNextResponse.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(BrowseNextResponse.dataTypeNodeId, "BrowseNextResponse", BrowseNextResponse);
// --------------------------------------------------------------------------------------------
const schemaBrowsePath = (0, node_opcua_factory_1.buildStructuredType)({
    name: "BrowsePath",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "StartingNode",
            fieldType: "NodeId",
        },
        {
            name: "RelativePath",
            fieldType: "RelativePath",
        },
    ]
});
class BrowsePath extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaBrowsePath; }
    static possibleFields = [
        "startingNode",
        "relativePath"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(543, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(545, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(544, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15190, 0);
    startingNode;
    relativePath;
    constructor(options) {
        super(options);
        if (options === null) {
            this.startingNode = new node_opcua_nodeid_1.NodeId(null);
            this.relativePath = new RelativePath(null);
            return;
        }
        const schema = BrowsePath.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.startingNode = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.startingNode);
        this.relativePath = new RelativePath(options.relativePath);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.startingNode, stream);
        this.relativePath.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.startingNode = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.startingNode);
        this.relativePath.decode(stream);
    }
    get schema() { return schemaBrowsePath; }
}
exports.BrowsePath = BrowsePath;
BrowsePath.schema.dataTypeNodeId = BrowsePath.dataTypeNodeId;
BrowsePath.schema.encodingDefaultBinary = BrowsePath.encodingDefaultBinary;
BrowsePath.schema.encodingDefaultXml = BrowsePath.encodingDefaultXml;
BrowsePath.schema.encodingDefaultJson = BrowsePath.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(BrowsePath.dataTypeNodeId, "BrowsePath", BrowsePath);
// --------------------------------------------------------------------------------------------
const schemaBrowsePathTarget = (0, node_opcua_factory_1.buildStructuredType)({
    name: "BrowsePathTarget",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "TargetId",
            fieldType: "ExpandedNodeId",
        },
        {
            name: "RemainingPathIndex",
            fieldType: "UInt32",
        },
    ]
});
class BrowsePathTarget extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaBrowsePathTarget; }
    static possibleFields = [
        "targetId",
        "remainingPathIndex"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(546, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(548, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(547, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15191, 0);
    targetId;
    remainingPathIndex;
    constructor(options) {
        super(options);
        if (options === null) {
            this.targetId = new node_opcua_nodeid_1.ExpandedNodeId(null);
            this.remainingPathIndex = 0;
            return;
        }
        const schema = BrowsePathTarget.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.targetId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.targetId);
        this.remainingPathIndex = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.remainingPathIndex);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeExpandedNodeId)(this.targetId, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.remainingPathIndex, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.targetId = (0, node_opcua_basic_types_1.decodeExpandedNodeId)(stream, this.targetId);
        this.remainingPathIndex = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.remainingPathIndex);
    }
    get schema() { return schemaBrowsePathTarget; }
}
exports.BrowsePathTarget = BrowsePathTarget;
BrowsePathTarget.schema.dataTypeNodeId = BrowsePathTarget.dataTypeNodeId;
BrowsePathTarget.schema.encodingDefaultBinary = BrowsePathTarget.encodingDefaultBinary;
BrowsePathTarget.schema.encodingDefaultXml = BrowsePathTarget.encodingDefaultXml;
BrowsePathTarget.schema.encodingDefaultJson = BrowsePathTarget.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(BrowsePathTarget.dataTypeNodeId, "BrowsePathTarget", BrowsePathTarget);
// --------------------------------------------------------------------------------------------
const schemaBrowsePathResult = (0, node_opcua_factory_1.buildStructuredType)({
    name: "BrowsePathResult",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "StatusCode",
            fieldType: "StatusCode",
        },
        {
            name: "Targets",
            fieldType: "BrowsePathTarget",
            isArray: true
        },
    ]
});
class BrowsePathResult extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaBrowsePathResult; }
    static possibleFields = [
        "statusCode",
        "targets"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(549, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(551, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(550, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15192, 0);
    statusCode;
    targets;
    constructor(options) {
        super(options);
        if (options === null) {
            this.statusCode = node_opcua_status_code_1.StatusCodes.Good;
            this.targets = null; /* null array */
            return;
        }
        const schema = BrowsePathResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.statusCode = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.statusCode);
        this.targets = []; // should default
        if (options.targets) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.targets));
            this.targets = options.targets.map((e) => new BrowsePathTarget(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_status_code_1.encodeStatusCode)(this.statusCode, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.targets, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.statusCode = (0, node_opcua_status_code_1.decodeStatusCode)(stream, this.statusCode);
        this.targets = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new BrowsePathTarget(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaBrowsePathResult; }
}
exports.BrowsePathResult = BrowsePathResult;
BrowsePathResult.schema.dataTypeNodeId = BrowsePathResult.dataTypeNodeId;
BrowsePathResult.schema.encodingDefaultBinary = BrowsePathResult.encodingDefaultBinary;
BrowsePathResult.schema.encodingDefaultXml = BrowsePathResult.encodingDefaultXml;
BrowsePathResult.schema.encodingDefaultJson = BrowsePathResult.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(BrowsePathResult.dataTypeNodeId, "BrowsePathResult", BrowsePathResult);
// --------------------------------------------------------------------------------------------
const schemaViewDescription = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ViewDescription",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ViewId",
            fieldType: "NodeId",
        },
        {
            name: "Timestamp",
            fieldType: "DateTime",
        },
        {
            name: "ViewVersion",
            fieldType: "UInt32",
        },
    ]
});
class ViewDescription extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaViewDescription; }
    static possibleFields = [
        "viewId",
        "timestamp",
        "viewVersion"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(511, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(513, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(512, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15179, 0);
    viewId;
    timestamp;
    viewVersion;
    constructor(options) {
        super(options);
        if (options === null) {
            this.viewId = new node_opcua_nodeid_1.NodeId(null);
            this.timestamp = new Date();
            this.viewVersion = 0;
            return;
        }
        const schema = ViewDescription.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.viewId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.viewId);
        this.timestamp = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.timestamp);
        this.viewVersion = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.viewVersion);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.viewId, stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.timestamp, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.viewVersion, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.viewId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.viewId);
        this.timestamp = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.timestamp);
        this.viewVersion = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.viewVersion);
    }
    get schema() { return schemaViewDescription; }
}
exports.ViewDescription = ViewDescription;
ViewDescription.schema.dataTypeNodeId = ViewDescription.dataTypeNodeId;
ViewDescription.schema.encodingDefaultBinary = ViewDescription.encodingDefaultBinary;
ViewDescription.schema.encodingDefaultXml = ViewDescription.encodingDefaultXml;
ViewDescription.schema.encodingDefaultJson = ViewDescription.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ViewDescription.dataTypeNodeId, "ViewDescription", ViewDescription);
// --------------------------------------------------------------------------------------------
const schemaBrowseRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "BrowseRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",
            fieldType: "RequestHeader",
        },
        {
            name: "View",
            fieldType: "ViewDescription",
        },
        {
            name: "RequestedMaxReferencesPerNode",
            fieldType: "UInt32",
        },
        {
            name: "NodesToBrowse",
            fieldType: "BrowseDescription",
            isArray: true
        },
    ]
});
class BrowseRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaBrowseRequest; }
    static possibleFields = [
        "requestHeader",
        "view",
        "requestedMaxReferencesPerNode",
        "nodesToBrowse"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(525, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(527, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(526, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15184, 0);
    requestHeader;
    view;
    requestedMaxReferencesPerNode;
    nodesToBrowse;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestHeader = new RequestHeader(null);
            this.view = new ViewDescription(null);
            this.requestedMaxReferencesPerNode = 0;
            this.nodesToBrowse = null; /* null array */
            return;
        }
        const schema = BrowseRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestHeader = new RequestHeader(options.requestHeader);
        this.view = new ViewDescription(options.view);
        this.requestedMaxReferencesPerNode = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.requestedMaxReferencesPerNode);
        this.nodesToBrowse = []; // should default
        if (options.nodesToBrowse) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.nodesToBrowse));
            this.nodesToBrowse = options.nodesToBrowse.map((e) => new BrowseDescription(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        this.view.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.requestedMaxReferencesPerNode, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.nodesToBrowse, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.view.decode(stream);
        this.requestedMaxReferencesPerNode = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.requestedMaxReferencesPerNode);
        this.nodesToBrowse = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new BrowseDescription(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaBrowseRequest; }
}
exports.BrowseRequest = BrowseRequest;
BrowseRequest.schema.dataTypeNodeId = BrowseRequest.dataTypeNodeId;
BrowseRequest.schema.encodingDefaultBinary = BrowseRequest.encodingDefaultBinary;
BrowseRequest.schema.encodingDefaultXml = BrowseRequest.encodingDefaultXml;
BrowseRequest.schema.encodingDefaultJson = BrowseRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(BrowseRequest.dataTypeNodeId, "BrowseRequest", BrowseRequest);
// --------------------------------------------------------------------------------------------
const schemaBrowseResponse = (0, node_opcua_factory_1.buildStructuredType)({
    name: "BrowseResponse",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",
            fieldType: "ResponseHeader",
        },
        {
            name: "Results",
            fieldType: "BrowseResult",
            isArray: true
        },
        {
            name: "DiagnosticInfos",
            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
class BrowseResponse extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaBrowseResponse; }
    static possibleFields = [
        "responseHeader",
        "results",
        "diagnosticInfos"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(528, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(530, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(529, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15185, 0);
    responseHeader;
    results;
    diagnosticInfos;
    constructor(options) {
        super(options);
        if (options === null) {
            this.responseHeader = new ResponseHeader(null);
            this.results = null; /* null array */
            this.diagnosticInfos = [];
            return;
        }
        const schema = BrowseResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.responseHeader = new ResponseHeader(options.responseHeader);
        this.results = []; // should default
        if (options.results) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.results));
            this.results = options.results.map((e) => new BrowseResult(e));
        }
        this.diagnosticInfos = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.diagnosticInfos);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.results, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.diagnosticInfos, stream, node_opcua_data_model_1.encodeDiagnosticInfo);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new BrowseResult(null);
            obj.decode(stream1);
            return obj;
        });
        this.diagnosticInfos = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_data_model_1.decodeDiagnosticInfo);
    }
    get schema() { return schemaBrowseResponse; }
}
exports.BrowseResponse = BrowseResponse;
BrowseResponse.schema.dataTypeNodeId = BrowseResponse.dataTypeNodeId;
BrowseResponse.schema.encodingDefaultBinary = BrowseResponse.encodingDefaultBinary;
BrowseResponse.schema.encodingDefaultXml = BrowseResponse.encodingDefaultXml;
BrowseResponse.schema.encodingDefaultJson = BrowseResponse.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(BrowseResponse.dataTypeNodeId, "BrowseResponse", BrowseResponse);
// --------------------------------------------------------------------------------------------
const schemaBuildInfo = (0, node_opcua_factory_1.buildStructuredType)({
    name: "BuildInfo",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ProductUri",
            fieldType: "String",
        },
        {
            name: "ManufacturerName",
            fieldType: "String",
        },
        {
            name: "ProductName",
            fieldType: "String",
        },
        {
            name: "SoftwareVersion",
            fieldType: "String",
        },
        {
            name: "BuildNumber",
            fieldType: "String",
        },
        {
            name: "BuildDate",
            fieldType: "DateTime",
        },
    ]
});
class BuildInfo extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaBuildInfo; }
    static possibleFields = [
        "productUri",
        "manufacturerName",
        "productName",
        "softwareVersion",
        "buildNumber",
        "buildDate"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(338, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(340, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(339, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15361, 0);
    productUri;
    manufacturerName;
    productName;
    softwareVersion;
    buildNumber;
    buildDate;
    constructor(options) {
        super(options);
        if (options === null) {
            this.productUri = null;
            this.manufacturerName = null;
            this.productName = null;
            this.softwareVersion = null;
            this.buildNumber = null;
            this.buildDate = new Date();
            return;
        }
        const schema = BuildInfo.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.productUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.productUri);
        this.manufacturerName = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.manufacturerName);
        this.productName = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.productName);
        this.softwareVersion = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.softwareVersion);
        this.buildNumber = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.buildNumber);
        this.buildDate = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.buildDate);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.productUri, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.manufacturerName, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.productName, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.softwareVersion, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.buildNumber, stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.buildDate, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.productUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.productUri);
        this.manufacturerName = (0, node_opcua_basic_types_1.decodeString)(stream, this.manufacturerName);
        this.productName = (0, node_opcua_basic_types_1.decodeString)(stream, this.productName);
        this.softwareVersion = (0, node_opcua_basic_types_1.decodeString)(stream, this.softwareVersion);
        this.buildNumber = (0, node_opcua_basic_types_1.decodeString)(stream, this.buildNumber);
        this.buildDate = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.buildDate);
    }
    get schema() { return schemaBuildInfo; }
}
exports.BuildInfo = BuildInfo;
BuildInfo.schema.dataTypeNodeId = BuildInfo.dataTypeNodeId;
BuildInfo.schema.encodingDefaultBinary = BuildInfo.encodingDefaultBinary;
BuildInfo.schema.encodingDefaultXml = BuildInfo.encodingDefaultXml;
BuildInfo.schema.encodingDefaultJson = BuildInfo.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(BuildInfo.dataTypeNodeId, "BuildInfo", BuildInfo);
// --------------------------------------------------------------------------------------------
const schemaCallMethodRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "CallMethodRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ObjectId",
            fieldType: "NodeId",
        },
        {
            name: "MethodId",
            fieldType: "NodeId",
        },
        {
            name: "InputArguments",
            fieldType: "Variant",
            isArray: true
        },
    ]
});
class CallMethodRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaCallMethodRequest; }
    static possibleFields = [
        "objectId",
        "methodId",
        "inputArguments"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(704, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(706, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(705, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15289, 0);
    objectId;
    methodId;
    inputArguments;
    constructor(options) {
        super(options);
        if (options === null) {
            this.objectId = new node_opcua_nodeid_1.NodeId(null);
            this.methodId = new node_opcua_nodeid_1.NodeId(null);
            this.inputArguments = [];
            return;
        }
        const schema = CallMethodRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.objectId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.objectId);
        this.methodId = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.methodId);
        this.inputArguments = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.inputArguments);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.objectId, stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.methodId, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.inputArguments, stream, node_opcua_variant_1.encodeVariant);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.objectId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.objectId);
        this.methodId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.methodId);
        this.inputArguments = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_variant_1.decodeVariant);
    }
    get schema() { return schemaCallMethodRequest; }
}
exports.CallMethodRequest = CallMethodRequest;
CallMethodRequest.schema.dataTypeNodeId = CallMethodRequest.dataTypeNodeId;
CallMethodRequest.schema.encodingDefaultBinary = CallMethodRequest.encodingDefaultBinary;
CallMethodRequest.schema.encodingDefaultXml = CallMethodRequest.encodingDefaultXml;
CallMethodRequest.schema.encodingDefaultJson = CallMethodRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(CallMethodRequest.dataTypeNodeId, "CallMethodRequest", CallMethodRequest);
// --------------------------------------------------------------------------------------------
const schemaCallMethodResult = (0, node_opcua_factory_1.buildStructuredType)({
    name: "CallMethodResult",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "StatusCode",
            fieldType: "StatusCode",
        },
        {
            name: "InputArgumentResults",
            fieldType: "StatusCode",
            isArray: true
        },
        {
            name: "InputArgumentDiagnosticInfos",
            fieldType: "DiagnosticInfo",
            isArray: true
        },
        {
            name: "OutputArguments",
            fieldType: "Variant",
            isArray: true
        },
    ]
});
class CallMethodResult extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaCallMethodResult; }
    static possibleFields = [
        "statusCode",
        "inputArgumentResults",
        "inputArgumentDiagnosticInfos",
        "outputArguments"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(707, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(709, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(708, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15290, 0);
    statusCode;
    inputArgumentResults;
    inputArgumentDiagnosticInfos;
    outputArguments;
    constructor(options) {
        super(options);
        if (options === null) {
            this.statusCode = node_opcua_status_code_1.StatusCodes.Good;
            this.inputArgumentResults = [];
            this.inputArgumentDiagnosticInfos = [];
            this.outputArguments = [];
            return;
        }
        const schema = CallMethodResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.statusCode = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.statusCode);
        this.inputArgumentResults = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.inputArgumentResults);
        this.inputArgumentDiagnosticInfos = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.inputArgumentDiagnosticInfos);
        this.outputArguments = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[3], options?.outputArguments);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_status_code_1.encodeStatusCode)(this.statusCode, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.inputArgumentResults, stream, node_opcua_status_code_1.encodeStatusCode);
        (0, node_opcua_basic_types_1.encodeArray)(this.inputArgumentDiagnosticInfos, stream, node_opcua_data_model_1.encodeDiagnosticInfo);
        (0, node_opcua_basic_types_1.encodeArray)(this.outputArguments, stream, node_opcua_variant_1.encodeVariant);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.statusCode = (0, node_opcua_status_code_1.decodeStatusCode)(stream, this.statusCode);
        this.inputArgumentResults = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_status_code_1.decodeStatusCode);
        this.inputArgumentDiagnosticInfos = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_data_model_1.decodeDiagnosticInfo);
        this.outputArguments = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_variant_1.decodeVariant);
    }
    get schema() { return schemaCallMethodResult; }
}
exports.CallMethodResult = CallMethodResult;
CallMethodResult.schema.dataTypeNodeId = CallMethodResult.dataTypeNodeId;
CallMethodResult.schema.encodingDefaultBinary = CallMethodResult.encodingDefaultBinary;
CallMethodResult.schema.encodingDefaultXml = CallMethodResult.encodingDefaultXml;
CallMethodResult.schema.encodingDefaultJson = CallMethodResult.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(CallMethodResult.dataTypeNodeId, "CallMethodResult", CallMethodResult);
// --------------------------------------------------------------------------------------------
const schemaCallRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "CallRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",
            fieldType: "RequestHeader",
        },
        {
            name: "MethodsToCall",
            fieldType: "CallMethodRequest",
            isArray: true
        },
    ]
});
class CallRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaCallRequest; }
    static possibleFields = [
        "requestHeader",
        "methodsToCall"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(710, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(712, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(711, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15291, 0);
    requestHeader;
    methodsToCall;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestHeader = new RequestHeader(null);
            this.methodsToCall = null; /* null array */
            return;
        }
        const schema = CallRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestHeader = new RequestHeader(options.requestHeader);
        this.methodsToCall = []; // should default
        if (options.methodsToCall) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.methodsToCall));
            this.methodsToCall = options.methodsToCall.map((e) => new CallMethodRequest(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.methodsToCall, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.methodsToCall = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new CallMethodRequest(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaCallRequest; }
}
exports.CallRequest = CallRequest;
CallRequest.schema.dataTypeNodeId = CallRequest.dataTypeNodeId;
CallRequest.schema.encodingDefaultBinary = CallRequest.encodingDefaultBinary;
CallRequest.schema.encodingDefaultXml = CallRequest.encodingDefaultXml;
CallRequest.schema.encodingDefaultJson = CallRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(CallRequest.dataTypeNodeId, "CallRequest", CallRequest);
// --------------------------------------------------------------------------------------------
const schemaCallResponse = (0, node_opcua_factory_1.buildStructuredType)({
    name: "CallResponse",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",
            fieldType: "ResponseHeader",
        },
        {
            name: "Results",
            fieldType: "CallMethodResult",
            isArray: true
        },
        {
            name: "DiagnosticInfos",
            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
class CallResponse extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaCallResponse; }
    static possibleFields = [
        "responseHeader",
        "results",
        "diagnosticInfos"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(713, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(715, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(714, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15292, 0);
    responseHeader;
    results;
    diagnosticInfos;
    constructor(options) {
        super(options);
        if (options === null) {
            this.responseHeader = new ResponseHeader(null);
            this.results = null; /* null array */
            this.diagnosticInfos = [];
            return;
        }
        const schema = CallResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.responseHeader = new ResponseHeader(options.responseHeader);
        this.results = []; // should default
        if (options.results) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.results));
            this.results = options.results.map((e) => new CallMethodResult(e));
        }
        this.diagnosticInfos = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.diagnosticInfos);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.results, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.diagnosticInfos, stream, node_opcua_data_model_1.encodeDiagnosticInfo);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new CallMethodResult(null);
            obj.decode(stream1);
            return obj;
        });
        this.diagnosticInfos = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_data_model_1.decodeDiagnosticInfo);
    }
    get schema() { return schemaCallResponse; }
}
exports.CallResponse = CallResponse;
CallResponse.schema.dataTypeNodeId = CallResponse.dataTypeNodeId;
CallResponse.schema.encodingDefaultBinary = CallResponse.encodingDefaultBinary;
CallResponse.schema.encodingDefaultXml = CallResponse.encodingDefaultXml;
CallResponse.schema.encodingDefaultJson = CallResponse.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(CallResponse.dataTypeNodeId, "CallResponse", CallResponse);
// --------------------------------------------------------------------------------------------
const schemaCancelRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "CancelRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",
            fieldType: "RequestHeader",
        },
        {
            name: "RequestHandle",
            fieldType: "UInt32",
        },
    ]
});
class CancelRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaCancelRequest; }
    static possibleFields = [
        "requestHeader",
        "requestHandle"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(477, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(479, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(478, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15149, 0);
    requestHeader;
    requestHandle;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestHeader = new RequestHeader(null);
            this.requestHandle = 0;
            return;
        }
        const schema = CancelRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestHeader = new RequestHeader(options.requestHeader);
        this.requestHandle = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.requestHandle);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.requestHandle, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.requestHandle = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.requestHandle);
    }
    get schema() { return schemaCancelRequest; }
}
exports.CancelRequest = CancelRequest;
CancelRequest.schema.dataTypeNodeId = CancelRequest.dataTypeNodeId;
CancelRequest.schema.encodingDefaultBinary = CancelRequest.encodingDefaultBinary;
CancelRequest.schema.encodingDefaultXml = CancelRequest.encodingDefaultXml;
CancelRequest.schema.encodingDefaultJson = CancelRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(CancelRequest.dataTypeNodeId, "CancelRequest", CancelRequest);
// --------------------------------------------------------------------------------------------
const schemaCancelResponse = (0, node_opcua_factory_1.buildStructuredType)({
    name: "CancelResponse",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",
            fieldType: "ResponseHeader",
        },
        {
            name: "CancelCount",
            fieldType: "UInt32",
        },
    ]
});
class CancelResponse extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaCancelResponse; }
    static possibleFields = [
        "responseHeader",
        "cancelCount"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(480, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(482, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(481, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15150, 0);
    responseHeader;
    cancelCount;
    constructor(options) {
        super(options);
        if (options === null) {
            this.responseHeader = new ResponseHeader(null);
            this.cancelCount = 0;
            return;
        }
        const schema = CancelResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.responseHeader = new ResponseHeader(options.responseHeader);
        this.cancelCount = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.cancelCount);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.cancelCount, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.cancelCount = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.cancelCount);
    }
    get schema() { return schemaCancelResponse; }
}
exports.CancelResponse = CancelResponse;
CancelResponse.schema.dataTypeNodeId = CancelResponse.dataTypeNodeId;
CancelResponse.schema.encodingDefaultBinary = CancelResponse.encodingDefaultBinary;
CancelResponse.schema.encodingDefaultXml = CancelResponse.encodingDefaultXml;
CancelResponse.schema.encodingDefaultJson = CancelResponse.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(CancelResponse.dataTypeNodeId, "CancelResponse", CancelResponse);
// --------------------------------------------------------------------------------------------
const schemaCartesianCoordinates = (0, node_opcua_factory_1.buildStructuredType)({
    name: "CartesianCoordinates",
    baseType: "ExtensionObject",
    fields: []
});
class CartesianCoordinates extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaCartesianCoordinates; }
    static possibleFields = [];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(18809, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(18818, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(18854, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(19067, 0);
    constructor(options) {
        super(options);
        if (options === null) {
            return;
        }
        const schema = CartesianCoordinates.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    get schema() { return schemaCartesianCoordinates; }
}
exports.CartesianCoordinates = CartesianCoordinates;
CartesianCoordinates.schema.dataTypeNodeId = CartesianCoordinates.dataTypeNodeId;
CartesianCoordinates.schema.encodingDefaultBinary = CartesianCoordinates.encodingDefaultBinary;
CartesianCoordinates.schema.encodingDefaultXml = CartesianCoordinates.encodingDefaultXml;
CartesianCoordinates.schema.encodingDefaultJson = CartesianCoordinates.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(CartesianCoordinates.dataTypeNodeId, "CartesianCoordinates", CartesianCoordinates);
// --------------------------------------------------------------------------------------------
const schemaChannelSecurityToken = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ChannelSecurityToken",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ChannelId",
            fieldType: "UInt32",
        },
        {
            name: "TokenId",
            fieldType: "UInt32",
        },
        {
            name: "CreatedAt",
            fieldType: "DateTime",
        },
        {
            name: "RevisedLifetime",
            fieldType: "UInt32",
        },
    ]
});
class ChannelSecurityToken extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaChannelSecurityToken; }
    static possibleFields = [
        "channelId",
        "tokenId",
        "createdAt",
        "revisedLifetime"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(441, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(443, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(442, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15131, 0);
    channelId;
    tokenId;
    createdAt;
    revisedLifetime;
    constructor(options) {
        super(options);
        if (options === null) {
            this.channelId = 0;
            this.tokenId = 0;
            this.createdAt = new Date();
            this.revisedLifetime = 0;
            return;
        }
        const schema = ChannelSecurityToken.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.channelId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.channelId);
        this.tokenId = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.tokenId);
        this.createdAt = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.createdAt);
        this.revisedLifetime = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.revisedLifetime);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.channelId, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.tokenId, stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.createdAt, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.revisedLifetime, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.channelId = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.channelId);
        this.tokenId = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.tokenId);
        this.createdAt = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.createdAt);
        this.revisedLifetime = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.revisedLifetime);
    }
    get schema() { return schemaChannelSecurityToken; }
}
exports.ChannelSecurityToken = ChannelSecurityToken;
ChannelSecurityToken.schema.dataTypeNodeId = ChannelSecurityToken.dataTypeNodeId;
ChannelSecurityToken.schema.encodingDefaultBinary = ChannelSecurityToken.encodingDefaultBinary;
ChannelSecurityToken.schema.encodingDefaultXml = ChannelSecurityToken.encodingDefaultXml;
ChannelSecurityToken.schema.encodingDefaultJson = ChannelSecurityToken.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ChannelSecurityToken.dataTypeNodeId, "ChannelSecurityToken", ChannelSecurityToken);
// --------------------------------------------------------------------------------------------
const schemaCloseSecureChannelRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "CloseSecureChannelRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",
            fieldType: "RequestHeader",
        },
    ]
});
class CloseSecureChannelRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaCloseSecureChannelRequest; }
    static possibleFields = [
        "requestHeader"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(450, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(452, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(451, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15134, 0);
    requestHeader;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestHeader = new RequestHeader(null);
            return;
        }
        const schema = CloseSecureChannelRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestHeader = new RequestHeader(options.requestHeader);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
    }
    get schema() { return schemaCloseSecureChannelRequest; }
}
exports.CloseSecureChannelRequest = CloseSecureChannelRequest;
CloseSecureChannelRequest.schema.dataTypeNodeId = CloseSecureChannelRequest.dataTypeNodeId;
CloseSecureChannelRequest.schema.encodingDefaultBinary = CloseSecureChannelRequest.encodingDefaultBinary;
CloseSecureChannelRequest.schema.encodingDefaultXml = CloseSecureChannelRequest.encodingDefaultXml;
CloseSecureChannelRequest.schema.encodingDefaultJson = CloseSecureChannelRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(CloseSecureChannelRequest.dataTypeNodeId, "CloseSecureChannelRequest", CloseSecureChannelRequest);
// --------------------------------------------------------------------------------------------
const schemaCloseSecureChannelResponse = (0, node_opcua_factory_1.buildStructuredType)({
    name: "CloseSecureChannelResponse",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",
            fieldType: "ResponseHeader",
        },
    ]
});
class CloseSecureChannelResponse extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaCloseSecureChannelResponse; }
    static possibleFields = [
        "responseHeader"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(453, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(455, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(454, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15135, 0);
    responseHeader;
    constructor(options) {
        super(options);
        if (options === null) {
            this.responseHeader = new ResponseHeader(null);
            return;
        }
        const schema = CloseSecureChannelResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.responseHeader = new ResponseHeader(options.responseHeader);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
    }
    get schema() { return schemaCloseSecureChannelResponse; }
}
exports.CloseSecureChannelResponse = CloseSecureChannelResponse;
CloseSecureChannelResponse.schema.dataTypeNodeId = CloseSecureChannelResponse.dataTypeNodeId;
CloseSecureChannelResponse.schema.encodingDefaultBinary = CloseSecureChannelResponse.encodingDefaultBinary;
CloseSecureChannelResponse.schema.encodingDefaultXml = CloseSecureChannelResponse.encodingDefaultXml;
CloseSecureChannelResponse.schema.encodingDefaultJson = CloseSecureChannelResponse.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(CloseSecureChannelResponse.dataTypeNodeId, "CloseSecureChannelResponse", CloseSecureChannelResponse);
// --------------------------------------------------------------------------------------------
const schemaCloseSessionRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "CloseSessionRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",
            fieldType: "RequestHeader",
        },
        {
            name: "DeleteSubscriptions",
            fieldType: "Boolean",
        },
    ]
});
class CloseSessionRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaCloseSessionRequest; }
    static possibleFields = [
        "requestHeader",
        "deleteSubscriptions"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(471, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(473, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(472, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15147, 0);
    requestHeader;
    deleteSubscriptions;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestHeader = new RequestHeader(null);
            this.deleteSubscriptions = false;
            return;
        }
        const schema = CloseSessionRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestHeader = new RequestHeader(options.requestHeader);
        this.deleteSubscriptions = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.deleteSubscriptions);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.deleteSubscriptions, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.deleteSubscriptions = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.deleteSubscriptions);
    }
    get schema() { return schemaCloseSessionRequest; }
}
exports.CloseSessionRequest = CloseSessionRequest;
CloseSessionRequest.schema.dataTypeNodeId = CloseSessionRequest.dataTypeNodeId;
CloseSessionRequest.schema.encodingDefaultBinary = CloseSessionRequest.encodingDefaultBinary;
CloseSessionRequest.schema.encodingDefaultXml = CloseSessionRequest.encodingDefaultXml;
CloseSessionRequest.schema.encodingDefaultJson = CloseSessionRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(CloseSessionRequest.dataTypeNodeId, "CloseSessionRequest", CloseSessionRequest);
// --------------------------------------------------------------------------------------------
const schemaCloseSessionResponse = (0, node_opcua_factory_1.buildStructuredType)({
    name: "CloseSessionResponse",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",
            fieldType: "ResponseHeader",
        },
    ]
});
class CloseSessionResponse extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaCloseSessionResponse; }
    static possibleFields = [
        "responseHeader"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(474, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(476, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(475, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15148, 0);
    responseHeader;
    constructor(options) {
        super(options);
        if (options === null) {
            this.responseHeader = new ResponseHeader(null);
            return;
        }
        const schema = CloseSessionResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.responseHeader = new ResponseHeader(options.responseHeader);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
    }
    get schema() { return schemaCloseSessionResponse; }
}
exports.CloseSessionResponse = CloseSessionResponse;
CloseSessionResponse.schema.dataTypeNodeId = CloseSessionResponse.dataTypeNodeId;
CloseSessionResponse.schema.encodingDefaultBinary = CloseSessionResponse.encodingDefaultBinary;
CloseSessionResponse.schema.encodingDefaultXml = CloseSessionResponse.encodingDefaultXml;
CloseSessionResponse.schema.encodingDefaultJson = CloseSessionResponse.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(CloseSessionResponse.dataTypeNodeId, "CloseSessionResponse", CloseSessionResponse);
// --------------------------------------------------------------------------------------------
const schemaComplexNumberType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ComplexNumberType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Real",
            fieldType: "Float",
        },
        {
            name: "Imaginary",
            fieldType: "Float",
        },
    ]
});
class ComplexNumberType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaComplexNumberType; }
    static possibleFields = [
        "real",
        "imaginary"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12171, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12181, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12173, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15377, 0);
    real;
    imaginary;
    constructor(options) {
        super(options);
        if (options === null) {
            this.real = 0;
            this.imaginary = 0;
            return;
        }
        const schema = ComplexNumberType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.real = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.real);
        this.imaginary = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.imaginary);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeFloat)(this.real, stream);
        (0, node_opcua_basic_types_1.encodeFloat)(this.imaginary, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.real = (0, node_opcua_basic_types_1.decodeFloat)(stream, this.real);
        this.imaginary = (0, node_opcua_basic_types_1.decodeFloat)(stream, this.imaginary);
    }
    get schema() { return schemaComplexNumberType; }
}
exports.ComplexNumberType = ComplexNumberType;
ComplexNumberType.schema.dataTypeNodeId = ComplexNumberType.dataTypeNodeId;
ComplexNumberType.schema.encodingDefaultBinary = ComplexNumberType.encodingDefaultBinary;
ComplexNumberType.schema.encodingDefaultXml = ComplexNumberType.encodingDefaultXml;
ComplexNumberType.schema.encodingDefaultJson = ComplexNumberType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ComplexNumberType.dataTypeNodeId, "ComplexNumberType", ComplexNumberType);
// --------------------------------------------------------------------------------------------
const schemaConfigurationVersionDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ConfigurationVersionDataType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "MajorVersion",
            fieldType: "UInt32",
        },
        {
            name: "MinorVersion",
            fieldType: "UInt32",
        },
    ]
});
class ConfigurationVersionDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaConfigurationVersionDataType; }
    static possibleFields = [
        "majorVersion",
        "minorVersion"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14593, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14847, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14803, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15049, 0);
    majorVersion;
    minorVersion;
    constructor(options) {
        super(options);
        if (options === null) {
            this.majorVersion = 0;
            this.minorVersion = 0;
            return;
        }
        const schema = ConfigurationVersionDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.majorVersion = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.majorVersion);
        this.minorVersion = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.minorVersion);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.majorVersion, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.minorVersion, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.majorVersion = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.majorVersion);
        this.minorVersion = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.minorVersion);
    }
    get schema() { return schemaConfigurationVersionDataType; }
}
exports.ConfigurationVersionDataType = ConfigurationVersionDataType;
ConfigurationVersionDataType.schema.dataTypeNodeId = ConfigurationVersionDataType.dataTypeNodeId;
ConfigurationVersionDataType.schema.encodingDefaultBinary = ConfigurationVersionDataType.encodingDefaultBinary;
ConfigurationVersionDataType.schema.encodingDefaultXml = ConfigurationVersionDataType.encodingDefaultXml;
ConfigurationVersionDataType.schema.encodingDefaultJson = ConfigurationVersionDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ConfigurationVersionDataType.dataTypeNodeId, "ConfigurationVersionDataType", ConfigurationVersionDataType);
// --------------------------------------------------------------------------------------------
var FilterOperator;
(function (FilterOperator) {
    FilterOperator[FilterOperator["Equals"] = 0] = "Equals";
    FilterOperator[FilterOperator["IsNull"] = 1] = "IsNull";
    FilterOperator[FilterOperator["GreaterThan"] = 2] = "GreaterThan";
    FilterOperator[FilterOperator["LessThan"] = 3] = "LessThan";
    FilterOperator[FilterOperator["GreaterThanOrEqual"] = 4] = "GreaterThanOrEqual";
    FilterOperator[FilterOperator["LessThanOrEqual"] = 5] = "LessThanOrEqual";
    FilterOperator[FilterOperator["Like"] = 6] = "Like";
    FilterOperator[FilterOperator["Not"] = 7] = "Not";
    FilterOperator[FilterOperator["Between"] = 8] = "Between";
    FilterOperator[FilterOperator["InList"] = 9] = "InList";
    FilterOperator[FilterOperator["And"] = 10] = "And";
    FilterOperator[FilterOperator["Or"] = 11] = "Or";
    FilterOperator[FilterOperator["Cast"] = 12] = "Cast";
    FilterOperator[FilterOperator["InView"] = 13] = "InView";
    FilterOperator[FilterOperator["OfType"] = 14] = "OfType";
    FilterOperator[FilterOperator["RelatedTo"] = 15] = "RelatedTo";
    FilterOperator[FilterOperator["BitwiseAnd"] = 16] = "BitwiseAnd";
    FilterOperator[FilterOperator["BitwiseOr"] = 17] = "BitwiseOr";
    FilterOperator[FilterOperator["Invalid"] = 4294967295] = "Invalid";
})(FilterOperator || (exports.FilterOperator = FilterOperator = {}));
const schemaFilterOperator = {
    enumValues: FilterOperator,
    flaggable: false,
    minValue: 0,
    maxValue: 17,
    name: "FilterOperator"
};
function decodeFilterOperator(stream, _value) {
    let value = stream.readUInt32();
    value = (value < schemaFilterOperator.minValue || value > schemaFilterOperator.maxValue) ? FilterOperator.Invalid : value;
    return value;
}
function encodeFilterOperator(value, stream) {
    stream.writeUInt32(value);
}
exports._enumerationFilterOperator = (0, node_opcua_factory_1.registerEnumeration)(schemaFilterOperator);
(0, node_opcua_assert_1.assert)(exports._enumerationFilterOperator.isFlaggable === false);
// --------------------------------------------------------------------------------------------
const schemaContentFilterElement = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ContentFilterElement",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "FilterOperator",
            fieldType: "FilterOperator",
        },
        {
            name: "FilterOperands",
            fieldType: "ExtensionObject",
            isArray: true
        },
    ]
});
class ContentFilterElement extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaContentFilterElement; }
    static possibleFields = [
        "filterOperator",
        "filterOperands"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(583, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(585, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(584, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15204, 0);
    filterOperator;
    filterOperands;
    constructor(options) {
        super(options);
        if (options === null) {
            this.filterOperator = 0;
            this.filterOperands = [];
            return;
        }
        const schema = ContentFilterElement.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.filterOperator = this.setFilterOperator((0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.filterOperator));
        this.filterOperands = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.filterOperands);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        encodeFilterOperator(this.filterOperator, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.filterOperands, stream, node_opcua_extension_object_1.encodeExtensionObject);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.filterOperator = decodeFilterOperator(stream, this.filterOperator);
        this.filterOperands = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_extension_object_1.decodeExtensionObject);
    }
    // Define Enumeration setters
    setFilterOperator(value) {
        const coercedValue = exports._enumerationFilterOperator.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to FilterOperator :" + value);
        }
        this.filterOperator = coercedValue.value;
        return this.filterOperator;
    }
    get schema() { return schemaContentFilterElement; }
}
exports.ContentFilterElement = ContentFilterElement;
ContentFilterElement.schema.dataTypeNodeId = ContentFilterElement.dataTypeNodeId;
ContentFilterElement.schema.encodingDefaultBinary = ContentFilterElement.encodingDefaultBinary;
ContentFilterElement.schema.encodingDefaultXml = ContentFilterElement.encodingDefaultXml;
ContentFilterElement.schema.encodingDefaultJson = ContentFilterElement.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ContentFilterElement.dataTypeNodeId, "ContentFilterElement", ContentFilterElement);
// --------------------------------------------------------------------------------------------
const schemaContentFilter = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ContentFilter",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Elements",
            fieldType: "ContentFilterElement",
            isArray: true
        },
    ]
});
class ContentFilter extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaContentFilter; }
    static possibleFields = [
        "elements"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(586, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(588, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(587, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15205, 0);
    elements;
    constructor(options) {
        super(options);
        if (options === null) {
            this.elements = null; /* null array */
            return;
        }
        const schema = ContentFilter.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.elements = []; // should default
        if (options.elements) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.elements));
            this.elements = options.elements.map((e) => new ContentFilterElement(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.elements, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.elements = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new ContentFilterElement(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaContentFilter; }
}
exports.ContentFilter = ContentFilter;
ContentFilter.schema.dataTypeNodeId = ContentFilter.dataTypeNodeId;
ContentFilter.schema.encodingDefaultBinary = ContentFilter.encodingDefaultBinary;
ContentFilter.schema.encodingDefaultXml = ContentFilter.encodingDefaultXml;
ContentFilter.schema.encodingDefaultJson = ContentFilter.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ContentFilter.dataTypeNodeId, "ContentFilter", ContentFilter);
// --------------------------------------------------------------------------------------------
const schemaContentFilterElementResult = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ContentFilterElementResult",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "StatusCode",
            fieldType: "StatusCode",
        },
        {
            name: "OperandStatusCodes",
            fieldType: "StatusCode",
            isArray: true
        },
        {
            name: "OperandDiagnosticInfos",
            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
class ContentFilterElementResult extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaContentFilterElementResult; }
    static possibleFields = [
        "statusCode",
        "operandStatusCodes",
        "operandDiagnosticInfos"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(604, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(606, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(605, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15211, 0);
    statusCode;
    operandStatusCodes;
    operandDiagnosticInfos;
    constructor(options) {
        super(options);
        if (options === null) {
            this.statusCode = node_opcua_status_code_1.StatusCodes.Good;
            this.operandStatusCodes = [];
            this.operandDiagnosticInfos = [];
            return;
        }
        const schema = ContentFilterElementResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.statusCode = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.statusCode);
        this.operandStatusCodes = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.operandStatusCodes);
        this.operandDiagnosticInfos = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.operandDiagnosticInfos);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_status_code_1.encodeStatusCode)(this.statusCode, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.operandStatusCodes, stream, node_opcua_status_code_1.encodeStatusCode);
        (0, node_opcua_basic_types_1.encodeArray)(this.operandDiagnosticInfos, stream, node_opcua_data_model_1.encodeDiagnosticInfo);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.statusCode = (0, node_opcua_status_code_1.decodeStatusCode)(stream, this.statusCode);
        this.operandStatusCodes = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_status_code_1.decodeStatusCode);
        this.operandDiagnosticInfos = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_data_model_1.decodeDiagnosticInfo);
    }
    get schema() { return schemaContentFilterElementResult; }
}
exports.ContentFilterElementResult = ContentFilterElementResult;
ContentFilterElementResult.schema.dataTypeNodeId = ContentFilterElementResult.dataTypeNodeId;
ContentFilterElementResult.schema.encodingDefaultBinary = ContentFilterElementResult.encodingDefaultBinary;
ContentFilterElementResult.schema.encodingDefaultXml = ContentFilterElementResult.encodingDefaultXml;
ContentFilterElementResult.schema.encodingDefaultJson = ContentFilterElementResult.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ContentFilterElementResult.dataTypeNodeId, "ContentFilterElementResult", ContentFilterElementResult);
// --------------------------------------------------------------------------------------------
const schemaContentFilterResult = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ContentFilterResult",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ElementResults",
            fieldType: "ContentFilterElementResult",
            isArray: true
        },
        {
            name: "ElementDiagnosticInfos",
            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
class ContentFilterResult extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaContentFilterResult; }
    static possibleFields = [
        "elementResults",
        "elementDiagnosticInfos"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(607, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(609, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(608, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15228, 0);
    elementResults;
    elementDiagnosticInfos;
    constructor(options) {
        super(options);
        if (options === null) {
            this.elementResults = null; /* null array */
            this.elementDiagnosticInfos = [];
            return;
        }
        const schema = ContentFilterResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.elementResults = []; // should default
        if (options.elementResults) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.elementResults));
            this.elementResults = options.elementResults.map((e) => new ContentFilterElementResult(e));
        }
        this.elementDiagnosticInfos = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.elementDiagnosticInfos);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.elementResults, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.elementDiagnosticInfos, stream, node_opcua_data_model_1.encodeDiagnosticInfo);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.elementResults = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new ContentFilterElementResult(null);
            obj.decode(stream1);
            return obj;
        });
        this.elementDiagnosticInfos = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_data_model_1.decodeDiagnosticInfo);
    }
    get schema() { return schemaContentFilterResult; }
}
exports.ContentFilterResult = ContentFilterResult;
ContentFilterResult.schema.dataTypeNodeId = ContentFilterResult.dataTypeNodeId;
ContentFilterResult.schema.encodingDefaultBinary = ContentFilterResult.encodingDefaultBinary;
ContentFilterResult.schema.encodingDefaultXml = ContentFilterResult.encodingDefaultXml;
ContentFilterResult.schema.encodingDefaultJson = ContentFilterResult.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ContentFilterResult.dataTypeNodeId, "ContentFilterResult", ContentFilterResult);
// --------------------------------------------------------------------------------------------
const schemaReadValueId = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ReadValueId",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "NodeId",
            fieldType: "NodeId",
        },
        {
            name: "AttributeId",
            fieldType: "UInt32",
        },
        {
            name: "IndexRange",
            fieldType: "NumericRange",
        },
        {
            name: "DataEncoding",
            fieldType: "QualifiedName",
        },
    ]
});
class ReadValueId extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaReadValueId; }
    static possibleFields = [
        "nodeId",
        "attributeId",
        "indexRange",
        "dataEncoding"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(626, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(628, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(627, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15256, 0);
    nodeId;
    attributeId;
    indexRange;
    dataEncoding;
    constructor(options) {
        super(options);
        if (options === null) {
            this.nodeId = new node_opcua_nodeid_1.NodeId(null);
            this.attributeId = 0;
            this.indexRange = new node_opcua_numeric_range_1.NumericRange(null);
            this.dataEncoding = new node_opcua_data_model_1.QualifiedName(null);
            return;
        }
        const schema = ReadValueId.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.nodeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.nodeId);
        this.attributeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.attributeId);
        this.indexRange = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.indexRange);
        this.dataEncoding = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.dataEncoding);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.nodeId, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.attributeId, stream);
        (0, node_opcua_numeric_range_1.encodeNumericRange)(this.indexRange, stream);
        (0, node_opcua_data_model_1.encodeQualifiedName)(this.dataEncoding, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.nodeId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.nodeId);
        this.attributeId = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.attributeId);
        this.indexRange = (0, node_opcua_numeric_range_1.decodeNumericRange)(stream, this.indexRange);
        this.dataEncoding = (0, node_opcua_data_model_1.decodeQualifiedName)(stream, this.dataEncoding);
    }
    get schema() { return schemaReadValueId; }
}
exports.ReadValueId = ReadValueId;
ReadValueId.schema.dataTypeNodeId = ReadValueId.dataTypeNodeId;
ReadValueId.schema.encodingDefaultBinary = ReadValueId.encodingDefaultBinary;
ReadValueId.schema.encodingDefaultXml = ReadValueId.encodingDefaultXml;
ReadValueId.schema.encodingDefaultJson = ReadValueId.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ReadValueId.dataTypeNodeId, "ReadValueId", ReadValueId);
// --------------------------------------------------------------------------------------------
var MonitoringMode;
(function (MonitoringMode) {
    MonitoringMode[MonitoringMode["Disabled"] = 0] = "Disabled";
    MonitoringMode[MonitoringMode["Sampling"] = 1] = "Sampling";
    MonitoringMode[MonitoringMode["Reporting"] = 2] = "Reporting";
    MonitoringMode[MonitoringMode["Invalid"] = 4294967295] = "Invalid";
})(MonitoringMode || (exports.MonitoringMode = MonitoringMode = {}));
const schemaMonitoringMode = {
    enumValues: MonitoringMode,
    flaggable: false,
    minValue: 0,
    maxValue: 2,
    name: "MonitoringMode"
};
function decodeMonitoringMode(stream, _value) {
    let value = stream.readUInt32();
    value = (value < schemaMonitoringMode.minValue || value > schemaMonitoringMode.maxValue) ? MonitoringMode.Invalid : value;
    return value;
}
function encodeMonitoringMode(value, stream) {
    stream.writeUInt32(value);
}
exports._enumerationMonitoringMode = (0, node_opcua_factory_1.registerEnumeration)(schemaMonitoringMode);
(0, node_opcua_assert_1.assert)(exports._enumerationMonitoringMode.isFlaggable === false);
// --------------------------------------------------------------------------------------------
const schemaMonitoringParameters = (0, node_opcua_factory_1.buildStructuredType)({
    name: "MonitoringParameters",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ClientHandle",
            fieldType: "UInt32",
        },
        {
            name: "SamplingInterval",
            fieldType: "Double",
        },
        {
            name: "Filter",
            fieldType: "ExtensionObject",
        },
        {
            name: "QueueSize",
            fieldType: "UInt32",
        },
        {
            name: "DiscardOldest",
            fieldType: "Boolean",
        },
    ]
});
class MonitoringParameters extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaMonitoringParameters; }
    static possibleFields = [
        "clientHandle",
        "samplingInterval",
        "filter",
        "queueSize",
        "discardOldest"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(740, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(742, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(741, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15320, 0);
    clientHandle;
    samplingInterval;
    filter;
    queueSize;
    discardOldest;
    constructor(options) {
        super(options);
        if (options === null) {
            this.clientHandle = 0;
            this.samplingInterval = 0;
            this.filter = null;
            this.queueSize = 0;
            this.discardOldest = false;
            return;
        }
        const schema = MonitoringParameters.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.clientHandle = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.clientHandle);
        this.samplingInterval = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.samplingInterval);
        this.filter = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.filter);
        this.queueSize = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.queueSize);
        this.discardOldest = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.discardOldest);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.clientHandle, stream);
        (0, node_opcua_basic_types_1.encodeDouble)(this.samplingInterval, stream);
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.filter, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.queueSize, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.discardOldest, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.clientHandle = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.clientHandle);
        this.samplingInterval = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.samplingInterval);
        this.filter = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.filter);
        this.queueSize = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.queueSize);
        this.discardOldest = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.discardOldest);
    }
    get schema() { return schemaMonitoringParameters; }
}
exports.MonitoringParameters = MonitoringParameters;
MonitoringParameters.schema.dataTypeNodeId = MonitoringParameters.dataTypeNodeId;
MonitoringParameters.schema.encodingDefaultBinary = MonitoringParameters.encodingDefaultBinary;
MonitoringParameters.schema.encodingDefaultXml = MonitoringParameters.encodingDefaultXml;
MonitoringParameters.schema.encodingDefaultJson = MonitoringParameters.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(MonitoringParameters.dataTypeNodeId, "MonitoringParameters", MonitoringParameters);
// --------------------------------------------------------------------------------------------
const schemaMonitoredItemCreateRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "MonitoredItemCreateRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ItemToMonitor",
            fieldType: "ReadValueId",
        },
        {
            name: "MonitoringMode",
            fieldType: "MonitoringMode",
        },
        {
            name: "RequestedParameters",
            fieldType: "MonitoringParameters",
        },
    ]
});
class MonitoredItemCreateRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaMonitoredItemCreateRequest; }
    static possibleFields = [
        "itemToMonitor",
        "monitoringMode",
        "requestedParameters"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(743, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(745, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(744, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15321, 0);
    itemToMonitor;
    monitoringMode;
    requestedParameters;
    constructor(options) {
        super(options);
        if (options === null) {
            this.itemToMonitor = new ReadValueId(null);
            this.monitoringMode = 0;
            this.requestedParameters = new MonitoringParameters(null);
            return;
        }
        const schema = MonitoredItemCreateRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.itemToMonitor = new ReadValueId(options.itemToMonitor);
        this.monitoringMode = this.setMonitoringMode((0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.monitoringMode));
        this.requestedParameters = new MonitoringParameters(options.requestedParameters);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.itemToMonitor.encode(stream);
        encodeMonitoringMode(this.monitoringMode, stream);
        this.requestedParameters.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.itemToMonitor.decode(stream);
        this.monitoringMode = decodeMonitoringMode(stream, this.monitoringMode);
        this.requestedParameters.decode(stream);
    }
    // Define Enumeration setters
    setMonitoringMode(value) {
        const coercedValue = exports._enumerationMonitoringMode.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to MonitoringMode :" + value);
        }
        this.monitoringMode = coercedValue.value;
        return this.monitoringMode;
    }
    get schema() { return schemaMonitoredItemCreateRequest; }
}
exports.MonitoredItemCreateRequest = MonitoredItemCreateRequest;
MonitoredItemCreateRequest.schema.dataTypeNodeId = MonitoredItemCreateRequest.dataTypeNodeId;
MonitoredItemCreateRequest.schema.encodingDefaultBinary = MonitoredItemCreateRequest.encodingDefaultBinary;
MonitoredItemCreateRequest.schema.encodingDefaultXml = MonitoredItemCreateRequest.encodingDefaultXml;
MonitoredItemCreateRequest.schema.encodingDefaultJson = MonitoredItemCreateRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(MonitoredItemCreateRequest.dataTypeNodeId, "MonitoredItemCreateRequest", MonitoredItemCreateRequest);
// --------------------------------------------------------------------------------------------
const schemaCreateMonitoredItemsRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "CreateMonitoredItemsRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",
            fieldType: "RequestHeader",
        },
        {
            name: "SubscriptionId",
            fieldType: "UInt32",
        },
        {
            name: "TimestampsToReturn",
            fieldType: "TimestampsToReturn",
        },
        {
            name: "ItemsToCreate",
            fieldType: "MonitoredItemCreateRequest",
            isArray: true
        },
    ]
});
class CreateMonitoredItemsRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaCreateMonitoredItemsRequest; }
    static possibleFields = [
        "requestHeader",
        "subscriptionId",
        "timestampsToReturn",
        "itemsToCreate"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(749, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(751, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(750, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15323, 0);
    requestHeader;
    subscriptionId;
    timestampsToReturn;
    itemsToCreate;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestHeader = new RequestHeader(null);
            this.subscriptionId = 0;
            this.timestampsToReturn = 0;
            this.itemsToCreate = null; /* null array */
            return;
        }
        const schema = CreateMonitoredItemsRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestHeader = new RequestHeader(options.requestHeader);
        this.subscriptionId = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.subscriptionId);
        this.timestampsToReturn = this.setTimestampsToReturn((0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.timestampsToReturn));
        this.itemsToCreate = []; // should default
        if (options.itemsToCreate) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.itemsToCreate));
            this.itemsToCreate = options.itemsToCreate.map((e) => new MonitoredItemCreateRequest(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.subscriptionId, stream);
        (0, node_opcua_data_value_1.encodeTimestampsToReturn)(this.timestampsToReturn, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.itemsToCreate, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.subscriptionId = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.subscriptionId);
        this.timestampsToReturn = (0, node_opcua_data_value_1.decodeTimestampsToReturn)(stream, this.timestampsToReturn);
        this.itemsToCreate = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new MonitoredItemCreateRequest(null);
            obj.decode(stream1);
            return obj;
        });
    }
    // Define Enumeration setters
    setTimestampsToReturn(value) {
        const coercedValue = node_opcua_data_value_1._enumerationTimestampsToReturn.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to TimestampsToReturn :" + value);
        }
        this.timestampsToReturn = coercedValue.value;
        return this.timestampsToReturn;
    }
    get schema() { return schemaCreateMonitoredItemsRequest; }
}
exports.CreateMonitoredItemsRequest = CreateMonitoredItemsRequest;
CreateMonitoredItemsRequest.schema.dataTypeNodeId = CreateMonitoredItemsRequest.dataTypeNodeId;
CreateMonitoredItemsRequest.schema.encodingDefaultBinary = CreateMonitoredItemsRequest.encodingDefaultBinary;
CreateMonitoredItemsRequest.schema.encodingDefaultXml = CreateMonitoredItemsRequest.encodingDefaultXml;
CreateMonitoredItemsRequest.schema.encodingDefaultJson = CreateMonitoredItemsRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(CreateMonitoredItemsRequest.dataTypeNodeId, "CreateMonitoredItemsRequest", CreateMonitoredItemsRequest);
// --------------------------------------------------------------------------------------------
const schemaMonitoredItemCreateResult = (0, node_opcua_factory_1.buildStructuredType)({
    name: "MonitoredItemCreateResult",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "StatusCode",
            fieldType: "StatusCode",
        },
        {
            name: "MonitoredItemId",
            fieldType: "UInt32",
        },
        {
            name: "RevisedSamplingInterval",
            fieldType: "Double",
        },
        {
            name: "RevisedQueueSize",
            fieldType: "UInt32",
        },
        {
            name: "FilterResult",
            fieldType: "ExtensionObject",
        },
    ]
});
class MonitoredItemCreateResult extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaMonitoredItemCreateResult; }
    static possibleFields = [
        "statusCode",
        "monitoredItemId",
        "revisedSamplingInterval",
        "revisedQueueSize",
        "filterResult"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(746, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(748, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(747, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15322, 0);
    statusCode;
    monitoredItemId;
    revisedSamplingInterval;
    revisedQueueSize;
    filterResult;
    constructor(options) {
        super(options);
        if (options === null) {
            this.statusCode = node_opcua_status_code_1.StatusCodes.Good;
            this.monitoredItemId = 0;
            this.revisedSamplingInterval = 0;
            this.revisedQueueSize = 0;
            this.filterResult = null;
            return;
        }
        const schema = MonitoredItemCreateResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.statusCode = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.statusCode);
        this.monitoredItemId = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.monitoredItemId);
        this.revisedSamplingInterval = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.revisedSamplingInterval);
        this.revisedQueueSize = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.revisedQueueSize);
        this.filterResult = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.filterResult);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_status_code_1.encodeStatusCode)(this.statusCode, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.monitoredItemId, stream);
        (0, node_opcua_basic_types_1.encodeDouble)(this.revisedSamplingInterval, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.revisedQueueSize, stream);
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.filterResult, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.statusCode = (0, node_opcua_status_code_1.decodeStatusCode)(stream, this.statusCode);
        this.monitoredItemId = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.monitoredItemId);
        this.revisedSamplingInterval = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.revisedSamplingInterval);
        this.revisedQueueSize = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.revisedQueueSize);
        this.filterResult = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.filterResult);
    }
    get schema() { return schemaMonitoredItemCreateResult; }
}
exports.MonitoredItemCreateResult = MonitoredItemCreateResult;
MonitoredItemCreateResult.schema.dataTypeNodeId = MonitoredItemCreateResult.dataTypeNodeId;
MonitoredItemCreateResult.schema.encodingDefaultBinary = MonitoredItemCreateResult.encodingDefaultBinary;
MonitoredItemCreateResult.schema.encodingDefaultXml = MonitoredItemCreateResult.encodingDefaultXml;
MonitoredItemCreateResult.schema.encodingDefaultJson = MonitoredItemCreateResult.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(MonitoredItemCreateResult.dataTypeNodeId, "MonitoredItemCreateResult", MonitoredItemCreateResult);
// --------------------------------------------------------------------------------------------
const schemaCreateMonitoredItemsResponse = (0, node_opcua_factory_1.buildStructuredType)({
    name: "CreateMonitoredItemsResponse",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",
            fieldType: "ResponseHeader",
        },
        {
            name: "Results",
            fieldType: "MonitoredItemCreateResult",
            isArray: true
        },
        {
            name: "DiagnosticInfos",
            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
class CreateMonitoredItemsResponse extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaCreateMonitoredItemsResponse; }
    static possibleFields = [
        "responseHeader",
        "results",
        "diagnosticInfos"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(752, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(754, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(753, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15324, 0);
    responseHeader;
    results;
    diagnosticInfos;
    constructor(options) {
        super(options);
        if (options === null) {
            this.responseHeader = new ResponseHeader(null);
            this.results = null; /* null array */
            this.diagnosticInfos = [];
            return;
        }
        const schema = CreateMonitoredItemsResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.responseHeader = new ResponseHeader(options.responseHeader);
        this.results = []; // should default
        if (options.results) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.results));
            this.results = options.results.map((e) => new MonitoredItemCreateResult(e));
        }
        this.diagnosticInfos = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.diagnosticInfos);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.results, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.diagnosticInfos, stream, node_opcua_data_model_1.encodeDiagnosticInfo);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new MonitoredItemCreateResult(null);
            obj.decode(stream1);
            return obj;
        });
        this.diagnosticInfos = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_data_model_1.decodeDiagnosticInfo);
    }
    get schema() { return schemaCreateMonitoredItemsResponse; }
}
exports.CreateMonitoredItemsResponse = CreateMonitoredItemsResponse;
CreateMonitoredItemsResponse.schema.dataTypeNodeId = CreateMonitoredItemsResponse.dataTypeNodeId;
CreateMonitoredItemsResponse.schema.encodingDefaultBinary = CreateMonitoredItemsResponse.encodingDefaultBinary;
CreateMonitoredItemsResponse.schema.encodingDefaultXml = CreateMonitoredItemsResponse.encodingDefaultXml;
CreateMonitoredItemsResponse.schema.encodingDefaultJson = CreateMonitoredItemsResponse.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(CreateMonitoredItemsResponse.dataTypeNodeId, "CreateMonitoredItemsResponse", CreateMonitoredItemsResponse);
// --------------------------------------------------------------------------------------------
const schemaCreateSessionRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "CreateSessionRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",
            fieldType: "RequestHeader",
        },
        {
            name: "ClientDescription",
            fieldType: "ApplicationDescription",
        },
        {
            name: "ServerUri",
            fieldType: "String",
        },
        {
            name: "EndpointUrl",
            fieldType: "String",
        },
        {
            name: "SessionName",
            fieldType: "String",
        },
        {
            name: "ClientNonce",
            fieldType: "ByteString",
        },
        {
            name: "ClientCertificate",
            fieldType: "ByteString",
        },
        {
            name: "RequestedSessionTimeout",
            fieldType: "Double",
        },
        {
            name: "MaxResponseMessageSize",
            fieldType: "UInt32",
        },
    ]
});
class CreateSessionRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaCreateSessionRequest; }
    static possibleFields = [
        "requestHeader",
        "clientDescription",
        "serverUri",
        "endpointUrl",
        "sessionName",
        "clientNonce",
        "clientCertificate",
        "requestedSessionTimeout",
        "maxResponseMessageSize"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(459, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(461, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(460, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15138, 0);
    requestHeader;
    clientDescription;
    serverUri;
    endpointUrl;
    sessionName;
    clientNonce;
    clientCertificate;
    requestedSessionTimeout;
    maxResponseMessageSize;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestHeader = new RequestHeader(null);
            this.clientDescription = new ApplicationDescription(null);
            this.serverUri = null;
            this.endpointUrl = null;
            this.sessionName = null;
            this.clientNonce = Buffer.alloc(0);
            this.clientCertificate = Buffer.alloc(0);
            this.requestedSessionTimeout = 0;
            this.maxResponseMessageSize = 0;
            return;
        }
        const schema = CreateSessionRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestHeader = new RequestHeader(options.requestHeader);
        this.clientDescription = new ApplicationDescription(options.clientDescription);
        this.serverUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.serverUri);
        this.endpointUrl = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.endpointUrl);
        this.sessionName = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.sessionName);
        this.clientNonce = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.clientNonce);
        this.clientCertificate = (0, node_opcua_factory_1.initialize_field)(schema.fields[6], options?.clientCertificate);
        this.requestedSessionTimeout = (0, node_opcua_factory_1.initialize_field)(schema.fields[7], options?.requestedSessionTimeout);
        this.maxResponseMessageSize = (0, node_opcua_factory_1.initialize_field)(schema.fields[8], options?.maxResponseMessageSize);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        this.clientDescription.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.serverUri, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.endpointUrl, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.sessionName, stream);
        (0, node_opcua_basic_types_1.encodeByteString)(this.clientNonce, stream);
        (0, node_opcua_basic_types_1.encodeByteString)(this.clientCertificate, stream);
        (0, node_opcua_basic_types_1.encodeDouble)(this.requestedSessionTimeout, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.maxResponseMessageSize, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.clientDescription.decode(stream);
        this.serverUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.serverUri);
        this.endpointUrl = (0, node_opcua_basic_types_1.decodeString)(stream, this.endpointUrl);
        this.sessionName = (0, node_opcua_basic_types_1.decodeString)(stream, this.sessionName);
        this.clientNonce = (0, node_opcua_basic_types_1.decodeByteString)(stream, this.clientNonce);
        this.clientCertificate = (0, node_opcua_basic_types_1.decodeByteString)(stream, this.clientCertificate);
        this.requestedSessionTimeout = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.requestedSessionTimeout);
        this.maxResponseMessageSize = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.maxResponseMessageSize);
    }
    get schema() { return schemaCreateSessionRequest; }
}
exports.CreateSessionRequest = CreateSessionRequest;
CreateSessionRequest.schema.dataTypeNodeId = CreateSessionRequest.dataTypeNodeId;
CreateSessionRequest.schema.encodingDefaultBinary = CreateSessionRequest.encodingDefaultBinary;
CreateSessionRequest.schema.encodingDefaultXml = CreateSessionRequest.encodingDefaultXml;
CreateSessionRequest.schema.encodingDefaultJson = CreateSessionRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(CreateSessionRequest.dataTypeNodeId, "CreateSessionRequest", CreateSessionRequest);
// --------------------------------------------------------------------------------------------
var MessageSecurityMode;
(function (MessageSecurityMode) {
    MessageSecurityMode[MessageSecurityMode["Invalid"] = 0] = "Invalid";
    MessageSecurityMode[MessageSecurityMode["None"] = 1] = "None";
    MessageSecurityMode[MessageSecurityMode["Sign"] = 2] = "Sign";
    MessageSecurityMode[MessageSecurityMode["SignAndEncrypt"] = 3] = "SignAndEncrypt";
})(MessageSecurityMode || (exports.MessageSecurityMode = MessageSecurityMode = {}));
const schemaMessageSecurityMode = {
    enumValues: MessageSecurityMode,
    flaggable: false,
    minValue: 0,
    maxValue: 3,
    name: "MessageSecurityMode"
};
function decodeMessageSecurityMode(stream, _value) {
    let value = stream.readUInt32();
    value = (value < schemaMessageSecurityMode.minValue || value > schemaMessageSecurityMode.maxValue) ? MessageSecurityMode.Invalid : value;
    return value;
}
function encodeMessageSecurityMode(value, stream) {
    stream.writeUInt32(value);
}
exports._enumerationMessageSecurityMode = (0, node_opcua_factory_1.registerEnumeration)(schemaMessageSecurityMode);
(0, node_opcua_assert_1.assert)(exports._enumerationMessageSecurityMode.isFlaggable === false);
// --------------------------------------------------------------------------------------------
var UserTokenType;
(function (UserTokenType) {
    UserTokenType[UserTokenType["Anonymous"] = 0] = "Anonymous";
    UserTokenType[UserTokenType["UserName"] = 1] = "UserName";
    UserTokenType[UserTokenType["Certificate"] = 2] = "Certificate";
    UserTokenType[UserTokenType["IssuedToken"] = 3] = "IssuedToken";
    UserTokenType[UserTokenType["Invalid"] = 4294967295] = "Invalid";
})(UserTokenType || (exports.UserTokenType = UserTokenType = {}));
const schemaUserTokenType = {
    enumValues: UserTokenType,
    flaggable: false,
    minValue: 0,
    maxValue: 3,
    name: "UserTokenType"
};
function decodeUserTokenType(stream, _value) {
    let value = stream.readUInt32();
    value = (value < schemaUserTokenType.minValue || value > schemaUserTokenType.maxValue) ? UserTokenType.Invalid : value;
    return value;
}
function encodeUserTokenType(value, stream) {
    stream.writeUInt32(value);
}
exports._enumerationUserTokenType = (0, node_opcua_factory_1.registerEnumeration)(schemaUserTokenType);
(0, node_opcua_assert_1.assert)(exports._enumerationUserTokenType.isFlaggable === false);
// --------------------------------------------------------------------------------------------
const schemaUserTokenPolicy = (0, node_opcua_factory_1.buildStructuredType)({
    name: "UserTokenPolicy",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "PolicyId",
            fieldType: "String",
        },
        {
            name: "TokenType",
            fieldType: "UserTokenType",
        },
        {
            name: "IssuedTokenType",
            fieldType: "String",
        },
        {
            name: "IssuerEndpointUrl",
            fieldType: "String",
        },
        {
            name: "SecurityPolicyUri",
            fieldType: "String",
        },
    ]
});
class UserTokenPolicy extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaUserTokenPolicy; }
    static possibleFields = [
        "policyId",
        "tokenType",
        "issuedTokenType",
        "issuerEndpointUrl",
        "securityPolicyUri"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(304, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(306, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(305, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15098, 0);
    policyId;
    tokenType;
    issuedTokenType;
    issuerEndpointUrl;
    securityPolicyUri;
    constructor(options) {
        super(options);
        if (options === null) {
            this.policyId = null;
            this.tokenType = 0;
            this.issuedTokenType = null;
            this.issuerEndpointUrl = null;
            this.securityPolicyUri = null;
            return;
        }
        const schema = UserTokenPolicy.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.policyId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.policyId);
        this.tokenType = this.setTokenType((0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.tokenType));
        this.issuedTokenType = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.issuedTokenType);
        this.issuerEndpointUrl = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.issuerEndpointUrl);
        this.securityPolicyUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.securityPolicyUri);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.policyId, stream);
        encodeUserTokenType(this.tokenType, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.issuedTokenType, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.issuerEndpointUrl, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.securityPolicyUri, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.policyId = (0, node_opcua_basic_types_1.decodeString)(stream, this.policyId);
        this.tokenType = decodeUserTokenType(stream, this.tokenType);
        this.issuedTokenType = (0, node_opcua_basic_types_1.decodeString)(stream, this.issuedTokenType);
        this.issuerEndpointUrl = (0, node_opcua_basic_types_1.decodeString)(stream, this.issuerEndpointUrl);
        this.securityPolicyUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.securityPolicyUri);
    }
    // Define Enumeration setters
    setTokenType(value) {
        const coercedValue = exports._enumerationUserTokenType.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to UserTokenType :" + value);
        }
        this.tokenType = coercedValue.value;
        return this.tokenType;
    }
    get schema() { return schemaUserTokenPolicy; }
}
exports.UserTokenPolicy = UserTokenPolicy;
UserTokenPolicy.schema.dataTypeNodeId = UserTokenPolicy.dataTypeNodeId;
UserTokenPolicy.schema.encodingDefaultBinary = UserTokenPolicy.encodingDefaultBinary;
UserTokenPolicy.schema.encodingDefaultXml = UserTokenPolicy.encodingDefaultXml;
UserTokenPolicy.schema.encodingDefaultJson = UserTokenPolicy.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(UserTokenPolicy.dataTypeNodeId, "UserTokenPolicy", UserTokenPolicy);
// --------------------------------------------------------------------------------------------
const schemaEndpointDescription = (0, node_opcua_factory_1.buildStructuredType)({
    name: "EndpointDescription",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "EndpointUrl",
            fieldType: "String",
        },
        {
            name: "Server",
            fieldType: "ApplicationDescription",
        },
        {
            name: "ServerCertificate",
            fieldType: "ByteString",
        },
        {
            name: "SecurityMode",
            fieldType: "MessageSecurityMode",
        },
        {
            name: "SecurityPolicyUri",
            fieldType: "String",
        },
        {
            name: "UserIdentityTokens",
            fieldType: "UserTokenPolicy",
            isArray: true
        },
        {
            name: "TransportProfileUri",
            fieldType: "String",
        },
        {
            name: "SecurityLevel",
            fieldType: "Byte",
        },
    ]
});
class EndpointDescription extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaEndpointDescription; }
    static possibleFields = [
        "endpointUrl",
        "server",
        "serverCertificate",
        "securityMode",
        "securityPolicyUri",
        "userIdentityTokens",
        "transportProfileUri",
        "securityLevel"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(312, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(314, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(313, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15099, 0);
    endpointUrl;
    server;
    serverCertificate;
    securityMode;
    securityPolicyUri;
    userIdentityTokens;
    transportProfileUri;
    securityLevel;
    constructor(options) {
        super(options);
        if (options === null) {
            this.endpointUrl = null;
            this.server = new ApplicationDescription(null);
            this.serverCertificate = Buffer.alloc(0);
            this.securityMode = 0;
            this.securityPolicyUri = null;
            this.userIdentityTokens = null; /* null array */
            this.transportProfileUri = null;
            this.securityLevel = 0;
            return;
        }
        const schema = EndpointDescription.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.endpointUrl = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.endpointUrl);
        this.server = new ApplicationDescription(options.server);
        this.serverCertificate = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.serverCertificate);
        this.securityMode = this.setSecurityMode((0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.securityMode));
        this.securityPolicyUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.securityPolicyUri);
        this.userIdentityTokens = []; // should default
        if (options.userIdentityTokens) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.userIdentityTokens));
            this.userIdentityTokens = options.userIdentityTokens.map((e) => new UserTokenPolicy(e));
        }
        this.transportProfileUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[6], options?.transportProfileUri);
        this.securityLevel = (0, node_opcua_factory_1.initialize_field)(schema.fields[7], options?.securityLevel);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.endpointUrl, stream);
        this.server.encode(stream);
        (0, node_opcua_basic_types_1.encodeByteString)(this.serverCertificate, stream);
        encodeMessageSecurityMode(this.securityMode, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.securityPolicyUri, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.userIdentityTokens, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeString)(this.transportProfileUri, stream);
        (0, node_opcua_basic_types_1.encodeByte)(this.securityLevel, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.endpointUrl = (0, node_opcua_basic_types_1.decodeString)(stream, this.endpointUrl);
        this.server.decode(stream);
        this.serverCertificate = (0, node_opcua_basic_types_1.decodeByteString)(stream, this.serverCertificate);
        this.securityMode = decodeMessageSecurityMode(stream, this.securityMode);
        this.securityPolicyUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.securityPolicyUri);
        this.userIdentityTokens = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new UserTokenPolicy(null);
            obj.decode(stream1);
            return obj;
        });
        this.transportProfileUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.transportProfileUri);
        this.securityLevel = (0, node_opcua_basic_types_1.decodeByte)(stream, this.securityLevel);
    }
    // Define Enumeration setters
    setSecurityMode(value) {
        const coercedValue = exports._enumerationMessageSecurityMode.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to MessageSecurityMode :" + value);
        }
        this.securityMode = coercedValue.value;
        return this.securityMode;
    }
    get schema() { return schemaEndpointDescription; }
}
exports.EndpointDescription = EndpointDescription;
EndpointDescription.schema.dataTypeNodeId = EndpointDescription.dataTypeNodeId;
EndpointDescription.schema.encodingDefaultBinary = EndpointDescription.encodingDefaultBinary;
EndpointDescription.schema.encodingDefaultXml = EndpointDescription.encodingDefaultXml;
EndpointDescription.schema.encodingDefaultJson = EndpointDescription.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(EndpointDescription.dataTypeNodeId, "EndpointDescription", EndpointDescription);
// --------------------------------------------------------------------------------------------
const schemaCreateSessionResponse = (0, node_opcua_factory_1.buildStructuredType)({
    name: "CreateSessionResponse",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",
            fieldType: "ResponseHeader",
        },
        {
            name: "SessionId",
            fieldType: "NodeId",
        },
        {
            name: "AuthenticationToken",
            fieldType: "NodeId",
        },
        {
            name: "RevisedSessionTimeout",
            fieldType: "Double",
        },
        {
            name: "ServerNonce",
            fieldType: "ByteString",
        },
        {
            name: "ServerCertificate",
            fieldType: "ByteString",
        },
        {
            name: "ServerEndpoints",
            fieldType: "EndpointDescription",
            isArray: true
        },
        {
            name: "ServerSoftwareCertificates",
            fieldType: "SignedSoftwareCertificate",
            isArray: true
        },
        {
            name: "ServerSignature",
            fieldType: "SignatureData",
        },
        {
            name: "MaxRequestMessageSize",
            fieldType: "UInt32",
        },
    ]
});
class CreateSessionResponse extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaCreateSessionResponse; }
    static possibleFields = [
        "responseHeader",
        "sessionId",
        "authenticationToken",
        "revisedSessionTimeout",
        "serverNonce",
        "serverCertificate",
        "serverEndpoints",
        "serverSoftwareCertificates",
        "serverSignature",
        "maxRequestMessageSize"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(462, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(464, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(463, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15139, 0);
    responseHeader;
    sessionId;
    authenticationToken;
    revisedSessionTimeout;
    serverNonce;
    serverCertificate;
    serverEndpoints;
    serverSoftwareCertificates;
    serverSignature;
    maxRequestMessageSize;
    constructor(options) {
        super(options);
        if (options === null) {
            this.responseHeader = new ResponseHeader(null);
            this.sessionId = new node_opcua_nodeid_1.NodeId(null);
            this.authenticationToken = new node_opcua_nodeid_1.NodeId(null);
            this.revisedSessionTimeout = 0;
            this.serverNonce = Buffer.alloc(0);
            this.serverCertificate = Buffer.alloc(0);
            this.serverEndpoints = null; /* null array */
            this.serverSoftwareCertificates = null; /* null array */
            this.serverSignature = new SignatureData(null);
            this.maxRequestMessageSize = 0;
            return;
        }
        const schema = CreateSessionResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.responseHeader = new ResponseHeader(options.responseHeader);
        this.sessionId = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.sessionId);
        this.authenticationToken = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.authenticationToken);
        this.revisedSessionTimeout = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.revisedSessionTimeout);
        this.serverNonce = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.serverNonce);
        this.serverCertificate = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.serverCertificate);
        this.serverEndpoints = []; // should default
        if (options.serverEndpoints) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.serverEndpoints));
            this.serverEndpoints = options.serverEndpoints.map((e) => new EndpointDescription(e));
        }
        this.serverSoftwareCertificates = []; // should default
        if (options.serverSoftwareCertificates) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.serverSoftwareCertificates));
            this.serverSoftwareCertificates = options.serverSoftwareCertificates.map((e) => new SignedSoftwareCertificate(e));
        }
        this.serverSignature = new SignatureData(options.serverSignature);
        this.maxRequestMessageSize = (0, node_opcua_factory_1.initialize_field)(schema.fields[9], options?.maxRequestMessageSize);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.sessionId, stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.authenticationToken, stream);
        (0, node_opcua_basic_types_1.encodeDouble)(this.revisedSessionTimeout, stream);
        (0, node_opcua_basic_types_1.encodeByteString)(this.serverNonce, stream);
        (0, node_opcua_basic_types_1.encodeByteString)(this.serverCertificate, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.serverEndpoints, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.serverSoftwareCertificates, stream, (obj, stream1) => { obj.encode(stream1); });
        this.serverSignature.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.maxRequestMessageSize, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.sessionId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.sessionId);
        this.authenticationToken = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.authenticationToken);
        this.revisedSessionTimeout = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.revisedSessionTimeout);
        this.serverNonce = (0, node_opcua_basic_types_1.decodeByteString)(stream, this.serverNonce);
        this.serverCertificate = (0, node_opcua_basic_types_1.decodeByteString)(stream, this.serverCertificate);
        this.serverEndpoints = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new EndpointDescription(null);
            obj.decode(stream1);
            return obj;
        });
        this.serverSoftwareCertificates = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new SignedSoftwareCertificate(null);
            obj.decode(stream1);
            return obj;
        });
        this.serverSignature.decode(stream);
        this.maxRequestMessageSize = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.maxRequestMessageSize);
    }
    get schema() { return schemaCreateSessionResponse; }
}
exports.CreateSessionResponse = CreateSessionResponse;
CreateSessionResponse.schema.dataTypeNodeId = CreateSessionResponse.dataTypeNodeId;
CreateSessionResponse.schema.encodingDefaultBinary = CreateSessionResponse.encodingDefaultBinary;
CreateSessionResponse.schema.encodingDefaultXml = CreateSessionResponse.encodingDefaultXml;
CreateSessionResponse.schema.encodingDefaultJson = CreateSessionResponse.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(CreateSessionResponse.dataTypeNodeId, "CreateSessionResponse", CreateSessionResponse);
// --------------------------------------------------------------------------------------------
const schemaCreateSubscriptionRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "CreateSubscriptionRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",
            fieldType: "RequestHeader",
        },
        {
            name: "RequestedPublishingInterval",
            fieldType: "Double",
        },
        {
            name: "RequestedLifetimeCount",
            fieldType: "UInt32",
        },
        {
            name: "RequestedMaxKeepAliveCount",
            fieldType: "UInt32",
        },
        {
            name: "MaxNotificationsPerPublish",
            fieldType: "UInt32",
        },
        {
            name: "PublishingEnabled",
            fieldType: "Boolean",
        },
        {
            name: "Priority",
            fieldType: "Byte",
        },
    ]
});
class CreateSubscriptionRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaCreateSubscriptionRequest; }
    static possibleFields = [
        "requestHeader",
        "requestedPublishingInterval",
        "requestedLifetimeCount",
        "requestedMaxKeepAliveCount",
        "maxNotificationsPerPublish",
        "publishingEnabled",
        "priority"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(785, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(787, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(786, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15337, 0);
    requestHeader;
    requestedPublishingInterval;
    requestedLifetimeCount;
    requestedMaxKeepAliveCount;
    maxNotificationsPerPublish;
    publishingEnabled;
    priority;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestHeader = new RequestHeader(null);
            this.requestedPublishingInterval = 0;
            this.requestedLifetimeCount = 0;
            this.requestedMaxKeepAliveCount = 0;
            this.maxNotificationsPerPublish = 0;
            this.publishingEnabled = false;
            this.priority = 0;
            return;
        }
        const schema = CreateSubscriptionRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestHeader = new RequestHeader(options.requestHeader);
        this.requestedPublishingInterval = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.requestedPublishingInterval);
        this.requestedLifetimeCount = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.requestedLifetimeCount);
        this.requestedMaxKeepAliveCount = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.requestedMaxKeepAliveCount);
        this.maxNotificationsPerPublish = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.maxNotificationsPerPublish);
        this.publishingEnabled = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.publishingEnabled);
        this.priority = (0, node_opcua_factory_1.initialize_field)(schema.fields[6], options?.priority);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeDouble)(this.requestedPublishingInterval, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.requestedLifetimeCount, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.requestedMaxKeepAliveCount, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.maxNotificationsPerPublish, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.publishingEnabled, stream);
        (0, node_opcua_basic_types_1.encodeByte)(this.priority, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.requestedPublishingInterval = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.requestedPublishingInterval);
        this.requestedLifetimeCount = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.requestedLifetimeCount);
        this.requestedMaxKeepAliveCount = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.requestedMaxKeepAliveCount);
        this.maxNotificationsPerPublish = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.maxNotificationsPerPublish);
        this.publishingEnabled = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.publishingEnabled);
        this.priority = (0, node_opcua_basic_types_1.decodeByte)(stream, this.priority);
    }
    get schema() { return schemaCreateSubscriptionRequest; }
}
exports.CreateSubscriptionRequest = CreateSubscriptionRequest;
CreateSubscriptionRequest.schema.dataTypeNodeId = CreateSubscriptionRequest.dataTypeNodeId;
CreateSubscriptionRequest.schema.encodingDefaultBinary = CreateSubscriptionRequest.encodingDefaultBinary;
CreateSubscriptionRequest.schema.encodingDefaultXml = CreateSubscriptionRequest.encodingDefaultXml;
CreateSubscriptionRequest.schema.encodingDefaultJson = CreateSubscriptionRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(CreateSubscriptionRequest.dataTypeNodeId, "CreateSubscriptionRequest", CreateSubscriptionRequest);
// --------------------------------------------------------------------------------------------
const schemaCreateSubscriptionResponse = (0, node_opcua_factory_1.buildStructuredType)({
    name: "CreateSubscriptionResponse",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",
            fieldType: "ResponseHeader",
        },
        {
            name: "SubscriptionId",
            fieldType: "UInt32",
        },
        {
            name: "RevisedPublishingInterval",
            fieldType: "Double",
        },
        {
            name: "RevisedLifetimeCount",
            fieldType: "UInt32",
        },
        {
            name: "RevisedMaxKeepAliveCount",
            fieldType: "UInt32",
        },
    ]
});
class CreateSubscriptionResponse extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaCreateSubscriptionResponse; }
    static possibleFields = [
        "responseHeader",
        "subscriptionId",
        "revisedPublishingInterval",
        "revisedLifetimeCount",
        "revisedMaxKeepAliveCount"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(788, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(790, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(789, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15338, 0);
    responseHeader;
    subscriptionId;
    revisedPublishingInterval;
    revisedLifetimeCount;
    revisedMaxKeepAliveCount;
    constructor(options) {
        super(options);
        if (options === null) {
            this.responseHeader = new ResponseHeader(null);
            this.subscriptionId = 0;
            this.revisedPublishingInterval = 0;
            this.revisedLifetimeCount = 0;
            this.revisedMaxKeepAliveCount = 0;
            return;
        }
        const schema = CreateSubscriptionResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.responseHeader = new ResponseHeader(options.responseHeader);
        this.subscriptionId = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.subscriptionId);
        this.revisedPublishingInterval = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.revisedPublishingInterval);
        this.revisedLifetimeCount = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.revisedLifetimeCount);
        this.revisedMaxKeepAliveCount = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.revisedMaxKeepAliveCount);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.subscriptionId, stream);
        (0, node_opcua_basic_types_1.encodeDouble)(this.revisedPublishingInterval, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.revisedLifetimeCount, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.revisedMaxKeepAliveCount, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.subscriptionId = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.subscriptionId);
        this.revisedPublishingInterval = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.revisedPublishingInterval);
        this.revisedLifetimeCount = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.revisedLifetimeCount);
        this.revisedMaxKeepAliveCount = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.revisedMaxKeepAliveCount);
    }
    get schema() { return schemaCreateSubscriptionResponse; }
}
exports.CreateSubscriptionResponse = CreateSubscriptionResponse;
CreateSubscriptionResponse.schema.dataTypeNodeId = CreateSubscriptionResponse.dataTypeNodeId;
CreateSubscriptionResponse.schema.encodingDefaultBinary = CreateSubscriptionResponse.encodingDefaultBinary;
CreateSubscriptionResponse.schema.encodingDefaultXml = CreateSubscriptionResponse.encodingDefaultXml;
CreateSubscriptionResponse.schema.encodingDefaultJson = CreateSubscriptionResponse.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(CreateSubscriptionResponse.dataTypeNodeId, "CreateSubscriptionResponse", CreateSubscriptionResponse);
// --------------------------------------------------------------------------------------------
const schemaCurrencyUnitType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "CurrencyUnitType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "NumericCode",
            fieldType: "Int16",
        },
        {
            name: "Exponent",
            fieldType: "SByte",
        },
        {
            name: "AlphabeticCode",
            fieldType: "String",
        },
        {
            name: "Currency",
            fieldType: "LocalizedText",
        },
    ]
});
class CurrencyUnitType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaCurrencyUnitType; }
    static possibleFields = [
        "numericCode",
        "exponent",
        "alphabeticCode",
        "currency"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23498, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23507, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23520, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23528, 0);
    numericCode;
    exponent;
    alphabeticCode;
    currency;
    constructor(options) {
        super(options);
        if (options === null) {
            this.numericCode = 0;
            this.exponent = 0;
            this.alphabeticCode = null;
            this.currency = new node_opcua_data_model_1.LocalizedText(null);
            return;
        }
        const schema = CurrencyUnitType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.numericCode = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.numericCode);
        this.exponent = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.exponent);
        this.alphabeticCode = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.alphabeticCode);
        this.currency = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.currency);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeInt16)(this.numericCode, stream);
        (0, node_opcua_basic_types_1.encodeSByte)(this.exponent, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.alphabeticCode, stream);
        (0, node_opcua_data_model_1.encodeLocalizedText)(this.currency, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.numericCode = (0, node_opcua_basic_types_1.decodeInt16)(stream, this.numericCode);
        this.exponent = (0, node_opcua_basic_types_1.decodeSByte)(stream, this.exponent);
        this.alphabeticCode = (0, node_opcua_basic_types_1.decodeString)(stream, this.alphabeticCode);
        this.currency = (0, node_opcua_data_model_1.decodeLocalizedText)(stream, this.currency);
    }
    get schema() { return schemaCurrencyUnitType; }
}
exports.CurrencyUnitType = CurrencyUnitType;
CurrencyUnitType.schema.dataTypeNodeId = CurrencyUnitType.dataTypeNodeId;
CurrencyUnitType.schema.encodingDefaultBinary = CurrencyUnitType.encodingDefaultBinary;
CurrencyUnitType.schema.encodingDefaultXml = CurrencyUnitType.encodingDefaultXml;
CurrencyUnitType.schema.encodingDefaultJson = CurrencyUnitType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(CurrencyUnitType.dataTypeNodeId, "CurrencyUnitType", CurrencyUnitType);
// --------------------------------------------------------------------------------------------
var DataChangeTrigger;
(function (DataChangeTrigger) {
    DataChangeTrigger[DataChangeTrigger["Status"] = 0] = "Status";
    DataChangeTrigger[DataChangeTrigger["StatusValue"] = 1] = "StatusValue";
    DataChangeTrigger[DataChangeTrigger["StatusValueTimestamp"] = 2] = "StatusValueTimestamp";
    DataChangeTrigger[DataChangeTrigger["Invalid"] = 4294967295] = "Invalid";
})(DataChangeTrigger || (exports.DataChangeTrigger = DataChangeTrigger = {}));
const schemaDataChangeTrigger = {
    enumValues: DataChangeTrigger,
    flaggable: false,
    minValue: 0,
    maxValue: 2,
    name: "DataChangeTrigger"
};
function decodeDataChangeTrigger(stream, _value) {
    let value = stream.readUInt32();
    value = (value < schemaDataChangeTrigger.minValue || value > schemaDataChangeTrigger.maxValue) ? DataChangeTrigger.Invalid : value;
    return value;
}
function encodeDataChangeTrigger(value, stream) {
    stream.writeUInt32(value);
}
exports._enumerationDataChangeTrigger = (0, node_opcua_factory_1.registerEnumeration)(schemaDataChangeTrigger);
(0, node_opcua_assert_1.assert)(exports._enumerationDataChangeTrigger.isFlaggable === false);
// --------------------------------------------------------------------------------------------
const schemaDataChangeFilter = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DataChangeFilter",
    baseType: "MonitoringFilter",
    fields: [
        {
            name: "Trigger",
            fieldType: "DataChangeTrigger",
        },
        {
            name: "DeadbandType",
            fieldType: "UInt32",
        },
        {
            name: "DeadbandValue",
            fieldType: "Double",
        },
    ]
});
class DataChangeFilter extends MonitoringFilter {
    static get schema() { return schemaDataChangeFilter; }
    static possibleFields = [
        "trigger",
        "deadbandType",
        "deadbandValue"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(722, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(724, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(723, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15294, 0);
    trigger;
    deadbandType;
    deadbandValue;
    constructor(options) {
        super(options);
        if (options === null) {
            this.trigger = 0;
            this.deadbandType = 0;
            this.deadbandValue = 0;
            return;
        }
        const schema = DataChangeFilter.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.trigger = this.setTrigger((0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.trigger));
        this.deadbandType = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.deadbandType);
        this.deadbandValue = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.deadbandValue);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        encodeDataChangeTrigger(this.trigger, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.deadbandType, stream);
        (0, node_opcua_basic_types_1.encodeDouble)(this.deadbandValue, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.trigger = decodeDataChangeTrigger(stream, this.trigger);
        this.deadbandType = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.deadbandType);
        this.deadbandValue = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.deadbandValue);
    }
    // Define Enumeration setters
    setTrigger(value) {
        const coercedValue = exports._enumerationDataChangeTrigger.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to DataChangeTrigger :" + value);
        }
        this.trigger = coercedValue.value;
        return this.trigger;
    }
    get schema() { return schemaDataChangeFilter; }
}
exports.DataChangeFilter = DataChangeFilter;
DataChangeFilter.schema.dataTypeNodeId = DataChangeFilter.dataTypeNodeId;
DataChangeFilter.schema.encodingDefaultBinary = DataChangeFilter.encodingDefaultBinary;
DataChangeFilter.schema.encodingDefaultXml = DataChangeFilter.encodingDefaultXml;
DataChangeFilter.schema.encodingDefaultJson = DataChangeFilter.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DataChangeFilter.dataTypeNodeId, "DataChangeFilter", DataChangeFilter);
// --------------------------------------------------------------------------------------------
const schemaNotificationData = (0, node_opcua_factory_1.buildStructuredType)({
    name: "NotificationData",
    baseType: "ExtensionObject",
    fields: []
});
class NotificationData extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaNotificationData; }
    static possibleFields = [];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(945, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(947, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(946, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15344, 0);
    constructor(options) {
        super(options);
        if (options === null) {
            return;
        }
        const schema = NotificationData.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    get schema() { return schemaNotificationData; }
}
exports.NotificationData = NotificationData;
NotificationData.schema.dataTypeNodeId = NotificationData.dataTypeNodeId;
NotificationData.schema.encodingDefaultBinary = NotificationData.encodingDefaultBinary;
NotificationData.schema.encodingDefaultXml = NotificationData.encodingDefaultXml;
NotificationData.schema.encodingDefaultJson = NotificationData.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(NotificationData.dataTypeNodeId, "NotificationData", NotificationData);
// --------------------------------------------------------------------------------------------
const schemaMonitoredItemNotification = (0, node_opcua_factory_1.buildStructuredType)({
    name: "MonitoredItemNotification",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ClientHandle",
            fieldType: "UInt32",
        },
        {
            name: "Value",
            fieldType: "DataValue",
        },
    ]
});
class MonitoredItemNotification extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaMonitoredItemNotification; }
    static possibleFields = [
        "clientHandle",
        "value"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(806, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(808, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(807, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15346, 0);
    clientHandle;
    value;
    constructor(options) {
        super(options);
        if (options === null) {
            this.clientHandle = 0;
            this.value = new node_opcua_data_value_1.DataValue(null);
            return;
        }
        const schema = MonitoredItemNotification.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.clientHandle = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.clientHandle);
        this.value = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.value);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.clientHandle, stream);
        (0, node_opcua_data_value_1.encodeDataValue)(this.value, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.clientHandle = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.clientHandle);
        this.value = (0, node_opcua_data_value_1.decodeDataValue)(stream, this.value);
    }
    get schema() { return schemaMonitoredItemNotification; }
}
exports.MonitoredItemNotification = MonitoredItemNotification;
MonitoredItemNotification.schema.dataTypeNodeId = MonitoredItemNotification.dataTypeNodeId;
MonitoredItemNotification.schema.encodingDefaultBinary = MonitoredItemNotification.encodingDefaultBinary;
MonitoredItemNotification.schema.encodingDefaultXml = MonitoredItemNotification.encodingDefaultXml;
MonitoredItemNotification.schema.encodingDefaultJson = MonitoredItemNotification.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(MonitoredItemNotification.dataTypeNodeId, "MonitoredItemNotification", MonitoredItemNotification);
// --------------------------------------------------------------------------------------------
const schemaDataChangeNotification = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DataChangeNotification",
    baseType: "NotificationData",
    fields: [
        {
            name: "MonitoredItems",
            fieldType: "MonitoredItemNotification",
            isArray: true
        },
        {
            name: "DiagnosticInfos",
            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
class DataChangeNotification extends NotificationData {
    static get schema() { return schemaDataChangeNotification; }
    static possibleFields = [
        "monitoredItems",
        "diagnosticInfos"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(809, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(811, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(810, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15345, 0);
    monitoredItems;
    diagnosticInfos;
    constructor(options) {
        super(options);
        if (options === null) {
            this.monitoredItems = null; /* null array */
            this.diagnosticInfos = [];
            return;
        }
        const schema = DataChangeNotification.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.monitoredItems = []; // should default
        if (options.monitoredItems) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.monitoredItems));
            this.monitoredItems = options.monitoredItems.map((e) => new MonitoredItemNotification(e));
        }
        this.diagnosticInfos = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.diagnosticInfos);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.monitoredItems, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.diagnosticInfos, stream, node_opcua_data_model_1.encodeDiagnosticInfo);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.monitoredItems = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new MonitoredItemNotification(null);
            obj.decode(stream1);
            return obj;
        });
        this.diagnosticInfos = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_data_model_1.decodeDiagnosticInfo);
    }
    get schema() { return schemaDataChangeNotification; }
}
exports.DataChangeNotification = DataChangeNotification;
DataChangeNotification.schema.dataTypeNodeId = DataChangeNotification.dataTypeNodeId;
DataChangeNotification.schema.encodingDefaultBinary = DataChangeNotification.encodingDefaultBinary;
DataChangeNotification.schema.encodingDefaultXml = DataChangeNotification.encodingDefaultXml;
DataChangeNotification.schema.encodingDefaultJson = DataChangeNotification.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DataChangeNotification.dataTypeNodeId, "DataChangeNotification", DataChangeNotification);
// --------------------------------------------------------------------------------------------
const schemaDataTypeDescription = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DataTypeDescription",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "DataTypeId",
            fieldType: "NodeId",
        },
        {
            name: "Name",
            fieldType: "QualifiedName",
        },
    ]
});
class DataTypeDescription extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaDataTypeDescription; }
    static possibleFields = [
        "dataTypeId",
        "name"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14525, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(125, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14796, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15057, 0);
    dataTypeId;
    name;
    constructor(options) {
        super(options);
        if (options === null) {
            this.dataTypeId = new node_opcua_nodeid_1.NodeId(null);
            this.name = new node_opcua_data_model_1.QualifiedName(null);
            return;
        }
        const schema = DataTypeDescription.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.dataTypeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.dataTypeId);
        this.name = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.name);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.dataTypeId, stream);
        (0, node_opcua_data_model_1.encodeQualifiedName)(this.name, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.dataTypeId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.dataTypeId);
        this.name = (0, node_opcua_data_model_1.decodeQualifiedName)(stream, this.name);
    }
    get schema() { return schemaDataTypeDescription; }
}
exports.DataTypeDescription = DataTypeDescription;
DataTypeDescription.schema.dataTypeNodeId = DataTypeDescription.dataTypeNodeId;
DataTypeDescription.schema.encodingDefaultBinary = DataTypeDescription.encodingDefaultBinary;
DataTypeDescription.schema.encodingDefaultXml = DataTypeDescription.encodingDefaultXml;
DataTypeDescription.schema.encodingDefaultJson = DataTypeDescription.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DataTypeDescription.dataTypeNodeId, "DataTypeDescription", DataTypeDescription);
// --------------------------------------------------------------------------------------------
const schemaDataTypeDefinition = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DataTypeDefinition",
    baseType: "ExtensionObject",
    fields: []
});
class DataTypeDefinition extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaDataTypeDefinition; }
    static possibleFields = [];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(97, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(121, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14797, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15063, 0);
    constructor(options) {
        super(options);
        if (options === null) {
            return;
        }
        const schema = DataTypeDefinition.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    get schema() { return schemaDataTypeDefinition; }
}
exports.DataTypeDefinition = DataTypeDefinition;
DataTypeDefinition.schema.dataTypeNodeId = DataTypeDefinition.dataTypeNodeId;
DataTypeDefinition.schema.encodingDefaultBinary = DataTypeDefinition.encodingDefaultBinary;
DataTypeDefinition.schema.encodingDefaultXml = DataTypeDefinition.encodingDefaultXml;
DataTypeDefinition.schema.encodingDefaultJson = DataTypeDefinition.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DataTypeDefinition.dataTypeNodeId, "DataTypeDefinition", DataTypeDefinition);
// --------------------------------------------------------------------------------------------
var StructureType;
(function (StructureType) {
    StructureType[StructureType["Structure"] = 0] = "Structure";
    StructureType[StructureType["StructureWithOptionalFields"] = 1] = "StructureWithOptionalFields";
    StructureType[StructureType["Union"] = 2] = "Union";
    StructureType[StructureType["StructureWithSubtypedValues"] = 3] = "StructureWithSubtypedValues";
    StructureType[StructureType["UnionWithSubtypedValues"] = 4] = "UnionWithSubtypedValues";
    StructureType[StructureType["Invalid"] = 4294967295] = "Invalid";
})(StructureType || (exports.StructureType = StructureType = {}));
const schemaStructureType = {
    enumValues: StructureType,
    flaggable: false,
    minValue: 0,
    maxValue: 4,
    name: "StructureType"
};
function decodeStructureType(stream, _value) {
    let value = stream.readUInt32();
    value = (value < schemaStructureType.minValue || value > schemaStructureType.maxValue) ? StructureType.Invalid : value;
    return value;
}
function encodeStructureType(value, stream) {
    stream.writeUInt32(value);
}
exports._enumerationStructureType = (0, node_opcua_factory_1.registerEnumeration)(schemaStructureType);
(0, node_opcua_assert_1.assert)(exports._enumerationStructureType.isFlaggable === false);
// --------------------------------------------------------------------------------------------
const schemaStructureField = (0, node_opcua_factory_1.buildStructuredType)({
    name: "StructureField",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Name",
            fieldType: "String",
        },
        {
            name: "Description",
            fieldType: "LocalizedText",
        },
        {
            name: "DataType",
            fieldType: "NodeId",
        },
        {
            name: "ValueRank",
            fieldType: "Int32",
        },
        {
            name: "ArrayDimensions",
            fieldType: "UInt32",
            isArray: true
        },
        {
            name: "MaxStringLength",
            fieldType: "UInt32",
        },
        {
            name: "IsOptional",
            fieldType: "Boolean",
        },
    ]
});
class StructureField extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaStructureField; }
    static possibleFields = [
        "name",
        "description",
        "dataType",
        "valueRank",
        "arrayDimensions",
        "maxStringLength",
        "isOptional"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(101, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14844, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14800, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15065, 0);
    name;
    description;
    dataType;
    valueRank;
    arrayDimensions;
    maxStringLength;
    isOptional;
    constructor(options) {
        super(options);
        if (options === null) {
            this.name = null;
            this.description = new node_opcua_data_model_1.LocalizedText(null);
            this.dataType = new node_opcua_nodeid_1.NodeId(null);
            this.valueRank = 0;
            this.arrayDimensions = [];
            this.maxStringLength = 0;
            this.isOptional = false;
            return;
        }
        const schema = StructureField.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.name = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.name);
        this.description = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.description);
        this.dataType = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.dataType);
        this.valueRank = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.valueRank);
        this.arrayDimensions = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[4], options?.arrayDimensions);
        this.maxStringLength = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.maxStringLength);
        this.isOptional = (0, node_opcua_factory_1.initialize_field)(schema.fields[6], options?.isOptional);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.name, stream);
        (0, node_opcua_data_model_1.encodeLocalizedText)(this.description, stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.dataType, stream);
        (0, node_opcua_basic_types_1.encodeInt32)(this.valueRank, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.arrayDimensions, stream, node_opcua_basic_types_1.encodeUInt32);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.maxStringLength, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.isOptional, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = (0, node_opcua_basic_types_1.decodeString)(stream, this.name);
        this.description = (0, node_opcua_data_model_1.decodeLocalizedText)(stream, this.description);
        this.dataType = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.dataType);
        this.valueRank = (0, node_opcua_basic_types_1.decodeInt32)(stream, this.valueRank);
        this.arrayDimensions = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeUInt32);
        this.maxStringLength = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.maxStringLength);
        this.isOptional = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.isOptional);
    }
    get schema() { return schemaStructureField; }
}
exports.StructureField = StructureField;
StructureField.schema.dataTypeNodeId = StructureField.dataTypeNodeId;
StructureField.schema.encodingDefaultBinary = StructureField.encodingDefaultBinary;
StructureField.schema.encodingDefaultXml = StructureField.encodingDefaultXml;
StructureField.schema.encodingDefaultJson = StructureField.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(StructureField.dataTypeNodeId, "StructureField", StructureField);
// --------------------------------------------------------------------------------------------
const schemaStructureDefinition = (0, node_opcua_factory_1.buildStructuredType)({
    name: "StructureDefinition",
    baseType: "DataTypeDefinition",
    fields: [
        {
            name: "DefaultEncodingId",
            fieldType: "NodeId",
        },
        {
            name: "BaseDataType",
            fieldType: "NodeId",
        },
        {
            name: "StructureType",
            fieldType: "StructureType",
        },
        {
            name: "Fields",
            fieldType: "StructureField",
            isArray: true
        },
    ]
});
class StructureDefinition extends DataTypeDefinition {
    static get schema() { return schemaStructureDefinition; }
    static possibleFields = [
        "defaultEncodingId",
        "baseDataType",
        "structureType",
        "fields"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(99, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(122, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14798, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15066, 0);
    defaultEncodingId;
    baseDataType;
    structureType;
    fields;
    constructor(options) {
        super(options);
        if (options === null) {
            this.defaultEncodingId = new node_opcua_nodeid_1.NodeId(null);
            this.baseDataType = new node_opcua_nodeid_1.NodeId(null);
            this.structureType = 0;
            this.fields = null; /* null array */
            return;
        }
        const schema = StructureDefinition.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.defaultEncodingId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.defaultEncodingId);
        this.baseDataType = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.baseDataType);
        this.structureType = this.setStructureType((0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.structureType));
        this.fields = []; // should default
        if (options.fields) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.fields));
            this.fields = options.fields.map((e) => new StructureField(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.defaultEncodingId, stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.baseDataType, stream);
        encodeStructureType(this.structureType, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.fields, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.defaultEncodingId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.defaultEncodingId);
        this.baseDataType = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.baseDataType);
        this.structureType = decodeStructureType(stream, this.structureType);
        this.fields = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new StructureField(null);
            obj.decode(stream1);
            return obj;
        });
    }
    // Define Enumeration setters
    setStructureType(value) {
        const coercedValue = exports._enumerationStructureType.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to StructureType :" + value);
        }
        this.structureType = coercedValue.value;
        return this.structureType;
    }
    get schema() { return schemaStructureDefinition; }
}
exports.StructureDefinition = StructureDefinition;
StructureDefinition.schema.dataTypeNodeId = StructureDefinition.dataTypeNodeId;
StructureDefinition.schema.encodingDefaultBinary = StructureDefinition.encodingDefaultBinary;
StructureDefinition.schema.encodingDefaultXml = StructureDefinition.encodingDefaultXml;
StructureDefinition.schema.encodingDefaultJson = StructureDefinition.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(StructureDefinition.dataTypeNodeId, "StructureDefinition", StructureDefinition);
// --------------------------------------------------------------------------------------------
const schemaStructureDescription = (0, node_opcua_factory_1.buildStructuredType)({
    name: "StructureDescription",
    baseType: "DataTypeDescription",
    fields: [
        {
            name: "StructureDefinition",
            fieldType: "StructureDefinition",
        },
    ]
});
class StructureDescription extends DataTypeDescription {
    static get schema() { return schemaStructureDescription; }
    static possibleFields = [
        "dataTypeId",
        "name",
        "structureDefinition"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15487, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(126, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15589, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15058, 0);
    structureDefinition;
    constructor(options) {
        super(options);
        if (options === null) {
            this.structureDefinition = new StructureDefinition(null);
            return;
        }
        const schema = StructureDescription.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.structureDefinition = new StructureDefinition(options.structureDefinition);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.structureDefinition.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.structureDefinition.decode(stream);
    }
    get schema() { return schemaStructureDescription; }
}
exports.StructureDescription = StructureDescription;
StructureDescription.schema.dataTypeNodeId = StructureDescription.dataTypeNodeId;
StructureDescription.schema.encodingDefaultBinary = StructureDescription.encodingDefaultBinary;
StructureDescription.schema.encodingDefaultXml = StructureDescription.encodingDefaultXml;
StructureDescription.schema.encodingDefaultJson = StructureDescription.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(StructureDescription.dataTypeNodeId, "StructureDescription", StructureDescription);
// --------------------------------------------------------------------------------------------
const schemaEnumValueType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "EnumValueType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Value",
            fieldType: "Int64",
        },
        {
            name: "DisplayName",
            fieldType: "LocalizedText",
        },
        {
            name: "Description",
            fieldType: "LocalizedText",
        },
    ]
});
class EnumValueType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaEnumValueType; }
    static possibleFields = [
        "value",
        "displayName",
        "description"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(7594, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(8251, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(7616, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15082, 0);
    value;
    displayName;
    description;
    constructor(options) {
        super(options);
        if (options === null) {
            this.value = [];
            this.displayName = new node_opcua_data_model_1.LocalizedText(null);
            this.description = new node_opcua_data_model_1.LocalizedText(null);
            return;
        }
        const schema = EnumValueType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.value = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.value);
        this.displayName = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.displayName);
        this.description = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.description);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeInt64)(this.value, stream);
        (0, node_opcua_data_model_1.encodeLocalizedText)(this.displayName, stream);
        (0, node_opcua_data_model_1.encodeLocalizedText)(this.description, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.value = (0, node_opcua_basic_types_1.decodeInt64)(stream, this.value);
        this.displayName = (0, node_opcua_data_model_1.decodeLocalizedText)(stream, this.displayName);
        this.description = (0, node_opcua_data_model_1.decodeLocalizedText)(stream, this.description);
    }
    get schema() { return schemaEnumValueType; }
}
exports.EnumValueType = EnumValueType;
EnumValueType.schema.dataTypeNodeId = EnumValueType.dataTypeNodeId;
EnumValueType.schema.encodingDefaultBinary = EnumValueType.encodingDefaultBinary;
EnumValueType.schema.encodingDefaultXml = EnumValueType.encodingDefaultXml;
EnumValueType.schema.encodingDefaultJson = EnumValueType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(EnumValueType.dataTypeNodeId, "EnumValueType", EnumValueType);
// --------------------------------------------------------------------------------------------
const schemaEnumField = (0, node_opcua_factory_1.buildStructuredType)({
    name: "EnumField",
    baseType: "EnumValueType",
    fields: [
        {
            name: "Name",
            fieldType: "String",
        },
    ]
});
class EnumField extends EnumValueType {
    static get schema() { return schemaEnumField; }
    static possibleFields = [
        "value",
        "displayName",
        "description",
        "name"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(102, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14845, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14801, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15083, 0);
    name;
    constructor(options) {
        super(options);
        if (options === null) {
            this.name = null;
            return;
        }
        const schema = EnumField.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.name = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.name);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.name, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = (0, node_opcua_basic_types_1.decodeString)(stream, this.name);
    }
    get schema() { return schemaEnumField; }
}
exports.EnumField = EnumField;
EnumField.schema.dataTypeNodeId = EnumField.dataTypeNodeId;
EnumField.schema.encodingDefaultBinary = EnumField.encodingDefaultBinary;
EnumField.schema.encodingDefaultXml = EnumField.encodingDefaultXml;
EnumField.schema.encodingDefaultJson = EnumField.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(EnumField.dataTypeNodeId, "EnumField", EnumField);
// --------------------------------------------------------------------------------------------
const schemaEnumDefinition = (0, node_opcua_factory_1.buildStructuredType)({
    name: "EnumDefinition",
    baseType: "DataTypeDefinition",
    fields: [
        {
            name: "Fields",
            fieldType: "EnumField",
            isArray: true
        },
    ]
});
class EnumDefinition extends DataTypeDefinition {
    static get schema() { return schemaEnumDefinition; }
    static possibleFields = [
        "fields"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(100, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(123, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14799, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15067, 0);
    fields;
    constructor(options) {
        super(options);
        if (options === null) {
            this.fields = null; /* null array */
            return;
        }
        const schema = EnumDefinition.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.fields = []; // should default
        if (options.fields) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.fields));
            this.fields = options.fields.map((e) => new EnumField(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.fields, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.fields = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new EnumField(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaEnumDefinition; }
}
exports.EnumDefinition = EnumDefinition;
EnumDefinition.schema.dataTypeNodeId = EnumDefinition.dataTypeNodeId;
EnumDefinition.schema.encodingDefaultBinary = EnumDefinition.encodingDefaultBinary;
EnumDefinition.schema.encodingDefaultXml = EnumDefinition.encodingDefaultXml;
EnumDefinition.schema.encodingDefaultJson = EnumDefinition.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(EnumDefinition.dataTypeNodeId, "EnumDefinition", EnumDefinition);
// --------------------------------------------------------------------------------------------
const schemaEnumDescription = (0, node_opcua_factory_1.buildStructuredType)({
    name: "EnumDescription",
    baseType: "DataTypeDescription",
    fields: [
        {
            name: "EnumDefinition",
            fieldType: "EnumDefinition",
        },
        {
            name: "BuiltInType",
            fieldType: "Byte",
        },
    ]
});
class EnumDescription extends DataTypeDescription {
    static get schema() { return schemaEnumDescription; }
    static possibleFields = [
        "dataTypeId",
        "name",
        "enumDefinition",
        "builtInType"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15488, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(127, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15590, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15059, 0);
    enumDefinition;
    builtInType;
    constructor(options) {
        super(options);
        if (options === null) {
            this.enumDefinition = new EnumDefinition(null);
            this.builtInType = 0;
            return;
        }
        const schema = EnumDescription.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.enumDefinition = new EnumDefinition(options.enumDefinition);
        this.builtInType = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.builtInType);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.enumDefinition.encode(stream);
        (0, node_opcua_basic_types_1.encodeByte)(this.builtInType, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.enumDefinition.decode(stream);
        this.builtInType = (0, node_opcua_basic_types_1.decodeByte)(stream, this.builtInType);
    }
    get schema() { return schemaEnumDescription; }
}
exports.EnumDescription = EnumDescription;
EnumDescription.schema.dataTypeNodeId = EnumDescription.dataTypeNodeId;
EnumDescription.schema.encodingDefaultBinary = EnumDescription.encodingDefaultBinary;
EnumDescription.schema.encodingDefaultXml = EnumDescription.encodingDefaultXml;
EnumDescription.schema.encodingDefaultJson = EnumDescription.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(EnumDescription.dataTypeNodeId, "EnumDescription", EnumDescription);
// --------------------------------------------------------------------------------------------
const schemaSimpleTypeDescription = (0, node_opcua_factory_1.buildStructuredType)({
    name: "SimpleTypeDescription",
    baseType: "DataTypeDescription",
    fields: [
        {
            name: "BaseDataType",
            fieldType: "NodeId",
        },
        {
            name: "BuiltInType",
            fieldType: "Byte",
        },
    ]
});
class SimpleTypeDescription extends DataTypeDescription {
    static get schema() { return schemaSimpleTypeDescription; }
    static possibleFields = [
        "dataTypeId",
        "name",
        "baseDataType",
        "builtInType"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15005, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15421, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15529, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15700, 0);
    baseDataType;
    builtInType;
    constructor(options) {
        super(options);
        if (options === null) {
            this.baseDataType = new node_opcua_nodeid_1.NodeId(null);
            this.builtInType = 0;
            return;
        }
        const schema = SimpleTypeDescription.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.baseDataType = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.baseDataType);
        this.builtInType = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.builtInType);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.baseDataType, stream);
        (0, node_opcua_basic_types_1.encodeByte)(this.builtInType, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.baseDataType = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.baseDataType);
        this.builtInType = (0, node_opcua_basic_types_1.decodeByte)(stream, this.builtInType);
    }
    get schema() { return schemaSimpleTypeDescription; }
}
exports.SimpleTypeDescription = SimpleTypeDescription;
SimpleTypeDescription.schema.dataTypeNodeId = SimpleTypeDescription.dataTypeNodeId;
SimpleTypeDescription.schema.encodingDefaultBinary = SimpleTypeDescription.encodingDefaultBinary;
SimpleTypeDescription.schema.encodingDefaultXml = SimpleTypeDescription.encodingDefaultXml;
SimpleTypeDescription.schema.encodingDefaultJson = SimpleTypeDescription.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(SimpleTypeDescription.dataTypeNodeId, "SimpleTypeDescription", SimpleTypeDescription);
// --------------------------------------------------------------------------------------------
const schemaDataTypeSchemaHeader = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DataTypeSchemaHeader",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Namespaces",
            fieldType: "String",
            isArray: true
        },
        {
            name: "StructureDataTypes",
            fieldType: "StructureDescription",
            isArray: true
        },
        {
            name: "EnumDataTypes",
            fieldType: "EnumDescription",
            isArray: true
        },
        {
            name: "SimpleDataTypes",
            fieldType: "SimpleTypeDescription",
            isArray: true
        },
    ]
});
class DataTypeSchemaHeader extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaDataTypeSchemaHeader; }
    static possibleFields = [
        "namespaces",
        "structureDataTypes",
        "enumDataTypes",
        "simpleDataTypes"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15534, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15676, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15950, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16151, 0);
    namespaces;
    structureDataTypes;
    enumDataTypes;
    simpleDataTypes;
    constructor(options) {
        super(options);
        if (options === null) {
            this.namespaces = [];
            this.structureDataTypes = null; /* null array */
            this.enumDataTypes = null; /* null array */
            this.simpleDataTypes = null; /* null array */
            return;
        }
        const schema = DataTypeSchemaHeader.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.namespaces = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[0], options?.namespaces);
        this.structureDataTypes = []; // should default
        if (options.structureDataTypes) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.structureDataTypes));
            this.structureDataTypes = options.structureDataTypes.map((e) => new StructureDescription(e));
        }
        this.enumDataTypes = []; // should default
        if (options.enumDataTypes) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.enumDataTypes));
            this.enumDataTypes = options.enumDataTypes.map((e) => new EnumDescription(e));
        }
        this.simpleDataTypes = []; // should default
        if (options.simpleDataTypes) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.simpleDataTypes));
            this.simpleDataTypes = options.simpleDataTypes.map((e) => new SimpleTypeDescription(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.namespaces, stream, node_opcua_basic_types_1.encodeString);
        (0, node_opcua_basic_types_1.encodeArray)(this.structureDataTypes, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.enumDataTypes, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.simpleDataTypes, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.namespaces = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeString);
        this.structureDataTypes = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new StructureDescription(null);
            obj.decode(stream1);
            return obj;
        });
        this.enumDataTypes = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new EnumDescription(null);
            obj.decode(stream1);
            return obj;
        });
        this.simpleDataTypes = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new SimpleTypeDescription(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaDataTypeSchemaHeader; }
}
exports.DataTypeSchemaHeader = DataTypeSchemaHeader;
DataTypeSchemaHeader.schema.dataTypeNodeId = DataTypeSchemaHeader.dataTypeNodeId;
DataTypeSchemaHeader.schema.encodingDefaultBinary = DataTypeSchemaHeader.encodingDefaultBinary;
DataTypeSchemaHeader.schema.encodingDefaultXml = DataTypeSchemaHeader.encodingDefaultXml;
DataTypeSchemaHeader.schema.encodingDefaultJson = DataTypeSchemaHeader.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DataTypeSchemaHeader.dataTypeNodeId, "DataTypeSchemaHeader", DataTypeSchemaHeader);
// --------------------------------------------------------------------------------------------
var DataSetFieldFlags;
(function (DataSetFieldFlags) {
    DataSetFieldFlags[DataSetFieldFlags["None"] = 0] = "None";
    DataSetFieldFlags[DataSetFieldFlags["PromotedField"] = 1] = "PromotedField";
    DataSetFieldFlags[DataSetFieldFlags["Invalid"] = 4294967295] = "Invalid";
})(DataSetFieldFlags || (exports.DataSetFieldFlags = DataSetFieldFlags = {}));
const schemaDataSetFieldFlags = {
    enumValues: DataSetFieldFlags,
    flaggable: false,
    minValue: 0,
    maxValue: 1,
    name: "DataSetFieldFlags"
};
function decodeDataSetFieldFlags(stream, _value) {
    let value = stream.readUInt16();
    value = (value < schemaDataSetFieldFlags.minValue || value > schemaDataSetFieldFlags.maxValue) ? DataSetFieldFlags.Invalid : value;
    return value;
}
function encodeDataSetFieldFlags(value, stream) {
    stream.writeUInt16(value);
}
exports._enumerationDataSetFieldFlags = (0, node_opcua_factory_1.registerEnumeration)(schemaDataSetFieldFlags);
(0, node_opcua_assert_1.assert)(exports._enumerationDataSetFieldFlags.isFlaggable === false);
// --------------------------------------------------------------------------------------------
const schemaFieldMetaData = (0, node_opcua_factory_1.buildStructuredType)({
    name: "FieldMetaData",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Name",
            fieldType: "String",
        },
        {
            name: "Description",
            fieldType: "LocalizedText",
        },
        {
            name: "FieldFlags",
            fieldType: "DataSetFieldFlags",
        },
        {
            name: "BuiltInType",
            fieldType: "Byte",
        },
        {
            name: "DataType",
            fieldType: "NodeId",
        },
        {
            name: "ValueRank",
            fieldType: "Int32",
        },
        {
            name: "ArrayDimensions",
            fieldType: "UInt32",
            isArray: true
        },
        {
            name: "MaxStringLength",
            fieldType: "UInt32",
        },
        {
            name: "DataSetFieldId",
            fieldType: "Guid",
        },
        {
            name: "Properties",
            fieldType: "KeyValuePair",
            isArray: true
        },
    ]
});
class FieldMetaData extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaFieldMetaData; }
    static possibleFields = [
        "name",
        "description",
        "fieldFlags",
        "builtInType",
        "dataType",
        "valueRank",
        "arrayDimensions",
        "maxStringLength",
        "dataSetFieldId",
        "properties"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14524, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14839, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14795, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15051, 0);
    name;
    description;
    fieldFlags;
    builtInType;
    dataType;
    valueRank;
    arrayDimensions;
    maxStringLength;
    dataSetFieldId;
    properties;
    constructor(options) {
        super(options);
        if (options === null) {
            this.name = null;
            this.description = new node_opcua_data_model_1.LocalizedText(null);
            this.fieldFlags = 0;
            this.builtInType = 0;
            this.dataType = new node_opcua_nodeid_1.NodeId(null);
            this.valueRank = 0;
            this.arrayDimensions = [];
            this.maxStringLength = 0;
            this.dataSetFieldId = "";
            this.properties = null; /* null array */
            return;
        }
        const schema = FieldMetaData.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.name = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.name);
        this.description = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.description);
        this.fieldFlags = this.setFieldFlags((0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.fieldFlags));
        this.builtInType = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.builtInType);
        this.dataType = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.dataType);
        this.valueRank = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.valueRank);
        this.arrayDimensions = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[6], options?.arrayDimensions);
        this.maxStringLength = (0, node_opcua_factory_1.initialize_field)(schema.fields[7], options?.maxStringLength);
        this.dataSetFieldId = (0, node_opcua_factory_1.initialize_field)(schema.fields[8], options?.dataSetFieldId);
        this.properties = []; // should default
        if (options.properties) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.properties));
            this.properties = options.properties.map((e) => new KeyValuePair(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.name, stream);
        (0, node_opcua_data_model_1.encodeLocalizedText)(this.description, stream);
        encodeDataSetFieldFlags(this.fieldFlags, stream);
        (0, node_opcua_basic_types_1.encodeByte)(this.builtInType, stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.dataType, stream);
        (0, node_opcua_basic_types_1.encodeInt32)(this.valueRank, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.arrayDimensions, stream, node_opcua_basic_types_1.encodeUInt32);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.maxStringLength, stream);
        (0, node_opcua_basic_types_1.encodeGuid)(this.dataSetFieldId, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.properties, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = (0, node_opcua_basic_types_1.decodeString)(stream, this.name);
        this.description = (0, node_opcua_data_model_1.decodeLocalizedText)(stream, this.description);
        this.fieldFlags = decodeDataSetFieldFlags(stream, this.fieldFlags);
        this.builtInType = (0, node_opcua_basic_types_1.decodeByte)(stream, this.builtInType);
        this.dataType = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.dataType);
        this.valueRank = (0, node_opcua_basic_types_1.decodeInt32)(stream, this.valueRank);
        this.arrayDimensions = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeUInt32);
        this.maxStringLength = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.maxStringLength);
        this.dataSetFieldId = (0, node_opcua_basic_types_1.decodeGuid)(stream, this.dataSetFieldId);
        this.properties = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new KeyValuePair(null);
            obj.decode(stream1);
            return obj;
        });
    }
    // Define Enumeration setters
    setFieldFlags(value) {
        const coercedValue = exports._enumerationDataSetFieldFlags.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to DataSetFieldFlags :" + value);
        }
        this.fieldFlags = coercedValue.value;
        return this.fieldFlags;
    }
    get schema() { return schemaFieldMetaData; }
}
exports.FieldMetaData = FieldMetaData;
FieldMetaData.schema.dataTypeNodeId = FieldMetaData.dataTypeNodeId;
FieldMetaData.schema.encodingDefaultBinary = FieldMetaData.encodingDefaultBinary;
FieldMetaData.schema.encodingDefaultXml = FieldMetaData.encodingDefaultXml;
FieldMetaData.schema.encodingDefaultJson = FieldMetaData.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(FieldMetaData.dataTypeNodeId, "FieldMetaData", FieldMetaData);
// --------------------------------------------------------------------------------------------
const schemaDataSetMetaDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DataSetMetaDataType",
    baseType: "DataTypeSchemaHeader",
    fields: [
        {
            name: "Name",
            fieldType: "String",
        },
        {
            name: "Description",
            fieldType: "LocalizedText",
        },
        {
            name: "Fields",
            fieldType: "FieldMetaData",
            isArray: true
        },
        {
            name: "DataSetClassId",
            fieldType: "Guid",
        },
        {
            name: "ConfigurationVersion",
            fieldType: "ConfigurationVersionDataType",
        },
    ]
});
class DataSetMetaDataType extends DataTypeSchemaHeader {
    static get schema() { return schemaDataSetMetaDataType; }
    static possibleFields = [
        "namespaces",
        "structureDataTypes",
        "enumDataTypes",
        "simpleDataTypes",
        "name",
        "description",
        "fields",
        "dataSetClassId",
        "configurationVersion"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14523, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(124, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14794, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15050, 0);
    name;
    description;
    fields;
    dataSetClassId;
    configurationVersion;
    constructor(options) {
        super(options);
        if (options === null) {
            this.name = null;
            this.description = new node_opcua_data_model_1.LocalizedText(null);
            this.fields = null; /* null array */
            this.dataSetClassId = "";
            this.configurationVersion = new ConfigurationVersionDataType(null);
            return;
        }
        const schema = DataSetMetaDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.name = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.name);
        this.description = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.description);
        this.fields = []; // should default
        if (options.fields) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.fields));
            this.fields = options.fields.map((e) => new FieldMetaData(e));
        }
        this.dataSetClassId = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.dataSetClassId);
        this.configurationVersion = new ConfigurationVersionDataType(options.configurationVersion);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.name, stream);
        (0, node_opcua_data_model_1.encodeLocalizedText)(this.description, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.fields, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeGuid)(this.dataSetClassId, stream);
        this.configurationVersion.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = (0, node_opcua_basic_types_1.decodeString)(stream, this.name);
        this.description = (0, node_opcua_data_model_1.decodeLocalizedText)(stream, this.description);
        this.fields = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new FieldMetaData(null);
            obj.decode(stream1);
            return obj;
        });
        this.dataSetClassId = (0, node_opcua_basic_types_1.decodeGuid)(stream, this.dataSetClassId);
        this.configurationVersion.decode(stream);
    }
    get schema() { return schemaDataSetMetaDataType; }
}
exports.DataSetMetaDataType = DataSetMetaDataType;
DataSetMetaDataType.schema.dataTypeNodeId = DataSetMetaDataType.dataTypeNodeId;
DataSetMetaDataType.schema.encodingDefaultBinary = DataSetMetaDataType.encodingDefaultBinary;
DataSetMetaDataType.schema.encodingDefaultXml = DataSetMetaDataType.encodingDefaultXml;
DataSetMetaDataType.schema.encodingDefaultJson = DataSetMetaDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DataSetMetaDataType.dataTypeNodeId, "DataSetMetaDataType", DataSetMetaDataType);
// --------------------------------------------------------------------------------------------
var DataSetFieldContentMask;
(function (DataSetFieldContentMask) {
    DataSetFieldContentMask[DataSetFieldContentMask["None"] = 0] = "None";
    DataSetFieldContentMask[DataSetFieldContentMask["StatusCode"] = 1] = "StatusCode";
    DataSetFieldContentMask[DataSetFieldContentMask["SourceTimestamp"] = 2] = "SourceTimestamp";
    DataSetFieldContentMask[DataSetFieldContentMask["ServerTimestamp"] = 4] = "ServerTimestamp";
    DataSetFieldContentMask[DataSetFieldContentMask["SourcePicoSeconds"] = 8] = "SourcePicoSeconds";
    DataSetFieldContentMask[DataSetFieldContentMask["ServerPicoSeconds"] = 16] = "ServerPicoSeconds";
    DataSetFieldContentMask[DataSetFieldContentMask["RawData"] = 32] = "RawData";
})(DataSetFieldContentMask || (exports.DataSetFieldContentMask = DataSetFieldContentMask = {}));
const schemaDataSetFieldContentMask = {
    enumValues: DataSetFieldContentMask,
    flaggable: true,
    name: "DataSetFieldContentMask"
};
function decodeDataSetFieldContentMask(stream, _value) {
    return stream.readUInt32();
}
function encodeDataSetFieldContentMask(value, stream) {
    stream.writeUInt32(value);
}
exports._enumerationDataSetFieldContentMask = (0, node_opcua_factory_1.registerEnumeration)(schemaDataSetFieldContentMask);
(0, node_opcua_assert_1.assert)(exports._enumerationDataSetFieldContentMask.isFlaggable === true);
// --------------------------------------------------------------------------------------------
const schemaDataSetReaderDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DataSetReaderDataType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Name",
            fieldType: "String",
        },
        {
            name: "Enabled",
            fieldType: "Boolean",
        },
        {
            name: "PublisherId",
            fieldType: "Variant",
        },
        {
            name: "WriterGroupId",
            fieldType: "UInt16",
        },
        {
            name: "DataSetWriterId",
            fieldType: "UInt16",
        },
        {
            name: "DataSetMetaData",
            fieldType: "DataSetMetaDataType",
        },
        {
            name: "DataSetFieldContentMask",
            fieldType: "DataSetFieldContentMask",
        },
        {
            name: "MessageReceiveTimeout",
            fieldType: "Double",
        },
        {
            name: "KeyFrameCount",
            fieldType: "UInt32",
        },
        {
            name: "HeaderLayoutUri",
            fieldType: "String",
        },
        {
            name: "SecurityMode",
            fieldType: "MessageSecurityMode",
        },
        {
            name: "SecurityGroupId",
            fieldType: "String",
        },
        {
            name: "SecurityKeyServices",
            fieldType: "EndpointDescription",
            isArray: true
        },
        {
            name: "DataSetReaderProperties",
            fieldType: "KeyValuePair",
            isArray: true
        },
        {
            name: "TransportSettings",
            fieldType: "ExtensionObject",
        },
        {
            name: "MessageSettings",
            fieldType: "ExtensionObject",
        },
        {
            name: "SubscribedDataSet",
            fieldType: "ExtensionObject",
        },
    ]
});
class DataSetReaderDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaDataSetReaderDataType; }
    static possibleFields = [
        "name",
        "enabled",
        "publisherId",
        "writerGroupId",
        "dataSetWriterId",
        "dataSetMetaData",
        "dataSetFieldContentMask",
        "messageReceiveTimeout",
        "keyFrameCount",
        "headerLayoutUri",
        "securityMode",
        "securityGroupId",
        "securityKeyServices",
        "dataSetReaderProperties",
        "transportSettings",
        "messageSettings",
        "subscribedDataSet"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15623, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15703, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16007, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16286, 0);
    name;
    enabled;
    publisherId;
    writerGroupId;
    dataSetWriterId;
    dataSetMetaData;
    dataSetFieldContentMask;
    messageReceiveTimeout;
    keyFrameCount;
    headerLayoutUri;
    securityMode;
    securityGroupId;
    securityKeyServices;
    dataSetReaderProperties;
    transportSettings;
    messageSettings;
    subscribedDataSet;
    constructor(options) {
        super(options);
        if (options === null) {
            this.name = null;
            this.enabled = false;
            this.publisherId = new node_opcua_variant_1.Variant(null);
            this.writerGroupId = 0;
            this.dataSetWriterId = 0;
            this.dataSetMetaData = new DataSetMetaDataType(null);
            this.dataSetFieldContentMask = 0;
            this.messageReceiveTimeout = 0;
            this.keyFrameCount = 0;
            this.headerLayoutUri = null;
            this.securityMode = 0;
            this.securityGroupId = null;
            this.securityKeyServices = null; /* null array */
            this.dataSetReaderProperties = null; /* null array */
            this.transportSettings = null;
            this.messageSettings = null;
            this.subscribedDataSet = null;
            return;
        }
        const schema = DataSetReaderDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.name = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.name);
        this.enabled = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.enabled);
        this.publisherId = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.publisherId);
        this.writerGroupId = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.writerGroupId);
        this.dataSetWriterId = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.dataSetWriterId);
        this.dataSetMetaData = new DataSetMetaDataType(options.dataSetMetaData);
        this.dataSetFieldContentMask = this.setDataSetFieldContentMask((0, node_opcua_factory_1.initialize_field)(schema.fields[6], options?.dataSetFieldContentMask));
        this.messageReceiveTimeout = (0, node_opcua_factory_1.initialize_field)(schema.fields[7], options?.messageReceiveTimeout);
        this.keyFrameCount = (0, node_opcua_factory_1.initialize_field)(schema.fields[8], options?.keyFrameCount);
        this.headerLayoutUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[9], options?.headerLayoutUri);
        this.securityMode = this.setSecurityMode((0, node_opcua_factory_1.initialize_field)(schema.fields[10], options?.securityMode));
        this.securityGroupId = (0, node_opcua_factory_1.initialize_field)(schema.fields[11], options?.securityGroupId);
        this.securityKeyServices = []; // should default
        if (options.securityKeyServices) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.securityKeyServices));
            this.securityKeyServices = options.securityKeyServices.map((e) => new EndpointDescription(e));
        }
        this.dataSetReaderProperties = []; // should default
        if (options.dataSetReaderProperties) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.dataSetReaderProperties));
            this.dataSetReaderProperties = options.dataSetReaderProperties.map((e) => new KeyValuePair(e));
        }
        this.transportSettings = (0, node_opcua_factory_1.initialize_field)(schema.fields[14], options?.transportSettings);
        this.messageSettings = (0, node_opcua_factory_1.initialize_field)(schema.fields[15], options?.messageSettings);
        this.subscribedDataSet = (0, node_opcua_factory_1.initialize_field)(schema.fields[16], options?.subscribedDataSet);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.name, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.enabled, stream);
        (0, node_opcua_variant_1.encodeVariant)(this.publisherId, stream);
        (0, node_opcua_basic_types_1.encodeUInt16)(this.writerGroupId, stream);
        (0, node_opcua_basic_types_1.encodeUInt16)(this.dataSetWriterId, stream);
        this.dataSetMetaData.encode(stream);
        encodeDataSetFieldContentMask(this.dataSetFieldContentMask, stream);
        (0, node_opcua_basic_types_1.encodeDouble)(this.messageReceiveTimeout, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.keyFrameCount, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.headerLayoutUri, stream);
        encodeMessageSecurityMode(this.securityMode, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.securityGroupId, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.securityKeyServices, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.dataSetReaderProperties, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.transportSettings, stream);
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.messageSettings, stream);
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.subscribedDataSet, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = (0, node_opcua_basic_types_1.decodeString)(stream, this.name);
        this.enabled = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.enabled);
        this.publisherId = (0, node_opcua_variant_1.decodeVariant)(stream, this.publisherId);
        this.writerGroupId = (0, node_opcua_basic_types_1.decodeUInt16)(stream, this.writerGroupId);
        this.dataSetWriterId = (0, node_opcua_basic_types_1.decodeUInt16)(stream, this.dataSetWriterId);
        this.dataSetMetaData.decode(stream);
        this.dataSetFieldContentMask = decodeDataSetFieldContentMask(stream, this.dataSetFieldContentMask);
        this.messageReceiveTimeout = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.messageReceiveTimeout);
        this.keyFrameCount = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.keyFrameCount);
        this.headerLayoutUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.headerLayoutUri);
        this.securityMode = decodeMessageSecurityMode(stream, this.securityMode);
        this.securityGroupId = (0, node_opcua_basic_types_1.decodeString)(stream, this.securityGroupId);
        this.securityKeyServices = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new EndpointDescription(null);
            obj.decode(stream1);
            return obj;
        });
        this.dataSetReaderProperties = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new KeyValuePair(null);
            obj.decode(stream1);
            return obj;
        });
        this.transportSettings = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.transportSettings);
        this.messageSettings = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.messageSettings);
        this.subscribedDataSet = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.subscribedDataSet);
    }
    // Define Enumeration setters
    setDataSetFieldContentMask(value) {
        const coercedValue = exports._enumerationDataSetFieldContentMask.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to DataSetFieldContentMask :" + value);
        }
        this.dataSetFieldContentMask = coercedValue.value;
        return this.dataSetFieldContentMask;
    }
    setSecurityMode(value) {
        const coercedValue = exports._enumerationMessageSecurityMode.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to MessageSecurityMode :" + value);
        }
        this.securityMode = coercedValue.value;
        return this.securityMode;
    }
    get schema() { return schemaDataSetReaderDataType; }
}
exports.DataSetReaderDataType = DataSetReaderDataType;
DataSetReaderDataType.schema.dataTypeNodeId = DataSetReaderDataType.dataTypeNodeId;
DataSetReaderDataType.schema.encodingDefaultBinary = DataSetReaderDataType.encodingDefaultBinary;
DataSetReaderDataType.schema.encodingDefaultXml = DataSetReaderDataType.encodingDefaultXml;
DataSetReaderDataType.schema.encodingDefaultJson = DataSetReaderDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DataSetReaderDataType.dataTypeNodeId, "DataSetReaderDataType", DataSetReaderDataType);
// --------------------------------------------------------------------------------------------
const schemaDataSetReaderMessageDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DataSetReaderMessageDataType",
    baseType: "ExtensionObject",
    fields: []
});
class DataSetReaderMessageDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaDataSetReaderMessageDataType; }
    static possibleFields = [];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15629, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15706, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16009, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16288, 0);
    constructor(options) {
        super(options);
        if (options === null) {
            return;
        }
        const schema = DataSetReaderMessageDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    get schema() { return schemaDataSetReaderMessageDataType; }
}
exports.DataSetReaderMessageDataType = DataSetReaderMessageDataType;
DataSetReaderMessageDataType.schema.dataTypeNodeId = DataSetReaderMessageDataType.dataTypeNodeId;
DataSetReaderMessageDataType.schema.encodingDefaultBinary = DataSetReaderMessageDataType.encodingDefaultBinary;
DataSetReaderMessageDataType.schema.encodingDefaultXml = DataSetReaderMessageDataType.encodingDefaultXml;
DataSetReaderMessageDataType.schema.encodingDefaultJson = DataSetReaderMessageDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DataSetReaderMessageDataType.dataTypeNodeId, "DataSetReaderMessageDataType", DataSetReaderMessageDataType);
// --------------------------------------------------------------------------------------------
const schemaDataSetWriterDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DataSetWriterDataType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Name",
            fieldType: "String",
        },
        {
            name: "Enabled",
            fieldType: "Boolean",
        },
        {
            name: "DataSetWriterId",
            fieldType: "UInt16",
        },
        {
            name: "DataSetFieldContentMask",
            fieldType: "DataSetFieldContentMask",
        },
        {
            name: "KeyFrameCount",
            fieldType: "UInt32",
        },
        {
            name: "DataSetName",
            fieldType: "String",
        },
        {
            name: "DataSetWriterProperties",
            fieldType: "KeyValuePair",
            isArray: true
        },
        {
            name: "TransportSettings",
            fieldType: "ExtensionObject",
        },
        {
            name: "MessageSettings",
            fieldType: "ExtensionObject",
        },
    ]
});
class DataSetWriterDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaDataSetWriterDataType; }
    static possibleFields = [
        "name",
        "enabled",
        "dataSetWriterId",
        "dataSetFieldContentMask",
        "keyFrameCount",
        "dataSetName",
        "dataSetWriterProperties",
        "transportSettings",
        "messageSettings"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15597, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15682, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15955, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16156, 0);
    name;
    enabled;
    dataSetWriterId;
    dataSetFieldContentMask;
    keyFrameCount;
    dataSetName;
    dataSetWriterProperties;
    transportSettings;
    messageSettings;
    constructor(options) {
        super(options);
        if (options === null) {
            this.name = null;
            this.enabled = false;
            this.dataSetWriterId = 0;
            this.dataSetFieldContentMask = 0;
            this.keyFrameCount = 0;
            this.dataSetName = null;
            this.dataSetWriterProperties = null; /* null array */
            this.transportSettings = null;
            this.messageSettings = null;
            return;
        }
        const schema = DataSetWriterDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.name = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.name);
        this.enabled = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.enabled);
        this.dataSetWriterId = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.dataSetWriterId);
        this.dataSetFieldContentMask = this.setDataSetFieldContentMask((0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.dataSetFieldContentMask));
        this.keyFrameCount = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.keyFrameCount);
        this.dataSetName = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.dataSetName);
        this.dataSetWriterProperties = []; // should default
        if (options.dataSetWriterProperties) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.dataSetWriterProperties));
            this.dataSetWriterProperties = options.dataSetWriterProperties.map((e) => new KeyValuePair(e));
        }
        this.transportSettings = (0, node_opcua_factory_1.initialize_field)(schema.fields[7], options?.transportSettings);
        this.messageSettings = (0, node_opcua_factory_1.initialize_field)(schema.fields[8], options?.messageSettings);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.name, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.enabled, stream);
        (0, node_opcua_basic_types_1.encodeUInt16)(this.dataSetWriterId, stream);
        encodeDataSetFieldContentMask(this.dataSetFieldContentMask, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.keyFrameCount, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.dataSetName, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.dataSetWriterProperties, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.transportSettings, stream);
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.messageSettings, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = (0, node_opcua_basic_types_1.decodeString)(stream, this.name);
        this.enabled = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.enabled);
        this.dataSetWriterId = (0, node_opcua_basic_types_1.decodeUInt16)(stream, this.dataSetWriterId);
        this.dataSetFieldContentMask = decodeDataSetFieldContentMask(stream, this.dataSetFieldContentMask);
        this.keyFrameCount = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.keyFrameCount);
        this.dataSetName = (0, node_opcua_basic_types_1.decodeString)(stream, this.dataSetName);
        this.dataSetWriterProperties = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new KeyValuePair(null);
            obj.decode(stream1);
            return obj;
        });
        this.transportSettings = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.transportSettings);
        this.messageSettings = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.messageSettings);
    }
    // Define Enumeration setters
    setDataSetFieldContentMask(value) {
        const coercedValue = exports._enumerationDataSetFieldContentMask.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to DataSetFieldContentMask :" + value);
        }
        this.dataSetFieldContentMask = coercedValue.value;
        return this.dataSetFieldContentMask;
    }
    get schema() { return schemaDataSetWriterDataType; }
}
exports.DataSetWriterDataType = DataSetWriterDataType;
DataSetWriterDataType.schema.dataTypeNodeId = DataSetWriterDataType.dataTypeNodeId;
DataSetWriterDataType.schema.encodingDefaultBinary = DataSetWriterDataType.encodingDefaultBinary;
DataSetWriterDataType.schema.encodingDefaultXml = DataSetWriterDataType.encodingDefaultXml;
DataSetWriterDataType.schema.encodingDefaultJson = DataSetWriterDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DataSetWriterDataType.dataTypeNodeId, "DataSetWriterDataType", DataSetWriterDataType);
// --------------------------------------------------------------------------------------------
const schemaDataSetWriterMessageDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DataSetWriterMessageDataType",
    baseType: "ExtensionObject",
    fields: []
});
class DataSetWriterMessageDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaDataSetWriterMessageDataType; }
    static possibleFields = [];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15605, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15688, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15987, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16158, 0);
    constructor(options) {
        super(options);
        if (options === null) {
            return;
        }
        const schema = DataSetWriterMessageDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    get schema() { return schemaDataSetWriterMessageDataType; }
}
exports.DataSetWriterMessageDataType = DataSetWriterMessageDataType;
DataSetWriterMessageDataType.schema.dataTypeNodeId = DataSetWriterMessageDataType.dataTypeNodeId;
DataSetWriterMessageDataType.schema.encodingDefaultBinary = DataSetWriterMessageDataType.encodingDefaultBinary;
DataSetWriterMessageDataType.schema.encodingDefaultXml = DataSetWriterMessageDataType.encodingDefaultXml;
DataSetWriterMessageDataType.schema.encodingDefaultJson = DataSetWriterMessageDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DataSetWriterMessageDataType.dataTypeNodeId, "DataSetWriterMessageDataType", DataSetWriterMessageDataType);
// --------------------------------------------------------------------------------------------
const schemaNodeAttributes = (0, node_opcua_factory_1.buildStructuredType)({
    name: "NodeAttributes",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "SpecifiedAttributes",
            fieldType: "UInt32",
        },
        {
            name: "DisplayName",
            fieldType: "LocalizedText",
        },
        {
            name: "Description",
            fieldType: "LocalizedText",
        },
        {
            name: "WriteMask",
            fieldType: "UInt32",
        },
        {
            name: "UserWriteMask",
            fieldType: "UInt32",
        },
    ]
});
class NodeAttributes extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaNodeAttributes; }
    static possibleFields = [
        "specifiedAttributes",
        "displayName",
        "description",
        "writeMask",
        "userWriteMask"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(349, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(351, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(350, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15151, 0);
    specifiedAttributes;
    displayName;
    description;
    writeMask;
    userWriteMask;
    constructor(options) {
        super(options);
        if (options === null) {
            this.specifiedAttributes = 0;
            this.displayName = new node_opcua_data_model_1.LocalizedText(null);
            this.description = new node_opcua_data_model_1.LocalizedText(null);
            this.writeMask = 0;
            this.userWriteMask = 0;
            return;
        }
        const schema = NodeAttributes.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.specifiedAttributes = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.specifiedAttributes);
        this.displayName = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.displayName);
        this.description = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.description);
        this.writeMask = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.writeMask);
        this.userWriteMask = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.userWriteMask);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.specifiedAttributes, stream);
        (0, node_opcua_data_model_1.encodeLocalizedText)(this.displayName, stream);
        (0, node_opcua_data_model_1.encodeLocalizedText)(this.description, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.writeMask, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.userWriteMask, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.specifiedAttributes = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.specifiedAttributes);
        this.displayName = (0, node_opcua_data_model_1.decodeLocalizedText)(stream, this.displayName);
        this.description = (0, node_opcua_data_model_1.decodeLocalizedText)(stream, this.description);
        this.writeMask = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.writeMask);
        this.userWriteMask = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.userWriteMask);
    }
    get schema() { return schemaNodeAttributes; }
}
exports.NodeAttributes = NodeAttributes;
NodeAttributes.schema.dataTypeNodeId = NodeAttributes.dataTypeNodeId;
NodeAttributes.schema.encodingDefaultBinary = NodeAttributes.encodingDefaultBinary;
NodeAttributes.schema.encodingDefaultXml = NodeAttributes.encodingDefaultXml;
NodeAttributes.schema.encodingDefaultJson = NodeAttributes.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(NodeAttributes.dataTypeNodeId, "NodeAttributes", NodeAttributes);
// --------------------------------------------------------------------------------------------
const schemaDataTypeAttributes = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DataTypeAttributes",
    baseType: "NodeAttributes",
    fields: [
        {
            name: "IsAbstract",
            fieldType: "Boolean",
        },
    ]
});
class DataTypeAttributes extends NodeAttributes {
    static get schema() { return schemaDataTypeAttributes; }
    static possibleFields = [
        "specifiedAttributes",
        "displayName",
        "description",
        "writeMask",
        "userWriteMask",
        "isAbstract"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(370, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(372, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(371, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15161, 0);
    isAbstract;
    constructor(options) {
        super(options);
        if (options === null) {
            this.isAbstract = false;
            return;
        }
        const schema = DataTypeAttributes.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.isAbstract = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.isAbstract);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.isAbstract, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.isAbstract = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.isAbstract);
    }
    get schema() { return schemaDataTypeAttributes; }
}
exports.DataTypeAttributes = DataTypeAttributes;
DataTypeAttributes.schema.dataTypeNodeId = DataTypeAttributes.dataTypeNodeId;
DataTypeAttributes.schema.encodingDefaultBinary = DataTypeAttributes.encodingDefaultBinary;
DataTypeAttributes.schema.encodingDefaultXml = DataTypeAttributes.encodingDefaultXml;
DataTypeAttributes.schema.encodingDefaultJson = DataTypeAttributes.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DataTypeAttributes.dataTypeNodeId, "DataTypeAttributes", DataTypeAttributes);
// --------------------------------------------------------------------------------------------
const schemaDatagramConnectionTransportDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DatagramConnectionTransportDataType",
    baseType: "ConnectionTransportDataType",
    fields: [
        {
            name: "DiscoveryAddress",
            fieldType: "ExtensionObject",
        },
    ]
});
class DatagramConnectionTransportDataType extends ConnectionTransportDataType {
    static get schema() { return schemaDatagramConnectionTransportDataType; }
    static possibleFields = [
        "discoveryAddress"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(17467, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(17468, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(17472, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(17476, 0);
    discoveryAddress;
    constructor(options) {
        super(options);
        if (options === null) {
            this.discoveryAddress = null;
            return;
        }
        const schema = DatagramConnectionTransportDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.discoveryAddress = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.discoveryAddress);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.discoveryAddress, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.discoveryAddress = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.discoveryAddress);
    }
    get schema() { return schemaDatagramConnectionTransportDataType; }
}
exports.DatagramConnectionTransportDataType = DatagramConnectionTransportDataType;
DatagramConnectionTransportDataType.schema.dataTypeNodeId = DatagramConnectionTransportDataType.dataTypeNodeId;
DatagramConnectionTransportDataType.schema.encodingDefaultBinary = DatagramConnectionTransportDataType.encodingDefaultBinary;
DatagramConnectionTransportDataType.schema.encodingDefaultXml = DatagramConnectionTransportDataType.encodingDefaultXml;
DatagramConnectionTransportDataType.schema.encodingDefaultJson = DatagramConnectionTransportDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DatagramConnectionTransportDataType.dataTypeNodeId, "DatagramConnectionTransportDataType", DatagramConnectionTransportDataType);
// --------------------------------------------------------------------------------------------
const schemaDatagramConnectionTransport2DataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DatagramConnectionTransport2DataType",
    baseType: "DatagramConnectionTransportDataType",
    fields: [
        {
            name: "DiscoveryAnnounceRate",
            fieldType: "UInt32",
        },
        {
            name: "DiscoveryMaxMessageSize",
            fieldType: "UInt32",
        },
        {
            name: "QosCategory",
            fieldType: "String",
        },
        {
            name: "DatagramQos",
            fieldType: "ExtensionObject",
            isArray: true
        },
    ]
});
class DatagramConnectionTransport2DataType extends DatagramConnectionTransportDataType {
    static get schema() { return schemaDatagramConnectionTransport2DataType; }
    static possibleFields = [
        "discoveryAddress",
        "discoveryAnnounceRate",
        "discoveryMaxMessageSize",
        "qosCategory",
        "datagramQos"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23612, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23864, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23932, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(24000, 0);
    discoveryAnnounceRate;
    discoveryMaxMessageSize;
    qosCategory;
    datagramQos;
    constructor(options) {
        super(options);
        if (options === null) {
            this.discoveryAnnounceRate = 0;
            this.discoveryMaxMessageSize = 0;
            this.qosCategory = null;
            this.datagramQos = [];
            return;
        }
        const schema = DatagramConnectionTransport2DataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.discoveryAnnounceRate = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.discoveryAnnounceRate);
        this.discoveryMaxMessageSize = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.discoveryMaxMessageSize);
        this.qosCategory = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.qosCategory);
        this.datagramQos = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[3], options?.datagramQos);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.discoveryAnnounceRate, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.discoveryMaxMessageSize, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.qosCategory, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.datagramQos, stream, node_opcua_extension_object_1.encodeExtensionObject);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.discoveryAnnounceRate = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.discoveryAnnounceRate);
        this.discoveryMaxMessageSize = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.discoveryMaxMessageSize);
        this.qosCategory = (0, node_opcua_basic_types_1.decodeString)(stream, this.qosCategory);
        this.datagramQos = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_extension_object_1.decodeExtensionObject);
    }
    get schema() { return schemaDatagramConnectionTransport2DataType; }
}
exports.DatagramConnectionTransport2DataType = DatagramConnectionTransport2DataType;
DatagramConnectionTransport2DataType.schema.dataTypeNodeId = DatagramConnectionTransport2DataType.dataTypeNodeId;
DatagramConnectionTransport2DataType.schema.encodingDefaultBinary = DatagramConnectionTransport2DataType.encodingDefaultBinary;
DatagramConnectionTransport2DataType.schema.encodingDefaultXml = DatagramConnectionTransport2DataType.encodingDefaultXml;
DatagramConnectionTransport2DataType.schema.encodingDefaultJson = DatagramConnectionTransport2DataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DatagramConnectionTransport2DataType.dataTypeNodeId, "DatagramConnectionTransport2DataType", DatagramConnectionTransport2DataType);
// --------------------------------------------------------------------------------------------
const schemaDatagramDataSetReaderTransportDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DatagramDataSetReaderTransportDataType",
    baseType: "DataSetReaderTransportDataType",
    fields: [
        {
            name: "Address",
            fieldType: "ExtensionObject",
        },
        {
            name: "QosCategory",
            fieldType: "String",
        },
        {
            name: "DatagramQos",
            fieldType: "ExtensionObject",
            isArray: true
        },
        {
            name: "Topic",
            fieldType: "String",
        },
    ]
});
class DatagramDataSetReaderTransportDataType extends DataSetReaderTransportDataType {
    static get schema() { return schemaDatagramDataSetReaderTransportDataType; }
    static possibleFields = [
        "address",
        "qosCategory",
        "datagramQos",
        "topic"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23614, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23866, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23934, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(24002, 0);
    address;
    qosCategory;
    datagramQos;
    topic;
    constructor(options) {
        super(options);
        if (options === null) {
            this.address = null;
            this.qosCategory = null;
            this.datagramQos = [];
            this.topic = null;
            return;
        }
        const schema = DatagramDataSetReaderTransportDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.address = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.address);
        this.qosCategory = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.qosCategory);
        this.datagramQos = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.datagramQos);
        this.topic = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.topic);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.address, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.qosCategory, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.datagramQos, stream, node_opcua_extension_object_1.encodeExtensionObject);
        (0, node_opcua_basic_types_1.encodeString)(this.topic, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.address = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.address);
        this.qosCategory = (0, node_opcua_basic_types_1.decodeString)(stream, this.qosCategory);
        this.datagramQos = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_extension_object_1.decodeExtensionObject);
        this.topic = (0, node_opcua_basic_types_1.decodeString)(stream, this.topic);
    }
    get schema() { return schemaDatagramDataSetReaderTransportDataType; }
}
exports.DatagramDataSetReaderTransportDataType = DatagramDataSetReaderTransportDataType;
DatagramDataSetReaderTransportDataType.schema.dataTypeNodeId = DatagramDataSetReaderTransportDataType.dataTypeNodeId;
DatagramDataSetReaderTransportDataType.schema.encodingDefaultBinary = DatagramDataSetReaderTransportDataType.encodingDefaultBinary;
DatagramDataSetReaderTransportDataType.schema.encodingDefaultXml = DatagramDataSetReaderTransportDataType.encodingDefaultXml;
DatagramDataSetReaderTransportDataType.schema.encodingDefaultJson = DatagramDataSetReaderTransportDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DatagramDataSetReaderTransportDataType.dataTypeNodeId, "DatagramDataSetReaderTransportDataType", DatagramDataSetReaderTransportDataType);
// --------------------------------------------------------------------------------------------
const schemaDatagramWriterGroupTransportDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DatagramWriterGroupTransportDataType",
    baseType: "WriterGroupTransportDataType",
    fields: [
        {
            name: "MessageRepeatCount",
            fieldType: "Byte",
        },
        {
            name: "MessageRepeatDelay",
            fieldType: "Double",
        },
    ]
});
class DatagramWriterGroupTransportDataType extends WriterGroupTransportDataType {
    static get schema() { return schemaDatagramWriterGroupTransportDataType; }
    static possibleFields = [
        "messageRepeatCount",
        "messageRepeatDelay"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15532, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(21155, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(21179, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(21203, 0);
    messageRepeatCount;
    messageRepeatDelay;
    constructor(options) {
        super(options);
        if (options === null) {
            this.messageRepeatCount = 0;
            this.messageRepeatDelay = 0;
            return;
        }
        const schema = DatagramWriterGroupTransportDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.messageRepeatCount = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.messageRepeatCount);
        this.messageRepeatDelay = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.messageRepeatDelay);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeByte)(this.messageRepeatCount, stream);
        (0, node_opcua_basic_types_1.encodeDouble)(this.messageRepeatDelay, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.messageRepeatCount = (0, node_opcua_basic_types_1.decodeByte)(stream, this.messageRepeatCount);
        this.messageRepeatDelay = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.messageRepeatDelay);
    }
    get schema() { return schemaDatagramWriterGroupTransportDataType; }
}
exports.DatagramWriterGroupTransportDataType = DatagramWriterGroupTransportDataType;
DatagramWriterGroupTransportDataType.schema.dataTypeNodeId = DatagramWriterGroupTransportDataType.dataTypeNodeId;
DatagramWriterGroupTransportDataType.schema.encodingDefaultBinary = DatagramWriterGroupTransportDataType.encodingDefaultBinary;
DatagramWriterGroupTransportDataType.schema.encodingDefaultXml = DatagramWriterGroupTransportDataType.encodingDefaultXml;
DatagramWriterGroupTransportDataType.schema.encodingDefaultJson = DatagramWriterGroupTransportDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DatagramWriterGroupTransportDataType.dataTypeNodeId, "DatagramWriterGroupTransportDataType", DatagramWriterGroupTransportDataType);
// --------------------------------------------------------------------------------------------
const schemaDatagramWriterGroupTransport2DataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DatagramWriterGroupTransport2DataType",
    baseType: "DatagramWriterGroupTransportDataType",
    fields: [
        {
            name: "Address",
            fieldType: "ExtensionObject",
        },
        {
            name: "QosCategory",
            fieldType: "String",
        },
        {
            name: "DatagramQos",
            fieldType: "ExtensionObject",
            isArray: true
        },
        {
            name: "DiscoveryAnnounceRate",
            fieldType: "UInt32",
        },
        {
            name: "Topic",
            fieldType: "String",
        },
    ]
});
class DatagramWriterGroupTransport2DataType extends DatagramWriterGroupTransportDataType {
    static get schema() { return schemaDatagramWriterGroupTransport2DataType; }
    static possibleFields = [
        "messageRepeatCount",
        "messageRepeatDelay",
        "address",
        "qosCategory",
        "datagramQos",
        "discoveryAnnounceRate",
        "topic"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23613, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23865, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23933, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(24001, 0);
    address;
    qosCategory;
    datagramQos;
    discoveryAnnounceRate;
    topic;
    constructor(options) {
        super(options);
        if (options === null) {
            this.address = null;
            this.qosCategory = null;
            this.datagramQos = [];
            this.discoveryAnnounceRate = 0;
            this.topic = null;
            return;
        }
        const schema = DatagramWriterGroupTransport2DataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.address = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.address);
        this.qosCategory = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.qosCategory);
        this.datagramQos = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.datagramQos);
        this.discoveryAnnounceRate = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.discoveryAnnounceRate);
        this.topic = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.topic);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.address, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.qosCategory, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.datagramQos, stream, node_opcua_extension_object_1.encodeExtensionObject);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.discoveryAnnounceRate, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.topic, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.address = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.address);
        this.qosCategory = (0, node_opcua_basic_types_1.decodeString)(stream, this.qosCategory);
        this.datagramQos = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_extension_object_1.decodeExtensionObject);
        this.discoveryAnnounceRate = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.discoveryAnnounceRate);
        this.topic = (0, node_opcua_basic_types_1.decodeString)(stream, this.topic);
    }
    get schema() { return schemaDatagramWriterGroupTransport2DataType; }
}
exports.DatagramWriterGroupTransport2DataType = DatagramWriterGroupTransport2DataType;
DatagramWriterGroupTransport2DataType.schema.dataTypeNodeId = DatagramWriterGroupTransport2DataType.dataTypeNodeId;
DatagramWriterGroupTransport2DataType.schema.encodingDefaultBinary = DatagramWriterGroupTransport2DataType.encodingDefaultBinary;
DatagramWriterGroupTransport2DataType.schema.encodingDefaultXml = DatagramWriterGroupTransport2DataType.encodingDefaultXml;
DatagramWriterGroupTransport2DataType.schema.encodingDefaultJson = DatagramWriterGroupTransport2DataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DatagramWriterGroupTransport2DataType.dataTypeNodeId, "DatagramWriterGroupTransport2DataType", DatagramWriterGroupTransport2DataType);
// --------------------------------------------------------------------------------------------
const schemaHistoryUpdateDetails = (0, node_opcua_factory_1.buildStructuredType)({
    name: "HistoryUpdateDetails",
    baseType: "ExtensionObject",
    fields: []
});
class HistoryUpdateDetails extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaHistoryUpdateDetails; }
    static possibleFields = [];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(677, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(679, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(678, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15279, 0);
    constructor(options) {
        super(options);
        if (options === null) {
            return;
        }
        const schema = HistoryUpdateDetails.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    get schema() { return schemaHistoryUpdateDetails; }
}
exports.HistoryUpdateDetails = HistoryUpdateDetails;
HistoryUpdateDetails.schema.dataTypeNodeId = HistoryUpdateDetails.dataTypeNodeId;
HistoryUpdateDetails.schema.encodingDefaultBinary = HistoryUpdateDetails.encodingDefaultBinary;
HistoryUpdateDetails.schema.encodingDefaultXml = HistoryUpdateDetails.encodingDefaultXml;
HistoryUpdateDetails.schema.encodingDefaultJson = HistoryUpdateDetails.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(HistoryUpdateDetails.dataTypeNodeId, "HistoryUpdateDetails", HistoryUpdateDetails);
// --------------------------------------------------------------------------------------------
const schemaDeleteAtTimeDetails = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DeleteAtTimeDetails",
    baseType: "HistoryUpdateDetails",
    fields: [
        {
            name: "NodeId",
            fieldType: "NodeId",
        },
        {
            name: "ReqTimes",
            fieldType: "DateTime",
            isArray: true
        },
    ]
});
class DeleteAtTimeDetails extends HistoryUpdateDetails {
    static get schema() { return schemaDeleteAtTimeDetails; }
    static possibleFields = [
        "nodeId",
        "reqTimes"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(689, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(691, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(690, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15284, 0);
    nodeId;
    reqTimes;
    constructor(options) {
        super(options);
        if (options === null) {
            this.nodeId = new node_opcua_nodeid_1.NodeId(null);
            this.reqTimes = [];
            return;
        }
        const schema = DeleteAtTimeDetails.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.nodeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.nodeId);
        this.reqTimes = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.reqTimes);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.nodeId, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.reqTimes, stream, node_opcua_basic_types_1.encodeDateTime);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.nodeId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.nodeId);
        this.reqTimes = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeDateTime);
    }
    get schema() { return schemaDeleteAtTimeDetails; }
}
exports.DeleteAtTimeDetails = DeleteAtTimeDetails;
DeleteAtTimeDetails.schema.dataTypeNodeId = DeleteAtTimeDetails.dataTypeNodeId;
DeleteAtTimeDetails.schema.encodingDefaultBinary = DeleteAtTimeDetails.encodingDefaultBinary;
DeleteAtTimeDetails.schema.encodingDefaultXml = DeleteAtTimeDetails.encodingDefaultXml;
DeleteAtTimeDetails.schema.encodingDefaultJson = DeleteAtTimeDetails.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DeleteAtTimeDetails.dataTypeNodeId, "DeleteAtTimeDetails", DeleteAtTimeDetails);
// --------------------------------------------------------------------------------------------
const schemaDeleteEventDetails = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DeleteEventDetails",
    baseType: "HistoryUpdateDetails",
    fields: [
        {
            name: "NodeId",
            fieldType: "NodeId",
        },
        {
            name: "EventIds",
            fieldType: "ByteString",
            isArray: true
        },
    ]
});
class DeleteEventDetails extends HistoryUpdateDetails {
    static get schema() { return schemaDeleteEventDetails; }
    static possibleFields = [
        "nodeId",
        "eventIds"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(692, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(694, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(693, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15285, 0);
    nodeId;
    eventIds;
    constructor(options) {
        super(options);
        if (options === null) {
            this.nodeId = new node_opcua_nodeid_1.NodeId(null);
            this.eventIds = [];
            return;
        }
        const schema = DeleteEventDetails.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.nodeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.nodeId);
        this.eventIds = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.eventIds);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.nodeId, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.eventIds, stream, node_opcua_basic_types_1.encodeByteString);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.nodeId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.nodeId);
        this.eventIds = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeByteString);
    }
    get schema() { return schemaDeleteEventDetails; }
}
exports.DeleteEventDetails = DeleteEventDetails;
DeleteEventDetails.schema.dataTypeNodeId = DeleteEventDetails.dataTypeNodeId;
DeleteEventDetails.schema.encodingDefaultBinary = DeleteEventDetails.encodingDefaultBinary;
DeleteEventDetails.schema.encodingDefaultXml = DeleteEventDetails.encodingDefaultXml;
DeleteEventDetails.schema.encodingDefaultJson = DeleteEventDetails.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DeleteEventDetails.dataTypeNodeId, "DeleteEventDetails", DeleteEventDetails);
// --------------------------------------------------------------------------------------------
const schemaDeleteMonitoredItemsRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DeleteMonitoredItemsRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",
            fieldType: "RequestHeader",
        },
        {
            name: "SubscriptionId",
            fieldType: "UInt32",
        },
        {
            name: "MonitoredItemIds",
            fieldType: "UInt32",
            isArray: true
        },
    ]
});
class DeleteMonitoredItemsRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaDeleteMonitoredItemsRequest; }
    static possibleFields = [
        "requestHeader",
        "subscriptionId",
        "monitoredItemIds"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(779, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(781, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(780, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15335, 0);
    requestHeader;
    subscriptionId;
    monitoredItemIds;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestHeader = new RequestHeader(null);
            this.subscriptionId = 0;
            this.monitoredItemIds = [];
            return;
        }
        const schema = DeleteMonitoredItemsRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestHeader = new RequestHeader(options.requestHeader);
        this.subscriptionId = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.subscriptionId);
        this.monitoredItemIds = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.monitoredItemIds);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.subscriptionId, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.monitoredItemIds, stream, node_opcua_basic_types_1.encodeUInt32);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.subscriptionId = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.subscriptionId);
        this.monitoredItemIds = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeUInt32);
    }
    get schema() { return schemaDeleteMonitoredItemsRequest; }
}
exports.DeleteMonitoredItemsRequest = DeleteMonitoredItemsRequest;
DeleteMonitoredItemsRequest.schema.dataTypeNodeId = DeleteMonitoredItemsRequest.dataTypeNodeId;
DeleteMonitoredItemsRequest.schema.encodingDefaultBinary = DeleteMonitoredItemsRequest.encodingDefaultBinary;
DeleteMonitoredItemsRequest.schema.encodingDefaultXml = DeleteMonitoredItemsRequest.encodingDefaultXml;
DeleteMonitoredItemsRequest.schema.encodingDefaultJson = DeleteMonitoredItemsRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DeleteMonitoredItemsRequest.dataTypeNodeId, "DeleteMonitoredItemsRequest", DeleteMonitoredItemsRequest);
// --------------------------------------------------------------------------------------------
const schemaDeleteMonitoredItemsResponse = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DeleteMonitoredItemsResponse",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",
            fieldType: "ResponseHeader",
        },
        {
            name: "Results",
            fieldType: "StatusCode",
            isArray: true
        },
        {
            name: "DiagnosticInfos",
            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
class DeleteMonitoredItemsResponse extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaDeleteMonitoredItemsResponse; }
    static possibleFields = [
        "responseHeader",
        "results",
        "diagnosticInfos"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(782, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(784, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(783, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15336, 0);
    responseHeader;
    results;
    diagnosticInfos;
    constructor(options) {
        super(options);
        if (options === null) {
            this.responseHeader = new ResponseHeader(null);
            this.results = [];
            this.diagnosticInfos = [];
            return;
        }
        const schema = DeleteMonitoredItemsResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.responseHeader = new ResponseHeader(options.responseHeader);
        this.results = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.results);
        this.diagnosticInfos = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.diagnosticInfos);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.results, stream, node_opcua_status_code_1.encodeStatusCode);
        (0, node_opcua_basic_types_1.encodeArray)(this.diagnosticInfos, stream, node_opcua_data_model_1.encodeDiagnosticInfo);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_status_code_1.decodeStatusCode);
        this.diagnosticInfos = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_data_model_1.decodeDiagnosticInfo);
    }
    get schema() { return schemaDeleteMonitoredItemsResponse; }
}
exports.DeleteMonitoredItemsResponse = DeleteMonitoredItemsResponse;
DeleteMonitoredItemsResponse.schema.dataTypeNodeId = DeleteMonitoredItemsResponse.dataTypeNodeId;
DeleteMonitoredItemsResponse.schema.encodingDefaultBinary = DeleteMonitoredItemsResponse.encodingDefaultBinary;
DeleteMonitoredItemsResponse.schema.encodingDefaultXml = DeleteMonitoredItemsResponse.encodingDefaultXml;
DeleteMonitoredItemsResponse.schema.encodingDefaultJson = DeleteMonitoredItemsResponse.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DeleteMonitoredItemsResponse.dataTypeNodeId, "DeleteMonitoredItemsResponse", DeleteMonitoredItemsResponse);
// --------------------------------------------------------------------------------------------
const schemaDeleteNodesItem = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DeleteNodesItem",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "NodeId",
            fieldType: "NodeId",
        },
        {
            name: "DeleteTargetReferences",
            fieldType: "Boolean",
        },
    ]
});
class DeleteNodesItem extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaDeleteNodesItem; }
    static possibleFields = [
        "nodeId",
        "deleteTargetReferences"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(382, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(384, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(383, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15172, 0);
    nodeId;
    deleteTargetReferences;
    constructor(options) {
        super(options);
        if (options === null) {
            this.nodeId = new node_opcua_nodeid_1.NodeId(null);
            this.deleteTargetReferences = false;
            return;
        }
        const schema = DeleteNodesItem.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.nodeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.nodeId);
        this.deleteTargetReferences = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.deleteTargetReferences);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.nodeId, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.deleteTargetReferences, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.nodeId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.nodeId);
        this.deleteTargetReferences = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.deleteTargetReferences);
    }
    get schema() { return schemaDeleteNodesItem; }
}
exports.DeleteNodesItem = DeleteNodesItem;
DeleteNodesItem.schema.dataTypeNodeId = DeleteNodesItem.dataTypeNodeId;
DeleteNodesItem.schema.encodingDefaultBinary = DeleteNodesItem.encodingDefaultBinary;
DeleteNodesItem.schema.encodingDefaultXml = DeleteNodesItem.encodingDefaultXml;
DeleteNodesItem.schema.encodingDefaultJson = DeleteNodesItem.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DeleteNodesItem.dataTypeNodeId, "DeleteNodesItem", DeleteNodesItem);
// --------------------------------------------------------------------------------------------
const schemaDeleteNodesRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DeleteNodesRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",
            fieldType: "RequestHeader",
        },
        {
            name: "NodesToDelete",
            fieldType: "DeleteNodesItem",
            isArray: true
        },
    ]
});
class DeleteNodesRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaDeleteNodesRequest; }
    static possibleFields = [
        "requestHeader",
        "nodesToDelete"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(498, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(500, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(499, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15173, 0);
    requestHeader;
    nodesToDelete;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestHeader = new RequestHeader(null);
            this.nodesToDelete = null; /* null array */
            return;
        }
        const schema = DeleteNodesRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestHeader = new RequestHeader(options.requestHeader);
        this.nodesToDelete = []; // should default
        if (options.nodesToDelete) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.nodesToDelete));
            this.nodesToDelete = options.nodesToDelete.map((e) => new DeleteNodesItem(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.nodesToDelete, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.nodesToDelete = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new DeleteNodesItem(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaDeleteNodesRequest; }
}
exports.DeleteNodesRequest = DeleteNodesRequest;
DeleteNodesRequest.schema.dataTypeNodeId = DeleteNodesRequest.dataTypeNodeId;
DeleteNodesRequest.schema.encodingDefaultBinary = DeleteNodesRequest.encodingDefaultBinary;
DeleteNodesRequest.schema.encodingDefaultXml = DeleteNodesRequest.encodingDefaultXml;
DeleteNodesRequest.schema.encodingDefaultJson = DeleteNodesRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DeleteNodesRequest.dataTypeNodeId, "DeleteNodesRequest", DeleteNodesRequest);
// --------------------------------------------------------------------------------------------
const schemaDeleteNodesResponse = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DeleteNodesResponse",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",
            fieldType: "ResponseHeader",
        },
        {
            name: "Results",
            fieldType: "StatusCode",
            isArray: true
        },
        {
            name: "DiagnosticInfos",
            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
class DeleteNodesResponse extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaDeleteNodesResponse; }
    static possibleFields = [
        "responseHeader",
        "results",
        "diagnosticInfos"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(501, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(503, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(502, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15174, 0);
    responseHeader;
    results;
    diagnosticInfos;
    constructor(options) {
        super(options);
        if (options === null) {
            this.responseHeader = new ResponseHeader(null);
            this.results = [];
            this.diagnosticInfos = [];
            return;
        }
        const schema = DeleteNodesResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.responseHeader = new ResponseHeader(options.responseHeader);
        this.results = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.results);
        this.diagnosticInfos = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.diagnosticInfos);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.results, stream, node_opcua_status_code_1.encodeStatusCode);
        (0, node_opcua_basic_types_1.encodeArray)(this.diagnosticInfos, stream, node_opcua_data_model_1.encodeDiagnosticInfo);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_status_code_1.decodeStatusCode);
        this.diagnosticInfos = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_data_model_1.decodeDiagnosticInfo);
    }
    get schema() { return schemaDeleteNodesResponse; }
}
exports.DeleteNodesResponse = DeleteNodesResponse;
DeleteNodesResponse.schema.dataTypeNodeId = DeleteNodesResponse.dataTypeNodeId;
DeleteNodesResponse.schema.encodingDefaultBinary = DeleteNodesResponse.encodingDefaultBinary;
DeleteNodesResponse.schema.encodingDefaultXml = DeleteNodesResponse.encodingDefaultXml;
DeleteNodesResponse.schema.encodingDefaultJson = DeleteNodesResponse.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DeleteNodesResponse.dataTypeNodeId, "DeleteNodesResponse", DeleteNodesResponse);
// --------------------------------------------------------------------------------------------
const schemaDeleteRawModifiedDetails = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DeleteRawModifiedDetails",
    baseType: "HistoryUpdateDetails",
    fields: [
        {
            name: "NodeId",
            fieldType: "NodeId",
        },
        {
            name: "IsDeleteModified",
            fieldType: "Boolean",
        },
        {
            name: "StartTime",
            fieldType: "DateTime",
        },
        {
            name: "EndTime",
            fieldType: "DateTime",
        },
    ]
});
class DeleteRawModifiedDetails extends HistoryUpdateDetails {
    static get schema() { return schemaDeleteRawModifiedDetails; }
    static possibleFields = [
        "nodeId",
        "isDeleteModified",
        "startTime",
        "endTime"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(686, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(688, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(687, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15283, 0);
    nodeId;
    isDeleteModified;
    startTime;
    endTime;
    constructor(options) {
        super(options);
        if (options === null) {
            this.nodeId = new node_opcua_nodeid_1.NodeId(null);
            this.isDeleteModified = false;
            this.startTime = new Date();
            this.endTime = new Date();
            return;
        }
        const schema = DeleteRawModifiedDetails.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.nodeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.nodeId);
        this.isDeleteModified = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.isDeleteModified);
        this.startTime = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.startTime);
        this.endTime = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.endTime);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.nodeId, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.isDeleteModified, stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.startTime, stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.endTime, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.nodeId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.nodeId);
        this.isDeleteModified = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.isDeleteModified);
        this.startTime = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.startTime);
        this.endTime = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.endTime);
    }
    get schema() { return schemaDeleteRawModifiedDetails; }
}
exports.DeleteRawModifiedDetails = DeleteRawModifiedDetails;
DeleteRawModifiedDetails.schema.dataTypeNodeId = DeleteRawModifiedDetails.dataTypeNodeId;
DeleteRawModifiedDetails.schema.encodingDefaultBinary = DeleteRawModifiedDetails.encodingDefaultBinary;
DeleteRawModifiedDetails.schema.encodingDefaultXml = DeleteRawModifiedDetails.encodingDefaultXml;
DeleteRawModifiedDetails.schema.encodingDefaultJson = DeleteRawModifiedDetails.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DeleteRawModifiedDetails.dataTypeNodeId, "DeleteRawModifiedDetails", DeleteRawModifiedDetails);
// --------------------------------------------------------------------------------------------
const schemaDeleteReferencesItem = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DeleteReferencesItem",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "SourceNodeId",
            fieldType: "NodeId",
        },
        {
            name: "ReferenceTypeId",
            fieldType: "NodeId",
        },
        {
            name: "IsForward",
            fieldType: "Boolean",
        },
        {
            name: "TargetNodeId",
            fieldType: "ExpandedNodeId",
        },
        {
            name: "DeleteBidirectional",
            fieldType: "Boolean",
        },
    ]
});
class DeleteReferencesItem extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaDeleteReferencesItem; }
    static possibleFields = [
        "sourceNodeId",
        "referenceTypeId",
        "isForward",
        "targetNodeId",
        "deleteBidirectional"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(385, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(387, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(386, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15175, 0);
    sourceNodeId;
    referenceTypeId;
    isForward;
    targetNodeId;
    deleteBidirectional;
    constructor(options) {
        super(options);
        if (options === null) {
            this.sourceNodeId = new node_opcua_nodeid_1.NodeId(null);
            this.referenceTypeId = new node_opcua_nodeid_1.NodeId(null);
            this.isForward = false;
            this.targetNodeId = new node_opcua_nodeid_1.ExpandedNodeId(null);
            this.deleteBidirectional = false;
            return;
        }
        const schema = DeleteReferencesItem.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.sourceNodeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.sourceNodeId);
        this.referenceTypeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.referenceTypeId);
        this.isForward = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.isForward);
        this.targetNodeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.targetNodeId);
        this.deleteBidirectional = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.deleteBidirectional);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.sourceNodeId, stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.referenceTypeId, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.isForward, stream);
        (0, node_opcua_basic_types_1.encodeExpandedNodeId)(this.targetNodeId, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.deleteBidirectional, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.sourceNodeId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.sourceNodeId);
        this.referenceTypeId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.referenceTypeId);
        this.isForward = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.isForward);
        this.targetNodeId = (0, node_opcua_basic_types_1.decodeExpandedNodeId)(stream, this.targetNodeId);
        this.deleteBidirectional = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.deleteBidirectional);
    }
    get schema() { return schemaDeleteReferencesItem; }
}
exports.DeleteReferencesItem = DeleteReferencesItem;
DeleteReferencesItem.schema.dataTypeNodeId = DeleteReferencesItem.dataTypeNodeId;
DeleteReferencesItem.schema.encodingDefaultBinary = DeleteReferencesItem.encodingDefaultBinary;
DeleteReferencesItem.schema.encodingDefaultXml = DeleteReferencesItem.encodingDefaultXml;
DeleteReferencesItem.schema.encodingDefaultJson = DeleteReferencesItem.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DeleteReferencesItem.dataTypeNodeId, "DeleteReferencesItem", DeleteReferencesItem);
// --------------------------------------------------------------------------------------------
const schemaDeleteReferencesRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DeleteReferencesRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",
            fieldType: "RequestHeader",
        },
        {
            name: "ReferencesToDelete",
            fieldType: "DeleteReferencesItem",
            isArray: true
        },
    ]
});
class DeleteReferencesRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaDeleteReferencesRequest; }
    static possibleFields = [
        "requestHeader",
        "referencesToDelete"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(504, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(506, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(505, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15176, 0);
    requestHeader;
    referencesToDelete;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestHeader = new RequestHeader(null);
            this.referencesToDelete = null; /* null array */
            return;
        }
        const schema = DeleteReferencesRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestHeader = new RequestHeader(options.requestHeader);
        this.referencesToDelete = []; // should default
        if (options.referencesToDelete) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.referencesToDelete));
            this.referencesToDelete = options.referencesToDelete.map((e) => new DeleteReferencesItem(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.referencesToDelete, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.referencesToDelete = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new DeleteReferencesItem(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaDeleteReferencesRequest; }
}
exports.DeleteReferencesRequest = DeleteReferencesRequest;
DeleteReferencesRequest.schema.dataTypeNodeId = DeleteReferencesRequest.dataTypeNodeId;
DeleteReferencesRequest.schema.encodingDefaultBinary = DeleteReferencesRequest.encodingDefaultBinary;
DeleteReferencesRequest.schema.encodingDefaultXml = DeleteReferencesRequest.encodingDefaultXml;
DeleteReferencesRequest.schema.encodingDefaultJson = DeleteReferencesRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DeleteReferencesRequest.dataTypeNodeId, "DeleteReferencesRequest", DeleteReferencesRequest);
// --------------------------------------------------------------------------------------------
const schemaDeleteReferencesResponse = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DeleteReferencesResponse",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",
            fieldType: "ResponseHeader",
        },
        {
            name: "Results",
            fieldType: "StatusCode",
            isArray: true
        },
        {
            name: "DiagnosticInfos",
            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
class DeleteReferencesResponse extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaDeleteReferencesResponse; }
    static possibleFields = [
        "responseHeader",
        "results",
        "diagnosticInfos"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(507, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(509, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(508, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15177, 0);
    responseHeader;
    results;
    diagnosticInfos;
    constructor(options) {
        super(options);
        if (options === null) {
            this.responseHeader = new ResponseHeader(null);
            this.results = [];
            this.diagnosticInfos = [];
            return;
        }
        const schema = DeleteReferencesResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.responseHeader = new ResponseHeader(options.responseHeader);
        this.results = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.results);
        this.diagnosticInfos = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.diagnosticInfos);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.results, stream, node_opcua_status_code_1.encodeStatusCode);
        (0, node_opcua_basic_types_1.encodeArray)(this.diagnosticInfos, stream, node_opcua_data_model_1.encodeDiagnosticInfo);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_status_code_1.decodeStatusCode);
        this.diagnosticInfos = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_data_model_1.decodeDiagnosticInfo);
    }
    get schema() { return schemaDeleteReferencesResponse; }
}
exports.DeleteReferencesResponse = DeleteReferencesResponse;
DeleteReferencesResponse.schema.dataTypeNodeId = DeleteReferencesResponse.dataTypeNodeId;
DeleteReferencesResponse.schema.encodingDefaultBinary = DeleteReferencesResponse.encodingDefaultBinary;
DeleteReferencesResponse.schema.encodingDefaultXml = DeleteReferencesResponse.encodingDefaultXml;
DeleteReferencesResponse.schema.encodingDefaultJson = DeleteReferencesResponse.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DeleteReferencesResponse.dataTypeNodeId, "DeleteReferencesResponse", DeleteReferencesResponse);
// --------------------------------------------------------------------------------------------
const schemaDeleteSubscriptionsRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DeleteSubscriptionsRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",
            fieldType: "RequestHeader",
        },
        {
            name: "SubscriptionIds",
            fieldType: "UInt32",
            isArray: true
        },
    ]
});
class DeleteSubscriptionsRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaDeleteSubscriptionsRequest; }
    static possibleFields = [
        "requestHeader",
        "subscriptionIds"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(845, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(847, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(846, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15359, 0);
    requestHeader;
    subscriptionIds;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestHeader = new RequestHeader(null);
            this.subscriptionIds = [];
            return;
        }
        const schema = DeleteSubscriptionsRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestHeader = new RequestHeader(options.requestHeader);
        this.subscriptionIds = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.subscriptionIds);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.subscriptionIds, stream, node_opcua_basic_types_1.encodeUInt32);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.subscriptionIds = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeUInt32);
    }
    get schema() { return schemaDeleteSubscriptionsRequest; }
}
exports.DeleteSubscriptionsRequest = DeleteSubscriptionsRequest;
DeleteSubscriptionsRequest.schema.dataTypeNodeId = DeleteSubscriptionsRequest.dataTypeNodeId;
DeleteSubscriptionsRequest.schema.encodingDefaultBinary = DeleteSubscriptionsRequest.encodingDefaultBinary;
DeleteSubscriptionsRequest.schema.encodingDefaultXml = DeleteSubscriptionsRequest.encodingDefaultXml;
DeleteSubscriptionsRequest.schema.encodingDefaultJson = DeleteSubscriptionsRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DeleteSubscriptionsRequest.dataTypeNodeId, "DeleteSubscriptionsRequest", DeleteSubscriptionsRequest);
// --------------------------------------------------------------------------------------------
const schemaDeleteSubscriptionsResponse = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DeleteSubscriptionsResponse",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",
            fieldType: "ResponseHeader",
        },
        {
            name: "Results",
            fieldType: "StatusCode",
            isArray: true
        },
        {
            name: "DiagnosticInfos",
            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
class DeleteSubscriptionsResponse extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaDeleteSubscriptionsResponse; }
    static possibleFields = [
        "responseHeader",
        "results",
        "diagnosticInfos"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(848, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(850, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(849, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15360, 0);
    responseHeader;
    results;
    diagnosticInfos;
    constructor(options) {
        super(options);
        if (options === null) {
            this.responseHeader = new ResponseHeader(null);
            this.results = [];
            this.diagnosticInfos = [];
            return;
        }
        const schema = DeleteSubscriptionsResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.responseHeader = new ResponseHeader(options.responseHeader);
        this.results = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.results);
        this.diagnosticInfos = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.diagnosticInfos);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.results, stream, node_opcua_status_code_1.encodeStatusCode);
        (0, node_opcua_basic_types_1.encodeArray)(this.diagnosticInfos, stream, node_opcua_data_model_1.encodeDiagnosticInfo);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_status_code_1.decodeStatusCode);
        this.diagnosticInfos = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_data_model_1.decodeDiagnosticInfo);
    }
    get schema() { return schemaDeleteSubscriptionsResponse; }
}
exports.DeleteSubscriptionsResponse = DeleteSubscriptionsResponse;
DeleteSubscriptionsResponse.schema.dataTypeNodeId = DeleteSubscriptionsResponse.dataTypeNodeId;
DeleteSubscriptionsResponse.schema.encodingDefaultBinary = DeleteSubscriptionsResponse.encodingDefaultBinary;
DeleteSubscriptionsResponse.schema.encodingDefaultXml = DeleteSubscriptionsResponse.encodingDefaultXml;
DeleteSubscriptionsResponse.schema.encodingDefaultJson = DeleteSubscriptionsResponse.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DeleteSubscriptionsResponse.dataTypeNodeId, "DeleteSubscriptionsResponse", DeleteSubscriptionsResponse);
// --------------------------------------------------------------------------------------------
const schemaDiscoveryConfiguration = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DiscoveryConfiguration",
    baseType: "ExtensionObject",
    fields: []
});
class DiscoveryConfiguration extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaDiscoveryConfiguration; }
    static possibleFields = [];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12890, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12900, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12892, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15105, 0);
    constructor(options) {
        super(options);
        if (options === null) {
            return;
        }
        const schema = DiscoveryConfiguration.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    get schema() { return schemaDiscoveryConfiguration; }
}
exports.DiscoveryConfiguration = DiscoveryConfiguration;
DiscoveryConfiguration.schema.dataTypeNodeId = DiscoveryConfiguration.dataTypeNodeId;
DiscoveryConfiguration.schema.encodingDefaultBinary = DiscoveryConfiguration.encodingDefaultBinary;
DiscoveryConfiguration.schema.encodingDefaultXml = DiscoveryConfiguration.encodingDefaultXml;
DiscoveryConfiguration.schema.encodingDefaultJson = DiscoveryConfiguration.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DiscoveryConfiguration.dataTypeNodeId, "DiscoveryConfiguration", DiscoveryConfiguration);
// --------------------------------------------------------------------------------------------
const schemaDoubleComplexNumberType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DoubleComplexNumberType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Real",
            fieldType: "Double",
        },
        {
            name: "Imaginary",
            fieldType: "Double",
        },
    ]
});
class DoubleComplexNumberType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaDoubleComplexNumberType; }
    static possibleFields = [
        "real",
        "imaginary"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12172, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12182, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12174, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15378, 0);
    real;
    imaginary;
    constructor(options) {
        super(options);
        if (options === null) {
            this.real = 0;
            this.imaginary = 0;
            return;
        }
        const schema = DoubleComplexNumberType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.real = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.real);
        this.imaginary = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.imaginary);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeDouble)(this.real, stream);
        (0, node_opcua_basic_types_1.encodeDouble)(this.imaginary, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.real = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.real);
        this.imaginary = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.imaginary);
    }
    get schema() { return schemaDoubleComplexNumberType; }
}
exports.DoubleComplexNumberType = DoubleComplexNumberType;
DoubleComplexNumberType.schema.dataTypeNodeId = DoubleComplexNumberType.dataTypeNodeId;
DoubleComplexNumberType.schema.encodingDefaultBinary = DoubleComplexNumberType.encodingDefaultBinary;
DoubleComplexNumberType.schema.encodingDefaultXml = DoubleComplexNumberType.encodingDefaultXml;
DoubleComplexNumberType.schema.encodingDefaultJson = DoubleComplexNumberType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DoubleComplexNumberType.dataTypeNodeId, "DoubleComplexNumberType", DoubleComplexNumberType);
// --------------------------------------------------------------------------------------------
const schemaDtlsPubSubConnectionDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "DtlsPubSubConnectionDataType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ClientCipherSuite",
            fieldType: "String",
        },
        {
            name: "ServerCipherSuites",
            fieldType: "String",
            isArray: true
        },
        {
            name: "ZeroRTT",
            fieldType: "Boolean",
        },
        {
            name: "CertificateGroupId",
            fieldType: "NodeId",
        },
        {
            name: "VerifyClientCertificate",
            fieldType: "Boolean",
        },
    ]
});
class DtlsPubSubConnectionDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaDtlsPubSubConnectionDataType; }
    static possibleFields = [
        "clientCipherSuite",
        "serverCipherSuites",
        "zeroRTT",
        "certificateGroupId",
        "verifyClientCertificate"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    clientCipherSuite;
    serverCipherSuites;
    zeroRTT;
    certificateGroupId;
    verifyClientCertificate;
    constructor(options) {
        super(options);
        if (options === null) {
            this.clientCipherSuite = null;
            this.serverCipherSuites = [];
            this.zeroRTT = false;
            this.certificateGroupId = new node_opcua_nodeid_1.NodeId(null);
            this.verifyClientCertificate = false;
            return;
        }
        const schema = DtlsPubSubConnectionDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.clientCipherSuite = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.clientCipherSuite);
        this.serverCipherSuites = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.serverCipherSuites);
        this.zeroRTT = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.zeroRTT);
        this.certificateGroupId = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.certificateGroupId);
        this.verifyClientCertificate = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.verifyClientCertificate);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.clientCipherSuite, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.serverCipherSuites, stream, node_opcua_basic_types_1.encodeString);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.zeroRTT, stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.certificateGroupId, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.verifyClientCertificate, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.clientCipherSuite = (0, node_opcua_basic_types_1.decodeString)(stream, this.clientCipherSuite);
        this.serverCipherSuites = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeString);
        this.zeroRTT = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.zeroRTT);
        this.certificateGroupId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.certificateGroupId);
        this.verifyClientCertificate = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.verifyClientCertificate);
    }
    get schema() { return schemaDtlsPubSubConnectionDataType; }
}
exports.DtlsPubSubConnectionDataType = DtlsPubSubConnectionDataType;
DtlsPubSubConnectionDataType.schema.dataTypeNodeId = DtlsPubSubConnectionDataType.dataTypeNodeId;
DtlsPubSubConnectionDataType.schema.encodingDefaultBinary = DtlsPubSubConnectionDataType.encodingDefaultBinary;
DtlsPubSubConnectionDataType.schema.encodingDefaultXml = DtlsPubSubConnectionDataType.encodingDefaultXml;
DtlsPubSubConnectionDataType.schema.encodingDefaultJson = DtlsPubSubConnectionDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(DtlsPubSubConnectionDataType.dataTypeNodeId, "DtlsPubSubConnectionDataType", DtlsPubSubConnectionDataType);
// --------------------------------------------------------------------------------------------
const schemaElementOperand = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ElementOperand",
    baseType: "FilterOperand",
    fields: [
        {
            name: "Index",
            fieldType: "UInt32",
        },
    ]
});
class ElementOperand extends FilterOperand {
    static get schema() { return schemaElementOperand; }
    static possibleFields = [
        "index"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(592, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(594, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(593, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15207, 0);
    index;
    constructor(options) {
        super(options);
        if (options === null) {
            this.index = 0;
            return;
        }
        const schema = ElementOperand.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.index = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.index);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.index, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.index = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.index);
    }
    get schema() { return schemaElementOperand; }
}
exports.ElementOperand = ElementOperand;
ElementOperand.schema.dataTypeNodeId = ElementOperand.dataTypeNodeId;
ElementOperand.schema.encodingDefaultBinary = ElementOperand.encodingDefaultBinary;
ElementOperand.schema.encodingDefaultXml = ElementOperand.encodingDefaultXml;
ElementOperand.schema.encodingDefaultJson = ElementOperand.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ElementOperand.dataTypeNodeId, "ElementOperand", ElementOperand);
// --------------------------------------------------------------------------------------------
const schemaEndpointConfiguration = (0, node_opcua_factory_1.buildStructuredType)({
    name: "EndpointConfiguration",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "OperationTimeout",
            fieldType: "Int32",
        },
        {
            name: "UseBinaryEncoding",
            fieldType: "Boolean",
        },
        {
            name: "MaxStringLength",
            fieldType: "Int32",
        },
        {
            name: "MaxByteStringLength",
            fieldType: "Int32",
        },
        {
            name: "MaxArrayLength",
            fieldType: "Int32",
        },
        {
            name: "MaxMessageSize",
            fieldType: "Int32",
        },
        {
            name: "MaxBufferSize",
            fieldType: "Int32",
        },
        {
            name: "ChannelLifetime",
            fieldType: "Int32",
        },
        {
            name: "SecurityTokenLifetime",
            fieldType: "Int32",
        },
    ]
});
class EndpointConfiguration extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaEndpointConfiguration; }
    static possibleFields = [
        "operationTimeout",
        "useBinaryEncoding",
        "maxStringLength",
        "maxByteStringLength",
        "maxArrayLength",
        "maxMessageSize",
        "maxBufferSize",
        "channelLifetime",
        "securityTokenLifetime"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(331, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(333, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(332, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15199, 0);
    operationTimeout;
    useBinaryEncoding;
    maxStringLength;
    maxByteStringLength;
    maxArrayLength;
    maxMessageSize;
    maxBufferSize;
    channelLifetime;
    securityTokenLifetime;
    constructor(options) {
        super(options);
        if (options === null) {
            this.operationTimeout = 0;
            this.useBinaryEncoding = false;
            this.maxStringLength = 0;
            this.maxByteStringLength = 0;
            this.maxArrayLength = 0;
            this.maxMessageSize = 0;
            this.maxBufferSize = 0;
            this.channelLifetime = 0;
            this.securityTokenLifetime = 0;
            return;
        }
        const schema = EndpointConfiguration.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.operationTimeout = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.operationTimeout);
        this.useBinaryEncoding = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.useBinaryEncoding);
        this.maxStringLength = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.maxStringLength);
        this.maxByteStringLength = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.maxByteStringLength);
        this.maxArrayLength = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.maxArrayLength);
        this.maxMessageSize = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.maxMessageSize);
        this.maxBufferSize = (0, node_opcua_factory_1.initialize_field)(schema.fields[6], options?.maxBufferSize);
        this.channelLifetime = (0, node_opcua_factory_1.initialize_field)(schema.fields[7], options?.channelLifetime);
        this.securityTokenLifetime = (0, node_opcua_factory_1.initialize_field)(schema.fields[8], options?.securityTokenLifetime);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeInt32)(this.operationTimeout, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.useBinaryEncoding, stream);
        (0, node_opcua_basic_types_1.encodeInt32)(this.maxStringLength, stream);
        (0, node_opcua_basic_types_1.encodeInt32)(this.maxByteStringLength, stream);
        (0, node_opcua_basic_types_1.encodeInt32)(this.maxArrayLength, stream);
        (0, node_opcua_basic_types_1.encodeInt32)(this.maxMessageSize, stream);
        (0, node_opcua_basic_types_1.encodeInt32)(this.maxBufferSize, stream);
        (0, node_opcua_basic_types_1.encodeInt32)(this.channelLifetime, stream);
        (0, node_opcua_basic_types_1.encodeInt32)(this.securityTokenLifetime, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.operationTimeout = (0, node_opcua_basic_types_1.decodeInt32)(stream, this.operationTimeout);
        this.useBinaryEncoding = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.useBinaryEncoding);
        this.maxStringLength = (0, node_opcua_basic_types_1.decodeInt32)(stream, this.maxStringLength);
        this.maxByteStringLength = (0, node_opcua_basic_types_1.decodeInt32)(stream, this.maxByteStringLength);
        this.maxArrayLength = (0, node_opcua_basic_types_1.decodeInt32)(stream, this.maxArrayLength);
        this.maxMessageSize = (0, node_opcua_basic_types_1.decodeInt32)(stream, this.maxMessageSize);
        this.maxBufferSize = (0, node_opcua_basic_types_1.decodeInt32)(stream, this.maxBufferSize);
        this.channelLifetime = (0, node_opcua_basic_types_1.decodeInt32)(stream, this.channelLifetime);
        this.securityTokenLifetime = (0, node_opcua_basic_types_1.decodeInt32)(stream, this.securityTokenLifetime);
    }
    get schema() { return schemaEndpointConfiguration; }
}
exports.EndpointConfiguration = EndpointConfiguration;
EndpointConfiguration.schema.dataTypeNodeId = EndpointConfiguration.dataTypeNodeId;
EndpointConfiguration.schema.encodingDefaultBinary = EndpointConfiguration.encodingDefaultBinary;
EndpointConfiguration.schema.encodingDefaultXml = EndpointConfiguration.encodingDefaultXml;
EndpointConfiguration.schema.encodingDefaultJson = EndpointConfiguration.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(EndpointConfiguration.dataTypeNodeId, "EndpointConfiguration", EndpointConfiguration);
// --------------------------------------------------------------------------------------------
const schemaEndpointType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "EndpointType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "EndpointUrl",
            fieldType: "String",
        },
        {
            name: "SecurityMode",
            fieldType: "MessageSecurityMode",
        },
        {
            name: "SecurityPolicyUri",
            fieldType: "String",
        },
        {
            name: "TransportProfileUri",
            fieldType: "String",
        },
    ]
});
class EndpointType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaEndpointType; }
    static possibleFields = [
        "endpointUrl",
        "securityMode",
        "securityPolicyUri",
        "transportProfileUri"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15528, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15671, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15949, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16150, 0);
    endpointUrl;
    securityMode;
    securityPolicyUri;
    transportProfileUri;
    constructor(options) {
        super(options);
        if (options === null) {
            this.endpointUrl = null;
            this.securityMode = 0;
            this.securityPolicyUri = null;
            this.transportProfileUri = null;
            return;
        }
        const schema = EndpointType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.endpointUrl = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.endpointUrl);
        this.securityMode = this.setSecurityMode((0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.securityMode));
        this.securityPolicyUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.securityPolicyUri);
        this.transportProfileUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.transportProfileUri);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.endpointUrl, stream);
        encodeMessageSecurityMode(this.securityMode, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.securityPolicyUri, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.transportProfileUri, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.endpointUrl = (0, node_opcua_basic_types_1.decodeString)(stream, this.endpointUrl);
        this.securityMode = decodeMessageSecurityMode(stream, this.securityMode);
        this.securityPolicyUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.securityPolicyUri);
        this.transportProfileUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.transportProfileUri);
    }
    // Define Enumeration setters
    setSecurityMode(value) {
        const coercedValue = exports._enumerationMessageSecurityMode.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to MessageSecurityMode :" + value);
        }
        this.securityMode = coercedValue.value;
        return this.securityMode;
    }
    get schema() { return schemaEndpointType; }
}
exports.EndpointType = EndpointType;
EndpointType.schema.dataTypeNodeId = EndpointType.dataTypeNodeId;
EndpointType.schema.encodingDefaultBinary = EndpointType.encodingDefaultBinary;
EndpointType.schema.encodingDefaultXml = EndpointType.encodingDefaultXml;
EndpointType.schema.encodingDefaultJson = EndpointType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(EndpointType.dataTypeNodeId, "EndpointType", EndpointType);
// --------------------------------------------------------------------------------------------
const schemaEndpointUrlListDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "EndpointUrlListDataType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "EndpointUrlList",
            fieldType: "String",
            isArray: true
        },
    ]
});
class EndpointUrlListDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaEndpointUrlListDataType; }
    static possibleFields = [
        "endpointUrlList"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(11943, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(11957, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(11949, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15363, 0);
    endpointUrlList;
    constructor(options) {
        super(options);
        if (options === null) {
            this.endpointUrlList = [];
            return;
        }
        const schema = EndpointUrlListDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.endpointUrlList = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[0], options?.endpointUrlList);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.endpointUrlList, stream, node_opcua_basic_types_1.encodeString);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.endpointUrlList = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeString);
    }
    get schema() { return schemaEndpointUrlListDataType; }
}
exports.EndpointUrlListDataType = EndpointUrlListDataType;
EndpointUrlListDataType.schema.dataTypeNodeId = EndpointUrlListDataType.dataTypeNodeId;
EndpointUrlListDataType.schema.encodingDefaultBinary = EndpointUrlListDataType.encodingDefaultBinary;
EndpointUrlListDataType.schema.encodingDefaultXml = EndpointUrlListDataType.encodingDefaultXml;
EndpointUrlListDataType.schema.encodingDefaultJson = EndpointUrlListDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(EndpointUrlListDataType.dataTypeNodeId, "EndpointUrlListDataType", EndpointUrlListDataType);
// --------------------------------------------------------------------------------------------
const schemaEphemeralKeyType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "EphemeralKeyType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "PublicKey",
            fieldType: "ByteString",
        },
        {
            name: "Signature",
            fieldType: "ByteString",
        },
    ]
});
class EphemeralKeyType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaEphemeralKeyType; }
    static possibleFields = [
        "publicKey",
        "signature"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(17548, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(17549, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(17553, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(17557, 0);
    publicKey;
    signature;
    constructor(options) {
        super(options);
        if (options === null) {
            this.publicKey = Buffer.alloc(0);
            this.signature = Buffer.alloc(0);
            return;
        }
        const schema = EphemeralKeyType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.publicKey = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.publicKey);
        this.signature = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.signature);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeByteString)(this.publicKey, stream);
        (0, node_opcua_basic_types_1.encodeByteString)(this.signature, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.publicKey = (0, node_opcua_basic_types_1.decodeByteString)(stream, this.publicKey);
        this.signature = (0, node_opcua_basic_types_1.decodeByteString)(stream, this.signature);
    }
    get schema() { return schemaEphemeralKeyType; }
}
exports.EphemeralKeyType = EphemeralKeyType;
EphemeralKeyType.schema.dataTypeNodeId = EphemeralKeyType.dataTypeNodeId;
EphemeralKeyType.schema.encodingDefaultBinary = EphemeralKeyType.encodingDefaultBinary;
EphemeralKeyType.schema.encodingDefaultXml = EphemeralKeyType.encodingDefaultXml;
EphemeralKeyType.schema.encodingDefaultJson = EphemeralKeyType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(EphemeralKeyType.dataTypeNodeId, "EphemeralKeyType", EphemeralKeyType);
// --------------------------------------------------------------------------------------------
const schemaEventFieldList = (0, node_opcua_factory_1.buildStructuredType)({
    name: "EventFieldList",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ClientHandle",
            fieldType: "UInt32",
        },
        {
            name: "EventFields",
            fieldType: "Variant",
            isArray: true
        },
    ]
});
class EventFieldList extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaEventFieldList; }
    static possibleFields = [
        "clientHandle",
        "eventFields"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(917, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(919, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(918, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15348, 0);
    clientHandle;
    eventFields;
    constructor(options) {
        super(options);
        if (options === null) {
            this.clientHandle = 0;
            this.eventFields = [];
            return;
        }
        const schema = EventFieldList.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.clientHandle = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.clientHandle);
        this.eventFields = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.eventFields);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.clientHandle, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.eventFields, stream, node_opcua_variant_1.encodeVariant);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.clientHandle = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.clientHandle);
        this.eventFields = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_variant_1.decodeVariant);
    }
    get schema() { return schemaEventFieldList; }
}
exports.EventFieldList = EventFieldList;
EventFieldList.schema.dataTypeNodeId = EventFieldList.dataTypeNodeId;
EventFieldList.schema.encodingDefaultBinary = EventFieldList.encodingDefaultBinary;
EventFieldList.schema.encodingDefaultXml = EventFieldList.encodingDefaultXml;
EventFieldList.schema.encodingDefaultJson = EventFieldList.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(EventFieldList.dataTypeNodeId, "EventFieldList", EventFieldList);
// --------------------------------------------------------------------------------------------
const schemaEventFilter = (0, node_opcua_factory_1.buildStructuredType)({
    name: "EventFilter",
    baseType: "MonitoringFilter",
    fields: [
        {
            name: "SelectClauses",
            fieldType: "SimpleAttributeOperand",
            isArray: true
        },
        {
            name: "WhereClause",
            fieldType: "ContentFilter",
        },
    ]
});
class EventFilter extends MonitoringFilter {
    static get schema() { return schemaEventFilter; }
    static possibleFields = [
        "selectClauses",
        "whereClause"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(725, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(727, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(726, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15295, 0);
    selectClauses;
    whereClause;
    constructor(options) {
        super(options);
        if (options === null) {
            this.selectClauses = null; /* null array */
            this.whereClause = new ContentFilter(null);
            return;
        }
        const schema = EventFilter.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.selectClauses = []; // should default
        if (options.selectClauses) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.selectClauses));
            this.selectClauses = options.selectClauses.map((e) => new SimpleAttributeOperand(e));
        }
        this.whereClause = new ContentFilter(options.whereClause);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.selectClauses, stream, (obj, stream1) => { obj.encode(stream1); });
        this.whereClause.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.selectClauses = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new SimpleAttributeOperand(null);
            obj.decode(stream1);
            return obj;
        });
        this.whereClause.decode(stream);
    }
    get schema() { return schemaEventFilter; }
}
exports.EventFilter = EventFilter;
EventFilter.schema.dataTypeNodeId = EventFilter.dataTypeNodeId;
EventFilter.schema.encodingDefaultBinary = EventFilter.encodingDefaultBinary;
EventFilter.schema.encodingDefaultXml = EventFilter.encodingDefaultXml;
EventFilter.schema.encodingDefaultJson = EventFilter.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(EventFilter.dataTypeNodeId, "EventFilter", EventFilter);
// --------------------------------------------------------------------------------------------
const schemaEventFilterResult = (0, node_opcua_factory_1.buildStructuredType)({
    name: "EventFilterResult",
    baseType: "MonitoringFilterResult",
    fields: [
        {
            name: "SelectClauseResults",
            fieldType: "StatusCode",
            isArray: true
        },
        {
            name: "SelectClauseDiagnosticInfos",
            fieldType: "DiagnosticInfo",
            isArray: true
        },
        {
            name: "WhereClauseResult",
            fieldType: "ContentFilterResult",
        },
    ]
});
class EventFilterResult extends MonitoringFilterResult {
    static get schema() { return schemaEventFilterResult; }
    static possibleFields = [
        "selectClauseResults",
        "selectClauseDiagnosticInfos",
        "whereClauseResult"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(734, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(736, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(735, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15314, 0);
    selectClauseResults;
    selectClauseDiagnosticInfos;
    whereClauseResult;
    constructor(options) {
        super(options);
        if (options === null) {
            this.selectClauseResults = [];
            this.selectClauseDiagnosticInfos = [];
            this.whereClauseResult = new ContentFilterResult(null);
            return;
        }
        const schema = EventFilterResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.selectClauseResults = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[0], options?.selectClauseResults);
        this.selectClauseDiagnosticInfos = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.selectClauseDiagnosticInfos);
        this.whereClauseResult = new ContentFilterResult(options.whereClauseResult);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.selectClauseResults, stream, node_opcua_status_code_1.encodeStatusCode);
        (0, node_opcua_basic_types_1.encodeArray)(this.selectClauseDiagnosticInfos, stream, node_opcua_data_model_1.encodeDiagnosticInfo);
        this.whereClauseResult.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.selectClauseResults = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_status_code_1.decodeStatusCode);
        this.selectClauseDiagnosticInfos = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_data_model_1.decodeDiagnosticInfo);
        this.whereClauseResult.decode(stream);
    }
    get schema() { return schemaEventFilterResult; }
}
exports.EventFilterResult = EventFilterResult;
EventFilterResult.schema.dataTypeNodeId = EventFilterResult.dataTypeNodeId;
EventFilterResult.schema.encodingDefaultBinary = EventFilterResult.encodingDefaultBinary;
EventFilterResult.schema.encodingDefaultXml = EventFilterResult.encodingDefaultXml;
EventFilterResult.schema.encodingDefaultJson = EventFilterResult.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(EventFilterResult.dataTypeNodeId, "EventFilterResult", EventFilterResult);
// --------------------------------------------------------------------------------------------
const schemaEventNotificationList = (0, node_opcua_factory_1.buildStructuredType)({
    name: "EventNotificationList",
    baseType: "NotificationData",
    fields: [
        {
            name: "Events",
            fieldType: "EventFieldList",
            isArray: true
        },
    ]
});
class EventNotificationList extends NotificationData {
    static get schema() { return schemaEventNotificationList; }
    static possibleFields = [
        "events"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(914, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(916, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(915, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15347, 0);
    events;
    constructor(options) {
        super(options);
        if (options === null) {
            this.events = null; /* null array */
            return;
        }
        const schema = EventNotificationList.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.events = []; // should default
        if (options.events) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.events));
            this.events = options.events.map((e) => new EventFieldList(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.events, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.events = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new EventFieldList(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaEventNotificationList; }
}
exports.EventNotificationList = EventNotificationList;
EventNotificationList.schema.dataTypeNodeId = EventNotificationList.dataTypeNodeId;
EventNotificationList.schema.encodingDefaultBinary = EventNotificationList.encodingDefaultBinary;
EventNotificationList.schema.encodingDefaultXml = EventNotificationList.encodingDefaultXml;
EventNotificationList.schema.encodingDefaultJson = EventNotificationList.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(EventNotificationList.dataTypeNodeId, "EventNotificationList", EventNotificationList);
// --------------------------------------------------------------------------------------------
var OverrideValueHandling;
(function (OverrideValueHandling) {
    OverrideValueHandling[OverrideValueHandling["Disabled"] = 0] = "Disabled";
    OverrideValueHandling[OverrideValueHandling["LastUsableValue"] = 1] = "LastUsableValue";
    OverrideValueHandling[OverrideValueHandling["OverrideValue"] = 2] = "OverrideValue";
    OverrideValueHandling[OverrideValueHandling["Invalid"] = 4294967295] = "Invalid";
})(OverrideValueHandling || (exports.OverrideValueHandling = OverrideValueHandling = {}));
const schemaOverrideValueHandling = {
    enumValues: OverrideValueHandling,
    flaggable: false,
    minValue: 0,
    maxValue: 2,
    name: "OverrideValueHandling"
};
function decodeOverrideValueHandling(stream, _value) {
    let value = stream.readUInt32();
    value = (value < schemaOverrideValueHandling.minValue || value > schemaOverrideValueHandling.maxValue) ? OverrideValueHandling.Invalid : value;
    return value;
}
function encodeOverrideValueHandling(value, stream) {
    stream.writeUInt32(value);
}
exports._enumerationOverrideValueHandling = (0, node_opcua_factory_1.registerEnumeration)(schemaOverrideValueHandling);
(0, node_opcua_assert_1.assert)(exports._enumerationOverrideValueHandling.isFlaggable === false);
// --------------------------------------------------------------------------------------------
const schemaFieldTargetDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "FieldTargetDataType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "DataSetFieldId",
            fieldType: "Guid",
        },
        {
            name: "ReceiverIndexRange",
            fieldType: "String",
        },
        {
            name: "TargetNodeId",
            fieldType: "NodeId",
        },
        {
            name: "AttributeId",
            fieldType: "UInt32",
        },
        {
            name: "WriteIndexRange",
            fieldType: "String",
        },
        {
            name: "OverrideValueHandling",
            fieldType: "OverrideValueHandling",
        },
        {
            name: "OverrideValue",
            fieldType: "Variant",
        },
    ]
});
class FieldTargetDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaFieldTargetDataType; }
    static possibleFields = [
        "dataSetFieldId",
        "receiverIndexRange",
        "targetNodeId",
        "attributeId",
        "writeIndexRange",
        "overrideValueHandling",
        "overrideValue"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14744, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14848, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14804, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15061, 0);
    dataSetFieldId;
    receiverIndexRange;
    targetNodeId;
    attributeId;
    writeIndexRange;
    overrideValueHandling;
    overrideValue;
    constructor(options) {
        super(options);
        if (options === null) {
            this.dataSetFieldId = "";
            this.receiverIndexRange = null;
            this.targetNodeId = new node_opcua_nodeid_1.NodeId(null);
            this.attributeId = 0;
            this.writeIndexRange = null;
            this.overrideValueHandling = 0;
            this.overrideValue = new node_opcua_variant_1.Variant(null);
            return;
        }
        const schema = FieldTargetDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.dataSetFieldId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.dataSetFieldId);
        this.receiverIndexRange = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.receiverIndexRange);
        this.targetNodeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.targetNodeId);
        this.attributeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.attributeId);
        this.writeIndexRange = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.writeIndexRange);
        this.overrideValueHandling = this.setOverrideValueHandling((0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.overrideValueHandling));
        this.overrideValue = (0, node_opcua_factory_1.initialize_field)(schema.fields[6], options?.overrideValue);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeGuid)(this.dataSetFieldId, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.receiverIndexRange, stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.targetNodeId, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.attributeId, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.writeIndexRange, stream);
        encodeOverrideValueHandling(this.overrideValueHandling, stream);
        (0, node_opcua_variant_1.encodeVariant)(this.overrideValue, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.dataSetFieldId = (0, node_opcua_basic_types_1.decodeGuid)(stream, this.dataSetFieldId);
        this.receiverIndexRange = (0, node_opcua_basic_types_1.decodeString)(stream, this.receiverIndexRange);
        this.targetNodeId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.targetNodeId);
        this.attributeId = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.attributeId);
        this.writeIndexRange = (0, node_opcua_basic_types_1.decodeString)(stream, this.writeIndexRange);
        this.overrideValueHandling = decodeOverrideValueHandling(stream, this.overrideValueHandling);
        this.overrideValue = (0, node_opcua_variant_1.decodeVariant)(stream, this.overrideValue);
    }
    // Define Enumeration setters
    setOverrideValueHandling(value) {
        const coercedValue = exports._enumerationOverrideValueHandling.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to OverrideValueHandling :" + value);
        }
        this.overrideValueHandling = coercedValue.value;
        return this.overrideValueHandling;
    }
    get schema() { return schemaFieldTargetDataType; }
}
exports.FieldTargetDataType = FieldTargetDataType;
FieldTargetDataType.schema.dataTypeNodeId = FieldTargetDataType.dataTypeNodeId;
FieldTargetDataType.schema.encodingDefaultBinary = FieldTargetDataType.encodingDefaultBinary;
FieldTargetDataType.schema.encodingDefaultXml = FieldTargetDataType.encodingDefaultXml;
FieldTargetDataType.schema.encodingDefaultJson = FieldTargetDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(FieldTargetDataType.dataTypeNodeId, "FieldTargetDataType", FieldTargetDataType);
// --------------------------------------------------------------------------------------------
const schemaFindServersOnNetworkRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "FindServersOnNetworkRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",
            fieldType: "RequestHeader",
        },
        {
            name: "StartingRecordId",
            fieldType: "UInt32",
        },
        {
            name: "MaxRecordsToReturn",
            fieldType: "UInt32",
        },
        {
            name: "ServerCapabilityFilter",
            fieldType: "String",
            isArray: true
        },
    ]
});
class FindServersOnNetworkRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaFindServersOnNetworkRequest; }
    static possibleFields = [
        "requestHeader",
        "startingRecordId",
        "maxRecordsToReturn",
        "serverCapabilityFilter"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12190, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12208, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12196, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15096, 0);
    requestHeader;
    startingRecordId;
    maxRecordsToReturn;
    serverCapabilityFilter;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestHeader = new RequestHeader(null);
            this.startingRecordId = 0;
            this.maxRecordsToReturn = 0;
            this.serverCapabilityFilter = [];
            return;
        }
        const schema = FindServersOnNetworkRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestHeader = new RequestHeader(options.requestHeader);
        this.startingRecordId = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.startingRecordId);
        this.maxRecordsToReturn = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.maxRecordsToReturn);
        this.serverCapabilityFilter = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[3], options?.serverCapabilityFilter);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.startingRecordId, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.maxRecordsToReturn, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.serverCapabilityFilter, stream, node_opcua_basic_types_1.encodeString);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.startingRecordId = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.startingRecordId);
        this.maxRecordsToReturn = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.maxRecordsToReturn);
        this.serverCapabilityFilter = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeString);
    }
    get schema() { return schemaFindServersOnNetworkRequest; }
}
exports.FindServersOnNetworkRequest = FindServersOnNetworkRequest;
FindServersOnNetworkRequest.schema.dataTypeNodeId = FindServersOnNetworkRequest.dataTypeNodeId;
FindServersOnNetworkRequest.schema.encodingDefaultBinary = FindServersOnNetworkRequest.encodingDefaultBinary;
FindServersOnNetworkRequest.schema.encodingDefaultXml = FindServersOnNetworkRequest.encodingDefaultXml;
FindServersOnNetworkRequest.schema.encodingDefaultJson = FindServersOnNetworkRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(FindServersOnNetworkRequest.dataTypeNodeId, "FindServersOnNetworkRequest", FindServersOnNetworkRequest);
// --------------------------------------------------------------------------------------------
const schemaServerOnNetwork = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ServerOnNetwork",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RecordId",
            fieldType: "UInt32",
        },
        {
            name: "ServerName",
            fieldType: "String",
        },
        {
            name: "DiscoveryUrl",
            fieldType: "String",
        },
        {
            name: "ServerCapabilities",
            fieldType: "String",
            isArray: true
        },
    ]
});
class ServerOnNetwork extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaServerOnNetwork; }
    static possibleFields = [
        "recordId",
        "serverName",
        "discoveryUrl",
        "serverCapabilities"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12189, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12207, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12195, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15095, 0);
    recordId;
    serverName;
    discoveryUrl;
    serverCapabilities;
    constructor(options) {
        super(options);
        if (options === null) {
            this.recordId = 0;
            this.serverName = null;
            this.discoveryUrl = null;
            this.serverCapabilities = [];
            return;
        }
        const schema = ServerOnNetwork.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.recordId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.recordId);
        this.serverName = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.serverName);
        this.discoveryUrl = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.discoveryUrl);
        this.serverCapabilities = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[3], options?.serverCapabilities);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.recordId, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.serverName, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.discoveryUrl, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.serverCapabilities, stream, node_opcua_basic_types_1.encodeString);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.recordId = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.recordId);
        this.serverName = (0, node_opcua_basic_types_1.decodeString)(stream, this.serverName);
        this.discoveryUrl = (0, node_opcua_basic_types_1.decodeString)(stream, this.discoveryUrl);
        this.serverCapabilities = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeString);
    }
    get schema() { return schemaServerOnNetwork; }
}
exports.ServerOnNetwork = ServerOnNetwork;
ServerOnNetwork.schema.dataTypeNodeId = ServerOnNetwork.dataTypeNodeId;
ServerOnNetwork.schema.encodingDefaultBinary = ServerOnNetwork.encodingDefaultBinary;
ServerOnNetwork.schema.encodingDefaultXml = ServerOnNetwork.encodingDefaultXml;
ServerOnNetwork.schema.encodingDefaultJson = ServerOnNetwork.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ServerOnNetwork.dataTypeNodeId, "ServerOnNetwork", ServerOnNetwork);
// --------------------------------------------------------------------------------------------
const schemaFindServersOnNetworkResponse = (0, node_opcua_factory_1.buildStructuredType)({
    name: "FindServersOnNetworkResponse",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",
            fieldType: "ResponseHeader",
        },
        {
            name: "LastCounterResetTime",
            fieldType: "DateTime",
        },
        {
            name: "Servers",
            fieldType: "ServerOnNetwork",
            isArray: true
        },
    ]
});
class FindServersOnNetworkResponse extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaFindServersOnNetworkResponse; }
    static possibleFields = [
        "responseHeader",
        "lastCounterResetTime",
        "servers"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12191, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12209, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12197, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15097, 0);
    responseHeader;
    lastCounterResetTime;
    servers;
    constructor(options) {
        super(options);
        if (options === null) {
            this.responseHeader = new ResponseHeader(null);
            this.lastCounterResetTime = new Date();
            this.servers = null; /* null array */
            return;
        }
        const schema = FindServersOnNetworkResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.responseHeader = new ResponseHeader(options.responseHeader);
        this.lastCounterResetTime = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.lastCounterResetTime);
        this.servers = []; // should default
        if (options.servers) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.servers));
            this.servers = options.servers.map((e) => new ServerOnNetwork(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.lastCounterResetTime, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.servers, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.lastCounterResetTime = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.lastCounterResetTime);
        this.servers = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new ServerOnNetwork(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaFindServersOnNetworkResponse; }
}
exports.FindServersOnNetworkResponse = FindServersOnNetworkResponse;
FindServersOnNetworkResponse.schema.dataTypeNodeId = FindServersOnNetworkResponse.dataTypeNodeId;
FindServersOnNetworkResponse.schema.encodingDefaultBinary = FindServersOnNetworkResponse.encodingDefaultBinary;
FindServersOnNetworkResponse.schema.encodingDefaultXml = FindServersOnNetworkResponse.encodingDefaultXml;
FindServersOnNetworkResponse.schema.encodingDefaultJson = FindServersOnNetworkResponse.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(FindServersOnNetworkResponse.dataTypeNodeId, "FindServersOnNetworkResponse", FindServersOnNetworkResponse);
// --------------------------------------------------------------------------------------------
const schemaFindServersRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "FindServersRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",
            fieldType: "RequestHeader",
        },
        {
            name: "EndpointUrl",
            fieldType: "String",
        },
        {
            name: "LocaleIds",
            fieldType: "String",
            isArray: true
        },
        {
            name: "ServerUris",
            fieldType: "String",
            isArray: true
        },
    ]
});
class FindServersRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaFindServersRequest; }
    static possibleFields = [
        "requestHeader",
        "endpointUrl",
        "localeIds",
        "serverUris"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(420, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(422, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(421, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15093, 0);
    requestHeader;
    endpointUrl;
    localeIds;
    serverUris;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestHeader = new RequestHeader(null);
            this.endpointUrl = null;
            this.localeIds = [];
            this.serverUris = [];
            return;
        }
        const schema = FindServersRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestHeader = new RequestHeader(options.requestHeader);
        this.endpointUrl = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.endpointUrl);
        this.localeIds = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.localeIds);
        this.serverUris = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[3], options?.serverUris);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.endpointUrl, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.localeIds, stream, node_opcua_basic_types_1.encodeString);
        (0, node_opcua_basic_types_1.encodeArray)(this.serverUris, stream, node_opcua_basic_types_1.encodeString);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.endpointUrl = (0, node_opcua_basic_types_1.decodeString)(stream, this.endpointUrl);
        this.localeIds = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeString);
        this.serverUris = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeString);
    }
    get schema() { return schemaFindServersRequest; }
}
exports.FindServersRequest = FindServersRequest;
FindServersRequest.schema.dataTypeNodeId = FindServersRequest.dataTypeNodeId;
FindServersRequest.schema.encodingDefaultBinary = FindServersRequest.encodingDefaultBinary;
FindServersRequest.schema.encodingDefaultXml = FindServersRequest.encodingDefaultXml;
FindServersRequest.schema.encodingDefaultJson = FindServersRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(FindServersRequest.dataTypeNodeId, "FindServersRequest", FindServersRequest);
// --------------------------------------------------------------------------------------------
const schemaFindServersResponse = (0, node_opcua_factory_1.buildStructuredType)({
    name: "FindServersResponse",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",
            fieldType: "ResponseHeader",
        },
        {
            name: "Servers",
            fieldType: "ApplicationDescription",
            isArray: true
        },
    ]
});
class FindServersResponse extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaFindServersResponse; }
    static possibleFields = [
        "responseHeader",
        "servers"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(423, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(425, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(424, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15094, 0);
    responseHeader;
    servers;
    constructor(options) {
        super(options);
        if (options === null) {
            this.responseHeader = new ResponseHeader(null);
            this.servers = null; /* null array */
            return;
        }
        const schema = FindServersResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.responseHeader = new ResponseHeader(options.responseHeader);
        this.servers = []; // should default
        if (options.servers) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.servers));
            this.servers = options.servers.map((e) => new ApplicationDescription(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.servers, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.servers = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new ApplicationDescription(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaFindServersResponse; }
}
exports.FindServersResponse = FindServersResponse;
FindServersResponse.schema.dataTypeNodeId = FindServersResponse.dataTypeNodeId;
FindServersResponse.schema.encodingDefaultBinary = FindServersResponse.encodingDefaultBinary;
FindServersResponse.schema.encodingDefaultXml = FindServersResponse.encodingDefaultXml;
FindServersResponse.schema.encodingDefaultJson = FindServersResponse.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(FindServersResponse.dataTypeNodeId, "FindServersResponse", FindServersResponse);
// --------------------------------------------------------------------------------------------
const schemaFrame = (0, node_opcua_factory_1.buildStructuredType)({
    name: "Frame",
    baseType: "ExtensionObject",
    fields: []
});
class Frame extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaFrame; }
    static possibleFields = [];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(18813, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(18822, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(18858, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(19071, 0);
    constructor(options) {
        super(options);
        if (options === null) {
            return;
        }
        const schema = Frame.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    get schema() { return schemaFrame; }
}
exports.Frame = Frame;
Frame.schema.dataTypeNodeId = Frame.dataTypeNodeId;
Frame.schema.encodingDefaultBinary = Frame.encodingDefaultBinary;
Frame.schema.encodingDefaultXml = Frame.encodingDefaultXml;
Frame.schema.encodingDefaultJson = Frame.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(Frame.dataTypeNodeId, "Frame", Frame);
// --------------------------------------------------------------------------------------------
const schemaGenericAttributeValue = (0, node_opcua_factory_1.buildStructuredType)({
    name: "GenericAttributeValue",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "AttributeId",
            fieldType: "UInt32",
        },
        {
            name: "Value",
            fieldType: "Variant",
        },
    ]
});
class GenericAttributeValue extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaGenericAttributeValue; }
    static possibleFields = [
        "attributeId",
        "value"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(17606, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(17610, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(17608, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15163, 0);
    attributeId;
    value;
    constructor(options) {
        super(options);
        if (options === null) {
            this.attributeId = 0;
            this.value = new node_opcua_variant_1.Variant(null);
            return;
        }
        const schema = GenericAttributeValue.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.attributeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.attributeId);
        this.value = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.value);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.attributeId, stream);
        (0, node_opcua_variant_1.encodeVariant)(this.value, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.attributeId = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.attributeId);
        this.value = (0, node_opcua_variant_1.decodeVariant)(stream, this.value);
    }
    get schema() { return schemaGenericAttributeValue; }
}
exports.GenericAttributeValue = GenericAttributeValue;
GenericAttributeValue.schema.dataTypeNodeId = GenericAttributeValue.dataTypeNodeId;
GenericAttributeValue.schema.encodingDefaultBinary = GenericAttributeValue.encodingDefaultBinary;
GenericAttributeValue.schema.encodingDefaultXml = GenericAttributeValue.encodingDefaultXml;
GenericAttributeValue.schema.encodingDefaultJson = GenericAttributeValue.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(GenericAttributeValue.dataTypeNodeId, "GenericAttributeValue", GenericAttributeValue);
// --------------------------------------------------------------------------------------------
const schemaGenericAttributes = (0, node_opcua_factory_1.buildStructuredType)({
    name: "GenericAttributes",
    baseType: "NodeAttributes",
    fields: [
        {
            name: "AttributeValues",
            fieldType: "GenericAttributeValue",
            isArray: true
        },
    ]
});
class GenericAttributes extends NodeAttributes {
    static get schema() { return schemaGenericAttributes; }
    static possibleFields = [
        "specifiedAttributes",
        "displayName",
        "description",
        "writeMask",
        "userWriteMask",
        "attributeValues"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(17607, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(17611, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(17609, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15164, 0);
    attributeValues;
    constructor(options) {
        super(options);
        if (options === null) {
            this.attributeValues = null; /* null array */
            return;
        }
        const schema = GenericAttributes.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.attributeValues = []; // should default
        if (options.attributeValues) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.attributeValues));
            this.attributeValues = options.attributeValues.map((e) => new GenericAttributeValue(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.attributeValues, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.attributeValues = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new GenericAttributeValue(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaGenericAttributes; }
}
exports.GenericAttributes = GenericAttributes;
GenericAttributes.schema.dataTypeNodeId = GenericAttributes.dataTypeNodeId;
GenericAttributes.schema.encodingDefaultBinary = GenericAttributes.encodingDefaultBinary;
GenericAttributes.schema.encodingDefaultXml = GenericAttributes.encodingDefaultXml;
GenericAttributes.schema.encodingDefaultJson = GenericAttributes.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(GenericAttributes.dataTypeNodeId, "GenericAttributes", GenericAttributes);
// --------------------------------------------------------------------------------------------
const schemaGetEndpointsRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "GetEndpointsRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",
            fieldType: "RequestHeader",
        },
        {
            name: "EndpointUrl",
            fieldType: "String",
        },
        {
            name: "LocaleIds",
            fieldType: "String",
            isArray: true
        },
        {
            name: "ProfileUris",
            fieldType: "String",
            isArray: true
        },
    ]
});
class GetEndpointsRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaGetEndpointsRequest; }
    static possibleFields = [
        "requestHeader",
        "endpointUrl",
        "localeIds",
        "profileUris"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(426, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(428, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(427, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15100, 0);
    requestHeader;
    endpointUrl;
    localeIds;
    profileUris;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestHeader = new RequestHeader(null);
            this.endpointUrl = null;
            this.localeIds = [];
            this.profileUris = [];
            return;
        }
        const schema = GetEndpointsRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestHeader = new RequestHeader(options.requestHeader);
        this.endpointUrl = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.endpointUrl);
        this.localeIds = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.localeIds);
        this.profileUris = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[3], options?.profileUris);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.endpointUrl, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.localeIds, stream, node_opcua_basic_types_1.encodeString);
        (0, node_opcua_basic_types_1.encodeArray)(this.profileUris, stream, node_opcua_basic_types_1.encodeString);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.endpointUrl = (0, node_opcua_basic_types_1.decodeString)(stream, this.endpointUrl);
        this.localeIds = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeString);
        this.profileUris = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeString);
    }
    get schema() { return schemaGetEndpointsRequest; }
}
exports.GetEndpointsRequest = GetEndpointsRequest;
GetEndpointsRequest.schema.dataTypeNodeId = GetEndpointsRequest.dataTypeNodeId;
GetEndpointsRequest.schema.encodingDefaultBinary = GetEndpointsRequest.encodingDefaultBinary;
GetEndpointsRequest.schema.encodingDefaultXml = GetEndpointsRequest.encodingDefaultXml;
GetEndpointsRequest.schema.encodingDefaultJson = GetEndpointsRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(GetEndpointsRequest.dataTypeNodeId, "GetEndpointsRequest", GetEndpointsRequest);
// --------------------------------------------------------------------------------------------
const schemaGetEndpointsResponse = (0, node_opcua_factory_1.buildStructuredType)({
    name: "GetEndpointsResponse",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",
            fieldType: "ResponseHeader",
        },
        {
            name: "Endpoints",
            fieldType: "EndpointDescription",
            isArray: true
        },
    ]
});
class GetEndpointsResponse extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaGetEndpointsResponse; }
    static possibleFields = [
        "responseHeader",
        "endpoints"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(429, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(431, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(430, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15101, 0);
    responseHeader;
    endpoints;
    constructor(options) {
        super(options);
        if (options === null) {
            this.responseHeader = new ResponseHeader(null);
            this.endpoints = null; /* null array */
            return;
        }
        const schema = GetEndpointsResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.responseHeader = new ResponseHeader(options.responseHeader);
        this.endpoints = []; // should default
        if (options.endpoints) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.endpoints));
            this.endpoints = options.endpoints.map((e) => new EndpointDescription(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.endpoints, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.endpoints = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new EndpointDescription(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaGetEndpointsResponse; }
}
exports.GetEndpointsResponse = GetEndpointsResponse;
GetEndpointsResponse.schema.dataTypeNodeId = GetEndpointsResponse.dataTypeNodeId;
GetEndpointsResponse.schema.encodingDefaultBinary = GetEndpointsResponse.encodingDefaultBinary;
GetEndpointsResponse.schema.encodingDefaultXml = GetEndpointsResponse.encodingDefaultXml;
GetEndpointsResponse.schema.encodingDefaultJson = GetEndpointsResponse.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(GetEndpointsResponse.dataTypeNodeId, "GetEndpointsResponse", GetEndpointsResponse);
// --------------------------------------------------------------------------------------------
const schemaHistoryData = (0, node_opcua_factory_1.buildStructuredType)({
    name: "HistoryData",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "DataValues",
            fieldType: "DataValue",
            isArray: true
        },
    ]
});
class HistoryData extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaHistoryData; }
    static possibleFields = [
        "dataValues"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(656, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(658, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(657, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15270, 0);
    dataValues;
    constructor(options) {
        super(options);
        if (options === null) {
            this.dataValues = [];
            return;
        }
        const schema = HistoryData.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.dataValues = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[0], options?.dataValues);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.dataValues, stream, node_opcua_data_value_1.encodeDataValue);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.dataValues = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_data_value_1.decodeDataValue);
    }
    get schema() { return schemaHistoryData; }
}
exports.HistoryData = HistoryData;
HistoryData.schema.dataTypeNodeId = HistoryData.dataTypeNodeId;
HistoryData.schema.encodingDefaultBinary = HistoryData.encodingDefaultBinary;
HistoryData.schema.encodingDefaultXml = HistoryData.encodingDefaultXml;
HistoryData.schema.encodingDefaultJson = HistoryData.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(HistoryData.dataTypeNodeId, "HistoryData", HistoryData);
// --------------------------------------------------------------------------------------------
const schemaHistoryEventFieldList = (0, node_opcua_factory_1.buildStructuredType)({
    name: "HistoryEventFieldList",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "EventFields",
            fieldType: "Variant",
            isArray: true
        },
    ]
});
class HistoryEventFieldList extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaHistoryEventFieldList; }
    static possibleFields = [
        "eventFields"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(920, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(922, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(921, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15349, 0);
    eventFields;
    constructor(options) {
        super(options);
        if (options === null) {
            this.eventFields = [];
            return;
        }
        const schema = HistoryEventFieldList.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.eventFields = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[0], options?.eventFields);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.eventFields, stream, node_opcua_variant_1.encodeVariant);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.eventFields = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_variant_1.decodeVariant);
    }
    get schema() { return schemaHistoryEventFieldList; }
}
exports.HistoryEventFieldList = HistoryEventFieldList;
HistoryEventFieldList.schema.dataTypeNodeId = HistoryEventFieldList.dataTypeNodeId;
HistoryEventFieldList.schema.encodingDefaultBinary = HistoryEventFieldList.encodingDefaultBinary;
HistoryEventFieldList.schema.encodingDefaultXml = HistoryEventFieldList.encodingDefaultXml;
HistoryEventFieldList.schema.encodingDefaultJson = HistoryEventFieldList.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(HistoryEventFieldList.dataTypeNodeId, "HistoryEventFieldList", HistoryEventFieldList);
// --------------------------------------------------------------------------------------------
const schemaHistoryEvent = (0, node_opcua_factory_1.buildStructuredType)({
    name: "HistoryEvent",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Events",
            fieldType: "HistoryEventFieldList",
            isArray: true
        },
    ]
});
class HistoryEvent extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaHistoryEvent; }
    static possibleFields = [
        "events"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(659, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(661, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(660, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15273, 0);
    events;
    constructor(options) {
        super(options);
        if (options === null) {
            this.events = null; /* null array */
            return;
        }
        const schema = HistoryEvent.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.events = []; // should default
        if (options.events) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.events));
            this.events = options.events.map((e) => new HistoryEventFieldList(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.events, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.events = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new HistoryEventFieldList(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaHistoryEvent; }
}
exports.HistoryEvent = HistoryEvent;
HistoryEvent.schema.dataTypeNodeId = HistoryEvent.dataTypeNodeId;
HistoryEvent.schema.encodingDefaultBinary = HistoryEvent.encodingDefaultBinary;
HistoryEvent.schema.encodingDefaultXml = HistoryEvent.encodingDefaultXml;
HistoryEvent.schema.encodingDefaultJson = HistoryEvent.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(HistoryEvent.dataTypeNodeId, "HistoryEvent", HistoryEvent);
// --------------------------------------------------------------------------------------------
var HistoryUpdateType;
(function (HistoryUpdateType) {
    HistoryUpdateType[HistoryUpdateType["Insert"] = 1] = "Insert";
    HistoryUpdateType[HistoryUpdateType["Replace"] = 2] = "Replace";
    HistoryUpdateType[HistoryUpdateType["Update"] = 3] = "Update";
    HistoryUpdateType[HistoryUpdateType["Delete"] = 4] = "Delete";
    HistoryUpdateType[HistoryUpdateType["Invalid"] = 4294967295] = "Invalid";
})(HistoryUpdateType || (exports.HistoryUpdateType = HistoryUpdateType = {}));
const schemaHistoryUpdateType = {
    enumValues: HistoryUpdateType,
    flaggable: false,
    minValue: 1,
    maxValue: 4,
    name: "HistoryUpdateType"
};
function decodeHistoryUpdateType(stream, _value) {
    let value = stream.readUInt32();
    value = (value < schemaHistoryUpdateType.minValue || value > schemaHistoryUpdateType.maxValue) ? HistoryUpdateType.Invalid : value;
    return value;
}
function encodeHistoryUpdateType(value, stream) {
    stream.writeUInt32(value);
}
exports._enumerationHistoryUpdateType = (0, node_opcua_factory_1.registerEnumeration)(schemaHistoryUpdateType);
(0, node_opcua_assert_1.assert)(exports._enumerationHistoryUpdateType.isFlaggable === false);
// --------------------------------------------------------------------------------------------
const schemaModificationInfo = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ModificationInfo",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ModificationTime",
            fieldType: "DateTime",
        },
        {
            name: "UpdateType",
            fieldType: "HistoryUpdateType",
        },
        {
            name: "UserName",
            fieldType: "String",
        },
    ]
});
class ModificationInfo extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaModificationInfo; }
    static possibleFields = [
        "modificationTime",
        "updateType",
        "userName"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(11216, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(11226, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(11218, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15271, 0);
    modificationTime;
    updateType;
    userName;
    constructor(options) {
        super(options);
        if (options === null) {
            this.modificationTime = new Date();
            this.updateType = 0;
            this.userName = null;
            return;
        }
        const schema = ModificationInfo.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.modificationTime = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.modificationTime);
        this.updateType = this.setUpdateType((0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.updateType));
        this.userName = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.userName);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.modificationTime, stream);
        encodeHistoryUpdateType(this.updateType, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.userName, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.modificationTime = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.modificationTime);
        this.updateType = decodeHistoryUpdateType(stream, this.updateType);
        this.userName = (0, node_opcua_basic_types_1.decodeString)(stream, this.userName);
    }
    // Define Enumeration setters
    setUpdateType(value) {
        const coercedValue = exports._enumerationHistoryUpdateType.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to HistoryUpdateType :" + value);
        }
        this.updateType = coercedValue.value;
        return this.updateType;
    }
    get schema() { return schemaModificationInfo; }
}
exports.ModificationInfo = ModificationInfo;
ModificationInfo.schema.dataTypeNodeId = ModificationInfo.dataTypeNodeId;
ModificationInfo.schema.encodingDefaultBinary = ModificationInfo.encodingDefaultBinary;
ModificationInfo.schema.encodingDefaultXml = ModificationInfo.encodingDefaultXml;
ModificationInfo.schema.encodingDefaultJson = ModificationInfo.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ModificationInfo.dataTypeNodeId, "ModificationInfo", ModificationInfo);
// --------------------------------------------------------------------------------------------
const schemaHistoryModifiedData = (0, node_opcua_factory_1.buildStructuredType)({
    name: "HistoryModifiedData",
    baseType: "HistoryData",
    fields: [
        {
            name: "ModificationInfos",
            fieldType: "ModificationInfo",
            isArray: true
        },
    ]
});
class HistoryModifiedData extends HistoryData {
    static get schema() { return schemaHistoryModifiedData; }
    static possibleFields = [
        "dataValues",
        "modificationInfos"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(11217, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(11227, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(11219, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15272, 0);
    modificationInfos;
    constructor(options) {
        super(options);
        if (options === null) {
            this.modificationInfos = null; /* null array */
            return;
        }
        const schema = HistoryModifiedData.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.modificationInfos = []; // should default
        if (options.modificationInfos) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.modificationInfos));
            this.modificationInfos = options.modificationInfos.map((e) => new ModificationInfo(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.modificationInfos, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.modificationInfos = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new ModificationInfo(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaHistoryModifiedData; }
}
exports.HistoryModifiedData = HistoryModifiedData;
HistoryModifiedData.schema.dataTypeNodeId = HistoryModifiedData.dataTypeNodeId;
HistoryModifiedData.schema.encodingDefaultBinary = HistoryModifiedData.encodingDefaultBinary;
HistoryModifiedData.schema.encodingDefaultXml = HistoryModifiedData.encodingDefaultXml;
HistoryModifiedData.schema.encodingDefaultJson = HistoryModifiedData.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(HistoryModifiedData.dataTypeNodeId, "HistoryModifiedData", HistoryModifiedData);
// --------------------------------------------------------------------------------------------
const schemaHistoryModifiedEvent = (0, node_opcua_factory_1.buildStructuredType)({
    name: "HistoryModifiedEvent",
    baseType: "HistoryEvent",
    fields: [
        {
            name: "ModificationInfos",
            fieldType: "ModificationInfo",
            isArray: true
        },
    ]
});
class HistoryModifiedEvent extends HistoryEvent {
    static get schema() { return schemaHistoryModifiedEvent; }
    static possibleFields = [
        "events",
        "modificationInfos"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(32824, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(32825, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(32829, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(32833, 0);
    modificationInfos;
    constructor(options) {
        super(options);
        if (options === null) {
            this.modificationInfos = null; /* null array */
            return;
        }
        const schema = HistoryModifiedEvent.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.modificationInfos = []; // should default
        if (options.modificationInfos) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.modificationInfos));
            this.modificationInfos = options.modificationInfos.map((e) => new ModificationInfo(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.modificationInfos, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.modificationInfos = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new ModificationInfo(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaHistoryModifiedEvent; }
}
exports.HistoryModifiedEvent = HistoryModifiedEvent;
HistoryModifiedEvent.schema.dataTypeNodeId = HistoryModifiedEvent.dataTypeNodeId;
HistoryModifiedEvent.schema.encodingDefaultBinary = HistoryModifiedEvent.encodingDefaultBinary;
HistoryModifiedEvent.schema.encodingDefaultXml = HistoryModifiedEvent.encodingDefaultXml;
HistoryModifiedEvent.schema.encodingDefaultJson = HistoryModifiedEvent.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(HistoryModifiedEvent.dataTypeNodeId, "HistoryModifiedEvent", HistoryModifiedEvent);
// --------------------------------------------------------------------------------------------
const schemaHistoryReadDetails = (0, node_opcua_factory_1.buildStructuredType)({
    name: "HistoryReadDetails",
    baseType: "ExtensionObject",
    fields: []
});
class HistoryReadDetails extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaHistoryReadDetails; }
    static possibleFields = [];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(641, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(643, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(642, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15261, 0);
    constructor(options) {
        super(options);
        if (options === null) {
            return;
        }
        const schema = HistoryReadDetails.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    get schema() { return schemaHistoryReadDetails; }
}
exports.HistoryReadDetails = HistoryReadDetails;
HistoryReadDetails.schema.dataTypeNodeId = HistoryReadDetails.dataTypeNodeId;
HistoryReadDetails.schema.encodingDefaultBinary = HistoryReadDetails.encodingDefaultBinary;
HistoryReadDetails.schema.encodingDefaultXml = HistoryReadDetails.encodingDefaultXml;
HistoryReadDetails.schema.encodingDefaultJson = HistoryReadDetails.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(HistoryReadDetails.dataTypeNodeId, "HistoryReadDetails", HistoryReadDetails);
// --------------------------------------------------------------------------------------------
const schemaHistoryReadValueId = (0, node_opcua_factory_1.buildStructuredType)({
    name: "HistoryReadValueId",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "NodeId",
            fieldType: "NodeId",
        },
        {
            name: "IndexRange",
            fieldType: "NumericRange",
        },
        {
            name: "DataEncoding",
            fieldType: "QualifiedName",
        },
        {
            name: "ContinuationPoint",
            fieldType: "ByteString",
        },
    ]
});
class HistoryReadValueId extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaHistoryReadValueId; }
    static possibleFields = [
        "nodeId",
        "indexRange",
        "dataEncoding",
        "continuationPoint"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(635, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(637, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(636, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15259, 0);
    nodeId;
    indexRange;
    dataEncoding;
    continuationPoint;
    constructor(options) {
        super(options);
        if (options === null) {
            this.nodeId = new node_opcua_nodeid_1.NodeId(null);
            this.indexRange = new node_opcua_numeric_range_1.NumericRange(null);
            this.dataEncoding = new node_opcua_data_model_1.QualifiedName(null);
            this.continuationPoint = Buffer.alloc(0);
            return;
        }
        const schema = HistoryReadValueId.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.nodeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.nodeId);
        this.indexRange = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.indexRange);
        this.dataEncoding = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.dataEncoding);
        this.continuationPoint = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.continuationPoint);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.nodeId, stream);
        (0, node_opcua_numeric_range_1.encodeNumericRange)(this.indexRange, stream);
        (0, node_opcua_data_model_1.encodeQualifiedName)(this.dataEncoding, stream);
        (0, node_opcua_basic_types_1.encodeByteString)(this.continuationPoint, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.nodeId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.nodeId);
        this.indexRange = (0, node_opcua_numeric_range_1.decodeNumericRange)(stream, this.indexRange);
        this.dataEncoding = (0, node_opcua_data_model_1.decodeQualifiedName)(stream, this.dataEncoding);
        this.continuationPoint = (0, node_opcua_basic_types_1.decodeByteString)(stream, this.continuationPoint);
    }
    get schema() { return schemaHistoryReadValueId; }
}
exports.HistoryReadValueId = HistoryReadValueId;
HistoryReadValueId.schema.dataTypeNodeId = HistoryReadValueId.dataTypeNodeId;
HistoryReadValueId.schema.encodingDefaultBinary = HistoryReadValueId.encodingDefaultBinary;
HistoryReadValueId.schema.encodingDefaultXml = HistoryReadValueId.encodingDefaultXml;
HistoryReadValueId.schema.encodingDefaultJson = HistoryReadValueId.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(HistoryReadValueId.dataTypeNodeId, "HistoryReadValueId", HistoryReadValueId);
// --------------------------------------------------------------------------------------------
const schemaHistoryReadRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "HistoryReadRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",
            fieldType: "RequestHeader",
        },
        {
            name: "HistoryReadDetails",
            fieldType: "ExtensionObject",
        },
        {
            name: "TimestampsToReturn",
            fieldType: "TimestampsToReturn",
        },
        {
            name: "ReleaseContinuationPoints",
            fieldType: "Boolean",
        },
        {
            name: "NodesToRead",
            fieldType: "HistoryReadValueId",
            isArray: true
        },
    ]
});
class HistoryReadRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaHistoryReadRequest; }
    static possibleFields = [
        "requestHeader",
        "historyReadDetails",
        "timestampsToReturn",
        "releaseContinuationPoints",
        "nodesToRead"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(662, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(664, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(663, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15274, 0);
    requestHeader;
    historyReadDetails;
    timestampsToReturn;
    releaseContinuationPoints;
    nodesToRead;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestHeader = new RequestHeader(null);
            this.historyReadDetails = null;
            this.timestampsToReturn = 0;
            this.releaseContinuationPoints = false;
            this.nodesToRead = null; /* null array */
            return;
        }
        const schema = HistoryReadRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestHeader = new RequestHeader(options.requestHeader);
        this.historyReadDetails = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.historyReadDetails);
        this.timestampsToReturn = this.setTimestampsToReturn((0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.timestampsToReturn));
        this.releaseContinuationPoints = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.releaseContinuationPoints);
        this.nodesToRead = []; // should default
        if (options.nodesToRead) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.nodesToRead));
            this.nodesToRead = options.nodesToRead.map((e) => new HistoryReadValueId(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.historyReadDetails, stream);
        (0, node_opcua_data_value_1.encodeTimestampsToReturn)(this.timestampsToReturn, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.releaseContinuationPoints, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.nodesToRead, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.historyReadDetails = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.historyReadDetails);
        this.timestampsToReturn = (0, node_opcua_data_value_1.decodeTimestampsToReturn)(stream, this.timestampsToReturn);
        this.releaseContinuationPoints = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.releaseContinuationPoints);
        this.nodesToRead = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new HistoryReadValueId(null);
            obj.decode(stream1);
            return obj;
        });
    }
    // Define Enumeration setters
    setTimestampsToReturn(value) {
        const coercedValue = node_opcua_data_value_1._enumerationTimestampsToReturn.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to TimestampsToReturn :" + value);
        }
        this.timestampsToReturn = coercedValue.value;
        return this.timestampsToReturn;
    }
    get schema() { return schemaHistoryReadRequest; }
}
exports.HistoryReadRequest = HistoryReadRequest;
HistoryReadRequest.schema.dataTypeNodeId = HistoryReadRequest.dataTypeNodeId;
HistoryReadRequest.schema.encodingDefaultBinary = HistoryReadRequest.encodingDefaultBinary;
HistoryReadRequest.schema.encodingDefaultXml = HistoryReadRequest.encodingDefaultXml;
HistoryReadRequest.schema.encodingDefaultJson = HistoryReadRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(HistoryReadRequest.dataTypeNodeId, "HistoryReadRequest", HistoryReadRequest);
// --------------------------------------------------------------------------------------------
const schemaHistoryReadResult = (0, node_opcua_factory_1.buildStructuredType)({
    name: "HistoryReadResult",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "StatusCode",
            fieldType: "StatusCode",
        },
        {
            name: "ContinuationPoint",
            fieldType: "ByteString",
        },
        {
            name: "HistoryData",
            fieldType: "ExtensionObject",
        },
    ]
});
class HistoryReadResult extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaHistoryReadResult; }
    static possibleFields = [
        "statusCode",
        "continuationPoint",
        "historyData"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(638, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(640, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(639, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15260, 0);
    statusCode;
    continuationPoint;
    historyData;
    constructor(options) {
        super(options);
        if (options === null) {
            this.statusCode = node_opcua_status_code_1.StatusCodes.Good;
            this.continuationPoint = Buffer.alloc(0);
            this.historyData = null;
            return;
        }
        const schema = HistoryReadResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.statusCode = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.statusCode);
        this.continuationPoint = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.continuationPoint);
        this.historyData = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.historyData);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_status_code_1.encodeStatusCode)(this.statusCode, stream);
        (0, node_opcua_basic_types_1.encodeByteString)(this.continuationPoint, stream);
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.historyData, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.statusCode = (0, node_opcua_status_code_1.decodeStatusCode)(stream, this.statusCode);
        this.continuationPoint = (0, node_opcua_basic_types_1.decodeByteString)(stream, this.continuationPoint);
        this.historyData = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.historyData);
    }
    get schema() { return schemaHistoryReadResult; }
}
exports.HistoryReadResult = HistoryReadResult;
HistoryReadResult.schema.dataTypeNodeId = HistoryReadResult.dataTypeNodeId;
HistoryReadResult.schema.encodingDefaultBinary = HistoryReadResult.encodingDefaultBinary;
HistoryReadResult.schema.encodingDefaultXml = HistoryReadResult.encodingDefaultXml;
HistoryReadResult.schema.encodingDefaultJson = HistoryReadResult.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(HistoryReadResult.dataTypeNodeId, "HistoryReadResult", HistoryReadResult);
// --------------------------------------------------------------------------------------------
const schemaHistoryReadResponse = (0, node_opcua_factory_1.buildStructuredType)({
    name: "HistoryReadResponse",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",
            fieldType: "ResponseHeader",
        },
        {
            name: "Results",
            fieldType: "HistoryReadResult",
            isArray: true
        },
        {
            name: "DiagnosticInfos",
            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
class HistoryReadResponse extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaHistoryReadResponse; }
    static possibleFields = [
        "responseHeader",
        "results",
        "diagnosticInfos"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(665, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(667, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(666, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15275, 0);
    responseHeader;
    results;
    diagnosticInfos;
    constructor(options) {
        super(options);
        if (options === null) {
            this.responseHeader = new ResponseHeader(null);
            this.results = null; /* null array */
            this.diagnosticInfos = [];
            return;
        }
        const schema = HistoryReadResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.responseHeader = new ResponseHeader(options.responseHeader);
        this.results = []; // should default
        if (options.results) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.results));
            this.results = options.results.map((e) => new HistoryReadResult(e));
        }
        this.diagnosticInfos = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.diagnosticInfos);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.results, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.diagnosticInfos, stream, node_opcua_data_model_1.encodeDiagnosticInfo);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new HistoryReadResult(null);
            obj.decode(stream1);
            return obj;
        });
        this.diagnosticInfos = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_data_model_1.decodeDiagnosticInfo);
    }
    get schema() { return schemaHistoryReadResponse; }
}
exports.HistoryReadResponse = HistoryReadResponse;
HistoryReadResponse.schema.dataTypeNodeId = HistoryReadResponse.dataTypeNodeId;
HistoryReadResponse.schema.encodingDefaultBinary = HistoryReadResponse.encodingDefaultBinary;
HistoryReadResponse.schema.encodingDefaultXml = HistoryReadResponse.encodingDefaultXml;
HistoryReadResponse.schema.encodingDefaultJson = HistoryReadResponse.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(HistoryReadResponse.dataTypeNodeId, "HistoryReadResponse", HistoryReadResponse);
// --------------------------------------------------------------------------------------------
const schemaHistoryUpdateRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "HistoryUpdateRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",
            fieldType: "RequestHeader",
        },
        {
            name: "HistoryUpdateDetails",
            fieldType: "ExtensionObject",
            isArray: true
        },
    ]
});
class HistoryUpdateRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaHistoryUpdateRequest; }
    static possibleFields = [
        "requestHeader",
        "historyUpdateDetails"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(698, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(700, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(699, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15287, 0);
    requestHeader;
    historyUpdateDetails;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestHeader = new RequestHeader(null);
            this.historyUpdateDetails = [];
            return;
        }
        const schema = HistoryUpdateRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestHeader = new RequestHeader(options.requestHeader);
        this.historyUpdateDetails = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.historyUpdateDetails);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.historyUpdateDetails, stream, node_opcua_extension_object_1.encodeExtensionObject);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.historyUpdateDetails = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_extension_object_1.decodeExtensionObject);
    }
    get schema() { return schemaHistoryUpdateRequest; }
}
exports.HistoryUpdateRequest = HistoryUpdateRequest;
HistoryUpdateRequest.schema.dataTypeNodeId = HistoryUpdateRequest.dataTypeNodeId;
HistoryUpdateRequest.schema.encodingDefaultBinary = HistoryUpdateRequest.encodingDefaultBinary;
HistoryUpdateRequest.schema.encodingDefaultXml = HistoryUpdateRequest.encodingDefaultXml;
HistoryUpdateRequest.schema.encodingDefaultJson = HistoryUpdateRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(HistoryUpdateRequest.dataTypeNodeId, "HistoryUpdateRequest", HistoryUpdateRequest);
// --------------------------------------------------------------------------------------------
const schemaHistoryUpdateResult = (0, node_opcua_factory_1.buildStructuredType)({
    name: "HistoryUpdateResult",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "StatusCode",
            fieldType: "StatusCode",
        },
        {
            name: "OperationResults",
            fieldType: "StatusCode",
            isArray: true
        },
        {
            name: "DiagnosticInfos",
            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
class HistoryUpdateResult extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaHistoryUpdateResult; }
    static possibleFields = [
        "statusCode",
        "operationResults",
        "diagnosticInfos"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(695, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(697, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(696, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15286, 0);
    statusCode;
    operationResults;
    diagnosticInfos;
    constructor(options) {
        super(options);
        if (options === null) {
            this.statusCode = node_opcua_status_code_1.StatusCodes.Good;
            this.operationResults = [];
            this.diagnosticInfos = [];
            return;
        }
        const schema = HistoryUpdateResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.statusCode = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.statusCode);
        this.operationResults = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.operationResults);
        this.diagnosticInfos = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.diagnosticInfos);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_status_code_1.encodeStatusCode)(this.statusCode, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.operationResults, stream, node_opcua_status_code_1.encodeStatusCode);
        (0, node_opcua_basic_types_1.encodeArray)(this.diagnosticInfos, stream, node_opcua_data_model_1.encodeDiagnosticInfo);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.statusCode = (0, node_opcua_status_code_1.decodeStatusCode)(stream, this.statusCode);
        this.operationResults = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_status_code_1.decodeStatusCode);
        this.diagnosticInfos = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_data_model_1.decodeDiagnosticInfo);
    }
    get schema() { return schemaHistoryUpdateResult; }
}
exports.HistoryUpdateResult = HistoryUpdateResult;
HistoryUpdateResult.schema.dataTypeNodeId = HistoryUpdateResult.dataTypeNodeId;
HistoryUpdateResult.schema.encodingDefaultBinary = HistoryUpdateResult.encodingDefaultBinary;
HistoryUpdateResult.schema.encodingDefaultXml = HistoryUpdateResult.encodingDefaultXml;
HistoryUpdateResult.schema.encodingDefaultJson = HistoryUpdateResult.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(HistoryUpdateResult.dataTypeNodeId, "HistoryUpdateResult", HistoryUpdateResult);
// --------------------------------------------------------------------------------------------
const schemaHistoryUpdateResponse = (0, node_opcua_factory_1.buildStructuredType)({
    name: "HistoryUpdateResponse",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",
            fieldType: "ResponseHeader",
        },
        {
            name: "Results",
            fieldType: "HistoryUpdateResult",
            isArray: true
        },
        {
            name: "DiagnosticInfos",
            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
class HistoryUpdateResponse extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaHistoryUpdateResponse; }
    static possibleFields = [
        "responseHeader",
        "results",
        "diagnosticInfos"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(701, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(703, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(702, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15288, 0);
    responseHeader;
    results;
    diagnosticInfos;
    constructor(options) {
        super(options);
        if (options === null) {
            this.responseHeader = new ResponseHeader(null);
            this.results = null; /* null array */
            this.diagnosticInfos = [];
            return;
        }
        const schema = HistoryUpdateResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.responseHeader = new ResponseHeader(options.responseHeader);
        this.results = []; // should default
        if (options.results) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.results));
            this.results = options.results.map((e) => new HistoryUpdateResult(e));
        }
        this.diagnosticInfos = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.diagnosticInfos);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.results, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.diagnosticInfos, stream, node_opcua_data_model_1.encodeDiagnosticInfo);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new HistoryUpdateResult(null);
            obj.decode(stream1);
            return obj;
        });
        this.diagnosticInfos = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_data_model_1.decodeDiagnosticInfo);
    }
    get schema() { return schemaHistoryUpdateResponse; }
}
exports.HistoryUpdateResponse = HistoryUpdateResponse;
HistoryUpdateResponse.schema.dataTypeNodeId = HistoryUpdateResponse.dataTypeNodeId;
HistoryUpdateResponse.schema.encodingDefaultBinary = HistoryUpdateResponse.encodingDefaultBinary;
HistoryUpdateResponse.schema.encodingDefaultXml = HistoryUpdateResponse.encodingDefaultXml;
HistoryUpdateResponse.schema.encodingDefaultJson = HistoryUpdateResponse.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(HistoryUpdateResponse.dataTypeNodeId, "HistoryUpdateResponse", HistoryUpdateResponse);
// --------------------------------------------------------------------------------------------
var IdentityCriteriaType;
(function (IdentityCriteriaType) {
    IdentityCriteriaType[IdentityCriteriaType["UserName"] = 1] = "UserName";
    IdentityCriteriaType[IdentityCriteriaType["Thumbprint"] = 2] = "Thumbprint";
    IdentityCriteriaType[IdentityCriteriaType["Role"] = 3] = "Role";
    IdentityCriteriaType[IdentityCriteriaType["GroupId"] = 4] = "GroupId";
    IdentityCriteriaType[IdentityCriteriaType["Anonymous"] = 5] = "Anonymous";
    IdentityCriteriaType[IdentityCriteriaType["AuthenticatedUser"] = 6] = "AuthenticatedUser";
    IdentityCriteriaType[IdentityCriteriaType["Application"] = 7] = "Application";
    IdentityCriteriaType[IdentityCriteriaType["X509Subject"] = 8] = "X509Subject";
    IdentityCriteriaType[IdentityCriteriaType["TrustedApplication"] = 9] = "TrustedApplication";
    IdentityCriteriaType[IdentityCriteriaType["Invalid"] = 4294967295] = "Invalid";
})(IdentityCriteriaType || (exports.IdentityCriteriaType = IdentityCriteriaType = {}));
const schemaIdentityCriteriaType = {
    enumValues: IdentityCriteriaType,
    flaggable: false,
    minValue: NaN,
    maxValue: NaN,
    name: "IdentityCriteriaType"
};
function decodeIdentityCriteriaType(stream, _value) {
    let value = stream.readUInt32();
    value = (value < schemaIdentityCriteriaType.minValue || value > schemaIdentityCriteriaType.maxValue) ? IdentityCriteriaType.Invalid : value;
    return value;
}
function encodeIdentityCriteriaType(value, stream) {
    stream.writeUInt32(value);
}
exports._enumerationIdentityCriteriaType = (0, node_opcua_factory_1.registerEnumeration)(schemaIdentityCriteriaType);
(0, node_opcua_assert_1.assert)(exports._enumerationIdentityCriteriaType.isFlaggable === false);
// --------------------------------------------------------------------------------------------
const schemaIdentityMappingRuleType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "IdentityMappingRuleType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "CriteriaType",
            fieldType: "IdentityCriteriaType",
        },
        {
            name: "Criteria",
            fieldType: "String",
        },
    ]
});
class IdentityMappingRuleType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaIdentityMappingRuleType; }
    static possibleFields = [
        "criteriaType",
        "criteria"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15634, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15736, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15728, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15042, 0);
    criteriaType;
    criteria;
    constructor(options) {
        super(options);
        if (options === null) {
            this.criteriaType = 0;
            this.criteria = null;
            return;
        }
        const schema = IdentityMappingRuleType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.criteriaType = this.setCriteriaType((0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.criteriaType));
        this.criteria = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.criteria);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        encodeIdentityCriteriaType(this.criteriaType, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.criteria, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.criteriaType = decodeIdentityCriteriaType(stream, this.criteriaType);
        this.criteria = (0, node_opcua_basic_types_1.decodeString)(stream, this.criteria);
    }
    // Define Enumeration setters
    setCriteriaType(value) {
        const coercedValue = exports._enumerationIdentityCriteriaType.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to IdentityCriteriaType :" + value);
        }
        this.criteriaType = coercedValue.value;
        return this.criteriaType;
    }
    get schema() { return schemaIdentityMappingRuleType; }
}
exports.IdentityMappingRuleType = IdentityMappingRuleType;
IdentityMappingRuleType.schema.dataTypeNodeId = IdentityMappingRuleType.dataTypeNodeId;
IdentityMappingRuleType.schema.encodingDefaultBinary = IdentityMappingRuleType.encodingDefaultBinary;
IdentityMappingRuleType.schema.encodingDefaultXml = IdentityMappingRuleType.encodingDefaultXml;
IdentityMappingRuleType.schema.encodingDefaultJson = IdentityMappingRuleType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(IdentityMappingRuleType.dataTypeNodeId, "IdentityMappingRuleType", IdentityMappingRuleType);
// --------------------------------------------------------------------------------------------
const schemaIssuedIdentityToken = (0, node_opcua_factory_1.buildStructuredType)({
    name: "IssuedIdentityToken",
    baseType: "UserIdentityToken",
    fields: [
        {
            name: "TokenData",
            fieldType: "ByteString",
        },
        {
            name: "EncryptionAlgorithm",
            fieldType: "String",
        },
    ]
});
class IssuedIdentityToken extends UserIdentityToken {
    static get schema() { return schemaIssuedIdentityToken; }
    static possibleFields = [
        "policyId",
        "tokenData",
        "encryptionAlgorithm"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(938, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(940, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(939, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15144, 0);
    tokenData;
    encryptionAlgorithm;
    constructor(options) {
        super(options);
        if (options === null) {
            this.tokenData = Buffer.alloc(0);
            this.encryptionAlgorithm = null;
            return;
        }
        const schema = IssuedIdentityToken.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.tokenData = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.tokenData);
        this.encryptionAlgorithm = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.encryptionAlgorithm);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeByteString)(this.tokenData, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.encryptionAlgorithm, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.tokenData = (0, node_opcua_basic_types_1.decodeByteString)(stream, this.tokenData);
        this.encryptionAlgorithm = (0, node_opcua_basic_types_1.decodeString)(stream, this.encryptionAlgorithm);
    }
    get schema() { return schemaIssuedIdentityToken; }
}
exports.IssuedIdentityToken = IssuedIdentityToken;
IssuedIdentityToken.schema.dataTypeNodeId = IssuedIdentityToken.dataTypeNodeId;
IssuedIdentityToken.schema.encodingDefaultBinary = IssuedIdentityToken.encodingDefaultBinary;
IssuedIdentityToken.schema.encodingDefaultXml = IssuedIdentityToken.encodingDefaultXml;
IssuedIdentityToken.schema.encodingDefaultJson = IssuedIdentityToken.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(IssuedIdentityToken.dataTypeNodeId, "IssuedIdentityToken", IssuedIdentityToken);
// --------------------------------------------------------------------------------------------
const schemaJsonActionMetaDataMessage = (0, node_opcua_factory_1.buildStructuredType)({
    name: "JsonActionMetaDataMessage",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "MessageId",
            fieldType: "String",
        },
        {
            name: "MessageType",
            fieldType: "String",
        },
        {
            name: "PublisherId",
            fieldType: "String",
        },
        {
            name: "DataSetWriterId",
            fieldType: "UInt16",
        },
        {
            name: "DataSetWriterName",
            fieldType: "String",
        },
        {
            name: "Timestamp",
            fieldType: "DateTime",
        },
        {
            name: "ActionTargets",
            fieldType: "ActionTargetDataType",
            isArray: true
        },
        {
            name: "Request",
            fieldType: "DataSetMetaDataType",
        },
        {
            name: "Response",
            fieldType: "DataSetMetaDataType",
        },
        {
            name: "ActionMethods",
            fieldType: "ActionMethodDataType",
            isArray: true
        },
    ]
});
class JsonActionMetaDataMessage extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaJsonActionMetaDataMessage; }
    static possibleFields = [
        "messageId",
        "messageType",
        "publisherId",
        "dataSetWriterId",
        "dataSetWriterName",
        "timestamp",
        "actionTargets",
        "request",
        "response",
        "actionMethods"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    messageId;
    messageType;
    publisherId;
    dataSetWriterId;
    dataSetWriterName;
    timestamp;
    actionTargets;
    request;
    response;
    actionMethods;
    constructor(options) {
        super(options);
        if (options === null) {
            this.messageId = null;
            this.messageType = null;
            this.publisherId = null;
            this.dataSetWriterId = 0;
            this.dataSetWriterName = null;
            this.timestamp = new Date();
            this.actionTargets = null; /* null array */
            this.request = new DataSetMetaDataType(null);
            this.response = new DataSetMetaDataType(null);
            this.actionMethods = null; /* null array */
            return;
        }
        const schema = JsonActionMetaDataMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.messageId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.messageId);
        this.messageType = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.messageType);
        this.publisherId = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.publisherId);
        this.dataSetWriterId = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.dataSetWriterId);
        this.dataSetWriterName = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.dataSetWriterName);
        this.timestamp = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.timestamp);
        this.actionTargets = []; // should default
        if (options.actionTargets) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.actionTargets));
            this.actionTargets = options.actionTargets.map((e) => new ActionTargetDataType(e));
        }
        this.request = new DataSetMetaDataType(options.request);
        this.response = new DataSetMetaDataType(options.response);
        this.actionMethods = []; // should default
        if (options.actionMethods) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.actionMethods));
            this.actionMethods = options.actionMethods.map((e) => new ActionMethodDataType(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.messageId, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.messageType, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.publisherId, stream);
        (0, node_opcua_basic_types_1.encodeUInt16)(this.dataSetWriterId, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.dataSetWriterName, stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.timestamp, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.actionTargets, stream, (obj, stream1) => { obj.encode(stream1); });
        this.request.encode(stream);
        this.response.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.actionMethods, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.messageId = (0, node_opcua_basic_types_1.decodeString)(stream, this.messageId);
        this.messageType = (0, node_opcua_basic_types_1.decodeString)(stream, this.messageType);
        this.publisherId = (0, node_opcua_basic_types_1.decodeString)(stream, this.publisherId);
        this.dataSetWriterId = (0, node_opcua_basic_types_1.decodeUInt16)(stream, this.dataSetWriterId);
        this.dataSetWriterName = (0, node_opcua_basic_types_1.decodeString)(stream, this.dataSetWriterName);
        this.timestamp = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.timestamp);
        this.actionTargets = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new ActionTargetDataType(null);
            obj.decode(stream1);
            return obj;
        });
        this.request.decode(stream);
        this.response.decode(stream);
        this.actionMethods = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new ActionMethodDataType(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaJsonActionMetaDataMessage; }
}
exports.JsonActionMetaDataMessage = JsonActionMetaDataMessage;
JsonActionMetaDataMessage.schema.dataTypeNodeId = JsonActionMetaDataMessage.dataTypeNodeId;
JsonActionMetaDataMessage.schema.encodingDefaultBinary = JsonActionMetaDataMessage.encodingDefaultBinary;
JsonActionMetaDataMessage.schema.encodingDefaultXml = JsonActionMetaDataMessage.encodingDefaultXml;
JsonActionMetaDataMessage.schema.encodingDefaultJson = JsonActionMetaDataMessage.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(JsonActionMetaDataMessage.dataTypeNodeId, "JsonActionMetaDataMessage", JsonActionMetaDataMessage);
// --------------------------------------------------------------------------------------------
const schemaJsonActionNetworkMessage = (0, node_opcua_factory_1.buildStructuredType)({
    name: "JsonActionNetworkMessage",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "MessageId",
            fieldType: "String",
        },
        {
            name: "MessageType",
            fieldType: "String",
        },
        {
            name: "PublisherId",
            fieldType: "String",
        },
        {
            name: "Timestamp",
            fieldType: "DateTime",
        },
        {
            name: "ResponseAddress",
            fieldType: "String",
        },
        {
            name: "CorrelationData",
            fieldType: "ByteString",
        },
        {
            name: "RequestorId",
            fieldType: "String",
        },
        {
            name: "TimeoutHint",
            fieldType: "Double",
        },
        {
            name: "Messages",
            fieldType: "ExtensionObject",
            isArray: true
        },
    ]
});
class JsonActionNetworkMessage extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaJsonActionNetworkMessage; }
    static possibleFields = [
        "messageId",
        "messageType",
        "publisherId",
        "timestamp",
        "responseAddress",
        "correlationData",
        "requestorId",
        "timeoutHint",
        "messages"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    messageId;
    messageType;
    publisherId;
    timestamp;
    responseAddress;
    correlationData;
    requestorId;
    timeoutHint;
    messages;
    constructor(options) {
        super(options);
        if (options === null) {
            this.messageId = null;
            this.messageType = null;
            this.publisherId = null;
            this.timestamp = new Date();
            this.responseAddress = null;
            this.correlationData = Buffer.alloc(0);
            this.requestorId = null;
            this.timeoutHint = 0;
            this.messages = [];
            return;
        }
        const schema = JsonActionNetworkMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.messageId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.messageId);
        this.messageType = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.messageType);
        this.publisherId = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.publisherId);
        this.timestamp = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.timestamp);
        this.responseAddress = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.responseAddress);
        this.correlationData = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.correlationData);
        this.requestorId = (0, node_opcua_factory_1.initialize_field)(schema.fields[6], options?.requestorId);
        this.timeoutHint = (0, node_opcua_factory_1.initialize_field)(schema.fields[7], options?.timeoutHint);
        this.messages = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[8], options?.messages);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.messageId, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.messageType, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.publisherId, stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.timestamp, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.responseAddress, stream);
        (0, node_opcua_basic_types_1.encodeByteString)(this.correlationData, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.requestorId, stream);
        (0, node_opcua_basic_types_1.encodeDouble)(this.timeoutHint, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.messages, stream, node_opcua_extension_object_1.encodeExtensionObject);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.messageId = (0, node_opcua_basic_types_1.decodeString)(stream, this.messageId);
        this.messageType = (0, node_opcua_basic_types_1.decodeString)(stream, this.messageType);
        this.publisherId = (0, node_opcua_basic_types_1.decodeString)(stream, this.publisherId);
        this.timestamp = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.timestamp);
        this.responseAddress = (0, node_opcua_basic_types_1.decodeString)(stream, this.responseAddress);
        this.correlationData = (0, node_opcua_basic_types_1.decodeByteString)(stream, this.correlationData);
        this.requestorId = (0, node_opcua_basic_types_1.decodeString)(stream, this.requestorId);
        this.timeoutHint = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.timeoutHint);
        this.messages = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_extension_object_1.decodeExtensionObject);
    }
    get schema() { return schemaJsonActionNetworkMessage; }
}
exports.JsonActionNetworkMessage = JsonActionNetworkMessage;
JsonActionNetworkMessage.schema.dataTypeNodeId = JsonActionNetworkMessage.dataTypeNodeId;
JsonActionNetworkMessage.schema.encodingDefaultBinary = JsonActionNetworkMessage.encodingDefaultBinary;
JsonActionNetworkMessage.schema.encodingDefaultXml = JsonActionNetworkMessage.encodingDefaultXml;
JsonActionNetworkMessage.schema.encodingDefaultJson = JsonActionNetworkMessage.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(JsonActionNetworkMessage.dataTypeNodeId, "JsonActionNetworkMessage", JsonActionNetworkMessage);
// --------------------------------------------------------------------------------------------
var ActionState;
(function (ActionState) {
    ActionState[ActionState["Idle"] = 0] = "Idle";
    ActionState[ActionState["Executing"] = 1] = "Executing";
    ActionState[ActionState["Done"] = 2] = "Done";
    ActionState[ActionState["Invalid"] = 4294967295] = "Invalid";
})(ActionState || (exports.ActionState = ActionState = {}));
const schemaActionState = {
    enumValues: ActionState,
    flaggable: false,
    minValue: 0,
    maxValue: 2,
    name: "ActionState"
};
function decodeActionState(stream, _value) {
    let value = stream.readUInt32();
    value = (value < schemaActionState.minValue || value > schemaActionState.maxValue) ? ActionState.Invalid : value;
    return value;
}
function encodeActionState(value, stream) {
    stream.writeUInt32(value);
}
exports._enumerationActionState = (0, node_opcua_factory_1.registerEnumeration)(schemaActionState);
(0, node_opcua_assert_1.assert)(exports._enumerationActionState.isFlaggable === false);
// --------------------------------------------------------------------------------------------
const schemaJsonActionRequestMessage = (0, node_opcua_factory_1.buildStructuredType)({
    name: "JsonActionRequestMessage",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "DataSetWriterId",
            fieldType: "UInt16",
        },
        {
            name: "ActionTargetId",
            fieldType: "UInt16",
        },
        {
            name: "DataSetWriterName",
            fieldType: "String",
        },
        {
            name: "WriterGroupName",
            fieldType: "String",
        },
        {
            name: "MetaDataVersion",
            fieldType: "ConfigurationVersionDataType",
        },
        {
            name: "MinorVersion",
            fieldType: "UInt32",
        },
        {
            name: "Timestamp",
            fieldType: "DateTime",
        },
        {
            name: "MessageType",
            fieldType: "String",
        },
        {
            name: "RequestId",
            fieldType: "UInt16",
        },
        {
            name: "ActionState",
            fieldType: "ActionState",
        },
        {
            name: "Payload",
            fieldType: "ExtensionObject",
        },
    ]
});
class JsonActionRequestMessage extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaJsonActionRequestMessage; }
    static possibleFields = [
        "dataSetWriterId",
        "actionTargetId",
        "dataSetWriterName",
        "writerGroupName",
        "metaDataVersion",
        "minorVersion",
        "timestamp",
        "messageType",
        "requestId",
        "actionState",
        "payload"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    dataSetWriterId;
    actionTargetId;
    dataSetWriterName;
    writerGroupName;
    metaDataVersion;
    minorVersion;
    timestamp;
    messageType;
    requestId;
    actionState;
    payload;
    constructor(options) {
        super(options);
        if (options === null) {
            this.dataSetWriterId = 0;
            this.actionTargetId = 0;
            this.dataSetWriterName = null;
            this.writerGroupName = null;
            this.metaDataVersion = new ConfigurationVersionDataType(null);
            this.minorVersion = 0;
            this.timestamp = new Date();
            this.messageType = null;
            this.requestId = 0;
            this.actionState = 0;
            this.payload = null;
            return;
        }
        const schema = JsonActionRequestMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.dataSetWriterId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.dataSetWriterId);
        this.actionTargetId = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.actionTargetId);
        this.dataSetWriterName = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.dataSetWriterName);
        this.writerGroupName = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.writerGroupName);
        this.metaDataVersion = new ConfigurationVersionDataType(options.metaDataVersion);
        this.minorVersion = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.minorVersion);
        this.timestamp = (0, node_opcua_factory_1.initialize_field)(schema.fields[6], options?.timestamp);
        this.messageType = (0, node_opcua_factory_1.initialize_field)(schema.fields[7], options?.messageType);
        this.requestId = (0, node_opcua_factory_1.initialize_field)(schema.fields[8], options?.requestId);
        this.actionState = this.setActionState((0, node_opcua_factory_1.initialize_field)(schema.fields[9], options?.actionState));
        this.payload = (0, node_opcua_factory_1.initialize_field)(schema.fields[10], options?.payload);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt16)(this.dataSetWriterId, stream);
        (0, node_opcua_basic_types_1.encodeUInt16)(this.actionTargetId, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.dataSetWriterName, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.writerGroupName, stream);
        this.metaDataVersion.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.minorVersion, stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.timestamp, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.messageType, stream);
        (0, node_opcua_basic_types_1.encodeUInt16)(this.requestId, stream);
        encodeActionState(this.actionState, stream);
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.payload, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.dataSetWriterId = (0, node_opcua_basic_types_1.decodeUInt16)(stream, this.dataSetWriterId);
        this.actionTargetId = (0, node_opcua_basic_types_1.decodeUInt16)(stream, this.actionTargetId);
        this.dataSetWriterName = (0, node_opcua_basic_types_1.decodeString)(stream, this.dataSetWriterName);
        this.writerGroupName = (0, node_opcua_basic_types_1.decodeString)(stream, this.writerGroupName);
        this.metaDataVersion.decode(stream);
        this.minorVersion = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.minorVersion);
        this.timestamp = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.timestamp);
        this.messageType = (0, node_opcua_basic_types_1.decodeString)(stream, this.messageType);
        this.requestId = (0, node_opcua_basic_types_1.decodeUInt16)(stream, this.requestId);
        this.actionState = decodeActionState(stream, this.actionState);
        this.payload = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.payload);
    }
    // Define Enumeration setters
    setActionState(value) {
        const coercedValue = exports._enumerationActionState.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to ActionState :" + value);
        }
        this.actionState = coercedValue.value;
        return this.actionState;
    }
    get schema() { return schemaJsonActionRequestMessage; }
}
exports.JsonActionRequestMessage = JsonActionRequestMessage;
JsonActionRequestMessage.schema.dataTypeNodeId = JsonActionRequestMessage.dataTypeNodeId;
JsonActionRequestMessage.schema.encodingDefaultBinary = JsonActionRequestMessage.encodingDefaultBinary;
JsonActionRequestMessage.schema.encodingDefaultXml = JsonActionRequestMessage.encodingDefaultXml;
JsonActionRequestMessage.schema.encodingDefaultJson = JsonActionRequestMessage.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(JsonActionRequestMessage.dataTypeNodeId, "JsonActionRequestMessage", JsonActionRequestMessage);
// --------------------------------------------------------------------------------------------
const schemaPubSubGroupDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "PubSubGroupDataType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Name",
            fieldType: "String",
        },
        {
            name: "Enabled",
            fieldType: "Boolean",
        },
        {
            name: "SecurityMode",
            fieldType: "MessageSecurityMode",
        },
        {
            name: "SecurityGroupId",
            fieldType: "String",
        },
        {
            name: "SecurityKeyServices",
            fieldType: "EndpointDescription",
            isArray: true
        },
        {
            name: "MaxNetworkMessageSize",
            fieldType: "UInt32",
        },
        {
            name: "GroupProperties",
            fieldType: "KeyValuePair",
            isArray: true
        },
    ]
});
class PubSubGroupDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaPubSubGroupDataType; }
    static possibleFields = [
        "name",
        "enabled",
        "securityMode",
        "securityGroupId",
        "securityKeyServices",
        "maxNetworkMessageSize",
        "groupProperties"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15609, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15689, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15988, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16159, 0);
    name;
    enabled;
    securityMode;
    securityGroupId;
    securityKeyServices;
    maxNetworkMessageSize;
    groupProperties;
    constructor(options) {
        super(options);
        if (options === null) {
            this.name = null;
            this.enabled = false;
            this.securityMode = 0;
            this.securityGroupId = null;
            this.securityKeyServices = null; /* null array */
            this.maxNetworkMessageSize = 0;
            this.groupProperties = null; /* null array */
            return;
        }
        const schema = PubSubGroupDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.name = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.name);
        this.enabled = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.enabled);
        this.securityMode = this.setSecurityMode((0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.securityMode));
        this.securityGroupId = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.securityGroupId);
        this.securityKeyServices = []; // should default
        if (options.securityKeyServices) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.securityKeyServices));
            this.securityKeyServices = options.securityKeyServices.map((e) => new EndpointDescription(e));
        }
        this.maxNetworkMessageSize = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.maxNetworkMessageSize);
        this.groupProperties = []; // should default
        if (options.groupProperties) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.groupProperties));
            this.groupProperties = options.groupProperties.map((e) => new KeyValuePair(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.name, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.enabled, stream);
        encodeMessageSecurityMode(this.securityMode, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.securityGroupId, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.securityKeyServices, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeUInt32)(this.maxNetworkMessageSize, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.groupProperties, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = (0, node_opcua_basic_types_1.decodeString)(stream, this.name);
        this.enabled = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.enabled);
        this.securityMode = decodeMessageSecurityMode(stream, this.securityMode);
        this.securityGroupId = (0, node_opcua_basic_types_1.decodeString)(stream, this.securityGroupId);
        this.securityKeyServices = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new EndpointDescription(null);
            obj.decode(stream1);
            return obj;
        });
        this.maxNetworkMessageSize = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.maxNetworkMessageSize);
        this.groupProperties = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new KeyValuePair(null);
            obj.decode(stream1);
            return obj;
        });
    }
    // Define Enumeration setters
    setSecurityMode(value) {
        const coercedValue = exports._enumerationMessageSecurityMode.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to MessageSecurityMode :" + value);
        }
        this.securityMode = coercedValue.value;
        return this.securityMode;
    }
    get schema() { return schemaPubSubGroupDataType; }
}
exports.PubSubGroupDataType = PubSubGroupDataType;
PubSubGroupDataType.schema.dataTypeNodeId = PubSubGroupDataType.dataTypeNodeId;
PubSubGroupDataType.schema.encodingDefaultBinary = PubSubGroupDataType.encodingDefaultBinary;
PubSubGroupDataType.schema.encodingDefaultXml = PubSubGroupDataType.encodingDefaultXml;
PubSubGroupDataType.schema.encodingDefaultJson = PubSubGroupDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(PubSubGroupDataType.dataTypeNodeId, "PubSubGroupDataType", PubSubGroupDataType);
// --------------------------------------------------------------------------------------------
const schemaWriterGroupDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "WriterGroupDataType",
    baseType: "PubSubGroupDataType",
    fields: [
        {
            name: "WriterGroupId",
            fieldType: "UInt16",
        },
        {
            name: "PublishingInterval",
            fieldType: "Double",
        },
        {
            name: "KeepAliveTime",
            fieldType: "Double",
        },
        {
            name: "Priority",
            fieldType: "Byte",
        },
        {
            name: "LocaleIds",
            fieldType: "String",
            isArray: true
        },
        {
            name: "HeaderLayoutUri",
            fieldType: "String",
        },
        {
            name: "TransportSettings",
            fieldType: "ExtensionObject",
        },
        {
            name: "MessageSettings",
            fieldType: "ExtensionObject",
        },
        {
            name: "DataSetWriters",
            fieldType: "DataSetWriterDataType",
            isArray: true
        },
    ]
});
class WriterGroupDataType extends PubSubGroupDataType {
    static get schema() { return schemaWriterGroupDataType; }
    static possibleFields = [
        "name",
        "enabled",
        "securityMode",
        "securityGroupId",
        "securityKeyServices",
        "maxNetworkMessageSize",
        "groupProperties",
        "writerGroupId",
        "publishingInterval",
        "keepAliveTime",
        "priority",
        "localeIds",
        "headerLayoutUri",
        "transportSettings",
        "messageSettings",
        "dataSetWriters"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15480, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(21150, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(21174, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(21198, 0);
    writerGroupId;
    publishingInterval;
    keepAliveTime;
    priority;
    localeIds;
    headerLayoutUri;
    transportSettings;
    messageSettings;
    dataSetWriters;
    constructor(options) {
        super(options);
        if (options === null) {
            this.writerGroupId = 0;
            this.publishingInterval = 0;
            this.keepAliveTime = 0;
            this.priority = 0;
            this.localeIds = [];
            this.headerLayoutUri = null;
            this.transportSettings = null;
            this.messageSettings = null;
            this.dataSetWriters = null; /* null array */
            return;
        }
        const schema = WriterGroupDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.writerGroupId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.writerGroupId);
        this.publishingInterval = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.publishingInterval);
        this.keepAliveTime = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.keepAliveTime);
        this.priority = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.priority);
        this.localeIds = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[4], options?.localeIds);
        this.headerLayoutUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.headerLayoutUri);
        this.transportSettings = (0, node_opcua_factory_1.initialize_field)(schema.fields[6], options?.transportSettings);
        this.messageSettings = (0, node_opcua_factory_1.initialize_field)(schema.fields[7], options?.messageSettings);
        this.dataSetWriters = []; // should default
        if (options.dataSetWriters) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.dataSetWriters));
            this.dataSetWriters = options.dataSetWriters.map((e) => new DataSetWriterDataType(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt16)(this.writerGroupId, stream);
        (0, node_opcua_basic_types_1.encodeDouble)(this.publishingInterval, stream);
        (0, node_opcua_basic_types_1.encodeDouble)(this.keepAliveTime, stream);
        (0, node_opcua_basic_types_1.encodeByte)(this.priority, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.localeIds, stream, node_opcua_basic_types_1.encodeString);
        (0, node_opcua_basic_types_1.encodeString)(this.headerLayoutUri, stream);
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.transportSettings, stream);
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.messageSettings, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.dataSetWriters, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.writerGroupId = (0, node_opcua_basic_types_1.decodeUInt16)(stream, this.writerGroupId);
        this.publishingInterval = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.publishingInterval);
        this.keepAliveTime = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.keepAliveTime);
        this.priority = (0, node_opcua_basic_types_1.decodeByte)(stream, this.priority);
        this.localeIds = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeString);
        this.headerLayoutUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.headerLayoutUri);
        this.transportSettings = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.transportSettings);
        this.messageSettings = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.messageSettings);
        this.dataSetWriters = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new DataSetWriterDataType(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaWriterGroupDataType; }
}
exports.WriterGroupDataType = WriterGroupDataType;
WriterGroupDataType.schema.dataTypeNodeId = WriterGroupDataType.dataTypeNodeId;
WriterGroupDataType.schema.encodingDefaultBinary = WriterGroupDataType.encodingDefaultBinary;
WriterGroupDataType.schema.encodingDefaultXml = WriterGroupDataType.encodingDefaultXml;
WriterGroupDataType.schema.encodingDefaultJson = WriterGroupDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(WriterGroupDataType.dataTypeNodeId, "WriterGroupDataType", WriterGroupDataType);
// --------------------------------------------------------------------------------------------
const schemaReaderGroupDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ReaderGroupDataType",
    baseType: "PubSubGroupDataType",
    fields: [
        {
            name: "TransportSettings",
            fieldType: "ExtensionObject",
        },
        {
            name: "MessageSettings",
            fieldType: "ExtensionObject",
        },
        {
            name: "DataSetReaders",
            fieldType: "DataSetReaderDataType",
            isArray: true
        },
    ]
});
class ReaderGroupDataType extends PubSubGroupDataType {
    static get schema() { return schemaReaderGroupDataType; }
    static possibleFields = [
        "name",
        "enabled",
        "securityMode",
        "securityGroupId",
        "securityKeyServices",
        "maxNetworkMessageSize",
        "groupProperties",
        "transportSettings",
        "messageSettings",
        "dataSetReaders"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15520, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(21153, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(21177, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(21201, 0);
    transportSettings;
    messageSettings;
    dataSetReaders;
    constructor(options) {
        super(options);
        if (options === null) {
            this.transportSettings = null;
            this.messageSettings = null;
            this.dataSetReaders = null; /* null array */
            return;
        }
        const schema = ReaderGroupDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.transportSettings = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.transportSettings);
        this.messageSettings = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.messageSettings);
        this.dataSetReaders = []; // should default
        if (options.dataSetReaders) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.dataSetReaders));
            this.dataSetReaders = options.dataSetReaders.map((e) => new DataSetReaderDataType(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.transportSettings, stream);
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.messageSettings, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.dataSetReaders, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.transportSettings = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.transportSettings);
        this.messageSettings = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.messageSettings);
        this.dataSetReaders = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new DataSetReaderDataType(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaReaderGroupDataType; }
}
exports.ReaderGroupDataType = ReaderGroupDataType;
ReaderGroupDataType.schema.dataTypeNodeId = ReaderGroupDataType.dataTypeNodeId;
ReaderGroupDataType.schema.encodingDefaultBinary = ReaderGroupDataType.encodingDefaultBinary;
ReaderGroupDataType.schema.encodingDefaultXml = ReaderGroupDataType.encodingDefaultXml;
ReaderGroupDataType.schema.encodingDefaultJson = ReaderGroupDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ReaderGroupDataType.dataTypeNodeId, "ReaderGroupDataType", ReaderGroupDataType);
// --------------------------------------------------------------------------------------------
const schemaPubSubConnectionDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "PubSubConnectionDataType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Name",
            fieldType: "String",
        },
        {
            name: "Enabled",
            fieldType: "Boolean",
        },
        {
            name: "PublisherId",
            fieldType: "Variant",
        },
        {
            name: "TransportProfileUri",
            fieldType: "String",
        },
        {
            name: "Address",
            fieldType: "ExtensionObject",
        },
        {
            name: "ConnectionProperties",
            fieldType: "KeyValuePair",
            isArray: true
        },
        {
            name: "TransportSettings",
            fieldType: "ExtensionObject",
        },
        {
            name: "WriterGroups",
            fieldType: "WriterGroupDataType",
            isArray: true
        },
        {
            name: "ReaderGroups",
            fieldType: "ReaderGroupDataType",
            isArray: true
        },
    ]
});
class PubSubConnectionDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaPubSubConnectionDataType; }
    static possibleFields = [
        "name",
        "enabled",
        "publisherId",
        "transportProfileUri",
        "address",
        "connectionProperties",
        "transportSettings",
        "writerGroups",
        "readerGroups"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15617, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15694, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15992, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16281, 0);
    name;
    enabled;
    publisherId;
    transportProfileUri;
    address;
    connectionProperties;
    transportSettings;
    writerGroups;
    readerGroups;
    constructor(options) {
        super(options);
        if (options === null) {
            this.name = null;
            this.enabled = false;
            this.publisherId = new node_opcua_variant_1.Variant(null);
            this.transportProfileUri = null;
            this.address = null;
            this.connectionProperties = null; /* null array */
            this.transportSettings = null;
            this.writerGroups = null; /* null array */
            this.readerGroups = null; /* null array */
            return;
        }
        const schema = PubSubConnectionDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.name = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.name);
        this.enabled = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.enabled);
        this.publisherId = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.publisherId);
        this.transportProfileUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.transportProfileUri);
        this.address = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.address);
        this.connectionProperties = []; // should default
        if (options.connectionProperties) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.connectionProperties));
            this.connectionProperties = options.connectionProperties.map((e) => new KeyValuePair(e));
        }
        this.transportSettings = (0, node_opcua_factory_1.initialize_field)(schema.fields[6], options?.transportSettings);
        this.writerGroups = []; // should default
        if (options.writerGroups) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.writerGroups));
            this.writerGroups = options.writerGroups.map((e) => new WriterGroupDataType(e));
        }
        this.readerGroups = []; // should default
        if (options.readerGroups) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.readerGroups));
            this.readerGroups = options.readerGroups.map((e) => new ReaderGroupDataType(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.name, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.enabled, stream);
        (0, node_opcua_variant_1.encodeVariant)(this.publisherId, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.transportProfileUri, stream);
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.address, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.connectionProperties, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.transportSettings, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.writerGroups, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.readerGroups, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = (0, node_opcua_basic_types_1.decodeString)(stream, this.name);
        this.enabled = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.enabled);
        this.publisherId = (0, node_opcua_variant_1.decodeVariant)(stream, this.publisherId);
        this.transportProfileUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.transportProfileUri);
        this.address = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.address);
        this.connectionProperties = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new KeyValuePair(null);
            obj.decode(stream1);
            return obj;
        });
        this.transportSettings = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.transportSettings);
        this.writerGroups = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new WriterGroupDataType(null);
            obj.decode(stream1);
            return obj;
        });
        this.readerGroups = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new ReaderGroupDataType(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaPubSubConnectionDataType; }
}
exports.PubSubConnectionDataType = PubSubConnectionDataType;
PubSubConnectionDataType.schema.dataTypeNodeId = PubSubConnectionDataType.dataTypeNodeId;
PubSubConnectionDataType.schema.encodingDefaultBinary = PubSubConnectionDataType.encodingDefaultBinary;
PubSubConnectionDataType.schema.encodingDefaultXml = PubSubConnectionDataType.encodingDefaultXml;
PubSubConnectionDataType.schema.encodingDefaultJson = PubSubConnectionDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(PubSubConnectionDataType.dataTypeNodeId, "PubSubConnectionDataType", PubSubConnectionDataType);
// --------------------------------------------------------------------------------------------
const schemaJsonActionResponderMessage = (0, node_opcua_factory_1.buildStructuredType)({
    name: "JsonActionResponderMessage",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "MessageId",
            fieldType: "String",
        },
        {
            name: "MessageType",
            fieldType: "String",
        },
        {
            name: "PublisherId",
            fieldType: "String",
        },
        {
            name: "Timestamp",
            fieldType: "DateTime",
        },
        {
            name: "Connection",
            fieldType: "PubSubConnectionDataType",
        },
    ]
});
class JsonActionResponderMessage extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaJsonActionResponderMessage; }
    static possibleFields = [
        "messageId",
        "messageType",
        "publisherId",
        "timestamp",
        "connection"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    messageId;
    messageType;
    publisherId;
    timestamp;
    connection;
    constructor(options) {
        super(options);
        if (options === null) {
            this.messageId = null;
            this.messageType = null;
            this.publisherId = null;
            this.timestamp = new Date();
            this.connection = new PubSubConnectionDataType(null);
            return;
        }
        const schema = JsonActionResponderMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.messageId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.messageId);
        this.messageType = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.messageType);
        this.publisherId = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.publisherId);
        this.timestamp = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.timestamp);
        this.connection = new PubSubConnectionDataType(options.connection);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.messageId, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.messageType, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.publisherId, stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.timestamp, stream);
        this.connection.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.messageId = (0, node_opcua_basic_types_1.decodeString)(stream, this.messageId);
        this.messageType = (0, node_opcua_basic_types_1.decodeString)(stream, this.messageType);
        this.publisherId = (0, node_opcua_basic_types_1.decodeString)(stream, this.publisherId);
        this.timestamp = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.timestamp);
        this.connection.decode(stream);
    }
    get schema() { return schemaJsonActionResponderMessage; }
}
exports.JsonActionResponderMessage = JsonActionResponderMessage;
JsonActionResponderMessage.schema.dataTypeNodeId = JsonActionResponderMessage.dataTypeNodeId;
JsonActionResponderMessage.schema.encodingDefaultBinary = JsonActionResponderMessage.encodingDefaultBinary;
JsonActionResponderMessage.schema.encodingDefaultXml = JsonActionResponderMessage.encodingDefaultXml;
JsonActionResponderMessage.schema.encodingDefaultJson = JsonActionResponderMessage.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(JsonActionResponderMessage.dataTypeNodeId, "JsonActionResponderMessage", JsonActionResponderMessage);
// --------------------------------------------------------------------------------------------
const schemaJsonActionResponseMessage = (0, node_opcua_factory_1.buildStructuredType)({
    name: "JsonActionResponseMessage",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "DataSetWriterId",
            fieldType: "UInt16",
        },
        {
            name: "ActionTargetId",
            fieldType: "UInt16",
        },
        {
            name: "DataSetWriterName",
            fieldType: "String",
        },
        {
            name: "WriterGroupName",
            fieldType: "String",
        },
        {
            name: "MetaDataVersion",
            fieldType: "ConfigurationVersionDataType",
        },
        {
            name: "MinorVersion",
            fieldType: "UInt32",
        },
        {
            name: "Timestamp",
            fieldType: "DateTime",
        },
        {
            name: "Status",
            fieldType: "StatusCode",
        },
        {
            name: "MessageType",
            fieldType: "String",
        },
        {
            name: "RequestId",
            fieldType: "UInt16",
        },
        {
            name: "ActionState",
            fieldType: "ActionState",
        },
        {
            name: "Payload",
            fieldType: "ExtensionObject",
        },
    ]
});
class JsonActionResponseMessage extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaJsonActionResponseMessage; }
    static possibleFields = [
        "dataSetWriterId",
        "actionTargetId",
        "dataSetWriterName",
        "writerGroupName",
        "metaDataVersion",
        "minorVersion",
        "timestamp",
        "status",
        "messageType",
        "requestId",
        "actionState",
        "payload"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    dataSetWriterId;
    actionTargetId;
    dataSetWriterName;
    writerGroupName;
    metaDataVersion;
    minorVersion;
    timestamp;
    status;
    messageType;
    requestId;
    actionState;
    payload;
    constructor(options) {
        super(options);
        if (options === null) {
            this.dataSetWriterId = 0;
            this.actionTargetId = 0;
            this.dataSetWriterName = null;
            this.writerGroupName = null;
            this.metaDataVersion = new ConfigurationVersionDataType(null);
            this.minorVersion = 0;
            this.timestamp = new Date();
            this.status = node_opcua_status_code_1.StatusCodes.Good;
            this.messageType = null;
            this.requestId = 0;
            this.actionState = 0;
            this.payload = null;
            return;
        }
        const schema = JsonActionResponseMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.dataSetWriterId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.dataSetWriterId);
        this.actionTargetId = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.actionTargetId);
        this.dataSetWriterName = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.dataSetWriterName);
        this.writerGroupName = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.writerGroupName);
        this.metaDataVersion = new ConfigurationVersionDataType(options.metaDataVersion);
        this.minorVersion = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.minorVersion);
        this.timestamp = (0, node_opcua_factory_1.initialize_field)(schema.fields[6], options?.timestamp);
        this.status = (0, node_opcua_factory_1.initialize_field)(schema.fields[7], options?.status);
        this.messageType = (0, node_opcua_factory_1.initialize_field)(schema.fields[8], options?.messageType);
        this.requestId = (0, node_opcua_factory_1.initialize_field)(schema.fields[9], options?.requestId);
        this.actionState = this.setActionState((0, node_opcua_factory_1.initialize_field)(schema.fields[10], options?.actionState));
        this.payload = (0, node_opcua_factory_1.initialize_field)(schema.fields[11], options?.payload);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt16)(this.dataSetWriterId, stream);
        (0, node_opcua_basic_types_1.encodeUInt16)(this.actionTargetId, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.dataSetWriterName, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.writerGroupName, stream);
        this.metaDataVersion.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.minorVersion, stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.timestamp, stream);
        (0, node_opcua_status_code_1.encodeStatusCode)(this.status, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.messageType, stream);
        (0, node_opcua_basic_types_1.encodeUInt16)(this.requestId, stream);
        encodeActionState(this.actionState, stream);
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.payload, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.dataSetWriterId = (0, node_opcua_basic_types_1.decodeUInt16)(stream, this.dataSetWriterId);
        this.actionTargetId = (0, node_opcua_basic_types_1.decodeUInt16)(stream, this.actionTargetId);
        this.dataSetWriterName = (0, node_opcua_basic_types_1.decodeString)(stream, this.dataSetWriterName);
        this.writerGroupName = (0, node_opcua_basic_types_1.decodeString)(stream, this.writerGroupName);
        this.metaDataVersion.decode(stream);
        this.minorVersion = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.minorVersion);
        this.timestamp = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.timestamp);
        this.status = (0, node_opcua_status_code_1.decodeStatusCode)(stream, this.status);
        this.messageType = (0, node_opcua_basic_types_1.decodeString)(stream, this.messageType);
        this.requestId = (0, node_opcua_basic_types_1.decodeUInt16)(stream, this.requestId);
        this.actionState = decodeActionState(stream, this.actionState);
        this.payload = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.payload);
    }
    // Define Enumeration setters
    setActionState(value) {
        const coercedValue = exports._enumerationActionState.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to ActionState :" + value);
        }
        this.actionState = coercedValue.value;
        return this.actionState;
    }
    get schema() { return schemaJsonActionResponseMessage; }
}
exports.JsonActionResponseMessage = JsonActionResponseMessage;
JsonActionResponseMessage.schema.dataTypeNodeId = JsonActionResponseMessage.dataTypeNodeId;
JsonActionResponseMessage.schema.encodingDefaultBinary = JsonActionResponseMessage.encodingDefaultBinary;
JsonActionResponseMessage.schema.encodingDefaultXml = JsonActionResponseMessage.encodingDefaultXml;
JsonActionResponseMessage.schema.encodingDefaultJson = JsonActionResponseMessage.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(JsonActionResponseMessage.dataTypeNodeId, "JsonActionResponseMessage", JsonActionResponseMessage);
// --------------------------------------------------------------------------------------------
const schemaJsonApplicationDescriptionMessage = (0, node_opcua_factory_1.buildStructuredType)({
    name: "JsonApplicationDescriptionMessage",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "MessageId",
            fieldType: "String",
        },
        {
            name: "MessageType",
            fieldType: "String",
        },
        {
            name: "PublisherId",
            fieldType: "String",
        },
        {
            name: "Timestamp",
            fieldType: "DateTime",
        },
        {
            name: "Description",
            fieldType: "ApplicationDescription",
        },
        {
            name: "ServerCapabilities",
            fieldType: "String",
            isArray: true
        },
    ]
});
class JsonApplicationDescriptionMessage extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaJsonApplicationDescriptionMessage; }
    static possibleFields = [
        "messageId",
        "messageType",
        "publisherId",
        "timestamp",
        "description",
        "serverCapabilities"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    messageId;
    messageType;
    publisherId;
    timestamp;
    description;
    serverCapabilities;
    constructor(options) {
        super(options);
        if (options === null) {
            this.messageId = null;
            this.messageType = null;
            this.publisherId = null;
            this.timestamp = new Date();
            this.description = new ApplicationDescription(null);
            this.serverCapabilities = [];
            return;
        }
        const schema = JsonApplicationDescriptionMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.messageId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.messageId);
        this.messageType = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.messageType);
        this.publisherId = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.publisherId);
        this.timestamp = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.timestamp);
        this.description = new ApplicationDescription(options.description);
        this.serverCapabilities = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[5], options?.serverCapabilities);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.messageId, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.messageType, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.publisherId, stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.timestamp, stream);
        this.description.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.serverCapabilities, stream, node_opcua_basic_types_1.encodeString);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.messageId = (0, node_opcua_basic_types_1.decodeString)(stream, this.messageId);
        this.messageType = (0, node_opcua_basic_types_1.decodeString)(stream, this.messageType);
        this.publisherId = (0, node_opcua_basic_types_1.decodeString)(stream, this.publisherId);
        this.timestamp = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.timestamp);
        this.description.decode(stream);
        this.serverCapabilities = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeString);
    }
    get schema() { return schemaJsonApplicationDescriptionMessage; }
}
exports.JsonApplicationDescriptionMessage = JsonApplicationDescriptionMessage;
JsonApplicationDescriptionMessage.schema.dataTypeNodeId = JsonApplicationDescriptionMessage.dataTypeNodeId;
JsonApplicationDescriptionMessage.schema.encodingDefaultBinary = JsonApplicationDescriptionMessage.encodingDefaultBinary;
JsonApplicationDescriptionMessage.schema.encodingDefaultXml = JsonApplicationDescriptionMessage.encodingDefaultXml;
JsonApplicationDescriptionMessage.schema.encodingDefaultJson = JsonApplicationDescriptionMessage.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(JsonApplicationDescriptionMessage.dataTypeNodeId, "JsonApplicationDescriptionMessage", JsonApplicationDescriptionMessage);
// --------------------------------------------------------------------------------------------
const schemaJsonDataSetMessage = (0, node_opcua_factory_1.buildStructuredType)({
    name: "JsonDataSetMessage",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "DataSetWriterId",
            fieldType: "UInt16",
        },
        {
            name: "DataSetWriterName",
            fieldType: "String",
        },
        {
            name: "PublisherId",
            fieldType: "String",
        },
        {
            name: "WriterGroupName",
            fieldType: "String",
        },
        {
            name: "SequenceNumber",
            fieldType: "UInt32",
        },
        {
            name: "MetaDataVersion",
            fieldType: "ConfigurationVersionDataType",
        },
        {
            name: "MinorVersion",
            fieldType: "UInt32",
        },
        {
            name: "Timestamp",
            fieldType: "DateTime",
        },
        {
            name: "Status",
            fieldType: "StatusCode",
        },
        {
            name: "MessageType",
            fieldType: "String",
        },
        {
            name: "Payload",
            fieldType: "ExtensionObject",
        },
    ]
});
class JsonDataSetMessage extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaJsonDataSetMessage; }
    static possibleFields = [
        "dataSetWriterId",
        "dataSetWriterName",
        "publisherId",
        "writerGroupName",
        "sequenceNumber",
        "metaDataVersion",
        "minorVersion",
        "timestamp",
        "status",
        "messageType",
        "payload"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    dataSetWriterId;
    dataSetWriterName;
    publisherId;
    writerGroupName;
    sequenceNumber;
    metaDataVersion;
    minorVersion;
    timestamp;
    status;
    messageType;
    payload;
    constructor(options) {
        super(options);
        if (options === null) {
            this.dataSetWriterId = 0;
            this.dataSetWriterName = null;
            this.publisherId = null;
            this.writerGroupName = null;
            this.sequenceNumber = 0;
            this.metaDataVersion = new ConfigurationVersionDataType(null);
            this.minorVersion = 0;
            this.timestamp = new Date();
            this.status = node_opcua_status_code_1.StatusCodes.Good;
            this.messageType = null;
            this.payload = null;
            return;
        }
        const schema = JsonDataSetMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.dataSetWriterId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.dataSetWriterId);
        this.dataSetWriterName = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.dataSetWriterName);
        this.publisherId = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.publisherId);
        this.writerGroupName = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.writerGroupName);
        this.sequenceNumber = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.sequenceNumber);
        this.metaDataVersion = new ConfigurationVersionDataType(options.metaDataVersion);
        this.minorVersion = (0, node_opcua_factory_1.initialize_field)(schema.fields[6], options?.minorVersion);
        this.timestamp = (0, node_opcua_factory_1.initialize_field)(schema.fields[7], options?.timestamp);
        this.status = (0, node_opcua_factory_1.initialize_field)(schema.fields[8], options?.status);
        this.messageType = (0, node_opcua_factory_1.initialize_field)(schema.fields[9], options?.messageType);
        this.payload = (0, node_opcua_factory_1.initialize_field)(schema.fields[10], options?.payload);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt16)(this.dataSetWriterId, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.dataSetWriterName, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.publisherId, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.writerGroupName, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.sequenceNumber, stream);
        this.metaDataVersion.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.minorVersion, stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.timestamp, stream);
        (0, node_opcua_status_code_1.encodeStatusCode)(this.status, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.messageType, stream);
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.payload, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.dataSetWriterId = (0, node_opcua_basic_types_1.decodeUInt16)(stream, this.dataSetWriterId);
        this.dataSetWriterName = (0, node_opcua_basic_types_1.decodeString)(stream, this.dataSetWriterName);
        this.publisherId = (0, node_opcua_basic_types_1.decodeString)(stream, this.publisherId);
        this.writerGroupName = (0, node_opcua_basic_types_1.decodeString)(stream, this.writerGroupName);
        this.sequenceNumber = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.sequenceNumber);
        this.metaDataVersion.decode(stream);
        this.minorVersion = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.minorVersion);
        this.timestamp = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.timestamp);
        this.status = (0, node_opcua_status_code_1.decodeStatusCode)(stream, this.status);
        this.messageType = (0, node_opcua_basic_types_1.decodeString)(stream, this.messageType);
        this.payload = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.payload);
    }
    get schema() { return schemaJsonDataSetMessage; }
}
exports.JsonDataSetMessage = JsonDataSetMessage;
JsonDataSetMessage.schema.dataTypeNodeId = JsonDataSetMessage.dataTypeNodeId;
JsonDataSetMessage.schema.encodingDefaultBinary = JsonDataSetMessage.encodingDefaultBinary;
JsonDataSetMessage.schema.encodingDefaultXml = JsonDataSetMessage.encodingDefaultXml;
JsonDataSetMessage.schema.encodingDefaultJson = JsonDataSetMessage.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(JsonDataSetMessage.dataTypeNodeId, "JsonDataSetMessage", JsonDataSetMessage);
// --------------------------------------------------------------------------------------------
const schemaJsonDataSetMetaDataMessage = (0, node_opcua_factory_1.buildStructuredType)({
    name: "JsonDataSetMetaDataMessage",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "MessageId",
            fieldType: "String",
        },
        {
            name: "MessageType",
            fieldType: "String",
        },
        {
            name: "PublisherId",
            fieldType: "String",
        },
        {
            name: "DataSetWriterId",
            fieldType: "UInt16",
        },
        {
            name: "WriterGroupName",
            fieldType: "String",
        },
        {
            name: "DataSetWriterName",
            fieldType: "String",
        },
        {
            name: "Timestamp",
            fieldType: "DateTime",
        },
        {
            name: "MetaData",
            fieldType: "DataSetMetaDataType",
        },
    ]
});
class JsonDataSetMetaDataMessage extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaJsonDataSetMetaDataMessage; }
    static possibleFields = [
        "messageId",
        "messageType",
        "publisherId",
        "dataSetWriterId",
        "writerGroupName",
        "dataSetWriterName",
        "timestamp",
        "metaData"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    messageId;
    messageType;
    publisherId;
    dataSetWriterId;
    writerGroupName;
    dataSetWriterName;
    timestamp;
    metaData;
    constructor(options) {
        super(options);
        if (options === null) {
            this.messageId = null;
            this.messageType = null;
            this.publisherId = null;
            this.dataSetWriterId = 0;
            this.writerGroupName = null;
            this.dataSetWriterName = null;
            this.timestamp = new Date();
            this.metaData = new DataSetMetaDataType(null);
            return;
        }
        const schema = JsonDataSetMetaDataMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.messageId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.messageId);
        this.messageType = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.messageType);
        this.publisherId = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.publisherId);
        this.dataSetWriterId = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.dataSetWriterId);
        this.writerGroupName = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.writerGroupName);
        this.dataSetWriterName = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.dataSetWriterName);
        this.timestamp = (0, node_opcua_factory_1.initialize_field)(schema.fields[6], options?.timestamp);
        this.metaData = new DataSetMetaDataType(options.metaData);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.messageId, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.messageType, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.publisherId, stream);
        (0, node_opcua_basic_types_1.encodeUInt16)(this.dataSetWriterId, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.writerGroupName, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.dataSetWriterName, stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.timestamp, stream);
        this.metaData.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.messageId = (0, node_opcua_basic_types_1.decodeString)(stream, this.messageId);
        this.messageType = (0, node_opcua_basic_types_1.decodeString)(stream, this.messageType);
        this.publisherId = (0, node_opcua_basic_types_1.decodeString)(stream, this.publisherId);
        this.dataSetWriterId = (0, node_opcua_basic_types_1.decodeUInt16)(stream, this.dataSetWriterId);
        this.writerGroupName = (0, node_opcua_basic_types_1.decodeString)(stream, this.writerGroupName);
        this.dataSetWriterName = (0, node_opcua_basic_types_1.decodeString)(stream, this.dataSetWriterName);
        this.timestamp = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.timestamp);
        this.metaData.decode(stream);
    }
    get schema() { return schemaJsonDataSetMetaDataMessage; }
}
exports.JsonDataSetMetaDataMessage = JsonDataSetMetaDataMessage;
JsonDataSetMetaDataMessage.schema.dataTypeNodeId = JsonDataSetMetaDataMessage.dataTypeNodeId;
JsonDataSetMetaDataMessage.schema.encodingDefaultBinary = JsonDataSetMetaDataMessage.encodingDefaultBinary;
JsonDataSetMetaDataMessage.schema.encodingDefaultXml = JsonDataSetMetaDataMessage.encodingDefaultXml;
JsonDataSetMetaDataMessage.schema.encodingDefaultJson = JsonDataSetMetaDataMessage.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(JsonDataSetMetaDataMessage.dataTypeNodeId, "JsonDataSetMetaDataMessage", JsonDataSetMetaDataMessage);
// --------------------------------------------------------------------------------------------
var JsonNetworkMessageContentMask;
(function (JsonNetworkMessageContentMask) {
    JsonNetworkMessageContentMask[JsonNetworkMessageContentMask["None"] = 0] = "None";
    JsonNetworkMessageContentMask[JsonNetworkMessageContentMask["NetworkMessageHeader"] = 1] = "NetworkMessageHeader";
    JsonNetworkMessageContentMask[JsonNetworkMessageContentMask["DataSetMessageHeader"] = 2] = "DataSetMessageHeader";
    JsonNetworkMessageContentMask[JsonNetworkMessageContentMask["SingleDataSetMessage"] = 4] = "SingleDataSetMessage";
    JsonNetworkMessageContentMask[JsonNetworkMessageContentMask["PublisherId"] = 8] = "PublisherId";
    JsonNetworkMessageContentMask[JsonNetworkMessageContentMask["DataSetClassId"] = 16] = "DataSetClassId";
    JsonNetworkMessageContentMask[JsonNetworkMessageContentMask["ReplyTo"] = 32] = "ReplyTo";
    JsonNetworkMessageContentMask[JsonNetworkMessageContentMask["WriterGroupName"] = 64] = "WriterGroupName";
})(JsonNetworkMessageContentMask || (exports.JsonNetworkMessageContentMask = JsonNetworkMessageContentMask = {}));
const schemaJsonNetworkMessageContentMask = {
    enumValues: JsonNetworkMessageContentMask,
    flaggable: true,
    name: "JsonNetworkMessageContentMask"
};
function decodeJsonNetworkMessageContentMask(stream, _value) {
    return stream.readUInt32();
}
function encodeJsonNetworkMessageContentMask(value, stream) {
    stream.writeUInt32(value);
}
exports._enumerationJsonNetworkMessageContentMask = (0, node_opcua_factory_1.registerEnumeration)(schemaJsonNetworkMessageContentMask);
(0, node_opcua_assert_1.assert)(exports._enumerationJsonNetworkMessageContentMask.isFlaggable === true);
// --------------------------------------------------------------------------------------------
var JsonDataSetMessageContentMask;
(function (JsonDataSetMessageContentMask) {
    JsonDataSetMessageContentMask[JsonDataSetMessageContentMask["None"] = 0] = "None";
    JsonDataSetMessageContentMask[JsonDataSetMessageContentMask["DataSetWriterId"] = 1] = "DataSetWriterId";
    JsonDataSetMessageContentMask[JsonDataSetMessageContentMask["MetaDataVersion"] = 2] = "MetaDataVersion";
    JsonDataSetMessageContentMask[JsonDataSetMessageContentMask["SequenceNumber"] = 4] = "SequenceNumber";
    JsonDataSetMessageContentMask[JsonDataSetMessageContentMask["Timestamp"] = 8] = "Timestamp";
    JsonDataSetMessageContentMask[JsonDataSetMessageContentMask["Status"] = 16] = "Status";
    JsonDataSetMessageContentMask[JsonDataSetMessageContentMask["MessageType"] = 32] = "MessageType";
    JsonDataSetMessageContentMask[JsonDataSetMessageContentMask["DataSetWriterName"] = 64] = "DataSetWriterName";
    JsonDataSetMessageContentMask[JsonDataSetMessageContentMask["FieldEncoding1"] = 128] = "FieldEncoding1";
    JsonDataSetMessageContentMask[JsonDataSetMessageContentMask["PublisherId"] = 256] = "PublisherId";
    JsonDataSetMessageContentMask[JsonDataSetMessageContentMask["WriterGroupName"] = 512] = "WriterGroupName";
    JsonDataSetMessageContentMask[JsonDataSetMessageContentMask["MinorVersion"] = 1024] = "MinorVersion";
    JsonDataSetMessageContentMask[JsonDataSetMessageContentMask["FieldEncoding2"] = 2048] = "FieldEncoding2";
})(JsonDataSetMessageContentMask || (exports.JsonDataSetMessageContentMask = JsonDataSetMessageContentMask = {}));
const schemaJsonDataSetMessageContentMask = {
    enumValues: JsonDataSetMessageContentMask,
    flaggable: true,
    name: "JsonDataSetMessageContentMask"
};
function decodeJsonDataSetMessageContentMask(stream, _value) {
    return stream.readUInt32();
}
function encodeJsonDataSetMessageContentMask(value, stream) {
    stream.writeUInt32(value);
}
exports._enumerationJsonDataSetMessageContentMask = (0, node_opcua_factory_1.registerEnumeration)(schemaJsonDataSetMessageContentMask);
(0, node_opcua_assert_1.assert)(exports._enumerationJsonDataSetMessageContentMask.isFlaggable === true);
// --------------------------------------------------------------------------------------------
const schemaJsonDataSetReaderMessageDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "JsonDataSetReaderMessageDataType",
    baseType: "DataSetReaderMessageDataType",
    fields: [
        {
            name: "NetworkMessageContentMask",
            fieldType: "JsonNetworkMessageContentMask",
        },
        {
            name: "DataSetMessageContentMask",
            fieldType: "JsonDataSetMessageContentMask",
        },
    ]
});
class JsonDataSetReaderMessageDataType extends DataSetReaderMessageDataType {
    static get schema() { return schemaJsonDataSetReaderMessageDataType; }
    static possibleFields = [
        "networkMessageContentMask",
        "dataSetMessageContentMask"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15665, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15725, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16019, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16404, 0);
    networkMessageContentMask;
    dataSetMessageContentMask;
    constructor(options) {
        super(options);
        if (options === null) {
            this.networkMessageContentMask = 0;
            this.dataSetMessageContentMask = 0;
            return;
        }
        const schema = JsonDataSetReaderMessageDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.networkMessageContentMask = this.setNetworkMessageContentMask((0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.networkMessageContentMask));
        this.dataSetMessageContentMask = this.setDataSetMessageContentMask((0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.dataSetMessageContentMask));
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        encodeJsonNetworkMessageContentMask(this.networkMessageContentMask, stream);
        encodeJsonDataSetMessageContentMask(this.dataSetMessageContentMask, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.networkMessageContentMask = decodeJsonNetworkMessageContentMask(stream, this.networkMessageContentMask);
        this.dataSetMessageContentMask = decodeJsonDataSetMessageContentMask(stream, this.dataSetMessageContentMask);
    }
    // Define Enumeration setters
    setNetworkMessageContentMask(value) {
        const coercedValue = exports._enumerationJsonNetworkMessageContentMask.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to JsonNetworkMessageContentMask :" + value);
        }
        this.networkMessageContentMask = coercedValue.value;
        return this.networkMessageContentMask;
    }
    setDataSetMessageContentMask(value) {
        const coercedValue = exports._enumerationJsonDataSetMessageContentMask.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to JsonDataSetMessageContentMask :" + value);
        }
        this.dataSetMessageContentMask = coercedValue.value;
        return this.dataSetMessageContentMask;
    }
    get schema() { return schemaJsonDataSetReaderMessageDataType; }
}
exports.JsonDataSetReaderMessageDataType = JsonDataSetReaderMessageDataType;
JsonDataSetReaderMessageDataType.schema.dataTypeNodeId = JsonDataSetReaderMessageDataType.dataTypeNodeId;
JsonDataSetReaderMessageDataType.schema.encodingDefaultBinary = JsonDataSetReaderMessageDataType.encodingDefaultBinary;
JsonDataSetReaderMessageDataType.schema.encodingDefaultXml = JsonDataSetReaderMessageDataType.encodingDefaultXml;
JsonDataSetReaderMessageDataType.schema.encodingDefaultJson = JsonDataSetReaderMessageDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(JsonDataSetReaderMessageDataType.dataTypeNodeId, "JsonDataSetReaderMessageDataType", JsonDataSetReaderMessageDataType);
// --------------------------------------------------------------------------------------------
const schemaJsonDataSetWriterMessageDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "JsonDataSetWriterMessageDataType",
    baseType: "DataSetWriterMessageDataType",
    fields: [
        {
            name: "DataSetMessageContentMask",
            fieldType: "JsonDataSetMessageContentMask",
        },
    ]
});
class JsonDataSetWriterMessageDataType extends DataSetWriterMessageDataType {
    static get schema() { return schemaJsonDataSetWriterMessageDataType; }
    static possibleFields = [
        "dataSetMessageContentMask"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15664, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15724, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16018, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16394, 0);
    dataSetMessageContentMask;
    constructor(options) {
        super(options);
        if (options === null) {
            this.dataSetMessageContentMask = 0;
            return;
        }
        const schema = JsonDataSetWriterMessageDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.dataSetMessageContentMask = this.setDataSetMessageContentMask((0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.dataSetMessageContentMask));
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        encodeJsonDataSetMessageContentMask(this.dataSetMessageContentMask, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.dataSetMessageContentMask = decodeJsonDataSetMessageContentMask(stream, this.dataSetMessageContentMask);
    }
    // Define Enumeration setters
    setDataSetMessageContentMask(value) {
        const coercedValue = exports._enumerationJsonDataSetMessageContentMask.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to JsonDataSetMessageContentMask :" + value);
        }
        this.dataSetMessageContentMask = coercedValue.value;
        return this.dataSetMessageContentMask;
    }
    get schema() { return schemaJsonDataSetWriterMessageDataType; }
}
exports.JsonDataSetWriterMessageDataType = JsonDataSetWriterMessageDataType;
JsonDataSetWriterMessageDataType.schema.dataTypeNodeId = JsonDataSetWriterMessageDataType.dataTypeNodeId;
JsonDataSetWriterMessageDataType.schema.encodingDefaultBinary = JsonDataSetWriterMessageDataType.encodingDefaultBinary;
JsonDataSetWriterMessageDataType.schema.encodingDefaultXml = JsonDataSetWriterMessageDataType.encodingDefaultXml;
JsonDataSetWriterMessageDataType.schema.encodingDefaultJson = JsonDataSetWriterMessageDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(JsonDataSetWriterMessageDataType.dataTypeNodeId, "JsonDataSetWriterMessageDataType", JsonDataSetWriterMessageDataType);
// --------------------------------------------------------------------------------------------
const schemaJsonNetworkMessage = (0, node_opcua_factory_1.buildStructuredType)({
    name: "JsonNetworkMessage",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "MessageId",
            fieldType: "String",
        },
        {
            name: "MessageType",
            fieldType: "String",
        },
        {
            name: "PublisherId",
            fieldType: "String",
        },
        {
            name: "WriterGroupName",
            fieldType: "String",
        },
        {
            name: "DataSetClassId",
            fieldType: "String",
        },
        {
            name: "Messages",
            fieldType: "ExtensionObject",
            isArray: true
        },
    ]
});
class JsonNetworkMessage extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaJsonNetworkMessage; }
    static possibleFields = [
        "messageId",
        "messageType",
        "publisherId",
        "writerGroupName",
        "dataSetClassId",
        "messages"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    messageId;
    messageType;
    publisherId;
    writerGroupName;
    dataSetClassId;
    messages;
    constructor(options) {
        super(options);
        if (options === null) {
            this.messageId = null;
            this.messageType = null;
            this.publisherId = null;
            this.writerGroupName = null;
            this.dataSetClassId = null;
            this.messages = [];
            return;
        }
        const schema = JsonNetworkMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.messageId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.messageId);
        this.messageType = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.messageType);
        this.publisherId = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.publisherId);
        this.writerGroupName = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.writerGroupName);
        this.dataSetClassId = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.dataSetClassId);
        this.messages = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[5], options?.messages);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.messageId, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.messageType, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.publisherId, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.writerGroupName, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.dataSetClassId, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.messages, stream, node_opcua_extension_object_1.encodeExtensionObject);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.messageId = (0, node_opcua_basic_types_1.decodeString)(stream, this.messageId);
        this.messageType = (0, node_opcua_basic_types_1.decodeString)(stream, this.messageType);
        this.publisherId = (0, node_opcua_basic_types_1.decodeString)(stream, this.publisherId);
        this.writerGroupName = (0, node_opcua_basic_types_1.decodeString)(stream, this.writerGroupName);
        this.dataSetClassId = (0, node_opcua_basic_types_1.decodeString)(stream, this.dataSetClassId);
        this.messages = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_extension_object_1.decodeExtensionObject);
    }
    get schema() { return schemaJsonNetworkMessage; }
}
exports.JsonNetworkMessage = JsonNetworkMessage;
JsonNetworkMessage.schema.dataTypeNodeId = JsonNetworkMessage.dataTypeNodeId;
JsonNetworkMessage.schema.encodingDefaultBinary = JsonNetworkMessage.encodingDefaultBinary;
JsonNetworkMessage.schema.encodingDefaultXml = JsonNetworkMessage.encodingDefaultXml;
JsonNetworkMessage.schema.encodingDefaultJson = JsonNetworkMessage.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(JsonNetworkMessage.dataTypeNodeId, "JsonNetworkMessage", JsonNetworkMessage);
// --------------------------------------------------------------------------------------------
const schemaJsonPubSubConnectionMessage = (0, node_opcua_factory_1.buildStructuredType)({
    name: "JsonPubSubConnectionMessage",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "MessageId",
            fieldType: "String",
        },
        {
            name: "MessageType",
            fieldType: "String",
        },
        {
            name: "PublisherId",
            fieldType: "String",
        },
        {
            name: "Timestamp",
            fieldType: "DateTime",
        },
        {
            name: "Connection",
            fieldType: "PubSubConnectionDataType",
        },
    ]
});
class JsonPubSubConnectionMessage extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaJsonPubSubConnectionMessage; }
    static possibleFields = [
        "messageId",
        "messageType",
        "publisherId",
        "timestamp",
        "connection"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    messageId;
    messageType;
    publisherId;
    timestamp;
    connection;
    constructor(options) {
        super(options);
        if (options === null) {
            this.messageId = null;
            this.messageType = null;
            this.publisherId = null;
            this.timestamp = new Date();
            this.connection = new PubSubConnectionDataType(null);
            return;
        }
        const schema = JsonPubSubConnectionMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.messageId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.messageId);
        this.messageType = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.messageType);
        this.publisherId = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.publisherId);
        this.timestamp = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.timestamp);
        this.connection = new PubSubConnectionDataType(options.connection);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.messageId, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.messageType, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.publisherId, stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.timestamp, stream);
        this.connection.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.messageId = (0, node_opcua_basic_types_1.decodeString)(stream, this.messageId);
        this.messageType = (0, node_opcua_basic_types_1.decodeString)(stream, this.messageType);
        this.publisherId = (0, node_opcua_basic_types_1.decodeString)(stream, this.publisherId);
        this.timestamp = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.timestamp);
        this.connection.decode(stream);
    }
    get schema() { return schemaJsonPubSubConnectionMessage; }
}
exports.JsonPubSubConnectionMessage = JsonPubSubConnectionMessage;
JsonPubSubConnectionMessage.schema.dataTypeNodeId = JsonPubSubConnectionMessage.dataTypeNodeId;
JsonPubSubConnectionMessage.schema.encodingDefaultBinary = JsonPubSubConnectionMessage.encodingDefaultBinary;
JsonPubSubConnectionMessage.schema.encodingDefaultXml = JsonPubSubConnectionMessage.encodingDefaultXml;
JsonPubSubConnectionMessage.schema.encodingDefaultJson = JsonPubSubConnectionMessage.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(JsonPubSubConnectionMessage.dataTypeNodeId, "JsonPubSubConnectionMessage", JsonPubSubConnectionMessage);
// --------------------------------------------------------------------------------------------
const schemaJsonServerEndpointsMessage = (0, node_opcua_factory_1.buildStructuredType)({
    name: "JsonServerEndpointsMessage",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "MessageId",
            fieldType: "String",
        },
        {
            name: "MessageType",
            fieldType: "String",
        },
        {
            name: "PublisherId",
            fieldType: "String",
        },
        {
            name: "Timestamp",
            fieldType: "DateTime",
        },
        {
            name: "Description",
            fieldType: "ApplicationDescription",
        },
        {
            name: "Endpoints",
            fieldType: "EndpointDescription",
            isArray: true
        },
    ]
});
class JsonServerEndpointsMessage extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaJsonServerEndpointsMessage; }
    static possibleFields = [
        "messageId",
        "messageType",
        "publisherId",
        "timestamp",
        "description",
        "endpoints"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    messageId;
    messageType;
    publisherId;
    timestamp;
    description;
    endpoints;
    constructor(options) {
        super(options);
        if (options === null) {
            this.messageId = null;
            this.messageType = null;
            this.publisherId = null;
            this.timestamp = new Date();
            this.description = new ApplicationDescription(null);
            this.endpoints = null; /* null array */
            return;
        }
        const schema = JsonServerEndpointsMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.messageId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.messageId);
        this.messageType = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.messageType);
        this.publisherId = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.publisherId);
        this.timestamp = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.timestamp);
        this.description = new ApplicationDescription(options.description);
        this.endpoints = []; // should default
        if (options.endpoints) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.endpoints));
            this.endpoints = options.endpoints.map((e) => new EndpointDescription(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.messageId, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.messageType, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.publisherId, stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.timestamp, stream);
        this.description.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.endpoints, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.messageId = (0, node_opcua_basic_types_1.decodeString)(stream, this.messageId);
        this.messageType = (0, node_opcua_basic_types_1.decodeString)(stream, this.messageType);
        this.publisherId = (0, node_opcua_basic_types_1.decodeString)(stream, this.publisherId);
        this.timestamp = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.timestamp);
        this.description.decode(stream);
        this.endpoints = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new EndpointDescription(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaJsonServerEndpointsMessage; }
}
exports.JsonServerEndpointsMessage = JsonServerEndpointsMessage;
JsonServerEndpointsMessage.schema.dataTypeNodeId = JsonServerEndpointsMessage.dataTypeNodeId;
JsonServerEndpointsMessage.schema.encodingDefaultBinary = JsonServerEndpointsMessage.encodingDefaultBinary;
JsonServerEndpointsMessage.schema.encodingDefaultXml = JsonServerEndpointsMessage.encodingDefaultXml;
JsonServerEndpointsMessage.schema.encodingDefaultJson = JsonServerEndpointsMessage.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(JsonServerEndpointsMessage.dataTypeNodeId, "JsonServerEndpointsMessage", JsonServerEndpointsMessage);
// --------------------------------------------------------------------------------------------
var PubSubState;
(function (PubSubState) {
    PubSubState[PubSubState["Disabled"] = 0] = "Disabled";
    PubSubState[PubSubState["Paused"] = 1] = "Paused";
    PubSubState[PubSubState["Operational"] = 2] = "Operational";
    PubSubState[PubSubState["Error"] = 3] = "Error";
    PubSubState[PubSubState["PreOperational"] = 4] = "PreOperational";
    PubSubState[PubSubState["Invalid"] = 4294967295] = "Invalid";
})(PubSubState || (exports.PubSubState = PubSubState = {}));
const schemaPubSubState = {
    enumValues: PubSubState,
    flaggable: false,
    minValue: 0,
    maxValue: 4,
    name: "PubSubState"
};
function decodePubSubState(stream, _value) {
    let value = stream.readUInt32();
    value = (value < schemaPubSubState.minValue || value > schemaPubSubState.maxValue) ? PubSubState.Invalid : value;
    return value;
}
function encodePubSubState(value, stream) {
    stream.writeUInt32(value);
}
exports._enumerationPubSubState = (0, node_opcua_factory_1.registerEnumeration)(schemaPubSubState);
(0, node_opcua_assert_1.assert)(exports._enumerationPubSubState.isFlaggable === false);
// --------------------------------------------------------------------------------------------
const schemaJsonStatusMessage = (0, node_opcua_factory_1.buildStructuredType)({
    name: "JsonStatusMessage",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "MessageId",
            fieldType: "String",
        },
        {
            name: "MessageType",
            fieldType: "String",
        },
        {
            name: "PublisherId",
            fieldType: "String",
        },
        {
            name: "Timestamp",
            fieldType: "DateTime",
        },
        {
            name: "IsCyclic",
            fieldType: "Boolean",
        },
        {
            name: "Status",
            fieldType: "PubSubState",
        },
        {
            name: "NextReportTime",
            fieldType: "DateTime",
        },
    ]
});
class JsonStatusMessage extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaJsonStatusMessage; }
    static possibleFields = [
        "messageId",
        "messageType",
        "publisherId",
        "timestamp",
        "isCyclic",
        "status",
        "nextReportTime"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    messageId;
    messageType;
    publisherId;
    timestamp;
    isCyclic;
    status;
    nextReportTime;
    constructor(options) {
        super(options);
        if (options === null) {
            this.messageId = null;
            this.messageType = null;
            this.publisherId = null;
            this.timestamp = new Date();
            this.isCyclic = false;
            this.status = 0;
            this.nextReportTime = new Date();
            return;
        }
        const schema = JsonStatusMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.messageId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.messageId);
        this.messageType = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.messageType);
        this.publisherId = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.publisherId);
        this.timestamp = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.timestamp);
        this.isCyclic = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.isCyclic);
        this.status = this.setStatus((0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.status));
        this.nextReportTime = (0, node_opcua_factory_1.initialize_field)(schema.fields[6], options?.nextReportTime);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.messageId, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.messageType, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.publisherId, stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.timestamp, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.isCyclic, stream);
        encodePubSubState(this.status, stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.nextReportTime, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.messageId = (0, node_opcua_basic_types_1.decodeString)(stream, this.messageId);
        this.messageType = (0, node_opcua_basic_types_1.decodeString)(stream, this.messageType);
        this.publisherId = (0, node_opcua_basic_types_1.decodeString)(stream, this.publisherId);
        this.timestamp = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.timestamp);
        this.isCyclic = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.isCyclic);
        this.status = decodePubSubState(stream, this.status);
        this.nextReportTime = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.nextReportTime);
    }
    // Define Enumeration setters
    setStatus(value) {
        const coercedValue = exports._enumerationPubSubState.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to PubSubState :" + value);
        }
        this.status = coercedValue.value;
        return this.status;
    }
    get schema() { return schemaJsonStatusMessage; }
}
exports.JsonStatusMessage = JsonStatusMessage;
JsonStatusMessage.schema.dataTypeNodeId = JsonStatusMessage.dataTypeNodeId;
JsonStatusMessage.schema.encodingDefaultBinary = JsonStatusMessage.encodingDefaultBinary;
JsonStatusMessage.schema.encodingDefaultXml = JsonStatusMessage.encodingDefaultXml;
JsonStatusMessage.schema.encodingDefaultJson = JsonStatusMessage.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(JsonStatusMessage.dataTypeNodeId, "JsonStatusMessage", JsonStatusMessage);
// --------------------------------------------------------------------------------------------
const schemaWriterGroupMessageDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "WriterGroupMessageDataType",
    baseType: "ExtensionObject",
    fields: []
});
class WriterGroupMessageDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaWriterGroupMessageDataType; }
    static possibleFields = [];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15616, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15693, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15991, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16280, 0);
    constructor(options) {
        super(options);
        if (options === null) {
            return;
        }
        const schema = WriterGroupMessageDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    get schema() { return schemaWriterGroupMessageDataType; }
}
exports.WriterGroupMessageDataType = WriterGroupMessageDataType;
WriterGroupMessageDataType.schema.dataTypeNodeId = WriterGroupMessageDataType.dataTypeNodeId;
WriterGroupMessageDataType.schema.encodingDefaultBinary = WriterGroupMessageDataType.encodingDefaultBinary;
WriterGroupMessageDataType.schema.encodingDefaultXml = WriterGroupMessageDataType.encodingDefaultXml;
WriterGroupMessageDataType.schema.encodingDefaultJson = WriterGroupMessageDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(WriterGroupMessageDataType.dataTypeNodeId, "WriterGroupMessageDataType", WriterGroupMessageDataType);
// --------------------------------------------------------------------------------------------
const schemaJsonWriterGroupMessageDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "JsonWriterGroupMessageDataType",
    baseType: "WriterGroupMessageDataType",
    fields: [
        {
            name: "NetworkMessageContentMask",
            fieldType: "JsonNetworkMessageContentMask",
        },
    ]
});
class JsonWriterGroupMessageDataType extends WriterGroupMessageDataType {
    static get schema() { return schemaJsonWriterGroupMessageDataType; }
    static possibleFields = [
        "networkMessageContentMask"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15657, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15719, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16017, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16393, 0);
    networkMessageContentMask;
    constructor(options) {
        super(options);
        if (options === null) {
            this.networkMessageContentMask = 0;
            return;
        }
        const schema = JsonWriterGroupMessageDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.networkMessageContentMask = this.setNetworkMessageContentMask((0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.networkMessageContentMask));
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        encodeJsonNetworkMessageContentMask(this.networkMessageContentMask, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.networkMessageContentMask = decodeJsonNetworkMessageContentMask(stream, this.networkMessageContentMask);
    }
    // Define Enumeration setters
    setNetworkMessageContentMask(value) {
        const coercedValue = exports._enumerationJsonNetworkMessageContentMask.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to JsonNetworkMessageContentMask :" + value);
        }
        this.networkMessageContentMask = coercedValue.value;
        return this.networkMessageContentMask;
    }
    get schema() { return schemaJsonWriterGroupMessageDataType; }
}
exports.JsonWriterGroupMessageDataType = JsonWriterGroupMessageDataType;
JsonWriterGroupMessageDataType.schema.dataTypeNodeId = JsonWriterGroupMessageDataType.dataTypeNodeId;
JsonWriterGroupMessageDataType.schema.encodingDefaultBinary = JsonWriterGroupMessageDataType.encodingDefaultBinary;
JsonWriterGroupMessageDataType.schema.encodingDefaultXml = JsonWriterGroupMessageDataType.encodingDefaultXml;
JsonWriterGroupMessageDataType.schema.encodingDefaultJson = JsonWriterGroupMessageDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(JsonWriterGroupMessageDataType.dataTypeNodeId, "JsonWriterGroupMessageDataType", JsonWriterGroupMessageDataType);
// --------------------------------------------------------------------------------------------
const schemaLinearConversionDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "LinearConversionDataType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "InitialAddend",
            fieldType: "Float",
        },
        {
            name: "Multiplicand",
            fieldType: "Float",
        },
        {
            name: "Divisor",
            fieldType: "Float",
        },
        {
            name: "FinalAddend",
            fieldType: "Float",
        },
    ]
});
class LinearConversionDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaLinearConversionDataType; }
    static possibleFields = [
        "initialAddend",
        "multiplicand",
        "divisor",
        "finalAddend"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(32435, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(32561, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(32573, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(32585, 0);
    initialAddend;
    multiplicand;
    divisor;
    finalAddend;
    constructor(options) {
        super(options);
        if (options === null) {
            this.initialAddend = 0;
            this.multiplicand = 0;
            this.divisor = 0;
            this.finalAddend = 0;
            return;
        }
        const schema = LinearConversionDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.initialAddend = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.initialAddend);
        this.multiplicand = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.multiplicand);
        this.divisor = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.divisor);
        this.finalAddend = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.finalAddend);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeFloat)(this.initialAddend, stream);
        (0, node_opcua_basic_types_1.encodeFloat)(this.multiplicand, stream);
        (0, node_opcua_basic_types_1.encodeFloat)(this.divisor, stream);
        (0, node_opcua_basic_types_1.encodeFloat)(this.finalAddend, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.initialAddend = (0, node_opcua_basic_types_1.decodeFloat)(stream, this.initialAddend);
        this.multiplicand = (0, node_opcua_basic_types_1.decodeFloat)(stream, this.multiplicand);
        this.divisor = (0, node_opcua_basic_types_1.decodeFloat)(stream, this.divisor);
        this.finalAddend = (0, node_opcua_basic_types_1.decodeFloat)(stream, this.finalAddend);
    }
    get schema() { return schemaLinearConversionDataType; }
}
exports.LinearConversionDataType = LinearConversionDataType;
LinearConversionDataType.schema.dataTypeNodeId = LinearConversionDataType.dataTypeNodeId;
LinearConversionDataType.schema.encodingDefaultBinary = LinearConversionDataType.encodingDefaultBinary;
LinearConversionDataType.schema.encodingDefaultXml = LinearConversionDataType.encodingDefaultXml;
LinearConversionDataType.schema.encodingDefaultJson = LinearConversionDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(LinearConversionDataType.dataTypeNodeId, "LinearConversionDataType", LinearConversionDataType);
// --------------------------------------------------------------------------------------------
const schemaLiteralOperand = (0, node_opcua_factory_1.buildStructuredType)({
    name: "LiteralOperand",
    baseType: "FilterOperand",
    fields: [
        {
            name: "Value",
            fieldType: "Variant",
        },
    ]
});
class LiteralOperand extends FilterOperand {
    static get schema() { return schemaLiteralOperand; }
    static possibleFields = [
        "value"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(595, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(597, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(596, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15208, 0);
    value;
    constructor(options) {
        super(options);
        if (options === null) {
            this.value = new node_opcua_variant_1.Variant(null);
            return;
        }
        const schema = LiteralOperand.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.value = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.value);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_variant_1.encodeVariant)(this.value, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.value = (0, node_opcua_variant_1.decodeVariant)(stream, this.value);
    }
    get schema() { return schemaLiteralOperand; }
}
exports.LiteralOperand = LiteralOperand;
LiteralOperand.schema.dataTypeNodeId = LiteralOperand.dataTypeNodeId;
LiteralOperand.schema.encodingDefaultBinary = LiteralOperand.encodingDefaultBinary;
LiteralOperand.schema.encodingDefaultXml = LiteralOperand.encodingDefaultXml;
LiteralOperand.schema.encodingDefaultJson = LiteralOperand.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(LiteralOperand.dataTypeNodeId, "LiteralOperand", LiteralOperand);
// --------------------------------------------------------------------------------------------
var ManAddrIfSubtype;
(function (ManAddrIfSubtype) {
    ManAddrIfSubtype[ManAddrIfSubtype["None"] = 0] = "None";
    ManAddrIfSubtype[ManAddrIfSubtype["Unknown"] = 1] = "Unknown";
    ManAddrIfSubtype[ManAddrIfSubtype["PortRef"] = 2] = "PortRef";
    ManAddrIfSubtype[ManAddrIfSubtype["SystemPortNumber"] = 3] = "SystemPortNumber";
    ManAddrIfSubtype[ManAddrIfSubtype["Invalid"] = 4294967295] = "Invalid";
})(ManAddrIfSubtype || (exports.ManAddrIfSubtype = ManAddrIfSubtype = {}));
const schemaManAddrIfSubtype = {
    enumValues: ManAddrIfSubtype,
    flaggable: false,
    minValue: 0,
    maxValue: 3,
    name: "ManAddrIfSubtype"
};
function decodeManAddrIfSubtype(stream, _value) {
    let value = stream.readUInt32();
    value = (value < schemaManAddrIfSubtype.minValue || value > schemaManAddrIfSubtype.maxValue) ? ManAddrIfSubtype.Invalid : value;
    return value;
}
function encodeManAddrIfSubtype(value, stream) {
    stream.writeUInt32(value);
}
exports._enumerationManAddrIfSubtype = (0, node_opcua_factory_1.registerEnumeration)(schemaManAddrIfSubtype);
(0, node_opcua_assert_1.assert)(exports._enumerationManAddrIfSubtype.isFlaggable === false);
// --------------------------------------------------------------------------------------------
const schemaLldpManagementAddressTxPortType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "LldpManagementAddressTxPortType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "AddressSubtype",
            fieldType: "UInt32",
        },
        {
            name: "ManAddress",
            fieldType: "String",
        },
        {
            name: "TxEnable",
            fieldType: "Boolean",
        },
        {
            name: "AddrLen",
            fieldType: "UInt32",
        },
        {
            name: "IfSubtype",
            fieldType: "ManAddrIfSubtype",
        },
        {
            name: "IfId",
            fieldType: "UInt32",
        },
    ]
});
class LldpManagementAddressTxPortType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaLldpManagementAddressTxPortType; }
    static possibleFields = [
        "addressSubtype",
        "manAddress",
        "txEnable",
        "addrLen",
        "ifSubtype",
        "ifId"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    addressSubtype;
    manAddress;
    txEnable;
    addrLen;
    ifSubtype;
    ifId;
    constructor(options) {
        super(options);
        if (options === null) {
            this.addressSubtype = 0;
            this.manAddress = null;
            this.txEnable = false;
            this.addrLen = 0;
            this.ifSubtype = 0;
            this.ifId = 0;
            return;
        }
        const schema = LldpManagementAddressTxPortType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.addressSubtype = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.addressSubtype);
        this.manAddress = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.manAddress);
        this.txEnable = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.txEnable);
        this.addrLen = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.addrLen);
        this.ifSubtype = this.setIfSubtype((0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.ifSubtype));
        this.ifId = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.ifId);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.addressSubtype, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.manAddress, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.txEnable, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.addrLen, stream);
        encodeManAddrIfSubtype(this.ifSubtype, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.ifId, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.addressSubtype = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.addressSubtype);
        this.manAddress = (0, node_opcua_basic_types_1.decodeString)(stream, this.manAddress);
        this.txEnable = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.txEnable);
        this.addrLen = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.addrLen);
        this.ifSubtype = decodeManAddrIfSubtype(stream, this.ifSubtype);
        this.ifId = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.ifId);
    }
    // Define Enumeration setters
    setIfSubtype(value) {
        const coercedValue = exports._enumerationManAddrIfSubtype.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to ManAddrIfSubtype :" + value);
        }
        this.ifSubtype = coercedValue.value;
        return this.ifSubtype;
    }
    get schema() { return schemaLldpManagementAddressTxPortType; }
}
exports.LldpManagementAddressTxPortType = LldpManagementAddressTxPortType;
LldpManagementAddressTxPortType.schema.dataTypeNodeId = LldpManagementAddressTxPortType.dataTypeNodeId;
LldpManagementAddressTxPortType.schema.encodingDefaultBinary = LldpManagementAddressTxPortType.encodingDefaultBinary;
LldpManagementAddressTxPortType.schema.encodingDefaultXml = LldpManagementAddressTxPortType.encodingDefaultXml;
LldpManagementAddressTxPortType.schema.encodingDefaultJson = LldpManagementAddressTxPortType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(LldpManagementAddressTxPortType.dataTypeNodeId, "LldpManagementAddressTxPortType", LldpManagementAddressTxPortType);
// --------------------------------------------------------------------------------------------
const schemaLldpManagementAddressType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "LldpManagementAddressType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "AddressSubtype",
            fieldType: "UInt32",
        },
        {
            name: "Address",
            fieldType: "String",
        },
        {
            name: "IfSubtype",
            fieldType: "ManAddrIfSubtype",
        },
        {
            name: "IfId",
            fieldType: "UInt32",
        },
    ]
});
class LldpManagementAddressType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaLldpManagementAddressType; }
    static possibleFields = [
        "addressSubtype",
        "address",
        "ifSubtype",
        "ifId"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    addressSubtype;
    address;
    ifSubtype;
    ifId;
    constructor(options) {
        super(options);
        if (options === null) {
            this.addressSubtype = 0;
            this.address = null;
            this.ifSubtype = 0;
            this.ifId = 0;
            return;
        }
        const schema = LldpManagementAddressType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.addressSubtype = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.addressSubtype);
        this.address = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.address);
        this.ifSubtype = this.setIfSubtype((0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.ifSubtype));
        this.ifId = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.ifId);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.addressSubtype, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.address, stream);
        encodeManAddrIfSubtype(this.ifSubtype, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.ifId, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.addressSubtype = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.addressSubtype);
        this.address = (0, node_opcua_basic_types_1.decodeString)(stream, this.address);
        this.ifSubtype = decodeManAddrIfSubtype(stream, this.ifSubtype);
        this.ifId = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.ifId);
    }
    // Define Enumeration setters
    setIfSubtype(value) {
        const coercedValue = exports._enumerationManAddrIfSubtype.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to ManAddrIfSubtype :" + value);
        }
        this.ifSubtype = coercedValue.value;
        return this.ifSubtype;
    }
    get schema() { return schemaLldpManagementAddressType; }
}
exports.LldpManagementAddressType = LldpManagementAddressType;
LldpManagementAddressType.schema.dataTypeNodeId = LldpManagementAddressType.dataTypeNodeId;
LldpManagementAddressType.schema.encodingDefaultBinary = LldpManagementAddressType.encodingDefaultBinary;
LldpManagementAddressType.schema.encodingDefaultXml = LldpManagementAddressType.encodingDefaultXml;
LldpManagementAddressType.schema.encodingDefaultJson = LldpManagementAddressType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(LldpManagementAddressType.dataTypeNodeId, "LldpManagementAddressType", LldpManagementAddressType);
// --------------------------------------------------------------------------------------------
const schemaLldpTlvType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "LldpTlvType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "TlvType",
            fieldType: "UInt32",
        },
        {
            name: "TlvInfo",
            fieldType: "ByteString",
        },
    ]
});
class LldpTlvType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaLldpTlvType; }
    static possibleFields = [
        "tlvType",
        "tlvInfo"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    tlvType;
    tlvInfo;
    constructor(options) {
        super(options);
        if (options === null) {
            this.tlvType = 0;
            this.tlvInfo = Buffer.alloc(0);
            return;
        }
        const schema = LldpTlvType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.tlvType = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.tlvType);
        this.tlvInfo = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.tlvInfo);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.tlvType, stream);
        (0, node_opcua_basic_types_1.encodeByteString)(this.tlvInfo, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.tlvType = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.tlvType);
        this.tlvInfo = (0, node_opcua_basic_types_1.decodeByteString)(stream, this.tlvInfo);
    }
    get schema() { return schemaLldpTlvType; }
}
exports.LldpTlvType = LldpTlvType;
LldpTlvType.schema.dataTypeNodeId = LldpTlvType.dataTypeNodeId;
LldpTlvType.schema.encodingDefaultBinary = LldpTlvType.encodingDefaultBinary;
LldpTlvType.schema.encodingDefaultXml = LldpTlvType.encodingDefaultXml;
LldpTlvType.schema.encodingDefaultJson = LldpTlvType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(LldpTlvType.dataTypeNodeId, "LldpTlvType", LldpTlvType);
// --------------------------------------------------------------------------------------------
const schemaMdnsDiscoveryConfiguration = (0, node_opcua_factory_1.buildStructuredType)({
    name: "MdnsDiscoveryConfiguration",
    baseType: "DiscoveryConfiguration",
    fields: [
        {
            name: "MdnsServerName",
            fieldType: "String",
        },
        {
            name: "ServerCapabilities",
            fieldType: "String",
            isArray: true
        },
    ]
});
class MdnsDiscoveryConfiguration extends DiscoveryConfiguration {
    static get schema() { return schemaMdnsDiscoveryConfiguration; }
    static possibleFields = [
        "mdnsServerName",
        "serverCapabilities"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12891, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12901, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12893, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15106, 0);
    mdnsServerName;
    serverCapabilities;
    constructor(options) {
        super(options);
        if (options === null) {
            this.mdnsServerName = null;
            this.serverCapabilities = [];
            return;
        }
        const schema = MdnsDiscoveryConfiguration.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.mdnsServerName = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.mdnsServerName);
        this.serverCapabilities = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.serverCapabilities);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.mdnsServerName, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.serverCapabilities, stream, node_opcua_basic_types_1.encodeString);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.mdnsServerName = (0, node_opcua_basic_types_1.decodeString)(stream, this.mdnsServerName);
        this.serverCapabilities = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeString);
    }
    get schema() { return schemaMdnsDiscoveryConfiguration; }
}
exports.MdnsDiscoveryConfiguration = MdnsDiscoveryConfiguration;
MdnsDiscoveryConfiguration.schema.dataTypeNodeId = MdnsDiscoveryConfiguration.dataTypeNodeId;
MdnsDiscoveryConfiguration.schema.encodingDefaultBinary = MdnsDiscoveryConfiguration.encodingDefaultBinary;
MdnsDiscoveryConfiguration.schema.encodingDefaultXml = MdnsDiscoveryConfiguration.encodingDefaultXml;
MdnsDiscoveryConfiguration.schema.encodingDefaultJson = MdnsDiscoveryConfiguration.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(MdnsDiscoveryConfiguration.dataTypeNodeId, "MdnsDiscoveryConfiguration", MdnsDiscoveryConfiguration);
// --------------------------------------------------------------------------------------------
const schemaMethodAttributes = (0, node_opcua_factory_1.buildStructuredType)({
    name: "MethodAttributes",
    baseType: "NodeAttributes",
    fields: [
        {
            name: "Executable",
            fieldType: "Boolean",
        },
        {
            name: "UserExecutable",
            fieldType: "Boolean",
        },
    ]
});
class MethodAttributes extends NodeAttributes {
    static get schema() { return schemaMethodAttributes; }
    static possibleFields = [
        "specifiedAttributes",
        "displayName",
        "description",
        "writeMask",
        "userWriteMask",
        "executable",
        "userExecutable"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(358, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(360, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(359, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15157, 0);
    executable;
    userExecutable;
    constructor(options) {
        super(options);
        if (options === null) {
            this.executable = false;
            this.userExecutable = false;
            return;
        }
        const schema = MethodAttributes.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.executable = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.executable);
        this.userExecutable = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.userExecutable);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.executable, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.userExecutable, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.executable = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.executable);
        this.userExecutable = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.userExecutable);
    }
    get schema() { return schemaMethodAttributes; }
}
exports.MethodAttributes = MethodAttributes;
MethodAttributes.schema.dataTypeNodeId = MethodAttributes.dataTypeNodeId;
MethodAttributes.schema.encodingDefaultBinary = MethodAttributes.encodingDefaultBinary;
MethodAttributes.schema.encodingDefaultXml = MethodAttributes.encodingDefaultXml;
MethodAttributes.schema.encodingDefaultJson = MethodAttributes.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(MethodAttributes.dataTypeNodeId, "MethodAttributes", MethodAttributes);
// --------------------------------------------------------------------------------------------
const schemaModelChangeStructureDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ModelChangeStructureDataType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Affected",
            fieldType: "NodeId",
        },
        {
            name: "AffectedType",
            fieldType: "NodeId",
        },
        {
            name: "Verb",
            fieldType: "Byte",
        },
    ]
});
class ModelChangeStructureDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaModelChangeStructureDataType; }
    static possibleFields = [
        "affected",
        "affectedType",
        "verb"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(877, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(879, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(878, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15373, 0);
    affected;
    affectedType;
    verb;
    constructor(options) {
        super(options);
        if (options === null) {
            this.affected = new node_opcua_nodeid_1.NodeId(null);
            this.affectedType = new node_opcua_nodeid_1.NodeId(null);
            this.verb = 0;
            return;
        }
        const schema = ModelChangeStructureDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.affected = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.affected);
        this.affectedType = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.affectedType);
        this.verb = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.verb);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.affected, stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.affectedType, stream);
        (0, node_opcua_basic_types_1.encodeByte)(this.verb, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.affected = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.affected);
        this.affectedType = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.affectedType);
        this.verb = (0, node_opcua_basic_types_1.decodeByte)(stream, this.verb);
    }
    get schema() { return schemaModelChangeStructureDataType; }
}
exports.ModelChangeStructureDataType = ModelChangeStructureDataType;
ModelChangeStructureDataType.schema.dataTypeNodeId = ModelChangeStructureDataType.dataTypeNodeId;
ModelChangeStructureDataType.schema.encodingDefaultBinary = ModelChangeStructureDataType.encodingDefaultBinary;
ModelChangeStructureDataType.schema.encodingDefaultXml = ModelChangeStructureDataType.encodingDefaultXml;
ModelChangeStructureDataType.schema.encodingDefaultJson = ModelChangeStructureDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ModelChangeStructureDataType.dataTypeNodeId, "ModelChangeStructureDataType", ModelChangeStructureDataType);
// --------------------------------------------------------------------------------------------
const schemaMonitoredItemModifyRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "MonitoredItemModifyRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "MonitoredItemId",
            fieldType: "UInt32",
        },
        {
            name: "RequestedParameters",
            fieldType: "MonitoringParameters",
        },
    ]
});
class MonitoredItemModifyRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaMonitoredItemModifyRequest; }
    static possibleFields = [
        "monitoredItemId",
        "requestedParameters"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(755, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(757, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(756, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15325, 0);
    monitoredItemId;
    requestedParameters;
    constructor(options) {
        super(options);
        if (options === null) {
            this.monitoredItemId = 0;
            this.requestedParameters = new MonitoringParameters(null);
            return;
        }
        const schema = MonitoredItemModifyRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.monitoredItemId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.monitoredItemId);
        this.requestedParameters = new MonitoringParameters(options.requestedParameters);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.monitoredItemId, stream);
        this.requestedParameters.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.monitoredItemId = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.monitoredItemId);
        this.requestedParameters.decode(stream);
    }
    get schema() { return schemaMonitoredItemModifyRequest; }
}
exports.MonitoredItemModifyRequest = MonitoredItemModifyRequest;
MonitoredItemModifyRequest.schema.dataTypeNodeId = MonitoredItemModifyRequest.dataTypeNodeId;
MonitoredItemModifyRequest.schema.encodingDefaultBinary = MonitoredItemModifyRequest.encodingDefaultBinary;
MonitoredItemModifyRequest.schema.encodingDefaultXml = MonitoredItemModifyRequest.encodingDefaultXml;
MonitoredItemModifyRequest.schema.encodingDefaultJson = MonitoredItemModifyRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(MonitoredItemModifyRequest.dataTypeNodeId, "MonitoredItemModifyRequest", MonitoredItemModifyRequest);
// --------------------------------------------------------------------------------------------
const schemaModifyMonitoredItemsRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ModifyMonitoredItemsRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",
            fieldType: "RequestHeader",
        },
        {
            name: "SubscriptionId",
            fieldType: "UInt32",
        },
        {
            name: "TimestampsToReturn",
            fieldType: "TimestampsToReturn",
        },
        {
            name: "ItemsToModify",
            fieldType: "MonitoredItemModifyRequest",
            isArray: true
        },
    ]
});
class ModifyMonitoredItemsRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaModifyMonitoredItemsRequest; }
    static possibleFields = [
        "requestHeader",
        "subscriptionId",
        "timestampsToReturn",
        "itemsToModify"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(761, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(763, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(762, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15327, 0);
    requestHeader;
    subscriptionId;
    timestampsToReturn;
    itemsToModify;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestHeader = new RequestHeader(null);
            this.subscriptionId = 0;
            this.timestampsToReturn = 0;
            this.itemsToModify = null; /* null array */
            return;
        }
        const schema = ModifyMonitoredItemsRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestHeader = new RequestHeader(options.requestHeader);
        this.subscriptionId = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.subscriptionId);
        this.timestampsToReturn = this.setTimestampsToReturn((0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.timestampsToReturn));
        this.itemsToModify = []; // should default
        if (options.itemsToModify) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.itemsToModify));
            this.itemsToModify = options.itemsToModify.map((e) => new MonitoredItemModifyRequest(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.subscriptionId, stream);
        (0, node_opcua_data_value_1.encodeTimestampsToReturn)(this.timestampsToReturn, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.itemsToModify, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.subscriptionId = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.subscriptionId);
        this.timestampsToReturn = (0, node_opcua_data_value_1.decodeTimestampsToReturn)(stream, this.timestampsToReturn);
        this.itemsToModify = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new MonitoredItemModifyRequest(null);
            obj.decode(stream1);
            return obj;
        });
    }
    // Define Enumeration setters
    setTimestampsToReturn(value) {
        const coercedValue = node_opcua_data_value_1._enumerationTimestampsToReturn.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to TimestampsToReturn :" + value);
        }
        this.timestampsToReturn = coercedValue.value;
        return this.timestampsToReturn;
    }
    get schema() { return schemaModifyMonitoredItemsRequest; }
}
exports.ModifyMonitoredItemsRequest = ModifyMonitoredItemsRequest;
ModifyMonitoredItemsRequest.schema.dataTypeNodeId = ModifyMonitoredItemsRequest.dataTypeNodeId;
ModifyMonitoredItemsRequest.schema.encodingDefaultBinary = ModifyMonitoredItemsRequest.encodingDefaultBinary;
ModifyMonitoredItemsRequest.schema.encodingDefaultXml = ModifyMonitoredItemsRequest.encodingDefaultXml;
ModifyMonitoredItemsRequest.schema.encodingDefaultJson = ModifyMonitoredItemsRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ModifyMonitoredItemsRequest.dataTypeNodeId, "ModifyMonitoredItemsRequest", ModifyMonitoredItemsRequest);
// --------------------------------------------------------------------------------------------
const schemaMonitoredItemModifyResult = (0, node_opcua_factory_1.buildStructuredType)({
    name: "MonitoredItemModifyResult",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "StatusCode",
            fieldType: "StatusCode",
        },
        {
            name: "RevisedSamplingInterval",
            fieldType: "Double",
        },
        {
            name: "RevisedQueueSize",
            fieldType: "UInt32",
        },
        {
            name: "FilterResult",
            fieldType: "ExtensionObject",
        },
    ]
});
class MonitoredItemModifyResult extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaMonitoredItemModifyResult; }
    static possibleFields = [
        "statusCode",
        "revisedSamplingInterval",
        "revisedQueueSize",
        "filterResult"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(758, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(760, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(759, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15326, 0);
    statusCode;
    revisedSamplingInterval;
    revisedQueueSize;
    filterResult;
    constructor(options) {
        super(options);
        if (options === null) {
            this.statusCode = node_opcua_status_code_1.StatusCodes.Good;
            this.revisedSamplingInterval = 0;
            this.revisedQueueSize = 0;
            this.filterResult = null;
            return;
        }
        const schema = MonitoredItemModifyResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.statusCode = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.statusCode);
        this.revisedSamplingInterval = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.revisedSamplingInterval);
        this.revisedQueueSize = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.revisedQueueSize);
        this.filterResult = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.filterResult);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_status_code_1.encodeStatusCode)(this.statusCode, stream);
        (0, node_opcua_basic_types_1.encodeDouble)(this.revisedSamplingInterval, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.revisedQueueSize, stream);
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.filterResult, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.statusCode = (0, node_opcua_status_code_1.decodeStatusCode)(stream, this.statusCode);
        this.revisedSamplingInterval = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.revisedSamplingInterval);
        this.revisedQueueSize = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.revisedQueueSize);
        this.filterResult = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.filterResult);
    }
    get schema() { return schemaMonitoredItemModifyResult; }
}
exports.MonitoredItemModifyResult = MonitoredItemModifyResult;
MonitoredItemModifyResult.schema.dataTypeNodeId = MonitoredItemModifyResult.dataTypeNodeId;
MonitoredItemModifyResult.schema.encodingDefaultBinary = MonitoredItemModifyResult.encodingDefaultBinary;
MonitoredItemModifyResult.schema.encodingDefaultXml = MonitoredItemModifyResult.encodingDefaultXml;
MonitoredItemModifyResult.schema.encodingDefaultJson = MonitoredItemModifyResult.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(MonitoredItemModifyResult.dataTypeNodeId, "MonitoredItemModifyResult", MonitoredItemModifyResult);
// --------------------------------------------------------------------------------------------
const schemaModifyMonitoredItemsResponse = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ModifyMonitoredItemsResponse",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",
            fieldType: "ResponseHeader",
        },
        {
            name: "Results",
            fieldType: "MonitoredItemModifyResult",
            isArray: true
        },
        {
            name: "DiagnosticInfos",
            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
class ModifyMonitoredItemsResponse extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaModifyMonitoredItemsResponse; }
    static possibleFields = [
        "responseHeader",
        "results",
        "diagnosticInfos"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(764, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(766, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(765, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15328, 0);
    responseHeader;
    results;
    diagnosticInfos;
    constructor(options) {
        super(options);
        if (options === null) {
            this.responseHeader = new ResponseHeader(null);
            this.results = null; /* null array */
            this.diagnosticInfos = [];
            return;
        }
        const schema = ModifyMonitoredItemsResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.responseHeader = new ResponseHeader(options.responseHeader);
        this.results = []; // should default
        if (options.results) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.results));
            this.results = options.results.map((e) => new MonitoredItemModifyResult(e));
        }
        this.diagnosticInfos = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.diagnosticInfos);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.results, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.diagnosticInfos, stream, node_opcua_data_model_1.encodeDiagnosticInfo);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.results = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new MonitoredItemModifyResult(null);
            obj.decode(stream1);
            return obj;
        });
        this.diagnosticInfos = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_data_model_1.decodeDiagnosticInfo);
    }
    get schema() { return schemaModifyMonitoredItemsResponse; }
}
exports.ModifyMonitoredItemsResponse = ModifyMonitoredItemsResponse;
ModifyMonitoredItemsResponse.schema.dataTypeNodeId = ModifyMonitoredItemsResponse.dataTypeNodeId;
ModifyMonitoredItemsResponse.schema.encodingDefaultBinary = ModifyMonitoredItemsResponse.encodingDefaultBinary;
ModifyMonitoredItemsResponse.schema.encodingDefaultXml = ModifyMonitoredItemsResponse.encodingDefaultXml;
ModifyMonitoredItemsResponse.schema.encodingDefaultJson = ModifyMonitoredItemsResponse.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ModifyMonitoredItemsResponse.dataTypeNodeId, "ModifyMonitoredItemsResponse", ModifyMonitoredItemsResponse);
// --------------------------------------------------------------------------------------------
const schemaModifySubscriptionRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ModifySubscriptionRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",
            fieldType: "RequestHeader",
        },
        {
            name: "SubscriptionId",
            fieldType: "UInt32",
        },
        {
            name: "RequestedPublishingInterval",
            fieldType: "Double",
        },
        {
            name: "RequestedLifetimeCount",
            fieldType: "UInt32",
        },
        {
            name: "RequestedMaxKeepAliveCount",
            fieldType: "UInt32",
        },
        {
            name: "MaxNotificationsPerPublish",
            fieldType: "UInt32",
        },
        {
            name: "Priority",
            fieldType: "Byte",
        },
    ]
});
class ModifySubscriptionRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaModifySubscriptionRequest; }
    static possibleFields = [
        "requestHeader",
        "subscriptionId",
        "requestedPublishingInterval",
        "requestedLifetimeCount",
        "requestedMaxKeepAliveCount",
        "maxNotificationsPerPublish",
        "priority"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(791, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(793, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(792, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15339, 0);
    requestHeader;
    subscriptionId;
    requestedPublishingInterval;
    requestedLifetimeCount;
    requestedMaxKeepAliveCount;
    maxNotificationsPerPublish;
    priority;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestHeader = new RequestHeader(null);
            this.subscriptionId = 0;
            this.requestedPublishingInterval = 0;
            this.requestedLifetimeCount = 0;
            this.requestedMaxKeepAliveCount = 0;
            this.maxNotificationsPerPublish = 0;
            this.priority = 0;
            return;
        }
        const schema = ModifySubscriptionRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestHeader = new RequestHeader(options.requestHeader);
        this.subscriptionId = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.subscriptionId);
        this.requestedPublishingInterval = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.requestedPublishingInterval);
        this.requestedLifetimeCount = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.requestedLifetimeCount);
        this.requestedMaxKeepAliveCount = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.requestedMaxKeepAliveCount);
        this.maxNotificationsPerPublish = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.maxNotificationsPerPublish);
        this.priority = (0, node_opcua_factory_1.initialize_field)(schema.fields[6], options?.priority);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.subscriptionId, stream);
        (0, node_opcua_basic_types_1.encodeDouble)(this.requestedPublishingInterval, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.requestedLifetimeCount, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.requestedMaxKeepAliveCount, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.maxNotificationsPerPublish, stream);
        (0, node_opcua_basic_types_1.encodeByte)(this.priority, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.subscriptionId = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.subscriptionId);
        this.requestedPublishingInterval = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.requestedPublishingInterval);
        this.requestedLifetimeCount = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.requestedLifetimeCount);
        this.requestedMaxKeepAliveCount = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.requestedMaxKeepAliveCount);
        this.maxNotificationsPerPublish = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.maxNotificationsPerPublish);
        this.priority = (0, node_opcua_basic_types_1.decodeByte)(stream, this.priority);
    }
    get schema() { return schemaModifySubscriptionRequest; }
}
exports.ModifySubscriptionRequest = ModifySubscriptionRequest;
ModifySubscriptionRequest.schema.dataTypeNodeId = ModifySubscriptionRequest.dataTypeNodeId;
ModifySubscriptionRequest.schema.encodingDefaultBinary = ModifySubscriptionRequest.encodingDefaultBinary;
ModifySubscriptionRequest.schema.encodingDefaultXml = ModifySubscriptionRequest.encodingDefaultXml;
ModifySubscriptionRequest.schema.encodingDefaultJson = ModifySubscriptionRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ModifySubscriptionRequest.dataTypeNodeId, "ModifySubscriptionRequest", ModifySubscriptionRequest);
// --------------------------------------------------------------------------------------------
const schemaModifySubscriptionResponse = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ModifySubscriptionResponse",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",
            fieldType: "ResponseHeader",
        },
        {
            name: "RevisedPublishingInterval",
            fieldType: "Double",
        },
        {
            name: "RevisedLifetimeCount",
            fieldType: "UInt32",
        },
        {
            name: "RevisedMaxKeepAliveCount",
            fieldType: "UInt32",
        },
    ]
});
class ModifySubscriptionResponse extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaModifySubscriptionResponse; }
    static possibleFields = [
        "responseHeader",
        "revisedPublishingInterval",
        "revisedLifetimeCount",
        "revisedMaxKeepAliveCount"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(794, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(796, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(795, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15340, 0);
    responseHeader;
    revisedPublishingInterval;
    revisedLifetimeCount;
    revisedMaxKeepAliveCount;
    constructor(options) {
        super(options);
        if (options === null) {
            this.responseHeader = new ResponseHeader(null);
            this.revisedPublishingInterval = 0;
            this.revisedLifetimeCount = 0;
            this.revisedMaxKeepAliveCount = 0;
            return;
        }
        const schema = ModifySubscriptionResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.responseHeader = new ResponseHeader(options.responseHeader);
        this.revisedPublishingInterval = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.revisedPublishingInterval);
        this.revisedLifetimeCount = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.revisedLifetimeCount);
        this.revisedMaxKeepAliveCount = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.revisedMaxKeepAliveCount);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeDouble)(this.revisedPublishingInterval, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.revisedLifetimeCount, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.revisedMaxKeepAliveCount, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.revisedPublishingInterval = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.revisedPublishingInterval);
        this.revisedLifetimeCount = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.revisedLifetimeCount);
        this.revisedMaxKeepAliveCount = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.revisedMaxKeepAliveCount);
    }
    get schema() { return schemaModifySubscriptionResponse; }
}
exports.ModifySubscriptionResponse = ModifySubscriptionResponse;
ModifySubscriptionResponse.schema.dataTypeNodeId = ModifySubscriptionResponse.dataTypeNodeId;
ModifySubscriptionResponse.schema.encodingDefaultBinary = ModifySubscriptionResponse.encodingDefaultBinary;
ModifySubscriptionResponse.schema.encodingDefaultXml = ModifySubscriptionResponse.encodingDefaultXml;
ModifySubscriptionResponse.schema.encodingDefaultJson = ModifySubscriptionResponse.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ModifySubscriptionResponse.dataTypeNodeId, "ModifySubscriptionResponse", ModifySubscriptionResponse);
// --------------------------------------------------------------------------------------------
const schemaNetworkAddressDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "NetworkAddressDataType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "NetworkInterface",
            fieldType: "String",
        },
    ]
});
class NetworkAddressDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaNetworkAddressDataType; }
    static possibleFields = [
        "networkInterface"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15502, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(21151, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(21175, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(21199, 0);
    networkInterface;
    constructor(options) {
        super(options);
        if (options === null) {
            this.networkInterface = null;
            return;
        }
        const schema = NetworkAddressDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.networkInterface = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.networkInterface);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.networkInterface, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.networkInterface = (0, node_opcua_basic_types_1.decodeString)(stream, this.networkInterface);
    }
    get schema() { return schemaNetworkAddressDataType; }
}
exports.NetworkAddressDataType = NetworkAddressDataType;
NetworkAddressDataType.schema.dataTypeNodeId = NetworkAddressDataType.dataTypeNodeId;
NetworkAddressDataType.schema.encodingDefaultBinary = NetworkAddressDataType.encodingDefaultBinary;
NetworkAddressDataType.schema.encodingDefaultXml = NetworkAddressDataType.encodingDefaultXml;
NetworkAddressDataType.schema.encodingDefaultJson = NetworkAddressDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(NetworkAddressDataType.dataTypeNodeId, "NetworkAddressDataType", NetworkAddressDataType);
// --------------------------------------------------------------------------------------------
const schemaNetworkAddressUrlDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "NetworkAddressUrlDataType",
    baseType: "NetworkAddressDataType",
    fields: [
        {
            name: "Url",
            fieldType: "String",
        },
    ]
});
class NetworkAddressUrlDataType extends NetworkAddressDataType {
    static get schema() { return schemaNetworkAddressUrlDataType; }
    static possibleFields = [
        "networkInterface",
        "url"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15510, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(21152, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(21176, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(21200, 0);
    url;
    constructor(options) {
        super(options);
        if (options === null) {
            this.url = null;
            return;
        }
        const schema = NetworkAddressUrlDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.url = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.url);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.url, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.url = (0, node_opcua_basic_types_1.decodeString)(stream, this.url);
    }
    get schema() { return schemaNetworkAddressUrlDataType; }
}
exports.NetworkAddressUrlDataType = NetworkAddressUrlDataType;
NetworkAddressUrlDataType.schema.dataTypeNodeId = NetworkAddressUrlDataType.dataTypeNodeId;
NetworkAddressUrlDataType.schema.encodingDefaultBinary = NetworkAddressUrlDataType.encodingDefaultBinary;
NetworkAddressUrlDataType.schema.encodingDefaultXml = NetworkAddressUrlDataType.encodingDefaultXml;
NetworkAddressUrlDataType.schema.encodingDefaultJson = NetworkAddressUrlDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(NetworkAddressUrlDataType.dataTypeNodeId, "NetworkAddressUrlDataType", NetworkAddressUrlDataType);
// --------------------------------------------------------------------------------------------
const schemaNetworkGroupDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "NetworkGroupDataType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ServerUri",
            fieldType: "String",
        },
        {
            name: "NetworkPaths",
            fieldType: "EndpointUrlListDataType",
            isArray: true
        },
    ]
});
class NetworkGroupDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaNetworkGroupDataType; }
    static possibleFields = [
        "serverUri",
        "networkPaths"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(11944, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(11958, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(11950, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15364, 0);
    serverUri;
    networkPaths;
    constructor(options) {
        super(options);
        if (options === null) {
            this.serverUri = null;
            this.networkPaths = null; /* null array */
            return;
        }
        const schema = NetworkGroupDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.serverUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.serverUri);
        this.networkPaths = []; // should default
        if (options.networkPaths) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.networkPaths));
            this.networkPaths = options.networkPaths.map((e) => new EndpointUrlListDataType(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.serverUri, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.networkPaths, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.serverUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.serverUri);
        this.networkPaths = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new EndpointUrlListDataType(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaNetworkGroupDataType; }
}
exports.NetworkGroupDataType = NetworkGroupDataType;
NetworkGroupDataType.schema.dataTypeNodeId = NetworkGroupDataType.dataTypeNodeId;
NetworkGroupDataType.schema.encodingDefaultBinary = NetworkGroupDataType.encodingDefaultBinary;
NetworkGroupDataType.schema.encodingDefaultXml = NetworkGroupDataType.encodingDefaultXml;
NetworkGroupDataType.schema.encodingDefaultJson = NetworkGroupDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(NetworkGroupDataType.dataTypeNodeId, "NetworkGroupDataType", NetworkGroupDataType);
// --------------------------------------------------------------------------------------------
const schemaNodeReference = (0, node_opcua_factory_1.buildStructuredType)({
    name: "NodeReference",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "NodeId",
            fieldType: "NodeId",
        },
        {
            name: "ReferenceTypeId",
            fieldType: "NodeId",
        },
        {
            name: "IsForward",
            fieldType: "Boolean",
        },
        {
            name: "ReferencedNodeIds",
            fieldType: "NodeId",
            isArray: true
        },
    ]
});
class NodeReference extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaNodeReference; }
    static possibleFields = [
        "nodeId",
        "referenceTypeId",
        "isForward",
        "referencedNodeIds"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(580, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(582, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(581, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15203, 0);
    nodeId;
    referenceTypeId;
    isForward;
    referencedNodeIds;
    constructor(options) {
        super(options);
        if (options === null) {
            this.nodeId = new node_opcua_nodeid_1.NodeId(null);
            this.referenceTypeId = new node_opcua_nodeid_1.NodeId(null);
            this.isForward = false;
            this.referencedNodeIds = [];
            return;
        }
        const schema = NodeReference.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.nodeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.nodeId);
        this.referenceTypeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.referenceTypeId);
        this.isForward = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.isForward);
        this.referencedNodeIds = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[3], options?.referencedNodeIds);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.nodeId, stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.referenceTypeId, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.isForward, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.referencedNodeIds, stream, node_opcua_basic_types_1.encodeNodeId);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.nodeId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.nodeId);
        this.referenceTypeId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.referenceTypeId);
        this.isForward = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.isForward);
        this.referencedNodeIds = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeNodeId);
    }
    get schema() { return schemaNodeReference; }
}
exports.NodeReference = NodeReference;
NodeReference.schema.dataTypeNodeId = NodeReference.dataTypeNodeId;
NodeReference.schema.encodingDefaultBinary = NodeReference.encodingDefaultBinary;
NodeReference.schema.encodingDefaultXml = NodeReference.encodingDefaultXml;
NodeReference.schema.encodingDefaultJson = NodeReference.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(NodeReference.dataTypeNodeId, "NodeReference", NodeReference);
// --------------------------------------------------------------------------------------------
const schemaQueryDataDescription = (0, node_opcua_factory_1.buildStructuredType)({
    name: "QueryDataDescription",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RelativePath",
            fieldType: "RelativePath",
        },
        {
            name: "AttributeId",
            fieldType: "UInt32",
        },
        {
            name: "IndexRange",
            fieldType: "NumericRange",
        },
    ]
});
class QueryDataDescription extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaQueryDataDescription; }
    static possibleFields = [
        "relativePath",
        "attributeId",
        "indexRange"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(570, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(572, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(571, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15200, 0);
    relativePath;
    attributeId;
    indexRange;
    constructor(options) {
        super(options);
        if (options === null) {
            this.relativePath = new RelativePath(null);
            this.attributeId = 0;
            this.indexRange = new node_opcua_numeric_range_1.NumericRange(null);
            return;
        }
        const schema = QueryDataDescription.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.relativePath = new RelativePath(options.relativePath);
        this.attributeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.attributeId);
        this.indexRange = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.indexRange);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.relativePath.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.attributeId, stream);
        (0, node_opcua_numeric_range_1.encodeNumericRange)(this.indexRange, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.relativePath.decode(stream);
        this.attributeId = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.attributeId);
        this.indexRange = (0, node_opcua_numeric_range_1.decodeNumericRange)(stream, this.indexRange);
    }
    get schema() { return schemaQueryDataDescription; }
}
exports.QueryDataDescription = QueryDataDescription;
QueryDataDescription.schema.dataTypeNodeId = QueryDataDescription.dataTypeNodeId;
QueryDataDescription.schema.encodingDefaultBinary = QueryDataDescription.encodingDefaultBinary;
QueryDataDescription.schema.encodingDefaultXml = QueryDataDescription.encodingDefaultXml;
QueryDataDescription.schema.encodingDefaultJson = QueryDataDescription.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(QueryDataDescription.dataTypeNodeId, "QueryDataDescription", QueryDataDescription);
// --------------------------------------------------------------------------------------------
const schemaNodeTypeDescription = (0, node_opcua_factory_1.buildStructuredType)({
    name: "NodeTypeDescription",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "TypeDefinitionNode",
            fieldType: "ExpandedNodeId",
        },
        {
            name: "IncludeSubTypes",
            fieldType: "Boolean",
        },
        {
            name: "DataToReturn",
            fieldType: "QueryDataDescription",
            isArray: true
        },
    ]
});
class NodeTypeDescription extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaNodeTypeDescription; }
    static possibleFields = [
        "typeDefinitionNode",
        "includeSubTypes",
        "dataToReturn"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(573, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(575, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(574, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15201, 0);
    typeDefinitionNode;
    includeSubTypes;
    dataToReturn;
    constructor(options) {
        super(options);
        if (options === null) {
            this.typeDefinitionNode = new node_opcua_nodeid_1.ExpandedNodeId(null);
            this.includeSubTypes = false;
            this.dataToReturn = null; /* null array */
            return;
        }
        const schema = NodeTypeDescription.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.typeDefinitionNode = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.typeDefinitionNode);
        this.includeSubTypes = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.includeSubTypes);
        this.dataToReturn = []; // should default
        if (options.dataToReturn) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.dataToReturn));
            this.dataToReturn = options.dataToReturn.map((e) => new QueryDataDescription(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeExpandedNodeId)(this.typeDefinitionNode, stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.includeSubTypes, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.dataToReturn, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.typeDefinitionNode = (0, node_opcua_basic_types_1.decodeExpandedNodeId)(stream, this.typeDefinitionNode);
        this.includeSubTypes = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.includeSubTypes);
        this.dataToReturn = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new QueryDataDescription(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaNodeTypeDescription; }
}
exports.NodeTypeDescription = NodeTypeDescription;
NodeTypeDescription.schema.dataTypeNodeId = NodeTypeDescription.dataTypeNodeId;
NodeTypeDescription.schema.encodingDefaultBinary = NodeTypeDescription.encodingDefaultBinary;
NodeTypeDescription.schema.encodingDefaultXml = NodeTypeDescription.encodingDefaultXml;
NodeTypeDescription.schema.encodingDefaultJson = NodeTypeDescription.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(NodeTypeDescription.dataTypeNodeId, "NodeTypeDescription", NodeTypeDescription);
// --------------------------------------------------------------------------------------------
const schemaNotificationMessage = (0, node_opcua_factory_1.buildStructuredType)({
    name: "NotificationMessage",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "SequenceNumber",
            fieldType: "UInt32",
        },
        {
            name: "PublishTime",
            fieldType: "DateTime",
        },
        {
            name: "NotificationData",
            fieldType: "ExtensionObject",
            isArray: true
        },
    ]
});
class NotificationMessage extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaNotificationMessage; }
    static possibleFields = [
        "sequenceNumber",
        "publishTime",
        "notificationData"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(803, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(805, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(804, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15343, 0);
    sequenceNumber;
    publishTime;
    notificationData;
    constructor(options) {
        super(options);
        if (options === null) {
            this.sequenceNumber = 0;
            this.publishTime = new Date();
            this.notificationData = [];
            return;
        }
        const schema = NotificationMessage.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.sequenceNumber = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.sequenceNumber);
        this.publishTime = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.publishTime);
        this.notificationData = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.notificationData);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.sequenceNumber, stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.publishTime, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.notificationData, stream, node_opcua_extension_object_1.encodeExtensionObject);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.sequenceNumber = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.sequenceNumber);
        this.publishTime = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.publishTime);
        this.notificationData = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_extension_object_1.decodeExtensionObject);
    }
    get schema() { return schemaNotificationMessage; }
}
exports.NotificationMessage = NotificationMessage;
NotificationMessage.schema.dataTypeNodeId = NotificationMessage.dataTypeNodeId;
NotificationMessage.schema.encodingDefaultBinary = NotificationMessage.encodingDefaultBinary;
NotificationMessage.schema.encodingDefaultXml = NotificationMessage.encodingDefaultXml;
NotificationMessage.schema.encodingDefaultJson = NotificationMessage.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(NotificationMessage.dataTypeNodeId, "NotificationMessage", NotificationMessage);
// --------------------------------------------------------------------------------------------
const schemaObjectAttributes = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ObjectAttributes",
    baseType: "NodeAttributes",
    fields: [
        {
            name: "EventNotifier",
            fieldType: "Byte",
        },
    ]
});
class ObjectAttributes extends NodeAttributes {
    static get schema() { return schemaObjectAttributes; }
    static possibleFields = [
        "specifiedAttributes",
        "displayName",
        "description",
        "writeMask",
        "userWriteMask",
        "eventNotifier"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(352, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(354, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(353, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15152, 0);
    eventNotifier;
    constructor(options) {
        super(options);
        if (options === null) {
            this.eventNotifier = 0;
            return;
        }
        const schema = ObjectAttributes.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.eventNotifier = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.eventNotifier);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeByte)(this.eventNotifier, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.eventNotifier = (0, node_opcua_basic_types_1.decodeByte)(stream, this.eventNotifier);
    }
    get schema() { return schemaObjectAttributes; }
}
exports.ObjectAttributes = ObjectAttributes;
ObjectAttributes.schema.dataTypeNodeId = ObjectAttributes.dataTypeNodeId;
ObjectAttributes.schema.encodingDefaultBinary = ObjectAttributes.encodingDefaultBinary;
ObjectAttributes.schema.encodingDefaultXml = ObjectAttributes.encodingDefaultXml;
ObjectAttributes.schema.encodingDefaultJson = ObjectAttributes.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ObjectAttributes.dataTypeNodeId, "ObjectAttributes", ObjectAttributes);
// --------------------------------------------------------------------------------------------
const schemaObjectTypeAttributes = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ObjectTypeAttributes",
    baseType: "NodeAttributes",
    fields: [
        {
            name: "IsAbstract",
            fieldType: "Boolean",
        },
    ]
});
class ObjectTypeAttributes extends NodeAttributes {
    static get schema() { return schemaObjectTypeAttributes; }
    static possibleFields = [
        "specifiedAttributes",
        "displayName",
        "description",
        "writeMask",
        "userWriteMask",
        "isAbstract"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(361, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(363, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(362, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15158, 0);
    isAbstract;
    constructor(options) {
        super(options);
        if (options === null) {
            this.isAbstract = false;
            return;
        }
        const schema = ObjectTypeAttributes.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.isAbstract = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.isAbstract);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.isAbstract, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.isAbstract = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.isAbstract);
    }
    get schema() { return schemaObjectTypeAttributes; }
}
exports.ObjectTypeAttributes = ObjectTypeAttributes;
ObjectTypeAttributes.schema.dataTypeNodeId = ObjectTypeAttributes.dataTypeNodeId;
ObjectTypeAttributes.schema.encodingDefaultBinary = ObjectTypeAttributes.encodingDefaultBinary;
ObjectTypeAttributes.schema.encodingDefaultXml = ObjectTypeAttributes.encodingDefaultXml;
ObjectTypeAttributes.schema.encodingDefaultJson = ObjectTypeAttributes.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ObjectTypeAttributes.dataTypeNodeId, "ObjectTypeAttributes", ObjectTypeAttributes);
// --------------------------------------------------------------------------------------------
var SecurityTokenRequestType;
(function (SecurityTokenRequestType) {
    SecurityTokenRequestType[SecurityTokenRequestType["Issue"] = 0] = "Issue";
    SecurityTokenRequestType[SecurityTokenRequestType["Renew"] = 1] = "Renew";
    SecurityTokenRequestType[SecurityTokenRequestType["Invalid"] = 4294967295] = "Invalid";
})(SecurityTokenRequestType || (exports.SecurityTokenRequestType = SecurityTokenRequestType = {}));
const schemaSecurityTokenRequestType = {
    enumValues: SecurityTokenRequestType,
    flaggable: false,
    minValue: 0,
    maxValue: 1,
    name: "SecurityTokenRequestType"
};
function decodeSecurityTokenRequestType(stream, _value) {
    let value = stream.readUInt32();
    value = (value < schemaSecurityTokenRequestType.minValue || value > schemaSecurityTokenRequestType.maxValue) ? SecurityTokenRequestType.Invalid : value;
    return value;
}
function encodeSecurityTokenRequestType(value, stream) {
    stream.writeUInt32(value);
}
exports._enumerationSecurityTokenRequestType = (0, node_opcua_factory_1.registerEnumeration)(schemaSecurityTokenRequestType);
(0, node_opcua_assert_1.assert)(exports._enumerationSecurityTokenRequestType.isFlaggable === false);
// --------------------------------------------------------------------------------------------
const schemaOpenSecureChannelRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "OpenSecureChannelRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",
            fieldType: "RequestHeader",
        },
        {
            name: "ClientProtocolVersion",
            fieldType: "UInt32",
        },
        {
            name: "RequestType",
            fieldType: "SecurityTokenRequestType",
        },
        {
            name: "SecurityMode",
            fieldType: "MessageSecurityMode",
        },
        {
            name: "ClientNonce",
            fieldType: "ByteString",
        },
        {
            name: "RequestedLifetime",
            fieldType: "UInt32",
        },
    ]
});
class OpenSecureChannelRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaOpenSecureChannelRequest; }
    static possibleFields = [
        "requestHeader",
        "clientProtocolVersion",
        "requestType",
        "securityMode",
        "clientNonce",
        "requestedLifetime"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(444, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(446, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(445, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15132, 0);
    requestHeader;
    clientProtocolVersion;
    requestType;
    securityMode;
    clientNonce;
    requestedLifetime;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestHeader = new RequestHeader(null);
            this.clientProtocolVersion = 0;
            this.requestType = 0;
            this.securityMode = 0;
            this.clientNonce = Buffer.alloc(0);
            this.requestedLifetime = 0;
            return;
        }
        const schema = OpenSecureChannelRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestHeader = new RequestHeader(options.requestHeader);
        this.clientProtocolVersion = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.clientProtocolVersion);
        this.requestType = this.setRequestType((0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.requestType));
        this.securityMode = this.setSecurityMode((0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.securityMode));
        this.clientNonce = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.clientNonce);
        this.requestedLifetime = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.requestedLifetime);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.clientProtocolVersion, stream);
        encodeSecurityTokenRequestType(this.requestType, stream);
        encodeMessageSecurityMode(this.securityMode, stream);
        (0, node_opcua_basic_types_1.encodeByteString)(this.clientNonce, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.requestedLifetime, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.clientProtocolVersion = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.clientProtocolVersion);
        this.requestType = decodeSecurityTokenRequestType(stream, this.requestType);
        this.securityMode = decodeMessageSecurityMode(stream, this.securityMode);
        this.clientNonce = (0, node_opcua_basic_types_1.decodeByteString)(stream, this.clientNonce);
        this.requestedLifetime = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.requestedLifetime);
    }
    // Define Enumeration setters
    setRequestType(value) {
        const coercedValue = exports._enumerationSecurityTokenRequestType.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to SecurityTokenRequestType :" + value);
        }
        this.requestType = coercedValue.value;
        return this.requestType;
    }
    setSecurityMode(value) {
        const coercedValue = exports._enumerationMessageSecurityMode.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to MessageSecurityMode :" + value);
        }
        this.securityMode = coercedValue.value;
        return this.securityMode;
    }
    get schema() { return schemaOpenSecureChannelRequest; }
}
exports.OpenSecureChannelRequest = OpenSecureChannelRequest;
OpenSecureChannelRequest.schema.dataTypeNodeId = OpenSecureChannelRequest.dataTypeNodeId;
OpenSecureChannelRequest.schema.encodingDefaultBinary = OpenSecureChannelRequest.encodingDefaultBinary;
OpenSecureChannelRequest.schema.encodingDefaultXml = OpenSecureChannelRequest.encodingDefaultXml;
OpenSecureChannelRequest.schema.encodingDefaultJson = OpenSecureChannelRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(OpenSecureChannelRequest.dataTypeNodeId, "OpenSecureChannelRequest", OpenSecureChannelRequest);
// --------------------------------------------------------------------------------------------
const schemaOpenSecureChannelResponse = (0, node_opcua_factory_1.buildStructuredType)({
    name: "OpenSecureChannelResponse",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",
            fieldType: "ResponseHeader",
        },
        {
            name: "ServerProtocolVersion",
            fieldType: "UInt32",
        },
        {
            name: "SecurityToken",
            fieldType: "ChannelSecurityToken",
        },
        {
            name: "ServerNonce",
            fieldType: "ByteString",
        },
    ]
});
class OpenSecureChannelResponse extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaOpenSecureChannelResponse; }
    static possibleFields = [
        "responseHeader",
        "serverProtocolVersion",
        "securityToken",
        "serverNonce"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(447, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(449, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(448, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15133, 0);
    responseHeader;
    serverProtocolVersion;
    securityToken;
    serverNonce;
    constructor(options) {
        super(options);
        if (options === null) {
            this.responseHeader = new ResponseHeader(null);
            this.serverProtocolVersion = 0;
            this.securityToken = new ChannelSecurityToken(null);
            this.serverNonce = Buffer.alloc(0);
            return;
        }
        const schema = OpenSecureChannelResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.responseHeader = new ResponseHeader(options.responseHeader);
        this.serverProtocolVersion = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.serverProtocolVersion);
        this.securityToken = new ChannelSecurityToken(options.securityToken);
        this.serverNonce = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.serverNonce);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.serverProtocolVersion, stream);
        this.securityToken.encode(stream);
        (0, node_opcua_basic_types_1.encodeByteString)(this.serverNonce, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.serverProtocolVersion = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.serverProtocolVersion);
        this.securityToken.decode(stream);
        this.serverNonce = (0, node_opcua_basic_types_1.decodeByteString)(stream, this.serverNonce);
    }
    get schema() { return schemaOpenSecureChannelResponse; }
}
exports.OpenSecureChannelResponse = OpenSecureChannelResponse;
OpenSecureChannelResponse.schema.dataTypeNodeId = OpenSecureChannelResponse.dataTypeNodeId;
OpenSecureChannelResponse.schema.encodingDefaultBinary = OpenSecureChannelResponse.encodingDefaultBinary;
OpenSecureChannelResponse.schema.encodingDefaultXml = OpenSecureChannelResponse.encodingDefaultXml;
OpenSecureChannelResponse.schema.encodingDefaultJson = OpenSecureChannelResponse.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(OpenSecureChannelResponse.dataTypeNodeId, "OpenSecureChannelResponse", OpenSecureChannelResponse);
// --------------------------------------------------------------------------------------------
const schemaOptionSet = (0, node_opcua_factory_1.buildStructuredType)({
    name: "OptionSet",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Value",
            fieldType: "ByteString",
        },
        {
            name: "ValidBits",
            fieldType: "ByteString",
        },
    ]
});
class OptionSet extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaOptionSet; }
    static possibleFields = [
        "value",
        "validBits"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12755, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12765, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(12757, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15084, 0);
    value;
    validBits;
    constructor(options) {
        super(options);
        if (options === null) {
            this.value = Buffer.alloc(0);
            this.validBits = Buffer.alloc(0);
            return;
        }
        const schema = OptionSet.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.value = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.value);
        this.validBits = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.validBits);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeByteString)(this.value, stream);
        (0, node_opcua_basic_types_1.encodeByteString)(this.validBits, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.value = (0, node_opcua_basic_types_1.decodeByteString)(stream, this.value);
        this.validBits = (0, node_opcua_basic_types_1.decodeByteString)(stream, this.validBits);
    }
    get schema() { return schemaOptionSet; }
}
exports.OptionSet = OptionSet;
OptionSet.schema.dataTypeNodeId = OptionSet.dataTypeNodeId;
OptionSet.schema.encodingDefaultBinary = OptionSet.encodingDefaultBinary;
OptionSet.schema.encodingDefaultXml = OptionSet.encodingDefaultXml;
OptionSet.schema.encodingDefaultJson = OptionSet.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(OptionSet.dataTypeNodeId, "OptionSet", OptionSet);
// --------------------------------------------------------------------------------------------
const schemaOrientation = (0, node_opcua_factory_1.buildStructuredType)({
    name: "Orientation",
    baseType: "ExtensionObject",
    fields: []
});
class Orientation extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaOrientation; }
    static possibleFields = [];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(18811, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(18820, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(18856, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(19069, 0);
    constructor(options) {
        super(options);
        if (options === null) {
            return;
        }
        const schema = Orientation.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    get schema() { return schemaOrientation; }
}
exports.Orientation = Orientation;
Orientation.schema.dataTypeNodeId = Orientation.dataTypeNodeId;
Orientation.schema.encodingDefaultBinary = Orientation.encodingDefaultBinary;
Orientation.schema.encodingDefaultXml = Orientation.encodingDefaultXml;
Orientation.schema.encodingDefaultJson = Orientation.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(Orientation.dataTypeNodeId, "Orientation", Orientation);
// --------------------------------------------------------------------------------------------
const schemaParsingResult = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ParsingResult",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "StatusCode",
            fieldType: "StatusCode",
        },
        {
            name: "DataStatusCodes",
            fieldType: "StatusCode",
            isArray: true
        },
        {
            name: "DataDiagnosticInfos",
            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
class ParsingResult extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaParsingResult; }
    static possibleFields = [
        "statusCode",
        "dataStatusCodes",
        "dataDiagnosticInfos"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(610, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(612, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(611, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15236, 0);
    statusCode;
    dataStatusCodes;
    dataDiagnosticInfos;
    constructor(options) {
        super(options);
        if (options === null) {
            this.statusCode = node_opcua_status_code_1.StatusCodes.Good;
            this.dataStatusCodes = [];
            this.dataDiagnosticInfos = [];
            return;
        }
        const schema = ParsingResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.statusCode = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.statusCode);
        this.dataStatusCodes = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.dataStatusCodes);
        this.dataDiagnosticInfos = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.dataDiagnosticInfos);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_status_code_1.encodeStatusCode)(this.statusCode, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.dataStatusCodes, stream, node_opcua_status_code_1.encodeStatusCode);
        (0, node_opcua_basic_types_1.encodeArray)(this.dataDiagnosticInfos, stream, node_opcua_data_model_1.encodeDiagnosticInfo);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.statusCode = (0, node_opcua_status_code_1.decodeStatusCode)(stream, this.statusCode);
        this.dataStatusCodes = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_status_code_1.decodeStatusCode);
        this.dataDiagnosticInfos = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_data_model_1.decodeDiagnosticInfo);
    }
    get schema() { return schemaParsingResult; }
}
exports.ParsingResult = ParsingResult;
ParsingResult.schema.dataTypeNodeId = ParsingResult.dataTypeNodeId;
ParsingResult.schema.encodingDefaultBinary = ParsingResult.encodingDefaultBinary;
ParsingResult.schema.encodingDefaultXml = ParsingResult.encodingDefaultXml;
ParsingResult.schema.encodingDefaultJson = ParsingResult.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ParsingResult.dataTypeNodeId, "ParsingResult", ParsingResult);
// --------------------------------------------------------------------------------------------
const schemaPortableNodeId = (0, node_opcua_factory_1.buildStructuredType)({
    name: "PortableNodeId",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "NamespaceUri",
            fieldType: "String",
        },
        {
            name: "Identifier",
            fieldType: "NodeId",
        },
    ]
});
class PortableNodeId extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaPortableNodeId; }
    static possibleFields = [
        "namespaceUri",
        "identifier"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(24106, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(24109, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(24121, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(24133, 0);
    namespaceUri;
    identifier;
    constructor(options) {
        super(options);
        if (options === null) {
            this.namespaceUri = null;
            this.identifier = new node_opcua_nodeid_1.NodeId(null);
            return;
        }
        const schema = PortableNodeId.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.namespaceUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.namespaceUri);
        this.identifier = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.identifier);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.namespaceUri, stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.identifier, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.namespaceUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.namespaceUri);
        this.identifier = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.identifier);
    }
    get schema() { return schemaPortableNodeId; }
}
exports.PortableNodeId = PortableNodeId;
PortableNodeId.schema.dataTypeNodeId = PortableNodeId.dataTypeNodeId;
PortableNodeId.schema.encodingDefaultBinary = PortableNodeId.encodingDefaultBinary;
PortableNodeId.schema.encodingDefaultXml = PortableNodeId.encodingDefaultXml;
PortableNodeId.schema.encodingDefaultJson = PortableNodeId.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(PortableNodeId.dataTypeNodeId, "PortableNodeId", PortableNodeId);
// --------------------------------------------------------------------------------------------
const schemaPortableQualifiedName = (0, node_opcua_factory_1.buildStructuredType)({
    name: "PortableQualifiedName",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "NamespaceUri",
            fieldType: "String",
        },
        {
            name: "Name",
            fieldType: "String",
        },
    ]
});
class PortableQualifiedName extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaPortableQualifiedName; }
    static possibleFields = [
        "namespaceUri",
        "name"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(24105, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(24108, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(24120, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(24132, 0);
    namespaceUri;
    name;
    constructor(options) {
        super(options);
        if (options === null) {
            this.namespaceUri = null;
            this.name = null;
            return;
        }
        const schema = PortableQualifiedName.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.namespaceUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.namespaceUri);
        this.name = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.name);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.namespaceUri, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.name, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.namespaceUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.namespaceUri);
        this.name = (0, node_opcua_basic_types_1.decodeString)(stream, this.name);
    }
    get schema() { return schemaPortableQualifiedName; }
}
exports.PortableQualifiedName = PortableQualifiedName;
PortableQualifiedName.schema.dataTypeNodeId = PortableQualifiedName.dataTypeNodeId;
PortableQualifiedName.schema.encodingDefaultBinary = PortableQualifiedName.encodingDefaultBinary;
PortableQualifiedName.schema.encodingDefaultXml = PortableQualifiedName.encodingDefaultXml;
PortableQualifiedName.schema.encodingDefaultJson = PortableQualifiedName.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(PortableQualifiedName.dataTypeNodeId, "PortableQualifiedName", PortableQualifiedName);
// --------------------------------------------------------------------------------------------
const schemaPriorityMappingEntryType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "PriorityMappingEntryType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "MappingUri",
            fieldType: "String",
        },
        {
            name: "PriorityLabel",
            fieldType: "String",
        },
        {
            name: "PriorityValue_PCP",
            fieldType: "Byte",
        },
        {
            name: "PriorityValue_DSCP",
            fieldType: "UInt32",
        },
    ]
});
class PriorityMappingEntryType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaPriorityMappingEntryType; }
    static possibleFields = [
        "mappingUri",
        "priorityLabel",
        "priorityValue_PCP",
        "priorityValue_DSCP"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(25220, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(25239, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(25243, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(25247, 0);
    mappingUri;
    priorityLabel;
    priorityValue_PCP;
    priorityValue_DSCP;
    constructor(options) {
        super(options);
        if (options === null) {
            this.mappingUri = null;
            this.priorityLabel = null;
            this.priorityValue_PCP = 0;
            this.priorityValue_DSCP = 0;
            return;
        }
        const schema = PriorityMappingEntryType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.mappingUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.mappingUri);
        this.priorityLabel = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.priorityLabel);
        this.priorityValue_PCP = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.priorityValue_PCP);
        this.priorityValue_DSCP = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.priorityValue_DSCP);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.mappingUri, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.priorityLabel, stream);
        (0, node_opcua_basic_types_1.encodeByte)(this.priorityValue_PCP, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.priorityValue_DSCP, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.mappingUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.mappingUri);
        this.priorityLabel = (0, node_opcua_basic_types_1.decodeString)(stream, this.priorityLabel);
        this.priorityValue_PCP = (0, node_opcua_basic_types_1.decodeByte)(stream, this.priorityValue_PCP);
        this.priorityValue_DSCP = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.priorityValue_DSCP);
    }
    get schema() { return schemaPriorityMappingEntryType; }
}
exports.PriorityMappingEntryType = PriorityMappingEntryType;
PriorityMappingEntryType.schema.dataTypeNodeId = PriorityMappingEntryType.dataTypeNodeId;
PriorityMappingEntryType.schema.encodingDefaultBinary = PriorityMappingEntryType.encodingDefaultBinary;
PriorityMappingEntryType.schema.encodingDefaultXml = PriorityMappingEntryType.encodingDefaultXml;
PriorityMappingEntryType.schema.encodingDefaultJson = PriorityMappingEntryType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(PriorityMappingEntryType.dataTypeNodeId, "PriorityMappingEntryType", PriorityMappingEntryType);
// --------------------------------------------------------------------------------------------
const schemaProgramDiagnostic2DataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ProgramDiagnostic2DataType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "CreateSessionId",
            fieldType: "NodeId",
        },
        {
            name: "CreateClientName",
            fieldType: "String",
        },
        {
            name: "InvocationCreationTime",
            fieldType: "DateTime",
        },
        {
            name: "LastTransitionTime",
            fieldType: "DateTime",
        },
        {
            name: "LastMethodCall",
            fieldType: "String",
        },
        {
            name: "LastMethodSessionId",
            fieldType: "NodeId",
        },
        {
            name: "LastMethodInputArguments",
            fieldType: "Argument",
            isArray: true
        },
        {
            name: "LastMethodOutputArguments",
            fieldType: "Argument",
            isArray: true
        },
        {
            name: "LastMethodInputValues",
            fieldType: "Variant",
            isArray: true
        },
        {
            name: "LastMethodOutputValues",
            fieldType: "Variant",
            isArray: true
        },
        {
            name: "LastMethodCallTime",
            fieldType: "DateTime",
        },
        {
            name: "LastMethodReturnStatus",
            fieldType: "StatusCode",
        },
    ]
});
class ProgramDiagnostic2DataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaProgramDiagnostic2DataType; }
    static possibleFields = [
        "createSessionId",
        "createClientName",
        "invocationCreationTime",
        "lastTransitionTime",
        "lastMethodCall",
        "lastMethodSessionId",
        "lastMethodInputArguments",
        "lastMethodOutputArguments",
        "lastMethodInputValues",
        "lastMethodOutputValues",
        "lastMethodCallTime",
        "lastMethodReturnStatus"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(24033, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(24034, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(24038, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(24042, 0);
    createSessionId;
    createClientName;
    invocationCreationTime;
    lastTransitionTime;
    lastMethodCall;
    lastMethodSessionId;
    lastMethodInputArguments;
    lastMethodOutputArguments;
    lastMethodInputValues;
    lastMethodOutputValues;
    lastMethodCallTime;
    lastMethodReturnStatus;
    constructor(options) {
        super(options);
        if (options === null) {
            this.createSessionId = new node_opcua_nodeid_1.NodeId(null);
            this.createClientName = null;
            this.invocationCreationTime = new Date();
            this.lastTransitionTime = new Date();
            this.lastMethodCall = null;
            this.lastMethodSessionId = new node_opcua_nodeid_1.NodeId(null);
            this.lastMethodInputArguments = null; /* null array */
            this.lastMethodOutputArguments = null; /* null array */
            this.lastMethodInputValues = [];
            this.lastMethodOutputValues = [];
            this.lastMethodCallTime = new Date();
            this.lastMethodReturnStatus = node_opcua_status_code_1.StatusCodes.Good;
            return;
        }
        const schema = ProgramDiagnostic2DataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.createSessionId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.createSessionId);
        this.createClientName = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.createClientName);
        this.invocationCreationTime = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.invocationCreationTime);
        this.lastTransitionTime = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.lastTransitionTime);
        this.lastMethodCall = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.lastMethodCall);
        this.lastMethodSessionId = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.lastMethodSessionId);
        this.lastMethodInputArguments = []; // should default
        if (options.lastMethodInputArguments) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.lastMethodInputArguments));
            this.lastMethodInputArguments = options.lastMethodInputArguments.map((e) => new Argument(e));
        }
        this.lastMethodOutputArguments = []; // should default
        if (options.lastMethodOutputArguments) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.lastMethodOutputArguments));
            this.lastMethodOutputArguments = options.lastMethodOutputArguments.map((e) => new Argument(e));
        }
        this.lastMethodInputValues = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[8], options?.lastMethodInputValues);
        this.lastMethodOutputValues = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[9], options?.lastMethodOutputValues);
        this.lastMethodCallTime = (0, node_opcua_factory_1.initialize_field)(schema.fields[10], options?.lastMethodCallTime);
        this.lastMethodReturnStatus = (0, node_opcua_factory_1.initialize_field)(schema.fields[11], options?.lastMethodReturnStatus);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.createSessionId, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.createClientName, stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.invocationCreationTime, stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.lastTransitionTime, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.lastMethodCall, stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.lastMethodSessionId, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.lastMethodInputArguments, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.lastMethodOutputArguments, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.lastMethodInputValues, stream, node_opcua_variant_1.encodeVariant);
        (0, node_opcua_basic_types_1.encodeArray)(this.lastMethodOutputValues, stream, node_opcua_variant_1.encodeVariant);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.lastMethodCallTime, stream);
        (0, node_opcua_status_code_1.encodeStatusCode)(this.lastMethodReturnStatus, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.createSessionId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.createSessionId);
        this.createClientName = (0, node_opcua_basic_types_1.decodeString)(stream, this.createClientName);
        this.invocationCreationTime = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.invocationCreationTime);
        this.lastTransitionTime = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.lastTransitionTime);
        this.lastMethodCall = (0, node_opcua_basic_types_1.decodeString)(stream, this.lastMethodCall);
        this.lastMethodSessionId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.lastMethodSessionId);
        this.lastMethodInputArguments = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new Argument(null);
            obj.decode(stream1);
            return obj;
        });
        this.lastMethodOutputArguments = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new Argument(null);
            obj.decode(stream1);
            return obj;
        });
        this.lastMethodInputValues = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_variant_1.decodeVariant);
        this.lastMethodOutputValues = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_variant_1.decodeVariant);
        this.lastMethodCallTime = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.lastMethodCallTime);
        this.lastMethodReturnStatus = (0, node_opcua_status_code_1.decodeStatusCode)(stream, this.lastMethodReturnStatus);
    }
    get schema() { return schemaProgramDiagnostic2DataType; }
}
exports.ProgramDiagnostic2DataType = ProgramDiagnostic2DataType;
ProgramDiagnostic2DataType.schema.dataTypeNodeId = ProgramDiagnostic2DataType.dataTypeNodeId;
ProgramDiagnostic2DataType.schema.encodingDefaultBinary = ProgramDiagnostic2DataType.encodingDefaultBinary;
ProgramDiagnostic2DataType.schema.encodingDefaultXml = ProgramDiagnostic2DataType.encodingDefaultXml;
ProgramDiagnostic2DataType.schema.encodingDefaultJson = ProgramDiagnostic2DataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ProgramDiagnostic2DataType.dataTypeNodeId, "ProgramDiagnostic2DataType", ProgramDiagnostic2DataType);
// --------------------------------------------------------------------------------------------
const schemaStatusResult = (0, node_opcua_factory_1.buildStructuredType)({
    name: "StatusResult",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "StatusCode",
            fieldType: "StatusCode",
        },
        {
            name: "DiagnosticInfo",
            fieldType: "DiagnosticInfo",
        },
    ]
});
class StatusResult extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaStatusResult; }
    static possibleFields = [
        "statusCode",
        "diagnosticInfo"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(299, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(301, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(300, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15371, 0);
    statusCode;
    diagnosticInfo;
    constructor(options) {
        super(options);
        if (options === null) {
            this.statusCode = node_opcua_status_code_1.StatusCodes.Good;
            this.diagnosticInfo = null;
            return;
        }
        const schema = StatusResult.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.statusCode = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.statusCode);
        this.diagnosticInfo = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.diagnosticInfo);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_status_code_1.encodeStatusCode)(this.statusCode, stream);
        (0, node_opcua_data_model_1.encodeDiagnosticInfo)(this.diagnosticInfo, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.statusCode = (0, node_opcua_status_code_1.decodeStatusCode)(stream, this.statusCode);
        this.diagnosticInfo = (0, node_opcua_data_model_1.decodeDiagnosticInfo)(stream, this.diagnosticInfo);
    }
    get schema() { return schemaStatusResult; }
}
exports.StatusResult = StatusResult;
StatusResult.schema.dataTypeNodeId = StatusResult.dataTypeNodeId;
StatusResult.schema.encodingDefaultBinary = StatusResult.encodingDefaultBinary;
StatusResult.schema.encodingDefaultXml = StatusResult.encodingDefaultXml;
StatusResult.schema.encodingDefaultJson = StatusResult.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(StatusResult.dataTypeNodeId, "StatusResult", StatusResult);
// --------------------------------------------------------------------------------------------
const schemaProgramDiagnosticDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "ProgramDiagnosticDataType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "CreateSessionId",
            fieldType: "NodeId",
        },
        {
            name: "CreateClientName",
            fieldType: "String",
        },
        {
            name: "InvocationCreationTime",
            fieldType: "DateTime",
        },
        {
            name: "LastTransitionTime",
            fieldType: "DateTime",
        },
        {
            name: "LastMethodCall",
            fieldType: "String",
        },
        {
            name: "LastMethodSessionId",
            fieldType: "NodeId",
        },
        {
            name: "LastMethodInputArguments",
            fieldType: "Argument",
            isArray: true
        },
        {
            name: "LastMethodOutputArguments",
            fieldType: "Argument",
            isArray: true
        },
        {
            name: "LastMethodCallTime",
            fieldType: "DateTime",
        },
        {
            name: "LastMethodReturnStatus",
            fieldType: "StatusResult",
        },
    ]
});
class ProgramDiagnosticDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaProgramDiagnosticDataType; }
    static possibleFields = [
        "createSessionId",
        "createClientName",
        "invocationCreationTime",
        "lastTransitionTime",
        "lastMethodCall",
        "lastMethodSessionId",
        "lastMethodInputArguments",
        "lastMethodOutputArguments",
        "lastMethodCallTime",
        "lastMethodReturnStatus"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(894, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(896, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(895, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15381, 0);
    createSessionId;
    createClientName;
    invocationCreationTime;
    lastTransitionTime;
    lastMethodCall;
    lastMethodSessionId;
    lastMethodInputArguments;
    lastMethodOutputArguments;
    lastMethodCallTime;
    lastMethodReturnStatus;
    constructor(options) {
        super(options);
        if (options === null) {
            this.createSessionId = new node_opcua_nodeid_1.NodeId(null);
            this.createClientName = null;
            this.invocationCreationTime = new Date();
            this.lastTransitionTime = new Date();
            this.lastMethodCall = null;
            this.lastMethodSessionId = new node_opcua_nodeid_1.NodeId(null);
            this.lastMethodInputArguments = null; /* null array */
            this.lastMethodOutputArguments = null; /* null array */
            this.lastMethodCallTime = new Date();
            this.lastMethodReturnStatus = new StatusResult(null);
            return;
        }
        const schema = ProgramDiagnosticDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.createSessionId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.createSessionId);
        this.createClientName = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.createClientName);
        this.invocationCreationTime = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.invocationCreationTime);
        this.lastTransitionTime = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.lastTransitionTime);
        this.lastMethodCall = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.lastMethodCall);
        this.lastMethodSessionId = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.lastMethodSessionId);
        this.lastMethodInputArguments = []; // should default
        if (options.lastMethodInputArguments) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.lastMethodInputArguments));
            this.lastMethodInputArguments = options.lastMethodInputArguments.map((e) => new Argument(e));
        }
        this.lastMethodOutputArguments = []; // should default
        if (options.lastMethodOutputArguments) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.lastMethodOutputArguments));
            this.lastMethodOutputArguments = options.lastMethodOutputArguments.map((e) => new Argument(e));
        }
        this.lastMethodCallTime = (0, node_opcua_factory_1.initialize_field)(schema.fields[8], options?.lastMethodCallTime);
        this.lastMethodReturnStatus = new StatusResult(options.lastMethodReturnStatus);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.createSessionId, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.createClientName, stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.invocationCreationTime, stream);
        (0, node_opcua_basic_types_1.encodeDateTime)(this.lastTransitionTime, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.lastMethodCall, stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.lastMethodSessionId, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.lastMethodInputArguments, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.lastMethodOutputArguments, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeDateTime)(this.lastMethodCallTime, stream);
        this.lastMethodReturnStatus.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.createSessionId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.createSessionId);
        this.createClientName = (0, node_opcua_basic_types_1.decodeString)(stream, this.createClientName);
        this.invocationCreationTime = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.invocationCreationTime);
        this.lastTransitionTime = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.lastTransitionTime);
        this.lastMethodCall = (0, node_opcua_basic_types_1.decodeString)(stream, this.lastMethodCall);
        this.lastMethodSessionId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.lastMethodSessionId);
        this.lastMethodInputArguments = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new Argument(null);
            obj.decode(stream1);
            return obj;
        });
        this.lastMethodOutputArguments = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new Argument(null);
            obj.decode(stream1);
            return obj;
        });
        this.lastMethodCallTime = (0, node_opcua_basic_types_1.decodeDateTime)(stream, this.lastMethodCallTime);
        this.lastMethodReturnStatus.decode(stream);
    }
    get schema() { return schemaProgramDiagnosticDataType; }
}
exports.ProgramDiagnosticDataType = ProgramDiagnosticDataType;
ProgramDiagnosticDataType.schema.dataTypeNodeId = ProgramDiagnosticDataType.dataTypeNodeId;
ProgramDiagnosticDataType.schema.encodingDefaultBinary = ProgramDiagnosticDataType.encodingDefaultBinary;
ProgramDiagnosticDataType.schema.encodingDefaultXml = ProgramDiagnosticDataType.encodingDefaultXml;
ProgramDiagnosticDataType.schema.encodingDefaultJson = ProgramDiagnosticDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(ProgramDiagnosticDataType.dataTypeNodeId, "ProgramDiagnosticDataType", ProgramDiagnosticDataType);
// --------------------------------------------------------------------------------------------
const schemaPublishedDataSetDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "PublishedDataSetDataType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Name",
            fieldType: "String",
        },
        {
            name: "DataSetFolder",
            fieldType: "String",
            isArray: true
        },
        {
            name: "DataSetMetaData",
            fieldType: "DataSetMetaDataType",
        },
        {
            name: "ExtensionFields",
            fieldType: "KeyValuePair",
            isArray: true
        },
        {
            name: "DataSetSource",
            fieldType: "ExtensionObject",
        },
    ]
});
class PublishedDataSetDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaPublishedDataSetDataType; }
    static possibleFields = [
        "name",
        "dataSetFolder",
        "dataSetMetaData",
        "extensionFields",
        "dataSetSource"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15578, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15677, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15951, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16152, 0);
    name;
    dataSetFolder;
    dataSetMetaData;
    extensionFields;
    dataSetSource;
    constructor(options) {
        super(options);
        if (options === null) {
            this.name = null;
            this.dataSetFolder = [];
            this.dataSetMetaData = new DataSetMetaDataType(null);
            this.extensionFields = null; /* null array */
            this.dataSetSource = null;
            return;
        }
        const schema = PublishedDataSetDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.name = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.name);
        this.dataSetFolder = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.dataSetFolder);
        this.dataSetMetaData = new DataSetMetaDataType(options.dataSetMetaData);
        this.extensionFields = []; // should default
        if (options.extensionFields) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.extensionFields));
            this.extensionFields = options.extensionFields.map((e) => new KeyValuePair(e));
        }
        this.dataSetSource = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.dataSetSource);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.name, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.dataSetFolder, stream, node_opcua_basic_types_1.encodeString);
        this.dataSetMetaData.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.extensionFields, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.dataSetSource, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = (0, node_opcua_basic_types_1.decodeString)(stream, this.name);
        this.dataSetFolder = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeString);
        this.dataSetMetaData.decode(stream);
        this.extensionFields = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new KeyValuePair(null);
            obj.decode(stream1);
            return obj;
        });
        this.dataSetSource = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.dataSetSource);
    }
    get schema() { return schemaPublishedDataSetDataType; }
}
exports.PublishedDataSetDataType = PublishedDataSetDataType;
PublishedDataSetDataType.schema.dataTypeNodeId = PublishedDataSetDataType.dataTypeNodeId;
PublishedDataSetDataType.schema.encodingDefaultBinary = PublishedDataSetDataType.encodingDefaultBinary;
PublishedDataSetDataType.schema.encodingDefaultXml = PublishedDataSetDataType.encodingDefaultXml;
PublishedDataSetDataType.schema.encodingDefaultJson = PublishedDataSetDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(PublishedDataSetDataType.dataTypeNodeId, "PublishedDataSetDataType", PublishedDataSetDataType);
// --------------------------------------------------------------------------------------------
const schemaPubSubConfigurationDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "PubSubConfigurationDataType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "PublishedDataSets",
            fieldType: "PublishedDataSetDataType",
            isArray: true
        },
        {
            name: "Connections",
            fieldType: "PubSubConnectionDataType",
            isArray: true
        },
        {
            name: "Enabled",
            fieldType: "Boolean",
        },
    ]
});
class PubSubConfigurationDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaPubSubConfigurationDataType; }
    static possibleFields = [
        "publishedDataSets",
        "connections",
        "enabled"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15530, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(21154, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(21178, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(21202, 0);
    publishedDataSets;
    connections;
    enabled;
    constructor(options) {
        super(options);
        if (options === null) {
            this.publishedDataSets = null; /* null array */
            this.connections = null; /* null array */
            this.enabled = false;
            return;
        }
        const schema = PubSubConfigurationDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.publishedDataSets = []; // should default
        if (options.publishedDataSets) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.publishedDataSets));
            this.publishedDataSets = options.publishedDataSets.map((e) => new PublishedDataSetDataType(e));
        }
        this.connections = []; // should default
        if (options.connections) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.connections));
            this.connections = options.connections.map((e) => new PubSubConnectionDataType(e));
        }
        this.enabled = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.enabled);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.publishedDataSets, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.connections, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeBoolean)(this.enabled, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.publishedDataSets = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new PublishedDataSetDataType(null);
            obj.decode(stream1);
            return obj;
        });
        this.connections = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new PubSubConnectionDataType(null);
            obj.decode(stream1);
            return obj;
        });
        this.enabled = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.enabled);
    }
    get schema() { return schemaPubSubConfigurationDataType; }
}
exports.PubSubConfigurationDataType = PubSubConfigurationDataType;
PubSubConfigurationDataType.schema.dataTypeNodeId = PubSubConfigurationDataType.dataTypeNodeId;
PubSubConfigurationDataType.schema.encodingDefaultBinary = PubSubConfigurationDataType.encodingDefaultBinary;
PubSubConfigurationDataType.schema.encodingDefaultXml = PubSubConfigurationDataType.encodingDefaultXml;
PubSubConfigurationDataType.schema.encodingDefaultJson = PubSubConfigurationDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(PubSubConfigurationDataType.dataTypeNodeId, "PubSubConfigurationDataType", PubSubConfigurationDataType);
// --------------------------------------------------------------------------------------------
const schemaSubscribedDataSetDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "SubscribedDataSetDataType",
    baseType: "ExtensionObject",
    fields: []
});
class SubscribedDataSetDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaSubscribedDataSetDataType; }
    static possibleFields = [];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15630, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15707, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16010, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16308, 0);
    constructor(options) {
        super(options);
        if (options === null) {
            return;
        }
        const schema = SubscribedDataSetDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    get schema() { return schemaSubscribedDataSetDataType; }
}
exports.SubscribedDataSetDataType = SubscribedDataSetDataType;
SubscribedDataSetDataType.schema.dataTypeNodeId = SubscribedDataSetDataType.dataTypeNodeId;
SubscribedDataSetDataType.schema.encodingDefaultBinary = SubscribedDataSetDataType.encodingDefaultBinary;
SubscribedDataSetDataType.schema.encodingDefaultXml = SubscribedDataSetDataType.encodingDefaultXml;
SubscribedDataSetDataType.schema.encodingDefaultJson = SubscribedDataSetDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(SubscribedDataSetDataType.dataTypeNodeId, "SubscribedDataSetDataType", SubscribedDataSetDataType);
// --------------------------------------------------------------------------------------------
const schemaStandaloneSubscribedDataSetDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "StandaloneSubscribedDataSetDataType",
    baseType: "SubscribedDataSetDataType",
    fields: [
        {
            name: "Name",
            fieldType: "String",
        },
        {
            name: "DataSetFolder",
            fieldType: "String",
            isArray: true
        },
        {
            name: "DataSetMetaData",
            fieldType: "DataSetMetaDataType",
        },
        {
            name: "SubscribedDataSet",
            fieldType: "ExtensionObject",
        },
    ]
});
class StandaloneSubscribedDataSetDataType extends SubscribedDataSetDataType {
    static get schema() { return schemaStandaloneSubscribedDataSetDataType; }
    static possibleFields = [
        "name",
        "dataSetFolder",
        "dataSetMetaData",
        "subscribedDataSet"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23600, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23852, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23920, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23988, 0);
    name;
    dataSetFolder;
    dataSetMetaData;
    subscribedDataSet;
    constructor(options) {
        super(options);
        if (options === null) {
            this.name = null;
            this.dataSetFolder = [];
            this.dataSetMetaData = new DataSetMetaDataType(null);
            this.subscribedDataSet = null;
            return;
        }
        const schema = StandaloneSubscribedDataSetDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.name = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.name);
        this.dataSetFolder = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.dataSetFolder);
        this.dataSetMetaData = new DataSetMetaDataType(options.dataSetMetaData);
        this.subscribedDataSet = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.subscribedDataSet);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.name, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.dataSetFolder, stream, node_opcua_basic_types_1.encodeString);
        this.dataSetMetaData.encode(stream);
        (0, node_opcua_extension_object_1.encodeExtensionObject)(this.subscribedDataSet, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = (0, node_opcua_basic_types_1.decodeString)(stream, this.name);
        this.dataSetFolder = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeString);
        this.dataSetMetaData.decode(stream);
        this.subscribedDataSet = (0, node_opcua_extension_object_1.decodeExtensionObject)(stream, this.subscribedDataSet);
    }
    get schema() { return schemaStandaloneSubscribedDataSetDataType; }
}
exports.StandaloneSubscribedDataSetDataType = StandaloneSubscribedDataSetDataType;
StandaloneSubscribedDataSetDataType.schema.dataTypeNodeId = StandaloneSubscribedDataSetDataType.dataTypeNodeId;
StandaloneSubscribedDataSetDataType.schema.encodingDefaultBinary = StandaloneSubscribedDataSetDataType.encodingDefaultBinary;
StandaloneSubscribedDataSetDataType.schema.encodingDefaultXml = StandaloneSubscribedDataSetDataType.encodingDefaultXml;
StandaloneSubscribedDataSetDataType.schema.encodingDefaultJson = StandaloneSubscribedDataSetDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(StandaloneSubscribedDataSetDataType.dataTypeNodeId, "StandaloneSubscribedDataSetDataType", StandaloneSubscribedDataSetDataType);
// --------------------------------------------------------------------------------------------
var PermissionType;
(function (PermissionType) {
    PermissionType[PermissionType["None"] = 0] = "None";
    PermissionType[PermissionType["Browse"] = 1] = "Browse";
    PermissionType[PermissionType["ReadRolePermissions"] = 2] = "ReadRolePermissions";
    PermissionType[PermissionType["WriteAttribute"] = 4] = "WriteAttribute";
    PermissionType[PermissionType["WriteRolePermissions"] = 8] = "WriteRolePermissions";
    PermissionType[PermissionType["WriteHistorizing"] = 16] = "WriteHistorizing";
    PermissionType[PermissionType["Read"] = 32] = "Read";
    PermissionType[PermissionType["Write"] = 64] = "Write";
    PermissionType[PermissionType["ReadHistory"] = 128] = "ReadHistory";
    PermissionType[PermissionType["InsertHistory"] = 256] = "InsertHistory";
    PermissionType[PermissionType["ModifyHistory"] = 512] = "ModifyHistory";
    PermissionType[PermissionType["DeleteHistory"] = 1024] = "DeleteHistory";
    PermissionType[PermissionType["ReceiveEvents"] = 2048] = "ReceiveEvents";
    PermissionType[PermissionType["Call"] = 4096] = "Call";
    PermissionType[PermissionType["AddReference"] = 8192] = "AddReference";
    PermissionType[PermissionType["RemoveReference"] = 16384] = "RemoveReference";
    PermissionType[PermissionType["DeleteNode"] = 32768] = "DeleteNode";
    PermissionType[PermissionType["AddNode"] = 65536] = "AddNode";
})(PermissionType || (exports.PermissionType = PermissionType = {}));
const schemaPermissionType = {
    enumValues: PermissionType,
    flaggable: true,
    name: "PermissionType"
};
function decodePermissionType(stream, _value) {
    return stream.readUInt32();
}
function encodePermissionType(value, stream) {
    stream.writeUInt32(value);
}
exports._enumerationPermissionType = (0, node_opcua_factory_1.registerEnumeration)(schemaPermissionType);
(0, node_opcua_assert_1.assert)(exports._enumerationPermissionType.isFlaggable === true);
// --------------------------------------------------------------------------------------------
const schemaRolePermissionType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "RolePermissionType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RoleId",
            fieldType: "NodeId",
        },
        {
            name: "Permissions",
            fieldType: "PermissionType",
        },
    ]
});
class RolePermissionType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaRolePermissionType; }
    static possibleFields = [
        "roleId",
        "permissions"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(96, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(128, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16126, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15062, 0);
    roleId;
    permissions;
    constructor(options) {
        super(options);
        if (options === null) {
            this.roleId = new node_opcua_nodeid_1.NodeId(null);
            this.permissions = 0;
            return;
        }
        const schema = RolePermissionType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.roleId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.roleId);
        this.permissions = this.setPermissions((0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.permissions));
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.roleId, stream);
        encodePermissionType(this.permissions, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.roleId = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.roleId);
        this.permissions = decodePermissionType(stream, this.permissions);
    }
    // Define Enumeration setters
    setPermissions(value) {
        const coercedValue = exports._enumerationPermissionType.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to PermissionType :" + value);
        }
        this.permissions = coercedValue.value;
        return this.permissions;
    }
    get schema() { return schemaRolePermissionType; }
}
exports.RolePermissionType = RolePermissionType;
RolePermissionType.schema.dataTypeNodeId = RolePermissionType.dataTypeNodeId;
RolePermissionType.schema.encodingDefaultBinary = RolePermissionType.encodingDefaultBinary;
RolePermissionType.schema.encodingDefaultXml = RolePermissionType.encodingDefaultXml;
RolePermissionType.schema.encodingDefaultJson = RolePermissionType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(RolePermissionType.dataTypeNodeId, "RolePermissionType", RolePermissionType);
// --------------------------------------------------------------------------------------------
const schemaSecurityGroupDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "SecurityGroupDataType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "Name",
            fieldType: "String",
        },
        {
            name: "SecurityGroupFolder",
            fieldType: "String",
            isArray: true
        },
        {
            name: "KeyLifetime",
            fieldType: "Double",
        },
        {
            name: "SecurityPolicyUri",
            fieldType: "String",
        },
        {
            name: "MaxFutureKeyCount",
            fieldType: "UInt32",
        },
        {
            name: "MaxPastKeyCount",
            fieldType: "UInt32",
        },
        {
            name: "SecurityGroupId",
            fieldType: "String",
        },
        {
            name: "RolePermissions",
            fieldType: "RolePermissionType",
            isArray: true
        },
        {
            name: "GroupProperties",
            fieldType: "KeyValuePair",
            isArray: true
        },
    ]
});
class SecurityGroupDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaSecurityGroupDataType; }
    static possibleFields = [
        "name",
        "securityGroupFolder",
        "keyLifetime",
        "securityPolicyUri",
        "maxFutureKeyCount",
        "maxPastKeyCount",
        "securityGroupId",
        "rolePermissions",
        "groupProperties"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23601, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23853, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23921, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23989, 0);
    name;
    securityGroupFolder;
    keyLifetime;
    securityPolicyUri;
    maxFutureKeyCount;
    maxPastKeyCount;
    securityGroupId;
    rolePermissions;
    groupProperties;
    constructor(options) {
        super(options);
        if (options === null) {
            this.name = null;
            this.securityGroupFolder = [];
            this.keyLifetime = 0;
            this.securityPolicyUri = null;
            this.maxFutureKeyCount = 0;
            this.maxPastKeyCount = 0;
            this.securityGroupId = null;
            this.rolePermissions = null; /* null array */
            this.groupProperties = null; /* null array */
            return;
        }
        const schema = SecurityGroupDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.name = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.name);
        this.securityGroupFolder = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.securityGroupFolder);
        this.keyLifetime = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.keyLifetime);
        this.securityPolicyUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.securityPolicyUri);
        this.maxFutureKeyCount = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.maxFutureKeyCount);
        this.maxPastKeyCount = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.maxPastKeyCount);
        this.securityGroupId = (0, node_opcua_factory_1.initialize_field)(schema.fields[6], options?.securityGroupId);
        this.rolePermissions = []; // should default
        if (options.rolePermissions) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.rolePermissions));
            this.rolePermissions = options.rolePermissions.map((e) => new RolePermissionType(e));
        }
        this.groupProperties = []; // should default
        if (options.groupProperties) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.groupProperties));
            this.groupProperties = options.groupProperties.map((e) => new KeyValuePair(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.name, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.securityGroupFolder, stream, node_opcua_basic_types_1.encodeString);
        (0, node_opcua_basic_types_1.encodeDouble)(this.keyLifetime, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.securityPolicyUri, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.maxFutureKeyCount, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.maxPastKeyCount, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.securityGroupId, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.rolePermissions, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.groupProperties, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.name = (0, node_opcua_basic_types_1.decodeString)(stream, this.name);
        this.securityGroupFolder = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeString);
        this.keyLifetime = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.keyLifetime);
        this.securityPolicyUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.securityPolicyUri);
        this.maxFutureKeyCount = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.maxFutureKeyCount);
        this.maxPastKeyCount = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.maxPastKeyCount);
        this.securityGroupId = (0, node_opcua_basic_types_1.decodeString)(stream, this.securityGroupId);
        this.rolePermissions = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new RolePermissionType(null);
            obj.decode(stream1);
            return obj;
        });
        this.groupProperties = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new KeyValuePair(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaSecurityGroupDataType; }
}
exports.SecurityGroupDataType = SecurityGroupDataType;
SecurityGroupDataType.schema.dataTypeNodeId = SecurityGroupDataType.dataTypeNodeId;
SecurityGroupDataType.schema.encodingDefaultBinary = SecurityGroupDataType.encodingDefaultBinary;
SecurityGroupDataType.schema.encodingDefaultXml = SecurityGroupDataType.encodingDefaultXml;
SecurityGroupDataType.schema.encodingDefaultJson = SecurityGroupDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(SecurityGroupDataType.dataTypeNodeId, "SecurityGroupDataType", SecurityGroupDataType);
// --------------------------------------------------------------------------------------------
const schemaPubSubKeyPushTargetDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "PubSubKeyPushTargetDataType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ApplicationUri",
            fieldType: "String",
        },
        {
            name: "PushTargetFolder",
            fieldType: "String",
            isArray: true
        },
        {
            name: "EndpointUrl",
            fieldType: "String",
        },
        {
            name: "SecurityPolicyUri",
            fieldType: "String",
        },
        {
            name: "UserTokenType",
            fieldType: "UserTokenPolicy",
        },
        {
            name: "RequestedKeyCount",
            fieldType: "UInt16",
        },
        {
            name: "RetryInterval",
            fieldType: "Double",
        },
        {
            name: "PushTargetProperties",
            fieldType: "KeyValuePair",
            isArray: true
        },
        {
            name: "SecurityGroups",
            fieldType: "String",
            isArray: true
        },
    ]
});
class PubSubKeyPushTargetDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaPubSubKeyPushTargetDataType; }
    static possibleFields = [
        "applicationUri",
        "pushTargetFolder",
        "endpointUrl",
        "securityPolicyUri",
        "userTokenType",
        "requestedKeyCount",
        "retryInterval",
        "pushTargetProperties",
        "securityGroups"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(25270, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(25530, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(25546, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(25562, 0);
    applicationUri;
    pushTargetFolder;
    endpointUrl;
    securityPolicyUri;
    userTokenType;
    requestedKeyCount;
    retryInterval;
    pushTargetProperties;
    securityGroups;
    constructor(options) {
        super(options);
        if (options === null) {
            this.applicationUri = null;
            this.pushTargetFolder = [];
            this.endpointUrl = null;
            this.securityPolicyUri = null;
            this.userTokenType = new UserTokenPolicy(null);
            this.requestedKeyCount = 0;
            this.retryInterval = 0;
            this.pushTargetProperties = null; /* null array */
            this.securityGroups = [];
            return;
        }
        const schema = PubSubKeyPushTargetDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.applicationUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.applicationUri);
        this.pushTargetFolder = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[1], options?.pushTargetFolder);
        this.endpointUrl = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.endpointUrl);
        this.securityPolicyUri = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.securityPolicyUri);
        this.userTokenType = new UserTokenPolicy(options.userTokenType);
        this.requestedKeyCount = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.requestedKeyCount);
        this.retryInterval = (0, node_opcua_factory_1.initialize_field)(schema.fields[6], options?.retryInterval);
        this.pushTargetProperties = []; // should default
        if (options.pushTargetProperties) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.pushTargetProperties));
            this.pushTargetProperties = options.pushTargetProperties.map((e) => new KeyValuePair(e));
        }
        this.securityGroups = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[8], options?.securityGroups);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.applicationUri, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.pushTargetFolder, stream, node_opcua_basic_types_1.encodeString);
        (0, node_opcua_basic_types_1.encodeString)(this.endpointUrl, stream);
        (0, node_opcua_basic_types_1.encodeString)(this.securityPolicyUri, stream);
        this.userTokenType.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt16)(this.requestedKeyCount, stream);
        (0, node_opcua_basic_types_1.encodeDouble)(this.retryInterval, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.pushTargetProperties, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.securityGroups, stream, node_opcua_basic_types_1.encodeString);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.applicationUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.applicationUri);
        this.pushTargetFolder = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeString);
        this.endpointUrl = (0, node_opcua_basic_types_1.decodeString)(stream, this.endpointUrl);
        this.securityPolicyUri = (0, node_opcua_basic_types_1.decodeString)(stream, this.securityPolicyUri);
        this.userTokenType.decode(stream);
        this.requestedKeyCount = (0, node_opcua_basic_types_1.decodeUInt16)(stream, this.requestedKeyCount);
        this.retryInterval = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.retryInterval);
        this.pushTargetProperties = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new KeyValuePair(null);
            obj.decode(stream1);
            return obj;
        });
        this.securityGroups = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeString);
    }
    get schema() { return schemaPubSubKeyPushTargetDataType; }
}
exports.PubSubKeyPushTargetDataType = PubSubKeyPushTargetDataType;
PubSubKeyPushTargetDataType.schema.dataTypeNodeId = PubSubKeyPushTargetDataType.dataTypeNodeId;
PubSubKeyPushTargetDataType.schema.encodingDefaultBinary = PubSubKeyPushTargetDataType.encodingDefaultBinary;
PubSubKeyPushTargetDataType.schema.encodingDefaultXml = PubSubKeyPushTargetDataType.encodingDefaultXml;
PubSubKeyPushTargetDataType.schema.encodingDefaultJson = PubSubKeyPushTargetDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(PubSubKeyPushTargetDataType.dataTypeNodeId, "PubSubKeyPushTargetDataType", PubSubKeyPushTargetDataType);
// --------------------------------------------------------------------------------------------
const schemaPubSubConfiguration2DataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "PubSubConfiguration2DataType",
    baseType: "PubSubConfigurationDataType",
    fields: [
        {
            name: "SubscribedDataSets",
            fieldType: "StandaloneSubscribedDataSetDataType",
            isArray: true
        },
        {
            name: "DataSetClasses",
            fieldType: "DataSetMetaDataType",
            isArray: true
        },
        {
            name: "DefaultSecurityKeyServices",
            fieldType: "EndpointDescription",
            isArray: true
        },
        {
            name: "SecurityGroups",
            fieldType: "SecurityGroupDataType",
            isArray: true
        },
        {
            name: "PubSubKeyPushTargets",
            fieldType: "PubSubKeyPushTargetDataType",
            isArray: true
        },
        {
            name: "ConfigurationVersion",
            fieldType: "UInt32",
        },
        {
            name: "ConfigurationProperties",
            fieldType: "KeyValuePair",
            isArray: true
        },
    ]
});
class PubSubConfiguration2DataType extends PubSubConfigurationDataType {
    static get schema() { return schemaPubSubConfiguration2DataType; }
    static possibleFields = [
        "publishedDataSets",
        "connections",
        "enabled",
        "subscribedDataSets",
        "dataSetClasses",
        "defaultSecurityKeyServices",
        "securityGroups",
        "pubSubKeyPushTargets",
        "configurationVersion",
        "configurationProperties"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23602, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23854, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23922, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(23990, 0);
    subscribedDataSets;
    dataSetClasses;
    defaultSecurityKeyServices;
    securityGroups;
    pubSubKeyPushTargets;
    configurationVersion;
    configurationProperties;
    constructor(options) {
        super(options);
        if (options === null) {
            this.subscribedDataSets = null; /* null array */
            this.dataSetClasses = null; /* null array */
            this.defaultSecurityKeyServices = null; /* null array */
            this.securityGroups = null; /* null array */
            this.pubSubKeyPushTargets = null; /* null array */
            this.configurationVersion = 0;
            this.configurationProperties = null; /* null array */
            return;
        }
        const schema = PubSubConfiguration2DataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.subscribedDataSets = []; // should default
        if (options.subscribedDataSets) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.subscribedDataSets));
            this.subscribedDataSets = options.subscribedDataSets.map((e) => new StandaloneSubscribedDataSetDataType(e));
        }
        this.dataSetClasses = []; // should default
        if (options.dataSetClasses) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.dataSetClasses));
            this.dataSetClasses = options.dataSetClasses.map((e) => new DataSetMetaDataType(e));
        }
        this.defaultSecurityKeyServices = []; // should default
        if (options.defaultSecurityKeyServices) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.defaultSecurityKeyServices));
            this.defaultSecurityKeyServices = options.defaultSecurityKeyServices.map((e) => new EndpointDescription(e));
        }
        this.securityGroups = []; // should default
        if (options.securityGroups) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.securityGroups));
            this.securityGroups = options.securityGroups.map((e) => new SecurityGroupDataType(e));
        }
        this.pubSubKeyPushTargets = []; // should default
        if (options.pubSubKeyPushTargets) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.pubSubKeyPushTargets));
            this.pubSubKeyPushTargets = options.pubSubKeyPushTargets.map((e) => new PubSubKeyPushTargetDataType(e));
        }
        this.configurationVersion = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.configurationVersion);
        this.configurationProperties = []; // should default
        if (options.configurationProperties) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.configurationProperties));
            this.configurationProperties = options.configurationProperties.map((e) => new KeyValuePair(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.subscribedDataSets, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.dataSetClasses, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.defaultSecurityKeyServices, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.securityGroups, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeArray)(this.pubSubKeyPushTargets, stream, (obj, stream1) => { obj.encode(stream1); });
        (0, node_opcua_basic_types_1.encodeUInt32)(this.configurationVersion, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.configurationProperties, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.subscribedDataSets = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new StandaloneSubscribedDataSetDataType(null);
            obj.decode(stream1);
            return obj;
        });
        this.dataSetClasses = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new DataSetMetaDataType(null);
            obj.decode(stream1);
            return obj;
        });
        this.defaultSecurityKeyServices = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new EndpointDescription(null);
            obj.decode(stream1);
            return obj;
        });
        this.securityGroups = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new SecurityGroupDataType(null);
            obj.decode(stream1);
            return obj;
        });
        this.pubSubKeyPushTargets = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new PubSubKeyPushTargetDataType(null);
            obj.decode(stream1);
            return obj;
        });
        this.configurationVersion = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.configurationVersion);
        this.configurationProperties = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new KeyValuePair(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaPubSubConfiguration2DataType; }
}
exports.PubSubConfiguration2DataType = PubSubConfiguration2DataType;
PubSubConfiguration2DataType.schema.dataTypeNodeId = PubSubConfiguration2DataType.dataTypeNodeId;
PubSubConfiguration2DataType.schema.encodingDefaultBinary = PubSubConfiguration2DataType.encodingDefaultBinary;
PubSubConfiguration2DataType.schema.encodingDefaultXml = PubSubConfiguration2DataType.encodingDefaultXml;
PubSubConfiguration2DataType.schema.encodingDefaultJson = PubSubConfiguration2DataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(PubSubConfiguration2DataType.dataTypeNodeId, "PubSubConfiguration2DataType", PubSubConfiguration2DataType);
// --------------------------------------------------------------------------------------------
var PubSubConfigurationRefMask;
(function (PubSubConfigurationRefMask) {
    PubSubConfigurationRefMask[PubSubConfigurationRefMask["None"] = 0] = "None";
    PubSubConfigurationRefMask[PubSubConfigurationRefMask["ElementAdd"] = 1] = "ElementAdd";
    PubSubConfigurationRefMask[PubSubConfigurationRefMask["ElementMatch"] = 2] = "ElementMatch";
    PubSubConfigurationRefMask[PubSubConfigurationRefMask["ElementModify"] = 4] = "ElementModify";
    PubSubConfigurationRefMask[PubSubConfigurationRefMask["ElementRemove"] = 8] = "ElementRemove";
    PubSubConfigurationRefMask[PubSubConfigurationRefMask["ReferenceWriter"] = 16] = "ReferenceWriter";
    PubSubConfigurationRefMask[PubSubConfigurationRefMask["ReferenceReader"] = 32] = "ReferenceReader";
    PubSubConfigurationRefMask[PubSubConfigurationRefMask["ReferenceWriterGroup"] = 64] = "ReferenceWriterGroup";
    PubSubConfigurationRefMask[PubSubConfigurationRefMask["ReferenceReaderGroup"] = 128] = "ReferenceReaderGroup";
    PubSubConfigurationRefMask[PubSubConfigurationRefMask["ReferenceConnection"] = 256] = "ReferenceConnection";
    PubSubConfigurationRefMask[PubSubConfigurationRefMask["ReferencePubDataset"] = 512] = "ReferencePubDataset";
    PubSubConfigurationRefMask[PubSubConfigurationRefMask["ReferenceSubDataset"] = 1024] = "ReferenceSubDataset";
    PubSubConfigurationRefMask[PubSubConfigurationRefMask["ReferenceSecurityGroup"] = 2048] = "ReferenceSecurityGroup";
    PubSubConfigurationRefMask[PubSubConfigurationRefMask["ReferencePushTarget"] = 4096] = "ReferencePushTarget";
})(PubSubConfigurationRefMask || (exports.PubSubConfigurationRefMask = PubSubConfigurationRefMask = {}));
const schemaPubSubConfigurationRefMask = {
    enumValues: PubSubConfigurationRefMask,
    flaggable: true,
    name: "PubSubConfigurationRefMask"
};
function decodePubSubConfigurationRefMask(stream, _value) {
    return stream.readUInt32();
}
function encodePubSubConfigurationRefMask(value, stream) {
    stream.writeUInt32(value);
}
exports._enumerationPubSubConfigurationRefMask = (0, node_opcua_factory_1.registerEnumeration)(schemaPubSubConfigurationRefMask);
(0, node_opcua_assert_1.assert)(exports._enumerationPubSubConfigurationRefMask.isFlaggable === true);
// --------------------------------------------------------------------------------------------
const schemaPubSubConfigurationRefDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "PubSubConfigurationRefDataType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ConfigurationMask",
            fieldType: "PubSubConfigurationRefMask",
        },
        {
            name: "ElementIndex",
            fieldType: "UInt16",
        },
        {
            name: "ConnectionIndex",
            fieldType: "UInt16",
        },
        {
            name: "GroupIndex",
            fieldType: "UInt16",
        },
    ]
});
class PubSubConfigurationRefDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaPubSubConfigurationRefDataType; }
    static possibleFields = [
        "configurationMask",
        "elementIndex",
        "connectionIndex",
        "groupIndex"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(25519, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(25531, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(25547, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(25563, 0);
    configurationMask;
    elementIndex;
    connectionIndex;
    groupIndex;
    constructor(options) {
        super(options);
        if (options === null) {
            this.configurationMask = 0;
            this.elementIndex = 0;
            this.connectionIndex = 0;
            this.groupIndex = 0;
            return;
        }
        const schema = PubSubConfigurationRefDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.configurationMask = this.setConfigurationMask((0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.configurationMask));
        this.elementIndex = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.elementIndex);
        this.connectionIndex = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.connectionIndex);
        this.groupIndex = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.groupIndex);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        encodePubSubConfigurationRefMask(this.configurationMask, stream);
        (0, node_opcua_basic_types_1.encodeUInt16)(this.elementIndex, stream);
        (0, node_opcua_basic_types_1.encodeUInt16)(this.connectionIndex, stream);
        (0, node_opcua_basic_types_1.encodeUInt16)(this.groupIndex, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.configurationMask = decodePubSubConfigurationRefMask(stream, this.configurationMask);
        this.elementIndex = (0, node_opcua_basic_types_1.decodeUInt16)(stream, this.elementIndex);
        this.connectionIndex = (0, node_opcua_basic_types_1.decodeUInt16)(stream, this.connectionIndex);
        this.groupIndex = (0, node_opcua_basic_types_1.decodeUInt16)(stream, this.groupIndex);
    }
    // Define Enumeration setters
    setConfigurationMask(value) {
        const coercedValue = exports._enumerationPubSubConfigurationRefMask.get(value);
        /* istanbul ignore next */
        if (coercedValue === undefined || coercedValue === null) {
            throw new Error("value cannot be coerced to PubSubConfigurationRefMask :" + value);
        }
        this.configurationMask = coercedValue.value;
        return this.configurationMask;
    }
    get schema() { return schemaPubSubConfigurationRefDataType; }
}
exports.PubSubConfigurationRefDataType = PubSubConfigurationRefDataType;
PubSubConfigurationRefDataType.schema.dataTypeNodeId = PubSubConfigurationRefDataType.dataTypeNodeId;
PubSubConfigurationRefDataType.schema.encodingDefaultBinary = PubSubConfigurationRefDataType.encodingDefaultBinary;
PubSubConfigurationRefDataType.schema.encodingDefaultXml = PubSubConfigurationRefDataType.encodingDefaultXml;
PubSubConfigurationRefDataType.schema.encodingDefaultJson = PubSubConfigurationRefDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(PubSubConfigurationRefDataType.dataTypeNodeId, "PubSubConfigurationRefDataType", PubSubConfigurationRefDataType);
// --------------------------------------------------------------------------------------------
const schemaPubSubConfigurationValueDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "PubSubConfigurationValueDataType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ConfigurationElement",
            fieldType: "PubSubConfigurationRefDataType",
        },
        {
            name: "Name",
            fieldType: "String",
        },
        {
            name: "Identifier",
            fieldType: "Variant",
        },
    ]
});
class PubSubConfigurationValueDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaPubSubConfigurationValueDataType; }
    static possibleFields = [
        "configurationElement",
        "name",
        "identifier"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(25520, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(25532, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(25548, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(25564, 0);
    configurationElement;
    name;
    identifier;
    constructor(options) {
        super(options);
        if (options === null) {
            this.configurationElement = new PubSubConfigurationRefDataType(null);
            this.name = null;
            this.identifier = new node_opcua_variant_1.Variant(null);
            return;
        }
        const schema = PubSubConfigurationValueDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.configurationElement = new PubSubConfigurationRefDataType(options.configurationElement);
        this.name = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.name);
        this.identifier = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.identifier);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.configurationElement.encode(stream);
        (0, node_opcua_basic_types_1.encodeString)(this.name, stream);
        (0, node_opcua_variant_1.encodeVariant)(this.identifier, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.configurationElement.decode(stream);
        this.name = (0, node_opcua_basic_types_1.decodeString)(stream, this.name);
        this.identifier = (0, node_opcua_variant_1.decodeVariant)(stream, this.identifier);
    }
    get schema() { return schemaPubSubConfigurationValueDataType; }
}
exports.PubSubConfigurationValueDataType = PubSubConfigurationValueDataType;
PubSubConfigurationValueDataType.schema.dataTypeNodeId = PubSubConfigurationValueDataType.dataTypeNodeId;
PubSubConfigurationValueDataType.schema.encodingDefaultBinary = PubSubConfigurationValueDataType.encodingDefaultBinary;
PubSubConfigurationValueDataType.schema.encodingDefaultXml = PubSubConfigurationValueDataType.encodingDefaultXml;
PubSubConfigurationValueDataType.schema.encodingDefaultJson = PubSubConfigurationValueDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(PubSubConfigurationValueDataType.dataTypeNodeId, "PubSubConfigurationValueDataType", PubSubConfigurationValueDataType);
// --------------------------------------------------------------------------------------------
const schemaSubscriptionAcknowledgement = (0, node_opcua_factory_1.buildStructuredType)({
    name: "SubscriptionAcknowledgement",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "SubscriptionId",
            fieldType: "UInt32",
        },
        {
            name: "SequenceNumber",
            fieldType: "UInt32",
        },
    ]
});
class SubscriptionAcknowledgement extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaSubscriptionAcknowledgement; }
    static possibleFields = [
        "subscriptionId",
        "sequenceNumber"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(821, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(823, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(822, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15351, 0);
    subscriptionId;
    sequenceNumber;
    constructor(options) {
        super(options);
        if (options === null) {
            this.subscriptionId = 0;
            this.sequenceNumber = 0;
            return;
        }
        const schema = SubscriptionAcknowledgement.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.subscriptionId = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.subscriptionId);
        this.sequenceNumber = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.sequenceNumber);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.subscriptionId, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.sequenceNumber, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.subscriptionId = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.subscriptionId);
        this.sequenceNumber = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.sequenceNumber);
    }
    get schema() { return schemaSubscriptionAcknowledgement; }
}
exports.SubscriptionAcknowledgement = SubscriptionAcknowledgement;
SubscriptionAcknowledgement.schema.dataTypeNodeId = SubscriptionAcknowledgement.dataTypeNodeId;
SubscriptionAcknowledgement.schema.encodingDefaultBinary = SubscriptionAcknowledgement.encodingDefaultBinary;
SubscriptionAcknowledgement.schema.encodingDefaultXml = SubscriptionAcknowledgement.encodingDefaultXml;
SubscriptionAcknowledgement.schema.encodingDefaultJson = SubscriptionAcknowledgement.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(SubscriptionAcknowledgement.dataTypeNodeId, "SubscriptionAcknowledgement", SubscriptionAcknowledgement);
// --------------------------------------------------------------------------------------------
const schemaPublishRequest = (0, node_opcua_factory_1.buildStructuredType)({
    name: "PublishRequest",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "RequestHeader",
            fieldType: "RequestHeader",
        },
        {
            name: "SubscriptionAcknowledgements",
            fieldType: "SubscriptionAcknowledgement",
            isArray: true
        },
    ]
});
class PublishRequest extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaPublishRequest; }
    static possibleFields = [
        "requestHeader",
        "subscriptionAcknowledgements"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(824, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(826, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(825, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15352, 0);
    requestHeader;
    subscriptionAcknowledgements;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestHeader = new RequestHeader(null);
            this.subscriptionAcknowledgements = null; /* null array */
            return;
        }
        const schema = PublishRequest.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestHeader = new RequestHeader(options.requestHeader);
        this.subscriptionAcknowledgements = []; // should default
        if (options.subscriptionAcknowledgements) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.subscriptionAcknowledgements));
            this.subscriptionAcknowledgements = options.subscriptionAcknowledgements.map((e) => new SubscriptionAcknowledgement(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.subscriptionAcknowledgements, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestHeader.decode(stream);
        this.subscriptionAcknowledgements = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new SubscriptionAcknowledgement(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaPublishRequest; }
}
exports.PublishRequest = PublishRequest;
PublishRequest.schema.dataTypeNodeId = PublishRequest.dataTypeNodeId;
PublishRequest.schema.encodingDefaultBinary = PublishRequest.encodingDefaultBinary;
PublishRequest.schema.encodingDefaultXml = PublishRequest.encodingDefaultXml;
PublishRequest.schema.encodingDefaultJson = PublishRequest.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(PublishRequest.dataTypeNodeId, "PublishRequest", PublishRequest);
// --------------------------------------------------------------------------------------------
const schemaPublishResponse = (0, node_opcua_factory_1.buildStructuredType)({
    name: "PublishResponse",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "ResponseHeader",
            fieldType: "ResponseHeader",
        },
        {
            name: "SubscriptionId",
            fieldType: "UInt32",
        },
        {
            name: "AvailableSequenceNumbers",
            fieldType: "UInt32",
            isArray: true
        },
        {
            name: "MoreNotifications",
            fieldType: "Boolean",
        },
        {
            name: "NotificationMessage",
            fieldType: "NotificationMessage",
        },
        {
            name: "Results",
            fieldType: "StatusCode",
            isArray: true
        },
        {
            name: "DiagnosticInfos",
            fieldType: "DiagnosticInfo",
            isArray: true
        },
    ]
});
class PublishResponse extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaPublishResponse; }
    static possibleFields = [
        "responseHeader",
        "subscriptionId",
        "availableSequenceNumbers",
        "moreNotifications",
        "notificationMessage",
        "results",
        "diagnosticInfos"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(827, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(829, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(828, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15353, 0);
    responseHeader;
    subscriptionId;
    availableSequenceNumbers;
    moreNotifications;
    notificationMessage;
    results;
    diagnosticInfos;
    constructor(options) {
        super(options);
        if (options === null) {
            this.responseHeader = new ResponseHeader(null);
            this.subscriptionId = 0;
            this.availableSequenceNumbers = [];
            this.moreNotifications = false;
            this.notificationMessage = new NotificationMessage(null);
            this.results = [];
            this.diagnosticInfos = [];
            return;
        }
        const schema = PublishResponse.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.responseHeader = new ResponseHeader(options.responseHeader);
        this.subscriptionId = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.subscriptionId);
        this.availableSequenceNumbers = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[2], options?.availableSequenceNumbers);
        this.moreNotifications = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.moreNotifications);
        this.notificationMessage = new NotificationMessage(options.notificationMessage);
        this.results = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[5], options?.results);
        this.diagnosticInfos = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[6], options?.diagnosticInfos);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.responseHeader.encode(stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.subscriptionId, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.availableSequenceNumbers, stream, node_opcua_basic_types_1.encodeUInt32);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.moreNotifications, stream);
        this.notificationMessage.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.results, stream, node_opcua_status_code_1.encodeStatusCode);
        (0, node_opcua_basic_types_1.encodeArray)(this.diagnosticInfos, stream, node_opcua_data_model_1.encodeDiagnosticInfo);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.responseHeader.decode(stream);
        this.subscriptionId = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.subscriptionId);
        this.availableSequenceNumbers = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_basic_types_1.decodeUInt32);
        this.moreNotifications = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.moreNotifications);
        this.notificationMessage.decode(stream);
        this.results = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_status_code_1.decodeStatusCode);
        this.diagnosticInfos = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_data_model_1.decodeDiagnosticInfo);
    }
    get schema() { return schemaPublishResponse; }
}
exports.PublishResponse = PublishResponse;
PublishResponse.schema.dataTypeNodeId = PublishResponse.dataTypeNodeId;
PublishResponse.schema.encodingDefaultBinary = PublishResponse.encodingDefaultBinary;
PublishResponse.schema.encodingDefaultXml = PublishResponse.encodingDefaultXml;
PublishResponse.schema.encodingDefaultJson = PublishResponse.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(PublishResponse.dataTypeNodeId, "PublishResponse", PublishResponse);
// --------------------------------------------------------------------------------------------
const schemaPublishedDataSetSourceDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "PublishedDataSetSourceDataType",
    baseType: "ExtensionObject",
    fields: []
});
class PublishedDataSetSourceDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaPublishedDataSetSourceDataType; }
    static possibleFields = [];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15580, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15678, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15952, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16153, 0);
    constructor(options) {
        super(options);
        if (options === null) {
            return;
        }
        const schema = PublishedDataSetSourceDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
    }
    get schema() { return schemaPublishedDataSetSourceDataType; }
}
exports.PublishedDataSetSourceDataType = PublishedDataSetSourceDataType;
PublishedDataSetSourceDataType.schema.dataTypeNodeId = PublishedDataSetSourceDataType.dataTypeNodeId;
PublishedDataSetSourceDataType.schema.encodingDefaultBinary = PublishedDataSetSourceDataType.encodingDefaultBinary;
PublishedDataSetSourceDataType.schema.encodingDefaultXml = PublishedDataSetSourceDataType.encodingDefaultXml;
PublishedDataSetSourceDataType.schema.encodingDefaultJson = PublishedDataSetSourceDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(PublishedDataSetSourceDataType.dataTypeNodeId, "PublishedDataSetSourceDataType", PublishedDataSetSourceDataType);
// --------------------------------------------------------------------------------------------
const schemaPublishedActionDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "PublishedActionDataType",
    baseType: "PublishedDataSetSourceDataType",
    fields: [
        {
            name: "RequestDataSetMetaData",
            fieldType: "DataSetMetaDataType",
        },
        {
            name: "ActionTargets",
            fieldType: "ActionTargetDataType",
            isArray: true
        },
    ]
});
class PublishedActionDataType extends PublishedDataSetSourceDataType {
    static get schema() { return schemaPublishedActionDataType; }
    static possibleFields = [
        "requestDataSetMetaData",
        "actionTargets"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    requestDataSetMetaData;
    actionTargets;
    constructor(options) {
        super(options);
        if (options === null) {
            this.requestDataSetMetaData = new DataSetMetaDataType(null);
            this.actionTargets = null; /* null array */
            return;
        }
        const schema = PublishedActionDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.requestDataSetMetaData = new DataSetMetaDataType(options.requestDataSetMetaData);
        this.actionTargets = []; // should default
        if (options.actionTargets) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.actionTargets));
            this.actionTargets = options.actionTargets.map((e) => new ActionTargetDataType(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        this.requestDataSetMetaData.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.actionTargets, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.requestDataSetMetaData.decode(stream);
        this.actionTargets = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new ActionTargetDataType(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaPublishedActionDataType; }
}
exports.PublishedActionDataType = PublishedActionDataType;
PublishedActionDataType.schema.dataTypeNodeId = PublishedActionDataType.dataTypeNodeId;
PublishedActionDataType.schema.encodingDefaultBinary = PublishedActionDataType.encodingDefaultBinary;
PublishedActionDataType.schema.encodingDefaultXml = PublishedActionDataType.encodingDefaultXml;
PublishedActionDataType.schema.encodingDefaultJson = PublishedActionDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(PublishedActionDataType.dataTypeNodeId, "PublishedActionDataType", PublishedActionDataType);
// --------------------------------------------------------------------------------------------
const schemaPublishedActionMethodDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "PublishedActionMethodDataType",
    baseType: "PublishedActionDataType",
    fields: [
        {
            name: "ActionMethods",
            fieldType: "ActionMethodDataType",
            isArray: true
        },
    ]
});
class PublishedActionMethodDataType extends PublishedActionDataType {
    static get schema() { return schemaPublishedActionMethodDataType; }
    static possibleFields = [
        "requestDataSetMetaData",
        "actionTargets",
        "actionMethods"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(0, 0);
    actionMethods;
    constructor(options) {
        super(options);
        if (options === null) {
            this.actionMethods = null; /* null array */
            return;
        }
        const schema = PublishedActionMethodDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.actionMethods = []; // should default
        if (options.actionMethods) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.actionMethods));
            this.actionMethods = options.actionMethods.map((e) => new ActionMethodDataType(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.actionMethods, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.actionMethods = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new ActionMethodDataType(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaPublishedActionMethodDataType; }
}
exports.PublishedActionMethodDataType = PublishedActionMethodDataType;
PublishedActionMethodDataType.schema.dataTypeNodeId = PublishedActionMethodDataType.dataTypeNodeId;
PublishedActionMethodDataType.schema.encodingDefaultBinary = PublishedActionMethodDataType.encodingDefaultBinary;
PublishedActionMethodDataType.schema.encodingDefaultXml = PublishedActionMethodDataType.encodingDefaultXml;
PublishedActionMethodDataType.schema.encodingDefaultJson = PublishedActionMethodDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(PublishedActionMethodDataType.dataTypeNodeId, "PublishedActionMethodDataType", PublishedActionMethodDataType);
// --------------------------------------------------------------------------------------------
const schemaPublishedVariableDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "PublishedVariableDataType",
    baseType: "ExtensionObject",
    fields: [
        {
            name: "PublishedVariable",
            fieldType: "NodeId",
        },
        {
            name: "AttributeId",
            fieldType: "UInt32",
        },
        {
            name: "SamplingIntervalHint",
            fieldType: "Double",
        },
        {
            name: "DeadbandType",
            fieldType: "UInt32",
        },
        {
            name: "DeadbandValue",
            fieldType: "Double",
        },
        {
            name: "IndexRange",
            fieldType: "NumericRange",
        },
        {
            name: "SubstituteValue",
            fieldType: "Variant",
        },
        {
            name: "MetaDataProperties",
            fieldType: "QualifiedName",
            isArray: true
        },
    ]
});
class PublishedVariableDataType extends node_opcua_extension_object_1.ExtensionObject {
    static get schema() { return schemaPublishedVariableDataType; }
    static possibleFields = [
        "publishedVariable",
        "attributeId",
        "samplingIntervalHint",
        "deadbandType",
        "deadbandValue",
        "indexRange",
        "substituteValue",
        "metaDataProperties"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14273, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14323, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(14319, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15060, 0);
    publishedVariable;
    attributeId;
    samplingIntervalHint;
    deadbandType;
    deadbandValue;
    indexRange;
    substituteValue;
    metaDataProperties;
    constructor(options) {
        super(options);
        if (options === null) {
            this.publishedVariable = new node_opcua_nodeid_1.NodeId(null);
            this.attributeId = 0;
            this.samplingIntervalHint = 0;
            this.deadbandType = 0;
            this.deadbandValue = 0;
            this.indexRange = new node_opcua_numeric_range_1.NumericRange(null);
            this.substituteValue = new node_opcua_variant_1.Variant(null);
            this.metaDataProperties = [];
            return;
        }
        const schema = PublishedVariableDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.publishedVariable = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.publishedVariable);
        this.attributeId = (0, node_opcua_factory_1.initialize_field)(schema.fields[1], options?.attributeId);
        this.samplingIntervalHint = (0, node_opcua_factory_1.initialize_field)(schema.fields[2], options?.samplingIntervalHint);
        this.deadbandType = (0, node_opcua_factory_1.initialize_field)(schema.fields[3], options?.deadbandType);
        this.deadbandValue = (0, node_opcua_factory_1.initialize_field)(schema.fields[4], options?.deadbandValue);
        this.indexRange = (0, node_opcua_factory_1.initialize_field)(schema.fields[5], options?.indexRange);
        this.substituteValue = (0, node_opcua_factory_1.initialize_field)(schema.fields[6], options?.substituteValue);
        this.metaDataProperties = (0, node_opcua_factory_1.initialize_field_array)(schema.fields[7], options?.metaDataProperties);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeNodeId)(this.publishedVariable, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.attributeId, stream);
        (0, node_opcua_basic_types_1.encodeDouble)(this.samplingIntervalHint, stream);
        (0, node_opcua_basic_types_1.encodeUInt32)(this.deadbandType, stream);
        (0, node_opcua_basic_types_1.encodeDouble)(this.deadbandValue, stream);
        (0, node_opcua_numeric_range_1.encodeNumericRange)(this.indexRange, stream);
        (0, node_opcua_variant_1.encodeVariant)(this.substituteValue, stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.metaDataProperties, stream, node_opcua_data_model_1.encodeQualifiedName);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.publishedVariable = (0, node_opcua_basic_types_1.decodeNodeId)(stream, this.publishedVariable);
        this.attributeId = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.attributeId);
        this.samplingIntervalHint = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.samplingIntervalHint);
        this.deadbandType = (0, node_opcua_basic_types_1.decodeUInt32)(stream, this.deadbandType);
        this.deadbandValue = (0, node_opcua_basic_types_1.decodeDouble)(stream, this.deadbandValue);
        this.indexRange = (0, node_opcua_numeric_range_1.decodeNumericRange)(stream, this.indexRange);
        this.substituteValue = (0, node_opcua_variant_1.decodeVariant)(stream, this.substituteValue);
        this.metaDataProperties = (0, node_opcua_basic_types_1.decodeArray)(stream, node_opcua_data_model_1.decodeQualifiedName);
    }
    get schema() { return schemaPublishedVariableDataType; }
}
exports.PublishedVariableDataType = PublishedVariableDataType;
PublishedVariableDataType.schema.dataTypeNodeId = PublishedVariableDataType.dataTypeNodeId;
PublishedVariableDataType.schema.encodingDefaultBinary = PublishedVariableDataType.encodingDefaultBinary;
PublishedVariableDataType.schema.encodingDefaultXml = PublishedVariableDataType.encodingDefaultXml;
PublishedVariableDataType.schema.encodingDefaultJson = PublishedVariableDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(PublishedVariableDataType.dataTypeNodeId, "PublishedVariableDataType", PublishedVariableDataType);
// --------------------------------------------------------------------------------------------
const schemaPublishedDataItemsDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "PublishedDataItemsDataType",
    baseType: "PublishedDataSetSourceDataType",
    fields: [
        {
            name: "PublishedData",
            fieldType: "PublishedVariableDataType",
            isArray: true
        },
    ]
});
class PublishedDataItemsDataType extends PublishedDataSetSourceDataType {
    static get schema() { return schemaPublishedDataItemsDataType; }
    static possibleFields = [
        "publishedData"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15581, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15679, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(15953, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(16154, 0);
    publishedData;
    constructor(options) {
        super(options);
        if (options === null) {
            this.publishedData = null; /* null array */
            return;
        }
        const schema = PublishedDataItemsDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.publishedData = []; // should default
        if (options.publishedData) {
            (0, node_opcua_assert_1.assert)(Array.isArray(options.publishedData));
            this.publishedData = options.publishedData.map((e) => new PublishedVariableDataType(e));
        }
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeArray)(this.publishedData, stream, (obj, stream1) => { obj.encode(stream1); });
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.publishedData = (0, node_opcua_basic_types_1.decodeArray)(stream, (stream1) => {
            const obj = new PublishedVariableDataType(null);
            obj.decode(stream1);
            return obj;
        });
    }
    get schema() { return schemaPublishedDataItemsDataType; }
}
exports.PublishedDataItemsDataType = PublishedDataItemsDataType;
PublishedDataItemsDataType.schema.dataTypeNodeId = PublishedDataItemsDataType.dataTypeNodeId;
PublishedDataItemsDataType.schema.encodingDefaultBinary = PublishedDataItemsDataType.encodingDefaultBinary;
PublishedDataItemsDataType.schema.encodingDefaultXml = PublishedDataItemsDataType.encodingDefaultXml;
PublishedDataItemsDataType.schema.encodingDefaultJson = PublishedDataItemsDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(PublishedDataItemsDataType.dataTypeNodeId, "PublishedDataItemsDataType", PublishedDataItemsDataType);
// --------------------------------------------------------------------------------------------
const schemaPublishedDataSetCustomSourceDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "PublishedDataSetCustomSourceDataType",
    baseType: "PublishedDataSetSourceDataType",
    fields: [
        {
            name: "CyclicDataSet",
            fieldType: "Boolean",
        },
    ]
});
class PublishedDataSetCustomSourceDataType extends PublishedDataSetSourceDataType {
    static get schema() { return schemaPublishedDataSetCustomSourceDataType; }
    static possibleFields = [
        "cyclicDataSet"
    ];
    static dataTypeNodeId = (0, node_opcua_nodeid_1.makeExpandedNodeId)(25269, 0);
    static encodingDefaultBinary = (0, node_opcua_nodeid_1.makeExpandedNodeId)(25529, 0);
    static encodingDefaultXml = (0, node_opcua_nodeid_1.makeExpandedNodeId)(25545, 0);
    static encodingDefaultJson = (0, node_opcua_nodeid_1.makeExpandedNodeId)(25561, 0);
    cyclicDataSet;
    constructor(options) {
        super(options);
        if (options === null) {
            this.cyclicDataSet = false;
            return;
        }
        const schema = PublishedDataSetCustomSourceDataType.schema;
        options = (schema.constructHook ? schema.constructHook(options) : options) || {};
        /* istanbul ignore next */
        if (node_opcua_factory_1.parameters.debugSchemaHelper) {
            (0, node_opcua_factory_1.check_options_correctness_against_schema)(this, schema, options);
        }
        this.cyclicDataSet = (0, node_opcua_factory_1.initialize_field)(schema.fields[0], options?.cyclicDataSet);
    }
    encode(stream) {
        /* NEEDED */ super.encode(stream);
        (0, node_opcua_basic_types_1.encodeBoolean)(this.cyclicDataSet, stream);
    }
    decode(stream) {
        // call base class implementation first
        /* NEEDED !!! */ super.decode(stream);
        this.cyclicDataSet = (0, node_opcua_basic_types_1.decodeBoolean)(stream, this.cyclicDataSet);
    }
    get schema() { return schemaPublishedDataSetCustomSourceDataType; }
}
exports.PublishedDataSetCustomSourceDataType = PublishedDataSetCustomSourceDataType;
PublishedDataSetCustomSourceDataType.schema.dataTypeNodeId = PublishedDataSetCustomSourceDataType.dataTypeNodeId;
PublishedDataSetCustomSourceDataType.schema.encodingDefaultBinary = PublishedDataSetCustomSourceDataType.encodingDefaultBinary;
PublishedDataSetCustomSourceDataType.schema.encodingDefaultXml = PublishedDataSetCustomSourceDataType.encodingDefaultXml;
PublishedDataSetCustomSourceDataType.schema.encodingDefaultJson = PublishedDataSetCustomSourceDataType.encodingDefaultJson;
(0, node_opcua_factory_1.registerClassDefinition)(PublishedDataSetCustomSourceDataType.dataTypeNodeId, "PublishedDataSetCustomSourceDataType", PublishedDataSetCustomSourceDataType);
// --------------------------------------------------------------------------------------------
const schemaPublishedEventsDataType = (0, node_opcua_factory_1.buildStructuredType)({
    name: "PublishedEventsDataType",
    baseType: "PublishedDataSetSourceDataType",
    fields: [
        {
            name: "EventNotifier",
            fieldType: "NodeId",
        },
        {
            name: "SelectedFields",
            fieldType: "SimpleAttributeOperand",
            isArray: true
        },
        {
            name: "Filter",
            fieldType: "ContentFilter"