import { EventEmitter } from "events";
import net from "net";
import { ISocketLike } from "../source";
export declare class FakeServer extends EventEmitter {
    port: number;
    url: string;
    tcpServer: net.Server;
    protected _serverSocket?: net.Socket;
    private _responses?;
    constructor({ port }: {
        port: number;
    });
    getSocket(): ISocketLike;
    initialize(done: () => void): void;
    shutdown(callback: (err?: Error) => void): void;
    popResponse(): ((socket: net.Socket, data: Buffer) => void) | null;
    pushResponse(func: (socket: net.Socket, data: Buffer) => void): void;
}
