import { RelativePath, RelativePathElement } from "node-opcua-types";
export declare function unescape(str: string): string;
export declare function escape(str: string): string;
export interface RelativePathEx extends RelativePath {
    elements: RelativePathElement[];
}
/**
 * construct a RelativePath from a string containing the relative path description.
 * The string must comply to the OPCUA BNF for RelativePath ( see part 4 - Annex A)

 * @param str {String}
 * @param addressSpace {AddressSpace}
 * @return {RelativePath}
 *
 * @example:
 *
 *      var relativePath = makeRelativePath("/Server.ServerStatus.CurrentTime");
 *
 */
export declare function makeRelativePath(str: string, addressSpace?: any): RelativePathEx;
