"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeBrowsePath = makeBrowsePath;
/**
 * @module node-opcua-service-translate-browse-path
 */
const node_opcua_nodeid_1 = require("node-opcua-nodeid");
const node_opcua_types_1 = require("node-opcua-types");
const make_relative_path_1 = require("./make_relative_path");
function _get_nodeId(node) {
    if (Object.prototype.hasOwnProperty.call(node, "nodeId")) {
        return node.nodeId;
    }
    return (0, node_opcua_nodeid_1.resolveNodeId)(node);
}
function makeBrowsePath(rootNode, relativePathBNF) {
    return new node_opcua_types_1.BrowsePath({
        startingNode: _get_nodeId(rootNode),
        relativePath: (0, make_relative_path_1.makeRelativePath)(relativePathBNF)
    });
}
//# sourceMappingURL=make_browse_path.js.map