import { Variant } from "node-opcua-variant";
export declare enum DeadbandType {
    None = 0,
    Absolute = 1,
    Percent = 2,
    Invalid = 4096
}
export type NumberType = number | number[];
export interface PseudoRange {
    low: number;
    high: number;
}
/**

 * @return true if the element is in deadBand
 */
export declare function isOutsideDeadbandNone(variant1: Variant, variant2: Variant): boolean;
/**

 * @return true if the element is in deadBand
 */
export declare function isOutsideDeadbandAbsolute(variant1: Variant, variant2: Variant, deadbandValue: number): boolean;
/**

 * @return true if the element is outside deadBand
 */
export declare function isOutsideDeadbandPercent(variant1: Variant, variant2: Variant, deadbandValuePercent: number, range: PseudoRange): boolean;
