"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ofType = ofType;
exports.l = l;
exports.n = n;
exports.s = s;
exports.or = or;
exports.and = and;
exports.lessThan = lessThan;
exports.LessThanOrEqual = LessThanOrEqual;
exports.greaterThanOrEqual = greaterThanOrEqual;
exports.greaterThan = greaterThan;
exports.inList = inList;
exports.makeContentFilterElements = makeContentFilterElements;
exports.makeContentFilter = makeContentFilter;
/**
 * @module node-opcua-service-filter
 */
const node_opcua_basic_types_1 = require("node-opcua-basic-types");
const node_opcua_data_model_1 = require("node-opcua-data-model");
const node_opcua_nodeid_1 = require("node-opcua-nodeid");
const node_opcua_variant_1 = require("node-opcua-variant");
const imports_1 = require("./imports");
function ofType(nodeId) {
    const element = new imports_1.ContentFilterElement({
        filterOperator: imports_1.FilterOperator.OfType,
        filterOperands: [
            new imports_1.LiteralOperand({
                value: {
                    dataType: node_opcua_basic_types_1.DataType.NodeId,
                    value: (0, node_opcua_nodeid_1.resolveNodeId)(nodeId)
                }
            })
        ]
    });
    return element;
}
function l(dataType, value) {
    switch (dataType) {
        case node_opcua_basic_types_1.DataType.NodeId:
            value = (0, node_opcua_nodeid_1.resolveNodeId)(value);
    }
    return new imports_1.LiteralOperand({ value: new node_opcua_variant_1.Variant({ dataType, value }) });
}
function n(n) {
    return l(node_opcua_basic_types_1.DataType.NodeId, n);
}
function s(attributeId, path) {
    return new imports_1.SimpleAttributeOperand({
        attributeId: attributeId,
        browsePath: path.split(".").map(node_opcua_data_model_1.coerceQualifiedName)
    });
}
function or(a, b) {
    return new imports_1.ContentFilterElement({
        filterOperands: [a, b],
        filterOperator: imports_1.FilterOperator.Or
    });
}
function and(a, b) {
    return new imports_1.ContentFilterElement({
        filterOperands: [a, b],
        filterOperator: imports_1.FilterOperator.And
    });
}
function lessThan(a, b) {
    return new imports_1.ContentFilterElement({
        filterOperands: [a, b],
        filterOperator: imports_1.FilterOperator.LessThan
    });
}
function LessThanOrEqual(a, b) {
    return new imports_1.ContentFilterElement({
        filterOperands: [a, b],
        filterOperator: imports_1.FilterOperator.LessThanOrEqual
    });
}
function greaterThanOrEqual(a, b) {
    return new imports_1.ContentFilterElement({
        filterOperands: [a, b],
        filterOperator: imports_1.FilterOperator.GreaterThanOrEqual
    });
}
function greaterThan(a, b) {
    return new imports_1.ContentFilterElement({
        filterOperands: [a, b],
        filterOperator: imports_1.FilterOperator.GreaterThan
    });
}
function inList(a, l) {
    return new imports_1.ContentFilterElement({
        filterOperands: [a, ...l],
        filterOperator: imports_1.FilterOperator.InList
    });
}
function makeContentFilterElements(o) {
    const elements = [];
    function pushElement(element) {
        elements.push(element);
        const thisIndex = elements.length - 1;
        if (element.filterOperands) {
            for (let i = 0; i < element.filterOperands.length; i++) {
                const op = element.filterOperands[i];
                if (op instanceof imports_1.ContentFilterElement) {
                    const index = pushElement(op);
                    element.filterOperands[i] = new imports_1.ElementOperand({ index });
                }
            }
        }
        return thisIndex;
    }
    pushElement(o);
    return elements;
}
function makeContentFilter(o) {
    return new imports_1.ContentFilter({
        elements: makeContentFilterElements(o instanceof imports_1.ContentFilterElement ? o : new imports_1.ContentFilterElement(o))
    });
}
//# sourceMappingURL=make_content_filter.js.map