"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractEventField = extractEventField;
exports.extractEventFieldsBase = extractEventFieldsBase;
const node_opcua_assert_1 = require("node-opcua-assert");
const node_opcua_data_model_1 = require("node-opcua-data-model");
const node_opcua_debug_1 = require("node-opcua-debug");
const node_opcua_nodeid_1 = require("node-opcua-nodeid");
const node_opcua_types_1 = require("node-opcua-types");
const node_opcua_variant_1 = require("node-opcua-variant");
const resolve_operand_1 = require("./resolve_operand");
const warningLog = (0, node_opcua_debug_1.make_warningLog)("FILTER");
const conditionTypeNodeId = (0, node_opcua_nodeid_1.resolveNodeId)("ConditionType");
/**
 *
 * extract a eventField from a event node, matching the given selectClause
 */
function extractEventField(context, operand) {
    (0, node_opcua_assert_1.assert)(operand instanceof node_opcua_types_1.SimpleAttributeOperand);
    operand.browsePath = operand.browsePath || [];
    if (operand.browsePath.length === 0 && operand.attributeId === node_opcua_data_model_1.AttributeIds.NodeId) {
        // "ns=0;i=2782" => ConditionType
        // "ns=0;i=2041" => BaseEventType
        if (!(0, node_opcua_nodeid_1.sameNodeId)(operand.typeDefinitionId, conditionTypeNodeId)) {
            // not a ConditionType
            // but could be on of its derived type. for instance ns=0;i=2881 => AcknowledgeableConditionType
            if (!context.isSubtypeOf(operand.typeDefinitionId, conditionTypeNodeId)) {
                warningLog(" ", operand.typeDefinitionId.toString());
                warningLog("this case is not handled yet : selectClause.typeDefinitionId = " + operand.typeDefinitionId.toString());
                warningLog(operand.toString());
                return new node_opcua_variant_1.Variant({ dataType: node_opcua_variant_1.DataType.NodeId, value: context.eventSource });
            }
        }
        const eventSourceTypeDefinition = context.getTypeDefinition(context.eventSource);
        if (!eventSourceTypeDefinition) {
            // eventSource is a EventType class
            return new node_opcua_variant_1.Variant();
        }
        if (!context.isSubtypeOf(eventSourceTypeDefinition, conditionTypeNodeId)) {
            return new node_opcua_variant_1.Variant();
        }
        // Yeh : our EventType is a Condition Type !
        return new node_opcua_variant_1.Variant({ dataType: node_opcua_variant_1.DataType.NodeId, value: context.eventSource });
    }
    return (0, resolve_operand_1.resolveOperand)(context, operand);
}
function extractEventFieldsBase(context, selectClauses) {
    (0, node_opcua_assert_1.assert)(Array.isArray(selectClauses));
    (0, node_opcua_assert_1.assert)(selectClauses.length === 0 || selectClauses[0] instanceof node_opcua_types_1.SimpleAttributeOperand);
    return selectClauses.map(extractEventField.bind(null, context));
}
//# sourceMappingURL=extract_event_field.js.map