"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkSelectClause = checkSelectClause;
exports.checkSelectClauses = checkSelectClauses;
/**
 * @module node-opcua-address-space
 */
const node_opcua_data_model_1 = require("node-opcua-data-model");
const node_opcua_service_translate_browse_path_1 = require("node-opcua-service-translate-browse-path");
const node_opcua_status_code_1 = require("node-opcua-status-code");
const node_opcua_debug_1 = require("node-opcua-debug");
const debugLog = (0, node_opcua_debug_1.make_debugLog)(__filename);
/**

 * @param parentNode
 * @param selectClause
 * @return {Array<StatusCode>}
 */
function checkSelectClause(parentNode, selectClause) {
    //
    const addressSpace = parentNode.addressSpace;
    // istanbul ignore next
    if (selectClause.typeDefinitionId.isEmpty()) {
        return node_opcua_status_code_1.StatusCodes.Good;
    }
    const eventTypeNode = addressSpace.findEventType(selectClause.typeDefinitionId);
    if (!eventTypeNode || !(eventTypeNode.nodeClass === node_opcua_data_model_1.NodeClass.ObjectType)) {
        // istanbul ignore next
        if (eventTypeNode) {
            debugLog(" checkSelectClause", eventTypeNode.toString());
        }
    }
    // istanbul ignore next
    if (eventTypeNode.nodeClass !== node_opcua_data_model_1.NodeClass.ObjectType) {
        return node_opcua_status_code_1.StatusCodes.BadTypeMismatch;
    }
    // navigate to the innerNode specified by the browsePath [ QualifiedName]
    const browsePath = (0, node_opcua_service_translate_browse_path_1.constructBrowsePathFromQualifiedName)(eventTypeNode, selectClause.browsePath);
    const browsePathResult = addressSpace.browsePath(browsePath);
    return browsePathResult.statusCode;
}
/**

 * @param eventTypeNode
 * @param selectClauses
 * @return an array of StatusCode
 */
function checkSelectClauses(eventTypeNode, selectClauses) {
    return selectClauses.map(checkSelectClause.bind(null, eventTypeNode));
}
//# sourceMappingURL=check_event_clause.js.map