"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.serviceToString = void 0;
exports.isSameService = isSameService;
function isSameService(a, b) {
    if (!a && !b) {
        return true;
    }
    if (!a || !b) {
        return false;
    }
    return a.port === b.port && a.txt?.path === b.txt?.path && a.name === b.name && a.txt?.caps === b.txt?.caps;
}
const serviceToString = (service) => {
    return ("\n   host" +
        service.host +
        "\n   type=" +
        service.type +
        service.name +
        "\n    on port " +
        service.port +
        "\n    txt " +
        JSON.stringify(service.txt) +
        "\n   ttl=" + service.ttl +
        "\n   ip=" + (service.ip));
};
exports.serviceToString = serviceToString;
//# sourceMappingURL=tools.js.map