"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UAUserManager1 = exports.UAUserManagerBase = void 0;
exports.makeUserManager = makeUserManager;
const util_1 = require("util");
const node_opcua_debug_1 = require("node-opcua-debug");
const errorLog = (0, node_opcua_debug_1.make_errorLog)(__filename);
class UAUserManagerBase {
    getUserRoles(user) {
        throw new Error("Method not implemented.");
    }
    isValidUser(session, username, password) {
        throw new Error("Method not implemented.");
    }
    getIdentitiesForRole(role) {
        return [];
    }
    bind(roleSet) {
        /**  */
    }
}
exports.UAUserManagerBase = UAUserManagerBase;
class UAUserManager1 extends UAUserManagerBase {
    options;
    constructor(options) {
        super();
        this.options = options;
    }
    getUserRoles(user) {
        if (!this.options.getUserRoles)
            return [];
        try {
            return this.options.getUserRoles(user);
        }
        catch (err) {
            if (util_1.types.isNativeError(err)) {
                errorLog("[NODE-OPCUA-E27] userManager provided getUserRoles method has thrown an exception, please fix your code! ");
                errorLog(err.message, "\n", err.stack?.split("\n").slice(0, 2).join("\n"));
            }
            return [];
        }
    }
    async isValidUser(session, username, password) {
        if (typeof this.options.isValidUserAsync === "function") {
            return new Promise((resolve, reject) => {
                this.options.isValidUserAsync?.call(session, username, password, (err, isAuthorized) => {
                    if (err)
                        return reject();
                    resolve(isAuthorized);
                });
            });
        }
        else if (typeof this.options.isValidUser === "function") {
            try {
                const authorized = this.options.isValidUser.call(session, username, password);
                return authorized;
            }
            catch (err) {
                if (util_1.types.isNativeError(err)) {
                    errorLog("[NODE-OPCUA-E26] userManager provided isValidUser method has thrown an exception, please fix your code!");
                    errorLog(err.message, "\n", err.stack?.split("\n").slice(0, 2).join("\n"));
                }
                return false;
            }
        }
        else {
            return false;
        }
    }
    getIdentitiesForRole(role) {
        return [];
    }
}
exports.UAUserManager1 = UAUserManager1;
function makeUserManager(options) {
    if (options instanceof UAUserManagerBase) {
        return options;
    }
    options = options || {};
    if (typeof options.isValidUser !== "function") {
        options.isValidUser = ( /*userName,password*/) => {
            return false;
        };
    }
    return new UAUserManager1(options);
}
//# sourceMappingURL=user_manager.js.map