"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sessionsCompatibleForTransfer = sessionsCompatibleForTransfer;
const node_opcua_assert_1 = require("node-opcua-assert");
const node_opcua_types_1 = require("node-opcua-types");
function sessionsCompatibleForTransfer(sessionSrc, sessionDest) {
    if (!sessionSrc) {
        return true;
    }
    (0, node_opcua_assert_1.assert)(sessionDest);
    (0, node_opcua_assert_1.assert)(sessionSrc);
    if (!sessionSrc.userIdentityToken && !sessionDest.userIdentityToken) {
        return true;
    }
    if (sessionSrc.userIdentityToken instanceof node_opcua_types_1.AnonymousIdentityToken) {
        if (!(sessionDest.userIdentityToken instanceof node_opcua_types_1.AnonymousIdentityToken)) {
            return false;
        }
        return true;
    }
    else if (sessionSrc.userIdentityToken instanceof node_opcua_types_1.UserNameIdentityToken) {
        if (!(sessionDest.userIdentityToken instanceof node_opcua_types_1.UserNameIdentityToken)) {
            return false;
        }
        return sessionSrc.userIdentityToken.userName === sessionDest.userIdentityToken.userName;
    }
    // istanbul ignore else
    else if (sessionSrc.userIdentityToken instanceof node_opcua_types_1.X509IdentityToken) {
        if (!(sessionDest.userIdentityToken instanceof node_opcua_types_1.X509IdentityToken)) {
            return false;
        }
        return (sessionSrc.userIdentityToken.certificateData.toString("hex") ===
            sessionDest.userIdentityToken.certificateData.toString("hex"));
    }
    else {
        throw new Error("Unsupported Identity token");
    }
}
//# sourceMappingURL=sessions_compatible_for_transfer.js.map