"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServerCapabilities = exports.defaultServerCapabilities = exports.ServerOperationLimits = void 0;
const node_opcua_binary_stream_1 = require("node-opcua-binary-stream");
const node_opcua_debug_1 = require("node-opcua-debug");
const warningLog = (0, node_opcua_debug_1.make_warningLog)(__filename);
class ServerOperationLimits {
    maxNodesPerRead;
    maxNodesPerBrowse;
    maxNodesPerWrite;
    maxNodesPerMethodCall;
    maxNodesPerRegisterNodes;
    maxNodesPerNodeManagement;
    maxMonitoredItemsPerCall;
    maxNodesPerHistoryReadData;
    maxNodesPerHistoryReadEvents;
    maxNodesPerHistoryUpdateData;
    maxNodesPerHistoryUpdateEvents;
    maxNodesPerTranslateBrowsePathsToNodeIds;
    constructor(options) {
        this.maxNodesPerRead = options.maxNodesPerRead || 0;
        this.maxNodesPerWrite = options.maxNodesPerWrite || 0;
        this.maxNodesPerMethodCall = options.maxNodesPerMethodCall || 0;
        this.maxNodesPerBrowse = options.maxNodesPerBrowse || 0;
        this.maxNodesPerRegisterNodes = options.maxNodesPerRegisterNodes || 0;
        this.maxNodesPerNodeManagement = options.maxNodesPerNodeManagement || 0;
        this.maxMonitoredItemsPerCall = options.maxMonitoredItemsPerCall || 0;
        this.maxNodesPerHistoryReadData = options.maxNodesPerHistoryReadData || 0;
        this.maxNodesPerHistoryReadEvents = options.maxNodesPerHistoryReadEvents || 0;
        this.maxNodesPerHistoryUpdateData = options.maxNodesPerHistoryUpdateData || 0;
        this.maxNodesPerHistoryUpdateEvents = options.maxNodesPerHistoryUpdateEvents || 0;
        this.maxNodesPerTranslateBrowsePathsToNodeIds = options.maxNodesPerTranslateBrowsePathsToNodeIds || 0;
    }
}
exports.ServerOperationLimits = ServerOperationLimits;
exports.defaultServerCapabilities = {
    maxBrowseContinuationPoints: 0,
    maxHistoryContinuationPoints: 0,
    maxStringLength: 16 * 1024 * 1024,
    maxArrayLength: 1024 * 1024,
    maxByteStringLength: 16 * 1024 * 1024,
    maxQueryContinuationPoints: 0,
    minSupportedSampleRate: 100,
    operationLimits: {
        maxNodesPerBrowse: 0,
        maxNodesPerHistoryReadData: 0,
        maxNodesPerHistoryReadEvents: 0,
        maxNodesPerHistoryUpdateData: 0,
        maxNodesPerHistoryUpdateEvents: 0,
        maxNodesPerMethodCall: 0,
        maxNodesPerNodeManagement: 0,
        maxNodesPerRead: 0,
        maxNodesPerRegisterNodes: 0,
        maxNodesPerWrite: 0,
        maxNodesPerTranslateBrowsePathsToNodeIds: 0,
        maxMonitoredItemsPerCall: 0
    },
    serverProfileArray: [],
    localeIdArray: [],
    softwareCertificates: [],
    maxSessions: 10,
    maxSubscriptions: 100,
    maxMonitoredItems: 1000000, // 1 million
    maxSubscriptionsPerSession: 10,
    maxMonitoredItemsPerSubscription: 100000, // one hundred thousand
    maxSelectClauseParameters: 100,
    maxWhereClauseParameters: 100,
    maxMonitoredItemsQueueSize: 60000,
    conformanceUnits: []
};
/**
 */
class ServerCapabilities {
    maxBrowseContinuationPoints;
    maxHistoryContinuationPoints;
    maxStringLength;
    maxArrayLength;
    maxByteStringLength;
    maxQueryContinuationPoints;
    minSupportedSampleRate;
    operationLimits;
    serverProfileArray;
    localeIdArray;
    softwareCertificates;
    // new in 1.05
    maxSessions;
    maxSubscriptions;
    maxMonitoredItems;
    maxSubscriptionsPerSession;
    maxMonitoredItemsPerSubscription;
    maxSelectClauseParameters;
    maxWhereClauseParameters;
    maxMonitoredItemsQueueSize;
    conformanceUnits;
    // eslint-disable-next-line complexity
    constructor(options) {
        options = options || {};
        options.operationLimits = options.operationLimits || {};
        this.serverProfileArray = options.serverProfileArray || [];
        this.localeIdArray = options.localeIdArray || [];
        this.softwareCertificates = options.softwareCertificates || [];
        this.maxArrayLength = options.maxArrayLength || exports.defaultServerCapabilities.maxArrayLength;
        this.maxStringLength = options.maxStringLength || exports.defaultServerCapabilities.maxStringLength;
        this.maxByteStringLength = options.maxByteStringLength || exports.defaultServerCapabilities.maxByteStringLength;
        if (node_opcua_binary_stream_1.BinaryStream.maxStringLength < this.maxStringLength) {
            warningLog(`ServerCapabilities.maxStringLength ${this.maxStringLength} is greater that the allowed limite BinaryStream.maxStringLength = ${node_opcua_binary_stream_1.BinaryStream.maxStringLength}\nPlease adjust the value.`);
        }
        if (node_opcua_binary_stream_1.BinaryStream.maxByteStringLength < this.maxByteStringLength) {
            warningLog(`ServerCapabilities.maxByteStringLength ${this.maxByteStringLength} is greater that the allowed limite BinaryStream.maxByteStringLength = ${node_opcua_binary_stream_1.BinaryStream.maxByteStringLength}\nPlease adjust the value.`);
        }
        this.maxBrowseContinuationPoints =
            options.maxBrowseContinuationPoints || exports.defaultServerCapabilities.maxBrowseContinuationPoints;
        this.maxQueryContinuationPoints =
            options.maxQueryContinuationPoints || exports.defaultServerCapabilities.maxQueryContinuationPoints;
        this.maxHistoryContinuationPoints =
            options.maxHistoryContinuationPoints || exports.defaultServerCapabilities.maxHistoryContinuationPoints;
        this.operationLimits = new ServerOperationLimits(options.operationLimits);
        this.minSupportedSampleRate = options.minSupportedSampleRate || exports.defaultServerCapabilities.minSupportedSampleRate; // to do adjust me
        // new in 1.05
        this.maxSessions = options.maxSessions || exports.defaultServerCapabilities.maxSessions;
        this.maxSubscriptionsPerSession =
            options.maxSubscriptionsPerSession || exports.defaultServerCapabilities.maxSubscriptionsPerSession;
        this.maxSubscriptions = options.maxSubscriptions || exports.defaultServerCapabilities.maxSubscriptions;
        this.maxMonitoredItems = options.maxMonitoredItems || exports.defaultServerCapabilities.maxMonitoredItems;
        this.maxMonitoredItemsPerSubscription =
            options.maxMonitoredItemsPerSubscription || exports.defaultServerCapabilities.maxMonitoredItemsPerSubscription;
        this.maxSelectClauseParameters = options.maxSelectClauseParameters || exports.defaultServerCapabilities.maxSelectClauseParameters;
        this.maxWhereClauseParameters = options.maxWhereClauseParameters || exports.defaultServerCapabilities.maxWhereClauseParameters;
        this.maxMonitoredItemsQueueSize =
            options.maxMonitoredItemsQueueSize || exports.defaultServerCapabilities.maxMonitoredItemsQueueSize;
        this.conformanceUnits = options.conformanceUnits || exports.defaultServerCapabilities.conformanceUnits;
    }
}
exports.ServerCapabilities = ServerCapabilities;
//# sourceMappingURL=server_capabilities.js.map