/**
 * @module node-opcua-server
 */
import { Double, UInt32 } from "node-opcua-basic-types";
import { QualifiedName } from "node-opcua-data-model";
import { SignedSoftwareCertificate } from "node-opcua-types";
/**
 */
export interface OperationLimitsOptions {
    maxNodesPerRead?: number;
    maxNodesPerBrowse?: number;
    maxNodesPerWrite?: number;
    maxNodesPerMethodCall?: number;
    maxNodesPerRegisterNodes?: number;
    maxNodesPerNodeManagement?: number;
    maxMonitoredItemsPerCall?: number;
    maxNodesPerHistoryReadData?: number;
    maxNodesPerHistoryReadEvents?: number;
    maxNodesPerHistoryUpdateData?: number;
    maxNodesPerHistoryUpdateEvents?: number;
    maxNodesPerTranslateBrowsePathsToNodeIds?: number;
}
export declare class ServerOperationLimits {
    maxNodesPerRead: number;
    maxNodesPerBrowse: number;
    maxNodesPerWrite: number;
    maxNodesPerMethodCall: number;
    maxNodesPerRegisterNodes: number;
    maxNodesPerNodeManagement: number;
    maxMonitoredItemsPerCall: number;
    maxNodesPerHistoryReadData: number;
    maxNodesPerHistoryReadEvents: number;
    maxNodesPerHistoryUpdateData: number;
    maxNodesPerHistoryUpdateEvents: number;
    maxNodesPerTranslateBrowsePathsToNodeIds: number;
    constructor(options: OperationLimitsOptions);
}
export interface IServerCapabilities {
    maxBrowseContinuationPoints: number;
    maxHistoryContinuationPoints: number;
    maxStringLength: number;
    maxArrayLength: number;
    maxByteStringLength: number;
    maxQueryContinuationPoints: number;
    minSupportedSampleRate: Double;
    operationLimits: OperationLimitsOptions;
    serverProfileArray: string[];
    localeIdArray: string[];
    softwareCertificates: SignedSoftwareCertificate[];
    /**
     * MaxSessions is an integer specifying the maximum number of concurrent
     * Sessions the Server can support. The value specifies the
     * maximum the Server can support under normal circumstances,
     * therefore there is no guarantee the Server can always support
     * the maximum.
     */
    maxSessions: UInt32;
    /**
     * MaxSubscriptions is an integer specifying the maximum number of
     * Subscriptions the Server can support. The value specifies the
     * maximum the Server can support under normal circumstances,
     * therefore there is no guarantee the Server can always support
     * the maximum.
     */
    maxSubscriptions: UInt32;
    /**
     * MaxMonitoredItems is an integer specifying the maximum number of
     * MonitoredItems the Server can support. The value specifies the
     * maximum the Server can support under normal circumstances,
     * therefore there is no guarantee the Server can always support
     * the maximum.
     */
    maxMonitoredItems: UInt32;
    /**
     * MaxSubscriptionsPerSession is an integer specifying the maximum number of
     * Subscriptions per Session the Server can support. The value specifies the
     * maximum the Server can support under normal circumstances,
     * therefore there is no guarantee the Server can always support
     * the maximum.
     */
    maxSubscriptionsPerSession: UInt32;
    /**
     * MaxMonitoredItemsPerSubscription is an integer specifying the maximum number of
     * MonitoredItems per Subscription the Server can support. The value specifies the
     * maximum the Server can support under normal circumstances,
     * therefore there is no guarantee the Server can always support
     * the maximum
     */
    maxMonitoredItemsPerSubscription: UInt32;
    /**
     * MaxSelectClauseParameters is an integer specifying the maximum number of
     * EventField SelectClause Parameters the Server can support for an EventFilter.
     * The value specifies the maximum the Server can support under normal circumstances,
     * therefore there is no guarantee the Server can always support
     * the maximum.
     */
    maxSelectClauseParameters: UInt32;
    /**
     * MaxWhereClauseParameters is an integer specifying the maximum number of
     * EventField WhereClause Parameters the Server can support for an EventFilter.
     * The value specifies the maximum the Server can support under normal circumstances,
     * therefore there is no guarantee the Server can always support the maximum
     */
    maxWhereClauseParameters: UInt32;
    /**
     * (draft)
     * MaxMonitoredItemsQueueSize is an integer specifying the maximum size of MonitoredItem
     * queues. The value specifies the maximum the Server can support under normal circumstances,
     * therefore there is no guarantee the Server can always support the maximum.
     *
     */
    maxMonitoredItemsQueueSize: UInt32;
    /**
     *
     * ConformanceUnits is a QualifiedName array specifying the set of conformance units
     * the Server supports. This list should be limited to the ConformanceUnits the Server
     * supports in its current configuration.
     *
     */
    conformanceUnits: QualifiedName[];
}
export type ServerCapabilitiesOptions = Partial<IServerCapabilities>;
export declare const defaultServerCapabilities: IServerCapabilities;
/**
 */
export declare class ServerCapabilities implements IServerCapabilities {
    maxBrowseContinuationPoints: number;
    maxHistoryContinuationPoints: number;
    maxStringLength: number;
    maxArrayLength: number;
    maxByteStringLength: number;
    maxQueryContinuationPoints: number;
    minSupportedSampleRate: number;
    operationLimits: ServerOperationLimits;
    serverProfileArray: string[];
    localeIdArray: string[];
    softwareCertificates: SignedSoftwareCertificate[];
    maxSessions: UInt32;
    maxSubscriptions: UInt32;
    maxMonitoredItems: UInt32;
    maxSubscriptionsPerSession: UInt32;
    maxMonitoredItemsPerSubscription: UInt32;
    maxSelectClauseParameters: UInt32;
    maxWhereClauseParameters: UInt32;
    maxMonitoredItemsQueueSize: UInt32;
    conformanceUnits: QualifiedName[];
    constructor(options: ServerCapabilitiesOptions);
}
