"use strict";
/**
 * @module node-opcua-server
 */
// RegisterServerManagerMDNSONLY
Object.defineProperty(exports, "__esModule", { value: true });
exports.RegisterServerManagerMDNSONLY = void 0;
const events_1 = require("events");
const node_opcua_assert_1 = require("node-opcua-assert");
const node_opcua_service_discovery_1 = require("node-opcua-service-discovery");
const base_server_1 = require("./base_server");
const i_register_server_manager_1 = require("./i_register_server_manager");
/**
 * a RegisterServerManager that declare the server the OPCUA Bonjour service
 * available on the current computer
 */
class RegisterServerManagerMDNSONLY extends events_1.EventEmitter {
    discoveryServerEndpointUrl = "";
    server;
    bonjour;
    _state = i_register_server_manager_1.RegisterServerManagerStatus.NOT_APPLICABLE;
    constructor(options) {
        super();
        this.server = options.server;
        (0, node_opcua_assert_1.assert)(this.server);
        (0, node_opcua_assert_1.assert)(this.server instanceof base_server_1.OPCUABaseServer);
        this.bonjour = new node_opcua_service_discovery_1.BonjourHolder();
        this._state = i_register_server_manager_1.RegisterServerManagerStatus.INITIALIZING;
    }
    async stop() {
        if (this.bonjour) {
            this._state = i_register_server_manager_1.RegisterServerManagerStatus.UNREGISTERING;
            await this.bonjour.stopAnnouncedOnMulticastSubnet();
            this.emit("serverUnregistered");
            this._state = i_register_server_manager_1.RegisterServerManagerStatus.INACTIVE;
        }
    }
    async start() {
        // istanbul ignore next
        if (!this.server) {
            throw new Error("internal error");
        }
        (0, node_opcua_assert_1.assert)(this.server instanceof base_server_1.OPCUABaseServer);
        const host = "TODO-find how to extract hostname";
        const capabilities = this.server.capabilitiesForMDNS;
        const name = this.server.serverInfo.applicationUri;
        const port = this.server.endpoints[0].port;
        this._state = i_register_server_manager_1.RegisterServerManagerStatus.REGISTERING;
        await this.bonjour.announcedOnMulticastSubnet({
            capabilities: capabilities,
            name: name,
            path: "/", // <- to do
            host,
            port: port
        });
        this._state = i_register_server_manager_1.RegisterServerManagerStatus.WAITING;
        this.emit("serverRegistered");
    }
    dispose() {
        (0, node_opcua_assert_1.assert)(!this.bonjour.isStarted());
        (0, node_opcua_assert_1.assert)(this.server);
        this.server = undefined;
    }
    getState() {
        return this._state;
    }
}
exports.RegisterServerManagerMDNSONLY = RegisterServerManagerMDNSONLY;
//# sourceMappingURL=register_server_manager_mdns_only.js.map