"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.installSessionLogging = installSessionLogging;
exports.installSubscriptionMonitoring = installSubscriptionMonitoring;
exports.installSessionLoggingOnEngine = installSessionLoggingOnEngine;
const util_1 = __importDefault(require("util"));
const server_subscription_1 = require("./server_subscription");
const consolelog = (...args) => {
    const d = new Date();
    const t = d.toTimeString().split(" ")[0] + "." + d.getMilliseconds().toString().padStart(3, "0");
    console.log.apply(console, [t, ...args]);
};
const doDebug = false;
/**
 *
 * @private
 */
function installSessionLogging(server) {
    installSessionLoggingOnEngine(server.engine);
}
const info = (subscription) => {
    return util_1.default.format(subscription.subscriptionId, server_subscription_1.SubscriptionState[subscription.state].padEnd(9), subscription.state, "kac=", subscription.currentKeepAliveCount.toString().padStart(3) +
        "/" +
        subscription.maxKeepAliveCount.toString().padStart(3), "ltc=", subscription.currentLifetimeCount.toString().padStart(3) +
        "/" +
        subscription.lifeTimeCount.toString().padStart(3), "prc=", subscription.publishEngine?.pendingPublishRequestCount.toString().padStart(3), "pi=", subscription.publishingInterval);
};
function installSubscriptionMonitoring(subscription) {
    consolelog("new_subscription", subscription.subscriptionId, info(subscription));
    subscription.on("lifeTimeExpired", () => {
        consolelog("lifeTimeExpired".padEnd(45), info(subscription));
    });
    if (true || doDebug) {
        subscription.on("lifeTimeCounterChanged", (ltc) => {
            consolelog("subscription lifeTimeCounterChanged".padEnd(45), info(subscription));
        });
    }
    subscription.on("expired", () => {
        consolelog("subscription expired".padEnd(45), info(subscription));
    });
    subscription.on("stateChanged", (state) => {
        consolelog("subscription stateChanged".padEnd(45), info(subscription));
    });
    subscription.on("terminate", () => {
        consolelog("subscription terminated".padEnd(45), info(subscription));
    });
    subscription.on("keepalive", () => {
        consolelog("subscription keepalive".padEnd(45), info(subscription));
    });
}
function installSessionLoggingOnEngine(serverEngine) {
    function on_create_session(session) {
        try {
            session.on("activate_session", function () {
                consolelog("activate_session");
            });
            session.on("statusChanged", (status) => {
                consolelog("session status changed: ", status);
            });
            session.on("new_subscription", function (subscription) {
                installSubscriptionMonitoring(subscription);
            });
        }
        catch (err) {
            consolelog(err.message);
        }
    }
    serverEngine.on("create_session", on_create_session);
    serverEngine.once("session_closed", function (session) {
        consolelog("session is closed");
        serverEngine.removeListener("create_session", on_create_session);
    });
}
//# sourceMappingURL=helper.js.map