"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.verify_multi_chunk_message = verify_multi_chunk_message;
exports.verify_single_chunk_message = verify_single_chunk_message;
// tslint:disable:no-console
const node_opcua_packet_analyzer_1 = require("node-opcua-packet-analyzer");
const index_1 = require("../source/index");
const token_stack_1 = require("../source/token_stack");
/**
 *
 * @param packets
 */
function verify_multi_chunk_message(packets) {
    const maxChunkSize = packets.map((p) => p.length).reduce((a, b) => Math.max(a, b), 0);
    const tokenStack = new token_stack_1.TokenStack(1);
    const messageBuilder = new index_1.MessageBuilder(tokenStack.clientKeyProvider(), {
        maxChunkCount: packets.length + 1,
        maxMessageSize: 1000000,
        maxChunkSize,
        name: "Verification",
    });
    messageBuilder.setSecurity(index_1.MessageSecurityMode.None, index_1.SecurityPolicy.None);
    messageBuilder.on("full_message_body", (fullMessageBody) => {
        console.log("full_message_body received:");
        (0, node_opcua_packet_analyzer_1.analyseExtensionObject)(fullMessageBody, 0, 0);
    });
    messageBuilder.on("startChunk", (info) => {
        console.log(" starting new chunk ", info.messageHeader);
    });
    messageBuilder.on("chunk", (messageChunk) => {
        console.log((0, index_1.messageHeaderToString)(messageChunk));
    });
    messageBuilder.on("error", (err) => {
        console.log("verify_multi_chunk_message : err", err.message);
    });
    let totalLength = 0;
    packets.forEach((packet) => {
        if (packet instanceof Array) {
            packet = Buffer.from(packet);
        }
        totalLength += packet.length;
        // console.log(sprintf(" adding packet size : %5d l=%d", packet.length, totalLength));
        messageBuilder.feed(packet);
    });
}
function verify_single_chunk_message(packet) {
    verify_multi_chunk_message([packet]);
}
//# sourceMappingURL=verify_message_chunk.js.map