"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.serverCapabilitiesIds = void 0;
exports.readOperationLimits = readOperationLimits;
exports.readServerCapabilities = readServerCapabilities;
/**
 * @module node-opcua-pseudo-session
 */
const node_opcua_nodeid_1 = require("node-opcua-nodeid");
const node_opcua_constants_1 = require("node-opcua-constants");
const node_opcua_service_read_1 = require("node-opcua-service-read");
const node_opcua_debug_1 = require("node-opcua-debug");
const warningLog = (0, node_opcua_debug_1.make_warningLog)(__filename);
async function _readMany(session, ids) {
    const entries = Object.entries(ids);
    const nodesToRead = entries.map(([key, value]) => ({ nodeId: (0, node_opcua_nodeid_1.resolveNodeId)(value), attributeId: node_opcua_service_read_1.AttributeIds.Value }));
    const dataValues = await session.read(nodesToRead);
    const results = {};
    entries.forEach(([key], index) => {
        const dataValue = dataValues[index];
        if (dataValue.statusCode.value === 0x00) {
            results[key] = dataValue.value.value;
        }
        else {
            warningLog("dataValue = ", dataValue.toString(), " for ", nodesToRead[index].nodeId.toString());
        }
    });
    return results;
}
async function readOperationLimits(session) {
    const ids = {
        maxNodesPerRead: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_OperationLimits_MaxNodesPerRead,
        maxNodesPerBrowse: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_OperationLimits_MaxNodesPerBrowse,
        maxNodesPerWrite: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_OperationLimits_MaxNodesPerWrite,
        maxNodesPerMethodCall: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_OperationLimits_MaxNodesPerMethodCall,
        maxNodesPerRegisterNodes: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_OperationLimits_MaxNodesPerRegisterNodes,
        maxNodesPerNodeManagement: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_OperationLimits_MaxNodesPerNodeManagement,
        maxMonitoredItemsPerCall: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_OperationLimits_MaxMonitoredItemsPerCall,
        maxNodesPerHistoryReadData: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadData,
        maxNodesPerHistoryReadEvents: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadEvents,
        maxNodesPerHistoryUpdateData: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateData,
        maxNodesPerHistoryUpdateEvents: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateEvents,
        maxNodesPerTranslateBrowsePathsToNodeIds: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds,
    };
    return await _readMany(session, ids);
}
exports.serverCapabilitiesIds = [
    node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxArrayLength,
    node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxStringLength,
    node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxByteStringLength,
    node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MinSupportedSampleRate,
    node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxBrowseContinuationPoints,
    node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxQueryContinuationPoints,
    node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxHistoryContinuationPoints,
    // new in 1.05
    node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxSessions,
    node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxSubscriptions,
    node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxMonitoredItems,
    node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxSubscriptionsPerSession,
    node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxSelectClauseParameters,
    node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxWhereClauseParameters,
    node_opcua_constants_1.VariableIds.Server_ServerCapabilities_ConformanceUnits,
    node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxMonitoredItemsPerSubscription,
    node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxMonitoredItemsQueueSize
];
async function readServerCapabilities(session) {
    const ids = {
        maxBrowseContinuationPoints: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxBrowseContinuationPoints,
        maxHistoryContinuationPoints: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxHistoryContinuationPoints,
        maxStringLength: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxStringLength,
        maxArrayLength: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxArrayLength,
        maxByteStringLength: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxByteStringLength,
        maxQueryContinuationPoints: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxQueryContinuationPoints,
        minSupportedSampleRate: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MinSupportedSampleRate,
        // operationLimits: OperationLimits;
        serverProfileArray: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_ServerProfileArray,
        localeIdArray: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_LocaleIdArray,
        softwareCertificates: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_SoftwareCertificates,
        maxSessions: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxSessions,
        maxSubscriptions: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxSubscriptions,
        maxMonitoredItems: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxMonitoredItems,
        maxSubscriptionsPerSession: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxSubscriptionsPerSession,
        maxMonitoredItemsPerSubscription: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxMonitoredItemsPerSubscription,
        maxSelectClauseParameters: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxSelectClauseParameters,
        maxWhereClauseParameters: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxWhereClauseParameters,
        maxMonitoredItemsQueueSize: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_MaxMonitoredItemsQueueSize,
        conformanceUnits: node_opcua_constants_1.VariableIds.Server_ServerCapabilities_ConformanceUnits,
        operationLimits: 0
    };
    const serverCapabilities = await _readMany(session, ids);
    const limits = await readOperationLimits(session);
    serverCapabilities.operationLimits = limits;
    return serverCapabilities;
}
//# sourceMappingURL=read_operational_limits.js.map