import { VariableIds } from "node-opcua-constants";
import { IBasicSessionReadAsyncMultiple } from "./basic_session_interface";
import { SignedSoftwareCertificate } from "node-opcua-types";
import { QualifiedName } from "node-opcua-data-model";
import { UInt32 } from "node-opcua-basic-types";
export interface IOperationLimits2 {
    maxNodesPerRead?: number;
    maxNodesPerBrowse?: number;
    maxNodesPerWrite?: number;
    maxNodesPerMethodCall?: number;
    maxNodesPerRegisterNodes?: number;
    maxNodesPerNodeManagement?: number;
    maxMonitoredItemsPerCall?: number;
    maxNodesPerHistoryReadData?: number;
    maxNodesPerHistoryReadEvents?: number;
    maxNodesPerHistoryUpdateData?: number;
    maxNodesPerHistoryUpdateEvents?: number;
    maxNodesPerTranslateBrowsePathsToNodeIds?: number;
}
export interface IServerCapabilities2 {
    maxBrowseContinuationPoints: number;
    maxHistoryContinuationPoints: number;
    maxStringLength: number;
    maxArrayLength: number;
    maxByteStringLength: number;
    maxQueryContinuationPoints: number;
    minSupportedSampleRate: number;
    operationLimits: IOperationLimits2;
    serverProfileArray: string[];
    localeIdArray: string[];
    softwareCertificates: SignedSoftwareCertificate[];
    maxSessions: UInt32;
    maxSubscriptions: UInt32;
    maxMonitoredItems: UInt32;
    maxSubscriptionsPerSession: UInt32;
    maxMonitoredItemsPerSubscription: UInt32;
    maxSelectClauseParameters: UInt32;
    maxWhereClauseParameters: UInt32;
    maxMonitoredItemsQueueSize: UInt32;
    conformanceUnits: QualifiedName[];
}
export declare function readOperationLimits(session: IBasicSessionReadAsyncMultiple): Promise<IOperationLimits2>;
export declare const serverCapabilitiesIds: VariableIds[];
export declare function readServerCapabilities(session: IBasicSessionReadAsyncMultiple): Promise<IServerCapabilities2>;
