"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.readAllAttributes = readAllAttributes;
const node_opcua_nodeid_1 = require("node-opcua-nodeid");
const node_opcua_assert_1 = __importDefault(require("node-opcua-assert"));
const node_opcua_status_code_1 = require("node-opcua-status-code");
const node_opcua_basic_types_1 = require("node-opcua-basic-types");
const node_opcua_utils_1 = require("node-opcua-utils");
const keys = Object.keys(node_opcua_basic_types_1.AttributeIds).filter((k) => node_opcua_basic_types_1.AttributeIds[k] !== node_opcua_basic_types_1.AttributeIds.INVALID);
const attributeNames = (() => {
    const r = [];
    for (let i = 1; i <= 22; i++) {
        r.push(node_opcua_basic_types_1.attributeNameById[i].toString());
    }
    return r;
})();
function composeResult(nodes, nodesToRead, dataValues) {
    (0, node_opcua_assert_1.default)(nodesToRead.length === dataValues.length);
    let c = 0;
    const results = [];
    let dataValue;
    let k;
    let nodeToRead;
    for (const node of nodes) {
        const data = {
            nodeId: (0, node_opcua_nodeid_1.resolveNodeId)(node),
            statusCode: node_opcua_status_code_1.StatusCodes.BadNodeIdUnknown
        };
        let addedProperty = 0;
        for (const key of attributeNames) {
            dataValue = dataValues[c];
            nodeToRead = nodesToRead[c];
            c++;
            if (dataValue.statusCode.equals(node_opcua_status_code_1.StatusCodes.Good)) {
                k = (0, node_opcua_utils_1.lowerFirstLetter)(key);
                data[k] = dataValue.value ? dataValue.value.value : null;
                addedProperty += 1;
            }
        }
        /* istanbul ignore if */
        if (addedProperty > 0) {
            data.statusCode = node_opcua_status_code_1.StatusCodes.Good;
        }
        else {
            data.statusCode = node_opcua_status_code_1.StatusCodes.BadNodeIdUnknown;
        }
        results.push(data);
    }
    return results;
}
async function readAllAttributes(session, arg1) {
    const isArray = Array.isArray(arg1);
    const nodes = isArray ? arg1 : [arg1];
    if (!isArray) {
        return (await readAllAttributes(session, nodes))[0];
    }
    const nodesToRead = [];
    for (const node of nodes) {
        const nodeId = (0, node_opcua_nodeid_1.resolveNodeId)(node);
        /* istanbul ignore next */
        if (!nodeId) {
            throw new Error("cannot coerce " + node + " to a valid NodeId");
        }
        for (let attributeId = 1; attributeId <= 22; attributeId++) {
            nodesToRead.push({
                attributeId,
                dataEncoding: undefined,
                indexRange: undefined,
                nodeId
            });
        }
    }
    const dataValues = await session.read(nodesToRead);
    const results = composeResult(nodes, nodesToRead, dataValues);
    return results;
}
//# sourceMappingURL=read_all_attributes.js.map