"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getChildByBrowseName = getChildByBrowseName;
const node_opcua_data_model_1 = require("node-opcua-data-model");
const node_opcua_debug_1 = require("node-opcua-debug");
const node_opcua_nodeid_1 = require("node-opcua-nodeid");
const warningLog = (0, node_opcua_debug_1.make_warningLog)(__dirname);
async function getChildByBrowseName(session, nodeId, name) {
    const browseResult = await session.browse({
        browseDirection: node_opcua_data_model_1.BrowseDirection.Forward,
        includeSubtypes: true,
        nodeId,
        referenceTypeId: (0, node_opcua_nodeid_1.resolveNodeId)("HierarchicalReferences"),
        nodeClassMask: 0,
        resultMask: 0x3f
    });
    if (!browseResult.references || browseResult.statusCode.isNotGood()) {
        throw new Error("Cannot browse node " + name + " " + browseResult.statusCode.toString() + " nodeId = " + nodeId.toString());
    }
    const selectedReference = browseResult.references.find((r) => r.browseName.name?.match(name) || r.displayName.text.match(name));
    if (!selectedReference) {
        warningLog("getChildByBrowseName error", browseResult.toString());
        throw new Error("Cannot find node " + name + " from " + nodeId.toString());
    }
    return selectedReference;
}
//# sourceMappingURL=get_child_by_browse_name.js.map