"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getBuiltInDataType = getBuiltInDataType;
const node_opcua_data_model_1 = require("node-opcua-data-model");
const node_opcua_status_code_1 = require("node-opcua-status-code");
const find_basic_datatype_1 = require("./find_basic_datatype");
async function getBuiltInDataType(session, variableNodeId) {
    let dataTypeId = null;
    const nodeToRead = {
        attributeId: node_opcua_data_model_1.AttributeIds.DataType,
        nodeId: variableNodeId
    };
    const dataValue = await session.read(nodeToRead);
    /* istanbul ignore next */
    if (dataValue.statusCode.isNot(node_opcua_status_code_1.StatusCodes.Good)) {
        throw new Error("cannot read DataType Attribute " + dataValue.statusCode.toString() + " for nodeId " + variableNodeId.toString());
    }
    dataTypeId = dataValue.value.value;
    return await (0, find_basic_datatype_1.findBasicDataType)(session, dataTypeId);
}
//# sourceMappingURL=get_builtin_datatype.js.map