"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findStructureDataType = findStructureDataType;
const node_opcua_constants_1 = require("node-opcua-constants");
const node_opcua_data_model_1 = require("node-opcua-data-model");
const node_opcua_nodeid_1 = require("node-opcua-nodeid");
async function findStructureDataType(session, dataTypeName, namespaceIndex) {
    let results = await session.browse({
        browseDirection: node_opcua_data_model_1.BrowseDirection.Forward,
        includeSubtypes: true,
        nodeClassMask: node_opcua_data_model_1.NodeClassMask.DataType,
        referenceTypeId: "HasSubtype",
        resultMask: 0xff,
        nodeId: (0, node_opcua_nodeid_1.coerceNodeId)(node_opcua_constants_1.DataTypeIds.Structure)
    });
    if (results.statusCode.isNotGood() || !results.references) {
        return null;
    }
    const ref = results.references.find((r) => r.browseName.name === dataTypeName && r.browseName.namespaceIndex === namespaceIndex);
    if (ref) {
        return ref.nodeId;
    }
    while (results.continuationPoint) {
        results = await session.browseNext(results.continuationPoint, false);
        if (results.statusCode.isNotGood() || !results.references) {
            return null;
        }
        const ref = results.references.find((r) => r.browseName.name === dataTypeName && r.browseName.namespaceIndex === namespaceIndex);
        if (ref) {
            if (results.continuationPoint) {
                await session.browseNext(results.continuationPoint, true);
            }
            return ref.nodeId;
        }
    }
    return null;
}
//# sourceMappingURL=find_structure_datatype.js.map