"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const config = "##################################################################################################\n" +
    "## SIMPLE OPENSSL CONFIG FILE FOR SELF-SIGNED CERTIFICATE GENERATION\n" +
    "################################################################################################################\n" +
    "\n" +
    "distinguished_name       = req_distinguished_name\n" +
    "default_md               = sha1\n" +
    "\n" +
    "default_md                = sha256                      # The default digest algorithm\n" +
    "\n" +
    "[ v3_ca ]\n" +
    "subjectKeyIdentifier        = hash\n" +
    "authorityKeyIdentifier      = keyid:always,issuer:always\n" +
    "\n" +
    "# authorityKeyIdentifier    = keyid\n" +
    "basicConstraints            = CA:TRUE\n" +
    "keyUsage                    = critical, cRLSign, keyCertSign\n" +
    'nsComment                   = "Self-signed Certificate for CA generated by Node-OPCUA Certificate utility"\n' +
    "#nsCertType                 = sslCA, emailCA\n" +
    "#subjectAltName             = email:copy\n" +
    "#issuerAltName              = issuer:copy\n" +
    "#obj                        = DER:02:03\n" +
    "# crlDistributionPoints       = @crl_info\n" +
    "# [ crl_info ]\n" +
    "# URI.0                     = http://localhost:8900/crl.pem\n" +
    "subjectAltName              = $ENV::ALTNAME\n" +
    "\n" +
    "[ req ]\n" +
    "days                      = 390\n" +
    "req_extensions            = v3_req\n" +
    "x509_extensions           = v3_ca\n" +
    "\n" +
    "[v3_req]\n" +
    "basicConstraints       = CA:false\n" +
    "keyUsage               = critical, cRLSign, keyCertSign\n" +
    "subjectAltName         = $ENV::ALTNAME\n" +
    "\n" +
    "[ v3_ca_signed]\n" +
    "subjectKeyIdentifier      = hash\n" +
    "authorityKeyIdentifier    = keyid,issuer\n" +
    "basicConstraints          = critical, CA:FALSE\n" +
    "keyUsage                  = nonRepudiation, digitalSignature, keyEncipherment, dataEncipherment, keyCertSign\n" +
    "extendedKeyUsage          = clientAuth,serverAuth \n" +
    'nsComment                 = "certificate generated by Node-OPCUA Certificate utility and signed by a CA"\n' +
    "subjectAltName            = $ENV::ALTNAME\n" +
    "[ v3_selfsigned]\n" +
    "subjectKeyIdentifier      = hash\n" +
    "authorityKeyIdentifier    = keyid,issuer\n" +
    "basicConstraints          = critical, CA:FALSE\n" +
    "keyUsage                  = nonRepudiation, digitalSignature, keyEncipherment, dataEncipherment, keyCertSign\n" +
    "extendedKeyUsage          = clientAuth,serverAuth \n" +
    'nsComment                 = "Self-signed certificate generated by Node-OPCUA Certificate utility"\n' +
    "subjectAltName            = $ENV::ALTNAME\n" +
    "[ req_distinguished_name ]\n" +
    "countryName             = Country Name (2 letter code)\n" +
    "countryName_default     = FR\n" +
    "countryName_min         = 2\n" +
    "countryName_max         = 2\n" +
    "# stateOrProvinceName     = State or Province Name (full name)\n" +
    "# stateOrProvinceName_default = Ile de France\n" +
    "# localityName            = Locality Name (city, district)\n" +
    "# localityName_default    = Paris\n" +
    "organizationName          = Organization Name (company)\n" +
    "organizationName_default  = NodeOPCUA\n" +
    "# organizationalUnitName  = Organizational Unit Name (department, division)\n" +
    "# organizationalUnitName_default = R&D\n" +
    "commonName                = Common Name (hostname, FQDN, IP, or your name)\n" +
    "commonName_max            = 256\n" +
    "commonName_default        = NodeOPCUA\n" +
    "# emailAddress            = Email Address\n" +
    "# emailAddress_max        = 40\n" +
    "# emailAddress_default    = node-opcua (at) node-opcua (dot) com\n" +
    "subjectAltName            = $ENV::ALTNAME";
exports.default = config;
//# sourceMappingURL=simple_config_template.cnf.js.map