import { UAProperty } from "node-opcua-address-space-base";
import { DataType } from "node-opcua-variant";
import { NodeId } from "node-opcua-nodeid";
import { UASystemOffNormalAlarm, UASystemOffNormalAlarm_Base } from "./ua_system_off_normal_alarm";
/**
 * |                |                                                            |
 * |----------------|------------------------------------------------------------|
 * |namespace       |http://opcfoundation.org/UA/                                |
 * |nodeClass       |ObjectType                                                  |
 * |typedDefinition |TrustListOutOfDateAlarmType i=19297                         |
 * |isAbstract      |false                                                       |
 */
export interface UATrustListOutOfDateAlarm_Base extends UASystemOffNormalAlarm_Base {
    trustListId: UAProperty<NodeId, DataType.NodeId>;
    lastUpdateTime: UAProperty<Date, DataType.DateTime>;
    updateFrequency: UAProperty<number, DataType.Double>;
}
export interface UATrustListOutOfDateAlarm extends UASystemOffNormalAlarm, UATrustListOutOfDateAlarm_Base {
}
