import { DataType } from "node-opcua-variant";
import { UInt64, UAString } from "node-opcua-basic-types";
import { EnumInterfaceAdminStatus } from "./enum_interface_admin_status";
import { EnumInterfaceOperStatus } from "./enum_interface_oper_status";
import { UABaseInterface, UABaseInterface_Base } from "./ua_base_interface";
import { UABaseDataVariable } from "./ua_base_data_variable";
import { UAAnalogUnit } from "./ua_analog_unit";
/**
 * |                |                                                            |
 * |----------------|------------------------------------------------------------|
 * |namespace       |http://opcfoundation.org/UA/                                |
 * |nodeClass       |ObjectType                                                  |
 * |typedDefinition |IIetfBaseNetworkInterfaceType i=24148                       |
 * |isAbstract      |true                                                        |
 */
export interface UAIIetfBaseNetworkInterface_Base extends UABaseInterface_Base {
    adminStatus: UABaseDataVariable<EnumInterfaceAdminStatus, DataType.Int32>;
    operStatus: UABaseDataVariable<EnumInterfaceOperStatus, DataType.Int32>;
    physAddress?: UABaseDataVariable<UAString, DataType.String>;
    speed: UAAnalogUnit<UInt64, DataType.UInt64>;
}
export interface UAIIetfBaseNetworkInterface extends UABaseInterface, UAIIetfBaseNetworkInterface_Base {
}
