import { UAProperty } from "node-opcua-address-space-base";
import { DataType } from "node-opcua-variant";
import { NodeId } from "node-opcua-nodeid";
import { UAAlarmCondition, UAAlarmCondition_Base } from "./ua_alarm_condition";
/**
 * |                |                                                            |
 * |----------------|------------------------------------------------------------|
 * |namespace       |http://opcfoundation.org/UA/                                |
 * |nodeClass       |ObjectType                                                  |
 * |typedDefinition |DiscrepancyAlarmType i=17080                                |
 * |isAbstract      |false                                                       |
 */
export interface UADiscrepancyAlarm_Base extends UAAlarmCondition_Base {
    targetValueNode: UAProperty<NodeId, DataType.NodeId>;
    expectedTime: UAProperty<number, DataType.Double>;
    tolerance?: UAProperty<number, DataType.Double>;
}
export interface UADiscrepancyAlarm extends UAAlarmCondition, UADiscrepancyAlarm_Base {
}
